/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_cad.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2007/11/08
 * ====================================================================
 */
#ifndef __LIST_CAD_H__
#define __LIST_CAD_H__

//#include <>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "types.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */



/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef    _LIST_CAD_
#define   GLOBAL
// 初期値設定
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// 初期値設定の代入部分を無くす
#define   GLOBAL_VAL(v)  /* */
#endif


	GLOBAL CAD_LIST *p_cad_list;
	GLOBAL CAD_LIST_INFO cad_list_info;

	GLOBAL CAD_LIST *StartData GLOBAL_VAL(0);


#undef  GLOBAL
#undef  GLOBAL_VAL
#undef  _LIST_CAD_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */
int init_cad(CAD *cad);
CAD_LIST *r_cad_list_add_first(CAD *add_cad, CAD_LIST_INFO *p_cad_list_info);
/* CAD Data をリストの最初に追加 */
CAD_LIST *cad_list_add_first(CAD *add_cad, CAD_LIST_INFO *p_cad_list_info);
/* CAD Data をリストの最初に追加して、 Undo Baffer に書込む */
CAD_LIST *cad_list_add_first_with_undo(CAD *add_cad, CAD_LIST_INFO *p_cad_list_info);

/* CAD Data をリストの最後に追加 */
CAD_LIST *cad_list_add_last(CAD *add_cad, CAD_LIST_INFO *p_cad_list_info);
/* CAD Data をリストの最後に追加、 Undo Baffer に書込む */
CAD_LIST *cad_list_add_last_with_undo(CAD *add_cad, CAD_LIST_INFO *p_cad_list_info);

/* CAD Data の削除機能 (メモリの削除ではない) */
int cad_list_delete(CAD_LIST *del_List, CAD_LIST_INFO *p_cad_list_info);
/* CAD Data の削除機能 (メモリの削除ではなく、Undo Buffer へ移す) */
int cad_list_delete_Undo(CAD_LIST *del_List, CAD_LIST_INFO *p_cad_list_info);

/* CAD Data を変更する */
CAD_LIST *cad_list_edit(CAD_LIST *point, CAD *change_cad, CAD_LIST_INFO *p_cad_list_info);
/* CAD Data を変更する、 Undo Baffer に書込む */
CAD_LIST *cad_list_edit_with_undo(CAD_LIST *point, CAD *change_cad, CAD_LIST_INFO *p_cad_list_info);

/* リストの総数を調べる */
long cad_list_num(CAD_LIST_INFO *p_cad_list_info);
/* n 番目のデータの検索 */
CAD_LIST *cad_search_num(long search_number, CAD_LIST_INFO *p_cad_list_info);
/* データの検索(CAD *p_cad から CAD_LIST を求める) */
CAD_LIST *cad_search_cad(CAD *p_cad, CAD_LIST_INFO *p_cad_list_info);
/* データの検索(CAD *p_cad から Data No. の long 値を求める) */
long cad_search_cad_to_num(CAD *p_cad, CAD_LIST_INFO *p_cad_list_info);


/* CAD Data をリストから削除 */
int cad_list_free(CAD_LIST *del_List, CAD_LIST_INFO *p_cad_list_info);
/* 全リストを削除 */
void cad_list_all_free(CAD_LIST_INFO *p_cad_list_info);

/* CAD リストを表示 */
void cad_list_print(CAD_LIST_INFO *p_cad_list_info);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __LIST_CAD_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_cad.h
 * ====================================================================
 */
