/* Generated by wayland-scanner 1.11.0 */

#ifndef STYLUS_UNSTABLE_V2_CLIENT_PROTOCOL_H
#define STYLUS_UNSTABLE_V2_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_stylus_unstable_v2 The stylus_unstable_v2 protocol
 * @section page_ifaces_stylus_unstable_v2 Interfaces
 * - @subpage page_iface_zcr_stylus_v2 - extends wl_touch with events for on-screen stylus
 * - @subpage page_iface_zcr_touch_stylus_v2 - stylus extension for touch
 * @section page_copyright_stylus_unstable_v2 Copyright
 * <pre>
 *
 * Copyright 2016 The Chromium Authors.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_touch;
struct zcr_stylus_v2;
struct zcr_touch_stylus_v2;

/**
 * @page page_iface_zcr_stylus_v2 zcr_stylus_v2
 * @section page_iface_zcr_stylus_v2_desc Description
 *
 * Allows a wl_touch to report stylus specific information. The client can
 * interpret the on-screen stylus like any other touch event, and use
 * this protocol to obtain detail information about the type of stylus,
 * as well as the force and tilt of the tool.
 *
 * These events are to be fired by the server within the same frame as other
 * wl_touch events.
 *
 * Warning! The protocol described in this file is experimental and
 * backward incompatible changes may be made. Backward compatible changes
 * may be added together with the corresponding uinterface version bump.
 * Backward incompatible changes are done by bumping the version number in
 * the protocol and uinterface names and resetting the interface version.
 * Once the protocol is to be declared stable, the 'z' prefix and the
 * version number in the protocol and interface names are removed and the
 * interface version number is reset.
 * @section page_iface_zcr_stylus_v2_api API
 * See @ref iface_zcr_stylus_v2.
 */
/**
 * @defgroup iface_zcr_stylus_v2 The zcr_stylus_v2 interface
 *
 * Allows a wl_touch to report stylus specific information. The client can
 * interpret the on-screen stylus like any other touch event, and use
 * this protocol to obtain detail information about the type of stylus,
 * as well as the force and tilt of the tool.
 *
 * These events are to be fired by the server within the same frame as other
 * wl_touch events.
 *
 * Warning! The protocol described in this file is experimental and
 * backward incompatible changes may be made. Backward compatible changes
 * may be added together with the corresponding uinterface version bump.
 * Backward incompatible changes are done by bumping the version number in
 * the protocol and uinterface names and resetting the interface version.
 * Once the protocol is to be declared stable, the 'z' prefix and the
 * version number in the protocol and interface names are removed and the
 * interface version number is reset.
 */
extern const struct wl_interface zcr_stylus_v2_interface;
/**
 * @page page_iface_zcr_touch_stylus_v2 zcr_touch_stylus_v2
 * @section page_iface_zcr_touch_stylus_v2_desc Description
 *
 * The zcr_touch_stylus_v1 interface extends the wl_touch interface with
 * events to describe details about a stylus.
 * @section page_iface_zcr_touch_stylus_v2_api API
 * See @ref iface_zcr_touch_stylus_v2.
 */
/**
 * @defgroup iface_zcr_touch_stylus_v2 The zcr_touch_stylus_v2 interface
 *
 * The zcr_touch_stylus_v1 interface extends the wl_touch interface with
 * events to describe details about a stylus.
 */
extern const struct wl_interface zcr_touch_stylus_v2_interface;

#ifndef ZCR_STYLUS_V2_ERROR_ENUM
#define ZCR_STYLUS_V2_ERROR_ENUM
enum zcr_stylus_v2_error {
	/**
	 * the touch already has a touch_stylus object associated
	 */
	ZCR_STYLUS_V2_ERROR_TOUCH_STYLUS_EXISTS = 0,
};
#endif /* ZCR_STYLUS_V2_ERROR_ENUM */

#define ZCR_STYLUS_V2_GET_TOUCH_STYLUS	0

/**
 * @ingroup iface_zcr_stylus_v2
 */
#define ZCR_STYLUS_V2_GET_TOUCH_STYLUS_SINCE_VERSION	1

/** @ingroup iface_zcr_stylus_v2 */
static inline void
zcr_stylus_v2_set_user_data(struct zcr_stylus_v2 *zcr_stylus_v2, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zcr_stylus_v2, user_data);
}

/** @ingroup iface_zcr_stylus_v2 */
static inline void *
zcr_stylus_v2_get_user_data(struct zcr_stylus_v2 *zcr_stylus_v2)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zcr_stylus_v2);
}

static inline uint32_t
zcr_stylus_v2_get_version(struct zcr_stylus_v2 *zcr_stylus_v2)
{
	return wl_proxy_get_version((struct wl_proxy *) zcr_stylus_v2);
}

/** @ingroup iface_zcr_stylus_v2 */
static inline void
zcr_stylus_v2_destroy(struct zcr_stylus_v2 *zcr_stylus_v2)
{
	wl_proxy_destroy((struct wl_proxy *) zcr_stylus_v2);
}

/**
 * @ingroup iface_zcr_stylus_v2
 *
 * Create touch_stylus object. See zcr_touch_stylus_v1 interface for
 * details. If the given wl_touch already has a touch_stylus object
 * associated, the touch_stylus_exists protocol error is raised.
 */
static inline struct zcr_touch_stylus_v2 *
zcr_stylus_v2_get_touch_stylus(struct zcr_stylus_v2 *zcr_stylus_v2, struct wl_touch *touch)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_constructor((struct wl_proxy *) zcr_stylus_v2,
			 ZCR_STYLUS_V2_GET_TOUCH_STYLUS, &zcr_touch_stylus_v2_interface, NULL, touch);

	return (struct zcr_touch_stylus_v2 *) id;
}

#ifndef ZCR_TOUCH_STYLUS_V2_TOOL_TYPE_ENUM
#define ZCR_TOUCH_STYLUS_V2_TOOL_TYPE_ENUM
/**
 * @ingroup iface_zcr_touch_stylus_v2
 * tool type of device.
 */
enum zcr_touch_stylus_v2_tool_type {
	/**
	 * Touch
	 */
	ZCR_TOUCH_STYLUS_V2_TOOL_TYPE_TOUCH = 1,
	/**
	 * Pen
	 */
	ZCR_TOUCH_STYLUS_V2_TOOL_TYPE_PEN = 2,
	/**
	 * Eraser
	 */
	ZCR_TOUCH_STYLUS_V2_TOOL_TYPE_ERASER = 3,
};
#endif /* ZCR_TOUCH_STYLUS_V2_TOOL_TYPE_ENUM */

/**
 * @ingroup iface_zcr_touch_stylus_v2
 * @struct zcr_touch_stylus_v2_listener
 */
struct zcr_touch_stylus_v2_listener {
	/**
	 * sets tool type of touch
	 *
	 * Notification that the user is using a tool type other than
	 * touch. There can only be one tool in use at a time. This event
	 * is sent in the same frame as the wl_touch.down event. The tool
	 * type cannot change while a touch is being reported.
	 * @param id touch id
	 * @param type type of tool in use
	 */
	void (*tool)(void *data,
		     struct zcr_touch_stylus_v2 *zcr_touch_stylus_v2,
		     uint32_t id,
		     uint32_t type);
	/**
	 * force change event
	 *
	 * Notification of a change in physical force on the surface of
	 * the screen. The force is calibrated and normalized to the 0 to 1
	 * range.
	 * @param time timestamp with millisecond granularity
	 * @param id touch id
	 * @param force new value of force
	 */
	void (*force)(void *data,
		      struct zcr_touch_stylus_v2 *zcr_touch_stylus_v2,
		      uint32_t time,
		      uint32_t id,
		      wl_fixed_t force);
	/**
	 * tilt change event
	 *
	 * Notification of a change in tilt of a stylus.
	 *
	 * Measured from surface normal as plane angle in degrees, values
	 * lie in [-90,90]. A positive x is to the right and a positive y
	 * is towards the user.
	 * @param time timestamp with millisecond granularity
	 * @param id touch id
	 * @param tilt_x tilt in x direction
	 * @param tilt_y tilt in y direction
	 */
	void (*tilt)(void *data,
		     struct zcr_touch_stylus_v2 *zcr_touch_stylus_v2,
		     uint32_t time,
		     uint32_t id,
		     wl_fixed_t tilt_x,
		     wl_fixed_t tilt_y);
};

/**
 * @ingroup zcr_touch_stylus_v2_iface
 */
static inline int
zcr_touch_stylus_v2_add_listener(struct zcr_touch_stylus_v2 *zcr_touch_stylus_v2,
				 const struct zcr_touch_stylus_v2_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zcr_touch_stylus_v2,
				     (void (**)(void)) listener, data);
}

#define ZCR_TOUCH_STYLUS_V2_DESTROY	0

/**
 * @ingroup iface_zcr_touch_stylus_v2
 */
#define ZCR_TOUCH_STYLUS_V2_DESTROY_SINCE_VERSION	1

/** @ingroup iface_zcr_touch_stylus_v2 */
static inline void
zcr_touch_stylus_v2_set_user_data(struct zcr_touch_stylus_v2 *zcr_touch_stylus_v2, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zcr_touch_stylus_v2, user_data);
}

/** @ingroup iface_zcr_touch_stylus_v2 */
static inline void *
zcr_touch_stylus_v2_get_user_data(struct zcr_touch_stylus_v2 *zcr_touch_stylus_v2)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zcr_touch_stylus_v2);
}

static inline uint32_t
zcr_touch_stylus_v2_get_version(struct zcr_touch_stylus_v2 *zcr_touch_stylus_v2)
{
	return wl_proxy_get_version((struct wl_proxy *) zcr_touch_stylus_v2);
}

/**
 * @ingroup iface_zcr_touch_stylus_v2
 */
static inline void
zcr_touch_stylus_v2_destroy(struct zcr_touch_stylus_v2 *zcr_touch_stylus_v2)
{
	wl_proxy_marshal((struct wl_proxy *) zcr_touch_stylus_v2,
			 ZCR_TOUCH_STYLUS_V2_DESTROY);

	wl_proxy_destroy((struct wl_proxy *) zcr_touch_stylus_v2);
}

#ifdef  __cplusplus
}
#endif

#endif
