/***************************************************************************
 *   Copyright (C) 2009 by Johan Maes -ON4QZ                               *
 *   on4qz@telenet.be   http://users.telenet.be/on4qz                      *
 *   http://users.telenet.be/on4qz                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "rigcontrol.h"
#include "global.h"
#include "configparams.h"
#include <QMessageBox>

#define MAXCONFLEN 128

rigControl *rigController;

QList<const rig_caps *> capsList;


int collect(const rig_caps *caps,rig_ptr_t)
{
  capsList.append(caps);
//  addToLog(QString("collect: %1,%2").arg(caps->mfg_name).arg(caps->model_name),RIGCTRL);
  return 1;
}

rigControl::rigControl()
{
	rigControlEnabled=FALSE;
  rig_set_debug(RIG_DEBUG_NONE);
  getRadioList();
}

rigControl::~rigControl()
{
	rig_close(my_rig); /* close port */
	rig_cleanup(my_rig); /* if you care about memory */
}

bool rigControl::init()
{
  int retcode;

  if(!enableCAT) return FALSE;

	myport.type.rig = RIG_PORT_SERIAL;
  myport.parm.serial.rate = baudrate;
  myport.parm.serial.data_bits =databits;
	myport.parm.serial.stop_bits =stopbits;
	if(parity=="Even") myport.parm.serial.parity = RIG_PARITY_EVEN;
	else if (parity=="Odd") myport.parm.serial.parity = RIG_PARITY_ODD;
	else  myport.parm.serial.parity = RIG_PARITY_NONE;
	if(handshake=="XOn/Xoff") myport.parm.serial.handshake = RIG_HANDSHAKE_XONXOFF;
	if(handshake=="Hardware") myport.parm.serial.handshake = RIG_HANDSHAKE_HARDWARE;
	else myport.parm.serial.handshake = RIG_HANDSHAKE_NONE;
	strncpy(myport.pathname, (const char *)serialPort.toLatin1().data(), FILPATHLEN);
  myport.parm.serial.rts_state=RIG_SIGNAL_OFF;
	myport.parm.serial.dtr_state=RIG_SIGNAL_OFF;	
  addToLog(QString("rigcontrol:init myport pathname: %1").arg(myport.pathname),RIGCTRL);

  radioModelNumber=getModelNumber(getRadioModelIndex());
  my_rig = rig_init(radioModelNumber);
  if(!my_rig)
    {
      addToLog(QString("Error in connection using radio model %1").arg(radioModel),RIGCTRL);
      QMessageBox::information(0,"Cat interface",QString("Error in connection using radio model %1").arg(radioModel));
      return FALSE;
    }

  if(QString(my_rig->caps->mfg_name)=="Icom")
    {
      rig_set_conf(my_rig, rig_token_lookup(my_rig, "civaddr"), QString::number(civAddress).toLatin1());
    }

strncpy(my_rig->state.rigport.pathname,(const char *)serialPort.toLatin1().data(),FILPATHLEN);
my_rig->state.rigport.parm.serial.rts_state=RIG_SIGNAL_OFF;
my_rig->state.rigport.parm.serial.dtr_state=RIG_SIGNAL_OFF;

addToLog(QString("rigcontrol:init rigport.pathname: %1").arg(my_rig->state.rigport.pathname),RIGCTRL);
retcode = rig_open(my_rig);
if (retcode != RIG_OK )
  {
    addToLog(QString("error opening rigcontroller: %1").arg(QString(rigerror(retcode))),RIGCTRL);
    errorMessage(retcode,"init() open");
    return FALSE;
  }
addToLog("rigcontroller successfully opened",RIGCTRL);
rigControlEnabled=TRUE;
//	int verbose=0;

//	rig_set_debug(verbose<2 ? RIG_DEBUG_NONE: (rig_debug_level_e)verbose);
  //rig_debug(RIG_DEBUG_VERBOSE, "rigctl, %s\n", hamlib_version);
// test if we can contact the tranceiver
double fr;
if(!getFrequency(fr)) rigControlEnabled=FALSE;
	return TRUE;
}

bool rigControl::getFrequency(double &frequency)
{
  int retcode;
	if(!rigControlEnabled) return FALSE;
	retcode = rig_set_vfo(my_rig, RIG_VFO_A);
  if (retcode != RIG_OK ) {errorMessage(retcode,"setVFO"); return FALSE; }
	retcode = rig_get_freq(my_rig, RIG_VFO_A, &frequency); 
  if (retcode != RIG_OK ) {errorMessage(retcode,"getFrequency"); return FALSE; }
	return TRUE; 
}

bool rigControl::setFrequency(double frequency)
{
  int retcode;
	if(!rigControlEnabled) return FALSE;
	retcode = rig_set_vfo(my_rig, RIG_VFO_A);
  if (retcode != RIG_OK ) {errorMessage(retcode,"setVFO"); return FALSE; }
	retcode = rig_set_freq(my_rig, RIG_VFO_A, frequency); 
  if (retcode != RIG_OK ) {errorMessage(retcode,"setFrequency"); return FALSE; }
  setMode("SSB");
	return TRUE; 
}

void rigControl::disable()
{
  if(rigControlEnabled)
  {
    rig_close(my_rig); /* close port */
    rig_cleanup(my_rig); /* if you care about memory */
    rigControlEnabled=FALSE;
  }
}




bool rigControl::getMode(QString &mode)
{
  rmode_t rmode;
	pbwidth_t width;
	int retcode;
	if(!rigControlEnabled) return FALSE;
	retcode = rig_get_mode(my_rig, RIG_VFO_CURR, &rmode, &width);
  if (retcode != RIG_OK ) {errorMessage(retcode,"getMode"); return FALSE; }
	mode=QString(rig_strrmode(rmode));
	return TRUE;
}

bool rigControl::setMode(QString mode)
{
  rmode_t rmode=rig_parse_mode(mode.toLatin1().data());
  int retcode;
  if(!rigControlEnabled) return FALSE;
  retcode = rig_set_mode(my_rig, RIG_VFO_CURR, rmode, rig_passband_normal(my_rig,rmode));
  if (retcode != RIG_OK ) {errorMessage(retcode,"setMode"); return FALSE; }
  return TRUE;
}


bool rigControl::setPTT(bool on)
{
  int retcode;
  ptt_t ptt;
  if(on) ptt=RIG_PTT_ON; else ptt=RIG_PTT_OFF;
  if(!rigControlEnabled) return FALSE;
  retcode = rig_set_ptt (my_rig, RIG_VFO_CURR,ptt);
  if (retcode != RIG_OK ) {errorMessage(retcode,"setPTT"); return FALSE; }
  return TRUE;
}



void  rigControl::errorMessage(int errorCode,QString command)
{
  QMessageBox::information(0,"Cat interface",QString("Error in connection: %1\n%2").arg(QString(rigerror(errorCode))).arg(command));
}

void rigControl::getRadioList()
{
  capsList.clear();
  rig_load_all_backends();
  rig_list_foreach(collect,0);
  qSort(capsList.begin(),capsList.end(),model_Sort);
}

bool rigControl::getRadioList(QComboBox *cb)
{
  int i;
  if(capsList.count()==0) return FALSE;
  QStringList sl;
  for (i=0;i<capsList.count();i++)
  {
    QString t= capsList.at(i)->mfg_name;
    t+=",";
    t+=capsList.at(i)->model_name;
    sl << t;
  }
  cb->addItems(sl);
  return TRUE;
}

int rigControl::getModelNumber(int idx)
{
  if(idx<0) return 0;
  return capsList.at(idx)->rig_model;
}

int rigControl::getRadioModelIndex()
{
  int i;
  QStringList sl=radioModel.split(",");
  if(sl.count()==1) sl.append("");
    for(i=0;i<capsList.count();i++)
  {
       if((capsList.at(i)->mfg_name==sl.at(0)) && (capsList.at(i)->model_name==sl.at(1)))
      {
         return i;
       }
  }
  return -1;
}



bool model_Sort(const rig_caps *caps1,const rig_caps *caps2)
{
 if(caps1->mfg_name==caps2->mfg_name)
  {

    if (QString::compare(caps1->model_name,caps2->model_name)<0) return TRUE;
    return FALSE;
  }
  if (QString::compare(caps1->mfg_name,caps2->mfg_name)<0) return TRUE;
  return FALSE;
}



