/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.0
import Ubuntu.Components 0.1
import Ubuntu.Components.ListItems 0.1
import Friends 0.2

MainView {
    width: units.gu(50)
    height: units.gu(100)

    FriendsUtils {
        id: friendsUtils
    }

    ListView {
        id: listView
        anchors {
            fill: parent
        }
        snapMode: ListView.SnapToItem
        cacheBuffer: parent.height
        model: StreamModel { 
            //stream: "messages"
            //service: "facebook"
            /* account Id from libaccounts */
            //account: 1
        }

        delegate: Item {
            id: tile
            height: status_update_content.height
            width: parent.width
            anchors {
                margins: units.gu(1)
            }

            UbuntuShape {
                id: avatarImage
                radius: "medium"
                height: units.dp(48)
                width: units.dp(48)
                anchors {
                    left: parent.left
                    top: parent.top
                    leftMargin: units.gu(1)
                    topMargin: units.gu(1)
                }
                image: Image {
                    anchors.fill: parent
                    source: Qt.resolvedUrl(model.avatar)
                    asynchronous: true
                    fillMode: Image.PreserveAspectFit
                }
            }

            Item {
                id: status_update_content
                anchors {
                    left: avatarImage.right
                    right: parent.right
                    top: parent.top
                    topMargin: units.gu(1)
                    leftMargin: units.gu(1)
                    bottomMargin: units.gu(1)
                    rightMargin: units.gu(1)
                }
                height: childrenRect.height + units.gu(2)
                Column {
                    spacing: units.gu(1)
                    anchors {
                        left: parent.left;
                        right: parent.right
                        bottomMargin: units.gu(2)
                    }
                    Label {
                        id: sender
                        text: model.sender
                        fontSize: "medium"
                        font.bold: true
                        font.family: "Ubuntu"
                        width: parent.width
                    }
                    Label {
                        id: message
                        text: model.message
                        wrapMode: Text.WrapAtWordBoundaryOrAnywhere
                        width: parent.width - units.gu(3)
                        font.family: "Ubuntu"
                    }
                }
                Row {
                    anchors.right: parent.right
                    anchors.rightMargin: units.gu(1)
                    anchors.top: parent.top
                    spacing: units.gu(1)

                    Label {
                        id: time
                        text: friendsUtils.createTimeString(model.timestamp)
                        fontSize: "small"
                        font.family: "Ubuntu"
                    }
                }
            }
            ThinDivider {}
        }
    }
}
