/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef MESSAGEWITHCHECKBOX_H
#define MESSAGEWITHCHECKBOX_H

#include <QDialog>
#include <QLabel>
#include <QPushButton>
#include <QCheckBox>
#include <QLayout>

/**
	@author Anistratov Oleg <ower86@gmail.com>
*/
class MessageWithCheckBox : public QDialog
{
  Q_OBJECT
  private:
    QLabel*      m_msg;
    QLabel*      m_icon;
    QCheckBox*   m_question;
    QPushButton* m_okBtn;
    int*         m_result;

  public:
    MessageWithCheckBox(const QString &, const QString &, const QString &, int*, QWidget* = 0);
    ~MessageWithCheckBox(){};

    void setIcon(const QPixmap & pix){m_icon->setPixmap(pix);}

  public slots:
    void finish(){*m_result = (m_question->checkState() == Qt::Unchecked); accept();}
};

#endif
