[comment {-*- tcl -*- doctools}]
[vset FORMATNAME pixmap]
[vset FORMATFULLNAME {Pixmap Image type}]

[manpage_begin img-[vset FORMATNAME] n 1.4]
[moddesc Img]
[titledesc "Img, [vset FORMATFULLNAME] ([vset FORMATNAME])"]
[copyright {1995-2023 Jan Nijtmans <nijtmans@users.sourceforge.net>}]
[require Tk]
[require img::[vset FORMATNAME] [opt 1.4]]
[description]

The package [package img::[vset FORMATNAME]] is a sub-package of
[package Img]. It can be loaded as a part of the complete Img support,
via [cmd {package require Img}], or on its own, via

[cmd "package require img::[vset FORMATNAME]"].

[para]

Like all packages of [package Img] it does [emph not] provide new
commands, but extends the existing [package Tk] command [cmd image].

[para]

In contrast to all other sub packages this packages does [emph not]
extend [package Tk]'s [cmd photo] image type, but rather provides a
completely new image type, on the same level as [cmd photo] and
[cmd bitmap].

[section {CREATING PIXMAPS}]

Like all images, pixmaps are created using the [cmd {image create}]
command.

[list_begin definitions]
[call [cmd image] [method {create pixmap}] [opt [arg name]] [opt [arg options]]]

Pixmaps support the following options:

[list_begin definitions]
[def "[option -data] [arg string]"]

Specifies the contents of the source pixmap as a string. The string
must adhere to X11 pixmap format (e.g., as generated by the pixmap
program). If both the [option -data] and [option -file] options are
specified, the [option -data] option takes precedence.

[def "[option -file] [arg name]"]

[arg name] gives the name of a file whose contents define the source
pixmap. The file must adhere to X11 pixmap format (e.g., as generated
by the pixmap program).

[list_end]
[list_end]

[section {IMAGE COMMAND}]

When a pixmap image is created, Tk also creates a new command whose
name is the same as the image. This command may be used to invoke
various operations on the image. It has the following general form:

[list_begin definitions]
[call [arg imageName] [method option] [opt [arg {arg arg ...}]]]
[list_end]

[method Option] and the args determine the exact behavior of the
command. The following commands are possible for pixmap images:

[list_begin definitions]

[call [arg imageName] [method cget] [arg option]]

Returns the current value of the configuration option given by

[arg option]. [arg Option] may have any of the values accepted by the
[cmd {image create pixmap}] command.


[call [arg imageName] [method configure] [opt [option option]] [opt [arg {value option value ...}]]]

Query or modify the configuration options for the image. If no option
is specified, returns a list describing all of the available options
for [arg imageName] (see [cmd Tk_ConfigureInfo] for information on the
format of this list). If [arg option] is specified with no

[arg value], then the command returns a list describing the one named
option (this list will be identical to the corresponding sublist of
the value returned if no option is specified).  If one or more

[arg option-value] pairs are specified, then the command modifies the
given option(s) to have the given value(s); in this case the command
returns an empty string. [option Option] may have any of the values
accepted by the [cmd {image create pixmap}] command.


[include format-footer.inc]
