#if   !defined(__ENGINE_HPP)
#define __ENGINE_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#include <Common.hpp>

#if   !defined(__PROTOTYPE_HPP)
#include <Prototype.hpp>
#endif

/// Engine domain type


DECLARE_TYPE( CORELINUX(Count), Cylinders );

/**
Engine is a abstract base class for engine types. It has
a pure virtual method for cloning the engines and a cylinder
count accessor.
*/
      
DECLARE_CLASS(Engine);

class Engine : public CORELINUX(Prototype)<Engine>
{

public:

                        /// Default constructor

                        Engine( void );

                        /// Copy Constructor 

                        Engine( EngineCref aRef );

                        /// Destructor

   virtual              ~Engine( void );

   //
   // Operator overloads
   //

            /// Assignment operator
         
            EngineRef   operator=( EngineCref );
         
            /// Equality operator
         
            bool        operator==( EngineCref aRef ) const;

   //
   // Accessors
   //

            /// Return the Cylinders count

   virtual  CylindersCref  getCylinders( void ) const = 0;

};

#endif // if !defined __ENGINE_HPP

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.5 $
   $Date: 2000/02/11 03:22:19 $
   $Locker:  $
*/



