/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.MissingResourceException;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeAssembler;
import org.cojen.classfile.CodeDisassembler;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.TypeDesc;

public abstract class AbstractCodeAssembler
implements CodeAssembler {
    protected AbstractCodeAssembler() {
    }

    public void ifComparisonBranch(Location location, String choice, TypeDesc type) {
        boolean trueBranch = false;
        int length = choice.length();
        if (choice.charAt(length - 1) == 't') {
            trueBranch = true;
            choice = choice.substring(0, length - 1);
        }
        choice = choice.intern();
        switch (type.getTypeCode()) {
            default: {
                if (choice == "==") {
                    this.ifEqualBranch(location, true);
                } else if (choice == "!=") {
                    this.ifEqualBranch(location, false);
                } else {
                    throw new IllegalArgumentException("Comparison not allowed on object types: " + choice);
                }
                return;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                this.ifComparisonBranch(location, choice);
                return;
            }
            case 11: {
                this.math((byte)-108);
                break;
            }
            case 6: {
                this.math((byte)(choice == (trueBranch ? "<=" : ">") || choice == (trueBranch ? "<" : ">=") ? -106 : -107));
                break;
            }
            case 7: {
                this.math((byte)(choice == (trueBranch ? "<=" : ">") || choice == (trueBranch ? "<" : ">=") ? -104 : -105));
            }
        }
        this.ifZeroComparisonBranch(location, choice);
    }

    public void inline(Object code) {
        ClassFile cf;
        Class<?> codeClass = code.getClass();
        String className = codeClass.getName().replace('.', '/') + ".class";
        ClassLoader loader = codeClass.getClassLoader();
        InputStream in = loader == null ? ClassLoader.getSystemResourceAsStream(className) : loader.getResourceAsStream(className);
        if (in == null) {
            throw new MissingResourceException("Unable to find class file", className, null);
        }
        try {
            cf = ClassFile.readFrom(in);
        }
        catch (IOException e) {
            MissingResourceException e2 = new MissingResourceException("Error loading class file: " + e.getMessage(), className, null);
            try {
                e2.initCause(e);
            }
            catch (NoSuchMethodError e3) {
                // empty catch block
            }
            throw e2;
        }
        MethodInfo defineMethod = null;
        MethodInfo[] methods = cf.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            MethodInfo method = methods[i];
            if (!"define".equals(method.getName())) continue;
            if (defineMethod != null) {
                throw new IllegalArgumentException("Multiple define methods found");
            }
            defineMethod = method;
        }
        if (defineMethod == null) {
            throw new IllegalArgumentException("No define method found");
        }
        TypeDesc[] paramTypes = defineMethod.getMethodDescriptor().getParameterTypes();
        LocalVariable[] paramVars = new LocalVariable[paramTypes.length];
        int i = paramVars.length;
        while (--i >= 0) {
            LocalVariable paramVar = this.createLocalVariable(null, paramTypes[i]);
            this.storeLocal(paramVar);
            paramVars[i] = paramVar;
        }
        Label returnLocation = this.createLabel();
        CodeDisassembler cd = new CodeDisassembler(defineMethod);
        cd.disassemble(this, paramVars, returnLocation);
        returnLocation.setLocation();
    }

    public void invoke(Method method) {
        TypeDesc ret = TypeDesc.forClass(method.getReturnType());
        Class<?>[] paramClasses = method.getParameterTypes();
        TypeDesc[] params = new TypeDesc[paramClasses.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = TypeDesc.forClass(paramClasses[i]);
        }
        Class<?> clazz = method.getDeclaringClass();
        if (Modifier.isStatic(method.getModifiers())) {
            this.invokeStatic(clazz.getName(), method.getName(), ret, params);
        } else if (clazz.isInterface()) {
            this.invokeInterface(clazz.getName(), method.getName(), ret, params);
        } else {
            this.invokeVirtual(clazz.getName(), method.getName(), ret, params);
        }
    }

    public void invokeSuper(Method method) {
        TypeDesc ret = TypeDesc.forClass(method.getReturnType());
        Class<?>[] paramClasses = method.getParameterTypes();
        TypeDesc[] params = new TypeDesc[paramClasses.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = TypeDesc.forClass(paramClasses[i]);
        }
        this.invokeSuper(method.getDeclaringClass().getName(), method.getName(), ret, params);
    }

    public void invoke(Constructor constructor) {
        Class<?>[] paramClasses = constructor.getParameterTypes();
        TypeDesc[] params = new TypeDesc[paramClasses.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = TypeDesc.forClass(paramClasses[i]);
        }
        this.invokeConstructor(constructor.getDeclaringClass().getName().toString(), params);
    }

    public abstract /* synthetic */ void breakpoint();

    public abstract /* synthetic */ void nop();

    public abstract /* synthetic */ void monitorExit();

    public abstract /* synthetic */ void monitorEnter();

    public abstract /* synthetic */ void integerIncrement(LocalVariable var1, int var2);

    public abstract /* synthetic */ void instanceOf(TypeDesc var1);

    public abstract /* synthetic */ void checkCast(TypeDesc var1);

    public abstract /* synthetic */ void throwObject();

    public abstract /* synthetic */ void arrayLength();

    public abstract /* synthetic */ void math(byte var1);

    public abstract /* synthetic */ void ret(LocalVariable var1);

    public abstract /* synthetic */ void jsr(Location var1);

    public abstract /* synthetic */ void switchBranch(int[] var1, Location[] var2, Location var3);

    public abstract /* synthetic */ void ifComparisonBranch(Location var1, String var2) throws IllegalArgumentException;

    public abstract /* synthetic */ void ifZeroComparisonBranch(Location var1, String var2) throws IllegalArgumentException;

    public abstract /* synthetic */ void ifEqualBranch(Location var1, boolean var2);

    public abstract /* synthetic */ void ifNullBranch(Location var1, boolean var2);

    public abstract /* synthetic */ void branch(Location var1);

    public abstract /* synthetic */ void swap2();

    public abstract /* synthetic */ void swap();

    public abstract /* synthetic */ void pop2();

    public abstract /* synthetic */ void pop();

    public abstract /* synthetic */ void dup2X2();

    public abstract /* synthetic */ void dup2X1();

    public abstract /* synthetic */ void dup2();

    public abstract /* synthetic */ void dupX2();

    public abstract /* synthetic */ void dupX1();

    public abstract /* synthetic */ void dup();

    public abstract /* synthetic */ void newObject(TypeDesc var1, int var2);

    public abstract /* synthetic */ void newObject(TypeDesc var1);

    public abstract /* synthetic */ void invokeSuperConstructor(TypeDesc[] var1);

    public abstract /* synthetic */ void invokeConstructor(TypeDesc var1, TypeDesc[] var2);

    public abstract /* synthetic */ void invokeConstructor(String var1, TypeDesc[] var2);

    public abstract /* synthetic */ void invokeConstructor(TypeDesc[] var1);

    public abstract /* synthetic */ void invokeSuper(TypeDesc var1, String var2, TypeDesc var3, TypeDesc[] var4);

    public abstract /* synthetic */ void invokeSuper(String var1, String var2, TypeDesc var3, TypeDesc[] var4);

    public abstract /* synthetic */ void invokePrivate(String var1, TypeDesc var2, TypeDesc[] var3);

    public abstract /* synthetic */ void invokeInterface(TypeDesc var1, String var2, TypeDesc var3, TypeDesc[] var4);

    public abstract /* synthetic */ void invokeInterface(String var1, String var2, TypeDesc var3, TypeDesc[] var4);

    public abstract /* synthetic */ void invokeStatic(TypeDesc var1, String var2, TypeDesc var3, TypeDesc[] var4);

    public abstract /* synthetic */ void invokeStatic(String var1, String var2, TypeDesc var3, TypeDesc[] var4);

    public abstract /* synthetic */ void invokeStatic(String var1, TypeDesc var2, TypeDesc[] var3);

    public abstract /* synthetic */ void invokeVirtual(TypeDesc var1, String var2, TypeDesc var3, TypeDesc[] var4);

    public abstract /* synthetic */ void invokeVirtual(String var1, String var2, TypeDesc var3, TypeDesc[] var4);

    public abstract /* synthetic */ void invokeVirtual(String var1, TypeDesc var2, TypeDesc[] var3);

    public abstract /* synthetic */ void convert(TypeDesc var1, TypeDesc var2, int var3);

    public abstract /* synthetic */ void convert(TypeDesc var1, TypeDesc var2);

    public abstract /* synthetic */ void returnValue(TypeDesc var1);

    public abstract /* synthetic */ void returnVoid();

    public abstract /* synthetic */ void storeStaticField(TypeDesc var1, String var2, TypeDesc var3);

    public abstract /* synthetic */ void storeStaticField(String var1, String var2, TypeDesc var3);

    public abstract /* synthetic */ void storeStaticField(String var1, TypeDesc var2);

    public abstract /* synthetic */ void storeField(TypeDesc var1, String var2, TypeDesc var3);

    public abstract /* synthetic */ void storeField(String var1, String var2, TypeDesc var3);

    public abstract /* synthetic */ void storeField(String var1, TypeDesc var2);

    public abstract /* synthetic */ void loadStaticField(TypeDesc var1, String var2, TypeDesc var3);

    public abstract /* synthetic */ void loadStaticField(String var1, String var2, TypeDesc var3);

    public abstract /* synthetic */ void loadStaticField(String var1, TypeDesc var2);

    public abstract /* synthetic */ void loadField(TypeDesc var1, String var2, TypeDesc var3);

    public abstract /* synthetic */ void loadField(String var1, String var2, TypeDesc var3);

    public abstract /* synthetic */ void loadField(String var1, TypeDesc var2);

    public abstract /* synthetic */ void storeToArray(TypeDesc var1);

    public abstract /* synthetic */ void loadFromArray(TypeDesc var1);

    public abstract /* synthetic */ void storeLocal(LocalVariable var1);

    public abstract /* synthetic */ void loadThis();

    public abstract /* synthetic */ void loadLocal(LocalVariable var1);

    public abstract /* synthetic */ void loadConstant(double var1);

    public abstract /* synthetic */ void loadConstant(float var1);

    public abstract /* synthetic */ void loadConstant(long var1);

    public abstract /* synthetic */ void loadConstant(int var1);

    public abstract /* synthetic */ void loadConstant(boolean var1);

    public abstract /* synthetic */ void loadConstant(TypeDesc var1) throws IllegalStateException;

    public abstract /* synthetic */ void loadConstant(String var1);

    public abstract /* synthetic */ void loadNull();

    public abstract /* synthetic */ void mapLineNumber(int var1);

    public abstract /* synthetic */ void exceptionHandler(Location var1, Location var2, String var3);

    public abstract /* synthetic */ Label createLabel();

    public abstract /* synthetic */ LocalVariable createLocalVariable(String var1, TypeDesc var2);

    public abstract /* synthetic */ LocalVariable getParameter(int var1) throws IndexOutOfBoundsException;

    public abstract /* synthetic */ int getParameterCount();
}

