/*
 * ucs2_cp932.h
 *
 * Unicode UCS-2 to Microsoft Codepage 932 (Shift_JIS) Conversion Table
 * Made by KAJIKI Yoshihiro <kajiki@ylug.org> 
 * with refer to "CP932.TXT" of Samba_JP Project. Thanks!
 *
 */

static unsigned char low_00[512] = {
	0xFF, 0x00,
	0xFF, 0x01,
	0xFF, 0x02,
	0xFF, 0x03,
	0xFF, 0x04,
	0xFF, 0x05,
	0xFF, 0x06,
	0xFF, 0x07,
	0xFF, 0x08,
	0xFF, 0x09,
	0xFF, 0x0A,
	0xFF, 0x0B,
	0xFF, 0x0C,
	0xFF, 0x0D,
	0xFF, 0x0E,
	0xFF, 0x0F,
	0xFF, 0x10,
	0xFF, 0x11,
	0xFF, 0x12,
	0xFF, 0x13,
	0xFF, 0x14,
	0xFF, 0x15,
	0xFF, 0x16,
	0xFF, 0x17,
	0xFF, 0x18,
	0xFF, 0x19,
	0xFF, 0x1A,
	0xFF, 0x1B,
	0xFF, 0x1C,
	0xFF, 0x1D,
	0xFF, 0x1E,
	0xFF, 0x1F,
	0xFF, 0x20,
	0xFF, 0x21,
	0xFF, 0x22,
	0xFF, 0x23,
	0xFF, 0x24,
	0xFF, 0x25,
	0xFF, 0x26,
	0xFF, 0x27,
	0xFF, 0x28,
	0xFF, 0x29,
	0xFF, 0x2A,
	0xFF, 0x2B,
	0xFF, 0x2C,
	0xFF, 0x2D,
	0xFF, 0x2E,
	0xFF, 0x2F,
	0xFF, 0x30,
	0xFF, 0x31,
	0xFF, 0x32,
	0xFF, 0x33,
	0xFF, 0x34,
	0xFF, 0x35,
	0xFF, 0x36,
	0xFF, 0x37,
	0xFF, 0x38,
	0xFF, 0x39,
	0xFF, 0x3A,
	0xFF, 0x3B,
	0xFF, 0x3C,
	0xFF, 0x3D,
	0xFF, 0x3E,
	0xFF, 0x3F,
	0xFF, 0x40,
	0xFF, 0x41,
	0xFF, 0x42,
	0xFF, 0x43,
	0xFF, 0x44,
	0xFF, 0x45,
	0xFF, 0x46,
	0xFF, 0x47,
	0xFF, 0x48,
	0xFF, 0x49,
	0xFF, 0x4A,
	0xFF, 0x4B,
	0xFF, 0x4C,
	0xFF, 0x4D,
	0xFF, 0x4E,
	0xFF, 0x4F,
	0xFF, 0x50,
	0xFF, 0x51,
	0xFF, 0x52,
	0xFF, 0x53,
	0xFF, 0x54,
	0xFF, 0x55,
	0xFF, 0x56,
	0xFF, 0x57,
	0xFF, 0x58,
	0xFF, 0x59,
	0xFF, 0x5A,
	0xFF, 0x5B,
	0xFF, 0x5C,
	0xFF, 0x5D,
	0xFF, 0x5E,
	0xFF, 0x5F,
	0xFF, 0x60,
	0xFF, 0x61,
	0xFF, 0x62,
	0xFF, 0x63,
	0xFF, 0x64,
	0xFF, 0x65,
	0xFF, 0x66,
	0xFF, 0x67,
	0xFF, 0x68,
	0xFF, 0x69,
	0xFF, 0x6A,
	0xFF, 0x6B,
	0xFF, 0x6C,
	0xFF, 0x6D,
	0xFF, 0x6E,
	0xFF, 0x6F,
	0xFF, 0x70,
	0xFF, 0x71,
	0xFF, 0x72,
	0xFF, 0x73,
	0xFF, 0x74,
	0xFF, 0x75,
	0xFF, 0x76,
	0xFF, 0x77,
	0xFF, 0x78,
	0xFF, 0x79,
	0xFF, 0x7A,
	0xFF, 0x7B,
	0xFF, 0x7C,
	0xFF, 0x7D,
	0xFF, 0x7E,
	0xFF, 0x7F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0x98,
	0x81, 0x4E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0x8B,
	0x81, 0x7D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0x4C,
	0xFF, 0xFF,
	0x81, 0xF7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0x7E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0x80,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_03[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x83, 0x9F,
	0x83, 0xA0,
	0x83, 0xA1,
	0x83, 0xA2,
	0x83, 0xA3,
	0x83, 0xA4,
	0x83, 0xA5,
	0x83, 0xA6,
	0x83, 0xA7,
	0x83, 0xA8,
	0x83, 0xA9,
	0x83, 0xAA,
	0x83, 0xAB,
	0x83, 0xAC,
	0x83, 0xAD,
	0x83, 0xAE,
	0x83, 0xAF,
	0xFF, 0xFF,
	0x83, 0xB0,
	0x83, 0xB1,
	0x83, 0xB2,
	0x83, 0xB3,
	0x83, 0xB4,
	0x83, 0xB5,
	0x83, 0xB6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x83, 0xBF,
	0x83, 0xC0,
	0x83, 0xC1,
	0x83, 0xC2,
	0x83, 0xC3,
	0x83, 0xC4,
	0x83, 0xC5,
	0x83, 0xC6,
	0x83, 0xC7,
	0x83, 0xC8,
	0x83, 0xC9,
	0x83, 0xCA,
	0x83, 0xCB,
	0x83, 0xCC,
	0x83, 0xCD,
	0x83, 0xCE,
	0x83, 0xCF,
	0xFF, 0xFF,
	0x83, 0xD0,
	0x83, 0xD1,
	0x83, 0xD2,
	0x83, 0xD3,
	0x83, 0xD4,
	0x83, 0xD5,
	0x83, 0xD6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_04[512] = {
	0xFF, 0xFF,
	0x84, 0x46,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x84, 0x40,
	0x84, 0x41,
	0x84, 0x42,
	0x84, 0x43,
	0x84, 0x44,
	0x84, 0x45,
	0x84, 0x47,
	0x84, 0x48,
	0x84, 0x49,
	0x84, 0x4A,
	0x84, 0x4B,
	0x84, 0x4C,
	0x84, 0x4D,
	0x84, 0x4E,
	0x84, 0x4F,
	0x84, 0x50,
	0x84, 0x51,
	0x84, 0x52,
	0x84, 0x53,
	0x84, 0x54,
	0x84, 0x55,
	0x84, 0x56,
	0x84, 0x57,
	0x84, 0x58,
	0x84, 0x59,
	0x84, 0x5A,
	0x84, 0x5B,
	0x84, 0x5C,
	0x84, 0x5D,
	0x84, 0x5E,
	0x84, 0x5F,
	0x84, 0x60,
	0x84, 0x70,
	0x84, 0x71,
	0x84, 0x72,
	0x84, 0x73,
	0x84, 0x74,
	0x84, 0x75,
	0x84, 0x77,
	0x84, 0x78,
	0x84, 0x79,
	0x84, 0x7A,
	0x84, 0x7B,
	0x84, 0x7C,
	0x84, 0x7D,
	0x84, 0x7E,
	0x84, 0x80,
	0x84, 0x81,
	0x84, 0x82,
	0x84, 0x83,
	0x84, 0x84,
	0x84, 0x85,
	0x84, 0x86,
	0x84, 0x87,
	0x84, 0x88,
	0x84, 0x89,
	0x84, 0x8A,
	0x84, 0x8B,
	0x84, 0x8C,
	0x84, 0x8D,
	0x84, 0x8E,
	0x84, 0x8F,
	0x84, 0x90,
	0x84, 0x91,
	0xFF, 0xFF,
	0x84, 0x76,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_20[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0x5D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0x5C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0x65,
	0x81, 0x66,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0x67,
	0x81, 0x68,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0xF5,
	0x81, 0xF6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0x64,
	0x81, 0x63,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0xF1,
	0xFF, 0xFF,
	0x81, 0x8C,
	0x81, 0x8D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0xA6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_21[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0x8E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0x59,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0x5A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0xF0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0x4A,
	0xFA, 0x4B,
	0xFA, 0x4C,
	0xFA, 0x4D,
	0xFA, 0x4E,
	0xFA, 0x4F,
	0xFA, 0x50,
	0xFA, 0x51,
	0xFA, 0x52,
	0xFA, 0x53,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0x40,
	0xFA, 0x41,
	0xFA, 0x42,
	0xFA, 0x43,
	0xFA, 0x44,
	0xFA, 0x45,
	0xFA, 0x46,
	0xFA, 0x47,
	0xFA, 0x48,
	0xFA, 0x49,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0xA9,
	0x81, 0xAA,
	0x81, 0xA8,
	0x81, 0xAB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0xCB,
	0xFF, 0xFF,
	0x81, 0xCC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_22[512] = {
	0x81, 0xCD,
	0xFF, 0xFF,
	0x81, 0xDD,
	0x81, 0xCE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0xDE,
	0x81, 0xB8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0xB9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x87, 0x94,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0xE3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0xE5,
	0x81, 0x87,
	0x87, 0x98,
	0x81, 0xDA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0x61,
	0xFF, 0xFF,
	0x81, 0xC8,
	0x81, 0xC9,
	0x81, 0xBF,
	0x81, 0xBE,
	0x81, 0xE7,
	0x81, 0xE8,
	0xFF, 0xFF,
	0x87, 0x93,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0x88,
	0x81, 0xE6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0xE4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0xE0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0x82,
	0x81, 0xDF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0x85,
	0x81, 0x86,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0xE1,
	0x81, 0xE2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0xBC,
	0x81, 0xBD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0xBA,
	0x81, 0xBB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0xDB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x87, 0x99,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_23[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0xDC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_24[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x87, 0x40,
	0x87, 0x41,
	0x87, 0x42,
	0x87, 0x43,
	0x87, 0x44,
	0x87, 0x45,
	0x87, 0x46,
	0x87, 0x47,
	0x87, 0x48,
	0x87, 0x49,
	0x87, 0x4A,
	0x87, 0x4B,
	0x87, 0x4C,
	0x87, 0x4D,
	0x87, 0x4E,
	0x87, 0x4F,
	0x87, 0x50,
	0x87, 0x51,
	0x87, 0x52,
	0x87, 0x53,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_25[512] = {
	0x84, 0x9F,
	0x84, 0xAA,
	0x84, 0xA0,
	0x84, 0xAB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x84, 0xA1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x84, 0xAC,
	0x84, 0xA2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x84, 0xAD,
	0x84, 0xA4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x84, 0xAF,
	0x84, 0xA3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x84, 0xAE,
	0x84, 0xA5,
	0x84, 0xBA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x84, 0xB5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x84, 0xB0,
	0x84, 0xA7,
	0x84, 0xBC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x84, 0xB7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x84, 0xB2,
	0x84, 0xA6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x84, 0xB6,
	0x84, 0xBB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x84, 0xB1,
	0x84, 0xA8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x84, 0xB8,
	0x84, 0xBD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x84, 0xB3,
	0x84, 0xA9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x84, 0xB9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x84, 0xBE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x84, 0xB4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0xA1,
	0x81, 0xA0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0xA3,
	0x81, 0xA2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0xA5,
	0x81, 0xA4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0x9F,
	0x81, 0x9E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0x9B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0x9D,
	0x81, 0x9C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0xFC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_26[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0x9A,
	0x81, 0x99,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0x8A,
	0xFF, 0xFF,
	0x81, 0x89,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0xF4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0xF3,
	0xFF, 0xFF,
	0x81, 0xF2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_30[512] = {
	0x81, 0x40,
	0x81, 0x41,
	0x81, 0x42,
	0x81, 0x56,
	0xFF, 0xFF,
	0x81, 0x58,
	0x81, 0x59,
	0x81, 0x5A,
	0x81, 0x71,
	0x81, 0x72,
	0x81, 0x73,
	0x81, 0x74,
	0x81, 0x75,
	0x81, 0x76,
	0x81, 0x77,
	0x81, 0x78,
	0x81, 0x79,
	0x81, 0x7A,
	0x81, 0xA7,
	0x81, 0xAC,
	0x81, 0x6B,
	0x81, 0x6C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x87, 0x80,
	0xFF, 0xFF,
	0x87, 0x81,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x82, 0x9F,
	0x82, 0xA0,
	0x82, 0xA1,
	0x82, 0xA2,
	0x82, 0xA3,
	0x82, 0xA4,
	0x82, 0xA5,
	0x82, 0xA6,
	0x82, 0xA7,
	0x82, 0xA8,
	0x82, 0xA9,
	0x82, 0xAA,
	0x82, 0xAB,
	0x82, 0xAC,
	0x82, 0xAD,
	0x82, 0xAE,
	0x82, 0xAF,
	0x82, 0xB0,
	0x82, 0xB1,
	0x82, 0xB2,
	0x82, 0xB3,
	0x82, 0xB4,
	0x82, 0xB5,
	0x82, 0xB6,
	0x82, 0xB7,
	0x82, 0xB8,
	0x82, 0xB9,
	0x82, 0xBA,
	0x82, 0xBB,
	0x82, 0xBC,
	0x82, 0xBD,
	0x82, 0xBE,
	0x82, 0xBF,
	0x82, 0xC0,
	0x82, 0xC1,
	0x82, 0xC2,
	0x82, 0xC3,
	0x82, 0xC4,
	0x82, 0xC5,
	0x82, 0xC6,
	0x82, 0xC7,
	0x82, 0xC8,
	0x82, 0xC9,
	0x82, 0xCA,
	0x82, 0xCB,
	0x82, 0xCC,
	0x82, 0xCD,
	0x82, 0xCE,
	0x82, 0xCF,
	0x82, 0xD0,
	0x82, 0xD1,
	0x82, 0xD2,
	0x82, 0xD3,
	0x82, 0xD4,
	0x82, 0xD5,
	0x82, 0xD6,
	0x82, 0xD7,
	0x82, 0xD8,
	0x82, 0xD9,
	0x82, 0xDA,
	0x82, 0xDB,
	0x82, 0xDC,
	0x82, 0xDD,
	0x82, 0xDE,
	0x82, 0xDF,
	0x82, 0xE0,
	0x82, 0xE1,
	0x82, 0xE2,
	0x82, 0xE3,
	0x82, 0xE4,
	0x82, 0xE5,
	0x82, 0xE6,
	0x82, 0xE7,
	0x82, 0xE8,
	0x82, 0xE9,
	0x82, 0xEA,
	0x82, 0xEB,
	0x82, 0xEC,
	0x82, 0xED,
	0x82, 0xEE,
	0x82, 0xEF,
	0x82, 0xF0,
	0x82, 0xF1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0x4A,
	0x81, 0x4B,
	0x81, 0x54,
	0x81, 0x55,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x83, 0x40,
	0x83, 0x41,
	0x83, 0x42,
	0x83, 0x43,
	0x83, 0x44,
	0x83, 0x45,
	0x83, 0x46,
	0x83, 0x47,
	0x83, 0x48,
	0x83, 0x49,
	0x83, 0x4A,
	0x83, 0x4B,
	0x83, 0x4C,
	0x83, 0x4D,
	0x83, 0x4E,
	0x83, 0x4F,
	0x83, 0x50,
	0x83, 0x51,
	0x83, 0x52,
	0x83, 0x53,
	0x83, 0x54,
	0x83, 0x55,
	0x83, 0x56,
	0x83, 0x57,
	0x83, 0x58,
	0x83, 0x59,
	0x83, 0x5A,
	0x83, 0x5B,
	0x83, 0x5C,
	0x83, 0x5D,
	0x83, 0x5E,
	0x83, 0x5F,
	0x83, 0x60,
	0x83, 0x61,
	0x83, 0x62,
	0x83, 0x63,
	0x83, 0x64,
	0x83, 0x65,
	0x83, 0x66,
	0x83, 0x67,
	0x83, 0x68,
	0x83, 0x69,
	0x83, 0x6A,
	0x83, 0x6B,
	0x83, 0x6C,
	0x83, 0x6D,
	0x83, 0x6E,
	0x83, 0x6F,
	0x83, 0x70,
	0x83, 0x71,
	0x83, 0x72,
	0x83, 0x73,
	0x83, 0x74,
	0x83, 0x75,
	0x83, 0x76,
	0x83, 0x77,
	0x83, 0x78,
	0x83, 0x79,
	0x83, 0x7A,
	0x83, 0x7B,
	0x83, 0x7C,
	0x83, 0x7D,
	0x83, 0x7E,
	0x83, 0x80,
	0x83, 0x81,
	0x83, 0x82,
	0x83, 0x83,
	0x83, 0x84,
	0x83, 0x85,
	0x83, 0x86,
	0x83, 0x87,
	0x83, 0x88,
	0x83, 0x89,
	0x83, 0x8A,
	0x83, 0x8B,
	0x83, 0x8C,
	0x83, 0x8D,
	0x83, 0x8E,
	0x83, 0x8F,
	0x83, 0x90,
	0x83, 0x91,
	0x83, 0x92,
	0x83, 0x93,
	0x83, 0x94,
	0x83, 0x95,
	0x83, 0x96,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0x45,
	0x81, 0x5B,
	0x81, 0x52,
	0x81, 0x53,
	0xFF, 0xFF
};

static unsigned char low_32[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0x58,
	0x87, 0x8B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x87, 0x8C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x87, 0x85,
	0x87, 0x86,
	0x87, 0x87,
	0x87, 0x88,
	0x87, 0x89,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_33[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x87, 0x65,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x87, 0x69,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x87, 0x60,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x87, 0x63,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x87, 0x61,
	0x87, 0x6B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x87, 0x6A,
	0x87, 0x64,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x87, 0x6C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x87, 0x66,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x87, 0x6E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x87, 0x5F,
	0x87, 0x6D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x87, 0x62,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x87, 0x67,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x87, 0x68,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x87, 0x7E,
	0x87, 0x8F,
	0x87, 0x8E,
	0x87, 0x8D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x87, 0x72,
	0x87, 0x73,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x87, 0x6F,
	0x87, 0x70,
	0x87, 0x71,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x87, 0x75,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x87, 0x74,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x87, 0x83,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_4E[512] = {
	0x88, 0xEA,
	0x92, 0x9A,
	0xFF, 0xFF,
	0x8E, 0xB5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x9C,
	0x8F, 0xE4,
	0x8E, 0x4F,
	0x8F, 0xE3,
	0x89, 0xBA,
	0xFF, 0xFF,
	0x95, 0x73,
	0x97, 0x5E,
	0xFF, 0xFF,
	0x98, 0xA0,
	0x89, 0x4E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x8E,
	0x98, 0xA1,
	0x90, 0xA2,
	0x99, 0xC0,
	0x8B, 0x75,
	0x95, 0xB8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0xE5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0xBC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xC0,
	0xFF, 0xFF,
	0xFA, 0x68,
	0xFF, 0xFF,
	0x98, 0xA2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x86,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0xA3,
	0x8B, 0xF8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0xA4,
	0xFF, 0xFF,
	0x8A, 0xDB,
	0x92, 0x4F,
	0xFF, 0xFF,
	0x8E, 0xE5,
	0x98, 0xA5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0xA6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0xA7,
	0x94, 0x54,
	0xFF, 0xFF,
	0x8B, 0x76,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0x56,
	0xFF, 0xFF,
	0x93, 0xE1,
	0x8C, 0xC1,
	0x96, 0x52,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x68,
	0x98, 0xA8,
	0x8F, 0xE6,
	0x98, 0xA9,
	0x89, 0xB3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xE3,
	0x8C, 0xEE,
	0x96, 0xE7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xA4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x90,
	0xFF, 0xFF,
	0x93, 0xFB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xA3,
	0xFF, 0xFF,
	0x8B, 0x54,
	0xFF, 0xFF,
	0x98, 0xAA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0xAB,
	0x97, 0xB9,
	0xFF, 0xFF,
	0x97, 0x5C,
	0x91, 0x88,
	0x98, 0xAD,
	0x8E, 0x96,
	0x93, 0xF1,
	0xFF, 0xFF,
	0x98, 0xB0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x5D,
	0x8C, 0xDD,
	0xFF, 0xFF,
	0x8C, 0xDC,
	0x88, 0xE4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0x6A,
	0x98, 0x69,
	0xFF, 0xFF,
	0x8D, 0xB1,
	0x88, 0x9F,
	0xFF, 0xFF,
	0x98, 0xB1,
	0x98, 0xB2,
	0x98, 0xB3,
	0x96, 0x53,
	0x98, 0xB4,
	0xFF, 0xFF,
	0x8C, 0xF0,
	0x88, 0xE5,
	0x96, 0x92,
	0xFF, 0xFF,
	0x8B, 0x9C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x9D,
	0x8B, 0x9E,
	0x92, 0xE0,
	0x97, 0xBA,
	0xFF, 0xFF,
	0x98, 0xB5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0xB6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0xB7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x6C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x59,
	0x90, 0x6D,
	0x98, 0xBC,
	0xFF, 0xFF,
	0x98, 0xBA,
	0xFF, 0xFF,
	0x98, 0xBB,
	0x8B, 0x77,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0xA1,
	0x89, 0xEE,
	0xFF, 0xFF,
	0x98, 0xB9,
	0x98, 0xB8,
	0x95, 0xA7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x65,
	0x8E, 0x64,
	0x91, 0xBC,
	0x98, 0xBD,
	0x95, 0x74,
	0x90, 0xE5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0x57,
	0x98, 0xBE,
	0x98, 0xC0,
	0xFF, 0xFF,
	0xFA, 0x69,
	0xFF, 0xFF,
	0x91, 0xE3,
	0x97, 0xDF,
	0x88, 0xC8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0xBF,
	0x89, 0xBC,
	0xFF, 0xFF,
	0x8B, 0xC2,
	0xFF, 0xFF,
	0x92, 0x87,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x8F,
	0x98, 0xC1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0x43,
	0xFA, 0x6A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_4F[512] = {
	0xFA, 0x6B,
	0x8A, 0xE9,
	0xFF, 0xFF,
	0xFA, 0x6C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0xC2,
	0x88, 0xC9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xDE,
	0x8A, 0xEA,
	0x95, 0x9A,
	0x94, 0xB0,
	0x8B, 0x78,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xEF,
	0xFF, 0xFF,
	0x98, 0xE5,
	0x93, 0x60,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0x8C,
	0x98, 0xC4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xBA,
	0xFF, 0xFF,
	0x97, 0xE0,
	0xFF, 0xFF,
	0x90, 0x4C,
	0xFA, 0x6D,
	0x8E, 0x66,
	0xFF, 0xFF,
	0x8E, 0x97,
	0x89, 0xBE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0xCF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x41,
	0x98, 0xC8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x88, 0xCA,
	0x92, 0xE1,
	0x8F, 0x5A,
	0x8D, 0xB2,
	0x97, 0x43,
	0xFF, 0xFF,
	0x91, 0xCC,
	0xFF, 0xFF,
	0x89, 0xBD,
	0xFA, 0x6E,
	0x98, 0xC7,
	0xFF, 0xFF,
	0x97, 0x5D,
	0x98, 0xC3,
	0x98, 0xC5,
	0x8D, 0xEC,
	0x98, 0xC6,
	0x9B, 0x43,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0xCE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0xD1,
	0x98, 0xCF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xC0,
	0xFF, 0xFF,
	0x95, 0xB9,
	0x98, 0xC9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0xCD,
	0x8C, 0xF1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x67,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xA4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0xD2,
	0xFF, 0xFF,
	0x98, 0xCA,
	0xFF, 0xFF,
	0xFA, 0x70,
	0x97, 0xE1,
	0xFF, 0xFF,
	0x8E, 0x98,
	0xFF, 0xFF,
	0x98, 0xCB,
	0xFF, 0xFF,
	0x98, 0xD0,
	0xFA, 0x6F,
	0xFF, 0xFF,
	0xFA, 0x72,
	0xFF, 0xFF,
	0x98, 0xD3,
	0xFF, 0xFF,
	0x98, 0xCC,
	0xFF, 0xFF,
	0xFA, 0x71,
	0x8B, 0x9F,
	0xFF, 0xFF,
	0x88, 0xCB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xA0,
	0x89, 0xBF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x44,
	0xFF, 0xFF,
	0x96, 0x99,
	0x95, 0x8E,
	0x8C, 0xF2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x4E,
	0x97, 0xB5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xD6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x57,
	0x91, 0xA3,
	0x89, 0xE2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0x61,
	0x8F, 0x72,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0x73,
	0x98, 0xD7,
	0xFF, 0xFF,
	0x98, 0xDC,
	0x98, 0xDA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0xD5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0xAD,
	0x98, 0xD8,
	0xFF, 0xFF,
	0x98, 0xDB,
	0x98, 0xD9,
	0xFF, 0xFF,
	0x95, 0xDB,
	0xFF, 0xFF,
	0x98, 0xD6,
	0xFF, 0xFF,
	0x90, 0x4D,
	0xFF, 0xFF,
	0x96, 0x93,
	0x98, 0xDD,
	0x98, 0xDE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x43,
	0x98, 0xEB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0x6F,
	0xFF, 0xFF,
	0x95, 0x55,
	0x98, 0xE6,
	0xFF, 0xFF,
	0x95, 0xEE,
	0xFF, 0xFF,
	0x89, 0xB4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0xEA,
	0xFA, 0x76
};

static unsigned char low_50[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0xE4,
	0x98, 0xED,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x71,
	0xFF, 0xFF,
	0x8C, 0xC2,
	0xFF, 0xFF,
	0x94, 0x7B,
	0xFF, 0xFF,
	0xE0, 0xC5,
	0xFF, 0xFF,
	0x98, 0xEC,
	0x93, 0x7C,
	0xFF, 0xFF,
	0x98, 0xE1,
	0xFF, 0xFF,
	0x8C, 0xF4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xF3,
	0x98, 0xDF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0x77,
	0x8E, 0xD8,
	0xFF, 0xFF,
	0x98, 0xE7,
	0xFA, 0x75,
	0x95, 0xED,
	0x92, 0x6C,
	0x98, 0xE3,
	0x8C, 0x91,
	0xFF, 0xFF,
	0x98, 0xE0,
	0x98, 0xE8,
	0x98, 0xE2,
	0x97, 0xCF,
	0x98, 0xE9,
	0x98, 0x60,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xE4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x90,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0x74,
	0xFF, 0xFF,
	0xFA, 0x7A,
	0x98, 0xEE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0x78,
	0x98, 0xEF,
	0x98, 0xF3,
	0x88, 0xCC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xCE,
	0x98, 0xF2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0xF1,
	0x98, 0xF5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0xF4,
	0xFF, 0xFF,
	0x92, 0xE2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x92,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0xF6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0x79,
	0xFF, 0xFF,
	0x8E, 0xC3,
	0xFF, 0xFF,
	0x91, 0xA4,
	0x92, 0xE3,
	0x8B, 0xF4,
	0xFF, 0xFF,
	0x98, 0xF7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x55,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0xF8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0xFA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x54,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x86,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0x7B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x50,
	0x94, 0xF5,
	0x98, 0xF9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0xC3,
	0x97, 0x62,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0xFC,
	0x99, 0x42,
	0x98, 0xFB,
	0x8D, 0xC2,
	0xFF, 0xFF,
	0x8F, 0x9D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x58,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0x43,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xCD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0x40,
	0x99, 0x41,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xAD,
	0xFF, 0xFF,
	0x91, 0x9C,
	0xFF, 0xFF,
	0x8B, 0xA1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x6C,
	0x99, 0x44,
	0xFF, 0xFF,
	0xFA, 0x7D,
	0xFF, 0xFF,
	0x97, 0xBB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0x45,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0x48,
	0xFF, 0xFF,
	0x99, 0x46,
	0xFF, 0xFF,
	0x91, 0x6D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0x47,
	0x99, 0x49,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0x7C,
	0x99, 0x4B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0x4A,
	0xFF, 0xFF,
	0x95, 0xC6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_51[512] = {
	0x8B, 0x56,
	0x99, 0x4D,
	0x99, 0x4E,
	0xFF, 0xFF,
	0x89, 0xAD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0x4C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0xF2,
	0xFF, 0xFF,
	0x99, 0x51,
	0x99, 0x50,
	0x99, 0x4F,
	0xFF, 0xFF,
	0x98, 0xD4,
	0xFF, 0xFF,
	0x99, 0x52,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x9E,
	0xFF, 0xFF,
	0x99, 0x53,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x44,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0xD7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0x55,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0x54,
	0x99, 0x57,
	0x99, 0x56,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0x58,
	0x99, 0x59,
	0x88, 0xF2,
	0xFF, 0xFF,
	0x8C, 0xB3,
	0x8C, 0x5A,
	0x8F, 0x5B,
	0x92, 0x9B,
	0x8B, 0xA2,
	0x90, 0xE6,
	0x8C, 0xF5,
	0xFA, 0x7E,
	0x8D, 0x8E,
	0x99, 0x5B,
	0x96, 0xC6,
	0x93, 0x65,
	0xFF, 0xFF,
	0x8E, 0x99,
	0xFF, 0xFF,
	0x99, 0x5A,
	0xFF, 0xFF,
	0x99, 0x5C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x7D,
	0xFF, 0xFF,
	0x8A, 0x95,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0x5D,
	0xFF, 0xFF,
	0xFA, 0x80,
	0x93, 0xFC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x53,
	0x99, 0x5F,
	0x99, 0x60,
	0x94, 0xAA,
	0x8C, 0xF6,
	0x98, 0x5A,
	0x99, 0x61,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xA4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xBA,
	0x91, 0xB4,
	0x8B, 0xEF,
	0x93, 0x54,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x93,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0x62,
	0xFF, 0xFF,
	0x99, 0x63,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xE0,
	0x89, 0x7E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0x66,
	0x8D, 0xFB,
	0xFF, 0xFF,
	0x99, 0x65,
	0x8D, 0xC4,
	0xFF, 0xFF,
	0x99, 0x67,
	0xE3, 0xEC,
	0x99, 0x68,
	0x96, 0x60,
	0x99, 0x69,
	0xFF, 0xFF,
	0x99, 0x6A,
	0x99, 0x6B,
	0x8F, 0xE7,
	0xFF, 0xFF,
	0x8E, 0xCA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0x81,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xA5,
	0xFF, 0xFF,
	0x99, 0x6E,
	0xFF, 0xFF,
	0x99, 0x6C,
	0x96, 0xBB,
	0x99, 0x6D,
	0xFF, 0xFF,
	0x95, 0x79,
	0x99, 0x6F,
	0x99, 0x70,
	0x99, 0x71,
	0x93, 0x7E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0x75,
	0x99, 0x73,
	0x99, 0x74,
	0x99, 0x72,
	0x8D, 0xE1,
	0x99, 0x76,
	0x96, 0xE8,
	0x97, 0xE2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0x77,
	0xFA, 0x82,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0xA6,
	0x99, 0x78,
	0x8F, 0x79,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0x79,
	0xFF, 0xFF,
	0x92, 0x9C,
	0x97, 0xBD,
	0x93, 0x80,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0xC3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0x7A,
	0xEA, 0xA3,
	0x8B, 0xC3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0x7B,
	0x96, 0x7D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x88,
	0x91, 0xFA,
	0xFF, 0xFF,
	0x99, 0x7D,
	0x93, 0xE2,
	0xFF, 0xFF,
	0xFA, 0x83,
	0x99, 0x7E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0x80,
	0x8A, 0x4D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0x81,
	0x8B, 0xA5,
	0xFF, 0xFF,
	0x93, 0xCA,
	0x89, 0x9A,
	0x8F, 0x6F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0x9F,
	0x99, 0x82,
	0xFF, 0xFF
};

static unsigned char low_52[512] = {
	0x93, 0x81,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x6E,
	0x99, 0x83,
	0xFF, 0xFF,
	0x95, 0xAA,
	0x90, 0xD8,
	0x8A, 0xA0,
	0xFF, 0xFF,
	0x8A, 0xA7,
	0x99, 0x84,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0x86,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x59,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0x85,
	0xFA, 0x84,
	0xFF, 0xFF,
	0x97, 0xF1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x89,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xBB,
	0x95, 0xCA,
	0xFF, 0xFF,
	0x99, 0x87,
	0xFF, 0xFF,
	0x97, 0x98,
	0x99, 0x88,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0x89,
	0xFF, 0xFF,
	0x93, 0x9E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0x8A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0xA7,
	0x8D, 0xFC,
	0x8C, 0x94,
	0x99, 0x8B,
	0x8E, 0x68,
	0x8D, 0x8F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0xE4,
	0x99, 0x8D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0xA5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0xED,
	0x99, 0x8E,
	0x99, 0x8F,
	0x91, 0x4F,
	0xFF, 0xFF,
	0x99, 0x8C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0x91,
	0xFF, 0xFF,
	0x96, 0x55,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0x84,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0x90,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x95,
	0x8D, 0xDC,
	0x94, 0x8D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0x94,
	0x99, 0x92,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0x9B,
	0x8F, 0xE8,
	0x99, 0x9B,
	0x8A, 0x84,
	0x99, 0x95,
	0x99, 0x93,
	0x91, 0x6E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0x97,
	0xFF, 0xFF,
	0x99, 0x96,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x63,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x80,
	0x99, 0x9C,
	0x97, 0xAB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0x98,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0x9D,
	0x99, 0x9A,
	0xFF, 0xFF,
	0x99, 0x99,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0xCD,
	0xFA, 0x85,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xF7,
	0x89, 0xC1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0xF2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0x86,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x95,
	0x93, 0x77,
	0x8D, 0x85,
	0x99, 0xA0,
	0x99, 0xA1,
	0xFF, 0xFF,
	0xFB, 0x77,
	0xFF, 0xFF,
	0x97, 0xE3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0x4A,
	0x99, 0xA3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xF8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0xA2,
	0xFF, 0xFF,
	0x8A, 0x4E,
	0xFF, 0xFF,
	0xFA, 0x87,
	0x99, 0xA4,
	0xFF, 0xFF,
	0x96, 0x75,
	0xFF, 0xFF,
	0x92, 0xBA,
	0xFF, 0xFF,
	0x97, 0x45,
	0xFF, 0xFF,
	0x95, 0xD7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0xA5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xD3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xAE,
	0xFF, 0xFF,
	0x99, 0xA6,
	0x8A, 0xA8,
	0x96, 0xB1,
	0xFF, 0xFF,
	0xFA, 0x88,
	0xFF, 0xFF,
	0x8F, 0x9F,
	0x99, 0xA7,
	0x95, 0xE5,
	0x99, 0xAB,
	0xFF, 0xFF,
	0x90, 0xA8,
	0x99, 0xA8,
	0x8B, 0xCE,
	0xFF, 0xFF,
	0x99, 0xA9,
	0x8A, 0xA9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x4D,
	0x99, 0xAC,
	0xFF, 0xFF,
	0x99, 0xAD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0xAE,
	0x99, 0xAF,
	0x8E, 0xD9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xF9,
	0x96, 0xDC
};

static unsigned char low_53[512] = {
	0xFA, 0x89,
	0x96, 0xE6,
	0x93, 0xF5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xEF,
	0x99, 0xB0,
	0xFA, 0x8A,
	0x99, 0xB1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0xB3,
	0xFF, 0xFF,
	0x99, 0xB5,
	0x99, 0xB4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0xB6,
	0x89, 0xBB,
	0x96, 0x6B,
	0xFF, 0xFF,
	0x8D, 0xFA,
	0x99, 0xB7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x78,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0xA0,
	0x8B, 0xA7,
	0xFF, 0xFF,
	0x99, 0xB8,
	0xFA, 0x8B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xD9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0xB9,
	0xFF, 0xFF,
	0x99, 0xBA,
	0xFF, 0xFF,
	0x99, 0xBB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0xBC,
	0x95, 0x43,
	0x8B, 0xE6,
	0x88, 0xE3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xBD,
	0x99, 0xBD,
	0x8F, 0x5C,
	0xFF, 0xFF,
	0x90, 0xE7,
	0xFF, 0xFF,
	0x99, 0xBF,
	0x99, 0xBE,
	0x8F, 0xA1,
	0x8C, 0xDF,
	0x99, 0xC1,
	0x94, 0xBC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0xC2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xDA,
	0x91, 0xB2,
	0x91, 0xEC,
	0x8B, 0xA6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xEC,
	0x92, 0x50,
	0xFF, 0xFF,
	0x94, 0x8E,
	0xFF, 0xFF,
	0x96, 0x6D,
	0xFF, 0xFF,
	0x99, 0xC4,
	0xFF, 0xFF,
	0x90, 0xE8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x54,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0xC5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0xC6,
	0x89, 0x4B,
	0x88, 0xF3,
	0x8A, 0xEB,
	0xFA, 0x8C,
	0x91, 0xA6,
	0x8B, 0x70,
	0x97, 0x91,
	0xFF, 0xFF,
	0x99, 0xC9,
	0x89, 0xB5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0xC8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xA8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0xCA,
	0xFF, 0xFF,
	0x96, 0xEF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0x8D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0xCB,
	0xFF, 0xFF,
	0x97, 0xD0,
	0xFF, 0xFF,
	0x8C, 0xFA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xB4,
	0x99, 0xCC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0xCE,
	0x99, 0xCD,
	0xFF, 0xFF,
	0x90, 0x7E,
	0x89, 0x58,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x7D,
	0x99, 0xCF,
	0xFF, 0xFF,
	0x99, 0xD0,
	0xFF, 0xFF,
	0xFA, 0x8E,
	0x8C, 0xB5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0xD1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x8E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x51,
	0x99, 0xD2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x94,
	0x8D, 0xB3,
	0x8B, 0x79,
	0x97, 0x46,
	0x91, 0x6F,
	0x94, 0xBD,
	0x8E, 0xFB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x66,
	0xFF, 0xFF,
	0x8E, 0xE6,
	0x8E, 0xF3,
	0xFF, 0xFF,
	0x8F, 0x96,
	0xFF, 0xFF,
	0x94, 0xBE,
	0xFF, 0xFF,
	0xFA, 0x8F,
	0xFF, 0xFF,
	0x99, 0xD5,
	0xFF, 0xFF,
	0x89, 0x62,
	0x91, 0x70,
	0x8C, 0xFB,
	0x8C, 0xC3,
	0x8B, 0xE5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0xD9,
	0x92, 0x40,
	0x91, 0xFC,
	0x8B, 0xA9,
	0x8F, 0xA2,
	0x99, 0xDA,
	0x99, 0xD8,
	0x89, 0xC2,
	0x91, 0xE4,
	0x8E, 0xB6,
	0x8E, 0x6A,
	0x89, 0x45,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x90,
	0x8D, 0x86,
	0x8E, 0x69,
	0xFF, 0xFF,
	0x99, 0xDB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_54[512] = {
	0xFF, 0xFF,
	0x99, 0xDC,
	0xFF, 0xFF,
	0x8B, 0x68,
	0x8A, 0x65,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0x87,
	0x8B, 0x67,
	0x92, 0xDD,
	0x89, 0x44,
	0x93, 0xAF,
	0x96, 0xBC,
	0x8D, 0x40,
	0x97, 0x99,
	0x93, 0x66,
	0x8C, 0xFC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x4E,
	0xFF, 0xFF,
	0x99, 0xE5,
	0xFF, 0xFF,
	0x8B, 0xE1,
	0x96, 0x69,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xDB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0xE4,
	0xFF, 0xFF,
	0x8A, 0xDC,
	0x99, 0xDF,
	0x99, 0xE0,
	0x99, 0xE2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0xE3,
	0xFF, 0xFF,
	0x8B, 0x7A,
	0x90, 0x81,
	0xFF, 0xFF,
	0x95, 0xAB,
	0x99, 0xE1,
	0x99, 0xDD,
	0x8C, 0xE1,
	0xFF, 0xFF,
	0x99, 0xDE,
	0xFF, 0xFF,
	0x98, 0x43,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xF0,
	0xFF, 0xFF,
	0x92, 0xE6,
	0x8C, 0xE0,
	0x8D, 0x90,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0xE6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xDB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0xEA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0xFC,
	0xFF, 0xFF,
	0x8E, 0xF4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0xED,
	0x99, 0xEB,
	0xFF, 0xFF,
	0x96, 0xA1,
	0xFF, 0xFF,
	0x99, 0xE8,
	0x99, 0xF1,
	0x99, 0xEC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0xEF,
	0x8C, 0xC4,
	0x96, 0xBD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0xF0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0xF2,
	0xFF, 0xFF,
	0x99, 0xF4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0x92,
	0x8D, 0xEE,
	0x98, 0x61,
	0xFF, 0xFF,
	0x99, 0xE9,
	0x99, 0xE7,
	0x99, 0xF3,
	0xFF, 0xFF,
	0x99, 0xEE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0x91,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0xF6,
	0xFF, 0xFF,
	0x9A, 0x42,
	0x99, 0xF8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0xFC,
	0xFA, 0x93,
	0xFF, 0xFF,
	0x9A, 0x40,
	0x99, 0xF9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x5D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0xE7,
	0x8A, 0x50,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0xF7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x44,
	0x88, 0xF4,
	0x9A, 0x43,
	0xFF, 0xFF,
	0x88, 0xA3,
	0x95, 0x69,
	0x9A, 0x41,
	0xFF, 0xFF,
	0x99, 0xFA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0xF5,
	0x99, 0xFB,
	0x8D, 0xC6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x45,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x88, 0xF5,
	0x9A, 0x4E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x46,
	0x9A, 0x47,
	0xFF, 0xFF,
	0x8F, 0xA3,
	0x96, 0x89,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x4C,
	0x9A, 0x4B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x4E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x4D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x4A,
	0xFF, 0xFF,
	0xFA, 0x94
};

static unsigned char low_55[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x53,
	0xFF, 0xFF,
	0x8D, 0xB4,
	0x90, 0x4F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x48,
	0x93, 0x82,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x49,
	0xFF, 0xFF,
	0x88, 0xA0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x53,
	0x97, 0x42,
	0xFF, 0xFF,
	0x8F, 0xA5,
	0xFF, 0xFF,
	0x9A, 0x59,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x58,
	0x9A, 0x4F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0xC1,
	0xFF, 0xFF,
	0x9A, 0x50,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0xED,
	0x9A, 0x55,
	0x8F, 0xA4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x52,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0xE2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x5B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x56,
	0x9A, 0x57,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x54,
	0x9A, 0x5A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x51,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x60,
	0x9A, 0x65,
	0xFF, 0xFF,
	0x9A, 0x61,
	0xFF, 0xFF,
	0x9A, 0x5C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x66,
	0x91, 0x50,
	0xFF, 0xFF,
	0xFA, 0x95,
	0x9A, 0x68,
	0xFF, 0xFF,
	0x8D, 0x41,
	0x9A, 0x5E,
	0x92, 0x9D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x62,
	0x9A, 0x5B,
	0x8A, 0xAB,
	0xFF, 0xFF,
	0x8A, 0xEC,
	0x8A, 0x85,
	0x9A, 0x63,
	0x9A, 0x5F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x96,
	0x9A, 0x69,
	0x9A, 0x67,
	0x91, 0x72,
	0x8B, 0x69,
	0x8B, 0xAA,
	0xFF, 0xFF,
	0x9A, 0x64,
	0xFF, 0xFF,
	0x8B, 0xF2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x63,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x6D,
	0x9A, 0x6B,
	0xFF, 0xFF,
	0x9A, 0xA5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x70,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x6A,
	0xFF, 0xFF,
	0x9A, 0x6E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x6C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x6B,
	0x9A, 0x6F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x72,
	0xFF, 0xFF,
	0x9A, 0x77,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x75,
	0x9A, 0x74,
	0xFF, 0xFF
};

static unsigned char low_56[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x51,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xC3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x71,
	0xFF, 0xFF,
	0x9A, 0x73,
	0x8F, 0xA6,
	0x89, 0x52,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x76,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xDC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x82,
	0xFF, 0xFF,
	0x8F, 0xFA,
	0x9A, 0x7D,
	0xFF, 0xFF,
	0x9A, 0x7B,
	0xFF, 0xFF,
	0x9A, 0x7C,
	0xFF, 0xFF,
	0x9A, 0x7E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x5C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x58,
	0xFF, 0xFF,
	0x9A, 0x78,
	0xFF, 0xFF,
	0x9A, 0x79,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x9A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x81,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xED,
	0xFF, 0xFF,
	0x9A, 0x84,
	0x9A, 0x80,
	0x9A, 0x83,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xAC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xD3,
	0xFF, 0xFF,
	0x94, 0xB6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x86,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x85,
	0x8A, 0x64,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x87,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x8A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x89,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x88,
	0xFF, 0xFF,
	0x94, 0x58,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x8B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x8C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x8E,
	0xFF, 0xFF,
	0x9A, 0x8D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x90,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x93,
	0x9A, 0x91,
	0x9A, 0x8F,
	0x9A, 0x92,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x94,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x95,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x96,
	0xFF, 0xFF,
	0x9A, 0x97,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x98,
	0x99, 0x64,
	0xFF, 0xFF,
	0x8E, 0xFA,
	0x8E, 0x6C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xF1,
	0xFF, 0xFF,
	0x88, 0xF6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x63,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x99,
	0xFF, 0xFF,
	0x8D, 0xA2,
	0xFF, 0xFF,
	0x88, 0xCD,
	0x90, 0x7D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x9A,
	0x8C, 0xC5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0x91,
	0xFF, 0xFF,
	0x9A, 0x9C
};

static unsigned char low_57[512] = {
	0x9A, 0x9B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xDE,
	0x9A, 0x9D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x9F,
	0x9A, 0x9E,
	0xFF, 0xFF,
	0x9A, 0xA0,
	0xFF, 0xFF,
	0x9A, 0xA1,
	0xFF, 0xFF,
	0x8C, 0x97,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x80,
	0x9A, 0xA2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xA4,
	0xFF, 0xFF,
	0x9A, 0xA3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xA6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x79,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xA7,
	0x88, 0xB3,
	0x8D, 0xDD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x5C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x6E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xA8,
	0x9A, 0xA9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xAB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xAC,
	0xFF, 0xFF,
	0x8D, 0xE2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xCF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x56,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xAA,
	0x9A, 0xAD,
	0x8D, 0xBF,
	0x8D, 0x42,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0x96,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xB1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0xA3,
	0xFA, 0x97,
	0x92, 0x52,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xAE,
	0x92, 0xD8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xB2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x82,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xB0,
	0x9A, 0xB3,
	0xFF, 0xFF,
	0x8C, 0x5E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xB4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xB5,
	0xFF, 0xFF,
	0x8D, 0x43,
	0x8A, 0x5F,
	0x9A, 0xB7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xB8,
	0xFF, 0xFF,
	0xFA, 0x98,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xB9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xB6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xAF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xBA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xBB,
	0xFA, 0x9A,
	0xFA, 0x99,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x84,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0xE9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xBD,
	0x9A, 0xBE,
	0x9A, 0xBC,
	0xFF, 0xFF,
	0x9A, 0xC0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0x57,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x88, 0xE6,
	0x95, 0x75,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xC1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0xFB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0xB7,
	0xFF, 0xFF,
	0x94, 0x7C,
	0x8A, 0xEE,
	0xFF, 0xFF,
	0x8D, 0xE9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_58[512] = {
	0x96, 0x78,
	0xFF, 0xFF,
	0x93, 0xB0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x98,
	0x91, 0xCD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xBF,
	0x9A, 0xC2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0xC2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xC3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xC4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xC6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0xE7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xAC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x9F,
	0x89, 0x81,
	0x95, 0xF1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0xEA,
	0x93, 0x67,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0xE4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xCC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xBB,
	0x97, 0xDB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xF2,
	0x9A, 0xC8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x59,
	0x9A, 0xCB,
	0xFF, 0xFF,
	0x93, 0x83,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x68,
	0x93, 0x84,
	0x94, 0xB7,
	0x92, 0xCB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0xC7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xC7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x96,
	0xFF, 0xFF,
	0x93, 0x55,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xC9,
	0xFF, 0xFF,
	0x9A, 0xC5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x6F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xCD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x6D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xAB,
	0xFF, 0xFF,
	0x9A, 0xCE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xE6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x9D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0xC4,
	0xFF, 0xFF,
	0xFA, 0x9D,
	0x9A, 0xD0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x6E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xD1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xD6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0x9E,
	0x95, 0xAD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xD5,
	0x9A, 0xCF,
	0x9A, 0xD2,
	0x9A, 0xD4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0xA4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xC7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xD7,
	0xFF, 0xFF,
	0x92, 0x64,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xF3,
	0xFF, 0xFF,
	0x8F, 0xEB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xD9,
	0xFF, 0xFF,
	0x9A, 0xD8,
	0xFF, 0xFF,
	0x8D, 0x88,
	0xFF, 0xFF,
	0x9A, 0xDA,
	0x9A, 0xDC,
	0x9A, 0xDB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xDE,
	0xFF, 0xFF,
	0x9A, 0xD3,
	0x9A, 0xE0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xDF,
	0x9A, 0xDD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x6D,
	0x90, 0x70,
	0xFF, 0xFF,
	0x91, 0x73,
	0x9A, 0xE1,
	0x90, 0xBA,
	0x88, 0xEB,
	0x94, 0x84,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0xD9,
	0xFF, 0xFF,
	0x9A, 0xE3,
	0x9A, 0xE2,
	0x9A, 0xE4,
	0x9A, 0xE5,
	0x9A, 0xE6,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_59[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xE7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xCF,
	0x9A, 0xE8,
	0xFA, 0x9F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xC4,
	0x9A, 0xE9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x5B,
	0x8A, 0x4F,
	0xFF, 0xFF,
	0x99, 0xC7,
	0x8F, 0x67,
	0x91, 0xBD,
	0x9A, 0xEA,
	0x96, 0xE9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0xB2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xEC,
	0xFF, 0xFF,
	0x91, 0xE5,
	0xFF, 0xFF,
	0x93, 0x56,
	0x91, 0xBE,
	0x95, 0x76,
	0x9A, 0xED,
	0x9A, 0xEE,
	0x89, 0x9B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0xB8,
	0x9A, 0xEF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x88, 0xCE,
	0x9A, 0xF0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xF1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x82,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xEF,
	0x93, 0xDE,
	0x95, 0xF2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xF5,
	0x91, 0x74,
	0x9A, 0xF4,
	0x8C, 0x5F,
	0xFF, 0xFF,
	0xFA, 0xA0,
	0x96, 0x7A,
	0x9A, 0xF3,
	0xFF, 0xFF,
	0x93, 0x85,
	0x9A, 0xF7,
	0xFF, 0xFF,
	0x9A, 0xF6,
	0xFA, 0xA1,
	0xFF, 0xFF,
	0xFA, 0xA2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xF9,
	0xFF, 0xFF,
	0x9A, 0xF8,
	0xFA, 0xA3,
	0xFF, 0xFF,
	0x89, 0x9C,
	0xFF, 0xFF,
	0x9A, 0xFA,
	0x8F, 0xA7,
	0x9A, 0xFC,
	0x92, 0x44,
	0xFF, 0xFF,
	0x9A, 0xFB,
	0xFF, 0xFF,
	0x95, 0xB1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x97,
	0x93, 0x7A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x40,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0x44,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x41,
	0x94, 0x40,
	0x94, 0xDC,
	0x96, 0xCF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0x44,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x4A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x57,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x64,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0xAD,
	0xFF, 0xFF,
	0x9B, 0xAA,
	0xFF, 0xFF,
	0x9B, 0x42,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x45,
	0xFA, 0xA4,
	0x91, 0xC3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x57,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x69,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x46,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x85,
	0xFA, 0xA5,
	0x8D, 0xC8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0xA8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x47,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x6F,
	0xFF, 0xFF,
	0x8E, 0x6E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x88, 0xB7,
	0x8C, 0xC6,
	0xFF, 0xFF,
	0x90, 0xA9,
	0x88, 0xCF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x4B,
	0x9B, 0x4C,
	0xFF, 0xFF,
	0x9B, 0x49,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x57,
	0x8A, 0xAD,
	0xFF, 0xFF,
	0x9B, 0x48,
	0xFF, 0xFF,
	0x96, 0xC3,
	0x95, 0x50,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x88, 0xA6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x88, 0xF7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x70
};

static unsigned char low_5A[512] = {
	0xFF, 0xFF,
	0x88, 0xD0,
	0xFF, 0xFF,
	0x88, 0xA1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x51,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x4F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0xBA,
	0xFF, 0xFF,
	0x9B, 0x52,
	0xFF, 0xFF,
	0x9B, 0x50,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x4E,
	0x90, 0x50,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x4D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xD8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xE2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x56,
	0x9B, 0x57,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0xA9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x53,
	0x98, 0x4B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0x6B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x55,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0xA5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x58,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0x77,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x59,
	0xFF, 0xFF,
	0x9B, 0x54,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0xB9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0x7D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x5A,
	0x95, 0x51,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x5B,
	0x9B, 0x5F,
	0x9B, 0x5C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xC5,
	0x9B, 0x5E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0xB9,
	0xFF, 0xFF,
	0x9B, 0x5D,
	0x8C, 0x99,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x6B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x64,
	0x9B, 0x61,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x84,
	0xFF, 0xFF,
	0x9B, 0x60,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x62,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x63,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x65,
	0x9B, 0x66,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_5B[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xF0,
	0xFF, 0xFF,
	0x9B, 0x68,
	0x9B, 0x67,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x69,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0xEC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x6C,
	0xFF, 0xFF,
	0x92, 0xDA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x64,
	0xFF, 0xFF,
	0x9B, 0x6A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x6D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x6E,
	0xFF, 0xFF,
	0x9B, 0x71,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x6F,
	0xFF, 0xFF,
	0x9B, 0x70,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x71,
	0x9B, 0x72,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0x45,
	0x9B, 0x73,
	0xFA, 0xA6,
	0x8E, 0x9A,
	0x91, 0xB6,
	0xFF, 0xFF,
	0x9B, 0x74,
	0x9B, 0x75,
	0x8E, 0x79,
	0x8D, 0x46,
	0xFF, 0xFF,
	0x96, 0xD0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x47,
	0x8C, 0xC7,
	0x9B, 0x76,
	0x8A, 0x77,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x77,
	0xFF, 0xFF,
	0x91, 0xB7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x78,
	0x9B, 0xA1,
	0xFF, 0xFF,
	0x9B, 0x79,
	0xFF, 0xFF,
	0x9B, 0x7A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x7B,
	0xFF, 0xFF,
	0x9B, 0x7D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x7E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x80,
	0xFF, 0xFF,
	0x91, 0xEE,
	0xFF, 0xFF,
	0x89, 0x46,
	0x8E, 0xE7,
	0x88, 0xC0,
	0xFF, 0xFF,
	0x91, 0x76,
	0x8A, 0xAE,
	0x8E, 0xB3,
	0xFF, 0xFF,
	0x8D, 0x47,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x86,
	0xFF, 0xFF,
	0x8F, 0x40,
	0x8A, 0xAF,
	0x92, 0x88,
	0x92, 0xE8,
	0x88, 0xB6,
	0x8B, 0x58,
	0x95, 0xF3,
	0xFF, 0xFF,
	0x8E, 0xC0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x71,
	0x90, 0xE9,
	0x8E, 0xBA,
	0x97, 0x47,
	0x9B, 0x81,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x7B,
	0xFF, 0xFF,
	0x8D, 0xC9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x51,
	0x89, 0x83,
	0x8F, 0xAA,
	0x89, 0xC6,
	0xFF, 0xFF,
	0x9B, 0x82,
	0x97, 0x65,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x68,
	0xFA, 0xA7,
	0xFF, 0xFF,
	0x8E, 0xE2,
	0x9B, 0x83,
	0x8A, 0xF1,
	0x93, 0xD0,
	0x96, 0xA7,
	0x9B, 0x84,
	0xFF, 0xFF,
	0x9B, 0x85,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0x78,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x87,
	0xFF, 0xFF,
	0x8A, 0xA6,
	0x8B, 0xF5,
	0x9B, 0x86,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0xA9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xB0,
	0xFF, 0xFF,
	0x90, 0x51,
	0x9B, 0x8B,
	0x8E, 0x40,
	0xFF, 0xFF,
	0x89, 0xC7,
	0x9B, 0x8A,
	0xFF, 0xFF,
	0x9B, 0x88,
	0x9B, 0x8C,
	0x9B, 0x89,
	0x94, 0x4A,
	0x9E, 0xCB,
	0x90, 0x52,
	0xFF, 0xFF,
	0x9B, 0x8D,
	0xFA, 0xAA,
	0xFF, 0xFF,
	0x97, 0xBE,
	0xFF, 0xFF,
	0x9B, 0x8E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x90,
	0xFF, 0xFF,
	0x92, 0x9E,
	0x9B, 0x8F,
	0xFF, 0xFF,
	0x90, 0xA1,
	0xFF, 0xFF,
	0x8E, 0x9B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0xCE,
	0x8E, 0xF5
};

static unsigned char low_5C[512] = {
	0xFF, 0xFF,
	0x95, 0x95,
	0x90, 0xEA,
	0xFF, 0xFF,
	0x8E, 0xCB,
	0x9B, 0x91,
	0x8F, 0xAB,
	0x9B, 0x92,
	0x9B, 0x93,
	0x88, 0xD1,
	0x91, 0xB8,
	0x90, 0x71,
	0xFF, 0xFF,
	0x9B, 0x94,
	0x93, 0xB1,
	0x8F, 0xAC,
	0xFF, 0xFF,
	0x8F, 0xAD,
	0xFF, 0xFF,
	0x9B, 0x95,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0xEB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0xAE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0xAB,
	0xFF, 0xFF,
	0x9B, 0x96,
	0xFF, 0xFF,
	0x9B, 0x97,
	0xFF, 0xFF,
	0x96, 0xDE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x98,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xC4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x41,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0x99,
	0x9B, 0x9A,
	0x8E, 0xDA,
	0x90, 0x4B,
	0x93, 0xF2,
	0x90, 0x73,
	0x94, 0xF6,
	0x94, 0x41,
	0x8B, 0xC7,
	0x9B, 0x9B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x8F,
	0x9B, 0x9C,
	0xFF, 0xFF,
	0x8B, 0xFC,
	0xFF, 0xFF,
	0x93, 0xCD,
	0x89, 0xAE,
	0xFF, 0xFF,
	0x8E, 0x72,
	0x9B, 0x9D,
	0x9B, 0xA0,
	0x9B, 0x9F,
	0x8B, 0xFB,
	0xFF, 0xFF,
	0x9B, 0x9E,
	0xFF, 0xFF,
	0x93, 0x57,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0xAE,
	0xFF, 0xFF,
	0x93, 0x6A,
	0x8E, 0xC6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x77,
	0x97, 0x9A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xA2,
	0xFF, 0xFF,
	0x9B, 0xA3,
	0x93, 0xD4,
	0xFF, 0xFF,
	0x8E, 0x52,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xA5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xA6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xA7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xF2,
	0x9B, 0xA8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xA9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xAA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0xAC,
	0xFF, 0xFF,
	0x91, 0x5A,
	0x8A, 0xE2,
	0xFF, 0xFF,
	0x9B, 0xAB,
	0x96, 0xA6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0xD0,
	0xFF, 0xFF,
	0x8A, 0x78,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xAD,
	0x9B, 0xAF,
	0x8A, 0xDD,
	0xFF, 0xFF,
	0xFA, 0xAD,
	0x9B, 0xAC,
	0x9B, 0xAE,
	0xFF, 0xFF,
	0x9B, 0xB1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xB0,
	0xFF, 0xFF,
	0x9B, 0xB2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xB3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xBB,
	0x8B, 0xAC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xE3,
	0x9B, 0xB4,
	0x9B, 0xB9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xB7,
	0xFF, 0xFF,
	0x95, 0xF5,
	0x95, 0xF4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0xAE,
	0x93, 0x87,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xB6,
	0x8F, 0x73,
	0xFF, 0xFF,
	0x9B, 0xB5,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_5D[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x92,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xBA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0xE8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xC0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xC1,
	0x9B, 0xBB,
	0x8A, 0x52,
	0x9B, 0xBC,
	0x9B, 0xC5,
	0x9B, 0xC4,
	0x9B, 0xC3,
	0x9B, 0xBF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xBE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xC2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0xAF,
	0xFF, 0xFF,
	0x95, 0xF6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0xB2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xC9,
	0x9B, 0xC6,
	0xFF, 0xFF,
	0x9B, 0xC8,
	0xFF, 0xFF,
	0x97, 0x92,
	0xFF, 0xFF,
	0x9B, 0xC7,
	0xFA, 0xB0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xBD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x93,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xCA,
	0xFA, 0xB3,
	0xFF, 0xFF,
	0x8D, 0xB5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xCB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xCC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xCF,
	0xFF, 0xFF,
	0x9B, 0xCE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xCD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x88,
	0x9B, 0xB8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xD5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xD1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xD0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xD2,
	0xFF, 0xFF,
	0x9B, 0xD3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xD6,
	0xFA, 0xB4,
	0xFA, 0xB5,
	0x97, 0xE4,
	0xFF, 0xFF,
	0x9B, 0xD7,
	0x9B, 0xD4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xD8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xDE,
	0x9B, 0xD9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0xB6,
	0xFF, 0xFF,
	0x9B, 0xDB,
	0x9B, 0xDA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xDC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xDD,
	0xFF, 0xFF,
	0x90, 0xEC,
	0x8F, 0x42,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x84,
	0xFF, 0xFF,
	0x91, 0x83,
	0xFF, 0xFF,
	0x8D, 0x48,
	0x8D, 0xB6,
	0x8D, 0x49,
	0x8B, 0x90,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xDE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0xB7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xC8,
	0x9B, 0xDF,
	0x96, 0xA4,
	0x94, 0x62,
	0x9B, 0xE0,
	0xFF, 0xFF,
	0x8D, 0x4A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xAA,
	0xFF, 0xFF,
	0x92, 0x46,
	0x8B, 0xD0,
	0xFF, 0xFF
};

static unsigned char low_5E[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x73,
	0x95, 0x7A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xBF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xE1,
	0x8A, 0xF3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xE4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x9F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xE3,
	0x9B, 0xE2,
	0x9B, 0xE5,
	0xFF, 0xFF,
	0x92, 0xE9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x83,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x74,
	0xFF, 0xFF,
	0x90, 0xC8,
	0xFF, 0xFF,
	0x91, 0xD1,
	0x8B, 0x41,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0xA0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xE6,
	0x9B, 0xE7,
	0x8F, 0xED,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x58,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xEA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xE9,
	0x9B, 0xE8,
	0x95, 0x9D,
	0xFF, 0xFF,
	0x9B, 0xF1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x79,
	0xFF, 0xFF,
	0x9B, 0xEB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xED,
	0x96, 0x8B,
	0xFF, 0xFF,
	0x9B, 0xEC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xEE,
	0xFF, 0xFF,
	0x94, 0xA6,
	0x9B, 0xEF,
	0x95, 0xBC,
	0x9B, 0xF0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xB1,
	0x95, 0xBD,
	0x94, 0x4E,
	0x9B, 0xF2,
	0x9B, 0xF3,
	0xFF, 0xFF,
	0x8D, 0x4B,
	0x8A, 0xB2,
	0x9B, 0xF4,
	0x8C, 0xB6,
	0x97, 0x63,
	0x97, 0x48,
	0x8A, 0xF4,
	0x9B, 0xF6,
	0xFF, 0xFF,
	0x92, 0xA1,
	0xFF, 0xFF,
	0x8D, 0x4C,
	0x8F, 0xAF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xDD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0xB0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x98,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0xEA,
	0x95, 0xF7,
	0x93, 0x58,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0x4D,
	0xFF, 0xFF,
	0x95, 0x7B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xF7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x78,
	0x8D, 0xC0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xC9,
	0xFF, 0xFF,
	0x92, 0xEB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x88, 0xC1,
	0x8F, 0x8E,
	0x8D, 0x4E,
	0x97, 0x66,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xF8,
	0x9B, 0xF9,
	0x94, 0x70,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xFA,
	0x97, 0xF5,
	0x98, 0x4C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9B, 0xFC,
	0x9B, 0xFB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x66,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x40,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x43,
	0x9C, 0x44,
	0xFF, 0xFF,
	0x9C, 0x42,
	0xFF, 0xFF,
	0x95, 0x5F,
	0x8F, 0xB1,
	0x9C, 0x46,
	0x9C, 0x45,
	0x9C, 0x41,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x47,
	0x9C, 0x48,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x49,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x4C,
	0x9C, 0x4A,
	0xFF, 0xFF,
	0x9C, 0x4B,
	0x9C, 0x4D,
	0xFF, 0xFF,
	0x89, 0x84,
	0x92, 0xEC,
	0x9C, 0x4E,
	0xFF, 0xFF,
	0x8C, 0x9A,
	0x89, 0xF4,
	0x94, 0x55,
	0xFF, 0xFF,
	0x9C, 0x4F,
	0x93, 0xF9
};

static unsigned char low_5F[512] = {
	0xFF, 0xFF,
	0x95, 0xD9,
	0xFF, 0xFF,
	0x9C, 0x50,
	0x98, 0x4D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x51,
	0x95, 0xBE,
	0x9C, 0x54,
	0x98, 0x9F,
	0x98, 0xAF,
	0xFF, 0xFF,
	0x8E, 0xAE,
	0x93, 0xF3,
	0x9C, 0x55,
	0xFF, 0xFF,
	0x8B, 0x7C,
	0x92, 0xA2,
	0x88, 0xF8,
	0x9C, 0x56,
	0x95, 0xA4,
	0x8D, 0x4F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x6F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0xED,
	0xFF, 0xFF,
	0xFA, 0xB7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0xED,
	0x8C, 0xB7,
	0x8C, 0xCA,
	0xFF, 0xFF,
	0x9C, 0x57,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x58,
	0xFF, 0xFF,
	0x9C, 0x5E,
	0xFF, 0xFF,
	0x8E, 0xE3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0xB8,
	0x92, 0xA3,
	0xFF, 0xFF,
	0x8B, 0xAD,
	0x9C, 0x59,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0x4A,
	0xFF, 0xFF,
	0x92, 0x65,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x5A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0x67,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x5B,
	0xFF, 0xFF,
	0x8B, 0xAE,
	0xFF, 0xFF,
	0x9C, 0x5C,
	0xFF, 0xFF,
	0x9C, 0x5D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x5F,
	0xFF, 0xFF,
	0x93, 0x96,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x60,
	0x9C, 0x61,
	0xFF, 0xFF,
	0x9C, 0x62,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x53,
	0x9C, 0x52,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x63,
	0x8C, 0x60,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0x46,
	0xFA, 0xB9,
	0xFF, 0xFF,
	0x8D, 0xCA,
	0x95, 0x56,
	0x92, 0xA4,
	0x95, 0x6A,
	0x9C, 0x64,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0xB2,
	0x89, 0x65,
	0xFF, 0xFF,
	0x9C, 0x65,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x66,
	0xFF, 0xFF,
	0x96, 0xF0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xDE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x69,
	0x89, 0x9D,
	0x90, 0xAA,
	0x9C, 0x68,
	0x9C, 0x67,
	0x8C, 0x61,
	0x91, 0xD2,
	0xFF, 0xFF,
	0x9C, 0x6D,
	0x9C, 0x6B,
	0xFF, 0xFF,
	0x9C, 0x6A,
	0x97, 0xA5,
	0x8C, 0xE3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x99,
	0x9C, 0x6C,
	0x93, 0x6B,
	0x8F, 0x5D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xBE,
	0x9C, 0x70,
	0x9C, 0x6F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x6E,
	0xFF, 0xFF,
	0x9C, 0x71,
	0x8C, 0xE4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x72,
	0x95, 0x9C,
	0x8F, 0x7A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x73,
	0x94, 0xF7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xBF,
	0x92, 0xA5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0xBA,
	0xFF, 0xFF,
	0x93, 0x4F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x74,
	0x8B, 0x4A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x53,
	0xFF, 0xFF,
	0x95, 0x4B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xF5,
	0x94, 0x45,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x75,
	0x8E, 0x75,
	0x96, 0x59,
	0x96, 0x5A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x9E,
	0x9C, 0x7A,
	0xFA, 0xBB,
	0xFF, 0xFF,
	0x92, 0x89,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x77,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xF5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0xAB,
	0x9C, 0x79,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0x4F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x78,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x76,
	0xFF, 0xFF,
	0x8D, 0x9A,
	0xFF, 0xFF,
	0x9C, 0x7C
};

static unsigned char low_60[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x83,
	0x9C, 0x89,
	0x9C, 0x81,
	0xFF, 0xFF,
	0x93, 0x7B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x86,
	0x95, 0x7C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x80,
	0xFF, 0xFF,
	0x9C, 0x85,
	0x97, 0xE5,
	0x8E, 0x76,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0xD3,
	0x9C, 0x7D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x7D,
	0x9C, 0x88,
	0x90, 0xAB,
	0x89, 0x85,
	0x9C, 0x82,
	0x89, 0xF6,
	0x9C, 0x87,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xAF,
	0xFF, 0xFF,
	0x9C, 0x84,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x8A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x8C,
	0x9C, 0x96,
	0x9C, 0x94,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x91,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x90,
	0x97, 0xF6,
	0xFF, 0xFF,
	0x9C, 0x92,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xB0,
	0xFF, 0xFF,
	0x8D, 0x50,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x9A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x99,
	0x9C, 0x8B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0xBC,
	0xFF, 0xFF,
	0x9C, 0x8F,
	0x9C, 0x7E,
	0xFF, 0xFF,
	0x89, 0xF8,
	0x9C, 0x93,
	0x9C, 0x95,
	0x92, 0x70,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0xA6,
	0x89, 0xB6,
	0x9C, 0x8D,
	0x9C, 0x98,
	0x9C, 0x97,
	0x8B, 0xB1,
	0xFF, 0xFF,
	0x91, 0xA7,
	0x8A, 0x86,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x62,
	0xFF, 0xFF,
	0x9C, 0x8E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x9A,
	0xFF, 0xFF,
	0x9C, 0x9D,
	0x9C, 0x9F,
	0xFA, 0xBD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0xBB,
	0xFA, 0xBE,
	0x9C, 0xA5,
	0x92, 0xEE,
	0x9C, 0x9B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0xA3,
	0xFF, 0xFF,
	0x89, 0xF7,
	0xFF, 0xFF,
	0x9C, 0xA1,
	0x9C, 0xA2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x9E,
	0x9C, 0xA0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xE5,
	0x97, 0x49,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xB3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x78,
	0x9C, 0xA4,
	0xFF, 0xFF,
	0x94, 0x59,
	0x88, 0xAB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xDF,
	0x9C, 0x7B,
	0x9C, 0xAA,
	0x9C, 0xAE,
	0x96, 0xE3,
	0xFF, 0xFF,
	0x9C, 0xA7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x89,
	0x9C, 0xAC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0xEE,
	0x9C, 0xAD,
	0x93, 0xD5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0x66,
	0xFF, 0xFF,
	0x9C, 0xA9,
	0xFF, 0xFF,
	0xFA, 0xC0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0xAF,
	0xFF, 0xFF,
	0x8D, 0x9B,
	0xFF, 0xFF,
	0x90, 0xC9,
	0xFF, 0xFF,
	0xFA, 0xBF,
	0x88, 0xD2,
	0x9C, 0xA8,
	0x9C, 0xA6,
	0xFF, 0xFF,
	0x91, 0x79,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0x9C,
	0x8E, 0x53,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0xC4,
	0x9C, 0xBB,
	0xFA, 0xC2,
	0x91, 0x7A,
	0x9C, 0xB6,
	0xFF, 0xFF,
	0x9C, 0xB3,
	0x9C, 0xB4,
	0xFF, 0xFF,
	0x8E, 0xE4,
	0x9C, 0xB7,
	0x9C, 0xBA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_61[512] = {
	0x9C, 0xB5,
	0x8F, 0x44,
	0xFF, 0xFF,
	0x9C, 0xB8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0xB2,
	0xFF, 0xFF,
	0x96, 0xFA,
	0x96, 0xF9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0xBC,
	0x9C, 0xBD,
	0x88, 0xD3,
	0xFF, 0xFF,
	0xFA, 0xC3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0xB1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xF0,
	0x88, 0xA4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xB4,
	0xFA, 0xC1,
	0x9C, 0xB9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0xC1,
	0x9C, 0xC0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0xC5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0xC5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0xC6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0xC4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0xC4,
	0x9C, 0xC7,
	0x9C, 0xBF,
	0x9C, 0xC3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0xC8,
	0xFF, 0xFF,
	0x9C, 0xC9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0xBE,
	0x8E, 0x9C,
	0xFF, 0xFF,
	0x9C, 0xC2,
	0x91, 0xD4,
	0x8D, 0x51,
	0x9C, 0xB0,
	0x90, 0x54,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0xD6,
	0xFF, 0xFF,
	0x95, 0xE7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0xCC,
	0x9C, 0xCD,
	0x9C, 0xCE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0xD5,
	0xFF, 0xFF,
	0x9C, 0xD4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x9D,
	0x8A, 0xB5,
	0xFF, 0xFF,
	0x9C, 0xD2,
	0xFF, 0xFF,
	0x8C, 0x64,
	0x8A, 0x53,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0xCF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0xB6,
	0x9C, 0xD1,
	0x88, 0xD4,
	0x9C, 0xD3,
	0xFF, 0xFF,
	0x9C, 0xCA,
	0x9C, 0xD0,
	0x9C, 0xD7,
	0x8C, 0x63,
	0x9C, 0xCB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x7C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x4A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0xDA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0xDE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x9E,
	0xFF, 0xFF,
	0x97, 0xF7,
	0x9C, 0xDF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0xDC,
	0xFF, 0xFF,
	0x9C, 0xD9,
	0xFF, 0xFF,
	0xFA, 0xC6,
	0x9C, 0xD8,
	0x9C, 0xDD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xAE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xB2,
	0xFF, 0xFF,
	0x8C, 0x65,
	0xFF, 0xFF,
	0x9C, 0xE0,
	0x9C, 0xDB,
	0xFF, 0xFF,
	0x9C, 0xE1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x9B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xAF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0xE9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xB6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0xE7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0xE8,
	0x8D, 0xA7,
	0x9C, 0xE6,
	0x9C, 0xE4,
	0x9C, 0xE3,
	0x9C, 0xEA,
	0x9C, 0xE2,
	0x9C, 0xEC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xF9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0xEE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0xED,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0xA6,
	0xFF, 0xFF,
	0x9C, 0xF1,
	0xFF, 0xFF,
	0x9C, 0xEF,
	0x9C, 0xE5,
	0x8C, 0x9C,
	0xFF, 0xFF,
	0x9C, 0xF0,
	0xFF, 0xFF,
	0x9C, 0xF4,
	0x9C, 0xF3,
	0x9C, 0xF5,
	0x9C, 0xF2
};

static unsigned char low_62[512] = {
	0x9C, 0xF6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9C, 0xF7,
	0x9C, 0xF8,
	0x95, 0xE8,
	0xFF, 0xFF,
	0x9C, 0xFA,
	0x9C, 0xF9,
	0x8F, 0x5E,
	0xFF, 0xFF,
	0x90, 0xAC,
	0x89, 0xE4,
	0x89, 0xFA,
	0xFA, 0xC7,
	0x9C, 0xFB,
	0xFF, 0xFF,
	0x88, 0xBD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0xCA,
	0x9C, 0xFC,
	0xFF, 0xFF,
	0xE6, 0xC1,
	0x9D, 0x40,
	0x8C, 0x81,
	0xFF, 0xFF,
	0x9D, 0x41,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0xED,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0x42,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0x43,
	0x8B, 0x59,
	0x9D, 0x44,
	0xFF, 0xFF,
	0x9D, 0x45,
	0x9D, 0x46,
	0x91, 0xD5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xCB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0xDF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x5B,
	0x8F, 0x8A,
	0x9D, 0x47,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0xEE,
	0xE7, 0xBB,
	0x94, 0xE0,
	0xFF, 0xFF,
	0x8E, 0xE8,
	0xFF, 0xFF,
	0x8D, 0xCB,
	0x9D, 0x48,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0xC5,
	0xFF, 0xFF,
	0x95, 0xA5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0xEF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0x4B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0x49,
	0xFF, 0xFF,
	0x9D, 0x4C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0x4A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0x4D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xAF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x88, 0xB5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0x7D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xE1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0x4E,
	0xFF, 0xFF,
	0x9D, 0x51,
	0x8F, 0xB3,
	0x8B, 0x5A,
	0xFF, 0xFF,
	0x9D, 0x4F,
	0x9D, 0x56,
	0x8F, 0xB4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0x50,
	0x94, 0x63,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x7D,
	0x9D, 0x52,
	0x9D, 0x53,
	0x9D, 0x57,
	0x93, 0x8A,
	0x9D, 0x54,
	0x8D, 0x52,
	0x90, 0xDC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0x65,
	0x94, 0xB2,
	0xFF, 0xFF,
	0x91, 0xF0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0xC8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xE2,
	0x9D, 0xAB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xF8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0xEF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x95,
	0xFF, 0xFF,
	0x9D, 0x5A,
	0x89, 0x9F,
	0x92, 0x8A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0x63,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x53,
	0x9D, 0x5D,
	0x9D, 0x64,
	0x9D, 0x5F,
	0x9D, 0x66,
	0x9D, 0x62,
	0xFF, 0xFF,
	0x9D, 0x61,
	0x94, 0x8F,
	0xFF, 0xFF,
	0x9D, 0x5B,
	0x89, 0xFB,
	0x9D, 0x59,
	0x8B, 0x91,
	0x91, 0xF1,
	0x9D, 0x55,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0x58,
	0x8D, 0x53,
	0x90, 0xD9,
	0xFF, 0xFF,
	0x8F, 0xB5,
	0x9D, 0x60,
	0x94, 0x71,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x92,
	0x8A, 0x67,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x87,
	0x90, 0x40,
	0x9D, 0x68,
	0x9D, 0x6D,
	0xFF, 0xFF,
	0x9D, 0x69,
	0xFF, 0xFF,
	0x8C, 0x9D,
	0xFF, 0xFF,
	0x9D, 0x6E,
	0x8E, 0x41,
	0x8D, 0x89,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x45,
	0x9D, 0x5C
};

static unsigned char low_63[512] = {
	0xFF, 0xFF,
	0x8E, 0x9D,
	0x9D, 0x6B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x77,
	0x9D, 0x6C,
	0x88, 0xC2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0x67,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0xA7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x93,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xB2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0x6A,
	0x88, 0xA5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0xC1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x55,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0xF0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xD2,
	0x9D, 0x70,
	0x91, 0x7D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0xA8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x4A,
	0x9D, 0x71,
	0xFF, 0xFF,
	0x9D, 0x73,
	0x9D, 0x6F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xDF,
	0xFF, 0xFF,
	0x92, 0xBB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x7B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xF9,
	0x8E, 0xCC,
	0x9D, 0x80,
	0xFF, 0xFF,
	0x9D, 0x7E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x98,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x9E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0x78,
	0x8F, 0xB7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xE6,
	0x94, 0x50,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0x76,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x7C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0xF6,
	0x9D, 0x7B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0xB6,
	0xFF, 0xFF,
	0x9D, 0x75,
	0x9D, 0x7A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0x72,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0x74,
	0xFF, 0xFF,
	0x8C, 0x40,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x7C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0x7C,
	0x97, 0xA9,
	0x8D, 0xCC,
	0x92, 0x54,
	0x9D, 0x79,
	0xFF, 0xFF,
	0x90, 0xDA,
	0xFF, 0xFF,
	0x8D, 0x54,
	0x90, 0x84,
	0x89, 0x86,
	0x91, 0x5B,
	0x9D, 0x77,
	0x8B, 0x64,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x66,
	0xFF, 0xFF,
	0x92, 0xCD,
	0x9D, 0x7D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x7E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0x81,
	0xFF, 0xFF,
	0x9D, 0x83,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0xB5,
	0x9D, 0x89,
	0xFF, 0xFF,
	0x9D, 0x84,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0x86,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0x60,
	0x92, 0xF1,
	0xFF, 0xFF,
	0x9D, 0x87,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x4B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x67,
	0x8A, 0xB7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x88, 0xAC,
	0xFF, 0xFF,
	0x9D, 0x85,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0x82,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xF6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x87,
	0xFA, 0xC9,
	0x9D, 0x88,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x68,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_64[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0x8C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0xB9,
	0xFF, 0xFF,
	0x9D, 0x93,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0x8D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0x8A,
	0x9D, 0x91,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0x72,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0x8E,
	0xFF, 0xFF,
	0x9D, 0x92,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xC0,
	0x93, 0x8B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0x8B,
	0xFF, 0xFF,
	0x9D, 0x8F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x67,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0xEF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0xDB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0x97,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x45,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0xCA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0x94,
	0xFF, 0xFF,
	0x96, 0x80,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0x95,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0x96,
	0xFF, 0xFF,
	0x96, 0xCC,
	0xFF, 0xFF,
	0x90, 0xA0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x82,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0x9D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x54,
	0x9D, 0x9A,
	0xFF, 0xFF,
	0x9D, 0x99,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0x51,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0xCB,
	0x93, 0xB3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x50,
	0x9D, 0x9B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0x9C,
	0xFF, 0xFF,
	0x95, 0x8F,
	0xFF, 0xFF,
	0x94, 0x64,
	0x8E, 0x42,
	0xFF, 0xFF,
	0x90, 0xEF,
	0xFF, 0xFF,
	0x96, 0x6F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x68,
	0xFF, 0xFF,
	0x9D, 0xA3,
	0x9D, 0x9E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x69,
	0x9D, 0xA5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xA1,
	0xFF, 0xFF,
	0x9D, 0xA2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x80,
	0xFA, 0xCC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xA0,
	0xFF, 0xFF,
	0x9D, 0x5E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xA4,
	0xFF, 0xFF,
	0x9D, 0x9F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xA9,
	0x9D, 0xAA,
	0x93, 0x46,
	0x9D, 0xAC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x43,
	0x9D, 0xA7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x5B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xAD,
	0xFF, 0xFF,
	0x9D, 0xA6,
	0x9D, 0xB1,
	0xFF, 0xFF,
	0x9D, 0xB0,
	0xFF, 0xFF,
	0x9D, 0xAF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xB2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xB4,
	0x8F, 0xEF,
	0xFF, 0xFF
};

static unsigned char low_65[512] = {
	0x9D, 0xB3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xB7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xB5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xB6,
	0x9D, 0x90,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xB9,
	0x9D, 0xB8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0x98,
	0x9D, 0xBA,
	0x9D, 0xAE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x78,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xBB,
	0x9D, 0xBC,
	0x9D, 0xBE,
	0x9D, 0xBD,
	0x9D, 0xBF,
	0x89, 0xFC,
	0xFF, 0xFF,
	0x8D, 0x55,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xFA,
	0x90, 0xAD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xCC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xC1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xC4,
	0xFA, 0xCD,
	0x95, 0x71,
	0xFF, 0xFF,
	0x8B, 0x7E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xC3,
	0x9D, 0xC2,
	0x94, 0x73,
	0x9D, 0xC5,
	0x8B, 0xB3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xC7,
	0x9D, 0xC6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xB8,
	0x8E, 0x55,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xD6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x68,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x94,
	0xFF, 0xFF,
	0x9D, 0xC8,
	0xFF, 0xFF,
	0x90, 0xAE,
	0x93, 0x47,
	0xFF, 0xFF,
	0x95, 0x7E,
	0x9D, 0xC9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xCA,
	0x9D, 0xCB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xB6,
	0x9B, 0x7C,
	0x90, 0xC4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0x6B,
	0xFF, 0xFF,
	0x8D, 0xD6,
	0xFF, 0xFF,
	0x94, 0xE3,
	0x94, 0xC1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x6C,
	0xFF, 0xFF,
	0x97, 0xBF,
	0xFF, 0xFF,
	0x9D, 0xCD,
	0x8E, 0xCE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xCE,
	0xFF, 0xFF,
	0x88, 0xB4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xD2,
	0x90, 0xCB,
	0xFF, 0xFF,
	0x95, 0x80,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xCF,
	0x8E, 0x61,
	0x92, 0x66,
	0xFF, 0xFF,
	0x8E, 0x7A,
	0x90, 0x56,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xD0,
	0xFF, 0xFF,
	0x95, 0xFB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x97,
	0x8E, 0x7B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xD3,
	0xFF, 0xFF,
	0x9D, 0xD1,
	0x9D, 0xD4,
	0x97, 0xB7,
	0x9D, 0xD2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0xF9,
	0x9D, 0xD5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0xB0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xD6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xF8,
	0xFF, 0xFF,
	0x9D, 0xD8,
	0xFF, 0xFF,
	0x9D, 0xD7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xD9,
	0x9D, 0xDA,
	0x8A, 0xF9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xFA,
	0x92, 0x55,
	0x8B, 0x8C,
	0x8E, 0x7C,
	0x91, 0x81,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x7B,
	0x88, 0xAE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xDB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xA0,
	0x9D, 0xDF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_66[512] = {
	0xFA, 0xCE,
	0xFF, 0xFF,
	0x8D, 0x56,
	0x9D, 0xDE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0xA9,
	0x8F, 0xB8,
	0xFF, 0xFF,
	0xFA, 0xD1,
	0x9D, 0xDD,
	0xFF, 0xFF,
	0x8F, 0xB9,
	0xFF, 0xFF,
	0x96, 0xBE,
	0x8D, 0xA8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x88, 0xD5,
	0x90, 0xCC,
	0xFA, 0xCF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xE4,
	0xFF, 0xFF,
	0xFA, 0xD3,
	0x90, 0xAF,
	0x89, 0x66,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0xD4,
	0x8F, 0x74,
	0xFF, 0xFF,
	0x96, 0x86,
	0x8D, 0xF0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0xBA,
	0xFA, 0xD2,
	0x90, 0xA5,
	0xFF, 0xFF,
	0xFA, 0x63,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xE3,
	0x9D, 0xE1,
	0x9D, 0xE2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0xD0,
	0x92, 0x8B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x45,
	0xFF, 0xFF,
	0x9D, 0xE8,
	0x8E, 0x9E,
	0x8D, 0x57,
	0x9D, 0xE6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xE7,
	0xFF, 0xFF,
	0x90, 0x57,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xE5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x4E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0xD6,
	0xFF, 0xFF,
	0xFA, 0xD7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xEA,
	0x9D, 0xE9,
	0x9D, 0xEE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xEF,
	0xFF, 0xFF,
	0x9D, 0xEB,
	0xFA, 0xD5,
	0x8A, 0x41,
	0x9D, 0xEC,
	0x9D, 0xED,
	0x94, 0xD3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0x81,
	0x8C, 0x69,
	0x9D, 0xF0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0xD9,
	0x90, 0xB0,
	0xFF, 0xFF,
	0x8F, 0xBB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x71,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xC5,
	0xFF, 0xFF,
	0x9D, 0xF1,
	0x9D, 0xF5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xC9,
	0x9D, 0xF2,
	0x9D, 0xF4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xF3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x8B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x67,
	0x88, 0xC3,
	0x9D, 0xF6,
	0xFA, 0xDA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xF7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0xDB,
	0xFF, 0xFF,
	0x92, 0xA8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0xEF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x62,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xE9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0xDC,
	0xFF, 0xFF,
	0x96, 0x5C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x41,
	0x9D, 0xF9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xFC,
	0xFF, 0xFF,
	0x9D, 0xFB,
	0xFA, 0xDD,
	0xFF, 0xFF,
	0x9D, 0xF8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x40,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xDC,
	0xFF, 0xFF,
	0x9D, 0xFA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x42,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x8C,
	0x9E, 0x43,
	0xFF, 0xFF,
	0x97, 0x6A,
	0x94, 0x98,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x44,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x46,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x47,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x48,
	0xFF, 0xFF,
	0x8B, 0xC8,
	0x89, 0x67,
	0x8D, 0x58,
	0x9E, 0x49,
	0xFF, 0xFF,
	0x9E, 0x4A,
	0x8F, 0x91,
	0x91, 0x82,
	0xFA, 0xDE,
	0xFA, 0x66,
	0x99, 0xD6,
	0x91, 0x5D,
	0x91, 0x5C,
	0x91, 0xD6
};

static unsigned char low_67[512] = {
	0x8D, 0xC5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0xF0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x8E,
	0x97, 0x4C,
	0xFF, 0xFF,
	0x95, 0xFC,
	0xFF, 0xFF,
	0x95, 0x9E,
	0xFA, 0xDF,
	0x9E, 0x4B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0xF1,
	0x92, 0xBD,
	0x9E, 0x4C,
	0x98, 0x4E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x5D,
	0xFF, 0xFF,
	0x92, 0xA9,
	0x9E, 0x4D,
	0x8A, 0xFA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x4E,
	0x9E, 0x4F,
	0x96, 0xD8,
	0xFF, 0xFF,
	0x96, 0xA2,
	0x96, 0x96,
	0x96, 0x7B,
	0x8E, 0x44,
	0x9E, 0x51,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0xE9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x70,
	0xFF, 0xFF,
	0x9E, 0x53,
	0x9E, 0x56,
	0x9E, 0x55,
	0xFF, 0xFF,
	0x8A, 0xF7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x80,
	0xFF, 0xFF,
	0x9E, 0x52,
	0xFF, 0xFF,
	0x9E, 0x54,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x57,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x99,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x9B,
	0x88, 0xC7,
	0x8D, 0xDE,
	0x91, 0xBA,
	0xFF, 0xFF,
	0x8E, 0xDB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0xF1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x5A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x6D,
	0xFF, 0xFF,
	0x9E, 0x58,
	0x91, 0xA9,
	0x9E, 0x59,
	0x8F, 0xF0,
	0x96, 0xDB,
	0x9E, 0x5B,
	0x9E, 0x5C,
	0x97, 0x88,
	0xFA, 0xE1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x61,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0x59,
	0xFF, 0xFF,
	0x94, 0x74,
	0x9E, 0x5E,
	0x93, 0x8C,
	0x9D, 0xDC,
	0x9D, 0xE0,
	0xFF, 0xFF,
	0x8B, 0x6E,
	0xFF, 0xFF,
	0x94, 0x66,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x60,
	0xFF, 0xFF,
	0x8F, 0xBC,
	0x94, 0xC2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x66,
	0xFF, 0xFF,
	0x94, 0xF8,
	0xFF, 0xFF,
	0x9E, 0x5D,
	0xFF, 0xFF,
	0x9E, 0x63,
	0x9E, 0x62,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0xCD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x8D,
	0xFF, 0xFF,
	0x97, 0xD1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x87,
	0xFF, 0xFF,
	0x89, 0xCA,
	0x8E, 0x7D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0x67,
	0x9E, 0x65,
	0x90, 0x95,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x64,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x5F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xCD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x6B,
	0x9E, 0x69,
	0xFF, 0xFF,
	0x89, 0xCB,
	0x9E, 0x67,
	0x9E, 0x6D,
	0x9E, 0x73,
	0xFF, 0xFF,
	0xFA, 0xE2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0xE4,
	0x91, 0xC6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xBF,
	0xFF, 0xFF,
	0x9E, 0x75,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0x41,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x74,
	0x94, 0x90,
	0x96, 0x5E,
	0x8A, 0xB9,
	0xFF, 0xFF,
	0x90, 0xF5,
	0x8F, 0x5F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0xD1,
	0xFF, 0xFF,
	0x97, 0x4D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x70,
	0x9E, 0x6F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x71,
	0xFF, 0xFF,
	0x9E, 0x6E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x76,
	0xFF, 0xFF,
	0x9E, 0x6C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x6A,
	0xFF, 0xFF,
	0x9E, 0x72,
	0x9E, 0x68,
	0xFF, 0xFF,
	0x92, 0x8C,
	0xFF, 0xFF,
	0x96, 0xF6,
	0x8E, 0xC4,
	0x8D, 0xF2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0xB8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x8F,
	0x8A, 0x60
};

static unsigned char low_68[512] = {
	0xFF, 0xFF,
	0xFA, 0xE5,
	0x92, 0xCC,
	0x93, 0xC8,
	0x89, 0x68,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0xF0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0xB2,
	0x8C, 0x49,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x78,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0x5A,
	0x8A, 0x9C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x7A,
	0x8A, 0x94,
	0x9E, 0x81,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x7D,
	0xFF, 0xFF,
	0x90, 0xF1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x6A,
	0x8D, 0xAA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x69,
	0x8D, 0xCD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x7B,
	0x8C, 0x85,
	0x8C, 0x6A,
	0x93, 0x8D,
	0xFA, 0xE6,
	0xFF, 0xFF,
	0x9E, 0x79,
	0xFF, 0xFF,
	0x88, 0xC4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x7C,
	0x9E, 0x7E,
	0xFF, 0xFF,
	0x8B, 0xCB,
	0x8C, 0x4B,
	0xFA, 0xE3,
	0x8A, 0xBA,
	0x8B, 0x6A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x82,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0xF7,
	0x96, 0x91,
	0xFF, 0xFF,
	0x8E, 0x56,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x83,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0x4F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x8F,
	0xFF, 0xFF,
	0x89, 0xB1,
	0x9E, 0x84,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x95,
	0x9E, 0x85,
	0xFF, 0xFF,
	0x97, 0xC0,
	0xFF, 0xFF,
	0x9E, 0x8C,
	0xFF, 0xFF,
	0x94, 0x7E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x94,
	0xFF, 0xFF,
	0x9E, 0x87,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x88, 0xB2,
	0x9E, 0x89,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0x5B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x8B,
	0xFF, 0xFF,
	0x9E, 0x8A,
	0xFF, 0xFF,
	0x9E, 0x86,
	0x9E, 0x91,
	0xFF, 0xFF,
	0x8F, 0xBD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0xEB,
	0x8C, 0xE6,
	0x97, 0x9C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x88,
	0xFF, 0xFF,
	0x92, 0xF2,
	0x8A, 0x42,
	0x8D, 0xAB,
	0xFF, 0xFF,
	0x9E, 0x80,
	0xFF, 0xFF,
	0x9E, 0x90,
	0x8A, 0x81,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x8E,
	0x9E, 0x92,
	0xFF, 0xFF,
	0x93, 0x8E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xFC,
	0xFF, 0xFF,
	0x9E, 0xB0,
	0xFF, 0xFF,
	0xFA, 0x64,
	0x96, 0xC7,
	0x9E, 0x97,
	0x8A, 0xFB,
	0xFF, 0xFF,
	0x9E, 0x9E,
	0xFF, 0xFF,
	0xFA, 0xE7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x5F,
	0xFF, 0xFF,
	0x9E, 0x9F,
	0x9E, 0xA1,
	0xFF, 0xFF,
	0x9E, 0xA5,
	0x9E, 0x99,
	0xFF, 0xFF,
	0x92, 0x49,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x8F,
	0x9E, 0xA9,
	0x9E, 0x9C,
	0xFF, 0xFF,
	0x9E, 0xA6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xA0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x58,
	0x9E, 0xAA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0xB1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xA8,
	0x8A, 0xBB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_69[512] = {
	0x98, 0x6F,
	0x9E, 0x96,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xA4,
	0x88, 0xD6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x98,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0xB8,
	0x9E, 0x9D,
	0x90, 0x41,
	0x92, 0xC5,
	0x9E, 0x93,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xA3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x9A,
	0x9E, 0xAD,
	0x8A, 0x91,
	0x8C, 0x9F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xAF,
	0x9E, 0x9A,
	0x9E, 0xAE,
	0xFF, 0xFF,
	0x9E, 0xA7,
	0x9E, 0x9B,
	0xFF, 0xFF,
	0x9E, 0xAB,
	0xFF, 0xFF,
	0x9E, 0xAC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xBD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xCC,
	0xFF, 0xFF,
	0x9E, 0xA2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xB9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xBB,
	0xFF, 0xFF,
	0x92, 0xD6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x6B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0x96,
	0x9E, 0xB6,
	0x91, 0xC8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xBC,
	0x91, 0x5E,
	0xFF, 0xFF,
	0x9E, 0xB3,
	0x9E, 0xC0,
	0x9E, 0xBF,
	0xFF, 0xFF,
	0x93, 0xED,
	0x9E, 0xBE,
	0x93, 0xE8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0xE9,
	0xFF, 0xFF,
	0x9E, 0xC2,
	0x9E, 0xB5,
	0xFF, 0xFF,
	0x8B, 0xC6,
	0x9E, 0xB8,
	0x8F, 0x7C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0x80,
	0x9E, 0xBA,
	0x8B, 0xC9,
	0xFF, 0xFF,
	0x9E, 0xB2,
	0x9E, 0xB4,
	0x9E, 0xB1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0x4F,
	0x8A, 0x79,
	0x9E, 0xB7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xC1,
	0x8A, 0x54,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0xE5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x7C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xD2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0x50,
	0x9E, 0xD5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0xEB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x59,
	0x9E, 0xD4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xD3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xD0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xC4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xE1,
	0x9E, 0xC3,
	0xFF, 0xFF,
	0x9E, 0xD6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xCE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xC9,
	0x9E, 0xC6,
	0xFF, 0xFF,
	0x9E, 0xC7,
	0xFF, 0xFF,
	0x9E, 0xCF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0xA0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xCC,
	0x8D, 0x5C,
	0x92, 0xC6,
	0x91, 0x84,
	0x9E, 0xCA,
	0xFF, 0xFF,
	0x9E, 0xC5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xC8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x6C,
	0x96, 0x8A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xCD,
	0x9E, 0xD7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0xEC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xDF,
	0x9E, 0xD8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xE5,
	0xFF, 0xFF,
	0x9E, 0xE3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xDE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xDD,
	0xFF, 0xFF,
	0x92, 0xCE,
	0xFF, 0xFF,
	0x91, 0x85,
	0xFF, 0xFF,
	0x9E, 0xDB
};

static unsigned char low_6A[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xD9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xE0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xE6,
	0x94, 0xF3,
	0x9E, 0xEC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xE7,
	0x9E, 0xEA,
	0x9E, 0xE4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x94,
	0xFF, 0xFF,
	0x95, 0x57,
	0xFF, 0xFF,
	0x9E, 0xDA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xE2,
	0x8F, 0xBE,
	0xFF, 0xFF,
	0x96, 0xCD,
	0x9E, 0xF6,
	0x9E, 0xE9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xA0,
	0x89, 0xA1,
	0x8A, 0x7E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xD1,
	0xFF, 0xFF,
	0xFA, 0xED,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0xBF,
	0x9E, 0xEE,
	0xFF, 0xFF,
	0x9E, 0xF5,
	0x8E, 0xF7,
	0x8A, 0x92,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x4D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xEB,
	0xFF, 0xFF,
	0xFA, 0xEF,
	0x9E, 0xF0,
	0x9E, 0xF4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xB4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x6B,
	0x9E, 0xF2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x40,
	0xFF, 0xFF,
	0x93, 0xC9,
	0x9E, 0xF1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xF3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0xEE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xED,
	0xFA, 0xF0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xEF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0xF1,
	0x8A, 0x80,
	0x92, 0x68,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xFA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xF8,
	0x8C, 0xE7,
	0xFF, 0xFF,
	0x9E, 0xF7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x40,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x77,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xF9,
	0xFF, 0xFF,
	0x9E, 0xFB,
	0x9E, 0xFC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x4B,
	0xFF, 0xFF,
	0x9F, 0x47,
	0xFF, 0xFF,
	0x9E, 0x8D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x46,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x45,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x42,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xE8,
	0x9F, 0x44,
	0x9F, 0x43,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x49,
	0xFF, 0xFF,
	0x98, 0x45,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x4C,
	0x8B, 0xF9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x48,
	0x9F, 0x4A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0xF2,
	0xFF, 0xFF,
	0xFA, 0xF3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xA5,
	0xFF, 0xFF,
	0x9F, 0x4D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x51,
	0x9F, 0x4E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_6B[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x93,
	0x9F, 0x4F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0xDC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x52,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x53,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x54,
	0xFF, 0xFF,
	0x9F, 0x55,
	0x8C, 0x87,
	0x8E, 0x9F,
	0xFF, 0xFF,
	0x8B, 0xD3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xA2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x7E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x57,
	0x9F, 0x56,
	0x9F, 0x59,
	0x8B, 0x5C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xD4,
	0x8A, 0xBC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x5C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x5B,
	0xFF, 0xFF,
	0x9F, 0x5D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xCC,
	0xFF, 0xFF,
	0x92, 0x56,
	0xFF, 0xFF,
	0x9F, 0x5E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xBD,
	0x9F, 0x60,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x5F,
	0xFF, 0xFF,
	0x9F, 0x61,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x62,
	0xFF, 0xFF,
	0x9F, 0x63,
	0x8E, 0x7E,
	0x90, 0xB3,
	0x8D, 0x9F,
	0xFF, 0xFF,
	0x95, 0x90,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xE0,
	0x98, 0x63,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x95,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0xCE,
	0x97, 0xF0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x64,
	0x9F, 0x65,
	0xFF, 0xFF,
	0x8E, 0x80,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x66,
	0x9F, 0x67,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x69,
	0x9F, 0x68,
	0xFF, 0xFF,
	0x96, 0x77,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x7D,
	0x8E, 0xEA,
	0x8E, 0x63,
	0xFF, 0xFF,
	0x9F, 0x6A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x6C,
	0x90, 0x42,
	0xFF, 0xFF,
	0x9F, 0x6B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x6D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x6E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x6F,
	0x9F, 0x70,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x71,
	0xFF, 0xFF,
	0x9F, 0x73,
	0x9F, 0x72,
	0x9F, 0x74,
	0x89, 0xA3,
	0x92, 0x69,
	0xFF, 0xFF,
	0x9F, 0x75,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x45,
	0x8A, 0x6B,
	0x9F, 0x76,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x61,
	0x9A, 0xCA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x42,
	0x9F, 0x77,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x78,
	0xFF, 0xFF,
	0x95, 0xEA,
	0x96, 0x88,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xC5,
	0x9F, 0x79,
	0x94, 0xE4,
	0xFF, 0xFF,
	0xFA, 0xF4,
	0xFF, 0xFF,
	0x94, 0xF9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0xD1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x7A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x7C,
	0x9F, 0x7B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x7E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x7D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_6C[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x81,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x81,
	0xFF, 0xFF,
	0x96, 0xAF,
	0xFF, 0xFF,
	0x9F, 0x82,
	0x9F, 0x83,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x43,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x84,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x86,
	0x9F, 0x85,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x85,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0x58,
	0x89, 0x69,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xC3,
	0xFA, 0xF5,
	0x92, 0xF3,
	0x8F, 0x60,
	0x8B, 0x81,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xC4,
	0xFF, 0xFF,
	0x8E, 0xAC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x88,
	0xFF, 0xFF,
	0x8A, 0xBE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x98,
	0xFF, 0xFF,
	0xFA, 0xF6,
	0x93, 0xF0,
	0x9F, 0x87,
	0x8D, 0x5D,
	0x92, 0x72,
	0xFF, 0xFF,
	0x9F, 0x89,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x91,
	0xFF, 0xFF,
	0x9F, 0x8A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0xF8,
	0x91, 0xBF,
	0xFF, 0xFF,
	0x8B, 0x82,
	0x9F, 0x92,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x88,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x44,
	0x9F, 0x90,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x8E,
	0x9F, 0x8B,
	0x97, 0x80,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0xF7,
	0xFF, 0xFF,
	0x92, 0xBE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xD7,
	0x9F, 0x8C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x94,
	0xFF, 0xFF,
	0x9F, 0x93,
	0x8C, 0x42,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xAB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0xB9,
	0x9F, 0x8D,
	0x9F, 0x8F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x76,
	0x91, 0xF2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x97,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x9C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x9D,
	0xFF, 0xFF,
	0x89, 0xCD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xA6,
	0x96, 0xFB,
	0x9F, 0x9F,
	0x8E, 0xA1,
	0x8F, 0xC0,
	0x9F, 0x98,
	0x9F, 0x9E,
	0x89, 0x88,
	0xFF, 0xFF,
	0x8B, 0xB5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x95,
	0x9F, 0x9A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0xF2,
	0x94, 0x91,
	0xFF, 0xFF,
	0x94, 0xE5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x97,
	0xFF, 0xFF,
	0x96, 0x40,
	0xFF, 0xFF,
	0x9F, 0x99,
	0xFF, 0xFF,
	0x9F, 0xA2,
	0xFA, 0xF9,
	0x9F, 0xA0,
	0xFF, 0xFF,
	0x9F, 0x9B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x41,
	0x94, 0x67,
	0x8B, 0x83,
	0xFF, 0xFF,
	0x93, 0x44,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x8D,
	0xFF, 0xFF,
	0x9F, 0xA3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xA1,
	0x91, 0xD7,
	0x9F, 0x96,
	0xFF, 0xFF,
	0x89, 0x6A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_6D[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0xFA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x6D,
	0x9F, 0xAE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xAD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0xF4,
	0xFF, 0xFF,
	0x9F, 0xAA,
	0xFF, 0xFF,
	0x97, 0x8C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xB4,
	0x9F, 0xA4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0xC3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x6B,
	0x8D, 0x5E,
	0x9F, 0xA7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x46,
	0x9F, 0xAC,
	0xFF, 0xFF,
	0x9F, 0xAB,
	0x9F, 0xA6,
	0xFF, 0xFF,
	0x9F, 0xA9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x88,
	0xFF, 0xFF,
	0x9F, 0xA8,
	0x94, 0x68,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0xAC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0xF2,
	0x90, 0xF3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xB4,
	0x9F, 0xB2,
	0xFF, 0xFF,
	0x95, 0x6C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xAF,
	0x9F, 0xB1,
	0xFF, 0xFF,
	0x89, 0x59,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0x5F,
	0x98, 0x51,
	0xFF, 0xFF,
	0x8A, 0x5C,
	0xFF, 0xFF,
	0x95, 0x82,
	0xFA, 0xFC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x81,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x43,
	0x90, 0x5A,
	0x9F, 0xB3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xB8,
	0xFF, 0xFF,
	0xFA, 0xFB,
	0x8F, 0xC1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x4F,
	0xFF, 0xFF,
	0x9F, 0xB5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xB0,
	0xFF, 0xFF,
	0x9F, 0xB6,
	0xFB, 0x40,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0xDC,
	0xFF, 0xFF,
	0x93, 0x93,
	0x93, 0xC0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0x41,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x55,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x74,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xBC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xBF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0xC1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x84,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xC6,
	0x9F, 0xC0,
	0x9F, 0xBD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0xD2,
	0x9F, 0xC3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0x42,
	0xFF, 0xFF,
	0x8F, 0x69,
	0x9F, 0xC5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xCA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x91,
	0x9F, 0xC8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xC2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x57,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xC9,
	0xFF, 0xFF,
	0x9F, 0xBE,
	0xFF, 0xFF,
	0x9F, 0xC4,
	0xFF, 0xFF,
	0x9F, 0xCB,
	0x88, 0xFA,
	0x9F, 0xC1,
	0xFF, 0xFF,
	0x9F, 0xCC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x5B,
	0xFB, 0x44,
	0x8F, 0x7E,
	0xFF, 0xFF,
	0x95, 0xA3,
	0xFF, 0xFF,
	0x8D, 0xAC,
	0xFB, 0x43,
	0x9F, 0xB9,
	0x9F, 0xC7,
	0x93, 0x59,
	0xFB, 0x45,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_6E[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0xB4,
	0xFF, 0xFF,
	0x8A, 0x89,
	0x8D, 0xCF,
	0x8F, 0xC2,
	0x9F, 0xBB,
	0x8F, 0x61,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x6B,
	0xFF, 0xFF,
	0x9F, 0xBA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xD0,
	0x8F, 0x8D,
	0x8C, 0xB8,
	0xFF, 0xFF,
	0x9F, 0xDF,
	0xFF, 0xFF,
	0x9F, 0xD9,
	0x8B, 0x94,
	0x93, 0x6E,
	0xFF, 0xFF,
	0x9F, 0xD4,
	0x9F, 0xDD,
	0x88, 0xAD,
	0x89, 0x51,
	0xFB, 0x48,
	0xFF, 0xFF,
	0x89, 0xB7,
	0xFF, 0xFF,
	0x9F, 0xD6,
	0x91, 0xAA,
	0x9F, 0xCD,
	0x9F, 0xCF,
	0x8D, 0x60,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xE0,
	0xFB, 0x46,
	0x9F, 0xDB,
	0xFF, 0xFF,
	0xFB, 0x49,
	0xFF, 0xFF,
	0x9F, 0xD3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xDA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0xA9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xD8,
	0x9F, 0xDC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xCE,
	0xFF, 0xFF,
	0x8F, 0xC3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x58,
	0xFB, 0x47,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xD2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x4E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xD5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xCE,
	0x93, 0x92,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xD1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xD7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0x70,
	0x8E, 0xBC,
	0x96, 0x9E,
	0xFF, 0xFF,
	0x9F, 0xE1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xAC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xED,
	0x8C, 0xB9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x80,
	0xFF, 0xFF,
	0x9F, 0xE3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0xAD,
	0x8D, 0x61,
	0xFF, 0xFF,
	0x9F, 0xF0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x88, 0xEC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xEE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xE2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xE8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xEA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x6E,
	0x9F, 0xE5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x4D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xE7,
	0xFF, 0xFF,
	0xFB, 0x4A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xEF,
	0xFF, 0xFF,
	0x9F, 0xE9,
	0x96, 0xC5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xE4,
	0xFF, 0xFF,
	0x8E, 0xA0,
	0x9F, 0xFC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x8A,
	0xFF, 0xFF,
	0x9F, 0xE6,
	0x9F, 0xEB,
	0x9F, 0xEC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0xEA,
	0x91, 0xD8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xF4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xFA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xF8,
	0xFF, 0xFF,
	0x93, 0x48,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x42,
	0x9F, 0xF5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xF6,
	0x9F, 0xDE
};

static unsigned char low_6F[512] = {
	0xFF, 0xFF,
	0x8B, 0x99,
	0x95, 0x59,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0xBD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0x97,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0x52,
	0xFF, 0xFF,
	0x9F, 0xF2,
	0xFF, 0xFF,
	0xE0, 0x41,
	0x89, 0x89,
	0x91, 0x86,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0x99,
	0xFF, 0xFF,
	0x8A, 0xBF,
	0x97, 0xF8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x9F,
	0x92, 0xD0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xF9,
	0x9F, 0xFB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x51,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x40,
	0x9F, 0xF7,
	0xFF, 0xFF,
	0x9F, 0xF1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xC1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x89,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x4E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x49,
	0x90, 0xF6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x83,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x81,
	0xFF, 0xFF,
	0xE0, 0x52,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x4B,
	0x92, 0xAA,
	0xE0, 0x48,
	0x92, 0xD7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x6B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x45,
	0xFF, 0xFF,
	0xE0, 0x44,
	0xFF, 0xFF,
	0xE0, 0x4D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x47,
	0xE0, 0x46,
	0xE0, 0x4C,
	0xFF, 0xFF,
	0x90, 0x9F,
	0xFF, 0xFF,
	0xE0, 0x43,
	0xFF, 0xFF,
	0xFB, 0x4B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x4F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x50,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xC0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x55,
	0xFF, 0xFF,
	0xE0, 0x54,
	0xE0, 0x56,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x59,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x62,
	0xFF, 0xFF,
	0xE0, 0x53,
	0xFF, 0xFF,
	0xFB, 0x4C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x57,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x83,
	0x91, 0xF7,
	0xE0, 0x51,
	0x94, 0x5A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x58,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x5D,
	0xE0, 0x5B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x5E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x61,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x5A,
	0x8D, 0x8A,
	0x94, 0x47,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xB7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x94,
	0xE0, 0x5C,
	0xFF, 0xFF,
	0xE0, 0x60,
	0x91, 0xF3,
	0xFF, 0xFF,
	0xE0, 0x5F,
	0xFF, 0xFF,
	0xE0, 0x4A,
	0xFF, 0xFF,
	0xFB, 0x4D,
	0xE8, 0x89,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x64,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x68,
	0xFF, 0xFF
};

static unsigned char low_70[512] = {
	0xFF, 0xFF,
	0xE0, 0x66,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0x4E,
	0xFF, 0xFF,
	0xFB, 0x4F,
	0xFF, 0xFF,
	0xE0, 0x62,
	0xFF, 0xFF,
	0xE0, 0x63,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x67,
	0xFF, 0xFF,
	0xE0, 0x65,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0x6D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x6D,
	0xFF, 0xFF,
	0xE0, 0x6A,
	0xE0, 0x69,
	0xFF, 0xFF,
	0xE0, 0x6C,
	0x93, 0xD2,
	0xE0, 0x6E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x95,
	0x91, 0xEB,
	0xFB, 0x50,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0xA3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x6F,
	0xFF, 0xFF,
	0xE0, 0x71,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x70,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0xF3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x72,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xE5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x73,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xCE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x94,
	0x8A, 0x44,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x84,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0xDC,
	0x8D, 0xD0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0x51,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0x46,
	0x90, 0x86,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x8A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x75,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x74,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0x52,
	0xE0, 0x78,
	0x92, 0x59,
	0xE0, 0x7B,
	0xE0, 0x76,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x7A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x79,
	0x93, 0x5F,
	0x88, 0xD7,
	0xFA, 0x62,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0xF3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x7D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x47,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x80,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x7E,
	0xFF, 0xFF,
	0xE0, 0x7C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x77,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x42,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x82,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_71[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0x54,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x81,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0x53,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x8B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x84,
	0x95, 0xB0,
	0xFF, 0xFF,
	0xE0, 0x83,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0xB3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0xC5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x52,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0xC4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0x56,
	0xFB, 0x57,
	0xFF, 0xFF,
	0x97, 0xF9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x8A,
	0xFF, 0xFF,
	0x90, 0xF7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x86,
	0xE0, 0x8B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x8C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0x55,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x89,
	0xFF, 0xFF,
	0x94, 0x81,
	0xE0, 0x85,
	0xE0, 0x88,
	0x8F, 0xC6,
	0xFF, 0xFF,
	0x94, 0xCF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x8C,
	0xFF, 0xFF,
	0x8E, 0xCF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0xF8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x8F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x87,
	0xFF, 0xFF,
	0x8C, 0x46,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x8D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x6F,
	0xE0, 0x90,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0xA4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x6E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x91,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x92,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0x4D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x94,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x95,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0x59,
	0xFF, 0xFF,
	0x94, 0x52,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x95,
	0xE0, 0x97,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x99,
	0xFF, 0xFF,
	0x97, 0xD3,
	0xFF, 0xFF,
	0xE0, 0x96,
	0xFF, 0xFF,
	0xE0, 0x98,
	0x89, 0x8D,
	0xFF, 0xFF,
	0xE0, 0x93,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9A, 0x7A,
	0xE0, 0x9A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x87,
	0x8E, 0x57,
	0xE0, 0x9C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x9B,
	0x90, 0x43,
	0x99, 0xD7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x9D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0x9F,
	0xFF, 0xFF,
	0xE0, 0x8E,
	0xE0, 0x9E,
	0xFF, 0xFF,
	0xFB, 0x5A,
	0xE0, 0xA0
};

static unsigned char low_72[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0x9A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xA1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xA2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xA3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xA4,
	0xFF, 0xFF,
	0x92, 0xDC,
	0xFF, 0xFF,
	0xE0, 0xA6,
	0xE0, 0xA5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xA7,
	0xFF, 0xFF,
	0xE0, 0xA8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0xDD,
	0x95, 0x83,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0xEA,
	0xE0, 0xA9,
	0xE0, 0xAA,
	0x91, 0x75,
	0x8E, 0xA2,
	0xE0, 0xAB,
	0xE0, 0xAC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xAD,
	0x95, 0xD0,
	0x94, 0xC5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xAE,
	0x94, 0x76,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0xAB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xAF,
	0x89, 0xE5,
	0xFF, 0xFF,
	0x8B, 0x8D,
	0xFF, 0xFF,
	0x96, 0xC4,
	0xFF, 0xFF,
	0x96, 0xB4,
	0xFF, 0xFF,
	0x89, 0xB2,
	0x98, 0x53,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x71,
	0xFF, 0xFF,
	0x95, 0xA8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0xB5,
	0xFF, 0xFF,
	0xE0, 0xB0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xC1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xA1,
	0xE0, 0xB1,
	0xFF, 0xFF,
	0x8D, 0xD2,
	0xE0, 0xB3,
	0xE0, 0xB2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xB4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xB5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xB6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x5D,
	0xFF, 0xFF,
	0xE0, 0xB7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xB8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xA2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xC6,
	0xFF, 0xFF,
	0xFB, 0x5B,
	0xE0, 0xBA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0xF3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xB9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0x5C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xB6,
	0xE0, 0xBB,
	0xE0, 0xBD,
	0xFF, 0xFF,
	0xE0, 0xBC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xBE,
	0xFF, 0xFF,
	0x8C, 0xCF,
	0xFF, 0xFF,
	0xE0, 0xBF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xE7,
	0xFF, 0xFF,
	0x91, 0x5F,
	0xFF, 0xFF,
	0x8D, 0x9D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xC1,
	0xE0, 0xC2,
	0xE0, 0xC0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0xEB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xC6,
	0x8B, 0xB7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xC4,
	0x92, 0x4B,
	0xE0, 0xC3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0x54,
	0x94, 0x82,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_73[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xC7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xC9,
	0xE0, 0xC6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0xD2,
	0xE0, 0xC8,
	0xE0, 0xCA,
	0xFF, 0xFF,
	0x97, 0xC2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0x5D,
	0xE0, 0xCE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xCD,
	0x92, 0x96,
	0x94, 0x4C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xA3,
	0xE0, 0xCC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xCB,
	0xFF, 0xFF,
	0x97, 0x50,
	0x97, 0x51,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xCF,
	0x89, 0x8E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0x96,
	0x8E, 0x82,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xD0,
	0xE0, 0xD1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xD3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x62,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xD5,
	0xFF, 0xFF,
	0xE0, 0xD4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xD6,
	0xFF, 0xFF,
	0x8A, 0x6C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xD8,
	0xFF, 0xFF,
	0xFB, 0x5F,
	0xE0, 0xD7,
	0xFF, 0xFF,
	0xE0, 0xDA,
	0xE0, 0xD9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xBA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0xA6,
	0xFF, 0xFF,
	0x8B, 0xCA,
	0xFF, 0xFF,
	0x89, 0xA4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xE8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xDF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0xE6,
	0xE0, 0xDC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xDE,
	0xFF, 0xFF,
	0xFB, 0x60,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xDF,
	0xFF, 0xFF,
	0x89, 0xCF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xDB,
	0xFB, 0x61,
	0x8E, 0x58,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0xBF,
	0xE0, 0xDD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0x64,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0x62,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xE2,
	0xFF, 0xFF,
	0x8E, 0xEC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0x63,
	0xFF, 0xFF,
	0xE0, 0xE0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x5D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xC7,
	0xE0, 0xE1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xFC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0x66,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xE7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xBB,
	0xFF, 0xFF
};

static unsigned char low_74[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x85,
	0xFF, 0xFF,
	0xE0, 0xE4,
	0x97, 0x9D,
	0xFB, 0x65,
	0xFF, 0xFF,
	0x97, 0xAE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0xF4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xE6,
	0xFB, 0x67,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0x69,
	0xFB, 0x68,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0x6A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xE8,
	0x97, 0xD4,
	0x8B, 0xD5,
	0x94, 0xFA,
	0x94, 0x69,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xE9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xEB,
	0xFF, 0xFF,
	0xE0, 0xEE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xEA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xED,
	0x8C, 0xE8,
	0x89, 0x6C,
	0xE0, 0xEF,
	0xFF, 0xFF,
	0x90, 0x90,
	0xE0, 0xEC,
	0x97, 0xDA,
	0xFF, 0xFF,
	0xFB, 0x6B,
	0xE0, 0xF2,
	0xEA, 0xA2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xF0,
	0xE0, 0xF3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xE5,
	0xE0, 0xF1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0xBA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xF4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xF5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x9E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0x6C,
	0xFF, 0xFF,
	0xE0, 0xF6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xF7,
	0xFB, 0x6D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xE3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xF8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xC2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0xA3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xF9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xFA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xFB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x5A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0x40,
	0xFF, 0xFF,
	0x95, 0x5A,
	0xE1, 0x41,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xA2,
	0xE1, 0x42,
	0xFF, 0xFF,
	0xE1, 0x43,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0x44,
	0xFF, 0xFF,
	0xE1, 0x46,
	0xE1, 0x47,
	0xE1, 0x45,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0x72,
	0xE1, 0x49,
	0xE1, 0x48,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_75[512] = {
	0xFF, 0xFF,
	0xFB, 0x6E,
	0xFF, 0xFF,
	0xE1, 0x4B,
	0xE1, 0x4A,
	0xE1, 0x4C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0x4D,
	0xE1, 0x4F,
	0xE1, 0x4E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0x99,
	0xFF, 0xFF,
	0xE1, 0x51,
	0xFF, 0xFF,
	0xE1, 0x50,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xC3,
	0xFF, 0xFF,
	0x90, 0x72,
	0xFF, 0xFF,
	0x93, 0x5B,
	0xFF, 0xFF,
	0xE1, 0x52,
	0x90, 0xB6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x59,
	0xFF, 0xFF,
	0x89, 0x99,
	0xE1, 0x53,
	0xFF, 0xFF,
	0x97, 0x70,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xE1,
	0xE1, 0x54,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0xA8,
	0x93, 0x63,
	0x97, 0x52,
	0x8D, 0x62,
	0x90, 0x5C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x6A,
	0x99, 0xB2,
	0xFF, 0xFF,
	0x92, 0xAC,
	0x89, 0xE6,
	0xE1, 0x55,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0x56,
	0xFF, 0xFF,
	0xE1, 0x5B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0x59,
	0xE1, 0x58,
	0x9D, 0xC0,
	0x8A, 0x45,
	0xE1, 0x57,
	0xFF, 0xFF,
	0x88, 0xD8,
	0xFF, 0xFF,
	0x94, 0xA8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xC8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0xAF,
	0xE1, 0x5C,
	0xE1, 0x5A,
	0x92, 0x7B,
	0x90, 0xA4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xA9,
	0xFF, 0xFF,
	0x95, 0x4C,
	0xFF, 0xFF,
	0xE1, 0x5E,
	0x97, 0xAA,
	0x8C, 0x6C,
	0xE1, 0x5F,
	0xFF, 0xFF,
	0xE1, 0x5D,
	0x94, 0xD4,
	0xE1, 0x60,
	0xFF, 0xFF,
	0xE1, 0x61,
	0xFF, 0xFF,
	0xFB, 0x6F,
	0x88, 0xD9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0xF4,
	0xE1, 0x66,
	0xFF, 0xFF,
	0xE1, 0x63,
	0x93, 0xEB,
	0xE1, 0x62,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x45,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0x69,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0x64,
	0xE1, 0x65,
	0xFF, 0xFF,
	0xE1, 0x68,
	0xE1, 0x67,
	0x95, 0x44,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x61,
	0x91, 0x60,
	0xFF, 0xFF,
	0x8B, 0x5E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0x6A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0x6B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0x6C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0x6E,
	0xFF, 0xFF,
	0xE1, 0x6D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x75,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0x76,
	0x94, 0xE6,
	0xE1, 0x70,
	0xFF, 0xFF,
	0xE1, 0x72,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0x74,
	0x90, 0x5D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0x75,
	0xE1, 0x73,
	0x8E, 0xBE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0x6F,
	0xE1, 0x71,
	0xFF, 0xFF,
	0x95, 0x61,
	0xFF, 0xFF,
	0x8F, 0xC7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0x78,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0x77,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0x79,
	0xFF, 0xFF,
	0x8E, 0xA4,
	0x8D, 0xAD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x97,
	0xE1, 0x7A,
	0xFF, 0xFF,
	0x92, 0xC9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0x7C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x9F,
	0xE1, 0x7B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x89,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0x82,
	0xFF, 0xFF,
	0xE1, 0x84,
	0xE1, 0x85,
	0x92, 0x73,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0x83,
	0xFF, 0xFF,
	0xE1, 0x80,
	0xFF, 0xFF,
	0xE1, 0x7D,
	0xE1, 0x7E
};

static unsigned char low_76[512] = {
	0xFF, 0xFF,
	0xE1, 0x81,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0x88,
	0xFF, 0xFF,
	0xE1, 0x86,
	0xFF, 0xFF,
	0xE1, 0x87,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0x89,
	0xE1, 0x8B,
	0xE1, 0x8C,
	0xE1, 0x8D,
	0xFF, 0xFF,
	0xE1, 0x8E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0x8A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0x90,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0x8F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0x91,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0xC3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0x94,
	0xE1, 0x92,
	0xE1, 0x93,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xE0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0xFC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xC8,
	0xFF, 0xFF,
	0xE1, 0x96,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0x95,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0x97,
	0xE1, 0x98,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0x9C,
	0xE1, 0x99,
	0xE1, 0x9A,
	0xE1, 0x9B,
	0xFF, 0xFF,
	0xE1, 0x9D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0x9E,
	0xFF, 0xFF,
	0xE1, 0x9F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xA0,
	0xFF, 0xFF,
	0xE1, 0xA1,
	0xFF, 0xFF,
	0x94, 0xAD,
	0x93, 0x6F,
	0xE1, 0xA2,
	0x94, 0x92,
	0x95, 0x53,
	0xFF, 0xFF,
	0xE1, 0xA3,
	0xFF, 0xFF,
	0xFB, 0x70,
	0xE1, 0xA4,
	0x93, 0x49,
	0xFF, 0xFF,
	0x8A, 0x46,
	0x8D, 0x63,
	0xE1, 0xA5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xA6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xA7,
	0xFF, 0xFF,
	0x8E, 0x48,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xA9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xA8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xAA,
	0xE1, 0xAB,
	0xFB, 0x73,
	0xFB, 0x71,
	0xFF, 0xFF,
	0xFB, 0x72,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0x74,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xE7,
	0xFF, 0xFF,
	0xE1, 0xAC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xAD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x89,
	0xE1, 0xAE,
	0xE1, 0xAF,
	0xE1, 0xB0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x4D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xB1,
	0x94, 0x75,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x7E,
	0xFF, 0xFF,
	0x89, 0x6D,
	0xFF, 0xFF,
	0x89, 0x76,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xB2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xB4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xB3,
	0x93, 0x90,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0xB7,
	0x9F, 0x58,
	0xFF, 0xFF,
	0xE1, 0xB5,
	0x96, 0xBF,
	0xFF, 0xFF,
	0xE1, 0xB6,
	0xFF, 0xFF,
	0x8A, 0xC4,
	0x94, 0xD5,
	0xE1, 0xB7,
	0xFF, 0xFF,
	0xE1, 0xB8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xB9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0xDA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0xD3,
	0xFF, 0xFF,
	0x92, 0xBC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x8A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xBB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x82,
	0xFF, 0xFF
};

static unsigned char low_77[512] = {
	0xFF, 0xFF,
	0x8F, 0xC8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xBE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xBD,
	0xE1, 0xBC,
	0x94, 0xFB,
	0xFF, 0xFF,
	0x8A, 0xC5,
	0x8C, 0xA7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xC4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xC1,
	0x90, 0x5E,
	0x96, 0xB0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xC0,
	0xE1, 0xC2,
	0xE1, 0xC3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xBF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xC5,
	0xE1, 0xC6,
	0xFF, 0xFF,
	0x92, 0xAD,
	0xFF, 0xFF,
	0x8A, 0xE1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x85,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0x76,
	0xE1, 0xC7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xC8,
	0xE1, 0xCB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x87,
	0xFF, 0xFF,
	0x93, 0xC2,
	0xFF, 0xFF,
	0xE1, 0xCC,
	0x96, 0x72,
	0xFF, 0xFF,
	0xE1, 0xC9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xCA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xCF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xCE,
	0xE1, 0xCD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xD1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xD0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xD2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xD4,
	0xFF, 0xFF,
	0xE1, 0xD3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xCB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x75,
	0x97, 0xC4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xD5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xB5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xD6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xD7,
	0xFF, 0xFF,
	0xE1, 0xDB,
	0xE1, 0xD9,
	0xE1, 0xDA,
	0xFF, 0xFF,
	0xE1, 0xD8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xDC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xDD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xDE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xDF,
	0x96, 0xB5,
	0xE1, 0xE0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0xEE,
	0xE1, 0xE1,
	0xFF, 0xFF,
	0x92, 0x6D,
	0xFF, 0xFF,
	0x94, 0x8A,
	0xFF, 0xFF,
	0x8B, 0xE9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x5A,
	0xE1, 0xE2,
	0x8B, 0xB8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0xCE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xE3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_78[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0xBB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xE4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xE5,
	0xFF, 0xFF,
	0x8C, 0xA4,
	0x8D, 0xD3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xE7,
	0xFB, 0x78,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x75,
	0x8D, 0xD4,
	0x8B, 0x6D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x43,
	0xFF, 0xFF,
	0x94, 0x6A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x76,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0x7B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xE9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0x79,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0xC9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0x7A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0xB0,
	0x8D, 0x64,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xA5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xA1,
	0xFF, 0xFF,
	0xE1, 0xEB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0x7B,
	0xFF, 0xFF,
	0xE1, 0xED,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xE9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xEC,
	0x92, 0xF4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xEF,
	0x8A, 0x56,
	0xE1, 0xEA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xE8,
	0xFF, 0xFF,
	0x89, 0x4F,
	0xFF, 0xFF,
	0x8D, 0xEA,
	0xFF, 0xFF,
	0x98, 0x71,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xEE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xF0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xC9,
	0xFF, 0xFF,
	0x90, 0xD7,
	0xE1, 0xF2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xF3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xF1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x6D,
	0xFF, 0xFF,
	0xE1, 0xF9,
	0xFF, 0xFF,
	0xE1, 0xF8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0xA5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xFA,
	0xE1, 0xF5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xFB,
	0xE1, 0xF6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xD6,
	0xE1, 0xF4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xF7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x41,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x40,
	0x96, 0x81,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xFC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x88, 0xE9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x43,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x42,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_79[512] = {
	0xFF, 0xFF,
	0x8F, 0xCA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x44,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x62,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x46,
	0xE2, 0x45,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x47,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xE6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE1, 0xE8,
	0xE2, 0x49,
	0xE2, 0x48,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0x7C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0xA6,
	0xFF, 0xFF,
	0x97, 0xE7,
	0xFF, 0xFF,
	0x8E, 0xD0,
	0xFF, 0xFF,
	0xE2, 0x4A,
	0x8C, 0x56,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x5F,
	0x8B, 0x46,
	0x8E, 0x83,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x53,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x50,
	0xFF, 0xFF,
	0xE2, 0x4F,
	0x91, 0x63,
	0xE2, 0x4C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x4E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x6A,
	0x90, 0x5F,
	0xE2, 0x4D,
	0xE2, 0x4B,
	0xFF, 0xFF,
	0x94, 0x49,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0xCB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0x5B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0xD5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x98,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x51,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x52,
	0xE2, 0x68,
	0x8B, 0xD6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0x5C,
	0x91, 0x54,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x53,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xD0,
	0x92, 0xF5,
	0x95, 0x9F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0x81,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0x83,
	0xFF, 0xFF,
	0xE2, 0x54,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x9A,
	0xE2, 0x55,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x57,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x58,
	0xFF, 0xFF,
	0x94, 0x48,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x59,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x5A,
	0xE2, 0x5B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xD7,
	0x89, 0xD1,
	0x93, 0xC3,
	0x8F, 0x47,
	0x8E, 0x84,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x5C,
	0xFF, 0xFF,
	0x8F, 0x48,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xC8,
	0x95, 0x62,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x5D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xE9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x64,
	0xFF, 0xFF,
	0xE2, 0x60,
	0xFF, 0xFF,
	0xE2, 0x61,
	0x94, 0x89,
	0xFF, 0xFF,
	0x90, 0x60,
	0xE2, 0x5E,
	0xFF, 0xFF,
	0x92, 0x81,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x5F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0xCC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x88, 0xDA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_7A[512] = {
	0x8B, 0x48,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x62,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0xF6,
	0xFF, 0xFF,
	0xE2, 0x63,
	0x90, 0xC5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0xAB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0x42,
	0xE2, 0x64,
	0xE2, 0x65,
	0x92, 0x74,
	0xFF, 0xFF,
	0x97, 0xC5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x67,
	0xE2, 0x66,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0xED,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x69,
	0x88, 0xEE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x6C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x6A,
	0x89, 0xD2,
	0x8C, 0x6D,
	0xE2, 0x6B,
	0x8D, 0x65,
	0x8D, 0x92,
	0xFF, 0xFF,
	0x95, 0xE4,
	0xE2, 0x6D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x73,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x6F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0xCF,
	0x89, 0x6E,
	0x89, 0xB8,
	0x88, 0xAA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x6E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x70,
	0xE2, 0x71,
	0x8F, 0xF5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x72,
	0xFF, 0xFF,
	0x8A, 0x6E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x74,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x8A,
	0xFF, 0xFF,
	0x8B, 0x86,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x75,
	0x8B, 0xF3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x76,
	0xFF, 0xFF,
	0x90, 0xFA,
	0xFF, 0xFF,
	0x93, 0xCB,
	0xFF, 0xFF,
	0x90, 0xDE,
	0x8D, 0xF3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x77,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x82,
	0x91, 0x8B,
	0xFF, 0xFF,
	0xE2, 0x79,
	0xE2, 0x7B,
	0xE2, 0x78,
	0xE2, 0x7A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x41,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x7C,
	0x8C, 0x45,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x87,
	0x97, 0x71,
	0xE2, 0x7E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x80,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x4D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x83,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x96,
	0xE2, 0x82,
	0xE2, 0x81,
	0xFF, 0xFF,
	0xE2, 0x85,
	0xE2, 0x7D,
	0xFF, 0xFF,
	0xE2, 0x86,
	0x97, 0xA7,
	0xFF, 0xFF,
	0xE2, 0x87,
	0xFF, 0xFF,
	0xE2, 0x88,
	0xFF, 0xFF,
	0xFB, 0x84,
	0x9A, 0xF2,
	0xE2, 0x8A,
	0xFF, 0xFF,
	0xE2, 0x89,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x8B,
	0xE2, 0x8C,
	0xFF, 0xFF,
	0x97, 0xB3,
	0xE2, 0x8D,
	0xFF, 0xFF,
	0xE8, 0xED,
	0x8F, 0xCD,
	0xE2, 0x8E,
	0xE2, 0x8F,
	0x8F, 0x76,
	0xFF, 0xFF,
	0x93, 0xB6,
	0xE2, 0x90,
	0xFB, 0x85,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x47,
	0xFB, 0x87,
	0xFF, 0xFF,
	0xE2, 0x91,
	0xFF, 0xFF,
	0x92, 0x5B,
	0xE2, 0x92,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xA3,
	0xFF, 0xFF,
	0x99, 0x5E,
	0x92, 0x7C,
	0x8E, 0xB1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xC6
};

static unsigned char low_7B[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x93,
	0xFF, 0xFF,
	0xE2, 0xA0,
	0xFF, 0xFF,
	0xE2, 0x96,
	0xFF, 0xFF,
	0x8B, 0x88,
	0xFF, 0xFF,
	0xE2, 0x95,
	0xE2, 0xA2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x94,
	0xFF, 0xFF,
	0x8F, 0xCE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x98,
	0xE2, 0x99,
	0xFF, 0xFF,
	0x93, 0x4A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x9A,
	0xFF, 0xFF,
	0x8A, 0x7D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x79,
	0x95, 0x84,
	0xFF, 0xFF,
	0xE2, 0x9C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0xE6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x97,
	0xFF, 0xFF,
	0xE2, 0x9B,
	0xE2, 0x9D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0xF9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xA4,
	0x95, 0x4D,
	0xFF, 0xFF,
	0x94, 0xA4,
	0x93, 0x99,
	0xFF, 0xFF,
	0x8B, 0xD8,
	0xE2, 0xA3,
	0xE2, 0xA1,
	0xFF, 0xFF,
	0x94, 0xB3,
	0xE2, 0x9E,
	0x92, 0x7D,
	0x93, 0x9B,
	0xFF, 0xFF,
	0x93, 0x9A,
	0xFF, 0xFF,
	0x8D, 0xF4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xB6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xA6,
	0xFF, 0xFF,
	0xE2, 0xA8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xAB,
	0xFF, 0xFF,
	0xE2, 0xAC,
	0xFF, 0xFF,
	0xE2, 0xA9,
	0xE2, 0xAA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xA7,
	0xE2, 0xA5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0x9F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xCD,
	0x89, 0xD3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xB3,
	0xFF, 0xFF,
	0xE2, 0xB0,
	0xFF, 0xFF,
	0xE2, 0xB5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xB4,
	0xFF, 0xFF,
	0x94, 0x93,
	0x96, 0xA5,
	0xFF, 0xFF,
	0x8E, 0x5A,
	0xE2, 0xAE,
	0xE2, 0xB7,
	0xE2, 0xB2,
	0xFF, 0xFF,
	0xE2, 0xB1,
	0xE2, 0xAD,
	0xFB, 0x88,
	0xE2, 0xAF,
	0xFF, 0xFF,
	0x8A, 0xC7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x5C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0xFB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xA0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xBC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xA2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0xDF,
	0xE2, 0xB9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xCD,
	0xFF, 0xFF,
	0xE2, 0xBD,
	0x95, 0xD1,
	0xFF, 0xFF,
	0x92, 0x7A,
	0xFF, 0xFF,
	0xE2, 0xB8,
	0xE2, 0xBA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xBB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xBE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0xC2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xC4,
	0xE2, 0xC3,
	0xE2, 0xC2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xBF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0x55,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xC8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xCC,
	0xE2, 0xC9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_7C[512] = {
	0xE2, 0xC5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xC6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xCB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xC0,
	0x99, 0xD3,
	0xE2, 0xC7,
	0xE2, 0xC1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xCA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xD0,
	0xFF, 0xFF,
	0x8A, 0xC8,
	0xFF, 0xFF,
	0xE2, 0xCD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xCE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xCF,
	0xE2, 0xD2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xD1,
	0x94, 0xF4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xD3,
	0x97, 0xFA,
	0x95, 0xEB,
	0xE2, 0xD8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xD5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xD4,
	0x90, 0xD0,
	0xFF, 0xFF,
	0xE2, 0xD7,
	0xE2, 0xD9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xD6,
	0xFF, 0xFF,
	0xE2, 0xDD,
	0xFF, 0xFF,
	0xE2, 0xDA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xDB,
	0xE2, 0xC4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xDC,
	0xE2, 0xDE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xDF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xC4,
	0xFF, 0xFF,
	0xE2, 0xE0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0xE0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xCC,
	0x8C, 0x48,
	0xE2, 0xE1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xB2,
	0xFF, 0xFF,
	0x90, 0x88,
	0xFF, 0xFF,
	0x96, 0xAE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xE2,
	0xFF, 0xFF,
	0x97, 0xB1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0x94,
	0xFF, 0xFF,
	0x91, 0x65,
	0x94, 0x53,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x6C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x88, 0xBE,
	0xFF, 0xFF,
	0xE2, 0xE7,
	0xE2, 0xE5,
	0xFF, 0xFF,
	0xE2, 0xE3,
	0x8A, 0x9F,
	0xFF, 0xFF,
	0x8F, 0xCF,
	0xE2, 0xE8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xE6,
	0xFF, 0xFF,
	0xE2, 0xE4,
	0xE2, 0xEC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xEB,
	0xE2, 0xEA,
	0xE2, 0xE9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xED,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xEE,
	0x90, 0xB8,
	0xFF, 0xFF,
	0xE2, 0xEF,
	0xFF, 0xFF,
	0xE2, 0xF1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xF0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xD0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x57,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xF3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x9C,
	0xFF, 0xFF,
	0xE2, 0xF2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xF4,
	0xFF, 0xFF,
	0x95, 0xB3,
	0x91, 0x8C,
	0x8D, 0x66,
	0xFF, 0xFF,
	0xE2, 0xF5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0xC6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xF7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xF8,
	0xFF, 0xFF,
	0xE2, 0xF9,
	0xFF, 0xFF,
	0xE2, 0xFA,
	0xFF, 0xFF,
	0x8E, 0x85,
	0xFF, 0xFF,
	0xE2, 0xFB,
	0x8C, 0x6E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x8A,
	0xFF, 0xFF
};

static unsigned char low_7D[512] = {
	0x8B, 0x49,
	0xFF, 0xFF,
	0xE3, 0x40,
	0xFF, 0xFF,
	0x96, 0xF1,
	0x8D, 0x67,
	0xE2, 0xFC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0x43,
	0x96, 0xE4,
	0xFF, 0xFF,
	0x94, 0x5B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0x52,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x83,
	0xE3, 0x42,
	0xFF, 0xFF,
	0x8E, 0xD1,
	0x8D, 0x68,
	0x8E, 0x86,
	0x8B, 0x89,
	0x95, 0xB4,
	0xE3, 0x41,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x66,
	0x96, 0x61,
	0x8D, 0xF5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x87,
	0x92, 0xDB,
	0xFF, 0xFF,
	0xE3, 0x46,
	0x97, 0xDD,
	0x8D, 0xD7,
	0xFF, 0xFF,
	0xE3, 0x47,
	0x90, 0x61,
	0xFF, 0xFF,
	0xE3, 0x49,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0xD0,
	0x8D, 0xAE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0x48,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x49,
	0x8C, 0xBC,
	0x91, 0x67,
	0xE3, 0x44,
	0xE3, 0x4A,
	0xFF, 0xFF,
	0xFB, 0x8A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0x45,
	0x8C, 0x6F,
	0xFF, 0xFF,
	0xE3, 0x4D,
	0xE3, 0x51,
	0x8C, 0x8B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0x4C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0x55,
	0xFB, 0x8B,
	0xFF, 0xFF,
	0x8D, 0x69,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x8D,
	0x88, 0xBA,
	0xE3, 0x52,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x8B,
	0xFF, 0xFF,
	0xE3, 0x4F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0x50,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x9D,
	0xE3, 0x4E,
	0xE3, 0x4B,
	0xFF, 0xFF,
	0x8A, 0x47,
	0x90, 0xE2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xA6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0x57,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0x54,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0x56,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0x53,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x70,
	0x91, 0xB1,
	0xE3, 0x58,
	0x91, 0x8E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0x65,
	0xFB, 0x8D,
	0xFF, 0xFF,
	0xE3, 0x61,
	0xE3, 0x5B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0x5F,
	0x8E, 0xF8,
	0x88, 0xDB,
	0xE3, 0x5A,
	0xE3, 0x62,
	0xE3, 0x66,
	0x8D, 0x6A,
	0x96, 0xD4,
	0xFF, 0xFF,
	0x92, 0xD4,
	0xE3, 0x5C,
	0xFF, 0xFF,
	0xFB, 0x8C,
	0xE3, 0x64,
	0xFF, 0xFF,
	0xE3, 0x59,
	0x92, 0x5D,
	0xFF, 0xFF,
	0xE3, 0x5E,
	0x88, 0xBB,
	0x96, 0xC8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0x5D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xD9,
	0x94, 0xEA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x8D,
	0xFF, 0xFF,
	0x97, 0xCE,
	0x8F, 0x8F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0x8E,
	0xFB, 0x8E,
	0xFF, 0xFF,
	0xE3, 0x67,
	0xFF, 0xFF,
	0x90, 0xFC,
	0xFF, 0xFF,
	0xE3, 0x63,
	0xE3, 0x68,
	0xE3, 0x6A,
	0xFF, 0xFF,
	0x92, 0xF7,
	0xE3, 0x6D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0x69,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xD2,
	0x8A, 0xC9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0xC9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x88, 0xDC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0x6C,
	0xFF, 0xFF,
	0x97, 0xFB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0x6B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_7E[512] = {
	0xFF, 0xFF,
	0x89, 0x8F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xEA,
	0xE3, 0x6E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0x75,
	0xE3, 0x6F,
	0xE3, 0x76,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0x72,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0x9B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0xC8,
	0xE3, 0x74,
	0xFF, 0xFF,
	0xE3, 0x71,
	0xE3, 0x77,
	0xE3, 0x70,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x63,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x44,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x6B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0x73,
	0xE3, 0x80,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0x7B,
	0xFF, 0xFF,
	0xE3, 0x7E,
	0xFF, 0xFF,
	0xE3, 0x7C,
	0xE3, 0x81,
	0xE3, 0x7A,
	0xFF, 0xFF,
	0xE3, 0x60,
	0x90, 0xD1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xC9,
	0xFF, 0xFF,
	0xE3, 0x7D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0x78,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x40,
	0x8C, 0x71,
	0xFF, 0xFF,
	0x8F, 0x4A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0x8F,
	0xFF, 0xFF,
	0x90, 0x44,
	0x91, 0x55,
	0xE3, 0x84,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0x86,
	0xE3, 0x87,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0x83,
	0xE3, 0x85,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0x79,
	0xE3, 0x82,
	0xFF, 0xFF,
	0xE3, 0x8A,
	0xE3, 0x89,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x9A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x4A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0x88,
	0xFF, 0xFF,
	0xE3, 0x8C,
	0xE3, 0x8B,
	0xE3, 0x8F,
	0xFF, 0xFF,
	0xE3, 0x91,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x5B,
	0xE3, 0x8D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0x92,
	0xE3, 0x93,
	0xFA, 0x5C,
	0xFF, 0xFF,
	0xE3, 0x94,
	0xFF, 0xFF,
	0xE3, 0x9A,
	0x93, 0x5A,
	0xE3, 0x96,
	0xFF, 0xFF,
	0xE3, 0x95,
	0xE3, 0x97,
	0xE3, 0x98,
	0xFF, 0xFF,
	0xE3, 0x99,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0x9B,
	0xE3, 0x9C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_7F[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xCA,
	0xFF, 0xFF,
	0xE3, 0x9D,
	0xFF, 0xFF,
	0xE3, 0x9E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0x9F,
	0xFF, 0xFF,
	0xFB, 0x90,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xA0,
	0xE3, 0xA1,
	0xE3, 0xA2,
	0xFF, 0xFF,
	0xE3, 0xA3,
	0xE3, 0xA4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xA6,
	0xE3, 0xA5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xA7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xA8,
	0xE3, 0xA9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xAC,
	0xE3, 0xAA,
	0xE3, 0xAB,
	0x8D, 0xDF,
	0x8C, 0x72,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x75,
	0xFF, 0xFF,
	0x94, 0xB1,
	0xFF, 0xFF,
	0x8F, 0x90,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0x6C,
	0xFF, 0xFF,
	0x94, 0xEB,
	0xE3, 0xAD,
	0x9C, 0xEB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xAE,
	0xE3, 0xB0,
	0xFF, 0xFF,
	0x97, 0x85,
	0xE3, 0xAF,
	0xE3, 0xB2,
	0xE3, 0xB1,
	0xFF, 0xFF,
	0x97, 0x72,
	0xFF, 0xFF,
	0xE3, 0xB3,
	0xFF, 0xFF,
	0x94, 0xFC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xB4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xB7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xB6,
	0xE3, 0xB5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0x91,
	0xFF, 0xFF,
	0xE3, 0xB8,
	0x8C, 0x51,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x41,
	0x8B, 0x60,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xBC,
	0xE3, 0xB9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xBA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xBD,
	0xFF, 0xFF,
	0xE3, 0xBE,
	0xE3, 0xBB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x48,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xA5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xC0,
	0xE3, 0xC1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xC2,
	0xFF, 0xFF,
	0x97, 0x82,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x4B,
	0xFF, 0xFF,
	0xE3, 0xC4,
	0xE3, 0xC3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x89,
	0xE3, 0xC5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xC6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xC7,
	0xFF, 0xFF,
	0x8A, 0xE3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xCB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xC8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xC9,
	0xFF, 0xFF,
	0x96, 0x7C,
	0x97, 0x83,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_80[512] = {
	0x97, 0x73,
	0x98, 0x56,
	0xFF, 0xFF,
	0x8D, 0x6C,
	0xE3, 0xCC,
	0x8E, 0xD2,
	0xE3, 0xCB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xCD,
	0x8E, 0xA7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0xCF,
	0xFF, 0xFF,
	0xE3, 0xCE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0x6B,
	0xFF, 0xFF,
	0x96, 0xD5,
	0xE3, 0xCF,
	0xE3, 0xD0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xD1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xD2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xD3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0xA8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0xEB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xD5,
	0xFF, 0xFF,
	0x92, 0x5E,
	0xFF, 0xFF,
	0xE3, 0xD4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xD7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xD6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xD8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0xB9,
	0xFF, 0xFF,
	0xE3, 0xD9,
	0xFF, 0xFF,
	0xE3, 0xDA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xB7,
	0xE3, 0xDB,
	0xFF, 0xFF,
	0x91, 0x8F,
	0xE3, 0xDC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xDD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0xFC,
	0xE3, 0xE0,
	0xFF, 0xFF,
	0xE3, 0xDF,
	0xE3, 0xDE,
	0x92, 0xAE,
	0xFF, 0xFF,
	0xE3, 0xE1,
	0x90, 0x45,
	0xFF, 0xFF,
	0xE3, 0xE2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xE3,
	0x98, 0x57,
	0xE3, 0xE4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xE5,
	0xE3, 0xE7,
	0xE3, 0xE6,
	0x94, 0xA3,
	0xFF, 0xFF,
	0x93, 0xF7,
	0xFF, 0xFF,
	0x98, 0x5D,
	0x94, 0xA7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xE9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0xD1,
	0xFF, 0xFF,
	0x95, 0x49,
	0xFF, 0xFF,
	0xE3, 0xEA,
	0xE3, 0xE8,
	0xFF, 0xFF,
	0x8A, 0xCC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xD2,
	0x8E, 0x88,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xEC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xA8,
	0x96, 0x62,
	0xFF, 0xFF,
	0xE3, 0xED,
	0xE3, 0xEB,
	0xFF, 0xFF,
	0x8D, 0x6D,
	0xFF, 0xFF,
	0x8D, 0x6E,
	0x88, 0xE7,
	0xFF, 0xFF,
	0x8D, 0xE6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0x78,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x88, 0xDD,
	0xE3, 0xF2,
	0xFF, 0xFF,
	0x92, 0x5F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0x77,
	0xFF, 0xFF,
	0x91, 0xD9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xF4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xF0,
	0xE3, 0xF3,
	0xE3, 0xEE,
	0xFF, 0xFF,
	0xE3, 0xF1,
	0x96, 0x45,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xD3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x88, 0xFB,
	0xE3, 0xEF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xF6,
	0xFF, 0xFF,
	0xE3, 0xF7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xB7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xB9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0x45,
	0x94, 0x5C,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_81[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x89,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xBA,
	0x90, 0xC6,
	0x98, 0x65,
	0x96, 0xAC,
	0xE3, 0xF5,
	0x90, 0xD2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x72,
	0xE3, 0xF8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xFA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xF9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xFB,
	0xFF, 0xFF,
	0x92, 0x45,
	0xFF, 0xFF,
	0x94, 0x5D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0xAF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0x42,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0x41,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE3, 0xFC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x74,
	0xFF, 0xFF,
	0x95, 0x85,
	0xE4, 0x44,
	0xFF, 0xFF,
	0xE4, 0x43,
	0x8D, 0x6F,
	0x98, 0x72,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0x54,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0x48,
	0xE4, 0x49,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0xEE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0x47,
	0xFF, 0xFF,
	0x8D, 0x98,
	0xE4, 0x46,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0x4A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0xB0,
	0x95, 0xA0,
	0x91, 0x42,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0xDA,
	0xE4, 0x4E,
	0xFF, 0xFF,
	0xE4, 0x4F,
	0xE4, 0x4B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0x4C,
	0xFF, 0xFF,
	0xE4, 0x4D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0x70,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0x55,
	0xFF, 0xFF,
	0xE4, 0x51,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0x86,
	0xFF, 0xFF,
	0x96, 0x8C,
	0x95, 0x47,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0x50,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0x53,
	0xE4, 0x52,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x63,
	0xE4, 0x56,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0x57,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x56,
	0xFF, 0xFF,
	0xE4, 0x58,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0x5A,
	0xFF, 0xFF,
	0xE4, 0x5E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0x5B,
	0xE4, 0x59,
	0x94, 0x5E,
	0xE4, 0x5C,
	0xFF, 0xFF,
	0xE4, 0x5D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xB0,
	0xFF, 0xFF,
	0xE4, 0x64,
	0xE4, 0x5F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0x60,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0x61,
	0xFF, 0xFF,
	0x91, 0x9F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0x63,
	0xE4, 0x62,
	0xE4, 0x65,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0x66,
	0xE4, 0x67,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x62,
	0xFF, 0xFF,
	0x89, 0xE7,
	0xFF, 0xFF,
	0xE4, 0x68,
	0x97, 0xD5,
	0xFF, 0xFF,
	0x8E, 0xA9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x4C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x8A,
	0x92, 0x76,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0x69,
	0xE4, 0x6A,
	0x89, 0x50,
	0xFF, 0xFF,
	0xE4, 0x6B,
	0xFF, 0xFF
};

static unsigned char low_82[512] = {
	0xFF, 0xFF,
	0xE4, 0x6C,
	0xE4, 0x6D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0x6E,
	0xFF, 0xFF,
	0xE4, 0x6F,
	0x8B, 0xBB,
	0x9D, 0xA8,
	0xE4, 0x70,
	0xFF, 0xFF,
	0x90, 0xE3,
	0xE4, 0x71,
	0x8E, 0xC9,
	0xFF, 0xFF,
	0xE4, 0x72,
	0xFF, 0xFF,
	0x98, 0xAE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0x73,
	0x95, 0xDC,
	0x8A, 0xDA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x43,
	0x8F, 0x77,
	0xFF, 0xFF,
	0x95, 0x91,
	0x8F, 0x4D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0x74,
	0x8D, 0x71,
	0xE4, 0x75,
	0x94, 0xCA,
	0xFF, 0xFF,
	0xE4, 0x84,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0x77,
	0xFF, 0xFF,
	0x91, 0xC7,
	0x94, 0x95,
	0x8C, 0xBD,
	0xE4, 0x76,
	0x91, 0x44,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0x78,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0xF8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0x7A,
	0xE4, 0x79,
	0xE4, 0x7C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0x7B,
	0xFF, 0xFF,
	0xE4, 0x7D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0x80,
	0xFF, 0xFF,
	0xE4, 0x7E,
	0xFF, 0xFF,
	0x8A, 0xCD,
	0xFF, 0xFF,
	0xE4, 0x81,
	0xFF, 0xFF,
	0xE4, 0x82,
	0xE4, 0x83,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0xAF,
	0x97, 0xC7,
	0xFF, 0xFF,
	0xE4, 0x85,
	0x90, 0x46,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x90,
	0xE4, 0x86,
	0xE4, 0x87,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0x88,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x88, 0xF0,
	0xFF, 0xFF,
	0xE4, 0x89,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0x8A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0x87,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0xC5,
	0xFF, 0xFF,
	0xE4, 0x8C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x48,
	0x88, 0xB0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0x8B,
	0xE4, 0x8E,
	0x94, 0x6D,
	0xFF, 0xFF,
	0x90, 0x63,
	0xFF, 0xFF,
	0x89, 0xD4,
	0xFF, 0xFF,
	0x96, 0x46,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x7C,
	0x8B, 0xDA,
	0xFF, 0xFF,
	0xE4, 0x8D,
	0xFF, 0xFF,
	0x89, 0xE8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xA1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x91,
	0xE4, 0x92,
	0x97, 0xE8,
	0x91, 0xDB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0x63,
	0xFF, 0xFF,
	0xE4, 0x9E,
	0xFF, 0xFF,
	0x89, 0xD5,
	0xE4, 0x9C,
	0xFF, 0xFF,
	0xE4, 0x9A,
	0xE4, 0x91,
	0xFF, 0xFF,
	0xE4, 0x8F,
	0xFF, 0xFF,
	0xE4, 0x90,
	0xFF, 0xFF,
	0x8E, 0xE1,
	0x8B, 0xEA,
	0x92, 0x97,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xCF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x70,
	0xFF, 0xFF,
	0xE4, 0x94,
	0xE4, 0x93,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0x99,
	0xE4, 0x95,
	0xE4, 0x98,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_83[512] = {
	0xFF, 0xFF,
	0xFB, 0x93,
	0x96, 0xCE,
	0xE4, 0x97,
	0x89, 0xD6,
	0x8A, 0x9D,
	0xE4, 0x9B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0x9D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x73,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xA1,
	0xE4, 0xAA,
	0xE4, 0xAB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x88, 0xA9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xB2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x88, 0xEF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xA9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xA8,
	0xFF, 0xFF,
	0xE4, 0xA3,
	0xE4, 0xA2,
	0xFF, 0xFF,
	0xE4, 0xA0,
	0xE4, 0x9F,
	0x92, 0x83,
	0xFF, 0xFF,
	0x91, 0xF9,
	0xE4, 0xA5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xA4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xA7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x90,
	0x8C, 0x74,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x60,
	0xE4, 0xA6,
	0xFF, 0xFF,
	0x8D, 0x72,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x91,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0x94,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xB8,
	0xFF, 0xFF,
	0xE4, 0xB9,
	0xFF, 0xFF,
	0x89, 0xD7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xAC,
	0xE4, 0xB6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0x95,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xAC,
	0xFF, 0xFF,
	0xE4, 0xB4,
	0xFF, 0xFF,
	0xE4, 0xBB,
	0xE4, 0xB5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xB3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0x96,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xB1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xAD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xCE,
	0xE4, 0xAF,
	0xE4, 0xBA,
	0xFF, 0xFF,
	0xE4, 0xB0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xBC,
	0xFF, 0xFF,
	0xE4, 0xAE,
	0x94, 0x9C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x89,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xB7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xCD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xC5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x9B,
	0xFF, 0xFF,
	0xFB, 0x96,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x65,
	0xFF, 0xFF,
	0x8B, 0xDB,
	0xFF, 0xFF,
	0xE4, 0xC0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xD9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0xD2,
	0xFF, 0xFF,
	0xE4, 0xC3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0xD8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x70,
	0xE4, 0xC8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xEC,
	0xFF, 0xFF,
	0xE4, 0xBF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xD8,
	0x8C, 0xD4,
	0x95, 0x48,
	0xE4, 0xC9,
	0xFF, 0xFF,
	0xE4, 0xBD,
	0xFF, 0xFF,
	0xFB, 0x97,
	0xE4, 0xC6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xD0,
	0xFF, 0xFF,
	0xE4, 0xC1,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_84[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xC2,
	0x93, 0xB8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xC7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xC4,
	0x96, 0x47,
	0xE4, 0xCA,
	0x88, 0xDE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xBE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xCC,
	0xFF, 0xFF,
	0xE4, 0xCB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0x8B,
	0xE4, 0xD2,
	0xFF, 0xFF,
	0xE4, 0xDD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x9E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xE0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xCE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xD3,
	0x97, 0x8E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xDC,
	0xFF, 0xFF,
	0xFB, 0x98,
	0x97, 0x74,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0xA8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x98,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x8B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0x92,
	0xE4, 0xE2,
	0x93, 0x9F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x88, 0xAF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xDB,
	0xFF, 0xFF,
	0xE4, 0xD7,
	0x91, 0x92,
	0xE4, 0xD1,
	0xE4, 0xD9,
	0xE4, 0xDE,
	0xFF, 0xFF,
	0x94, 0x4B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x88, 0xA8,
	0xFF, 0xFF,
	0xE4, 0xD6,
	0xFF, 0xFF,
	0xE4, 0xDF,
	0x95, 0x98,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xDA,
	0xFF, 0xFF,
	0xE4, 0xD5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0xD3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x4E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0xAA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0xD6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0x66,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xE5,
	0xFF, 0xFF,
	0xE4, 0xEE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xD8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x97,
	0xFF, 0xFF,
	0xFB, 0x99,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0xF6,
	0xE4, 0xE3,
	0xFF, 0xFF,
	0xE4, 0xE8,
	0x91, 0x93,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xE4,
	0xFF, 0xFF,
	0xE4, 0xEB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x7E,
	0xFF, 0xFF,
	0xE4, 0xEC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x75,
	0xE4, 0xE1,
	0x8A, 0x57,
	0xFF, 0xFF,
	0xE4, 0xE7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xEA,
	0x96, 0xAA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xED,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xE6,
	0xE4, 0xE9,
	0xFF, 0xFF,
	0xFA, 0x60,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x48,
	0xFF, 0xFF,
	0x98, 0x40,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xF1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xF8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xF0
};

static unsigned char low_85[512] = {
	0x8E, 0xC1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xCF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xCC,
	0xFF, 0xFF,
	0x96, 0xA0,
	0xE4, 0xF7,
	0xE4, 0xF6,
	0xFF, 0xFF,
	0xE4, 0xF2,
	0xE4, 0xF3,
	0xFF, 0xFF,
	0x89, 0x55,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xF5,
	0xFF, 0xFF,
	0xE4, 0xEF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0xD3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xF4,
	0x88, 0xFC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0xA0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xC1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xF9,
	0xE5, 0x40,
	0xFF, 0xFF,
	0x94, 0xD7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xFC,
	0x8F, 0xD4,
	0x8E, 0xC7,
	0xE5, 0x42,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xBC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0x9A,
	0xFF, 0xFF,
	0xE5, 0x43,
	0xFF, 0xFF,
	0x95, 0x99,
	0xE4, 0xFB,
	0xFB, 0x9B,
	0xE4, 0xD4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE4, 0xFA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0x6E,
	0x93, 0xA0,
	0x95, 0x93,
	0xFB, 0x9C,
	0xFF, 0xFF,
	0xE5, 0x4A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x50,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x51,
	0xFF, 0xFF,
	0xE5, 0x44,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0x96,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x4E,
	0xE5, 0x46,
	0xFF, 0xFF,
	0xE5, 0x48,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x52,
	0xE5, 0x47,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x4B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x92,
	0xFF, 0xFF,
	0x93, 0xE3,
	0xFF, 0xFF,
	0xE5, 0x4C,
	0xE5, 0x4F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x45,
	0xFF, 0xFF,
	0x91, 0x45,
	0xFF, 0xFF,
	0xE5, 0x49,
	0x8E, 0x46,
	0x90, 0x64,
	0x8C, 0x4F,
	0x96, 0xF2,
	0xFF, 0xFF,
	0x96, 0xF7,
	0x8F, 0x92,
	0xFB, 0x9E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x56,
	0xE5, 0x54,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0x6D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x53,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x95,
	0xFF, 0xFF,
	0xE5, 0x55,
	0xE5, 0x57,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x58,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x5B,
	0xE5, 0x59,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xA1,
	0xE5, 0x5A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xCB,
	0xE5, 0x4D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x93,
	0xFF, 0xFF,
	0xE5, 0x5C,
	0xE5, 0x61,
	0x91, 0x94,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x60,
	0xFF, 0xFF
};

static unsigned char low_86[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x41,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x62,
	0x91, 0x68,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x5D,
	0xE5, 0x5F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x5E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9F, 0x50,
	0x9F, 0x41,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x64,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x63,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x96,
	0xFF, 0xFF,
	0xE1, 0xBA,
	0xE5, 0x65,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x66,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x67,
	0x8C, 0xD5,
	0xFF, 0xFF,
	0x8B, 0x73,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x69,
	0x99, 0x7C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x95,
	0xFF, 0xFF,
	0x97, 0xB8,
	0xFF, 0xFF,
	0x8B, 0xF1,
	0xE5, 0x6A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x6B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x8E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x6C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xF8,
	0xFF, 0xFF,
	0x88, 0xB8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xE1,
	0xE5, 0x71,
	0xE5, 0x72,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x6D,
	0xFF, 0xFF,
	0x8E, 0x5C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x6E,
	0x94, 0x61,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x6F,
	0xE5, 0x70,
	0xE5, 0x7A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x74,
	0xE5, 0x77,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x73,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x75,
	0xFF, 0xFF,
	0xE5, 0x76,
	0x8E, 0xD6,
	0xFF, 0xFF,
	0xE5, 0x78,
	0xFF, 0xFF,
	0x92, 0x60,
	0xFF, 0xFF,
	0x8C, 0x75,
	0x8A, 0x61,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x7B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x5E,
	0xFF, 0xFF,
	0xE5, 0x81,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x7C,
	0xE5, 0x80,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xB8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x7D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x7E,
	0x95, 0x67,
	0x94, 0xD8,
	0xE5, 0x82,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0xFB,
	0xE5, 0x8C,
	0xFF, 0xFF,
	0xE5, 0x88,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xE9,
	0xFF, 0xFF
};

static unsigned char low_87[512] = {
	0xE5, 0x86,
	0xFF, 0xFF,
	0x96, 0x49,
	0xE5, 0x87,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x84,
	0xFF, 0xFF,
	0xE5, 0x85,
	0xE5, 0x8A,
	0xE5, 0x8D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x8B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x89,
	0xE5, 0x83,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x77,
	0xFF, 0xFF,
	0xE5, 0x94,
	0xFF, 0xFF,
	0x96, 0xA8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x92,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x93,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x8E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x90,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x91,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x8F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0xE4,
	0xFF, 0xFF,
	0x98, 0x58,
	0xE5, 0x98,
	0xFF, 0xFF,
	0xE5, 0x99,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x9F,
	0xFF, 0xFF,
	0x90, 0x49,
	0xFF, 0xFF,
	0xE5, 0x9B,
	0xFF, 0xFF,
	0xE5, 0x9E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x96,
	0xE5, 0x95,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xA0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xDA,
	0xFF, 0xFF,
	0xE5, 0x9C,
	0xFF, 0xFF,
	0xE5, 0xA1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x9D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0x9A,
	0xFF, 0xFF,
	0x92, 0xB1,
	0xFF, 0xFF,
	0xE5, 0x97,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0x88,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xA5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x5A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xA4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xA3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xAC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xA6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xAE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x86,
	0xE5, 0xB1,
	0xFF, 0xFF,
	0xE5, 0xA8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xA9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xAD,
	0xFF, 0xFF,
	0xE5, 0xB0,
	0xE5, 0xAF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xA7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xAA,
	0xFF, 0xFF,
	0xE5, 0xBB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xB4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xB2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xB3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xB8,
	0xE5, 0xB9,
	0xFF, 0xFF,
	0x8A, 0x49,
	0xFF, 0xFF,
	0x8B, 0x61,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xB7,
	0xFF, 0xFF
};

static unsigned char low_88[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xA2,
	0xFF, 0xFF,
	0xFB, 0xA1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xB6,
	0xE5, 0xBA,
	0xE5, 0xB5,
	0xFF, 0xFF,
	0xE5, 0xBC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xBE,
	0xE5, 0xBD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xC0,
	0xE5, 0xBF,
	0xE5, 0x79,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xC4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xC1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xC2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xC3,
	0xFF, 0xFF,
	0xE5, 0xC5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x8C,
	0xFF, 0xFF,
	0xE5, 0xC7,
	0xFF, 0xFF,
	0xE5, 0xC6,
	0xFF, 0xFF,
	0x8F, 0x4F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0x73,
	0x9F, 0xA5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xC8,
	0x8F, 0x70,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x58,
	0xFF, 0xFF,
	0xE5, 0xC9,
	0xFF, 0xFF,
	0x89, 0x71,
	0xFF, 0xFF,
	0x8F, 0xD5,
	0xE5, 0xCA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0x74,
	0xE5, 0xCB,
	0x88, 0xDF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0x5C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xCC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x8A,
	0xFF, 0xFF,
	0xE5, 0xD3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xD0,
	0xFF, 0xFF,
	0x92, 0x8F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xD1,
	0xE5, 0xCE,
	0x8B, 0xDC,
	0xFF, 0xFF,
	0xE5, 0xCD,
	0xE5, 0xD4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x55,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0xDC,
	0xFF, 0xFF,
	0xE5, 0xDA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xD6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0xB3,
	0xE5, 0xD5,
	0xFF, 0xFF,
	0xE5, 0xD8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xCF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xD9,
	0xFF, 0xFF,
	0xE5, 0xDB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xED,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xD7,
	0xFF, 0xFF,
	0xE5, 0xDC,
	0xE5, 0xDE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xD1,
	0xE5, 0xD2,
	0xFF, 0xFF,
	0x88, 0xBF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xDD,
	0xFF, 0xFF,
	0x8D, 0xD9,
	0x97, 0xF4,
	0xE5, 0xDF,
	0xE5, 0xE0,
	0x91, 0x95,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0xA0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xE1,
	0x97, 0x54,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xE2,
	0xE5, 0xE3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xE2,
	0xE5, 0xE4,
	0xFF, 0xFF,
	0x8D, 0xBE,
	0xFF, 0xFF,
	0x97, 0xA1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xE9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xEA,
	0x8F, 0xD6,
	0xE5, 0xE8,
	0xFB, 0xA2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x87,
	0xE5, 0xE5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xE7,
	0x90, 0xBB,
	0x90, 0x9E,
	0xFF, 0xFF
};

static unsigned char low_89[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xE6,
	0xFF, 0xFF,
	0xE5, 0xEB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xA1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xED,
	0xFF, 0xFF,
	0xE5, 0xEC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x8C,
	0xFF, 0xFF,
	0x96, 0x4A,
	0xE5, 0xEE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0x5D,
	0xE5, 0xFA,
	0xE5, 0xF0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xF1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xF2,
	0xE5, 0xF3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xF7,
	0xFF, 0xFF,
	0xE5, 0xF8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xF6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xF4,
	0xFF, 0xFF,
	0xE5, 0xEF,
	0xE5, 0xF5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xF9,
	0xE8, 0xB5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xA6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE5, 0xFC,
	0x8B, 0xDD,
	0xE5, 0xFB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x41,
	0xFF, 0xFF,
	0xE6, 0x40,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x43,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x42,
	0xFF, 0xFF,
	0xE6, 0x44,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x50,
	0xFF, 0xFF,
	0xE6, 0x45,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x46,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x47,
	0x90, 0xBC,
	0xFF, 0xFF,
	0x97, 0x76,
	0xFF, 0xFF,
	0xE6, 0x48,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xA2,
	0x94, 0x65,
	0xE6, 0x49,
	0xFF, 0xFF,
	0xE6, 0x4A,
	0x8C, 0xA9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x4B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x4B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x8B,
	0x94, 0x60,
	0xE6, 0x4C,
	0xFF, 0xFF,
	0x8A, 0x6F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x4D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x4F,
	0x97, 0x97,
	0xFF, 0xFF,
	0xE6, 0x4E,
	0x90, 0x65,
	0xFF, 0xFF,
	0xE6, 0x50,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x51,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x52,
	0x8A, 0xCF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x53,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x54,
	0xFF, 0xFF,
	0xE6, 0x55,
	0xE6, 0x56,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x70,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x57,
	0xFF, 0xFF,
	0xE6, 0x58,
	0xE6, 0x59,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xF0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x47,
	0xE6, 0x5A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x5B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x5C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_8A[512] = {
	0x8C, 0xBE,
	0xFF, 0xFF,
	0x92, 0xF9,
	0xE6, 0x5D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x76,
	0xFF, 0xFF,
	0x90, 0x75,
	0xFF, 0xFF,
	0xE6, 0x60,
	0xFF, 0xFF,
	0x93, 0xA2,
	0xFF, 0xFF,
	0xE6, 0x5F,
	0xFF, 0xFF,
	0xFB, 0xA3,
	0x8C, 0x50,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x5E,
	0x91, 0xF5,
	0x8B, 0x4C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x61,
	0xFF, 0xFF,
	0xE6, 0x62,
	0xFF, 0xFF,
	0x8F, 0xD7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x8D,
	0xFF, 0xFF,
	0xE6, 0x63,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x4B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0xDD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x96,
	0xFF, 0xFF,
	0x96, 0xF3,
	0x91, 0x69,
	0xFF, 0xFF,
	0xE6, 0x64,
	0xFB, 0xA4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x66,
	0x92, 0x90,
	0x8F, 0xD8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x65,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x68,
	0xFF, 0xFF,
	0xE6, 0x69,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0xBC,
	0x91, 0xC0,
	0xE6, 0x67,
	0xFF, 0xFF,
	0x8F, 0xD9,
	0x95, 0x5D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x66,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x8C,
	0xFF, 0xFF,
	0x89, 0x72,
	0xFF, 0xFF,
	0xE6, 0x6D,
	0x8C, 0x77,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x8E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x8D,
	0xFF, 0xFF,
	0x98, 0x6C,
	0xE6, 0x6C,
	0xE6, 0x6B,
	0x91, 0x46,
	0xFF, 0xFF,
	0x8B, 0x6C,
	0x98, 0x62,
	0x8A, 0x59,
	0x8F, 0xDA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0xA5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x6A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x6F,
	0xFF, 0xFF,
	0xE6, 0x70,
	0xE6, 0x6E,
	0xFF, 0xFF,
	0x8C, 0xD6,
	0xFF, 0xFF,
	0x97, 0x5F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x8F,
	0x94, 0x46,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x73,
	0xFF, 0xFF,
	0x90, 0xBE,
	0xFF, 0xFF,
	0x92, 0x61,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x55,
	0xFF, 0xFF,
	0xE6, 0x76,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xEA,
	0xFF, 0xFF,
	0x90, 0xBD,
	0xE6, 0x72,
	0xFF, 0xFF,
	0xE6, 0x77,
	0x8C, 0xEB,
	0xE6, 0x74,
	0xE6, 0x75,
	0xFB, 0xA6,
	0xE6, 0x71,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0xE0,
	0x93, 0xC7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x4E,
	0xFF, 0xFF,
	0x89, 0xDB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xEE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x62,
	0xFF, 0xFF,
	0xFB, 0xA7,
	0x92, 0xB2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x7A,
	0xFF, 0xFF,
	0xE6, 0x78,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x6B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0xBF,
	0x8A, 0xD0,
	0xE6, 0x79,
	0xFF, 0xFF,
	0x90, 0x7A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0xC8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0x5F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x7B,
	0xE6, 0x87,
	0x92, 0xB3,
	0xFF, 0xFF,
	0xE6, 0x86,
	0xFB, 0xA8,
	0xE6, 0x83,
	0xE6, 0x8B,
	0xE6, 0x84,
	0xFF, 0xFF,
	0xE6, 0x80,
	0xFF, 0xFF,
	0x92, 0xFA,
	0xE6, 0x7E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x7C,
	0xFF, 0xFF,
	0x97, 0x40,
	0x8E, 0x90,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x81,
	0xFF, 0xFF,
	0xE6, 0x7D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0xAA,
	0xE6, 0x85,
	0x8F, 0x94,
	0xFF, 0xFF,
	0x8C, 0xBF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0xF8,
	0xFF, 0xFF
};

static unsigned char low_8B[512] = {
	0x96, 0x64,
	0x89, 0x79,
	0x88, 0xE0,
	0xFF, 0xFF,
	0x93, 0xA3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x89,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x88,
	0xFF, 0xFF,
	0x93, 0xE4,
	0xFF, 0xFF,
	0xE6, 0x8D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x82,
	0xFF, 0xFF,
	0xE6, 0x8C,
	0xE6, 0x8E,
	0xFF, 0xFF,
	0x8C, 0xAA,
	0xE6, 0x8A,
	0x8D, 0x75,
	0xFF, 0xFF,
	0x8E, 0xD3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x8F,
	0x97, 0x77,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x92,
	0xFF, 0xFF,
	0xE6, 0x95,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x93,
	0x95, 0x54,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x90,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xDE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x94,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x96,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x9A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x97,
	0xFF, 0xFF,
	0xE6, 0x99,
	0xE6, 0x98,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0xAB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x9B,
	0xFF, 0xFF,
	0x8E, 0xAF,
	0xFF, 0xFF,
	0xE6, 0x9D,
	0xE6, 0x9C,
	0x95, 0x88,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x9F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x78,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x9E,
	0xE6, 0xA0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xA1,
	0x8B, 0x63,
	0xE3, 0xBF,
	0x8F, 0xF7,
	0xFF, 0xFF,
	0xE6, 0xA2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xEC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xA3,
	0xFF, 0xFF,
	0xFB, 0xAC,
	0xE6, 0xA4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x5D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9D, 0xCC,
	0xFF, 0xFF,
	0xE6, 0xA5,
	0xFF, 0xFF,
	0xE6, 0xA6,
	0xFF, 0xFF,
	0x8F, 0x51,
	0xFF, 0xFF,
	0xE6, 0xA7,
	0xE6, 0xA8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xA9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xAA,
	0xE6, 0xAB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_8C[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x4A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xAC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xAE,
	0xFF, 0xFF,
	0xE6, 0xAD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xA4,
	0xFF, 0xFF,
	0xE6, 0xAF,
	0xFF, 0xFF,
	0x96, 0x4C,
	0xFF, 0xFF,
	0xE6, 0xB0,
	0xFF, 0xFF,
	0xE6, 0xB1,
	0xFF, 0xFF,
	0xE6, 0xB2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xB3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xD8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0xDB,
	0xE6, 0xB4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0x8B,
	0x98, 0xAC,
	0xE6, 0xB5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xB6,
	0x95, 0x5E,
	0xE6, 0xB7,
	0xFF, 0xFF,
	0xE6, 0xBF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xB8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xBA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xB9,
	0xE6, 0xBB,
	0xFF, 0xFF,
	0x96, 0x65,
	0xE6, 0xBC,
	0xE6, 0xBD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xBE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xC0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x4C,
	0x92, 0xE5,
	0xFF, 0xFF,
	0x95, 0x89,
	0x8D, 0xE0,
	0x8D, 0x76,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0x6E,
	0x89, 0xDD,
	0x94, 0xCC,
	0xE6, 0xC3,
	0x8A, 0xD1,
	0x90, 0xD3,
	0xE6, 0xC2,
	0xE6, 0xC7,
	0x92, 0x99,
	0x96, 0xE1,
	0xFF, 0xFF,
	0xE6, 0xC5,
	0xE6, 0xC6,
	0x8B, 0x4D,
	0xFF, 0xFF,
	0xE6, 0xC8,
	0x94, 0x83,
	0x91, 0xDD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xEF,
	0x93, 0x5C,
	0xE6, 0xC4,
	0xFF, 0xFF,
	0x96, 0x66,
	0x89, 0xEA,
	0xE6, 0xCA,
	0x98, 0x47,
	0x92, 0xC0,
	0x98, 0x64,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x91,
	0xE6, 0xC9,
	0xFF, 0xFF,
	0x91, 0xAF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xDA,
	0x91, 0x47,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xF6,
	0xFF, 0xFF,
	0x95, 0x6F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xCD,
	0x8E, 0x5E,
	0x8E, 0x92,
	0xFF, 0xFF,
	0x8F, 0xDC,
	0xFF, 0xFF,
	0x94, 0x85,
	0xFF, 0xFF,
	0x8C, 0xAB,
	0xE6, 0xCC,
	0xE6, 0xCB,
	0xFF, 0xFF,
	0x95, 0x8A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0xBF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x71,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0xAD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0xAE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xCF,
	0xE6, 0xD0,
	0x8D, 0x77,
	0xE6, 0xCE,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_8D[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xD1,
	0xE6, 0xD2,
	0xFF, 0xFF,
	0xE6, 0xD4,
	0x91, 0xA1,
	0xFF, 0xFF,
	0xE6, 0xD3,
	0x8A, 0xE4,
	0xFF, 0xFF,
	0xE6, 0xD6,
	0xFF, 0xFF,
	0xE6, 0xD5,
	0xE6, 0xD7,
	0xFF, 0xFF,
	0xFB, 0xAF,
	0xE6, 0xD9,
	0xE6, 0xDB,
	0xFF, 0xFF,
	0xE6, 0xDC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0xD4,
	0xFF, 0xFF,
	0x8E, 0xCD,
	0xE6, 0xDD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x71,
	0xFF, 0xFF,
	0xE6, 0xDE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x96,
	0xE6, 0xDF,
	0xFF, 0xFF,
	0xE6, 0xE0,
	0x95, 0x8B,
	0xFF, 0xFF,
	0xFB, 0xB0,
	0x8B, 0x4E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xE1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0xB4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x7A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xE2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0xEF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x96,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0xAB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xE5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xE4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xE3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xEB,
	0xE6, 0xE9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xE6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xE8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xE7,
	0xE6, 0xEA,
	0xFF, 0xFF,
	0x8B, 0x97,
	0xFF, 0xFF,
	0xE6, 0xEE,
	0xFF, 0xFF,
	0x90, 0xD5,
	0xFF, 0xFF,
	0xE6, 0xEF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xD7,
	0xFF, 0xFF,
	0xE6, 0xEC,
	0xE6, 0xED,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0x48,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0xB5,
	0xFF, 0xFF,
	0x91, 0x48,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xF0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xF3
};

static unsigned char low_8E[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xF1,
	0xE6, 0xF2,
	0x97, 0x78,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xA5,
	0xE6, 0xF6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xF4,
	0xE6, 0xF5,
	0xE6, 0xF7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x48,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xFA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xFB,
	0xE6, 0xF9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xF8,
	0xFF, 0xFF,
	0x92, 0xFB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x40,
	0xE7, 0x44,
	0xE7, 0x41,
	0xE6, 0xFC,
	0xFF, 0xFF,
	0xE7, 0x42,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x43,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x4A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x45,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0xD6,
	0xE7, 0x47,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x49,
	0xE7, 0x46,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x4C,
	0xFF, 0xFF,
	0x8F, 0x52,
	0xFF, 0xFF,
	0xE7, 0x4B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x4D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x4E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x51,
	0xE7, 0x50,
	0xFF, 0xFF,
	0xE7, 0x4F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x53,
	0xE7, 0x52,
	0xFF, 0xFF,
	0x96, 0xF4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x55,
	0xFF, 0xFF,
	0xE7, 0x54,
	0xE7, 0x56,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x57,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x59,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x58,
	0x90, 0x67,
	0xE7, 0x5A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xEB,
	0xE7, 0x5B,
	0xE7, 0x5D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x5E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x5F,
	0xE7, 0x5C,
	0xFF, 0xFF,
	0xE7, 0x60,
	0xFF, 0xFF,
	0x8E, 0xD4,
	0xE7, 0x61,
	0x8B, 0x4F,
	0x8C, 0x52,
	0xFF, 0xFF,
	0xFB, 0xB2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xAC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x62,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xEE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x5D,
	0xE7, 0x63,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x66,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0xB2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x65,
	0xE7, 0x64,
	0x8C, 0x79,
	0xE7, 0x67,
	0xFF, 0xFF
};

static unsigned char low_8F[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x72,
	0xFF, 0xFF,
	0xE7, 0x69,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0xDA,
	0xE7, 0x68,
	0xFF, 0xFF,
	0xE7, 0x71,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x6B,
	0xE7, 0x6D,
	0x95, 0xE3,
	0xE7, 0x6A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x6C,
	0xFF, 0xFF,
	0xE7, 0x70,
	0xE7, 0x6E,
	0x8B, 0x50,
	0xFF, 0xFF,
	0xE7, 0x6F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x72,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0x79,
	0x97, 0xD6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x53,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x73,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x41,
	0xE7, 0x75,
	0xFF, 0xFF,
	0xE7, 0x74,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x78,
	0x97, 0x60,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x77,
	0xFF, 0xFF,
	0x8A, 0x8D,
	0xE7, 0x76,
	0xE7, 0x7B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x7A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x79,
	0x93, 0x51,
	0xE7, 0x7C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x7D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x7E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0x8C,
	0xFF, 0xFF,
	0x8C, 0x44,
	0xE7, 0x80,
	0xE7, 0x81,
	0xE7, 0x82,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x68,
	0xE7, 0x83,
	0xFF, 0xFF,
	0x8E, 0xAB,
	0xE7, 0x84,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x85,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0x9F,
	0x99, 0x9E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x86,
	0xE3, 0x90,
	0xE7, 0x87,
	0x92, 0x43,
	0x90, 0x4A,
	0x94, 0x5F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x88,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xD3,
	0x92, 0xD2,
	0x8D, 0x9E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x48,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x49,
	0xFF, 0xFF,
	0x96, 0x98,
	0x90, 0x76,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x7D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xDF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xD4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x89,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x8B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x8A,
	0x89, 0xDE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xF4,
	0xE7, 0x8C,
	0x94, 0x97,
	0xFF, 0xFF,
	0x93, 0x52,
	0xFF, 0xFF,
	0xE7, 0x8D,
	0x8F, 0x71,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x8F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0xC0,
	0xE7, 0x9E,
	0xE7, 0x91,
	0xE7, 0x92,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0xC7,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_90[512] = {
	0x91, 0xDE,
	0x91, 0x97,
	0xFF, 0xFF,
	0x93, 0xA6,
	0xFF, 0xFF,
	0xE7, 0x90,
	0x8B, 0x74,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x99,
	0xFF, 0xFF,
	0xE7, 0x96,
	0xE7, 0xA3,
	0x93, 0xA7,
	0x92, 0x80,
	0xE7, 0x93,
	0xFF, 0xFF,
	0x92, 0xFC,
	0x93, 0x72,
	0xE7, 0x94,
	0xE7, 0x98,
	0x90, 0x80,
	0xFF, 0xFF,
	0x94, 0x87,
	0x92, 0xCA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0xC0,
	0xE7, 0x97,
	0x91, 0xAC,
	0x91, 0xA2,
	0xE7, 0x95,
	0x88, 0xA7,
	0x98, 0x41,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x9A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0xDF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x54,
	0x90, 0x69,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x9C,
	0xE7, 0x9B,
	0xFF, 0xFF,
	0x88, 0xED,
	0xE7, 0x9D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0x4E,
	0xFF, 0xFF,
	0xE7, 0xA5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xD9,
	0x90, 0x8B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x78,
	0xFF, 0xFF,
	0x8B, 0xF6,
	0xFF, 0xFF,
	0xE7, 0xA4,
	0x97, 0x56,
	0x89, 0x5E,
	0xFF, 0xFF,
	0x95, 0xD5,
	0x89, 0xDF,
	0xE7, 0x9F,
	0xE7, 0xA0,
	0xE7, 0xA1,
	0xE7, 0xA2,
	0x93, 0xB9,
	0x92, 0x42,
	0x88, 0xE1,
	0xE7, 0xA6,
	0xFF, 0xFF,
	0xE7, 0xA7,
	0xEA, 0xA1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0xBB,
	0xFF, 0xFF,
	0xE7, 0xA8,
	0xFF, 0xFF,
	0x89, 0x93,
	0x91, 0x6B,
	0xFF, 0xFF,
	0x8C, 0xAD,
	0xFF, 0xFF,
	0x97, 0x79,
	0xFF, 0xFF,
	0xFB, 0xB5,
	0xE7, 0xA9,
	0x93, 0x4B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x98,
	0x8E, 0xD5,
	0xE7, 0xAA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0xAD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x85,
	0xE7, 0xAB,
	0x91, 0x4A,
	0x91, 0x49,
	0xFF, 0xFF,
	0x88, 0xE2,
	0xFF, 0xFF,
	0x97, 0xC9,
	0xE7, 0xAF,
	0xFF, 0xFF,
	0x94, 0xF0,
	0xE7, 0xB1,
	0xE7, 0xB0,
	0xE7, 0xAE,
	0xE2, 0x84,
	0x8A, 0xD2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0x8E,
	0xFF, 0xFF,
	0xE7, 0xB3,
	0xE7, 0xB2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0xB4,
	0xFF, 0xFF,
	0x97, 0x57,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xDF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x4D,
	0xFF, 0xFF,
	0xE7, 0xB5,
	0xFF, 0xFF,
	0x8E, 0xD7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0xB6,
	0xFF, 0xFF,
	0xE7, 0xB7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0xB8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x40,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x88, 0xE8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0x78,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0x59,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0xBC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0xB6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x53,
	0xE7, 0xB9,
	0xFF, 0xFF,
	0xE7, 0xBA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0x94,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x73,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x58,
	0xFF, 0xFF,
	0x8B, 0xBD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x73,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_91[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0xBD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0xBE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0xB8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0xBF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0xB9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x41,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0xC1,
	0xFF, 0xFF,
	0xE7, 0xC0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xD1,
	0xE7, 0xC2,
	0x8F, 0x55,
	0x8E, 0xDE,
	0x94, 0x7A,
	0x92, 0x91,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0xF0,
	0xFF, 0xFF,
	0x90, 0x8C,
	0xFF, 0xFF,
	0xE7, 0xC3,
	0xFF, 0xFF,
	0xE7, 0xC4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x7C,
	0xE7, 0xC5,
	0xFF, 0xFF,
	0xE7, 0xC6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0xC7,
	0x97, 0x8F,
	0xFF, 0xFF,
	0x8F, 0x56,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0xC9,
	0xE7, 0xC8,
	0xFF, 0xFF,
	0x8D, 0x79,
	0xFF, 0xFF,
	0x8D, 0x93,
	0x8E, 0x5F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0xCC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x86,
	0xFF, 0xFF,
	0xE7, 0xCB,
	0xFF, 0xFF,
	0xE7, 0xCA,
	0xFF, 0xFF,
	0x91, 0xE7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xED,
	0xFF, 0xFF,
	0x90, 0xC1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xAE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x58,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0xCD,
	0xFF, 0xFF,
	0x8F, 0xDD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0xD0,
	0xE7, 0xCE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0xCF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0xD2,
	0xE7, 0xD1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0xF8,
	0xFF, 0xFF,
	0xE7, 0xD3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0xD4,
	0xE7, 0xD5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xCE,
	0x8D, 0xD1,
	0x8E, 0xDF,
	0xE7, 0xD6,
	0xFF, 0xFF,
	0xE7, 0xD7,
	0x97, 0xA2,
	0x8F, 0x64,
	0x96, 0xEC,
	0x97, 0xCA,
	0xE7, 0xD8,
	0x8B, 0xE0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0xD9,
	0xFB, 0xBB,
	0x93, 0x42,
	0xFF, 0xFF,
	0xFB, 0xBA,
	0xE7, 0xDC,
	0x8A, 0x98,
	0x90, 0x6A,
	0xFB, 0xBC,
	0xE7, 0xDA,
	0xFF, 0xFF,
	0xE7, 0xDB,
	0xFF, 0xFF,
	0x92, 0xDE,
	0xFB, 0xBF,
	0xFB, 0xC0,
	0x96, 0x74,
	0x8B, 0xFA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0xBD,
	0xFB, 0xBE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0xDE,
	0xE7, 0xDF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0xDD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0xE1
};

static unsigned char low_92[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0xC1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0xC3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xDD,
	0x8A, 0x62,
	0xFF, 0xFF,
	0xFB, 0xC2,
	0xE7, 0xE5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0xE2,
	0xE7, 0xE4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0xE0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x6E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0xE3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0xE9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xD8,
	0xFF, 0xFF,
	0xFB, 0xCA,
	0xFB, 0xC4,
	0xFF, 0xFF,
	0xFB, 0xC6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0xED,
	0xFB, 0xC5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x53,
	0xE7, 0xE8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0xEB,
	0xE7, 0xE9,
	0xFF, 0xFF,
	0xE7, 0xEE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0xC7,
	0xFF, 0xFF,
	0xE7, 0xEF,
	0xFB, 0xC9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0xE7,
	0xFF, 0xFF,
	0xFB, 0xC8,
	0xE7, 0xF4,
	0x89, 0x94,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0xE6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xAB,
	0xFF, 0xFF,
	0xE7, 0xEA,
	0xFF, 0xFF,
	0x8F, 0xDE,
	0xFB, 0xCB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0x7A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0xCD,
	0xFB, 0xCE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x67,
	0xFF, 0xFF,
	0x8B, 0xE2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x65,
	0xFF, 0xFF,
	0x93, 0xBA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0x5F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x4C,
	0xFF, 0xFF,
	0xE7, 0xF2,
	0xFF, 0xFF,
	0xE7, 0xEC,
	0xE7, 0xF1,
	0xFF, 0xFF,
	0x96, 0xC1,
	0xFF, 0xFF,
	0x92, 0xB6,
	0xE7, 0xF3,
	0xE7, 0xF0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0xCC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x4B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0xF7,
	0xFF, 0xFF,
	0xE7, 0xF6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0xF5,
	0xFB, 0xD2,
	0xFF, 0xFF,
	0x96, 0x4E,
	0xFB, 0xD6,
	0xFF, 0xFF,
	0xFB, 0xD4,
	0xFF, 0xFF,
	0xFB, 0xD0,
	0xFF, 0xFF,
	0xFB, 0xD1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0xD5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x9B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0xCF,
	0xFF, 0xFF,
	0xE7, 0xF8,
	0x95, 0xDD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x73,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0x65,
	0x92, 0x92,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x98,
	0xFA, 0x65,
	0xE7, 0xFA,
	0xFB, 0xD9,
	0x8D, 0x7C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0xDC
};

static unsigned char low_93[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0xDE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x4B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0xF9,
	0x90, 0x8D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x8E,
	0xE8, 0x40,
	0xE8, 0x42,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0xDD,
	0xFB, 0xDB,
	0xFF, 0xFF,
	0x8F, 0xF9,
	0xFB, 0xD8,
	0xE8, 0x41,
	0xE8, 0x43,
	0xFF, 0xFF,
	0xFB, 0xD7,
	0x8B, 0xD1,
	0xFF, 0xFF,
	0x95, 0x64,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0xE0,
	0x98, 0x42,
	0xFF, 0xFF,
	0xE7, 0xFC,
	0x8D, 0xF6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0x5E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x45,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x44,
	0xE8, 0x46,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE7, 0xFB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0x5E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xE7,
	0xFF, 0xFF,
	0x93, 0x74,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0xD5,
	0xFF, 0xFF,
	0xE8, 0x4B,
	0xFB, 0xE0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x62,
	0xE8, 0x47,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x48,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x4C,
	0xFF, 0xFF,
	0xE8, 0x4A,
	0xFF, 0xFF,
	0xFB, 0xDF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xAE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x49,
	0xFF, 0xFF,
	0x8F, 0xDF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x99,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x4F,
	0xFF, 0xFF,
	0x8D, 0xBD,
	0x91, 0x99,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0xC8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0xE1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x5A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x4D,
	0xE8, 0x4E,
	0x92, 0xC1,
	0xFF, 0xFF,
	0xE8, 0x4C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x50,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x56,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0xE2,
	0xFF, 0xFF,
	0xE8, 0x59,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x58,
	0x93, 0x4C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x51,
	0xE8, 0x52,
	0xE8, 0x55,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x57,
	0xFB, 0xE3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xBE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x5A,
	0xE8, 0x54,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x53,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0xE4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_94[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x5E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x5F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x60,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x5D,
	0xE8, 0x5C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0xE0,
	0x93, 0xA8,
	0xE8, 0x5B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x64,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x62,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0xE5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x63,
	0xE8, 0x61,
	0xFF, 0xFF,
	0x91, 0xF6,
	0xFF, 0xFF,
	0xE8, 0x65,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x66,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x68,
	0xFB, 0xE6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0xE7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xD3,
	0xE8, 0x67,
	0x96, 0xF8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x73,
	0xE8, 0x69,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x6C,
	0xFF, 0xFF,
	0xE8, 0x6A,
	0xFF, 0xFF,
	0xE8, 0x6B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x6D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x6F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x70,
	0xFF, 0xFF,
	0xE8, 0x71,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x74,
	0xE8, 0x72,
	0xE8, 0x75,
	0xE8, 0x77,
	0xFF, 0xFF,
	0xE8, 0x76,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_95[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0xB7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0xE5,
	0xFF, 0xFF,
	0xE8, 0x78,
	0x91, 0x4D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x79,
	0xFF, 0xFF,
	0x95, 0xC2,
	0xE8, 0x7A,
	0x8A, 0x4A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x5B,
	0xFF, 0xFF,
	0x8A, 0xD5,
	0xFB, 0xE8,
	0x8A, 0xD4,
	0xE8, 0x7B,
	0xFF, 0xFF,
	0xE8, 0x7C,
	0xFF, 0xFF,
	0xE8, 0x7D,
	0xE8, 0x7E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x80,
	0xFF, 0xFF,
	0x8A, 0xD6,
	0x8A, 0x74,
	0x8D, 0x7D,
	0x94, 0xB4,
	0xFF, 0xFF,
	0xE8, 0x82,
	0xE8, 0x81,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x83,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x7B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x86,
	0xFF, 0xFF,
	0xE8, 0x85,
	0xE8, 0x84,
	0xFF, 0xFF,
	0xE8, 0x87,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x8A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x88, 0xC5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x88,
	0xFF, 0xFF,
	0xE8, 0x8C,
	0xE8, 0x8B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x8E,
	0xE8, 0x8D,
	0xE8, 0x8F,
	0xFF, 0xFF,
	0x93, 0xAC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x90,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x91,
	0xE8, 0x93,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x92,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_96[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0x8C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x94,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x95,
	0xFF, 0xFF,
	0x8D, 0xE3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x96,
	0xE8, 0x97,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x68,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x6A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x88, 0xA2,
	0x91, 0xC9,
	0xFF, 0xFF,
	0xE8, 0x98,
	0xFF, 0xFF,
	0x95, 0x8D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0x9B,
	0xE8, 0x99,
	0x8D, 0x7E,
	0xFF, 0xFF,
	0xE8, 0x9A,
	0x8C, 0xC0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xC3,
	0xE8, 0x9D,
	0xE8, 0x9F,
	0xE8, 0x9E,
	0xE8, 0xA0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x40,
	0x90, 0x77,
	0x8F, 0x9C,
	0x8A, 0xD7,
	0xE8, 0xA1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0x86,
	0xFF, 0xFF,
	0xE8, 0xA3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x41,
	0xFF, 0xFF,
	0xE8, 0xA2,
	0x92, 0xC2,
	0xFF, 0xFF,
	0x97, 0xCB,
	0x93, 0xA9,
	0xE8, 0x9C,
	0x97, 0xA4,
	0xFF, 0xFF,
	0x8C, 0xAF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x7A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xF7,
	0x97, 0xB2,
	0xFF, 0xFF,
	0x8C, 0x47,
	0xFF, 0xFF,
	0x91, 0xE0,
	0xE4, 0x40,
	0xFF, 0xFF,
	0xE8, 0xA4,
	0x8A, 0x4B,
	0x90, 0x8F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x75,
	0xE8, 0xA6,
	0xFF, 0xFF,
	0xE8, 0xA7,
	0xE8, 0xA5,
	0x8C, 0x84,
	0xFF, 0xFF,
	0x8D, 0xDB,
	0x8F, 0xE1,
	0xFB, 0xEB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x42,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0xD7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xA9,
	0xE7, 0xAC,
	0xFF, 0xFF,
	0xE8, 0xA8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0xEC,
	0xE8, 0xAC,
	0xE8, 0xAA,
	0xE8, 0xAB,
	0xFF, 0xFF,
	0xE8, 0xAD,
	0xFF, 0xFF,
	0xE8, 0xAE,
	0x97, 0xEA,
	0xE8, 0xAF,
	0xE8, 0xB0,
	0xFF, 0xFF,
	0x90, 0xC7,
	0x94, 0xB9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x9D,
	0x8A, 0xE5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0x59,
	0x89, 0xEB,
	0x8F, 0x57,
	0x8C, 0xD9,
	0xFF, 0xFF,
	0xE8, 0xB3,
	0xFF, 0xFF,
	0xE8, 0xB2,
	0x8E, 0x93,
	0xE8, 0xB4,
	0xE8, 0xB1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x47,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xB8,
	0xE5, 0xAB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x99, 0xD4,
	0xFF, 0xFF,
	0x90, 0x97,
	0xE8, 0xB6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0xA3,
	0x93, 0xEF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x4A,
	0xFF, 0xFF,
	0x90, 0xE1,
	0x8E, 0xB4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0xB5,
	0xFF, 0xFF,
	0x89, 0x5F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0xEB,
	0x97, 0x8B,
	0xFF, 0xFF,
	0xE8, 0xB9,
	0xFF, 0xFF,
	0x93, 0x64,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_97[512] = {
	0x8E, 0xF9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xBA,
	0xFF, 0xFF,
	0xE8, 0xBB,
	0x90, 0x6B,
	0xE8, 0xBC,
	0xFF, 0xFF,
	0x97, 0xEC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xB7,
	0xE8, 0xBE,
	0xE8, 0xC0,
	0xFF, 0xFF,
	0xE8, 0xBF,
	0xFF, 0xFF,
	0xE8, 0xBD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xC1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xC2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x9A,
	0xFF, 0xFF,
	0x89, 0xE0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xC3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0xB6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xC4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xC5,
	0xFF, 0xFF,
	0x98, 0x49,
	0xFB, 0xED,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x9E, 0x50,
	0xE8, 0xC6,
	0xFF, 0xFF,
	0xFB, 0xEE,
	0xFF, 0xFF,
	0xE8, 0xC7,
	0xE8, 0xC8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xCC,
	0xFB, 0xEF,
	0xE8, 0xC9,
	0xFF, 0xFF,
	0xE8, 0xCA,
	0xFF, 0xFF,
	0xE8, 0xCB,
	0xE8, 0xCD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0xF0,
	0xFF, 0xFF,
	0xFB, 0xF1,
	0xFF, 0xFF,
	0xFB, 0xF2,
	0x90, 0xC2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0xF3,
	0x96, 0xF5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0xC3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xCE,
	0xFF, 0xFF,
	0x94, 0xF1,
	0xFF, 0xFF,
	0xE8, 0xCF,
	0xEA, 0x72,
	0x96, 0xCA,
	0xFF, 0xFF,
	0xE8, 0xD0,
	0xFF, 0xFF,
	0xE8, 0xD1,
	0xFF, 0xFF,
	0xE8, 0xD2,
	0x8A, 0x76,
	0xFF, 0xFF,
	0xE8, 0xD4,
	0xFF, 0xFF,
	0x90, 0x78,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xD5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x43,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xD6,
	0xE8, 0xDA,
	0xFF, 0xFF,
	0xE8, 0xD8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xD9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x93,
	0xE8, 0xD7,
	0xE8, 0xDB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xDC,
	0xFF, 0xFF,
	0x88, 0xC6,
	0xFF, 0xFF,
	0xE8, 0xDD,
	0xE8, 0xDE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0xE2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xDF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x66,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xE2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xE1,
	0xFF, 0xFF,
	0xE8, 0xE0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0x91,
	0xFF, 0xFF,
	0x95, 0xDA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xE3,
	0xE8, 0xE4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xE5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xE6,
	0xFF, 0xFF,
	0xE8, 0xE7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xE8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xD8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xE9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xEA,
	0x94, 0x42,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xEC,
	0x89, 0xB9,
	0xFF, 0xFF,
	0xE8, 0xEF,
	0xE8, 0xEE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x43,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xBF
};

static unsigned char low_98[512] = {
	0xFF, 0xFF,
	0x95, 0xC5,
	0x92, 0xB8,
	0x8D, 0xA0,
	0xFF, 0xFF,
	0x8D, 0x80,
	0x8F, 0x87,
	0xFF, 0xFF,
	0x90, 0x7B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xF1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xF0,
	0x97, 0x61,
	0x8A, 0xE6,
	0x94, 0xD0,
	0x93, 0xDA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x9C,
	0x97, 0xCC,
	0xFF, 0xFF,
	0x8C, 0x7A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xF4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xF3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x6A,
	0x93, 0xAA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x6F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xF5,
	0xE8, 0xF2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0x70,
	0x97, 0x8A,
	0xE8, 0xF6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xF7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xF9,
	0x91, 0xE8,
	0x8A, 0x7A,
	0x8A, 0x7B,
	0xE8, 0xF8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0xE7,
	0x8C, 0xB0,
	0xFF, 0xFF,
	0xFB, 0xF4,
	0x8A, 0xE8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x5E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0xDE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0xF5,
	0xFF, 0xFF,
	0x8C, 0xDA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xFA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE8, 0xFB,
	0xE8, 0xFC,
	0xE9, 0x40,
	0xFF, 0xFF,
	0xE9, 0x42,
	0xE9, 0x41,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0x97,
	0xFF, 0xFF,
	0xE9, 0x43,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x44,
	0xFF, 0xFF,
	0xE9, 0x45,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x46,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x48,
	0xE9, 0x47,
	0xFF, 0xFF,
	0xE9, 0x49,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xF2,
	0xE3, 0xCA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x48,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x51,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x4A,
	0xFF, 0xFF,
	0xE9, 0x4B,
	0xFF, 0xFF,
	0x99, 0xAA,
	0x9F, 0x5A,
	0x94, 0xD1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x88, 0xF9,
	0xFF, 0xFF,
	0x88, 0xB9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x94,
	0x96, 0x4F,
	0x8F, 0xFC,
	0xFF, 0xFF
};

static unsigned char low_99[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x4C,
	0xFF, 0xFF,
	0x96, 0xDD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x4D,
	0x97, 0x7B,
	0xFF, 0xFF,
	0x89, 0x61,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0x60,
	0xFF, 0xFF,
	0xE9, 0x4E,
	0x89, 0xEC,
	0xE9, 0x4F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x50,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x52,
	0xE9, 0x53,
	0xFF, 0xFF,
	0xE9, 0x55,
	0xE9, 0x51,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x54,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0xF8,
	0x8A, 0xD9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x56,
	0xFF, 0xFF,
	0xE9, 0x57,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x58,
	0xE9, 0x59,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x5A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x5C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x5B,
	0xFF, 0xFF,
	0xE9, 0x5E,
	0xE9, 0x61,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x5D,
	0xE9, 0x5F,
	0xE9, 0x60,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x62,
	0xFF, 0xFF,
	0x8B, 0xC0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8E, 0xF1,
	0xE9, 0x63,
	0xE9, 0x64,
	0x8D, 0x81,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0xFA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x65,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x5D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0x6E,
	0xE9, 0x66,
	0xE9, 0x67,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x79,
	0x93, 0xE9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x68,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0x9D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0xCA,
	0x89, 0x77,
	0x8B, 0xEC,
	0xFF, 0xFF,
	0x8B, 0xED,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0x93,
	0xE9, 0x6D,
	0x8B, 0xEE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xED,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x6C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x6A,
	0xFF, 0xFF,
	0xE9, 0x6B,
	0xFF, 0xFF,
	0xE9, 0x69,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x77,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x6E,
	0xE9, 0x6F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x70,
	0xE9, 0x71,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x73,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x72,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8F, 0x78
};

static unsigned char low_9A[512] = {
	0xFF, 0xFF,
	0xE9, 0x74,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x76,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0x52,
	0xE9, 0x75,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x9B,
	0x8C, 0xB1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x78,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0xCB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x79,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0xAB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x7A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x80,
	0xFF, 0xFF,
	0xE9, 0x7D,
	0xFF, 0xFF,
	0xE9, 0x7C,
	0xE9, 0x7E,
	0xFF, 0xFF,
	0xE9, 0x7B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x82,
	0xFB, 0xFB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x81,
	0xFF, 0xFF,
	0xE9, 0x84,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8B, 0xC1,
	0xE9, 0x83,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x85,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x86,
	0xFF, 0xFF,
	0xE9, 0x88,
	0xE9, 0x87,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x89,
	0xE9, 0x8B,
	0xE9, 0x8A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0x9C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x8C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x8D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x5B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x8E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x8F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x90, 0x91,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x90,
	0xFF, 0xFF,
	0xE9, 0x91,
	0xFF, 0xFF,
	0xE9, 0x92,
	0xE9, 0x93,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0x82,
	0xFB, 0xFC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFC, 0x40,
	0xFF, 0xFF,
	0xE9, 0x94,
	0xE9, 0x95,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x96,
	0xE9, 0x97,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x98,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x94, 0xAF,
	0xE9, 0x9A,
	0xFF, 0xFF,
	0x95, 0x45,
	0xE9, 0x9B,
	0xE9, 0x99,
	0xFF, 0xFF,
	0xE9, 0x9D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x9C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x9E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0x9F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_9B[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xA0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xA1,
	0xFF, 0xFF,
	0xE9, 0xA2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xA3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xA4,
	0xE9, 0xA5,
	0xFF, 0xFF,
	0xE9, 0xA6,
	0xFF, 0xFF,
	0xE9, 0xA7,
	0xE9, 0xA8,
	0xE9, 0xA9,
	0xE9, 0xAA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xAB,
	0xE9, 0xAC,
	0xFF, 0xFF,
	0x9F, 0x54,
	0xE9, 0xAD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE2, 0xF6,
	0x8B, 0x53,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x40,
	0x8D, 0xB0,
	0xE9, 0xAF,
	0xE9, 0xAE,
	0x96, 0xA3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xB1,
	0xE9, 0xB2,
	0xE9, 0xB0,
	0xFF, 0xFF,
	0xE9, 0xB3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x82,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xB4,
	0xFF, 0xFF,
	0x8B, 0x9B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0x44,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFC, 0x42,
	0xFF, 0xFF,
	0xE9, 0xB5,
	0xFC, 0x41,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xB7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x88, 0xBC,
	0xFC, 0x43,
	0xFF, 0xFF,
	0xE9, 0xB8,
	0x95, 0xA9,
	0xE9, 0xB6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xB9,
	0xE9, 0xBA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xBB,
	0xE9, 0xBC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xBD,
	0xFF, 0xFF,
	0x96, 0x8E,
	0x8E, 0x4C,
	0xFF, 0xFF,
	0x8D, 0xF8,
	0x91, 0x4E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFC, 0x44,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xBE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xC1,
	0xFF, 0xFF,
	0xFC, 0x45,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xBF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xC2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xEF,
	0xE9, 0xC0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xC3,
	0xFF, 0xFF,
	0xE9, 0xC4,
	0xE9, 0xC5,
	0xFF, 0xFF,
	0xE9, 0xC9,
	0xFF, 0xFF,
	0x8E, 0x49,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0xE2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xCA,
	0xE9, 0xC7,
	0xE9, 0xC6,
	0xE9, 0xC8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x7E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xCE,
	0xE9, 0xCD,
	0xE9, 0xCC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x88, 0xB1,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_9C[512] = {
	0xFC, 0x46,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xD8,
	0xFF, 0xFF,
	0xE9, 0xD4,
	0xFF, 0xFF,
	0xE9, 0xD5,
	0xE9, 0xD1,
	0xE9, 0xD7,
	0xFF, 0xFF,
	0xE9, 0xD3,
	0x8A, 0x82,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0x6B,
	0xFF, 0xFF,
	0xE9, 0xD6,
	0xE9, 0xD2,
	0xE9, 0xD0,
	0xE9, 0xCF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xDA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xDD,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xDC,
	0xE9, 0xDB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0x68,
	0xE9, 0xD9,
	0x88, 0xF1,
	0xE9, 0xDE,
	0xFF, 0xFF,
	0xE9, 0xE0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8A, 0x8F,
	0xE9, 0xCB,
	0x89, 0x56,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xE2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xE1,
	0xE9, 0xDF,
	0x92, 0x4C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x90,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0xD8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xE3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xE4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xE5,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xE6,
	0xFF, 0xFF,
	0xE9, 0xE7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x92, 0xB9,
	0xFF, 0xFF,
	0xE9, 0xE8,
	0xFF, 0xFF,
	0x94, 0xB5,
	0xFF, 0xFF,
	0xE9, 0xED,
	0xE9, 0xE9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xEA,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x96, 0x50,
	0x96, 0xC2,
	0xFF, 0xFF,
	0x93, 0xCE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_9D[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xEE,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xEF,
	0x93, 0xBC,
	0xE9, 0xEC,
	0xE9, 0xEB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xA8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xF7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xF6,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x95,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xF4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xF3,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xF1,
	0xFF, 0xFF,
	0x8A, 0x9B,
	0xFF, 0xFF,
	0xE9, 0xF0,
	0x8E, 0xB0,
	0x89, 0xA7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8D, 0x83,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xFA,
	0xE9, 0xF9,
	0xFF, 0xFF,
	0xE9, 0xF8,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xF5,
	0xFF, 0xFF,
	0xE9, 0xFB,
	0xFF, 0xFF,
	0xE9, 0xFC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x44,
	0xEA, 0x43,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x45,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0x4C,
	0xEA, 0x40,
	0xEA, 0x41,
	0xFF, 0xFF,
	0x8D, 0x94,
	0x96, 0xB7,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x42,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFC, 0x48,
	0x96, 0x51,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x4A,
	0xFC, 0x47,
	0xFF, 0xFF,
	0xEA, 0x46,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x4B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x48,
	0xFF, 0xFF,
	0xEA, 0x47,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0x7B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x4C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x4D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x4E,
	0xFF, 0xFF,
	0xEA, 0x49,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE9, 0xF2,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x4F,
	0xFF, 0xFF,
	0x92, 0xDF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x53,
	0xFF, 0xFF,
	0xEA, 0x54,
	0xEA, 0x52,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x51,
	0xEA, 0x57,
	0xFF, 0xFF,
	0xEA, 0x50,
	0xFF, 0xFF,
	0xEA, 0x55,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x56,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x59,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x58,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x5B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x5C,
	0xFF, 0xFF,
	0xEA, 0x5D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x98, 0x68,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x5A,
	0x91, 0xE9,
	0x8D, 0xEB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x5E,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_9E[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFC, 0x4A,
	0xEA, 0x5F,
	0xEA, 0x60,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x61,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x62,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xB2,
	0xEA, 0x63,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x64,
	0xFF, 0xFF,
	0x8E, 0xAD,
	0xFF, 0xFF,
	0xEA, 0x65,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x66,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x67,
	0xEA, 0x68,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x6B,
	0xEA, 0x69,
	0x98, 0x5B,
	0xFF, 0xFF,
	0xEA, 0x6A,
	0xFF, 0xFF,
	0x97, 0xED,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x6C,
	0xFF, 0xFF,
	0x97, 0xD9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x6D,
	0x94, 0x9E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x6E,
	0xEA, 0x70,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x71,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x6F,
	0x8D, 0x8D,
	0x96, 0xCB,
	0x96, 0x83,
	0x9B, 0xF5,
	0xFF, 0xFF,
	0x9F, 0x80,
	0x96, 0x9B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x89, 0xA9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x73,
	0x8B, 0x6F,
	0xEA, 0x74,
	0xEA, 0x75,
	0xEA, 0x76,
	0xFC, 0x4B,
	0x8D, 0x95,
	0xFF, 0xFF,
	0xEA, 0x77,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE0, 0xD2,
	0x96, 0xD9,
	0xFF, 0xFF,
	0x91, 0xE1,
	0xEA, 0x78,
	0xEA, 0x7A,
	0xEA, 0x79,
	0xFF, 0xFF,
	0xEA, 0x7B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x7C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x7D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x7E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x80,
	0xFF, 0xFF,
	0xEA, 0x81,
	0xEA, 0x82,
	0xFF, 0xFF,
	0xEA, 0x83,
	0xFF, 0xFF,
	0xEA, 0x84,
	0xEA, 0x85,
	0xEA, 0x86,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_9F[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x87,
	0xEA, 0x88,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x93, 0x43,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x8C, 0xDB,
	0xFF, 0xFF,
	0xEA, 0x8A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x91, 0x6C,
	0xEA, 0x8B,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x8C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x95, 0x40,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x8D,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x8E,
	0xE2, 0x56,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xE6, 0xD8,
	0xE8, 0xEB,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x8F,
	0xFF, 0xFF,
	0xEA, 0x90,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x92,
	0xEA, 0x93,
	0xEA, 0x94,
	0x97, 0xEE,
	0xEA, 0x91,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x95,
	0xEA, 0x96,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x98,
	0xFF, 0xFF,
	0xEA, 0x97,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x9A,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x9B,
	0xEA, 0x99,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x97, 0xB4,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x9C,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x9D,
	0xE2, 0x73,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xEA, 0x9E,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_E0[512] = {
	0xF0, 0x40,
	0xF0, 0x41,
	0xF0, 0x42,
	0xF0, 0x43,
	0xF0, 0x44,
	0xF0, 0x45,
	0xF0, 0x46,
	0xF0, 0x47,
	0xF0, 0x48,
	0xF0, 0x49,
	0xF0, 0x4A,
	0xF0, 0x4B,
	0xF0, 0x4C,
	0xF0, 0x4D,
	0xF0, 0x4E,
	0xF0, 0x4F,
	0xF0, 0x50,
	0xF0, 0x51,
	0xF0, 0x52,
	0xF0, 0x53,
	0xF0, 0x54,
	0xF0, 0x55,
	0xF0, 0x56,
	0xF0, 0x57,
	0xF0, 0x58,
	0xF0, 0x59,
	0xF0, 0x5A,
	0xF0, 0x5B,
	0xF0, 0x5C,
	0xF0, 0x5D,
	0xF0, 0x5E,
	0xF0, 0x5F,
	0xF0, 0x60,
	0xF0, 0x61,
	0xF0, 0x62,
	0xF0, 0x63,
	0xF0, 0x64,
	0xF0, 0x65,
	0xF0, 0x66,
	0xF0, 0x67,
	0xF0, 0x68,
	0xF0, 0x69,
	0xF0, 0x6A,
	0xF0, 0x6B,
	0xF0, 0x6C,
	0xF0, 0x6D,
	0xF0, 0x6E,
	0xF0, 0x6F,
	0xF0, 0x70,
	0xF0, 0x71,
	0xF0, 0x72,
	0xF0, 0x73,
	0xF0, 0x74,
	0xF0, 0x75,
	0xF0, 0x76,
	0xF0, 0x77,
	0xF0, 0x78,
	0xF0, 0x79,
	0xF0, 0x7A,
	0xF0, 0x7B,
	0xF0, 0x7C,
	0xF0, 0x7D,
	0xF0, 0x7E,
	0xF0, 0x80,
	0xF0, 0x81,
	0xF0, 0x82,
	0xF0, 0x83,
	0xF0, 0x84,
	0xF0, 0x85,
	0xF0, 0x86,
	0xF0, 0x87,
	0xF0, 0x88,
	0xF0, 0x89,
	0xF0, 0x8A,
	0xF0, 0x8B,
	0xF0, 0x8C,
	0xF0, 0x8D,
	0xF0, 0x8E,
	0xF0, 0x8F,
	0xF0, 0x90,
	0xF0, 0x91,
	0xF0, 0x92,
	0xF0, 0x93,
	0xF0, 0x94,
	0xF0, 0x95,
	0xF0, 0x96,
	0xF0, 0x97,
	0xF0, 0x98,
	0xF0, 0x99,
	0xF0, 0x9A,
	0xF0, 0x9B,
	0xF0, 0x9C,
	0xF0, 0x9D,
	0xF0, 0x9E,
	0xF0, 0x9F,
	0xF0, 0xA0,
	0xF0, 0xA1,
	0xF0, 0xA2,
	0xF0, 0xA3,
	0xF0, 0xA4,
	0xF0, 0xA5,
	0xF0, 0xA6,
	0xF0, 0xA7,
	0xF0, 0xA8,
	0xF0, 0xA9,
	0xF0, 0xAA,
	0xF0, 0xAB,
	0xF0, 0xAC,
	0xF0, 0xAD,
	0xF0, 0xAE,
	0xF0, 0xAF,
	0xF0, 0xB0,
	0xF0, 0xB1,
	0xF0, 0xB2,
	0xF0, 0xB3,
	0xF0, 0xB4,
	0xF0, 0xB5,
	0xF0, 0xB6,
	0xF0, 0xB7,
	0xF0, 0xB8,
	0xF0, 0xB9,
	0xF0, 0xBA,
	0xF0, 0xBB,
	0xF0, 0xBC,
	0xF0, 0xBD,
	0xF0, 0xBE,
	0xF0, 0xBF,
	0xF0, 0xC0,
	0xF0, 0xC1,
	0xF0, 0xC2,
	0xF0, 0xC3,
	0xF0, 0xC4,
	0xF0, 0xC5,
	0xF0, 0xC6,
	0xF0, 0xC7,
	0xF0, 0xC8,
	0xF0, 0xC9,
	0xF0, 0xCA,
	0xF0, 0xCB,
	0xF0, 0xCC,
	0xF0, 0xCD,
	0xF0, 0xCE,
	0xF0, 0xCF,
	0xF0, 0xD0,
	0xF0, 0xD1,
	0xF0, 0xD2,
	0xF0, 0xD3,
	0xF0, 0xD4,
	0xF0, 0xD5,
	0xF0, 0xD6,
	0xF0, 0xD7,
	0xF0, 0xD8,
	0xF0, 0xD9,
	0xF0, 0xDA,
	0xF0, 0xDB,
	0xF0, 0xDC,
	0xF0, 0xDD,
	0xF0, 0xDE,
	0xF0, 0xDF,
	0xF0, 0xE0,
	0xF0, 0xE1,
	0xF0, 0xE2,
	0xF0, 0xE3,
	0xF0, 0xE4,
	0xF0, 0xE5,
	0xF0, 0xE6,
	0xF0, 0xE7,
	0xF0, 0xE8,
	0xF0, 0xE9,
	0xF0, 0xEA,
	0xF0, 0xEB,
	0xF0, 0xEC,
	0xF0, 0xED,
	0xF0, 0xEE,
	0xF0, 0xEF,
	0xF0, 0xF0,
	0xF0, 0xF1,
	0xF0, 0xF2,
	0xF0, 0xF3,
	0xF0, 0xF4,
	0xF0, 0xF5,
	0xF0, 0xF6,
	0xF0, 0xF7,
	0xF0, 0xF8,
	0xF0, 0xF9,
	0xF0, 0xFA,
	0xF0, 0xFB,
	0xF0, 0xFC,
	0xF1, 0x40,
	0xF1, 0x41,
	0xF1, 0x42,
	0xF1, 0x43,
	0xF1, 0x44,
	0xF1, 0x45,
	0xF1, 0x46,
	0xF1, 0x47,
	0xF1, 0x48,
	0xF1, 0x49,
	0xF1, 0x4A,
	0xF1, 0x4B,
	0xF1, 0x4C,
	0xF1, 0x4D,
	0xF1, 0x4E,
	0xF1, 0x4F,
	0xF1, 0x50,
	0xF1, 0x51,
	0xF1, 0x52,
	0xF1, 0x53,
	0xF1, 0x54,
	0xF1, 0x55,
	0xF1, 0x56,
	0xF1, 0x57,
	0xF1, 0x58,
	0xF1, 0x59,
	0xF1, 0x5A,
	0xF1, 0x5B,
	0xF1, 0x5C,
	0xF1, 0x5D,
	0xF1, 0x5E,
	0xF1, 0x5F,
	0xF1, 0x60,
	0xF1, 0x61,
	0xF1, 0x62,
	0xF1, 0x63,
	0xF1, 0x64,
	0xF1, 0x65,
	0xF1, 0x66,
	0xF1, 0x67,
	0xF1, 0x68,
	0xF1, 0x69,
	0xF1, 0x6A,
	0xF1, 0x6B,
	0xF1, 0x6C,
	0xF1, 0x6D,
	0xF1, 0x6E,
	0xF1, 0x6F,
	0xF1, 0x70,
	0xF1, 0x71,
	0xF1, 0x72,
	0xF1, 0x73,
	0xF1, 0x74,
	0xF1, 0x75,
	0xF1, 0x76,
	0xF1, 0x77,
	0xF1, 0x78,
	0xF1, 0x79,
	0xF1, 0x7A,
	0xF1, 0x7B,
	0xF1, 0x7C,
	0xF1, 0x7D,
	0xF1, 0x7E,
	0xF1, 0x80,
	0xF1, 0x81,
	0xF1, 0x82,
	0xF1, 0x83,
	0xF1, 0x84
};

static unsigned char low_E1[512] = {
	0xF1, 0x85,
	0xF1, 0x86,
	0xF1, 0x87,
	0xF1, 0x88,
	0xF1, 0x89,
	0xF1, 0x8A,
	0xF1, 0x8B,
	0xF1, 0x8C,
	0xF1, 0x8D,
	0xF1, 0x8E,
	0xF1, 0x8F,
	0xF1, 0x90,
	0xF1, 0x91,
	0xF1, 0x92,
	0xF1, 0x93,
	0xF1, 0x94,
	0xF1, 0x95,
	0xF1, 0x96,
	0xF1, 0x97,
	0xF1, 0x98,
	0xF1, 0x99,
	0xF1, 0x9A,
	0xF1, 0x9B,
	0xF1, 0x9C,
	0xF1, 0x9D,
	0xF1, 0x9E,
	0xF1, 0x9F,
	0xF1, 0xA0,
	0xF1, 0xA1,
	0xF1, 0xA2,
	0xF1, 0xA3,
	0xF1, 0xA4,
	0xF1, 0xA5,
	0xF1, 0xA6,
	0xF1, 0xA7,
	0xF1, 0xA8,
	0xF1, 0xA9,
	0xF1, 0xAA,
	0xF1, 0xAB,
	0xF1, 0xAC,
	0xF1, 0xAD,
	0xF1, 0xAE,
	0xF1, 0xAF,
	0xF1, 0xB0,
	0xF1, 0xB1,
	0xF1, 0xB2,
	0xF1, 0xB3,
	0xF1, 0xB4,
	0xF1, 0xB5,
	0xF1, 0xB6,
	0xF1, 0xB7,
	0xF1, 0xB8,
	0xF1, 0xB9,
	0xF1, 0xBA,
	0xF1, 0xBB,
	0xF1, 0xBC,
	0xF1, 0xBD,
	0xF1, 0xBE,
	0xF1, 0xBF,
	0xF1, 0xC0,
	0xF1, 0xC1,
	0xF1, 0xC2,
	0xF1, 0xC3,
	0xF1, 0xC4,
	0xF1, 0xC5,
	0xF1, 0xC6,
	0xF1, 0xC7,
	0xF1, 0xC8,
	0xF1, 0xC9,
	0xF1, 0xCA,
	0xF1, 0xCB,
	0xF1, 0xCC,
	0xF1, 0xCD,
	0xF1, 0xCE,
	0xF1, 0xCF,
	0xF1, 0xD0,
	0xF1, 0xD1,
	0xF1, 0xD2,
	0xF1, 0xD3,
	0xF1, 0xD4,
	0xF1, 0xD5,
	0xF1, 0xD6,
	0xF1, 0xD7,
	0xF1, 0xD8,
	0xF1, 0xD9,
	0xF1, 0xDA,
	0xF1, 0xDB,
	0xF1, 0xDC,
	0xF1, 0xDD,
	0xF1, 0xDE,
	0xF1, 0xDF,
	0xF1, 0xE0,
	0xF1, 0xE1,
	0xF1, 0xE2,
	0xF1, 0xE3,
	0xF1, 0xE4,
	0xF1, 0xE5,
	0xF1, 0xE6,
	0xF1, 0xE7,
	0xF1, 0xE8,
	0xF1, 0xE9,
	0xF1, 0xEA,
	0xF1, 0xEB,
	0xF1, 0xEC,
	0xF1, 0xED,
	0xF1, 0xEE,
	0xF1, 0xEF,
	0xF1, 0xF0,
	0xF1, 0xF1,
	0xF1, 0xF2,
	0xF1, 0xF3,
	0xF1, 0xF4,
	0xF1, 0xF5,
	0xF1, 0xF6,
	0xF1, 0xF7,
	0xF1, 0xF8,
	0xF1, 0xF9,
	0xF1, 0xFA,
	0xF1, 0xFB,
	0xF1, 0xFC,
	0xF2, 0x40,
	0xF2, 0x41,
	0xF2, 0x42,
	0xF2, 0x43,
	0xF2, 0x44,
	0xF2, 0x45,
	0xF2, 0x46,
	0xF2, 0x47,
	0xF2, 0x48,
	0xF2, 0x49,
	0xF2, 0x4A,
	0xF2, 0x4B,
	0xF2, 0x4C,
	0xF2, 0x4D,
	0xF2, 0x4E,
	0xF2, 0x4F,
	0xF2, 0x50,
	0xF2, 0x51,
	0xF2, 0x52,
	0xF2, 0x53,
	0xF2, 0x54,
	0xF2, 0x55,
	0xF2, 0x56,
	0xF2, 0x57,
	0xF2, 0x58,
	0xF2, 0x59,
	0xF2, 0x5A,
	0xF2, 0x5B,
	0xF2, 0x5C,
	0xF2, 0x5D,
	0xF2, 0x5E,
	0xF2, 0x5F,
	0xF2, 0x60,
	0xF2, 0x61,
	0xF2, 0x62,
	0xF2, 0x63,
	0xF2, 0x64,
	0xF2, 0x65,
	0xF2, 0x66,
	0xF2, 0x67,
	0xF2, 0x68,
	0xF2, 0x69,
	0xF2, 0x6A,
	0xF2, 0x6B,
	0xF2, 0x6C,
	0xF2, 0x6D,
	0xF2, 0x6E,
	0xF2, 0x6F,
	0xF2, 0x70,
	0xF2, 0x71,
	0xF2, 0x72,
	0xF2, 0x73,
	0xF2, 0x74,
	0xF2, 0x75,
	0xF2, 0x76,
	0xF2, 0x77,
	0xF2, 0x78,
	0xF2, 0x79,
	0xF2, 0x7A,
	0xF2, 0x7B,
	0xF2, 0x7C,
	0xF2, 0x7D,
	0xF2, 0x7E,
	0xF2, 0x80,
	0xF2, 0x81,
	0xF2, 0x82,
	0xF2, 0x83,
	0xF2, 0x84,
	0xF2, 0x85,
	0xF2, 0x86,
	0xF2, 0x87,
	0xF2, 0x88,
	0xF2, 0x89,
	0xF2, 0x8A,
	0xF2, 0x8B,
	0xF2, 0x8C,
	0xF2, 0x8D,
	0xF2, 0x8E,
	0xF2, 0x8F,
	0xF2, 0x90,
	0xF2, 0x91,
	0xF2, 0x92,
	0xF2, 0x93,
	0xF2, 0x94,
	0xF2, 0x95,
	0xF2, 0x96,
	0xF2, 0x97,
	0xF2, 0x98,
	0xF2, 0x99,
	0xF2, 0x9A,
	0xF2, 0x9B,
	0xF2, 0x9C,
	0xF2, 0x9D,
	0xF2, 0x9E,
	0xF2, 0x9F,
	0xF2, 0xA0,
	0xF2, 0xA1,
	0xF2, 0xA2,
	0xF2, 0xA3,
	0xF2, 0xA4,
	0xF2, 0xA5,
	0xF2, 0xA6,
	0xF2, 0xA7,
	0xF2, 0xA8,
	0xF2, 0xA9,
	0xF2, 0xAA,
	0xF2, 0xAB,
	0xF2, 0xAC,
	0xF2, 0xAD,
	0xF2, 0xAE,
	0xF2, 0xAF,
	0xF2, 0xB0,
	0xF2, 0xB1,
	0xF2, 0xB2,
	0xF2, 0xB3,
	0xF2, 0xB4,
	0xF2, 0xB5,
	0xF2, 0xB6,
	0xF2, 0xB7,
	0xF2, 0xB8,
	0xF2, 0xB9,
	0xF2, 0xBA,
	0xF2, 0xBB,
	0xF2, 0xBC,
	0xF2, 0xBD,
	0xF2, 0xBE,
	0xF2, 0xBF,
	0xF2, 0xC0,
	0xF2, 0xC1,
	0xF2, 0xC2,
	0xF2, 0xC3,
	0xF2, 0xC4,
	0xF2, 0xC5,
	0xF2, 0xC6,
	0xF2, 0xC7,
	0xF2, 0xC8
};

static unsigned char low_E2[512] = {
	0xF2, 0xC9,
	0xF2, 0xCA,
	0xF2, 0xCB,
	0xF2, 0xCC,
	0xF2, 0xCD,
	0xF2, 0xCE,
	0xF2, 0xCF,
	0xF2, 0xD0,
	0xF2, 0xD1,
	0xF2, 0xD2,
	0xF2, 0xD3,
	0xF2, 0xD4,
	0xF2, 0xD5,
	0xF2, 0xD6,
	0xF2, 0xD7,
	0xF2, 0xD8,
	0xF2, 0xD9,
	0xF2, 0xDA,
	0xF2, 0xDB,
	0xF2, 0xDC,
	0xF2, 0xDD,
	0xF2, 0xDE,
	0xF2, 0xDF,
	0xF2, 0xE0,
	0xF2, 0xE1,
	0xF2, 0xE2,
	0xF2, 0xE3,
	0xF2, 0xE4,
	0xF2, 0xE5,
	0xF2, 0xE6,
	0xF2, 0xE7,
	0xF2, 0xE8,
	0xF2, 0xE9,
	0xF2, 0xEA,
	0xF2, 0xEB,
	0xF2, 0xEC,
	0xF2, 0xED,
	0xF2, 0xEE,
	0xF2, 0xEF,
	0xF2, 0xF0,
	0xF2, 0xF1,
	0xF2, 0xF2,
	0xF2, 0xF3,
	0xF2, 0xF4,
	0xF2, 0xF5,
	0xF2, 0xF6,
	0xF2, 0xF7,
	0xF2, 0xF8,
	0xF2, 0xF9,
	0xF2, 0xFA,
	0xF2, 0xFB,
	0xF2, 0xFC,
	0xF3, 0x40,
	0xF3, 0x41,
	0xF3, 0x42,
	0xF3, 0x43,
	0xF3, 0x44,
	0xF3, 0x45,
	0xF3, 0x46,
	0xF3, 0x47,
	0xF3, 0x48,
	0xF3, 0x49,
	0xF3, 0x4A,
	0xF3, 0x4B,
	0xF3, 0x4C,
	0xF3, 0x4D,
	0xF3, 0x4E,
	0xF3, 0x4F,
	0xF3, 0x50,
	0xF3, 0x51,
	0xF3, 0x52,
	0xF3, 0x53,
	0xF3, 0x54,
	0xF3, 0x55,
	0xF3, 0x56,
	0xF3, 0x57,
	0xF3, 0x58,
	0xF3, 0x59,
	0xF3, 0x5A,
	0xF3, 0x5B,
	0xF3, 0x5C,
	0xF3, 0x5D,
	0xF3, 0x5E,
	0xF3, 0x5F,
	0xF3, 0x60,
	0xF3, 0x61,
	0xF3, 0x62,
	0xF3, 0x63,
	0xF3, 0x64,
	0xF3, 0x65,
	0xF3, 0x66,
	0xF3, 0x67,
	0xF3, 0x68,
	0xF3, 0x69,
	0xF3, 0x6A,
	0xF3, 0x6B,
	0xF3, 0x6C,
	0xF3, 0x6D,
	0xF3, 0x6E,
	0xF3, 0x6F,
	0xF3, 0x70,
	0xF3, 0x71,
	0xF3, 0x72,
	0xF3, 0x73,
	0xF3, 0x74,
	0xF3, 0x75,
	0xF3, 0x76,
	0xF3, 0x77,
	0xF3, 0x78,
	0xF3, 0x79,
	0xF3, 0x7A,
	0xF3, 0x7B,
	0xF3, 0x7C,
	0xF3, 0x7D,
	0xF3, 0x7E,
	0xF3, 0x80,
	0xF3, 0x81,
	0xF3, 0x82,
	0xF3, 0x83,
	0xF3, 0x84,
	0xF3, 0x85,
	0xF3, 0x86,
	0xF3, 0x87,
	0xF3, 0x88,
	0xF3, 0x89,
	0xF3, 0x8A,
	0xF3, 0x8B,
	0xF3, 0x8C,
	0xF3, 0x8D,
	0xF3, 0x8E,
	0xF3, 0x8F,
	0xF3, 0x90,
	0xF3, 0x91,
	0xF3, 0x92,
	0xF3, 0x93,
	0xF3, 0x94,
	0xF3, 0x95,
	0xF3, 0x96,
	0xF3, 0x97,
	0xF3, 0x98,
	0xF3, 0x99,
	0xF3, 0x9A,
	0xF3, 0x9B,
	0xF3, 0x9C,
	0xF3, 0x9D,
	0xF3, 0x9E,
	0xF3, 0x9F,
	0xF3, 0xA0,
	0xF3, 0xA1,
	0xF3, 0xA2,
	0xF3, 0xA3,
	0xF3, 0xA4,
	0xF3, 0xA5,
	0xF3, 0xA6,
	0xF3, 0xA7,
	0xF3, 0xA8,
	0xF3, 0xA9,
	0xF3, 0xAA,
	0xF3, 0xAB,
	0xF3, 0xAC,
	0xF3, 0xAD,
	0xF3, 0xAE,
	0xF3, 0xAF,
	0xF3, 0xB0,
	0xF3, 0xB1,
	0xF3, 0xB2,
	0xF3, 0xB3,
	0xF3, 0xB4,
	0xF3, 0xB5,
	0xF3, 0xB6,
	0xF3, 0xB7,
	0xF3, 0xB8,
	0xF3, 0xB9,
	0xF3, 0xBA,
	0xF3, 0xBB,
	0xF3, 0xBC,
	0xF3, 0xBD,
	0xF3, 0xBE,
	0xF3, 0xBF,
	0xF3, 0xC0,
	0xF3, 0xC1,
	0xF3, 0xC2,
	0xF3, 0xC3,
	0xF3, 0xC4,
	0xF3, 0xC5,
	0xF3, 0xC6,
	0xF3, 0xC7,
	0xF3, 0xC8,
	0xF3, 0xC9,
	0xF3, 0xCA,
	0xF3, 0xCB,
	0xF3, 0xCC,
	0xF3, 0xCD,
	0xF3, 0xCE,
	0xF3, 0xCF,
	0xF3, 0xD0,
	0xF3, 0xD1,
	0xF3, 0xD2,
	0xF3, 0xD3,
	0xF3, 0xD4,
	0xF3, 0xD5,
	0xF3, 0xD6,
	0xF3, 0xD7,
	0xF3, 0xD8,
	0xF3, 0xD9,
	0xF3, 0xDA,
	0xF3, 0xDB,
	0xF3, 0xDC,
	0xF3, 0xDD,
	0xF3, 0xDE,
	0xF3, 0xDF,
	0xF3, 0xE0,
	0xF3, 0xE1,
	0xF3, 0xE2,
	0xF3, 0xE3,
	0xF3, 0xE4,
	0xF3, 0xE5,
	0xF3, 0xE6,
	0xF3, 0xE7,
	0xF3, 0xE8,
	0xF3, 0xE9,
	0xF3, 0xEA,
	0xF3, 0xEB,
	0xF3, 0xEC,
	0xF3, 0xED,
	0xF3, 0xEE,
	0xF3, 0xEF,
	0xF3, 0xF0,
	0xF3, 0xF1,
	0xF3, 0xF2,
	0xF3, 0xF3,
	0xF3, 0xF4,
	0xF3, 0xF5,
	0xF3, 0xF6,
	0xF3, 0xF7,
	0xF3, 0xF8,
	0xF3, 0xF9,
	0xF3, 0xFA,
	0xF3, 0xFB,
	0xF3, 0xFC,
	0xF4, 0x40,
	0xF4, 0x41,
	0xF4, 0x42,
	0xF4, 0x43,
	0xF4, 0x44,
	0xF4, 0x45,
	0xF4, 0x46,
	0xF4, 0x47,
	0xF4, 0x48,
	0xF4, 0x49,
	0xF4, 0x4A,
	0xF4, 0x4B,
	0xF4, 0x4C,
	0xF4, 0x4D,
	0xF4, 0x4E,
	0xF4, 0x4F
};

static unsigned char low_E3[512] = {
	0xF4, 0x50,
	0xF4, 0x51,
	0xF4, 0x52,
	0xF4, 0x53,
	0xF4, 0x54,
	0xF4, 0x55,
	0xF4, 0x56,
	0xF4, 0x57,
	0xF4, 0x58,
	0xF4, 0x59,
	0xF4, 0x5A,
	0xF4, 0x5B,
	0xF4, 0x5C,
	0xF4, 0x5D,
	0xF4, 0x5E,
	0xF4, 0x5F,
	0xF4, 0x60,
	0xF4, 0x61,
	0xF4, 0x62,
	0xF4, 0x63,
	0xF4, 0x64,
	0xF4, 0x65,
	0xF4, 0x66,
	0xF4, 0x67,
	0xF4, 0x68,
	0xF4, 0x69,
	0xF4, 0x6A,
	0xF4, 0x6B,
	0xF4, 0x6C,
	0xF4, 0x6D,
	0xF4, 0x6E,
	0xF4, 0x6F,
	0xF4, 0x70,
	0xF4, 0x71,
	0xF4, 0x72,
	0xF4, 0x73,
	0xF4, 0x74,
	0xF4, 0x75,
	0xF4, 0x76,
	0xF4, 0x77,
	0xF4, 0x78,
	0xF4, 0x79,
	0xF4, 0x7A,
	0xF4, 0x7B,
	0xF4, 0x7C,
	0xF4, 0x7D,
	0xF4, 0x7E,
	0xF4, 0x80,
	0xF4, 0x81,
	0xF4, 0x82,
	0xF4, 0x83,
	0xF4, 0x84,
	0xF4, 0x85,
	0xF4, 0x86,
	0xF4, 0x87,
	0xF4, 0x88,
	0xF4, 0x89,
	0xF4, 0x8A,
	0xF4, 0x8B,
	0xF4, 0x8C,
	0xF4, 0x8D,
	0xF4, 0x8E,
	0xF4, 0x8F,
	0xF4, 0x90,
	0xF4, 0x91,
	0xF4, 0x92,
	0xF4, 0x93,
	0xF4, 0x94,
	0xF4, 0x95,
	0xF4, 0x96,
	0xF4, 0x97,
	0xF4, 0x98,
	0xF4, 0x99,
	0xF4, 0x9A,
	0xF4, 0x9B,
	0xF4, 0x9C,
	0xF4, 0x9D,
	0xF4, 0x9E,
	0xF4, 0x9F,
	0xF4, 0xA0,
	0xF4, 0xA1,
	0xF4, 0xA2,
	0xF4, 0xA3,
	0xF4, 0xA4,
	0xF4, 0xA5,
	0xF4, 0xA6,
	0xF4, 0xA7,
	0xF4, 0xA8,
	0xF4, 0xA9,
	0xF4, 0xAA,
	0xF4, 0xAB,
	0xF4, 0xAC,
	0xF4, 0xAD,
	0xF4, 0xAE,
	0xF4, 0xAF,
	0xF4, 0xB0,
	0xF4, 0xB1,
	0xF4, 0xB2,
	0xF4, 0xB3,
	0xF4, 0xB4,
	0xF4, 0xB5,
	0xF4, 0xB6,
	0xF4, 0xB7,
	0xF4, 0xB8,
	0xF4, 0xB9,
	0xF4, 0xBA,
	0xF4, 0xBB,
	0xF4, 0xBC,
	0xF4, 0xBD,
	0xF4, 0xBE,
	0xF4, 0xBF,
	0xF4, 0xC0,
	0xF4, 0xC1,
	0xF4, 0xC2,
	0xF4, 0xC3,
	0xF4, 0xC4,
	0xF4, 0xC5,
	0xF4, 0xC6,
	0xF4, 0xC7,
	0xF4, 0xC8,
	0xF4, 0xC9,
	0xF4, 0xCA,
	0xF4, 0xCB,
	0xF4, 0xCC,
	0xF4, 0xCD,
	0xF4, 0xCE,
	0xF4, 0xCF,
	0xF4, 0xD0,
	0xF4, 0xD1,
	0xF4, 0xD2,
	0xF4, 0xD3,
	0xF4, 0xD4,
	0xF4, 0xD5,
	0xF4, 0xD6,
	0xF4, 0xD7,
	0xF4, 0xD8,
	0xF4, 0xD9,
	0xF4, 0xDA,
	0xF4, 0xDB,
	0xF4, 0xDC,
	0xF4, 0xDD,
	0xF4, 0xDE,
	0xF4, 0xDF,
	0xF4, 0xE0,
	0xF4, 0xE1,
	0xF4, 0xE2,
	0xF4, 0xE3,
	0xF4, 0xE4,
	0xF4, 0xE5,
	0xF4, 0xE6,
	0xF4, 0xE7,
	0xF4, 0xE8,
	0xF4, 0xE9,
	0xF4, 0xEA,
	0xF4, 0xEB,
	0xF4, 0xEC,
	0xF4, 0xED,
	0xF4, 0xEE,
	0xF4, 0xEF,
	0xF4, 0xF0,
	0xF4, 0xF1,
	0xF4, 0xF2,
	0xF4, 0xF3,
	0xF4, 0xF4,
	0xF4, 0xF5,
	0xF4, 0xF6,
	0xF4, 0xF7,
	0xF4, 0xF8,
	0xF4, 0xF9,
	0xF4, 0xFA,
	0xF4, 0xFB,
	0xF4, 0xFC,
	0xF5, 0x40,
	0xF5, 0x41,
	0xF5, 0x42,
	0xF5, 0x43,
	0xF5, 0x44,
	0xF5, 0x45,
	0xF5, 0x46,
	0xF5, 0x47,
	0xF5, 0x48,
	0xF5, 0x49,
	0xF5, 0x4A,
	0xF5, 0x4B,
	0xF5, 0x4C,
	0xF5, 0x4D,
	0xF5, 0x4E,
	0xF5, 0x4F,
	0xF5, 0x50,
	0xF5, 0x51,
	0xF5, 0x52,
	0xF5, 0x53,
	0xF5, 0x54,
	0xF5, 0x55,
	0xF5, 0x56,
	0xF5, 0x57,
	0xF5, 0x58,
	0xF5, 0x59,
	0xF5, 0x5A,
	0xF5, 0x5B,
	0xF5, 0x5C,
	0xF5, 0x5D,
	0xF5, 0x5E,
	0xF5, 0x5F,
	0xF5, 0x60,
	0xF5, 0x61,
	0xF5, 0x62,
	0xF5, 0x63,
	0xF5, 0x64,
	0xF5, 0x65,
	0xF5, 0x66,
	0xF5, 0x67,
	0xF5, 0x68,
	0xF5, 0x69,
	0xF5, 0x6A,
	0xF5, 0x6B,
	0xF5, 0x6C,
	0xF5, 0x6D,
	0xF5, 0x6E,
	0xF5, 0x6F,
	0xF5, 0x70,
	0xF5, 0x71,
	0xF5, 0x72,
	0xF5, 0x73,
	0xF5, 0x74,
	0xF5, 0x75,
	0xF5, 0x76,
	0xF5, 0x77,
	0xF5, 0x78,
	0xF5, 0x79,
	0xF5, 0x7A,
	0xF5, 0x7B,
	0xF5, 0x7C,
	0xF5, 0x7D,
	0xF5, 0x7E,
	0xF5, 0x80,
	0xF5, 0x81,
	0xF5, 0x82,
	0xF5, 0x83,
	0xF5, 0x84,
	0xF5, 0x85,
	0xF5, 0x86,
	0xF5, 0x87,
	0xF5, 0x88,
	0xF5, 0x89,
	0xF5, 0x8A,
	0xF5, 0x8B,
	0xF5, 0x8C,
	0xF5, 0x8D,
	0xF5, 0x8E,
	0xF5, 0x8F,
	0xF5, 0x90,
	0xF5, 0x91,
	0xF5, 0x92,
	0xF5, 0x93,
	0xF5, 0x94
};

static unsigned char low_E4[512] = {
	0xF5, 0x95,
	0xF5, 0x96,
	0xF5, 0x97,
	0xF5, 0x98,
	0xF5, 0x99,
	0xF5, 0x9A,
	0xF5, 0x9B,
	0xF5, 0x9C,
	0xF5, 0x9D,
	0xF5, 0x9E,
	0xF5, 0x9F,
	0xF5, 0xA0,
	0xF5, 0xA1,
	0xF5, 0xA2,
	0xF5, 0xA3,
	0xF5, 0xA4,
	0xF5, 0xA5,
	0xF5, 0xA6,
	0xF5, 0xA7,
	0xF5, 0xA8,
	0xF5, 0xA9,
	0xF5, 0xAA,
	0xF5, 0xAB,
	0xF5, 0xAC,
	0xF5, 0xAD,
	0xF5, 0xAE,
	0xF5, 0xAF,
	0xF5, 0xB0,
	0xF5, 0xB1,
	0xF5, 0xB2,
	0xF5, 0xB3,
	0xF5, 0xB4,
	0xF5, 0xB5,
	0xF5, 0xB6,
	0xF5, 0xB7,
	0xF5, 0xB8,
	0xF5, 0xB9,
	0xF5, 0xBA,
	0xF5, 0xBB,
	0xF5, 0xBC,
	0xF5, 0xBD,
	0xF5, 0xBE,
	0xF5, 0xBF,
	0xF5, 0xC0,
	0xF5, 0xC1,
	0xF5, 0xC2,
	0xF5, 0xC3,
	0xF5, 0xC4,
	0xF5, 0xC5,
	0xF5, 0xC6,
	0xF5, 0xC7,
	0xF5, 0xC8,
	0xF5, 0xC9,
	0xF5, 0xCA,
	0xF5, 0xCB,
	0xF5, 0xCC,
	0xF5, 0xCD,
	0xF5, 0xCE,
	0xF5, 0xCF,
	0xF5, 0xD0,
	0xF5, 0xD1,
	0xF5, 0xD2,
	0xF5, 0xD3,
	0xF5, 0xD4,
	0xF5, 0xD5,
	0xF5, 0xD6,
	0xF5, 0xD7,
	0xF5, 0xD8,
	0xF5, 0xD9,
	0xF5, 0xDA,
	0xF5, 0xDB,
	0xF5, 0xDC,
	0xF5, 0xDD,
	0xF5, 0xDE,
	0xF5, 0xDF,
	0xF5, 0xE0,
	0xF5, 0xE1,
	0xF5, 0xE2,
	0xF5, 0xE3,
	0xF5, 0xE4,
	0xF5, 0xE5,
	0xF5, 0xE6,
	0xF5, 0xE7,
	0xF5, 0xE8,
	0xF5, 0xE9,
	0xF5, 0xEA,
	0xF5, 0xEB,
	0xF5, 0xEC,
	0xF5, 0xED,
	0xF5, 0xEE,
	0xF5, 0xEF,
	0xF5, 0xF0,
	0xF5, 0xF1,
	0xF5, 0xF2,
	0xF5, 0xF3,
	0xF5, 0xF4,
	0xF5, 0xF5,
	0xF5, 0xF6,
	0xF5, 0xF7,
	0xF5, 0xF8,
	0xF5, 0xF9,
	0xF5, 0xFA,
	0xF5, 0xFB,
	0xF5, 0xFC,
	0xF6, 0x40,
	0xF6, 0x41,
	0xF6, 0x42,
	0xF6, 0x43,
	0xF6, 0x44,
	0xF6, 0x45,
	0xF6, 0x46,
	0xF6, 0x47,
	0xF6, 0x48,
	0xF6, 0x49,
	0xF6, 0x4A,
	0xF6, 0x4B,
	0xF6, 0x4C,
	0xF6, 0x4D,
	0xF6, 0x4E,
	0xF6, 0x4F,
	0xF6, 0x50,
	0xF6, 0x51,
	0xF6, 0x52,
	0xF6, 0x53,
	0xF6, 0x54,
	0xF6, 0x55,
	0xF6, 0x56,
	0xF6, 0x57,
	0xF6, 0x58,
	0xF6, 0x59,
	0xF6, 0x5A,
	0xF6, 0x5B,
	0xF6, 0x5C,
	0xF6, 0x5D,
	0xF6, 0x5E,
	0xF6, 0x5F,
	0xF6, 0x60,
	0xF6, 0x61,
	0xF6, 0x62,
	0xF6, 0x63,
	0xF6, 0x64,
	0xF6, 0x65,
	0xF6, 0x66,
	0xF6, 0x67,
	0xF6, 0x68,
	0xF6, 0x69,
	0xF6, 0x6A,
	0xF6, 0x6B,
	0xF6, 0x6C,
	0xF6, 0x6D,
	0xF6, 0x6E,
	0xF6, 0x6F,
	0xF6, 0x70,
	0xF6, 0x71,
	0xF6, 0x72,
	0xF6, 0x73,
	0xF6, 0x74,
	0xF6, 0x75,
	0xF6, 0x76,
	0xF6, 0x77,
	0xF6, 0x78,
	0xF6, 0x79,
	0xF6, 0x7A,
	0xF6, 0x7B,
	0xF6, 0x7C,
	0xF6, 0x7D,
	0xF6, 0x7E,
	0xF6, 0x80,
	0xF6, 0x81,
	0xF6, 0x82,
	0xF6, 0x83,
	0xF6, 0x84,
	0xF6, 0x85,
	0xF6, 0x86,
	0xF6, 0x87,
	0xF6, 0x88,
	0xF6, 0x89,
	0xF6, 0x8A,
	0xF6, 0x8B,
	0xF6, 0x8C,
	0xF6, 0x8D,
	0xF6, 0x8E,
	0xF6, 0x8F,
	0xF6, 0x90,
	0xF6, 0x91,
	0xF6, 0x92,
	0xF6, 0x93,
	0xF6, 0x94,
	0xF6, 0x95,
	0xF6, 0x96,
	0xF6, 0x97,
	0xF6, 0x98,
	0xF6, 0x99,
	0xF6, 0x9A,
	0xF6, 0x9B,
	0xF6, 0x9C,
	0xF6, 0x9D,
	0xF6, 0x9E,
	0xF6, 0x9F,
	0xF6, 0xA0,
	0xF6, 0xA1,
	0xF6, 0xA2,
	0xF6, 0xA3,
	0xF6, 0xA4,
	0xF6, 0xA5,
	0xF6, 0xA6,
	0xF6, 0xA7,
	0xF6, 0xA8,
	0xF6, 0xA9,
	0xF6, 0xAA,
	0xF6, 0xAB,
	0xF6, 0xAC,
	0xF6, 0xAD,
	0xF6, 0xAE,
	0xF6, 0xAF,
	0xF6, 0xB0,
	0xF6, 0xB1,
	0xF6, 0xB2,
	0xF6, 0xB3,
	0xF6, 0xB4,
	0xF6, 0xB5,
	0xF6, 0xB6,
	0xF6, 0xB7,
	0xF6, 0xB8,
	0xF6, 0xB9,
	0xF6, 0xBA,
	0xF6, 0xBB,
	0xF6, 0xBC,
	0xF6, 0xBD,
	0xF6, 0xBE,
	0xF6, 0xBF,
	0xF6, 0xC0,
	0xF6, 0xC1,
	0xF6, 0xC2,
	0xF6, 0xC3,
	0xF6, 0xC4,
	0xF6, 0xC5,
	0xF6, 0xC6,
	0xF6, 0xC7,
	0xF6, 0xC8,
	0xF6, 0xC9,
	0xF6, 0xCA,
	0xF6, 0xCB,
	0xF6, 0xCC,
	0xF6, 0xCD,
	0xF6, 0xCE,
	0xF6, 0xCF,
	0xF6, 0xD0,
	0xF6, 0xD1,
	0xF6, 0xD2,
	0xF6, 0xD3,
	0xF6, 0xD4,
	0xF6, 0xD5,
	0xF6, 0xD6,
	0xF6, 0xD7,
	0xF6, 0xD8
};

static unsigned char low_E5[512] = {
	0xF6, 0xD9,
	0xF6, 0xDA,
	0xF6, 0xDB,
	0xF6, 0xDC,
	0xF6, 0xDD,
	0xF6, 0xDE,
	0xF6, 0xDF,
	0xF6, 0xE0,
	0xF6, 0xE1,
	0xF6, 0xE2,
	0xF6, 0xE3,
	0xF6, 0xE4,
	0xF6, 0xE5,
	0xF6, 0xE6,
	0xF6, 0xE7,
	0xF6, 0xE8,
	0xF6, 0xE9,
	0xF6, 0xEA,
	0xF6, 0xEB,
	0xF6, 0xEC,
	0xF6, 0xED,
	0xF6, 0xEE,
	0xF6, 0xEF,
	0xF6, 0xF0,
	0xF6, 0xF1,
	0xF6, 0xF2,
	0xF6, 0xF3,
	0xF6, 0xF4,
	0xF6, 0xF5,
	0xF6, 0xF6,
	0xF6, 0xF7,
	0xF6, 0xF8,
	0xF6, 0xF9,
	0xF6, 0xFA,
	0xF6, 0xFB,
	0xF6, 0xFC,
	0xF7, 0x40,
	0xF7, 0x41,
	0xF7, 0x42,
	0xF7, 0x43,
	0xF7, 0x44,
	0xF7, 0x45,
	0xF7, 0x46,
	0xF7, 0x47,
	0xF7, 0x48,
	0xF7, 0x49,
	0xF7, 0x4A,
	0xF7, 0x4B,
	0xF7, 0x4C,
	0xF7, 0x4D,
	0xF7, 0x4E,
	0xF7, 0x4F,
	0xF7, 0x50,
	0xF7, 0x51,
	0xF7, 0x52,
	0xF7, 0x53,
	0xF7, 0x54,
	0xF7, 0x55,
	0xF7, 0x56,
	0xF7, 0x57,
	0xF7, 0x58,
	0xF7, 0x59,
	0xF7, 0x5A,
	0xF7, 0x5B,
	0xF7, 0x5C,
	0xF7, 0x5D,
	0xF7, 0x5E,
	0xF7, 0x5F,
	0xF7, 0x60,
	0xF7, 0x61,
	0xF7, 0x62,
	0xF7, 0x63,
	0xF7, 0x64,
	0xF7, 0x65,
	0xF7, 0x66,
	0xF7, 0x67,
	0xF7, 0x68,
	0xF7, 0x69,
	0xF7, 0x6A,
	0xF7, 0x6B,
	0xF7, 0x6C,
	0xF7, 0x6D,
	0xF7, 0x6E,
	0xF7, 0x6F,
	0xF7, 0x70,
	0xF7, 0x71,
	0xF7, 0x72,
	0xF7, 0x73,
	0xF7, 0x74,
	0xF7, 0x75,
	0xF7, 0x76,
	0xF7, 0x77,
	0xF7, 0x78,
	0xF7, 0x79,
	0xF7, 0x7A,
	0xF7, 0x7B,
	0xF7, 0x7C,
	0xF7, 0x7D,
	0xF7, 0x7E,
	0xF7, 0x80,
	0xF7, 0x81,
	0xF7, 0x82,
	0xF7, 0x83,
	0xF7, 0x84,
	0xF7, 0x85,
	0xF7, 0x86,
	0xF7, 0x87,
	0xF7, 0x88,
	0xF7, 0x89,
	0xF7, 0x8A,
	0xF7, 0x8B,
	0xF7, 0x8C,
	0xF7, 0x8D,
	0xF7, 0x8E,
	0xF7, 0x8F,
	0xF7, 0x90,
	0xF7, 0x91,
	0xF7, 0x92,
	0xF7, 0x93,
	0xF7, 0x94,
	0xF7, 0x95,
	0xF7, 0x96,
	0xF7, 0x97,
	0xF7, 0x98,
	0xF7, 0x99,
	0xF7, 0x9A,
	0xF7, 0x9B,
	0xF7, 0x9C,
	0xF7, 0x9D,
	0xF7, 0x9E,
	0xF7, 0x9F,
	0xF7, 0xA0,
	0xF7, 0xA1,
	0xF7, 0xA2,
	0xF7, 0xA3,
	0xF7, 0xA4,
	0xF7, 0xA5,
	0xF7, 0xA6,
	0xF7, 0xA7,
	0xF7, 0xA8,
	0xF7, 0xA9,
	0xF7, 0xAA,
	0xF7, 0xAB,
	0xF7, 0xAC,
	0xF7, 0xAD,
	0xF7, 0xAE,
	0xF7, 0xAF,
	0xF7, 0xB0,
	0xF7, 0xB1,
	0xF7, 0xB2,
	0xF7, 0xB3,
	0xF7, 0xB4,
	0xF7, 0xB5,
	0xF7, 0xB6,
	0xF7, 0xB7,
	0xF7, 0xB8,
	0xF7, 0xB9,
	0xF7, 0xBA,
	0xF7, 0xBB,
	0xF7, 0xBC,
	0xF7, 0xBD,
	0xF7, 0xBE,
	0xF7, 0xBF,
	0xF7, 0xC0,
	0xF7, 0xC1,
	0xF7, 0xC2,
	0xF7, 0xC3,
	0xF7, 0xC4,
	0xF7, 0xC5,
	0xF7, 0xC6,
	0xF7, 0xC7,
	0xF7, 0xC8,
	0xF7, 0xC9,
	0xF7, 0xCA,
	0xF7, 0xCB,
	0xF7, 0xCC,
	0xF7, 0xCD,
	0xF7, 0xCE,
	0xF7, 0xCF,
	0xF7, 0xD0,
	0xF7, 0xD1,
	0xF7, 0xD2,
	0xF7, 0xD3,
	0xF7, 0xD4,
	0xF7, 0xD5,
	0xF7, 0xD6,
	0xF7, 0xD7,
	0xF7, 0xD8,
	0xF7, 0xD9,
	0xF7, 0xDA,
	0xF7, 0xDB,
	0xF7, 0xDC,
	0xF7, 0xDD,
	0xF7, 0xDE,
	0xF7, 0xDF,
	0xF7, 0xE0,
	0xF7, 0xE1,
	0xF7, 0xE2,
	0xF7, 0xE3,
	0xF7, 0xE4,
	0xF7, 0xE5,
	0xF7, 0xE6,
	0xF7, 0xE7,
	0xF7, 0xE8,
	0xF7, 0xE9,
	0xF7, 0xEA,
	0xF7, 0xEB,
	0xF7, 0xEC,
	0xF7, 0xED,
	0xF7, 0xEE,
	0xF7, 0xEF,
	0xF7, 0xF0,
	0xF7, 0xF1,
	0xF7, 0xF2,
	0xF7, 0xF3,
	0xF7, 0xF4,
	0xF7, 0xF5,
	0xF7, 0xF6,
	0xF7, 0xF7,
	0xF7, 0xF8,
	0xF7, 0xF9,
	0xF7, 0xFA,
	0xF7, 0xFB,
	0xF7, 0xFC,
	0xF8, 0x40,
	0xF8, 0x41,
	0xF8, 0x42,
	0xF8, 0x43,
	0xF8, 0x44,
	0xF8, 0x45,
	0xF8, 0x46,
	0xF8, 0x47,
	0xF8, 0x48,
	0xF8, 0x49,
	0xF8, 0x4A,
	0xF8, 0x4B,
	0xF8, 0x4C,
	0xF8, 0x4D,
	0xF8, 0x4E,
	0xF8, 0x4F,
	0xF8, 0x50,
	0xF8, 0x51,
	0xF8, 0x52,
	0xF8, 0x53,
	0xF8, 0x54,
	0xF8, 0x55,
	0xF8, 0x56,
	0xF8, 0x57,
	0xF8, 0x58,
	0xF8, 0x59,
	0xF8, 0x5A,
	0xF8, 0x5B,
	0xF8, 0x5C,
	0xF8, 0x5D,
	0xF8, 0x5E,
	0xF8, 0x5F
};

static unsigned char low_E6[512] = {
	0xF8, 0x60,
	0xF8, 0x61,
	0xF8, 0x62,
	0xF8, 0x63,
	0xF8, 0x64,
	0xF8, 0x65,
	0xF8, 0x66,
	0xF8, 0x67,
	0xF8, 0x68,
	0xF8, 0x69,
	0xF8, 0x6A,
	0xF8, 0x6B,
	0xF8, 0x6C,
	0xF8, 0x6D,
	0xF8, 0x6E,
	0xF8, 0x6F,
	0xF8, 0x70,
	0xF8, 0x71,
	0xF8, 0x72,
	0xF8, 0x73,
	0xF8, 0x74,
	0xF8, 0x75,
	0xF8, 0x76,
	0xF8, 0x77,
	0xF8, 0x78,
	0xF8, 0x79,
	0xF8, 0x7A,
	0xF8, 0x7B,
	0xF8, 0x7C,
	0xF8, 0x7D,
	0xF8, 0x7E,
	0xF8, 0x80,
	0xF8, 0x81,
	0xF8, 0x82,
	0xF8, 0x83,
	0xF8, 0x84,
	0xF8, 0x85,
	0xF8, 0x86,
	0xF8, 0x87,
	0xF8, 0x88,
	0xF8, 0x89,
	0xF8, 0x8A,
	0xF8, 0x8B,
	0xF8, 0x8C,
	0xF8, 0x8D,
	0xF8, 0x8E,
	0xF8, 0x8F,
	0xF8, 0x90,
	0xF8, 0x91,
	0xF8, 0x92,
	0xF8, 0x93,
	0xF8, 0x94,
	0xF8, 0x95,
	0xF8, 0x96,
	0xF8, 0x97,
	0xF8, 0x98,
	0xF8, 0x99,
	0xF8, 0x9A,
	0xF8, 0x9B,
	0xF8, 0x9C,
	0xF8, 0x9D,
	0xF8, 0x9E,
	0xF8, 0x9F,
	0xF8, 0xA0,
	0xF8, 0xA1,
	0xF8, 0xA2,
	0xF8, 0xA3,
	0xF8, 0xA4,
	0xF8, 0xA5,
	0xF8, 0xA6,
	0xF8, 0xA7,
	0xF8, 0xA8,
	0xF8, 0xA9,
	0xF8, 0xAA,
	0xF8, 0xAB,
	0xF8, 0xAC,
	0xF8, 0xAD,
	0xF8, 0xAE,
	0xF8, 0xAF,
	0xF8, 0xB0,
	0xF8, 0xB1,
	0xF8, 0xB2,
	0xF8, 0xB3,
	0xF8, 0xB4,
	0xF8, 0xB5,
	0xF8, 0xB6,
	0xF8, 0xB7,
	0xF8, 0xB8,
	0xF8, 0xB9,
	0xF8, 0xBA,
	0xF8, 0xBB,
	0xF8, 0xBC,
	0xF8, 0xBD,
	0xF8, 0xBE,
	0xF8, 0xBF,
	0xF8, 0xC0,
	0xF8, 0xC1,
	0xF8, 0xC2,
	0xF8, 0xC3,
	0xF8, 0xC4,
	0xF8, 0xC5,
	0xF8, 0xC6,
	0xF8, 0xC7,
	0xF8, 0xC8,
	0xF8, 0xC9,
	0xF8, 0xCA,
	0xF8, 0xCB,
	0xF8, 0xCC,
	0xF8, 0xCD,
	0xF8, 0xCE,
	0xF8, 0xCF,
	0xF8, 0xD0,
	0xF8, 0xD1,
	0xF8, 0xD2,
	0xF8, 0xD3,
	0xF8, 0xD4,
	0xF8, 0xD5,
	0xF8, 0xD6,
	0xF8, 0xD7,
	0xF8, 0xD8,
	0xF8, 0xD9,
	0xF8, 0xDA,
	0xF8, 0xDB,
	0xF8, 0xDC,
	0xF8, 0xDD,
	0xF8, 0xDE,
	0xF8, 0xDF,
	0xF8, 0xE0,
	0xF8, 0xE1,
	0xF8, 0xE2,
	0xF8, 0xE3,
	0xF8, 0xE4,
	0xF8, 0xE5,
	0xF8, 0xE6,
	0xF8, 0xE7,
	0xF8, 0xE8,
	0xF8, 0xE9,
	0xF8, 0xEA,
	0xF8, 0xEB,
	0xF8, 0xEC,
	0xF8, 0xED,
	0xF8, 0xEE,
	0xF8, 0xEF,
	0xF8, 0xF0,
	0xF8, 0xF1,
	0xF8, 0xF2,
	0xF8, 0xF3,
	0xF8, 0xF4,
	0xF8, 0xF5,
	0xF8, 0xF6,
	0xF8, 0xF7,
	0xF8, 0xF8,
	0xF8, 0xF9,
	0xF8, 0xFA,
	0xF8, 0xFB,
	0xF8, 0xFC,
	0xF9, 0x40,
	0xF9, 0x41,
	0xF9, 0x42,
	0xF9, 0x43,
	0xF9, 0x44,
	0xF9, 0x45,
	0xF9, 0x46,
	0xF9, 0x47,
	0xF9, 0x48,
	0xF9, 0x49,
	0xF9, 0x4A,
	0xF9, 0x4B,
	0xF9, 0x4C,
	0xF9, 0x4D,
	0xF9, 0x4E,
	0xF9, 0x4F,
	0xF9, 0x50,
	0xF9, 0x51,
	0xF9, 0x52,
	0xF9, 0x53,
	0xF9, 0x54,
	0xF9, 0x55,
	0xF9, 0x56,
	0xF9, 0x57,
	0xF9, 0x58,
	0xF9, 0x59,
	0xF9, 0x5A,
	0xF9, 0x5B,
	0xF9, 0x5C,
	0xF9, 0x5D,
	0xF9, 0x5E,
	0xF9, 0x5F,
	0xF9, 0x60,
	0xF9, 0x61,
	0xF9, 0x62,
	0xF9, 0x63,
	0xF9, 0x64,
	0xF9, 0x65,
	0xF9, 0x66,
	0xF9, 0x67,
	0xF9, 0x68,
	0xF9, 0x69,
	0xF9, 0x6A,
	0xF9, 0x6B,
	0xF9, 0x6C,
	0xF9, 0x6D,
	0xF9, 0x6E,
	0xF9, 0x6F,
	0xF9, 0x70,
	0xF9, 0x71,
	0xF9, 0x72,
	0xF9, 0x73,
	0xF9, 0x74,
	0xF9, 0x75,
	0xF9, 0x76,
	0xF9, 0x77,
	0xF9, 0x78,
	0xF9, 0x79,
	0xF9, 0x7A,
	0xF9, 0x7B,
	0xF9, 0x7C,
	0xF9, 0x7D,
	0xF9, 0x7E,
	0xF9, 0x80,
	0xF9, 0x81,
	0xF9, 0x82,
	0xF9, 0x83,
	0xF9, 0x84,
	0xF9, 0x85,
	0xF9, 0x86,
	0xF9, 0x87,
	0xF9, 0x88,
	0xF9, 0x89,
	0xF9, 0x8A,
	0xF9, 0x8B,
	0xF9, 0x8C,
	0xF9, 0x8D,
	0xF9, 0x8E,
	0xF9, 0x8F,
	0xF9, 0x90,
	0xF9, 0x91,
	0xF9, 0x92,
	0xF9, 0x93,
	0xF9, 0x94,
	0xF9, 0x95,
	0xF9, 0x96,
	0xF9, 0x97,
	0xF9, 0x98,
	0xF9, 0x99,
	0xF9, 0x9A,
	0xF9, 0x9B,
	0xF9, 0x9C,
	0xF9, 0x9D,
	0xF9, 0x9E,
	0xF9, 0x9F,
	0xF9, 0xA0,
	0xF9, 0xA1,
	0xF9, 0xA2,
	0xF9, 0xA3,
	0xF9, 0xA4
};

static unsigned char low_E7[512] = {
	0xF9, 0xA5,
	0xF9, 0xA6,
	0xF9, 0xA7,
	0xF9, 0xA8,
	0xF9, 0xA9,
	0xF9, 0xAA,
	0xF9, 0xAB,
	0xF9, 0xAC,
	0xF9, 0xAD,
	0xF9, 0xAE,
	0xF9, 0xAF,
	0xF9, 0xB0,
	0xF9, 0xB1,
	0xF9, 0xB2,
	0xF9, 0xB3,
	0xF9, 0xB4,
	0xF9, 0xB5,
	0xF9, 0xB6,
	0xF9, 0xB7,
	0xF9, 0xB8,
	0xF9, 0xB9,
	0xF9, 0xBA,
	0xF9, 0xBB,
	0xF9, 0xBC,
	0xF9, 0xBD,
	0xF9, 0xBE,
	0xF9, 0xBF,
	0xF9, 0xC0,
	0xF9, 0xC1,
	0xF9, 0xC2,
	0xF9, 0xC3,
	0xF9, 0xC4,
	0xF9, 0xC5,
	0xF9, 0xC6,
	0xF9, 0xC7,
	0xF9, 0xC8,
	0xF9, 0xC9,
	0xF9, 0xCA,
	0xF9, 0xCB,
	0xF9, 0xCC,
	0xF9, 0xCD,
	0xF9, 0xCE,
	0xF9, 0xCF,
	0xF9, 0xD0,
	0xF9, 0xD1,
	0xF9, 0xD2,
	0xF9, 0xD3,
	0xF9, 0xD4,
	0xF9, 0xD5,
	0xF9, 0xD6,
	0xF9, 0xD7,
	0xF9, 0xD8,
	0xF9, 0xD9,
	0xF9, 0xDA,
	0xF9, 0xDB,
	0xF9, 0xDC,
	0xF9, 0xDD,
	0xF9, 0xDE,
	0xF9, 0xDF,
	0xF9, 0xE0,
	0xF9, 0xE1,
	0xF9, 0xE2,
	0xF9, 0xE3,
	0xF9, 0xE4,
	0xF9, 0xE5,
	0xF9, 0xE6,
	0xF9, 0xE7,
	0xF9, 0xE8,
	0xF9, 0xE9,
	0xF9, 0xEA,
	0xF9, 0xEB,
	0xF9, 0xEC,
	0xF9, 0xED,
	0xF9, 0xEE,
	0xF9, 0xEF,
	0xF9, 0xF0,
	0xF9, 0xF1,
	0xF9, 0xF2,
	0xF9, 0xF3,
	0xF9, 0xF4,
	0xF9, 0xF5,
	0xF9, 0xF6,
	0xF9, 0xF7,
	0xF9, 0xF8,
	0xF9, 0xF9,
	0xF9, 0xFA,
	0xF9, 0xFB,
	0xF9, 0xFC,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_F9[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0xE0,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFB, 0xE9,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_FA[512] = {
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFA, 0x90,
	0xFA, 0x9B,
	0xFA, 0x9C,
	0xFA, 0xB1,
	0xFA, 0xD8,
	0xFA, 0xE8,
	0xFA, 0xEA,
	0xFB, 0x58,
	0xFB, 0x5E,
	0xFB, 0x75,
	0xFB, 0x7D,
	0xFB, 0x7E,
	0xFB, 0x80,
	0xFB, 0x82,
	0xFB, 0x86,
	0xFB, 0x89,
	0xFB, 0x92,
	0xFB, 0x9D,
	0xFB, 0x9F,
	0xFB, 0xA0,
	0xFB, 0xA9,
	0xFB, 0xB1,
	0xFB, 0xB3,
	0xFB, 0xB4,
	0xFB, 0xB7,
	0xFB, 0xD3,
	0xFB, 0xDA,
	0xFB, 0xEA,
	0xFB, 0xF6,
	0xFB, 0xF7,
	0xFB, 0xF9,
	0xFC, 0x49,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char low_FF[512] = {
	0xFF, 0xFF,
	0x81, 0x49,
	0xFA, 0x57,
	0x81, 0x94,
	0x81, 0x90,
	0x81, 0x93,
	0x81, 0x95,
	0xFA, 0x56,
	0x81, 0x69,
	0x81, 0x6A,
	0x81, 0x96,
	0x81, 0x7B,
	0x81, 0x43,
	0x81, 0x7C,
	0x81, 0x44,
	0x81, 0x5E,
	0x82, 0x4F,
	0x82, 0x50,
	0x82, 0x51,
	0x82, 0x52,
	0x82, 0x53,
	0x82, 0x54,
	0x82, 0x55,
	0x82, 0x56,
	0x82, 0x57,
	0x82, 0x58,
	0x81, 0x46,
	0x81, 0x47,
	0x81, 0x83,
	0x81, 0x81,
	0x81, 0x84,
	0x81, 0x48,
	0x81, 0x97,
	0x82, 0x60,
	0x82, 0x61,
	0x82, 0x62,
	0x82, 0x63,
	0x82, 0x64,
	0x82, 0x65,
	0x82, 0x66,
	0x82, 0x67,
	0x82, 0x68,
	0x82, 0x69,
	0x82, 0x6A,
	0x82, 0x6B,
	0x82, 0x6C,
	0x82, 0x6D,
	0x82, 0x6E,
	0x82, 0x6F,
	0x82, 0x70,
	0x82, 0x71,
	0x82, 0x72,
	0x82, 0x73,
	0x82, 0x74,
	0x82, 0x75,
	0x82, 0x76,
	0x82, 0x77,
	0x82, 0x78,
	0x82, 0x79,
	0x81, 0x6D,
	0x81, 0x5F,
	0x81, 0x6E,
	0x81, 0x4F,
	0x81, 0x51,
	0x81, 0x4D,
	0x82, 0x81,
	0x82, 0x82,
	0x82, 0x83,
	0x82, 0x84,
	0x82, 0x85,
	0x82, 0x86,
	0x82, 0x87,
	0x82, 0x88,
	0x82, 0x89,
	0x82, 0x8A,
	0x82, 0x8B,
	0x82, 0x8C,
	0x82, 0x8D,
	0x82, 0x8E,
	0x82, 0x8F,
	0x82, 0x90,
	0x82, 0x91,
	0x82, 0x92,
	0x82, 0x93,
	0x82, 0x94,
	0x82, 0x95,
	0x82, 0x96,
	0x82, 0x97,
	0x82, 0x98,
	0x82, 0x99,
	0x82, 0x9A,
	0x81, 0x6F,
	0x81, 0x62,
	0x81, 0x70,
	0x81, 0x60,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xA1,
	0xFF, 0xA2,
	0xFF, 0xA3,
	0xFF, 0xA4,
	0xFF, 0xA5,
	0xFF, 0xA6,
	0xFF, 0xA7,
	0xFF, 0xA8,
	0xFF, 0xA9,
	0xFF, 0xAA,
	0xFF, 0xAB,
	0xFF, 0xAC,
	0xFF, 0xAD,
	0xFF, 0xAE,
	0xFF, 0xAF,
	0xFF, 0xB0,
	0xFF, 0xB1,
	0xFF, 0xB2,
	0xFF, 0xB3,
	0xFF, 0xB4,
	0xFF, 0xB5,
	0xFF, 0xB6,
	0xFF, 0xB7,
	0xFF, 0xB8,
	0xFF, 0xB9,
	0xFF, 0xBA,
	0xFF, 0xBB,
	0xFF, 0xBC,
	0xFF, 0xBD,
	0xFF, 0xBE,
	0xFF, 0xBF,
	0xFF, 0xC0,
	0xFF, 0xC1,
	0xFF, 0xC2,
	0xFF, 0xC3,
	0xFF, 0xC4,
	0xFF, 0xC5,
	0xFF, 0xC6,
	0xFF, 0xC7,
	0xFF, 0xC8,
	0xFF, 0xC9,
	0xFF, 0xCA,
	0xFF, 0xCB,
	0xFF, 0xCC,
	0xFF, 0xCD,
	0xFF, 0xCE,
	0xFF, 0xCF,
	0xFF, 0xD0,
	0xFF, 0xD1,
	0xFF, 0xD2,
	0xFF, 0xD3,
	0xFF, 0xD4,
	0xFF, 0xD5,
	0xFF, 0xD6,
	0xFF, 0xD7,
	0xFF, 0xD8,
	0xFF, 0xD9,
	0xFF, 0xDA,
	0xFF, 0xDB,
	0xFF, 0xDC,
	0xFF, 0xDD,
	0xFF, 0xDE,
	0xFF, 0xDF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0x81, 0x91,
	0x81, 0x92,
	0x81, 0xCA,
	0x81, 0x50,
	0xFA, 0x55,
	0x81, 0x8F,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF,
	0xFF, 0xFF
};

static unsigned char *table_ucs2_cp932[256] = {
	low_00,
	NULL,
	NULL,
	low_03,
	low_04,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	low_20,
	low_21,
	low_22,
	low_23,
	low_24,
	low_25,
	low_26,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	low_30,
	NULL,
	low_32,
	low_33,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	low_4E,
	low_4F,
	low_50,
	low_51,
	low_52,
	low_53,
	low_54,
	low_55,
	low_56,
	low_57,
	low_58,
	low_59,
	low_5A,
	low_5B,
	low_5C,
	low_5D,
	low_5E,
	low_5F,
	low_60,
	low_61,
	low_62,
	low_63,
	low_64,
	low_65,
	low_66,
	low_67,
	low_68,
	low_69,
	low_6A,
	low_6B,
	low_6C,
	low_6D,
	low_6E,
	low_6F,
	low_70,
	low_71,
	low_72,
	low_73,
	low_74,
	low_75,
	low_76,
	low_77,
	low_78,
	low_79,
	low_7A,
	low_7B,
	low_7C,
	low_7D,
	low_7E,
	low_7F,
	low_80,
	low_81,
	low_82,
	low_83,
	low_84,
	low_85,
	low_86,
	low_87,
	low_88,
	low_89,
	low_8A,
	low_8B,
	low_8C,
	low_8D,
	low_8E,
	low_8F,
	low_90,
	low_91,
	low_92,
	low_93,
	low_94,
	low_95,
	low_96,
	low_97,
	low_98,
	low_99,
	low_9A,
	low_9B,
	low_9C,
	low_9D,
	low_9E,
	low_9F,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	low_E0,
	low_E1,
	low_E2,
	low_E3,
	low_E4,
	low_E5,
	low_E6,
	low_E7,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	low_F9,
	low_FA,
	NULL,
	NULL,
	NULL,
	NULL,
	low_FF
};
