/**************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
**************************************************************************/

#include "about_dialog.h"

AboutDialog::AboutDialog()
{
    QLabel *header = new QLabel(this);

    // Arial, Verdana, Courrier, Time
#ifdef WIN32
    QFont police("Arial", 8, true);
#elif defined __APPLE__
    QFont police = QFont();
#else
    QFont police("Arial", 10, true);
#endif

    header->setPixmap(QPixmap(":/images/about-logo.png"));
    QLabel *label = new QLabel(tr("<strong>KontrolPack ") + QString(VERSION) + tr(" : access securely any remote computer.</strong> <br/>"), this);
    QLabel *labelLicence = new QLabel(tr("This program is free software: you can redistribute it and/or modify it under\n"
                                         "the terms of the GNU General Public License as published by the Free \n"
                                         "Software Foundation; either version 2 of the License, or (at your option)\n"
                                         "any later version."), this);
    label->setFont(police);
    labelLicence->setFont(police);

    setWindowTitle(tr("About KontrolPack ") + QString(VERSION));
    setWindowIcon(QIcon(":/images/kontrolpack.png"));

    QLabel *creatorLabel = new QLabel(tr("<strong>Created by : Thomas THELLIEZ</strong> (Lead developer and administrator)<br/><br/>KontrolPack web site : <a href=\"https://www.kontrolpack.com/\">https://www.kontrolpack.com/</a><br/><br/>This software uses Microsoft and Apple Trademarks in text : <br/><br/>Microsoft&reg; software and Windows&reg; operating system are trademarks<br/> of Microsoft Corporation.<br/><br/>Mac and Mac OS are trademarks of Apple Inc., registered in the U.S. and<br/> other countries."), this);
    creatorLabel->setOpenExternalLinks(true);
    creatorLabel->setFont(police);
    QPushButton *button = new QPushButton(tr("Close"));
    QGridLayout *layout = new QGridLayout;
    layout->addWidget(label, 0, 0);
    layout->addWidget(header, 1, 0);
    layout->addWidget(labelLicence, 3, 0);
    layout->addWidget(creatorLabel, 4, 0);
    layout->addWidget(button, 5, 0);
    setLayout(layout);
#ifdef WIN32
    setFixedSize(460, 450);
#elif defined __APPLE__
    setFixedSize(500, 500);
#else
    setFixedSize(460, 450);
#endif

    connect(button, SIGNAL(clicked()), this, SLOT(hideDialogBox()));
}

void AboutDialog::hideDialogBox()
{
    this->hide();
}

void AboutDialog::closeEvent(QCloseEvent *event)
{
    hide();
    event->ignore();
}
