
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2019 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQGraphicsItem.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QGraphicsItem>
#include <QGraphicsTransform>
#include <QGraphicsScene>
#include <QStyleOptionGraphicsItem>
#include <QGraphicsEffect>
#include <QGraphicsWidget>
#include <QGraphicsSceneContextMenuEvent>
#include <QGraphicsSceneDragDropEvent>
#include <QGraphicsSceneHoverEvent>
#include <QGraphicsSceneMouseEvent>
#include <QGraphicsSceneWheelEvent>
#include <QPainter>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include "gsiDeclQtGuiTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QGraphicsItem

// bool QGraphicsItem::acceptDrops()


static void _init_f_acceptDrops_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_acceptDrops_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->acceptDrops ());
}


// bool QGraphicsItem::acceptHoverEvents()


static void _init_f_acceptHoverEvents_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_acceptHoverEvents_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->acceptHoverEvents ());
}


// bool QGraphicsItem::acceptTouchEvents()


static void _init_f_acceptTouchEvents_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_acceptTouchEvents_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->acceptTouchEvents ());
}


// QFlags<Qt::MouseButton> QGraphicsItem::acceptedMouseButtons()


static void _init_f_acceptedMouseButtons_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::MouseButton> > ();
}

static void _call_f_acceptedMouseButtons_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::MouseButton> > ((QFlags<Qt::MouseButton>)((QGraphicsItem *)cls)->acceptedMouseButtons ());
}


// bool QGraphicsItem::acceptsHoverEvents()


static void _init_f_acceptsHoverEvents_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_acceptsHoverEvents_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->acceptsHoverEvents ());
}


// void QGraphicsItem::advance(int phase)


static void _init_f_advance_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("phase");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_advance_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->advance (arg1);
}


// QRectF QGraphicsItem::boundingRect()


static void _init_f_boundingRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_boundingRect_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRectF > ((QRectF)((QGraphicsItem *)cls)->boundingRect ());
}


// QRegion QGraphicsItem::boundingRegion(const QTransform &itemToDeviceTransform)


static void _init_f_boundingRegion_c2350 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("itemToDeviceTransform");
  decl->add_arg<const QTransform & > (argspec_0);
  decl->set_return<QRegion > ();
}

static void _call_f_boundingRegion_c2350 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTransform &arg1 = gsi::arg_reader<const QTransform & >() (args, heap);
  ret.write<QRegion > ((QRegion)((QGraphicsItem *)cls)->boundingRegion (arg1));
}


// double QGraphicsItem::boundingRegionGranularity()


static void _init_f_boundingRegionGranularity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_boundingRegionGranularity_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QGraphicsItem *)cls)->boundingRegionGranularity ());
}


// QGraphicsItem::CacheMode QGraphicsItem::cacheMode()


static void _init_f_cacheMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QGraphicsItem::CacheMode>::target_type > ();
}

static void _call_f_cacheMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QGraphicsItem::CacheMode>::target_type > ((qt_gsi::Converter<QGraphicsItem::CacheMode>::target_type)qt_gsi::CppToQtAdaptor<QGraphicsItem::CacheMode>(((QGraphicsItem *)cls)->cacheMode ()));
}


// QList<QGraphicsItem *> QGraphicsItem::childItems()


static void _init_f_childItems_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QGraphicsItem *> > ();
}

static void _call_f_childItems_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QGraphicsItem *> > ((QList<QGraphicsItem *>)((QGraphicsItem *)cls)->childItems ());
}


// QList<QGraphicsItem *> QGraphicsItem::children()


static void _init_f_children_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QGraphicsItem *> > ();
}

static void _call_f_children_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QGraphicsItem *> > ((QList<QGraphicsItem *>)((QGraphicsItem *)cls)->children ());
}


// QRectF QGraphicsItem::childrenBoundingRect()


static void _init_f_childrenBoundingRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_childrenBoundingRect_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRectF > ((QRectF)((QGraphicsItem *)cls)->childrenBoundingRect ());
}


// void QGraphicsItem::clearFocus()


static void _init_f_clearFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clearFocus_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->clearFocus ();
}


// QPainterPath QGraphicsItem::clipPath()


static void _init_f_clipPath_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainterPath > ();
}

static void _call_f_clipPath_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsItem *)cls)->clipPath ());
}


// bool QGraphicsItem::collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode)


static void _init_f_collidesWithItem_c4977 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::IntersectsItemShape");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_collidesWithItem_c4977 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = gsi::arg_reader<const QGraphicsItem * >() (args, heap);
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::ItemSelectionMode>(heap, Qt::IntersectsItemShape), heap);
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->collidesWithItem (arg1, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg2).cref()));
}


// bool QGraphicsItem::collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode)


static void _init_f_collidesWithPath_c4877 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::IntersectsItemShape");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_collidesWithPath_c4877 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPainterPath &arg1 = gsi::arg_reader<const QPainterPath & >() (args, heap);
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::ItemSelectionMode>(heap, Qt::IntersectsItemShape), heap);
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->collidesWithPath (arg1, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg2).cref()));
}


// QList<QGraphicsItem *> QGraphicsItem::collidingItems(Qt::ItemSelectionMode mode)


static void _init_f_collidingItems_c2471 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode", true, "Qt::IntersectsItemShape");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_0);
  decl->set_return<QList<QGraphicsItem *> > ();
}

static void _call_f_collidingItems_c2471 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::ItemSelectionMode>(heap, Qt::IntersectsItemShape), heap);
  ret.write<QList<QGraphicsItem *> > ((QList<QGraphicsItem *>)((QGraphicsItem *)cls)->collidingItems (qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg1).cref()));
}


// QGraphicsItem *QGraphicsItem::commonAncestorItem(const QGraphicsItem *other)


static void _init_f_commonAncestorItem_c2614 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  decl->set_return<QGraphicsItem * > ();
}

static void _call_f_commonAncestorItem_c2614 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = gsi::arg_reader<const QGraphicsItem * >() (args, heap);
  ret.write<QGraphicsItem * > ((QGraphicsItem *)((QGraphicsItem *)cls)->commonAncestorItem (arg1));
}


// bool QGraphicsItem::contains(const QPointF &point)


static void _init_f_contains_c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_contains_c1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->contains (arg1));
}


// QCursor QGraphicsItem::cursor()


static void _init_f_cursor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QCursor > ();
}

static void _call_f_cursor_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QCursor > ((QCursor)((QGraphicsItem *)cls)->cursor ());
}


// QVariant QGraphicsItem::data(int key)


static void _init_f_data_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_data_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QVariant > ((QVariant)((QGraphicsItem *)cls)->data (arg1));
}


// QTransform QGraphicsItem::deviceTransform(const QTransform &viewportTransform)


static void _init_f_deviceTransform_c2350 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("viewportTransform");
  decl->add_arg<const QTransform & > (argspec_0);
  decl->set_return<QTransform > ();
}

static void _call_f_deviceTransform_c2350 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTransform &arg1 = gsi::arg_reader<const QTransform & >() (args, heap);
  ret.write<QTransform > ((QTransform)((QGraphicsItem *)cls)->deviceTransform (arg1));
}


// double QGraphicsItem::effectiveOpacity()


static void _init_f_effectiveOpacity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_effectiveOpacity_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QGraphicsItem *)cls)->effectiveOpacity ());
}


// void QGraphicsItem::ensureVisible(const QRectF &rect, int xmargin, int ymargin)


static void _init_f_ensureVisible_3180 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect", true, "QRectF()");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("xmargin", true, "50");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("ymargin", true, "50");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_ensureVisible_3180 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = args ? gsi::arg_reader<const QRectF & >() (args, heap) : gsi::arg_maker<const QRectF & >() (QRectF(), heap);
  int arg2 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (50, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (50, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->ensureVisible (arg1, arg2, arg3);
}


// void QGraphicsItem::ensureVisible(double x, double y, double w, double h, int xmargin, int ymargin)


static void _init_f_ensureVisible_5278 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("xmargin", true, "50");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("ymargin", true, "50");
  decl->add_arg<int > (argspec_5);
  decl->set_return<void > ();
}

static void _call_f_ensureVisible_5278 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  int arg5 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (50, heap);
  int arg6 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (50, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->ensureVisible (arg1, arg2, arg3, arg4, arg5, arg6);
}


// bool QGraphicsItem::filtersChildEvents()


static void _init_f_filtersChildEvents_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_filtersChildEvents_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->filtersChildEvents ());
}


// QFlags<QGraphicsItem::GraphicsItemFlag> QGraphicsItem::flags()


static void _init_f_flags_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QGraphicsItem::GraphicsItemFlag> > ();
}

static void _call_f_flags_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QGraphicsItem::GraphicsItemFlag> > ((QFlags<QGraphicsItem::GraphicsItemFlag>)((QGraphicsItem *)cls)->flags ());
}


// QGraphicsItem *QGraphicsItem::focusItem()


static void _init_f_focusItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsItem * > ();
}

static void _call_f_focusItem_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QGraphicsItem * > ((QGraphicsItem *)((QGraphicsItem *)cls)->focusItem ());
}


// QGraphicsItem *QGraphicsItem::focusProxy()


static void _init_f_focusProxy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsItem * > ();
}

static void _call_f_focusProxy_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QGraphicsItem * > ((QGraphicsItem *)((QGraphicsItem *)cls)->focusProxy ());
}


// QGraphicsItem *QGraphicsItem::focusScopeItem()


static void _init_f_focusScopeItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsItem * > ();
}

static void _call_f_focusScopeItem_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QGraphicsItem * > ((QGraphicsItem *)((QGraphicsItem *)cls)->focusScopeItem ());
}


// void QGraphicsItem::grabKeyboard()


static void _init_f_grabKeyboard_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_grabKeyboard_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->grabKeyboard ();
}


// void QGraphicsItem::grabMouse()


static void _init_f_grabMouse_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_grabMouse_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->grabMouse ();
}


// QGraphicsEffect *QGraphicsItem::graphicsEffect()


static void _init_f_graphicsEffect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsEffect * > ();
}

static void _call_f_graphicsEffect_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QGraphicsEffect * > ((QGraphicsEffect *)((QGraphicsItem *)cls)->graphicsEffect ());
}


// QGraphicsItemGroup *QGraphicsItem::group()


static void _init_f_group_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsItemGroup * > ();
}

static void _call_f_group_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QGraphicsItemGroup * > ((QGraphicsItemGroup *)((QGraphicsItem *)cls)->group ());
}


// bool QGraphicsItem::handlesChildEvents()


static void _init_f_handlesChildEvents_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_handlesChildEvents_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->handlesChildEvents ());
}


// bool QGraphicsItem::hasCursor()


static void _init_f_hasCursor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasCursor_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->hasCursor ());
}


// bool QGraphicsItem::hasFocus()


static void _init_f_hasFocus_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasFocus_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->hasFocus ());
}


// void QGraphicsItem::hide()


static void _init_f_hide_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_hide_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->hide ();
}


// QFlags<Qt::InputMethodHint> QGraphicsItem::inputMethodHints()


static void _init_f_inputMethodHints_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::InputMethodHint> > ();
}

static void _call_f_inputMethodHints_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::InputMethodHint> > ((QFlags<Qt::InputMethodHint>)((QGraphicsItem *)cls)->inputMethodHints ());
}


// void QGraphicsItem::installSceneEventFilter(QGraphicsItem *filterItem)


static void _init_f_installSceneEventFilter_1919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filterItem");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_installSceneEventFilter_1919 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsItem *arg1 = gsi::arg_reader<QGraphicsItem * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->installSceneEventFilter (arg1);
}


// bool QGraphicsItem::isActive()


static void _init_f_isActive_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isActive_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->isActive ());
}


// bool QGraphicsItem::isAncestorOf(const QGraphicsItem *child)


static void _init_f_isAncestorOf_c2614 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("child");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isAncestorOf_c2614 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = gsi::arg_reader<const QGraphicsItem * >() (args, heap);
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->isAncestorOf (arg1));
}


// bool QGraphicsItem::isClipped()


static void _init_f_isClipped_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isClipped_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->isClipped ());
}


// bool QGraphicsItem::isEnabled()


static void _init_f_isEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->isEnabled ());
}


// bool QGraphicsItem::isObscured()


static void _init_f_isObscured_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isObscured_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->isObscured ());
}


// bool QGraphicsItem::isObscured(const QRectF &rect)


static void _init_f_isObscured_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isObscured_c1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->isObscured (arg1));
}


// bool QGraphicsItem::isObscured(double x, double y, double w, double h)


static void _init_f_isObscured_c3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_f_isObscured_c3960 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->isObscured (arg1, arg2, arg3, arg4));
}


// bool QGraphicsItem::isObscuredBy(const QGraphicsItem *item)


static void _init_f_isObscuredBy_c2614 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isObscuredBy_c2614 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = gsi::arg_reader<const QGraphicsItem * >() (args, heap);
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->isObscuredBy (arg1));
}


// bool QGraphicsItem::isPanel()


static void _init_f_isPanel_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isPanel_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->isPanel ());
}


// bool QGraphicsItem::isSelected()


static void _init_f_isSelected_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSelected_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->isSelected ());
}


// bool QGraphicsItem::isUnderMouse()


static void _init_f_isUnderMouse_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isUnderMouse_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->isUnderMouse ());
}


// bool QGraphicsItem::isVisible()


static void _init_f_isVisible_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isVisible_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->isVisible ());
}


// bool QGraphicsItem::isVisibleTo(const QGraphicsItem *parent)


static void _init_f_isVisibleTo_c2614 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isVisibleTo_c2614 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = gsi::arg_reader<const QGraphicsItem * >() (args, heap);
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->isVisibleTo (arg1));
}


// bool QGraphicsItem::isWidget()


static void _init_f_isWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isWidget_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->isWidget ());
}


// bool QGraphicsItem::isWindow()


static void _init_f_isWindow_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isWindow_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsItem *)cls)->isWindow ());
}


// QTransform QGraphicsItem::itemTransform(const QGraphicsItem *other, bool *ok)


static void _init_f_itemTransform_c3556 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<QTransform > ();
}

static void _call_f_itemTransform_c3556 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = gsi::arg_reader<const QGraphicsItem * >() (args, heap);
  bool *arg2 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (0, heap);
  ret.write<QTransform > ((QTransform)((QGraphicsItem *)cls)->itemTransform (arg1, arg2));
}


// QPointF QGraphicsItem::mapFromItem(const QGraphicsItem *item, const QPointF &point)


static void _init_f_mapFromItem_c4492 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("point");
  decl->add_arg<const QPointF & > (argspec_1);
  decl->set_return<QPointF > ();
}

static void _call_f_mapFromItem_c4492 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = gsi::arg_reader<const QGraphicsItem * >() (args, heap);
  const QPointF &arg2 = gsi::arg_reader<const QPointF & >() (args, heap);
  ret.write<QPointF > ((QPointF)((QGraphicsItem *)cls)->mapFromItem (arg1, arg2));
}


// QPolygonF QGraphicsItem::mapFromItem(const QGraphicsItem *item, const QRectF &rect)


static void _init_f_mapFromItem_c4368 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRectF & > (argspec_1);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapFromItem_c4368 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = gsi::arg_reader<const QGraphicsItem * >() (args, heap);
  const QRectF &arg2 = gsi::arg_reader<const QRectF & >() (args, heap);
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapFromItem (arg1, arg2));
}


// QPolygonF QGraphicsItem::mapFromItem(const QGraphicsItem *item, const QPolygonF &polygon)


static void _init_f_mapFromItem_c4714 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("polygon");
  decl->add_arg<const QPolygonF & > (argspec_1);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapFromItem_c4714 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = gsi::arg_reader<const QGraphicsItem * >() (args, heap);
  const QPolygonF &arg2 = gsi::arg_reader<const QPolygonF & >() (args, heap);
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapFromItem (arg1, arg2));
}


// QPainterPath QGraphicsItem::mapFromItem(const QGraphicsItem *item, const QPainterPath &path)


static void _init_f_mapFromItem_c5020 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("path");
  decl->add_arg<const QPainterPath & > (argspec_1);
  decl->set_return<QPainterPath > ();
}

static void _call_f_mapFromItem_c5020 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = gsi::arg_reader<const QGraphicsItem * >() (args, heap);
  const QPainterPath &arg2 = gsi::arg_reader<const QPainterPath & >() (args, heap);
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsItem *)cls)->mapFromItem (arg1, arg2));
}


// QPointF QGraphicsItem::mapFromItem(const QGraphicsItem *item, double x, double y)


static void _init_f_mapFromItem_c4540 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("x");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("y");
  decl->add_arg<double > (argspec_2);
  decl->set_return<QPointF > ();
}

static void _call_f_mapFromItem_c4540 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = gsi::arg_reader<const QGraphicsItem * >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  ret.write<QPointF > ((QPointF)((QGraphicsItem *)cls)->mapFromItem (arg1, arg2, arg3));
}


// QPolygonF QGraphicsItem::mapFromItem(const QGraphicsItem *item, double x, double y, double w, double h)


static void _init_f_mapFromItem_c6466 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("x");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("y");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("h");
  decl->add_arg<double > (argspec_4);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapFromItem_c6466 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = gsi::arg_reader<const QGraphicsItem * >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  double arg5 = gsi::arg_reader<double >() (args, heap);
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapFromItem (arg1, arg2, arg3, arg4, arg5));
}


// QPointF QGraphicsItem::mapFromParent(const QPointF &point)


static void _init_f_mapFromParent_c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<QPointF > ();
}

static void _call_f_mapFromParent_c1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  ret.write<QPointF > ((QPointF)((QGraphicsItem *)cls)->mapFromParent (arg1));
}


// QPolygonF QGraphicsItem::mapFromParent(const QRectF &rect)


static void _init_f_mapFromParent_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapFromParent_c1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapFromParent (arg1));
}


// QPolygonF QGraphicsItem::mapFromParent(const QPolygonF &polygon)


static void _init_f_mapFromParent_c2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("polygon");
  decl->add_arg<const QPolygonF & > (argspec_0);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapFromParent_c2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPolygonF &arg1 = gsi::arg_reader<const QPolygonF & >() (args, heap);
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapFromParent (arg1));
}


// QPainterPath QGraphicsItem::mapFromParent(const QPainterPath &path)


static void _init_f_mapFromParent_c2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<QPainterPath > ();
}

static void _call_f_mapFromParent_c2514 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPainterPath &arg1 = gsi::arg_reader<const QPainterPath & >() (args, heap);
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsItem *)cls)->mapFromParent (arg1));
}


// QPointF QGraphicsItem::mapFromParent(double x, double y)


static void _init_f_mapFromParent_c2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  decl->set_return<QPointF > ();
}

static void _call_f_mapFromParent_c2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  ret.write<QPointF > ((QPointF)((QGraphicsItem *)cls)->mapFromParent (arg1, arg2));
}


// QPolygonF QGraphicsItem::mapFromParent(double x, double y, double w, double h)


static void _init_f_mapFromParent_c3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapFromParent_c3960 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapFromParent (arg1, arg2, arg3, arg4));
}


// QPointF QGraphicsItem::mapFromScene(const QPointF &point)


static void _init_f_mapFromScene_c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<QPointF > ();
}

static void _call_f_mapFromScene_c1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  ret.write<QPointF > ((QPointF)((QGraphicsItem *)cls)->mapFromScene (arg1));
}


// QPolygonF QGraphicsItem::mapFromScene(const QRectF &rect)


static void _init_f_mapFromScene_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapFromScene_c1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapFromScene (arg1));
}


// QPolygonF QGraphicsItem::mapFromScene(const QPolygonF &polygon)


static void _init_f_mapFromScene_c2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("polygon");
  decl->add_arg<const QPolygonF & > (argspec_0);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapFromScene_c2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPolygonF &arg1 = gsi::arg_reader<const QPolygonF & >() (args, heap);
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapFromScene (arg1));
}


// QPainterPath QGraphicsItem::mapFromScene(const QPainterPath &path)


static void _init_f_mapFromScene_c2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<QPainterPath > ();
}

static void _call_f_mapFromScene_c2514 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPainterPath &arg1 = gsi::arg_reader<const QPainterPath & >() (args, heap);
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsItem *)cls)->mapFromScene (arg1));
}


// QPointF QGraphicsItem::mapFromScene(double x, double y)


static void _init_f_mapFromScene_c2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  decl->set_return<QPointF > ();
}

static void _call_f_mapFromScene_c2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  ret.write<QPointF > ((QPointF)((QGraphicsItem *)cls)->mapFromScene (arg1, arg2));
}


// QPolygonF QGraphicsItem::mapFromScene(double x, double y, double w, double h)


static void _init_f_mapFromScene_c3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapFromScene_c3960 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapFromScene (arg1, arg2, arg3, arg4));
}


// QRectF QGraphicsItem::mapRectFromItem(const QGraphicsItem *item, const QRectF &rect)


static void _init_f_mapRectFromItem_c4368 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRectF & > (argspec_1);
  decl->set_return<QRectF > ();
}

static void _call_f_mapRectFromItem_c4368 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = gsi::arg_reader<const QGraphicsItem * >() (args, heap);
  const QRectF &arg2 = gsi::arg_reader<const QRectF & >() (args, heap);
  ret.write<QRectF > ((QRectF)((QGraphicsItem *)cls)->mapRectFromItem (arg1, arg2));
}


// QRectF QGraphicsItem::mapRectFromItem(const QGraphicsItem *item, double x, double y, double w, double h)


static void _init_f_mapRectFromItem_c6466 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("x");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("y");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("h");
  decl->add_arg<double > (argspec_4);
  decl->set_return<QRectF > ();
}

static void _call_f_mapRectFromItem_c6466 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = gsi::arg_reader<const QGraphicsItem * >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  double arg5 = gsi::arg_reader<double >() (args, heap);
  ret.write<QRectF > ((QRectF)((QGraphicsItem *)cls)->mapRectFromItem (arg1, arg2, arg3, arg4, arg5));
}


// QRectF QGraphicsItem::mapRectFromParent(const QRectF &rect)


static void _init_f_mapRectFromParent_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_mapRectFromParent_c1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  ret.write<QRectF > ((QRectF)((QGraphicsItem *)cls)->mapRectFromParent (arg1));
}


// QRectF QGraphicsItem::mapRectFromParent(double x, double y, double w, double h)


static void _init_f_mapRectFromParent_c3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  decl->set_return<QRectF > ();
}

static void _call_f_mapRectFromParent_c3960 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  ret.write<QRectF > ((QRectF)((QGraphicsItem *)cls)->mapRectFromParent (arg1, arg2, arg3, arg4));
}


// QRectF QGraphicsItem::mapRectFromScene(const QRectF &rect)


static void _init_f_mapRectFromScene_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_mapRectFromScene_c1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  ret.write<QRectF > ((QRectF)((QGraphicsItem *)cls)->mapRectFromScene (arg1));
}


// QRectF QGraphicsItem::mapRectFromScene(double x, double y, double w, double h)


static void _init_f_mapRectFromScene_c3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  decl->set_return<QRectF > ();
}

static void _call_f_mapRectFromScene_c3960 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  ret.write<QRectF > ((QRectF)((QGraphicsItem *)cls)->mapRectFromScene (arg1, arg2, arg3, arg4));
}


// QRectF QGraphicsItem::mapRectToItem(const QGraphicsItem *item, const QRectF &rect)


static void _init_f_mapRectToItem_c4368 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRectF & > (argspec_1);
  decl->set_return<QRectF > ();
}

static void _call_f_mapRectToItem_c4368 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = gsi::arg_reader<const QGraphicsItem * >() (args, heap);
  const QRectF &arg2 = gsi::arg_reader<const QRectF & >() (args, heap);
  ret.write<QRectF > ((QRectF)((QGraphicsItem *)cls)->mapRectToItem (arg1, arg2));
}


// QRectF QGraphicsItem::mapRectToItem(const QGraphicsItem *item, double x, double y, double w, double h)


static void _init_f_mapRectToItem_c6466 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("x");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("y");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("h");
  decl->add_arg<double > (argspec_4);
  decl->set_return<QRectF > ();
}

static void _call_f_mapRectToItem_c6466 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = gsi::arg_reader<const QGraphicsItem * >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  double arg5 = gsi::arg_reader<double >() (args, heap);
  ret.write<QRectF > ((QRectF)((QGraphicsItem *)cls)->mapRectToItem (arg1, arg2, arg3, arg4, arg5));
}


// QRectF QGraphicsItem::mapRectToParent(const QRectF &rect)


static void _init_f_mapRectToParent_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_mapRectToParent_c1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  ret.write<QRectF > ((QRectF)((QGraphicsItem *)cls)->mapRectToParent (arg1));
}


// QRectF QGraphicsItem::mapRectToParent(double x, double y, double w, double h)


static void _init_f_mapRectToParent_c3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  decl->set_return<QRectF > ();
}

static void _call_f_mapRectToParent_c3960 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  ret.write<QRectF > ((QRectF)((QGraphicsItem *)cls)->mapRectToParent (arg1, arg2, arg3, arg4));
}


// QRectF QGraphicsItem::mapRectToScene(const QRectF &rect)


static void _init_f_mapRectToScene_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_mapRectToScene_c1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  ret.write<QRectF > ((QRectF)((QGraphicsItem *)cls)->mapRectToScene (arg1));
}


// QRectF QGraphicsItem::mapRectToScene(double x, double y, double w, double h)


static void _init_f_mapRectToScene_c3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  decl->set_return<QRectF > ();
}

static void _call_f_mapRectToScene_c3960 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  ret.write<QRectF > ((QRectF)((QGraphicsItem *)cls)->mapRectToScene (arg1, arg2, arg3, arg4));
}


// QPointF QGraphicsItem::mapToItem(const QGraphicsItem *item, const QPointF &point)


static void _init_f_mapToItem_c4492 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("point");
  decl->add_arg<const QPointF & > (argspec_1);
  decl->set_return<QPointF > ();
}

static void _call_f_mapToItem_c4492 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = gsi::arg_reader<const QGraphicsItem * >() (args, heap);
  const QPointF &arg2 = gsi::arg_reader<const QPointF & >() (args, heap);
  ret.write<QPointF > ((QPointF)((QGraphicsItem *)cls)->mapToItem (arg1, arg2));
}


// QPolygonF QGraphicsItem::mapToItem(const QGraphicsItem *item, const QRectF &rect)


static void _init_f_mapToItem_c4368 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRectF & > (argspec_1);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapToItem_c4368 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = gsi::arg_reader<const QGraphicsItem * >() (args, heap);
  const QRectF &arg2 = gsi::arg_reader<const QRectF & >() (args, heap);
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapToItem (arg1, arg2));
}


// QPolygonF QGraphicsItem::mapToItem(const QGraphicsItem *item, const QPolygonF &polygon)


static void _init_f_mapToItem_c4714 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("polygon");
  decl->add_arg<const QPolygonF & > (argspec_1);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapToItem_c4714 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = gsi::arg_reader<const QGraphicsItem * >() (args, heap);
  const QPolygonF &arg2 = gsi::arg_reader<const QPolygonF & >() (args, heap);
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapToItem (arg1, arg2));
}


// QPainterPath QGraphicsItem::mapToItem(const QGraphicsItem *item, const QPainterPath &path)


static void _init_f_mapToItem_c5020 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("path");
  decl->add_arg<const QPainterPath & > (argspec_1);
  decl->set_return<QPainterPath > ();
}

static void _call_f_mapToItem_c5020 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = gsi::arg_reader<const QGraphicsItem * >() (args, heap);
  const QPainterPath &arg2 = gsi::arg_reader<const QPainterPath & >() (args, heap);
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsItem *)cls)->mapToItem (arg1, arg2));
}


// QPointF QGraphicsItem::mapToItem(const QGraphicsItem *item, double x, double y)


static void _init_f_mapToItem_c4540 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("x");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("y");
  decl->add_arg<double > (argspec_2);
  decl->set_return<QPointF > ();
}

static void _call_f_mapToItem_c4540 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = gsi::arg_reader<const QGraphicsItem * >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  ret.write<QPointF > ((QPointF)((QGraphicsItem *)cls)->mapToItem (arg1, arg2, arg3));
}


// QPolygonF QGraphicsItem::mapToItem(const QGraphicsItem *item, double x, double y, double w, double h)


static void _init_f_mapToItem_c6466 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("x");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("y");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("h");
  decl->add_arg<double > (argspec_4);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapToItem_c6466 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = gsi::arg_reader<const QGraphicsItem * >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  double arg5 = gsi::arg_reader<double >() (args, heap);
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapToItem (arg1, arg2, arg3, arg4, arg5));
}


// QPointF QGraphicsItem::mapToParent(const QPointF &point)


static void _init_f_mapToParent_c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<QPointF > ();
}

static void _call_f_mapToParent_c1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  ret.write<QPointF > ((QPointF)((QGraphicsItem *)cls)->mapToParent (arg1));
}


// QPolygonF QGraphicsItem::mapToParent(const QRectF &rect)


static void _init_f_mapToParent_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapToParent_c1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapToParent (arg1));
}


// QPolygonF QGraphicsItem::mapToParent(const QPolygonF &polygon)


static void _init_f_mapToParent_c2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("polygon");
  decl->add_arg<const QPolygonF & > (argspec_0);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapToParent_c2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPolygonF &arg1 = gsi::arg_reader<const QPolygonF & >() (args, heap);
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapToParent (arg1));
}


// QPainterPath QGraphicsItem::mapToParent(const QPainterPath &path)


static void _init_f_mapToParent_c2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<QPainterPath > ();
}

static void _call_f_mapToParent_c2514 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPainterPath &arg1 = gsi::arg_reader<const QPainterPath & >() (args, heap);
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsItem *)cls)->mapToParent (arg1));
}


// QPointF QGraphicsItem::mapToParent(double x, double y)


static void _init_f_mapToParent_c2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  decl->set_return<QPointF > ();
}

static void _call_f_mapToParent_c2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  ret.write<QPointF > ((QPointF)((QGraphicsItem *)cls)->mapToParent (arg1, arg2));
}


// QPolygonF QGraphicsItem::mapToParent(double x, double y, double w, double h)


static void _init_f_mapToParent_c3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapToParent_c3960 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapToParent (arg1, arg2, arg3, arg4));
}


// QPointF QGraphicsItem::mapToScene(const QPointF &point)


static void _init_f_mapToScene_c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<QPointF > ();
}

static void _call_f_mapToScene_c1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  ret.write<QPointF > ((QPointF)((QGraphicsItem *)cls)->mapToScene (arg1));
}


// QPolygonF QGraphicsItem::mapToScene(const QRectF &rect)


static void _init_f_mapToScene_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapToScene_c1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapToScene (arg1));
}


// QPolygonF QGraphicsItem::mapToScene(const QPolygonF &polygon)


static void _init_f_mapToScene_c2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("polygon");
  decl->add_arg<const QPolygonF & > (argspec_0);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapToScene_c2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPolygonF &arg1 = gsi::arg_reader<const QPolygonF & >() (args, heap);
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapToScene (arg1));
}


// QPainterPath QGraphicsItem::mapToScene(const QPainterPath &path)


static void _init_f_mapToScene_c2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<QPainterPath > ();
}

static void _call_f_mapToScene_c2514 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPainterPath &arg1 = gsi::arg_reader<const QPainterPath & >() (args, heap);
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsItem *)cls)->mapToScene (arg1));
}


// QPointF QGraphicsItem::mapToScene(double x, double y)


static void _init_f_mapToScene_c2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  decl->set_return<QPointF > ();
}

static void _call_f_mapToScene_c2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  ret.write<QPointF > ((QPointF)((QGraphicsItem *)cls)->mapToScene (arg1, arg2));
}


// QPolygonF QGraphicsItem::mapToScene(double x, double y, double w, double h)


static void _init_f_mapToScene_c3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapToScene_c3960 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsItem *)cls)->mapToScene (arg1, arg2, arg3, arg4));
}


// QMatrix QGraphicsItem::matrix()


static void _init_f_matrix_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMatrix > ();
}

static void _call_f_matrix_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMatrix > ((QMatrix)((QGraphicsItem *)cls)->matrix ());
}


// void QGraphicsItem::moveBy(double dx, double dy)


static void _init_f_moveBy_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_moveBy_2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->moveBy (arg1, arg2);
}


// double QGraphicsItem::opacity()


static void _init_f_opacity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_opacity_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QGraphicsItem *)cls)->opacity ());
}


// QPainterPath QGraphicsItem::opaqueArea()


static void _init_f_opaqueArea_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainterPath > ();
}

static void _call_f_opaqueArea_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsItem *)cls)->opaqueArea ());
}


// void QGraphicsItem::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)


static void _init_f_paint_6301 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionGraphicsItem * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget", true, "0");
  decl->add_arg<QWidget * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_paint_6301 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = gsi::arg_reader<QPainter * >() (args, heap);
  const QStyleOptionGraphicsItem *arg2 = gsi::arg_reader<const QStyleOptionGraphicsItem * >() (args, heap);
  QWidget *arg3 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (0, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->paint (arg1, arg2, arg3);
}


// QGraphicsItem *QGraphicsItem::panel()


static void _init_f_panel_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsItem * > ();
}

static void _call_f_panel_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QGraphicsItem * > ((QGraphicsItem *)((QGraphicsItem *)cls)->panel ());
}


// QGraphicsItem::PanelModality QGraphicsItem::panelModality()


static void _init_f_panelModality_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QGraphicsItem::PanelModality>::target_type > ();
}

static void _call_f_panelModality_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QGraphicsItem::PanelModality>::target_type > ((qt_gsi::Converter<QGraphicsItem::PanelModality>::target_type)qt_gsi::CppToQtAdaptor<QGraphicsItem::PanelModality>(((QGraphicsItem *)cls)->panelModality ()));
}


// QGraphicsItem *QGraphicsItem::parentItem()


static void _init_f_parentItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsItem * > ();
}

static void _call_f_parentItem_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QGraphicsItem * > ((QGraphicsItem *)((QGraphicsItem *)cls)->parentItem ());
}


// QGraphicsObject *QGraphicsItem::parentObject()


static void _init_f_parentObject_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsObject * > ();
}

static void _call_f_parentObject_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QGraphicsObject * > ((QGraphicsObject *)((QGraphicsItem *)cls)->parentObject ());
}


// QGraphicsWidget *QGraphicsItem::parentWidget()


static void _init_f_parentWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsWidget * > ();
}

static void _call_f_parentWidget_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QGraphicsWidget * > ((QGraphicsWidget *)((QGraphicsItem *)cls)->parentWidget ());
}


// QPointF QGraphicsItem::pos()


static void _init_f_pos_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPointF > ();
}

static void _call_f_pos_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPointF > ((QPointF)((QGraphicsItem *)cls)->pos ());
}


// void QGraphicsItem::removeSceneEventFilter(QGraphicsItem *filterItem)


static void _init_f_removeSceneEventFilter_1919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filterItem");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeSceneEventFilter_1919 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsItem *arg1 = gsi::arg_reader<QGraphicsItem * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->removeSceneEventFilter (arg1);
}


// void QGraphicsItem::resetMatrix()


static void _init_f_resetMatrix_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_resetMatrix_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->resetMatrix ();
}


// void QGraphicsItem::resetTransform()


static void _init_f_resetTransform_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_resetTransform_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->resetTransform ();
}


// void QGraphicsItem::rotate(double angle)


static void _init_f_rotate_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("angle");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_rotate_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->rotate (arg1);
}


// double QGraphicsItem::rotation()


static void _init_f_rotation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_rotation_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QGraphicsItem *)cls)->rotation ());
}


// void QGraphicsItem::scale(double sx, double sy)


static void _init_f_scale_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sx");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sy");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_scale_2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->scale (arg1, arg2);
}


// double QGraphicsItem::scale()


static void _init_f_scale_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_scale_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QGraphicsItem *)cls)->scale ());
}


// QGraphicsScene *QGraphicsItem::scene()


static void _init_f_scene_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsScene * > ();
}

static void _call_f_scene_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QGraphicsScene * > ((QGraphicsScene *)((QGraphicsItem *)cls)->scene ());
}


// QRectF QGraphicsItem::sceneBoundingRect()


static void _init_f_sceneBoundingRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_sceneBoundingRect_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRectF > ((QRectF)((QGraphicsItem *)cls)->sceneBoundingRect ());
}


// QMatrix QGraphicsItem::sceneMatrix()


static void _init_f_sceneMatrix_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMatrix > ();
}

static void _call_f_sceneMatrix_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMatrix > ((QMatrix)((QGraphicsItem *)cls)->sceneMatrix ());
}


// QPointF QGraphicsItem::scenePos()


static void _init_f_scenePos_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPointF > ();
}

static void _call_f_scenePos_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPointF > ((QPointF)((QGraphicsItem *)cls)->scenePos ());
}


// QTransform QGraphicsItem::sceneTransform()


static void _init_f_sceneTransform_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTransform > ();
}

static void _call_f_sceneTransform_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTransform > ((QTransform)((QGraphicsItem *)cls)->sceneTransform ());
}


// void QGraphicsItem::scroll(double dx, double dy, const QRectF &rect)


static void _init_f_scroll_3788 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("rect", true, "QRectF()");
  decl->add_arg<const QRectF & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_scroll_3788 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  const QRectF &arg3 = args ? gsi::arg_reader<const QRectF & >() (args, heap) : gsi::arg_maker<const QRectF & >() (QRectF(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->scroll (arg1, arg2, arg3);
}


// void QGraphicsItem::setAcceptDrops(bool on)


static void _init_f_setAcceptDrops_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("on");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAcceptDrops_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setAcceptDrops (arg1);
}


// void QGraphicsItem::setAcceptHoverEvents(bool enabled)


static void _init_f_setAcceptHoverEvents_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAcceptHoverEvents_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setAcceptHoverEvents (arg1);
}


// void QGraphicsItem::setAcceptTouchEvents(bool enabled)


static void _init_f_setAcceptTouchEvents_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAcceptTouchEvents_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setAcceptTouchEvents (arg1);
}


// void QGraphicsItem::setAcceptedMouseButtons(QFlags<Qt::MouseButton> buttons)


static void _init_f_setAcceptedMouseButtons_2602 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("buttons");
  decl->add_arg<QFlags<Qt::MouseButton> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAcceptedMouseButtons_2602 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<Qt::MouseButton> arg1 = gsi::arg_reader<QFlags<Qt::MouseButton> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setAcceptedMouseButtons (arg1);
}


// void QGraphicsItem::setAcceptsHoverEvents(bool enabled)


static void _init_f_setAcceptsHoverEvents_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAcceptsHoverEvents_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setAcceptsHoverEvents (arg1);
}


// void QGraphicsItem::setActive(bool active)


static void _init_f_setActive_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("active");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setActive_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setActive (arg1);
}


// void QGraphicsItem::setBoundingRegionGranularity(double granularity)


static void _init_f_setBoundingRegionGranularity_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("granularity");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBoundingRegionGranularity_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setBoundingRegionGranularity (arg1);
}


// void QGraphicsItem::setCacheMode(QGraphicsItem::CacheMode mode, const QSize &cacheSize)


static void _init_f_setCacheMode_4403 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QGraphicsItem::CacheMode>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("cacheSize", true, "QSize()");
  decl->add_arg<const QSize & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setCacheMode_4403 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QGraphicsItem::CacheMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QGraphicsItem::CacheMode>::target_type & >() (args, heap);
  const QSize &arg2 = args ? gsi::arg_reader<const QSize & >() (args, heap) : gsi::arg_maker<const QSize & >() (QSize(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setCacheMode (qt_gsi::QtToCppAdaptor<QGraphicsItem::CacheMode>(arg1).cref(), arg2);
}


// void QGraphicsItem::setCursor(const QCursor &cursor)


static void _init_f_setCursor_2032 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cursor");
  decl->add_arg<const QCursor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCursor_2032 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QCursor &arg1 = gsi::arg_reader<const QCursor & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setCursor (arg1);
}


// void QGraphicsItem::setData(int key, const QVariant &value)


static void _init_f_setData_2778 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setData_2778 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QVariant &arg2 = gsi::arg_reader<const QVariant & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setData (arg1, arg2);
}


// void QGraphicsItem::setEnabled(bool enabled)


static void _init_f_setEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEnabled_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setEnabled (arg1);
}


// void QGraphicsItem::setFiltersChildEvents(bool enabled)


static void _init_f_setFiltersChildEvents_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFiltersChildEvents_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setFiltersChildEvents (arg1);
}


// void QGraphicsItem::setFlag(QGraphicsItem::GraphicsItemFlag flag, bool enabled)


static void _init_f_setFlag_4199 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flag");
  decl->add_arg<const qt_gsi::Converter<QGraphicsItem::GraphicsItemFlag>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("enabled", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setFlag_4199 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QGraphicsItem::GraphicsItemFlag>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QGraphicsItem::GraphicsItemFlag>::target_type & >() (args, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setFlag (qt_gsi::QtToCppAdaptor<QGraphicsItem::GraphicsItemFlag>(arg1).cref(), arg2);
}


// void QGraphicsItem::setFlags(QFlags<QGraphicsItem::GraphicsItemFlag> flags)


static void _init_f_setFlags_4139 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags");
  decl->add_arg<QFlags<QGraphicsItem::GraphicsItemFlag> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFlags_4139 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QGraphicsItem::GraphicsItemFlag> arg1 = gsi::arg_reader<QFlags<QGraphicsItem::GraphicsItemFlag> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setFlags (arg1);
}


// void QGraphicsItem::setFocus(Qt::FocusReason focusReason)


static void _init_f_setFocus_1877 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("focusReason", true, "Qt::OtherFocusReason");
  decl->add_arg<const qt_gsi::Converter<Qt::FocusReason>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFocus_1877 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::FocusReason>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::FocusReason>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::FocusReason>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::FocusReason>(heap, Qt::OtherFocusReason), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setFocus (qt_gsi::QtToCppAdaptor<Qt::FocusReason>(arg1).cref());
}


// void QGraphicsItem::setFocusProxy(QGraphicsItem *item)


static void _init_f_setFocusProxy_1919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFocusProxy_1919 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsItem *arg1 = gsi::arg_reader<QGraphicsItem * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setFocusProxy (arg1);
}


// void QGraphicsItem::setGraphicsEffect(QGraphicsEffect *effect)


static void _init_f_setGraphicsEffect_2109 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("effect");
  decl->add_arg<QGraphicsEffect * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGraphicsEffect_2109 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsEffect *arg1 = gsi::arg_reader<QGraphicsEffect * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setGraphicsEffect (arg1);
}


// void QGraphicsItem::setGroup(QGraphicsItemGroup *group)


static void _init_f_setGroup_2444 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("group");
  decl->add_arg<QGraphicsItemGroup * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGroup_2444 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsItemGroup *arg1 = gsi::arg_reader<QGraphicsItemGroup * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setGroup (arg1);
}


// void QGraphicsItem::setHandlesChildEvents(bool enabled)


static void _init_f_setHandlesChildEvents_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHandlesChildEvents_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setHandlesChildEvents (arg1);
}


// void QGraphicsItem::setInputMethodHints(QFlags<Qt::InputMethodHint> hints)


static void _init_f_setInputMethodHints_2985 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hints");
  decl->add_arg<QFlags<Qt::InputMethodHint> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setInputMethodHints_2985 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<Qt::InputMethodHint> arg1 = gsi::arg_reader<QFlags<Qt::InputMethodHint> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setInputMethodHints (arg1);
}


// void QGraphicsItem::setMatrix(const QMatrix &matrix, bool combine)


static void _init_f_setMatrix_2779 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("matrix");
  decl->add_arg<const QMatrix & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("combine", true, "false");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setMatrix_2779 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMatrix &arg1 = gsi::arg_reader<const QMatrix & >() (args, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (false, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setMatrix (arg1, arg2);
}


// void QGraphicsItem::setOpacity(double opacity)


static void _init_f_setOpacity_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("opacity");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOpacity_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setOpacity (arg1);
}


// void QGraphicsItem::setPanelModality(QGraphicsItem::PanelModality panelModality)


static void _init_f_setPanelModality_3180 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("panelModality");
  decl->add_arg<const qt_gsi::Converter<QGraphicsItem::PanelModality>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPanelModality_3180 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QGraphicsItem::PanelModality>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QGraphicsItem::PanelModality>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setPanelModality (qt_gsi::QtToCppAdaptor<QGraphicsItem::PanelModality>(arg1).cref());
}


// void QGraphicsItem::setParentItem(QGraphicsItem *parent)


static void _init_f_setParentItem_1919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setParentItem_1919 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsItem *arg1 = gsi::arg_reader<QGraphicsItem * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setParentItem (arg1);
}


// void QGraphicsItem::setPos(const QPointF &pos)


static void _init_f_setPos_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPos_1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setPos (arg1);
}


// void QGraphicsItem::setPos(double x, double y)


static void _init_f_setPos_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setPos_2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setPos (arg1, arg2);
}


// void QGraphicsItem::setRotation(double angle)


static void _init_f_setRotation_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("angle");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRotation_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setRotation (arg1);
}


// void QGraphicsItem::setScale(double scale)


static void _init_f_setScale_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("scale");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setScale_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setScale (arg1);
}


// void QGraphicsItem::setSelected(bool selected)


static void _init_f_setSelected_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selected");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSelected_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setSelected (arg1);
}


// void QGraphicsItem::setToolTip(const QString &toolTip)


static void _init_f_setToolTip_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("toolTip");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setToolTip_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setToolTip (arg1);
}


// void QGraphicsItem::setTransform(const QTransform &matrix, bool combine)


static void _init_f_setTransform_3106 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("matrix");
  decl->add_arg<const QTransform & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("combine", true, "false");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setTransform_3106 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTransform &arg1 = gsi::arg_reader<const QTransform & >() (args, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (false, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setTransform (arg1, arg2);
}


// void QGraphicsItem::setTransformOriginPoint(const QPointF &origin)


static void _init_f_setTransformOriginPoint_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("origin");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTransformOriginPoint_1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setTransformOriginPoint (arg1);
}


// void QGraphicsItem::setTransformOriginPoint(double ax, double ay)


static void _init_f_setTransformOriginPoint_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ax");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ay");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setTransformOriginPoint_2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setTransformOriginPoint (arg1, arg2);
}


// void QGraphicsItem::setTransformations(const QList<QGraphicsTransform *> &transformations)


static void _init_f_setTransformations_3968 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("transformations");
  decl->add_arg<const QList<QGraphicsTransform *> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTransformations_3968 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QGraphicsTransform *> &arg1 = gsi::arg_reader<const QList<QGraphicsTransform *> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setTransformations (arg1);
}


// void QGraphicsItem::setVisible(bool visible)


static void _init_f_setVisible_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVisible_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setVisible (arg1);
}


// void QGraphicsItem::setX(double x)


static void _init_f_setX_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setX_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setX (arg1);
}


// void QGraphicsItem::setY(double y)


static void _init_f_setY_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("y");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setY_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setY (arg1);
}


// void QGraphicsItem::setZValue(double z)


static void _init_f_setZValue_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("z");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setZValue_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->setZValue (arg1);
}


// QPainterPath QGraphicsItem::shape()


static void _init_f_shape_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainterPath > ();
}

static void _call_f_shape_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsItem *)cls)->shape ());
}


// void QGraphicsItem::shear(double sh, double sv)


static void _init_f_shear_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sh");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sv");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_shear_2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->shear (arg1, arg2);
}


// void QGraphicsItem::show()


static void _init_f_show_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_show_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->show ();
}


// void QGraphicsItem::stackBefore(const QGraphicsItem *sibling)


static void _init_f_stackBefore_2614 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sibling");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_stackBefore_2614 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = gsi::arg_reader<const QGraphicsItem * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->stackBefore (arg1);
}


// QGraphicsObject *QGraphicsItem::toGraphicsObject()


static void _init_f_toGraphicsObject_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsObject * > ();
}

static void _call_f_toGraphicsObject_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QGraphicsObject * > ((QGraphicsObject *)((QGraphicsItem *)cls)->toGraphicsObject ());
}


// const QGraphicsObject *QGraphicsItem::toGraphicsObject()


static void _init_f_toGraphicsObject_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QGraphicsObject * > ();
}

static void _call_f_toGraphicsObject_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QGraphicsObject * > ((const QGraphicsObject *)((QGraphicsItem *)cls)->toGraphicsObject ());
}


// QString QGraphicsItem::toolTip()


static void _init_f_toolTip_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_toolTip_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QGraphicsItem *)cls)->toolTip ());
}


// QGraphicsItem *QGraphicsItem::topLevelItem()


static void _init_f_topLevelItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsItem * > ();
}

static void _call_f_topLevelItem_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QGraphicsItem * > ((QGraphicsItem *)((QGraphicsItem *)cls)->topLevelItem ());
}


// QGraphicsWidget *QGraphicsItem::topLevelWidget()


static void _init_f_topLevelWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsWidget * > ();
}

static void _call_f_topLevelWidget_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QGraphicsWidget * > ((QGraphicsWidget *)((QGraphicsItem *)cls)->topLevelWidget ());
}


// QTransform QGraphicsItem::transform()


static void _init_f_transform_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTransform > ();
}

static void _call_f_transform_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTransform > ((QTransform)((QGraphicsItem *)cls)->transform ());
}


// QPointF QGraphicsItem::transformOriginPoint()


static void _init_f_transformOriginPoint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPointF > ();
}

static void _call_f_transformOriginPoint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPointF > ((QPointF)((QGraphicsItem *)cls)->transformOriginPoint ());
}


// QList<QGraphicsTransform *> QGraphicsItem::transformations()


static void _init_f_transformations_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QGraphicsTransform *> > ();
}

static void _call_f_transformations_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QGraphicsTransform *> > ((QList<QGraphicsTransform *>)((QGraphicsItem *)cls)->transformations ());
}


// void QGraphicsItem::translate(double dx, double dy)


static void _init_f_translate_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_translate_2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->translate (arg1, arg2);
}


// int QGraphicsItem::type()


static void _init_f_type_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_type_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QGraphicsItem *)cls)->type ());
}


// void QGraphicsItem::ungrabKeyboard()


static void _init_f_ungrabKeyboard_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_ungrabKeyboard_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->ungrabKeyboard ();
}


// void QGraphicsItem::ungrabMouse()


static void _init_f_ungrabMouse_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_ungrabMouse_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->ungrabMouse ();
}


// void QGraphicsItem::unsetCursor()


static void _init_f_unsetCursor_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_unsetCursor_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->unsetCursor ();
}


// void QGraphicsItem::update(const QRectF &rect)


static void _init_f_update_1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect", true, "QRectF()");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_update_1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = args ? gsi::arg_reader<const QRectF & >() (args, heap) : gsi::arg_maker<const QRectF & >() (QRectF(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->update (arg1);
}


// void QGraphicsItem::update(double x, double y, double width, double height)


static void _init_f_update_3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("width");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("height");
  decl->add_arg<double > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_update_3960 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem *)cls)->update (arg1, arg2, arg3, arg4);
}


// QGraphicsWidget *QGraphicsItem::window()


static void _init_f_window_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsWidget * > ();
}

static void _call_f_window_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QGraphicsWidget * > ((QGraphicsWidget *)((QGraphicsItem *)cls)->window ());
}


// double QGraphicsItem::x()


static void _init_f_x_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_x_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QGraphicsItem *)cls)->x ());
}


// double QGraphicsItem::y()


static void _init_f_y_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_y_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QGraphicsItem *)cls)->y ());
}


// double QGraphicsItem::zValue()


static void _init_f_zValue_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_zValue_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QGraphicsItem *)cls)->zValue ());
}


namespace gsi
{

static gsi::Methods methods_QGraphicsItem () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod (":acceptDrops", "@brief Method bool QGraphicsItem::acceptDrops()\n", true, &_init_f_acceptDrops_c0, &_call_f_acceptDrops_c0);
  methods += new qt_gsi::GenericMethod (":acceptHoverEvents", "@brief Method bool QGraphicsItem::acceptHoverEvents()\n", true, &_init_f_acceptHoverEvents_c0, &_call_f_acceptHoverEvents_c0);
  methods += new qt_gsi::GenericMethod (":acceptTouchEvents", "@brief Method bool QGraphicsItem::acceptTouchEvents()\n", true, &_init_f_acceptTouchEvents_c0, &_call_f_acceptTouchEvents_c0);
  methods += new qt_gsi::GenericMethod (":acceptedMouseButtons", "@brief Method QFlags<Qt::MouseButton> QGraphicsItem::acceptedMouseButtons()\n", true, &_init_f_acceptedMouseButtons_c0, &_call_f_acceptedMouseButtons_c0);
  methods += new qt_gsi::GenericMethod (":acceptsHoverEvents", "@brief Method bool QGraphicsItem::acceptsHoverEvents()\n", true, &_init_f_acceptsHoverEvents_c0, &_call_f_acceptsHoverEvents_c0);
  methods += new qt_gsi::GenericMethod ("advance", "@brief Method void QGraphicsItem::advance(int phase)\n", false, &_init_f_advance_767, &_call_f_advance_767);
  methods += new qt_gsi::GenericMethod ("boundingRect", "@brief Method QRectF QGraphicsItem::boundingRect()\n", true, &_init_f_boundingRect_c0, &_call_f_boundingRect_c0);
  methods += new qt_gsi::GenericMethod ("boundingRegion", "@brief Method QRegion QGraphicsItem::boundingRegion(const QTransform &itemToDeviceTransform)\n", true, &_init_f_boundingRegion_c2350, &_call_f_boundingRegion_c2350);
  methods += new qt_gsi::GenericMethod (":boundingRegionGranularity", "@brief Method double QGraphicsItem::boundingRegionGranularity()\n", true, &_init_f_boundingRegionGranularity_c0, &_call_f_boundingRegionGranularity_c0);
  methods += new qt_gsi::GenericMethod (":cacheMode", "@brief Method QGraphicsItem::CacheMode QGraphicsItem::cacheMode()\n", true, &_init_f_cacheMode_c0, &_call_f_cacheMode_c0);
  methods += new qt_gsi::GenericMethod ("childItems", "@brief Method QList<QGraphicsItem *> QGraphicsItem::childItems()\n", true, &_init_f_childItems_c0, &_call_f_childItems_c0);
  methods += new qt_gsi::GenericMethod ("children", "@brief Method QList<QGraphicsItem *> QGraphicsItem::children()\n", true, &_init_f_children_c0, &_call_f_children_c0);
  methods += new qt_gsi::GenericMethod ("childrenBoundingRect", "@brief Method QRectF QGraphicsItem::childrenBoundingRect()\n", true, &_init_f_childrenBoundingRect_c0, &_call_f_childrenBoundingRect_c0);
  methods += new qt_gsi::GenericMethod ("clearFocus", "@brief Method void QGraphicsItem::clearFocus()\n", false, &_init_f_clearFocus_0, &_call_f_clearFocus_0);
  methods += new qt_gsi::GenericMethod ("clipPath", "@brief Method QPainterPath QGraphicsItem::clipPath()\n", true, &_init_f_clipPath_c0, &_call_f_clipPath_c0);
  methods += new qt_gsi::GenericMethod ("collidesWithItem", "@brief Method bool QGraphicsItem::collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode)\n", true, &_init_f_collidesWithItem_c4977, &_call_f_collidesWithItem_c4977);
  methods += new qt_gsi::GenericMethod ("collidesWithPath", "@brief Method bool QGraphicsItem::collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode)\n", true, &_init_f_collidesWithPath_c4877, &_call_f_collidesWithPath_c4877);
  methods += new qt_gsi::GenericMethod ("collidingItems", "@brief Method QList<QGraphicsItem *> QGraphicsItem::collidingItems(Qt::ItemSelectionMode mode)\n", true, &_init_f_collidingItems_c2471, &_call_f_collidingItems_c2471);
  methods += new qt_gsi::GenericMethod ("commonAncestorItem", "@brief Method QGraphicsItem *QGraphicsItem::commonAncestorItem(const QGraphicsItem *other)\n", true, &_init_f_commonAncestorItem_c2614, &_call_f_commonAncestorItem_c2614);
  methods += new qt_gsi::GenericMethod ("contains", "@brief Method bool QGraphicsItem::contains(const QPointF &point)\n", true, &_init_f_contains_c1986, &_call_f_contains_c1986);
  methods += new qt_gsi::GenericMethod (":cursor", "@brief Method QCursor QGraphicsItem::cursor()\n", true, &_init_f_cursor_c0, &_call_f_cursor_c0);
  methods += new qt_gsi::GenericMethod ("data", "@brief Method QVariant QGraphicsItem::data(int key)\n", true, &_init_f_data_c767, &_call_f_data_c767);
  methods += new qt_gsi::GenericMethod ("deviceTransform", "@brief Method QTransform QGraphicsItem::deviceTransform(const QTransform &viewportTransform)\n", true, &_init_f_deviceTransform_c2350, &_call_f_deviceTransform_c2350);
  methods += new qt_gsi::GenericMethod ("effectiveOpacity", "@brief Method double QGraphicsItem::effectiveOpacity()\n", true, &_init_f_effectiveOpacity_c0, &_call_f_effectiveOpacity_c0);
  methods += new qt_gsi::GenericMethod ("ensureVisible", "@brief Method void QGraphicsItem::ensureVisible(const QRectF &rect, int xmargin, int ymargin)\n", false, &_init_f_ensureVisible_3180, &_call_f_ensureVisible_3180);
  methods += new qt_gsi::GenericMethod ("ensureVisible", "@brief Method void QGraphicsItem::ensureVisible(double x, double y, double w, double h, int xmargin, int ymargin)\n", false, &_init_f_ensureVisible_5278, &_call_f_ensureVisible_5278);
  methods += new qt_gsi::GenericMethod (":filtersChildEvents", "@brief Method bool QGraphicsItem::filtersChildEvents()\n", true, &_init_f_filtersChildEvents_c0, &_call_f_filtersChildEvents_c0);
  methods += new qt_gsi::GenericMethod (":flags", "@brief Method QFlags<QGraphicsItem::GraphicsItemFlag> QGraphicsItem::flags()\n", true, &_init_f_flags_c0, &_call_f_flags_c0);
  methods += new qt_gsi::GenericMethod ("focusItem", "@brief Method QGraphicsItem *QGraphicsItem::focusItem()\n", true, &_init_f_focusItem_c0, &_call_f_focusItem_c0);
  methods += new qt_gsi::GenericMethod (":focusProxy", "@brief Method QGraphicsItem *QGraphicsItem::focusProxy()\n", true, &_init_f_focusProxy_c0, &_call_f_focusProxy_c0);
  methods += new qt_gsi::GenericMethod ("focusScopeItem", "@brief Method QGraphicsItem *QGraphicsItem::focusScopeItem()\n", true, &_init_f_focusScopeItem_c0, &_call_f_focusScopeItem_c0);
  methods += new qt_gsi::GenericMethod ("grabKeyboard", "@brief Method void QGraphicsItem::grabKeyboard()\n", false, &_init_f_grabKeyboard_0, &_call_f_grabKeyboard_0);
  methods += new qt_gsi::GenericMethod ("grabMouse", "@brief Method void QGraphicsItem::grabMouse()\n", false, &_init_f_grabMouse_0, &_call_f_grabMouse_0);
  methods += new qt_gsi::GenericMethod (":graphicsEffect", "@brief Method QGraphicsEffect *QGraphicsItem::graphicsEffect()\n", true, &_init_f_graphicsEffect_c0, &_call_f_graphicsEffect_c0);
  methods += new qt_gsi::GenericMethod (":group", "@brief Method QGraphicsItemGroup *QGraphicsItem::group()\n", true, &_init_f_group_c0, &_call_f_group_c0);
  methods += new qt_gsi::GenericMethod (":handlesChildEvents", "@brief Method bool QGraphicsItem::handlesChildEvents()\n", true, &_init_f_handlesChildEvents_c0, &_call_f_handlesChildEvents_c0);
  methods += new qt_gsi::GenericMethod ("hasCursor", "@brief Method bool QGraphicsItem::hasCursor()\n", true, &_init_f_hasCursor_c0, &_call_f_hasCursor_c0);
  methods += new qt_gsi::GenericMethod ("hasFocus", "@brief Method bool QGraphicsItem::hasFocus()\n", true, &_init_f_hasFocus_c0, &_call_f_hasFocus_c0);
  methods += new qt_gsi::GenericMethod ("hide", "@brief Method void QGraphicsItem::hide()\n", false, &_init_f_hide_0, &_call_f_hide_0);
  methods += new qt_gsi::GenericMethod (":inputMethodHints", "@brief Method QFlags<Qt::InputMethodHint> QGraphicsItem::inputMethodHints()\n", true, &_init_f_inputMethodHints_c0, &_call_f_inputMethodHints_c0);
  methods += new qt_gsi::GenericMethod ("installSceneEventFilter", "@brief Method void QGraphicsItem::installSceneEventFilter(QGraphicsItem *filterItem)\n", false, &_init_f_installSceneEventFilter_1919, &_call_f_installSceneEventFilter_1919);
  methods += new qt_gsi::GenericMethod ("isActive?|:active", "@brief Method bool QGraphicsItem::isActive()\n", true, &_init_f_isActive_c0, &_call_f_isActive_c0);
  methods += new qt_gsi::GenericMethod ("isAncestorOf?", "@brief Method bool QGraphicsItem::isAncestorOf(const QGraphicsItem *child)\n", true, &_init_f_isAncestorOf_c2614, &_call_f_isAncestorOf_c2614);
  methods += new qt_gsi::GenericMethod ("isClipped?", "@brief Method bool QGraphicsItem::isClipped()\n", true, &_init_f_isClipped_c0, &_call_f_isClipped_c0);
  methods += new qt_gsi::GenericMethod ("isEnabled?|:enabled", "@brief Method bool QGraphicsItem::isEnabled()\n", true, &_init_f_isEnabled_c0, &_call_f_isEnabled_c0);
  methods += new qt_gsi::GenericMethod ("isObscured?", "@brief Method bool QGraphicsItem::isObscured()\n", true, &_init_f_isObscured_c0, &_call_f_isObscured_c0);
  methods += new qt_gsi::GenericMethod ("isObscured?", "@brief Method bool QGraphicsItem::isObscured(const QRectF &rect)\n", true, &_init_f_isObscured_c1862, &_call_f_isObscured_c1862);
  methods += new qt_gsi::GenericMethod ("isObscured?", "@brief Method bool QGraphicsItem::isObscured(double x, double y, double w, double h)\n", true, &_init_f_isObscured_c3960, &_call_f_isObscured_c3960);
  methods += new qt_gsi::GenericMethod ("isObscuredBy?", "@brief Method bool QGraphicsItem::isObscuredBy(const QGraphicsItem *item)\n", true, &_init_f_isObscuredBy_c2614, &_call_f_isObscuredBy_c2614);
  methods += new qt_gsi::GenericMethod ("isPanel?", "@brief Method bool QGraphicsItem::isPanel()\n", true, &_init_f_isPanel_c0, &_call_f_isPanel_c0);
  methods += new qt_gsi::GenericMethod ("isSelected?|:selected", "@brief Method bool QGraphicsItem::isSelected()\n", true, &_init_f_isSelected_c0, &_call_f_isSelected_c0);
  methods += new qt_gsi::GenericMethod ("isUnderMouse?", "@brief Method bool QGraphicsItem::isUnderMouse()\n", true, &_init_f_isUnderMouse_c0, &_call_f_isUnderMouse_c0);
  methods += new qt_gsi::GenericMethod ("isVisible?|:visible", "@brief Method bool QGraphicsItem::isVisible()\n", true, &_init_f_isVisible_c0, &_call_f_isVisible_c0);
  methods += new qt_gsi::GenericMethod ("isVisibleTo?", "@brief Method bool QGraphicsItem::isVisibleTo(const QGraphicsItem *parent)\n", true, &_init_f_isVisibleTo_c2614, &_call_f_isVisibleTo_c2614);
  methods += new qt_gsi::GenericMethod ("isWidget?", "@brief Method bool QGraphicsItem::isWidget()\n", true, &_init_f_isWidget_c0, &_call_f_isWidget_c0);
  methods += new qt_gsi::GenericMethod ("isWindow?", "@brief Method bool QGraphicsItem::isWindow()\n", true, &_init_f_isWindow_c0, &_call_f_isWindow_c0);
  methods += new qt_gsi::GenericMethod ("itemTransform", "@brief Method QTransform QGraphicsItem::itemTransform(const QGraphicsItem *other, bool *ok)\n", true, &_init_f_itemTransform_c3556, &_call_f_itemTransform_c3556);
  methods += new qt_gsi::GenericMethod ("mapFromItem", "@brief Method QPointF QGraphicsItem::mapFromItem(const QGraphicsItem *item, const QPointF &point)\n", true, &_init_f_mapFromItem_c4492, &_call_f_mapFromItem_c4492);
  methods += new qt_gsi::GenericMethod ("mapFromItem", "@brief Method QPolygonF QGraphicsItem::mapFromItem(const QGraphicsItem *item, const QRectF &rect)\n", true, &_init_f_mapFromItem_c4368, &_call_f_mapFromItem_c4368);
  methods += new qt_gsi::GenericMethod ("mapFromItem", "@brief Method QPolygonF QGraphicsItem::mapFromItem(const QGraphicsItem *item, const QPolygonF &polygon)\n", true, &_init_f_mapFromItem_c4714, &_call_f_mapFromItem_c4714);
  methods += new qt_gsi::GenericMethod ("mapFromItem", "@brief Method QPainterPath QGraphicsItem::mapFromItem(const QGraphicsItem *item, const QPainterPath &path)\n", true, &_init_f_mapFromItem_c5020, &_call_f_mapFromItem_c5020);
  methods += new qt_gsi::GenericMethod ("mapFromItem", "@brief Method QPointF QGraphicsItem::mapFromItem(const QGraphicsItem *item, double x, double y)\n", true, &_init_f_mapFromItem_c4540, &_call_f_mapFromItem_c4540);
  methods += new qt_gsi::GenericMethod ("mapFromItem", "@brief Method QPolygonF QGraphicsItem::mapFromItem(const QGraphicsItem *item, double x, double y, double w, double h)\n", true, &_init_f_mapFromItem_c6466, &_call_f_mapFromItem_c6466);
  methods += new qt_gsi::GenericMethod ("mapFromParent", "@brief Method QPointF QGraphicsItem::mapFromParent(const QPointF &point)\n", true, &_init_f_mapFromParent_c1986, &_call_f_mapFromParent_c1986);
  methods += new qt_gsi::GenericMethod ("mapFromParent", "@brief Method QPolygonF QGraphicsItem::mapFromParent(const QRectF &rect)\n", true, &_init_f_mapFromParent_c1862, &_call_f_mapFromParent_c1862);
  methods += new qt_gsi::GenericMethod ("mapFromParent", "@brief Method QPolygonF QGraphicsItem::mapFromParent(const QPolygonF &polygon)\n", true, &_init_f_mapFromParent_c2208, &_call_f_mapFromParent_c2208);
  methods += new qt_gsi::GenericMethod ("mapFromParent", "@brief Method QPainterPath QGraphicsItem::mapFromParent(const QPainterPath &path)\n", true, &_init_f_mapFromParent_c2514, &_call_f_mapFromParent_c2514);
  methods += new qt_gsi::GenericMethod ("mapFromParent", "@brief Method QPointF QGraphicsItem::mapFromParent(double x, double y)\n", true, &_init_f_mapFromParent_c2034, &_call_f_mapFromParent_c2034);
  methods += new qt_gsi::GenericMethod ("mapFromParent", "@brief Method QPolygonF QGraphicsItem::mapFromParent(double x, double y, double w, double h)\n", true, &_init_f_mapFromParent_c3960, &_call_f_mapFromParent_c3960);
  methods += new qt_gsi::GenericMethod ("mapFromScene", "@brief Method QPointF QGraphicsItem::mapFromScene(const QPointF &point)\n", true, &_init_f_mapFromScene_c1986, &_call_f_mapFromScene_c1986);
  methods += new qt_gsi::GenericMethod ("mapFromScene", "@brief Method QPolygonF QGraphicsItem::mapFromScene(const QRectF &rect)\n", true, &_init_f_mapFromScene_c1862, &_call_f_mapFromScene_c1862);
  methods += new qt_gsi::GenericMethod ("mapFromScene", "@brief Method QPolygonF QGraphicsItem::mapFromScene(const QPolygonF &polygon)\n", true, &_init_f_mapFromScene_c2208, &_call_f_mapFromScene_c2208);
  methods += new qt_gsi::GenericMethod ("mapFromScene", "@brief Method QPainterPath QGraphicsItem::mapFromScene(const QPainterPath &path)\n", true, &_init_f_mapFromScene_c2514, &_call_f_mapFromScene_c2514);
  methods += new qt_gsi::GenericMethod ("mapFromScene", "@brief Method QPointF QGraphicsItem::mapFromScene(double x, double y)\n", true, &_init_f_mapFromScene_c2034, &_call_f_mapFromScene_c2034);
  methods += new qt_gsi::GenericMethod ("mapFromScene", "@brief Method QPolygonF QGraphicsItem::mapFromScene(double x, double y, double w, double h)\n", true, &_init_f_mapFromScene_c3960, &_call_f_mapFromScene_c3960);
  methods += new qt_gsi::GenericMethod ("mapRectFromItem", "@brief Method QRectF QGraphicsItem::mapRectFromItem(const QGraphicsItem *item, const QRectF &rect)\n", true, &_init_f_mapRectFromItem_c4368, &_call_f_mapRectFromItem_c4368);
  methods += new qt_gsi::GenericMethod ("mapRectFromItem", "@brief Method QRectF QGraphicsItem::mapRectFromItem(const QGraphicsItem *item, double x, double y, double w, double h)\n", true, &_init_f_mapRectFromItem_c6466, &_call_f_mapRectFromItem_c6466);
  methods += new qt_gsi::GenericMethod ("mapRectFromParent", "@brief Method QRectF QGraphicsItem::mapRectFromParent(const QRectF &rect)\n", true, &_init_f_mapRectFromParent_c1862, &_call_f_mapRectFromParent_c1862);
  methods += new qt_gsi::GenericMethod ("mapRectFromParent", "@brief Method QRectF QGraphicsItem::mapRectFromParent(double x, double y, double w, double h)\n", true, &_init_f_mapRectFromParent_c3960, &_call_f_mapRectFromParent_c3960);
  methods += new qt_gsi::GenericMethod ("mapRectFromScene", "@brief Method QRectF QGraphicsItem::mapRectFromScene(const QRectF &rect)\n", true, &_init_f_mapRectFromScene_c1862, &_call_f_mapRectFromScene_c1862);
  methods += new qt_gsi::GenericMethod ("mapRectFromScene", "@brief Method QRectF QGraphicsItem::mapRectFromScene(double x, double y, double w, double h)\n", true, &_init_f_mapRectFromScene_c3960, &_call_f_mapRectFromScene_c3960);
  methods += new qt_gsi::GenericMethod ("mapRectToItem", "@brief Method QRectF QGraphicsItem::mapRectToItem(const QGraphicsItem *item, const QRectF &rect)\n", true, &_init_f_mapRectToItem_c4368, &_call_f_mapRectToItem_c4368);
  methods += new qt_gsi::GenericMethod ("mapRectToItem", "@brief Method QRectF QGraphicsItem::mapRectToItem(const QGraphicsItem *item, double x, double y, double w, double h)\n", true, &_init_f_mapRectToItem_c6466, &_call_f_mapRectToItem_c6466);
  methods += new qt_gsi::GenericMethod ("mapRectToParent", "@brief Method QRectF QGraphicsItem::mapRectToParent(const QRectF &rect)\n", true, &_init_f_mapRectToParent_c1862, &_call_f_mapRectToParent_c1862);
  methods += new qt_gsi::GenericMethod ("mapRectToParent", "@brief Method QRectF QGraphicsItem::mapRectToParent(double x, double y, double w, double h)\n", true, &_init_f_mapRectToParent_c3960, &_call_f_mapRectToParent_c3960);
  methods += new qt_gsi::GenericMethod ("mapRectToScene", "@brief Method QRectF QGraphicsItem::mapRectToScene(const QRectF &rect)\n", true, &_init_f_mapRectToScene_c1862, &_call_f_mapRectToScene_c1862);
  methods += new qt_gsi::GenericMethod ("mapRectToScene", "@brief Method QRectF QGraphicsItem::mapRectToScene(double x, double y, double w, double h)\n", true, &_init_f_mapRectToScene_c3960, &_call_f_mapRectToScene_c3960);
  methods += new qt_gsi::GenericMethod ("mapToItem", "@brief Method QPointF QGraphicsItem::mapToItem(const QGraphicsItem *item, const QPointF &point)\n", true, &_init_f_mapToItem_c4492, &_call_f_mapToItem_c4492);
  methods += new qt_gsi::GenericMethod ("mapToItem", "@brief Method QPolygonF QGraphicsItem::mapToItem(const QGraphicsItem *item, const QRectF &rect)\n", true, &_init_f_mapToItem_c4368, &_call_f_mapToItem_c4368);
  methods += new qt_gsi::GenericMethod ("mapToItem", "@brief Method QPolygonF QGraphicsItem::mapToItem(const QGraphicsItem *item, const QPolygonF &polygon)\n", true, &_init_f_mapToItem_c4714, &_call_f_mapToItem_c4714);
  methods += new qt_gsi::GenericMethod ("mapToItem", "@brief Method QPainterPath QGraphicsItem::mapToItem(const QGraphicsItem *item, const QPainterPath &path)\n", true, &_init_f_mapToItem_c5020, &_call_f_mapToItem_c5020);
  methods += new qt_gsi::GenericMethod ("mapToItem", "@brief Method QPointF QGraphicsItem::mapToItem(const QGraphicsItem *item, double x, double y)\n", true, &_init_f_mapToItem_c4540, &_call_f_mapToItem_c4540);
  methods += new qt_gsi::GenericMethod ("mapToItem", "@brief Method QPolygonF QGraphicsItem::mapToItem(const QGraphicsItem *item, double x, double y, double w, double h)\n", true, &_init_f_mapToItem_c6466, &_call_f_mapToItem_c6466);
  methods += new qt_gsi::GenericMethod ("mapToParent", "@brief Method QPointF QGraphicsItem::mapToParent(const QPointF &point)\n", true, &_init_f_mapToParent_c1986, &_call_f_mapToParent_c1986);
  methods += new qt_gsi::GenericMethod ("mapToParent", "@brief Method QPolygonF QGraphicsItem::mapToParent(const QRectF &rect)\n", true, &_init_f_mapToParent_c1862, &_call_f_mapToParent_c1862);
  methods += new qt_gsi::GenericMethod ("mapToParent", "@brief Method QPolygonF QGraphicsItem::mapToParent(const QPolygonF &polygon)\n", true, &_init_f_mapToParent_c2208, &_call_f_mapToParent_c2208);
  methods += new qt_gsi::GenericMethod ("mapToParent", "@brief Method QPainterPath QGraphicsItem::mapToParent(const QPainterPath &path)\n", true, &_init_f_mapToParent_c2514, &_call_f_mapToParent_c2514);
  methods += new qt_gsi::GenericMethod ("mapToParent", "@brief Method QPointF QGraphicsItem::mapToParent(double x, double y)\n", true, &_init_f_mapToParent_c2034, &_call_f_mapToParent_c2034);
  methods += new qt_gsi::GenericMethod ("mapToParent", "@brief Method QPolygonF QGraphicsItem::mapToParent(double x, double y, double w, double h)\n", true, &_init_f_mapToParent_c3960, &_call_f_mapToParent_c3960);
  methods += new qt_gsi::GenericMethod ("mapToScene", "@brief Method QPointF QGraphicsItem::mapToScene(const QPointF &point)\n", true, &_init_f_mapToScene_c1986, &_call_f_mapToScene_c1986);
  methods += new qt_gsi::GenericMethod ("mapToScene", "@brief Method QPolygonF QGraphicsItem::mapToScene(const QRectF &rect)\n", true, &_init_f_mapToScene_c1862, &_call_f_mapToScene_c1862);
  methods += new qt_gsi::GenericMethod ("mapToScene", "@brief Method QPolygonF QGraphicsItem::mapToScene(const QPolygonF &polygon)\n", true, &_init_f_mapToScene_c2208, &_call_f_mapToScene_c2208);
  methods += new qt_gsi::GenericMethod ("mapToScene", "@brief Method QPainterPath QGraphicsItem::mapToScene(const QPainterPath &path)\n", true, &_init_f_mapToScene_c2514, &_call_f_mapToScene_c2514);
  methods += new qt_gsi::GenericMethod ("mapToScene", "@brief Method QPointF QGraphicsItem::mapToScene(double x, double y)\n", true, &_init_f_mapToScene_c2034, &_call_f_mapToScene_c2034);
  methods += new qt_gsi::GenericMethod ("mapToScene", "@brief Method QPolygonF QGraphicsItem::mapToScene(double x, double y, double w, double h)\n", true, &_init_f_mapToScene_c3960, &_call_f_mapToScene_c3960);
  methods += new qt_gsi::GenericMethod (":matrix", "@brief Method QMatrix QGraphicsItem::matrix()\n", true, &_init_f_matrix_c0, &_call_f_matrix_c0);
  methods += new qt_gsi::GenericMethod ("moveBy", "@brief Method void QGraphicsItem::moveBy(double dx, double dy)\n", false, &_init_f_moveBy_2034, &_call_f_moveBy_2034);
  methods += new qt_gsi::GenericMethod (":opacity", "@brief Method double QGraphicsItem::opacity()\n", true, &_init_f_opacity_c0, &_call_f_opacity_c0);
  methods += new qt_gsi::GenericMethod ("opaqueArea", "@brief Method QPainterPath QGraphicsItem::opaqueArea()\n", true, &_init_f_opaqueArea_c0, &_call_f_opaqueArea_c0);
  methods += new qt_gsi::GenericMethod ("paint", "@brief Method void QGraphicsItem::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)\n", false, &_init_f_paint_6301, &_call_f_paint_6301);
  methods += new qt_gsi::GenericMethod ("panel", "@brief Method QGraphicsItem *QGraphicsItem::panel()\n", true, &_init_f_panel_c0, &_call_f_panel_c0);
  methods += new qt_gsi::GenericMethod (":panelModality", "@brief Method QGraphicsItem::PanelModality QGraphicsItem::panelModality()\n", true, &_init_f_panelModality_c0, &_call_f_panelModality_c0);
  methods += new qt_gsi::GenericMethod (":parentItem", "@brief Method QGraphicsItem *QGraphicsItem::parentItem()\n", true, &_init_f_parentItem_c0, &_call_f_parentItem_c0);
  methods += new qt_gsi::GenericMethod ("parentObject", "@brief Method QGraphicsObject *QGraphicsItem::parentObject()\n", true, &_init_f_parentObject_c0, &_call_f_parentObject_c0);
  methods += new qt_gsi::GenericMethod ("parentWidget", "@brief Method QGraphicsWidget *QGraphicsItem::parentWidget()\n", true, &_init_f_parentWidget_c0, &_call_f_parentWidget_c0);
  methods += new qt_gsi::GenericMethod (":pos", "@brief Method QPointF QGraphicsItem::pos()\n", true, &_init_f_pos_c0, &_call_f_pos_c0);
  methods += new qt_gsi::GenericMethod ("removeSceneEventFilter", "@brief Method void QGraphicsItem::removeSceneEventFilter(QGraphicsItem *filterItem)\n", false, &_init_f_removeSceneEventFilter_1919, &_call_f_removeSceneEventFilter_1919);
  methods += new qt_gsi::GenericMethod ("resetMatrix", "@brief Method void QGraphicsItem::resetMatrix()\n", false, &_init_f_resetMatrix_0, &_call_f_resetMatrix_0);
  methods += new qt_gsi::GenericMethod ("resetTransform", "@brief Method void QGraphicsItem::resetTransform()\n", false, &_init_f_resetTransform_0, &_call_f_resetTransform_0);
  methods += new qt_gsi::GenericMethod ("rotate", "@brief Method void QGraphicsItem::rotate(double angle)\n", false, &_init_f_rotate_1071, &_call_f_rotate_1071);
  methods += new qt_gsi::GenericMethod (":rotation", "@brief Method double QGraphicsItem::rotation()\n", true, &_init_f_rotation_c0, &_call_f_rotation_c0);
  methods += new qt_gsi::GenericMethod ("scale", "@brief Method void QGraphicsItem::scale(double sx, double sy)\n", false, &_init_f_scale_2034, &_call_f_scale_2034);
  methods += new qt_gsi::GenericMethod (":scale", "@brief Method double QGraphicsItem::scale()\n", true, &_init_f_scale_c0, &_call_f_scale_c0);
  methods += new qt_gsi::GenericMethod ("scene", "@brief Method QGraphicsScene *QGraphicsItem::scene()\n", true, &_init_f_scene_c0, &_call_f_scene_c0);
  methods += new qt_gsi::GenericMethod ("sceneBoundingRect", "@brief Method QRectF QGraphicsItem::sceneBoundingRect()\n", true, &_init_f_sceneBoundingRect_c0, &_call_f_sceneBoundingRect_c0);
  methods += new qt_gsi::GenericMethod ("sceneMatrix", "@brief Method QMatrix QGraphicsItem::sceneMatrix()\n", true, &_init_f_sceneMatrix_c0, &_call_f_sceneMatrix_c0);
  methods += new qt_gsi::GenericMethod ("scenePos", "@brief Method QPointF QGraphicsItem::scenePos()\n", true, &_init_f_scenePos_c0, &_call_f_scenePos_c0);
  methods += new qt_gsi::GenericMethod ("sceneTransform", "@brief Method QTransform QGraphicsItem::sceneTransform()\n", true, &_init_f_sceneTransform_c0, &_call_f_sceneTransform_c0);
  methods += new qt_gsi::GenericMethod ("scroll", "@brief Method void QGraphicsItem::scroll(double dx, double dy, const QRectF &rect)\n", false, &_init_f_scroll_3788, &_call_f_scroll_3788);
  methods += new qt_gsi::GenericMethod ("setAcceptDrops|acceptDrops=", "@brief Method void QGraphicsItem::setAcceptDrops(bool on)\n", false, &_init_f_setAcceptDrops_864, &_call_f_setAcceptDrops_864);
  methods += new qt_gsi::GenericMethod ("setAcceptHoverEvents|acceptHoverEvents=", "@brief Method void QGraphicsItem::setAcceptHoverEvents(bool enabled)\n", false, &_init_f_setAcceptHoverEvents_864, &_call_f_setAcceptHoverEvents_864);
  methods += new qt_gsi::GenericMethod ("setAcceptTouchEvents|acceptTouchEvents=", "@brief Method void QGraphicsItem::setAcceptTouchEvents(bool enabled)\n", false, &_init_f_setAcceptTouchEvents_864, &_call_f_setAcceptTouchEvents_864);
  methods += new qt_gsi::GenericMethod ("setAcceptedMouseButtons|acceptedMouseButtons=", "@brief Method void QGraphicsItem::setAcceptedMouseButtons(QFlags<Qt::MouseButton> buttons)\n", false, &_init_f_setAcceptedMouseButtons_2602, &_call_f_setAcceptedMouseButtons_2602);
  methods += new qt_gsi::GenericMethod ("setAcceptsHoverEvents|acceptsHoverEvents=", "@brief Method void QGraphicsItem::setAcceptsHoverEvents(bool enabled)\n", false, &_init_f_setAcceptsHoverEvents_864, &_call_f_setAcceptsHoverEvents_864);
  methods += new qt_gsi::GenericMethod ("setActive|active=", "@brief Method void QGraphicsItem::setActive(bool active)\n", false, &_init_f_setActive_864, &_call_f_setActive_864);
  methods += new qt_gsi::GenericMethod ("setBoundingRegionGranularity|boundingRegionGranularity=", "@brief Method void QGraphicsItem::setBoundingRegionGranularity(double granularity)\n", false, &_init_f_setBoundingRegionGranularity_1071, &_call_f_setBoundingRegionGranularity_1071);
  methods += new qt_gsi::GenericMethod ("setCacheMode", "@brief Method void QGraphicsItem::setCacheMode(QGraphicsItem::CacheMode mode, const QSize &cacheSize)\n", false, &_init_f_setCacheMode_4403, &_call_f_setCacheMode_4403);
  methods += new qt_gsi::GenericMethod ("setCursor|cursor=", "@brief Method void QGraphicsItem::setCursor(const QCursor &cursor)\n", false, &_init_f_setCursor_2032, &_call_f_setCursor_2032);
  methods += new qt_gsi::GenericMethod ("setData", "@brief Method void QGraphicsItem::setData(int key, const QVariant &value)\n", false, &_init_f_setData_2778, &_call_f_setData_2778);
  methods += new qt_gsi::GenericMethod ("setEnabled|enabled=", "@brief Method void QGraphicsItem::setEnabled(bool enabled)\n", false, &_init_f_setEnabled_864, &_call_f_setEnabled_864);
  methods += new qt_gsi::GenericMethod ("setFiltersChildEvents|filtersChildEvents=", "@brief Method void QGraphicsItem::setFiltersChildEvents(bool enabled)\n", false, &_init_f_setFiltersChildEvents_864, &_call_f_setFiltersChildEvents_864);
  methods += new qt_gsi::GenericMethod ("setFlag", "@brief Method void QGraphicsItem::setFlag(QGraphicsItem::GraphicsItemFlag flag, bool enabled)\n", false, &_init_f_setFlag_4199, &_call_f_setFlag_4199);
  methods += new qt_gsi::GenericMethod ("setFlags|flags=", "@brief Method void QGraphicsItem::setFlags(QFlags<QGraphicsItem::GraphicsItemFlag> flags)\n", false, &_init_f_setFlags_4139, &_call_f_setFlags_4139);
  methods += new qt_gsi::GenericMethod ("setFocus", "@brief Method void QGraphicsItem::setFocus(Qt::FocusReason focusReason)\n", false, &_init_f_setFocus_1877, &_call_f_setFocus_1877);
  methods += new qt_gsi::GenericMethod ("setFocusProxy|focusProxy=", "@brief Method void QGraphicsItem::setFocusProxy(QGraphicsItem *item)\n", false, &_init_f_setFocusProxy_1919, &_call_f_setFocusProxy_1919);
  methods += new qt_gsi::GenericMethod ("setGraphicsEffect|graphicsEffect=", "@brief Method void QGraphicsItem::setGraphicsEffect(QGraphicsEffect *effect)\n", false, &_init_f_setGraphicsEffect_2109, &_call_f_setGraphicsEffect_2109);
  methods += new qt_gsi::GenericMethod ("setGroup|group=", "@brief Method void QGraphicsItem::setGroup(QGraphicsItemGroup *group)\n", false, &_init_f_setGroup_2444, &_call_f_setGroup_2444);
  methods += new qt_gsi::GenericMethod ("setHandlesChildEvents|handlesChildEvents=", "@brief Method void QGraphicsItem::setHandlesChildEvents(bool enabled)\n", false, &_init_f_setHandlesChildEvents_864, &_call_f_setHandlesChildEvents_864);
  methods += new qt_gsi::GenericMethod ("setInputMethodHints|inputMethodHints=", "@brief Method void QGraphicsItem::setInputMethodHints(QFlags<Qt::InputMethodHint> hints)\n", false, &_init_f_setInputMethodHints_2985, &_call_f_setInputMethodHints_2985);
  methods += new qt_gsi::GenericMethod ("setMatrix", "@brief Method void QGraphicsItem::setMatrix(const QMatrix &matrix, bool combine)\n", false, &_init_f_setMatrix_2779, &_call_f_setMatrix_2779);
  methods += new qt_gsi::GenericMethod ("setOpacity|opacity=", "@brief Method void QGraphicsItem::setOpacity(double opacity)\n", false, &_init_f_setOpacity_1071, &_call_f_setOpacity_1071);
  methods += new qt_gsi::GenericMethod ("setPanelModality|panelModality=", "@brief Method void QGraphicsItem::setPanelModality(QGraphicsItem::PanelModality panelModality)\n", false, &_init_f_setPanelModality_3180, &_call_f_setPanelModality_3180);
  methods += new qt_gsi::GenericMethod ("setParentItem|parentItem=", "@brief Method void QGraphicsItem::setParentItem(QGraphicsItem *parent)\n", false, &_init_f_setParentItem_1919, &_call_f_setParentItem_1919);
  methods += new qt_gsi::GenericMethod ("setPos|pos=", "@brief Method void QGraphicsItem::setPos(const QPointF &pos)\n", false, &_init_f_setPos_1986, &_call_f_setPos_1986);
  methods += new qt_gsi::GenericMethod ("setPos", "@brief Method void QGraphicsItem::setPos(double x, double y)\n", false, &_init_f_setPos_2034, &_call_f_setPos_2034);
  methods += new qt_gsi::GenericMethod ("setRotation|rotation=", "@brief Method void QGraphicsItem::setRotation(double angle)\n", false, &_init_f_setRotation_1071, &_call_f_setRotation_1071);
  methods += new qt_gsi::GenericMethod ("setScale|scale=", "@brief Method void QGraphicsItem::setScale(double scale)\n", false, &_init_f_setScale_1071, &_call_f_setScale_1071);
  methods += new qt_gsi::GenericMethod ("setSelected|selected=", "@brief Method void QGraphicsItem::setSelected(bool selected)\n", false, &_init_f_setSelected_864, &_call_f_setSelected_864);
  methods += new qt_gsi::GenericMethod ("setToolTip|toolTip=", "@brief Method void QGraphicsItem::setToolTip(const QString &toolTip)\n", false, &_init_f_setToolTip_2025, &_call_f_setToolTip_2025);
  methods += new qt_gsi::GenericMethod ("setTransform", "@brief Method void QGraphicsItem::setTransform(const QTransform &matrix, bool combine)\n", false, &_init_f_setTransform_3106, &_call_f_setTransform_3106);
  methods += new qt_gsi::GenericMethod ("setTransformOriginPoint|transformOriginPoint=", "@brief Method void QGraphicsItem::setTransformOriginPoint(const QPointF &origin)\n", false, &_init_f_setTransformOriginPoint_1986, &_call_f_setTransformOriginPoint_1986);
  methods += new qt_gsi::GenericMethod ("setTransformOriginPoint", "@brief Method void QGraphicsItem::setTransformOriginPoint(double ax, double ay)\n", false, &_init_f_setTransformOriginPoint_2034, &_call_f_setTransformOriginPoint_2034);
  methods += new qt_gsi::GenericMethod ("setTransformations|transformations=", "@brief Method void QGraphicsItem::setTransformations(const QList<QGraphicsTransform *> &transformations)\n", false, &_init_f_setTransformations_3968, &_call_f_setTransformations_3968);
  methods += new qt_gsi::GenericMethod ("setVisible|visible=", "@brief Method void QGraphicsItem::setVisible(bool visible)\n", false, &_init_f_setVisible_864, &_call_f_setVisible_864);
  methods += new qt_gsi::GenericMethod ("setX|x=", "@brief Method void QGraphicsItem::setX(double x)\n", false, &_init_f_setX_1071, &_call_f_setX_1071);
  methods += new qt_gsi::GenericMethod ("setY|y=", "@brief Method void QGraphicsItem::setY(double y)\n", false, &_init_f_setY_1071, &_call_f_setY_1071);
  methods += new qt_gsi::GenericMethod ("setZValue|zValue=", "@brief Method void QGraphicsItem::setZValue(double z)\n", false, &_init_f_setZValue_1071, &_call_f_setZValue_1071);
  methods += new qt_gsi::GenericMethod ("shape", "@brief Method QPainterPath QGraphicsItem::shape()\n", true, &_init_f_shape_c0, &_call_f_shape_c0);
  methods += new qt_gsi::GenericMethod ("shear", "@brief Method void QGraphicsItem::shear(double sh, double sv)\n", false, &_init_f_shear_2034, &_call_f_shear_2034);
  methods += new qt_gsi::GenericMethod ("show", "@brief Method void QGraphicsItem::show()\n", false, &_init_f_show_0, &_call_f_show_0);
  methods += new qt_gsi::GenericMethod ("stackBefore", "@brief Method void QGraphicsItem::stackBefore(const QGraphicsItem *sibling)\n", false, &_init_f_stackBefore_2614, &_call_f_stackBefore_2614);
  methods += new qt_gsi::GenericMethod ("toGraphicsObject", "@brief Method QGraphicsObject *QGraphicsItem::toGraphicsObject()\n", false, &_init_f_toGraphicsObject_0, &_call_f_toGraphicsObject_0);
  methods += new qt_gsi::GenericMethod ("toGraphicsObject", "@brief Method const QGraphicsObject *QGraphicsItem::toGraphicsObject()\n", true, &_init_f_toGraphicsObject_c0, &_call_f_toGraphicsObject_c0);
  methods += new qt_gsi::GenericMethod (":toolTip", "@brief Method QString QGraphicsItem::toolTip()\n", true, &_init_f_toolTip_c0, &_call_f_toolTip_c0);
  methods += new qt_gsi::GenericMethod ("topLevelItem", "@brief Method QGraphicsItem *QGraphicsItem::topLevelItem()\n", true, &_init_f_topLevelItem_c0, &_call_f_topLevelItem_c0);
  methods += new qt_gsi::GenericMethod ("topLevelWidget", "@brief Method QGraphicsWidget *QGraphicsItem::topLevelWidget()\n", true, &_init_f_topLevelWidget_c0, &_call_f_topLevelWidget_c0);
  methods += new qt_gsi::GenericMethod (":transform", "@brief Method QTransform QGraphicsItem::transform()\n", true, &_init_f_transform_c0, &_call_f_transform_c0);
  methods += new qt_gsi::GenericMethod (":transformOriginPoint", "@brief Method QPointF QGraphicsItem::transformOriginPoint()\n", true, &_init_f_transformOriginPoint_c0, &_call_f_transformOriginPoint_c0);
  methods += new qt_gsi::GenericMethod (":transformations", "@brief Method QList<QGraphicsTransform *> QGraphicsItem::transformations()\n", true, &_init_f_transformations_c0, &_call_f_transformations_c0);
  methods += new qt_gsi::GenericMethod ("translate", "@brief Method void QGraphicsItem::translate(double dx, double dy)\n", false, &_init_f_translate_2034, &_call_f_translate_2034);
  methods += new qt_gsi::GenericMethod ("type", "@brief Method int QGraphicsItem::type()\n", true, &_init_f_type_c0, &_call_f_type_c0);
  methods += new qt_gsi::GenericMethod ("ungrabKeyboard", "@brief Method void QGraphicsItem::ungrabKeyboard()\n", false, &_init_f_ungrabKeyboard_0, &_call_f_ungrabKeyboard_0);
  methods += new qt_gsi::GenericMethod ("ungrabMouse", "@brief Method void QGraphicsItem::ungrabMouse()\n", false, &_init_f_ungrabMouse_0, &_call_f_ungrabMouse_0);
  methods += new qt_gsi::GenericMethod ("unsetCursor", "@brief Method void QGraphicsItem::unsetCursor()\n", false, &_init_f_unsetCursor_0, &_call_f_unsetCursor_0);
  methods += new qt_gsi::GenericMethod ("update", "@brief Method void QGraphicsItem::update(const QRectF &rect)\n", false, &_init_f_update_1862, &_call_f_update_1862);
  methods += new qt_gsi::GenericMethod ("update", "@brief Method void QGraphicsItem::update(double x, double y, double width, double height)\n", false, &_init_f_update_3960, &_call_f_update_3960);
  methods += new qt_gsi::GenericMethod ("window", "@brief Method QGraphicsWidget *QGraphicsItem::window()\n", true, &_init_f_window_c0, &_call_f_window_c0);
  methods += new qt_gsi::GenericMethod (":x", "@brief Method double QGraphicsItem::x()\n", true, &_init_f_x_c0, &_call_f_x_c0);
  methods += new qt_gsi::GenericMethod (":y", "@brief Method double QGraphicsItem::y()\n", true, &_init_f_y_c0, &_call_f_y_c0);
  methods += new qt_gsi::GenericMethod (":zValue", "@brief Method double QGraphicsItem::zValue()\n", true, &_init_f_zValue_c0, &_call_f_zValue_c0);
  return methods;
}

gsi::Class<QGraphicsItem> decl_QGraphicsItem ("QtGui", "QGraphicsItem_Native",
  methods_QGraphicsItem (),
  "@hide\n@alias QGraphicsItem");

GSI_QTGUI_PUBLIC gsi::Class<QGraphicsItem> &qtdecl_QGraphicsItem () { return decl_QGraphicsItem; }

}


class QGraphicsItem_Adaptor : public QGraphicsItem, public qt_gsi::QtObjectBase
{
public:

  virtual ~QGraphicsItem_Adaptor();

  //  [adaptor ctor] QGraphicsItem::QGraphicsItem(QGraphicsItem *parent, QGraphicsScene *scene)
  QGraphicsItem_Adaptor() : QGraphicsItem()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsItem::QGraphicsItem(QGraphicsItem *parent, QGraphicsScene *scene)
  QGraphicsItem_Adaptor(QGraphicsItem *parent) : QGraphicsItem(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsItem::QGraphicsItem(QGraphicsItem *parent, QGraphicsScene *scene)
  QGraphicsItem_Adaptor(QGraphicsItem *parent, QGraphicsScene *scene) : QGraphicsItem(parent, scene)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QGraphicsItem::addToIndex()
  void fp_QGraphicsItem_addToIndex_0 () {
    QGraphicsItem::addToIndex();
  }

  //  [expose] void QGraphicsItem::prepareGeometryChange()
  void fp_QGraphicsItem_prepareGeometryChange_0 () {
    QGraphicsItem::prepareGeometryChange();
  }

  //  [expose] void QGraphicsItem::removeFromIndex()
  void fp_QGraphicsItem_removeFromIndex_0 () {
    QGraphicsItem::removeFromIndex();
  }

  //  [adaptor impl] void QGraphicsItem::advance(int phase)
  void cbs_advance_767_0(int phase)
  {
    QGraphicsItem::advance(phase);
  }

  virtual void advance(int phase)
  {
    if (cb_advance_767_0.can_issue()) {
      cb_advance_767_0.issue<QGraphicsItem_Adaptor, int>(&QGraphicsItem_Adaptor::cbs_advance_767_0, phase);
    } else {
      QGraphicsItem::advance(phase);
    }
  }

  //  [adaptor impl] QRectF QGraphicsItem::boundingRect()
  QRectF cbs_boundingRect_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("boundingRect");
  }

  virtual QRectF boundingRect() const
  {
    if (cb_boundingRect_c0_0.can_issue()) {
      return cb_boundingRect_c0_0.issue<QGraphicsItem_Adaptor, QRectF>(&QGraphicsItem_Adaptor::cbs_boundingRect_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("boundingRect");
    }
  }

  //  [adaptor impl] bool QGraphicsItem::collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode)
  bool cbs_collidesWithItem_c4977_1(const QGraphicsItem *other, const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & mode) const
  {
    return QGraphicsItem::collidesWithItem(other, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(mode).cref());
  }

  virtual bool collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode) const
  {
    if (cb_collidesWithItem_c4977_1.can_issue()) {
      return cb_collidesWithItem_c4977_1.issue<QGraphicsItem_Adaptor, bool, const QGraphicsItem *, const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type &>(&QGraphicsItem_Adaptor::cbs_collidesWithItem_c4977_1, other, qt_gsi::CppToQtAdaptor<Qt::ItemSelectionMode>(mode));
    } else {
      return QGraphicsItem::collidesWithItem(other, mode);
    }
  }

  //  [adaptor impl] bool QGraphicsItem::collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode)
  bool cbs_collidesWithPath_c4877_1(const QPainterPath &path, const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & mode) const
  {
    return QGraphicsItem::collidesWithPath(path, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(mode).cref());
  }

  virtual bool collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode) const
  {
    if (cb_collidesWithPath_c4877_1.can_issue()) {
      return cb_collidesWithPath_c4877_1.issue<QGraphicsItem_Adaptor, bool, const QPainterPath &, const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type &>(&QGraphicsItem_Adaptor::cbs_collidesWithPath_c4877_1, path, qt_gsi::CppToQtAdaptor<Qt::ItemSelectionMode>(mode));
    } else {
      return QGraphicsItem::collidesWithPath(path, mode);
    }
  }

  //  [adaptor impl] bool QGraphicsItem::contains(const QPointF &point)
  bool cbs_contains_c1986_0(const QPointF &point) const
  {
    return QGraphicsItem::contains(point);
  }

  virtual bool contains(const QPointF &point) const
  {
    if (cb_contains_c1986_0.can_issue()) {
      return cb_contains_c1986_0.issue<QGraphicsItem_Adaptor, bool, const QPointF &>(&QGraphicsItem_Adaptor::cbs_contains_c1986_0, point);
    } else {
      return QGraphicsItem::contains(point);
    }
  }

  //  [adaptor impl] bool QGraphicsItem::isObscuredBy(const QGraphicsItem *item)
  bool cbs_isObscuredBy_c2614_0(const QGraphicsItem *item) const
  {
    return QGraphicsItem::isObscuredBy(item);
  }

  virtual bool isObscuredBy(const QGraphicsItem *item) const
  {
    if (cb_isObscuredBy_c2614_0.can_issue()) {
      return cb_isObscuredBy_c2614_0.issue<QGraphicsItem_Adaptor, bool, const QGraphicsItem *>(&QGraphicsItem_Adaptor::cbs_isObscuredBy_c2614_0, item);
    } else {
      return QGraphicsItem::isObscuredBy(item);
    }
  }

  //  [adaptor impl] QPainterPath QGraphicsItem::opaqueArea()
  QPainterPath cbs_opaqueArea_c0_0() const
  {
    return QGraphicsItem::opaqueArea();
  }

  virtual QPainterPath opaqueArea() const
  {
    if (cb_opaqueArea_c0_0.can_issue()) {
      return cb_opaqueArea_c0_0.issue<QGraphicsItem_Adaptor, QPainterPath>(&QGraphicsItem_Adaptor::cbs_opaqueArea_c0_0);
    } else {
      return QGraphicsItem::opaqueArea();
    }
  }

  //  [adaptor impl] void QGraphicsItem::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
  void cbs_paint_6301_1(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
  {
    __SUPPRESS_UNUSED_WARNING (painter);
    __SUPPRESS_UNUSED_WARNING (option);
    __SUPPRESS_UNUSED_WARNING (widget);
    throw qt_gsi::AbstractMethodCalledException("paint");
  }

  virtual void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
  {
    if (cb_paint_6301_1.can_issue()) {
      cb_paint_6301_1.issue<QGraphicsItem_Adaptor, QPainter *, const QStyleOptionGraphicsItem *, QWidget *>(&QGraphicsItem_Adaptor::cbs_paint_6301_1, painter, option, widget);
    } else {
      throw qt_gsi::AbstractMethodCalledException("paint");
    }
  }

  //  [adaptor impl] QPainterPath QGraphicsItem::shape()
  QPainterPath cbs_shape_c0_0() const
  {
    return QGraphicsItem::shape();
  }

  virtual QPainterPath shape() const
  {
    if (cb_shape_c0_0.can_issue()) {
      return cb_shape_c0_0.issue<QGraphicsItem_Adaptor, QPainterPath>(&QGraphicsItem_Adaptor::cbs_shape_c0_0);
    } else {
      return QGraphicsItem::shape();
    }
  }

  //  [adaptor impl] int QGraphicsItem::type()
  int cbs_type_c0_0() const
  {
    return QGraphicsItem::type();
  }

  virtual int type() const
  {
    if (cb_type_c0_0.can_issue()) {
      return cb_type_c0_0.issue<QGraphicsItem_Adaptor, int>(&QGraphicsItem_Adaptor::cbs_type_c0_0);
    } else {
      return QGraphicsItem::type();
    }
  }

  //  [adaptor impl] void QGraphicsItem::contextMenuEvent(QGraphicsSceneContextMenuEvent *event)
  void cbs_contextMenuEvent_3674_0(QGraphicsSceneContextMenuEvent *event)
  {
    QGraphicsItem::contextMenuEvent(event);
  }

  virtual void contextMenuEvent(QGraphicsSceneContextMenuEvent *event)
  {
    if (cb_contextMenuEvent_3674_0.can_issue()) {
      cb_contextMenuEvent_3674_0.issue<QGraphicsItem_Adaptor, QGraphicsSceneContextMenuEvent *>(&QGraphicsItem_Adaptor::cbs_contextMenuEvent_3674_0, event);
    } else {
      QGraphicsItem::contextMenuEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsItem::dragEnterEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dragEnterEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsItem::dragEnterEvent(event);
  }

  virtual void dragEnterEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dragEnterEvent_3315_0.can_issue()) {
      cb_dragEnterEvent_3315_0.issue<QGraphicsItem_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsItem_Adaptor::cbs_dragEnterEvent_3315_0, event);
    } else {
      QGraphicsItem::dragEnterEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsItem::dragLeaveEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dragLeaveEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsItem::dragLeaveEvent(event);
  }

  virtual void dragLeaveEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dragLeaveEvent_3315_0.can_issue()) {
      cb_dragLeaveEvent_3315_0.issue<QGraphicsItem_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsItem_Adaptor::cbs_dragLeaveEvent_3315_0, event);
    } else {
      QGraphicsItem::dragLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsItem::dragMoveEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dragMoveEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsItem::dragMoveEvent(event);
  }

  virtual void dragMoveEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dragMoveEvent_3315_0.can_issue()) {
      cb_dragMoveEvent_3315_0.issue<QGraphicsItem_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsItem_Adaptor::cbs_dragMoveEvent_3315_0, event);
    } else {
      QGraphicsItem::dragMoveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsItem::dropEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dropEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsItem::dropEvent(event);
  }

  virtual void dropEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dropEvent_3315_0.can_issue()) {
      cb_dropEvent_3315_0.issue<QGraphicsItem_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsItem_Adaptor::cbs_dropEvent_3315_0, event);
    } else {
      QGraphicsItem::dropEvent(event);
    }
  }

  //  [adaptor impl] QVariant QGraphicsItem::extension(const QVariant &variant)
  QVariant cbs_extension_c2119_0(const QVariant &variant) const
  {
    return QGraphicsItem::extension(variant);
  }

  virtual QVariant extension(const QVariant &variant) const
  {
    if (cb_extension_c2119_0.can_issue()) {
      return cb_extension_c2119_0.issue<QGraphicsItem_Adaptor, QVariant, const QVariant &>(&QGraphicsItem_Adaptor::cbs_extension_c2119_0, variant);
    } else {
      return QGraphicsItem::extension(variant);
    }
  }

  //  [adaptor impl] void QGraphicsItem::focusInEvent(QFocusEvent *event)
  void cbs_focusInEvent_1729_0(QFocusEvent *event)
  {
    QGraphicsItem::focusInEvent(event);
  }

  virtual void focusInEvent(QFocusEvent *event)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QGraphicsItem_Adaptor, QFocusEvent *>(&QGraphicsItem_Adaptor::cbs_focusInEvent_1729_0, event);
    } else {
      QGraphicsItem::focusInEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsItem::focusOutEvent(QFocusEvent *event)
  void cbs_focusOutEvent_1729_0(QFocusEvent *event)
  {
    QGraphicsItem::focusOutEvent(event);
  }

  virtual void focusOutEvent(QFocusEvent *event)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QGraphicsItem_Adaptor, QFocusEvent *>(&QGraphicsItem_Adaptor::cbs_focusOutEvent_1729_0, event);
    } else {
      QGraphicsItem::focusOutEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsItem::hoverEnterEvent(QGraphicsSceneHoverEvent *event)
  void cbs_hoverEnterEvent_3044_0(QGraphicsSceneHoverEvent *event)
  {
    QGraphicsItem::hoverEnterEvent(event);
  }

  virtual void hoverEnterEvent(QGraphicsSceneHoverEvent *event)
  {
    if (cb_hoverEnterEvent_3044_0.can_issue()) {
      cb_hoverEnterEvent_3044_0.issue<QGraphicsItem_Adaptor, QGraphicsSceneHoverEvent *>(&QGraphicsItem_Adaptor::cbs_hoverEnterEvent_3044_0, event);
    } else {
      QGraphicsItem::hoverEnterEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsItem::hoverLeaveEvent(QGraphicsSceneHoverEvent *event)
  void cbs_hoverLeaveEvent_3044_0(QGraphicsSceneHoverEvent *event)
  {
    QGraphicsItem::hoverLeaveEvent(event);
  }

  virtual void hoverLeaveEvent(QGraphicsSceneHoverEvent *event)
  {
    if (cb_hoverLeaveEvent_3044_0.can_issue()) {
      cb_hoverLeaveEvent_3044_0.issue<QGraphicsItem_Adaptor, QGraphicsSceneHoverEvent *>(&QGraphicsItem_Adaptor::cbs_hoverLeaveEvent_3044_0, event);
    } else {
      QGraphicsItem::hoverLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsItem::hoverMoveEvent(QGraphicsSceneHoverEvent *event)
  void cbs_hoverMoveEvent_3044_0(QGraphicsSceneHoverEvent *event)
  {
    QGraphicsItem::hoverMoveEvent(event);
  }

  virtual void hoverMoveEvent(QGraphicsSceneHoverEvent *event)
  {
    if (cb_hoverMoveEvent_3044_0.can_issue()) {
      cb_hoverMoveEvent_3044_0.issue<QGraphicsItem_Adaptor, QGraphicsSceneHoverEvent *>(&QGraphicsItem_Adaptor::cbs_hoverMoveEvent_3044_0, event);
    } else {
      QGraphicsItem::hoverMoveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsItem::inputMethodEvent(QInputMethodEvent *event)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *event)
  {
    QGraphicsItem::inputMethodEvent(event);
  }

  virtual void inputMethodEvent(QInputMethodEvent *event)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QGraphicsItem_Adaptor, QInputMethodEvent *>(&QGraphicsItem_Adaptor::cbs_inputMethodEvent_2354_0, event);
    } else {
      QGraphicsItem::inputMethodEvent(event);
    }
  }

  //  [adaptor impl] QVariant QGraphicsItem::inputMethodQuery(Qt::InputMethodQuery query)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & query) const
  {
    return QGraphicsItem::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(query).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery query) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QGraphicsItem_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QGraphicsItem_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(query));
    } else {
      return QGraphicsItem::inputMethodQuery(query);
    }
  }

  //  [adaptor impl] QVariant QGraphicsItem::itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant &value)
  QVariant cbs_itemChange_5658_0(const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type & change, const QVariant &value)
  {
    return QGraphicsItem::itemChange(qt_gsi::QtToCppAdaptor<QGraphicsItem::GraphicsItemChange>(change).cref(), value);
  }

  virtual QVariant itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant &value)
  {
    if (cb_itemChange_5658_0.can_issue()) {
      return cb_itemChange_5658_0.issue<QGraphicsItem_Adaptor, QVariant, const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type &, const QVariant &>(&QGraphicsItem_Adaptor::cbs_itemChange_5658_0, qt_gsi::CppToQtAdaptor<QGraphicsItem::GraphicsItemChange>(change), value);
    } else {
      return QGraphicsItem::itemChange(change, value);
    }
  }

  //  [adaptor impl] void QGraphicsItem::keyPressEvent(QKeyEvent *event)
  void cbs_keyPressEvent_1514_0(QKeyEvent *event)
  {
    QGraphicsItem::keyPressEvent(event);
  }

  virtual void keyPressEvent(QKeyEvent *event)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QGraphicsItem_Adaptor, QKeyEvent *>(&QGraphicsItem_Adaptor::cbs_keyPressEvent_1514_0, event);
    } else {
      QGraphicsItem::keyPressEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsItem::keyReleaseEvent(QKeyEvent *event)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *event)
  {
    QGraphicsItem::keyReleaseEvent(event);
  }

  virtual void keyReleaseEvent(QKeyEvent *event)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QGraphicsItem_Adaptor, QKeyEvent *>(&QGraphicsItem_Adaptor::cbs_keyReleaseEvent_1514_0, event);
    } else {
      QGraphicsItem::keyReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsItem::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mouseDoubleClickEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsItem::mouseDoubleClickEvent(event);
  }

  virtual void mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mouseDoubleClickEvent_3049_0.can_issue()) {
      cb_mouseDoubleClickEvent_3049_0.issue<QGraphicsItem_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsItem_Adaptor::cbs_mouseDoubleClickEvent_3049_0, event);
    } else {
      QGraphicsItem::mouseDoubleClickEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsItem::mouseMoveEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mouseMoveEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsItem::mouseMoveEvent(event);
  }

  virtual void mouseMoveEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mouseMoveEvent_3049_0.can_issue()) {
      cb_mouseMoveEvent_3049_0.issue<QGraphicsItem_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsItem_Adaptor::cbs_mouseMoveEvent_3049_0, event);
    } else {
      QGraphicsItem::mouseMoveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsItem::mousePressEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mousePressEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsItem::mousePressEvent(event);
  }

  virtual void mousePressEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mousePressEvent_3049_0.can_issue()) {
      cb_mousePressEvent_3049_0.issue<QGraphicsItem_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsItem_Adaptor::cbs_mousePressEvent_3049_0, event);
    } else {
      QGraphicsItem::mousePressEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsItem::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mouseReleaseEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsItem::mouseReleaseEvent(event);
  }

  virtual void mouseReleaseEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mouseReleaseEvent_3049_0.can_issue()) {
      cb_mouseReleaseEvent_3049_0.issue<QGraphicsItem_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsItem_Adaptor::cbs_mouseReleaseEvent_3049_0, event);
    } else {
      QGraphicsItem::mouseReleaseEvent(event);
    }
  }

  //  [adaptor impl] bool QGraphicsItem::sceneEvent(QEvent *event)
  bool cbs_sceneEvent_1217_0(QEvent *event)
  {
    return QGraphicsItem::sceneEvent(event);
  }

  virtual bool sceneEvent(QEvent *event)
  {
    if (cb_sceneEvent_1217_0.can_issue()) {
      return cb_sceneEvent_1217_0.issue<QGraphicsItem_Adaptor, bool, QEvent *>(&QGraphicsItem_Adaptor::cbs_sceneEvent_1217_0, event);
    } else {
      return QGraphicsItem::sceneEvent(event);
    }
  }

  //  [adaptor impl] bool QGraphicsItem::sceneEventFilter(QGraphicsItem *watched, QEvent *event)
  bool cbs_sceneEventFilter_3028_0(QGraphicsItem *watched, QEvent *event)
  {
    return QGraphicsItem::sceneEventFilter(watched, event);
  }

  virtual bool sceneEventFilter(QGraphicsItem *watched, QEvent *event)
  {
    if (cb_sceneEventFilter_3028_0.can_issue()) {
      return cb_sceneEventFilter_3028_0.issue<QGraphicsItem_Adaptor, bool, QGraphicsItem *, QEvent *>(&QGraphicsItem_Adaptor::cbs_sceneEventFilter_3028_0, watched, event);
    } else {
      return QGraphicsItem::sceneEventFilter(watched, event);
    }
  }

  //  [adaptor impl] void QGraphicsItem::setExtension(QGraphicsItem::Extension extension, const QVariant &variant)
  void cbs_setExtension_4817_0(unsigned int extension, const QVariant &variant)
  {
    QGraphicsItem::setExtension(QGraphicsItem::Extension(extension), variant);
  }

  virtual void setExtension(QGraphicsItem::Extension extension, const QVariant &variant)
  {
    if (cb_setExtension_4817_0.can_issue()) {
      cb_setExtension_4817_0.issue<QGraphicsItem_Adaptor, unsigned int, const QVariant &>(&QGraphicsItem_Adaptor::cbs_setExtension_4817_0, (unsigned int)(extension), variant);
    } else {
      QGraphicsItem::setExtension(extension, variant);
    }
  }

  //  [adaptor impl] bool QGraphicsItem::supportsExtension(QGraphicsItem::Extension extension)
  bool cbs_supportsExtension_c2806_0(unsigned int extension) const
  {
    return QGraphicsItem::supportsExtension(QGraphicsItem::Extension(extension));
  }

  virtual bool supportsExtension(QGraphicsItem::Extension extension) const
  {
    if (cb_supportsExtension_c2806_0.can_issue()) {
      return cb_supportsExtension_c2806_0.issue<QGraphicsItem_Adaptor, bool, unsigned int>(&QGraphicsItem_Adaptor::cbs_supportsExtension_c2806_0, (unsigned int)(extension));
    } else {
      return QGraphicsItem::supportsExtension(extension);
    }
  }

  //  [adaptor impl] void QGraphicsItem::wheelEvent(QGraphicsSceneWheelEvent *event)
  void cbs_wheelEvent_3029_0(QGraphicsSceneWheelEvent *event)
  {
    QGraphicsItem::wheelEvent(event);
  }

  virtual void wheelEvent(QGraphicsSceneWheelEvent *event)
  {
    if (cb_wheelEvent_3029_0.can_issue()) {
      cb_wheelEvent_3029_0.issue<QGraphicsItem_Adaptor, QGraphicsSceneWheelEvent *>(&QGraphicsItem_Adaptor::cbs_wheelEvent_3029_0, event);
    } else {
      QGraphicsItem::wheelEvent(event);
    }
  }

  gsi::Callback cb_advance_767_0;
  gsi::Callback cb_boundingRect_c0_0;
  gsi::Callback cb_collidesWithItem_c4977_1;
  gsi::Callback cb_collidesWithPath_c4877_1;
  gsi::Callback cb_contains_c1986_0;
  gsi::Callback cb_isObscuredBy_c2614_0;
  gsi::Callback cb_opaqueArea_c0_0;
  gsi::Callback cb_paint_6301_1;
  gsi::Callback cb_shape_c0_0;
  gsi::Callback cb_type_c0_0;
  gsi::Callback cb_contextMenuEvent_3674_0;
  gsi::Callback cb_dragEnterEvent_3315_0;
  gsi::Callback cb_dragLeaveEvent_3315_0;
  gsi::Callback cb_dragMoveEvent_3315_0;
  gsi::Callback cb_dropEvent_3315_0;
  gsi::Callback cb_extension_c2119_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_hoverEnterEvent_3044_0;
  gsi::Callback cb_hoverLeaveEvent_3044_0;
  gsi::Callback cb_hoverMoveEvent_3044_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_itemChange_5658_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_mouseDoubleClickEvent_3049_0;
  gsi::Callback cb_mouseMoveEvent_3049_0;
  gsi::Callback cb_mousePressEvent_3049_0;
  gsi::Callback cb_mouseReleaseEvent_3049_0;
  gsi::Callback cb_sceneEvent_1217_0;
  gsi::Callback cb_sceneEventFilter_3028_0;
  gsi::Callback cb_setExtension_4817_0;
  gsi::Callback cb_supportsExtension_c2806_0;
  gsi::Callback cb_wheelEvent_3029_0;
};

QGraphicsItem_Adaptor::~QGraphicsItem_Adaptor() { }

//  Constructor QGraphicsItem::QGraphicsItem(QGraphicsItem *parent, QGraphicsScene *scene) (adaptor class)

static void _init_ctor_QGraphicsItem_Adaptor_3825 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("scene", true, "0");
  decl->add_arg<QGraphicsScene * > (argspec_1);
  decl->set_return_new<QGraphicsItem_Adaptor> ();
}

static void _call_ctor_QGraphicsItem_Adaptor_3825 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsItem *arg1 = args ? gsi::arg_reader<QGraphicsItem * >() (args, heap) : gsi::arg_maker<QGraphicsItem * >() (0, heap);
  QGraphicsScene *arg2 = args ? gsi::arg_reader<QGraphicsScene * >() (args, heap) : gsi::arg_maker<QGraphicsScene * >() (0, heap);
  ret.write<QGraphicsItem_Adaptor *> (new QGraphicsItem_Adaptor (arg1, arg2));
}


// exposed void QGraphicsItem::addToIndex()

static void _init_fp_addToIndex_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_addToIndex_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem_Adaptor *)cls)->fp_QGraphicsItem_addToIndex_0 ();
}


// void QGraphicsItem::advance(int phase)

static void _init_cbs_advance_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("phase");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_advance_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem_Adaptor *)cls)->cbs_advance_767_0 (arg1);
}

static void _set_callback_cbs_advance_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_advance_767_0 = cb;
}


// QRectF QGraphicsItem::boundingRect()

static void _init_cbs_boundingRect_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_cbs_boundingRect_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRectF > ((QRectF)((QGraphicsItem_Adaptor *)cls)->cbs_boundingRect_c0_0 ());
}

static void _set_callback_cbs_boundingRect_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_boundingRect_c0_0 = cb;
}


// bool QGraphicsItem::collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode)

static void _init_cbs_collidesWithItem_c4977_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_collidesWithItem_c4977_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > (heap);
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (heap);
  ret.write<bool > ((bool)((QGraphicsItem_Adaptor *)cls)->cbs_collidesWithItem_c4977_1 (arg1, arg2));
}

static void _set_callback_cbs_collidesWithItem_c4977_1 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_collidesWithItem_c4977_1 = cb;
}


// bool QGraphicsItem::collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode)

static void _init_cbs_collidesWithPath_c4877_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_collidesWithPath_c4877_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPainterPath &arg1 = args.read<const QPainterPath & > (heap);
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (heap);
  ret.write<bool > ((bool)((QGraphicsItem_Adaptor *)cls)->cbs_collidesWithPath_c4877_1 (arg1, arg2));
}

static void _set_callback_cbs_collidesWithPath_c4877_1 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_collidesWithPath_c4877_1 = cb;
}


// bool QGraphicsItem::contains(const QPointF &point)

static void _init_cbs_contains_c1986_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_contains_c1986_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = args.read<const QPointF & > (heap);
  ret.write<bool > ((bool)((QGraphicsItem_Adaptor *)cls)->cbs_contains_c1986_0 (arg1));
}

static void _set_callback_cbs_contains_c1986_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_contains_c1986_0 = cb;
}


// void QGraphicsItem::contextMenuEvent(QGraphicsSceneContextMenuEvent *event)

static void _init_cbs_contextMenuEvent_3674_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_3674_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneContextMenuEvent *arg1 = args.read<QGraphicsSceneContextMenuEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem_Adaptor *)cls)->cbs_contextMenuEvent_3674_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_3674_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_contextMenuEvent_3674_0 = cb;
}


// void QGraphicsItem::dragEnterEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dragEnterEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_3315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem_Adaptor *)cls)->cbs_dragEnterEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_dragEnterEvent_3315_0 = cb;
}


// void QGraphicsItem::dragLeaveEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dragLeaveEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_3315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem_Adaptor *)cls)->cbs_dragLeaveEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_dragLeaveEvent_3315_0 = cb;
}


// void QGraphicsItem::dragMoveEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dragMoveEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_3315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem_Adaptor *)cls)->cbs_dragMoveEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_dragMoveEvent_3315_0 = cb;
}


// void QGraphicsItem::dropEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dropEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_3315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem_Adaptor *)cls)->cbs_dropEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dropEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_dropEvent_3315_0 = cb;
}


// QVariant QGraphicsItem::extension(const QVariant &variant)

static void _init_cbs_extension_c2119_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("variant");
  decl->add_arg<const QVariant & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_extension_c2119_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVariant &arg1 = args.read<const QVariant & > (heap);
  ret.write<QVariant > ((QVariant)((QGraphicsItem_Adaptor *)cls)->cbs_extension_c2119_0 (arg1));
}

static void _set_callback_cbs_extension_c2119_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_extension_c2119_0 = cb;
}


// void QGraphicsItem::focusInEvent(QFocusEvent *event)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// void QGraphicsItem::focusOutEvent(QFocusEvent *event)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// void QGraphicsItem::hoverEnterEvent(QGraphicsSceneHoverEvent *event)

static void _init_cbs_hoverEnterEvent_3044_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneHoverEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hoverEnterEvent_3044_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneHoverEvent *arg1 = args.read<QGraphicsSceneHoverEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem_Adaptor *)cls)->cbs_hoverEnterEvent_3044_0 (arg1);
}

static void _set_callback_cbs_hoverEnterEvent_3044_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_hoverEnterEvent_3044_0 = cb;
}


// void QGraphicsItem::hoverLeaveEvent(QGraphicsSceneHoverEvent *event)

static void _init_cbs_hoverLeaveEvent_3044_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneHoverEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hoverLeaveEvent_3044_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneHoverEvent *arg1 = args.read<QGraphicsSceneHoverEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem_Adaptor *)cls)->cbs_hoverLeaveEvent_3044_0 (arg1);
}

static void _set_callback_cbs_hoverLeaveEvent_3044_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_hoverLeaveEvent_3044_0 = cb;
}


// void QGraphicsItem::hoverMoveEvent(QGraphicsSceneHoverEvent *event)

static void _init_cbs_hoverMoveEvent_3044_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneHoverEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hoverMoveEvent_3044_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneHoverEvent *arg1 = args.read<QGraphicsSceneHoverEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem_Adaptor *)cls)->cbs_hoverMoveEvent_3044_0 (arg1);
}

static void _set_callback_cbs_hoverMoveEvent_3044_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_hoverMoveEvent_3044_0 = cb;
}


// void QGraphicsItem::inputMethodEvent(QInputMethodEvent *event)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}


// QVariant QGraphicsItem::inputMethodQuery(Qt::InputMethodQuery query)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QGraphicsItem_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}


// bool QGraphicsItem::isObscuredBy(const QGraphicsItem *item)

static void _init_cbs_isObscuredBy_c2614_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_isObscuredBy_c2614_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > (heap);
  ret.write<bool > ((bool)((QGraphicsItem_Adaptor *)cls)->cbs_isObscuredBy_c2614_0 (arg1));
}

static void _set_callback_cbs_isObscuredBy_c2614_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_isObscuredBy_c2614_0 = cb;
}


// QVariant QGraphicsItem::itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant &value)

static void _init_cbs_itemChange_5658_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("change");
  decl->add_arg<const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_cbs_itemChange_5658_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type & arg1 = args.read<const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type & > (heap);
  const QVariant &arg2 = args.read<const QVariant & > (heap);
  ret.write<QVariant > ((QVariant)((QGraphicsItem_Adaptor *)cls)->cbs_itemChange_5658_0 (arg1, arg2));
}

static void _set_callback_cbs_itemChange_5658_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_itemChange_5658_0 = cb;
}


// void QGraphicsItem::keyPressEvent(QKeyEvent *event)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QGraphicsItem::keyReleaseEvent(QKeyEvent *event)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// void QGraphicsItem::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mouseDoubleClickEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_3049_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem_Adaptor *)cls)->cbs_mouseDoubleClickEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_mouseDoubleClickEvent_3049_0 = cb;
}


// void QGraphicsItem::mouseMoveEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mouseMoveEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_3049_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem_Adaptor *)cls)->cbs_mouseMoveEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_mouseMoveEvent_3049_0 = cb;
}


// void QGraphicsItem::mousePressEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mousePressEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_3049_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem_Adaptor *)cls)->cbs_mousePressEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_mousePressEvent_3049_0 = cb;
}


// void QGraphicsItem::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mouseReleaseEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_3049_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem_Adaptor *)cls)->cbs_mouseReleaseEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_mouseReleaseEvent_3049_0 = cb;
}


// QPainterPath QGraphicsItem::opaqueArea()

static void _init_cbs_opaqueArea_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainterPath > ();
}

static void _call_cbs_opaqueArea_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsItem_Adaptor *)cls)->cbs_opaqueArea_c0_0 ());
}

static void _set_callback_cbs_opaqueArea_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_opaqueArea_c0_0 = cb;
}


// void QGraphicsItem::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)

static void _init_cbs_paint_6301_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionGraphicsItem * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<QWidget * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_paint_6301_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QStyleOptionGraphicsItem *arg2 = args.read<const QStyleOptionGraphicsItem * > (heap);
  QWidget *arg3 = args.read<QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem_Adaptor *)cls)->cbs_paint_6301_1 (arg1, arg2, arg3);
}

static void _set_callback_cbs_paint_6301_1 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_paint_6301_1 = cb;
}


// exposed void QGraphicsItem::prepareGeometryChange()

static void _init_fp_prepareGeometryChange_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_prepareGeometryChange_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem_Adaptor *)cls)->fp_QGraphicsItem_prepareGeometryChange_0 ();
}


// exposed void QGraphicsItem::removeFromIndex()

static void _init_fp_removeFromIndex_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_removeFromIndex_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem_Adaptor *)cls)->fp_QGraphicsItem_removeFromIndex_0 ();
}


// bool QGraphicsItem::sceneEvent(QEvent *event)

static void _init_cbs_sceneEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_sceneEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGraphicsItem_Adaptor *)cls)->cbs_sceneEvent_1217_0 (arg1));
}

static void _set_callback_cbs_sceneEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_sceneEvent_1217_0 = cb;
}


// bool QGraphicsItem::sceneEventFilter(QGraphicsItem *watched, QEvent *event)

static void _init_cbs_sceneEventFilter_3028_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_sceneEventFilter_3028_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsItem *arg1 = args.read<QGraphicsItem * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGraphicsItem_Adaptor *)cls)->cbs_sceneEventFilter_3028_0 (arg1, arg2));
}

static void _set_callback_cbs_sceneEventFilter_3028_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_sceneEventFilter_3028_0 = cb;
}


// void QGraphicsItem::setExtension(QGraphicsItem::Extension extension, const QVariant &variant)

static void _init_cbs_setExtension_4817_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("extension");
  decl->add_arg<unsigned int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("variant");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setExtension_4817_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned int arg1 = args.read<unsigned int > (heap);
  const QVariant &arg2 = args.read<const QVariant & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem_Adaptor *)cls)->cbs_setExtension_4817_0 (arg1, arg2);
}

static void _set_callback_cbs_setExtension_4817_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_setExtension_4817_0 = cb;
}


// QPainterPath QGraphicsItem::shape()

static void _init_cbs_shape_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainterPath > ();
}

static void _call_cbs_shape_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsItem_Adaptor *)cls)->cbs_shape_c0_0 ());
}

static void _set_callback_cbs_shape_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_shape_c0_0 = cb;
}


// bool QGraphicsItem::supportsExtension(QGraphicsItem::Extension extension)

static void _init_cbs_supportsExtension_c2806_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("extension");
  decl->add_arg<unsigned int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_supportsExtension_c2806_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned int arg1 = args.read<unsigned int > (heap);
  ret.write<bool > ((bool)((QGraphicsItem_Adaptor *)cls)->cbs_supportsExtension_c2806_0 (arg1));
}

static void _set_callback_cbs_supportsExtension_c2806_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_supportsExtension_c2806_0 = cb;
}


// int QGraphicsItem::type()

static void _init_cbs_type_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_type_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QGraphicsItem_Adaptor *)cls)->cbs_type_c0_0 ());
}

static void _set_callback_cbs_type_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_type_c0_0 = cb;
}


// void QGraphicsItem::wheelEvent(QGraphicsSceneWheelEvent *event)

static void _init_cbs_wheelEvent_3029_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_3029_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneWheelEvent *arg1 = args.read<QGraphicsSceneWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsItem_Adaptor *)cls)->cbs_wheelEvent_3029_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_3029_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsItem_Adaptor *)cls)->cb_wheelEvent_3029_0 = cb;
}


namespace gsi
{

gsi::Class<QGraphicsItem> &qtdecl_QGraphicsItem ();

static gsi::Methods methods_QGraphicsItem_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGraphicsItem::QGraphicsItem(QGraphicsItem *parent, QGraphicsScene *scene)\nThis method creates an object of class QGraphicsItem.", &_init_ctor_QGraphicsItem_Adaptor_3825, &_call_ctor_QGraphicsItem_Adaptor_3825);
  methods += new qt_gsi::GenericMethod ("*addToIndex", "@brief Method void QGraphicsItem::addToIndex()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addToIndex_0, &_call_fp_addToIndex_0);
  methods += new qt_gsi::GenericMethod ("advance", "@hide", false, &_init_cbs_advance_767_0, &_call_cbs_advance_767_0);
  methods += new qt_gsi::GenericMethod ("advance", "@brief Virtual method void QGraphicsItem::advance(int phase)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_advance_767_0, &_call_cbs_advance_767_0, &_set_callback_cbs_advance_767_0);
  methods += new qt_gsi::GenericMethod ("boundingRect", "@hide", true, &_init_cbs_boundingRect_c0_0, &_call_cbs_boundingRect_c0_0);
  methods += new qt_gsi::GenericMethod ("boundingRect", "@brief Virtual method QRectF QGraphicsItem::boundingRect()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_boundingRect_c0_0, &_call_cbs_boundingRect_c0_0, &_set_callback_cbs_boundingRect_c0_0);
  methods += new qt_gsi::GenericMethod ("collidesWithItem", "@hide", true, &_init_cbs_collidesWithItem_c4977_1, &_call_cbs_collidesWithItem_c4977_1);
  methods += new qt_gsi::GenericMethod ("collidesWithItem", "@brief Virtual method bool QGraphicsItem::collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_collidesWithItem_c4977_1, &_call_cbs_collidesWithItem_c4977_1, &_set_callback_cbs_collidesWithItem_c4977_1);
  methods += new qt_gsi::GenericMethod ("collidesWithPath", "@hide", true, &_init_cbs_collidesWithPath_c4877_1, &_call_cbs_collidesWithPath_c4877_1);
  methods += new qt_gsi::GenericMethod ("collidesWithPath", "@brief Virtual method bool QGraphicsItem::collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_collidesWithPath_c4877_1, &_call_cbs_collidesWithPath_c4877_1, &_set_callback_cbs_collidesWithPath_c4877_1);
  methods += new qt_gsi::GenericMethod ("contains", "@hide", true, &_init_cbs_contains_c1986_0, &_call_cbs_contains_c1986_0);
  methods += new qt_gsi::GenericMethod ("contains", "@brief Virtual method bool QGraphicsItem::contains(const QPointF &point)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_contains_c1986_0, &_call_cbs_contains_c1986_0, &_set_callback_cbs_contains_c1986_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_3674_0, &_call_cbs_contextMenuEvent_3674_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QGraphicsItem::contextMenuEvent(QGraphicsSceneContextMenuEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_3674_0, &_call_cbs_contextMenuEvent_3674_0, &_set_callback_cbs_contextMenuEvent_3674_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_3315_0, &_call_cbs_dragEnterEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QGraphicsItem::dragEnterEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_3315_0, &_call_cbs_dragEnterEvent_3315_0, &_set_callback_cbs_dragEnterEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_3315_0, &_call_cbs_dragLeaveEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QGraphicsItem::dragLeaveEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_3315_0, &_call_cbs_dragLeaveEvent_3315_0, &_set_callback_cbs_dragLeaveEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_3315_0, &_call_cbs_dragMoveEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QGraphicsItem::dragMoveEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_3315_0, &_call_cbs_dragMoveEvent_3315_0, &_set_callback_cbs_dragMoveEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_3315_0, &_call_cbs_dropEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QGraphicsItem::dropEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_3315_0, &_call_cbs_dropEvent_3315_0, &_set_callback_cbs_dropEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*extension", "@hide", true, &_init_cbs_extension_c2119_0, &_call_cbs_extension_c2119_0);
  methods += new qt_gsi::GenericMethod ("*extension", "@brief Virtual method QVariant QGraphicsItem::extension(const QVariant &variant)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_extension_c2119_0, &_call_cbs_extension_c2119_0, &_set_callback_cbs_extension_c2119_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QGraphicsItem::focusInEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QGraphicsItem::focusOutEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*hoverEnterEvent", "@hide", false, &_init_cbs_hoverEnterEvent_3044_0, &_call_cbs_hoverEnterEvent_3044_0);
  methods += new qt_gsi::GenericMethod ("*hoverEnterEvent", "@brief Virtual method void QGraphicsItem::hoverEnterEvent(QGraphicsSceneHoverEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hoverEnterEvent_3044_0, &_call_cbs_hoverEnterEvent_3044_0, &_set_callback_cbs_hoverEnterEvent_3044_0);
  methods += new qt_gsi::GenericMethod ("*hoverLeaveEvent", "@hide", false, &_init_cbs_hoverLeaveEvent_3044_0, &_call_cbs_hoverLeaveEvent_3044_0);
  methods += new qt_gsi::GenericMethod ("*hoverLeaveEvent", "@brief Virtual method void QGraphicsItem::hoverLeaveEvent(QGraphicsSceneHoverEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hoverLeaveEvent_3044_0, &_call_cbs_hoverLeaveEvent_3044_0, &_set_callback_cbs_hoverLeaveEvent_3044_0);
  methods += new qt_gsi::GenericMethod ("*hoverMoveEvent", "@hide", false, &_init_cbs_hoverMoveEvent_3044_0, &_call_cbs_hoverMoveEvent_3044_0);
  methods += new qt_gsi::GenericMethod ("*hoverMoveEvent", "@brief Virtual method void QGraphicsItem::hoverMoveEvent(QGraphicsSceneHoverEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hoverMoveEvent_3044_0, &_call_cbs_hoverMoveEvent_3044_0, &_set_callback_cbs_hoverMoveEvent_3044_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QGraphicsItem::inputMethodEvent(QInputMethodEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodQuery", "@brief Virtual method QVariant QGraphicsItem::inputMethodQuery(Qt::InputMethodQuery query)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("isObscuredBy", "@hide", true, &_init_cbs_isObscuredBy_c2614_0, &_call_cbs_isObscuredBy_c2614_0);
  methods += new qt_gsi::GenericMethod ("isObscuredBy", "@brief Virtual method bool QGraphicsItem::isObscuredBy(const QGraphicsItem *item)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isObscuredBy_c2614_0, &_call_cbs_isObscuredBy_c2614_0, &_set_callback_cbs_isObscuredBy_c2614_0);
  methods += new qt_gsi::GenericMethod ("*itemChange", "@hide", false, &_init_cbs_itemChange_5658_0, &_call_cbs_itemChange_5658_0);
  methods += new qt_gsi::GenericMethod ("*itemChange", "@brief Virtual method QVariant QGraphicsItem::itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant &value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_itemChange_5658_0, &_call_cbs_itemChange_5658_0, &_set_callback_cbs_itemChange_5658_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QGraphicsItem::keyPressEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QGraphicsItem::keyReleaseEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_3049_0, &_call_cbs_mouseDoubleClickEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QGraphicsItem::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_3049_0, &_call_cbs_mouseDoubleClickEvent_3049_0, &_set_callback_cbs_mouseDoubleClickEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_3049_0, &_call_cbs_mouseMoveEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QGraphicsItem::mouseMoveEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_3049_0, &_call_cbs_mouseMoveEvent_3049_0, &_set_callback_cbs_mouseMoveEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_3049_0, &_call_cbs_mousePressEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QGraphicsItem::mousePressEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_3049_0, &_call_cbs_mousePressEvent_3049_0, &_set_callback_cbs_mousePressEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_3049_0, &_call_cbs_mouseReleaseEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QGraphicsItem::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_3049_0, &_call_cbs_mouseReleaseEvent_3049_0, &_set_callback_cbs_mouseReleaseEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("opaqueArea", "@hide", true, &_init_cbs_opaqueArea_c0_0, &_call_cbs_opaqueArea_c0_0);
  methods += new qt_gsi::GenericMethod ("opaqueArea", "@brief Virtual method QPainterPath QGraphicsItem::opaqueArea()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_opaqueArea_c0_0, &_call_cbs_opaqueArea_c0_0, &_set_callback_cbs_opaqueArea_c0_0);
  methods += new qt_gsi::GenericMethod ("paint", "@hide", false, &_init_cbs_paint_6301_1, &_call_cbs_paint_6301_1);
  methods += new qt_gsi::GenericMethod ("paint", "@brief Virtual method void QGraphicsItem::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paint_6301_1, &_call_cbs_paint_6301_1, &_set_callback_cbs_paint_6301_1);
  methods += new qt_gsi::GenericMethod ("*prepareGeometryChange", "@brief Method void QGraphicsItem::prepareGeometryChange()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_prepareGeometryChange_0, &_call_fp_prepareGeometryChange_0);
  methods += new qt_gsi::GenericMethod ("*removeFromIndex", "@brief Method void QGraphicsItem::removeFromIndex()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_removeFromIndex_0, &_call_fp_removeFromIndex_0);
  methods += new qt_gsi::GenericMethod ("*sceneEvent", "@hide", false, &_init_cbs_sceneEvent_1217_0, &_call_cbs_sceneEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*sceneEvent", "@brief Virtual method bool QGraphicsItem::sceneEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sceneEvent_1217_0, &_call_cbs_sceneEvent_1217_0, &_set_callback_cbs_sceneEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*sceneEventFilter", "@hide", false, &_init_cbs_sceneEventFilter_3028_0, &_call_cbs_sceneEventFilter_3028_0);
  methods += new qt_gsi::GenericMethod ("*sceneEventFilter", "@brief Virtual method bool QGraphicsItem::sceneEventFilter(QGraphicsItem *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sceneEventFilter_3028_0, &_call_cbs_sceneEventFilter_3028_0, &_set_callback_cbs_sceneEventFilter_3028_0);
  methods += new qt_gsi::GenericMethod ("*setExtension", "@hide", false, &_init_cbs_setExtension_4817_0, &_call_cbs_setExtension_4817_0);
  methods += new qt_gsi::GenericMethod ("*setExtension", "@brief Virtual method void QGraphicsItem::setExtension(QGraphicsItem::Extension extension, const QVariant &variant)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setExtension_4817_0, &_call_cbs_setExtension_4817_0, &_set_callback_cbs_setExtension_4817_0);
  methods += new qt_gsi::GenericMethod ("shape", "@hide", true, &_init_cbs_shape_c0_0, &_call_cbs_shape_c0_0);
  methods += new qt_gsi::GenericMethod ("shape", "@brief Virtual method QPainterPath QGraphicsItem::shape()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_shape_c0_0, &_call_cbs_shape_c0_0, &_set_callback_cbs_shape_c0_0);
  methods += new qt_gsi::GenericMethod ("*supportsExtension", "@hide", true, &_init_cbs_supportsExtension_c2806_0, &_call_cbs_supportsExtension_c2806_0);
  methods += new qt_gsi::GenericMethod ("*supportsExtension", "@brief Virtual method bool QGraphicsItem::supportsExtension(QGraphicsItem::Extension extension)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportsExtension_c2806_0, &_call_cbs_supportsExtension_c2806_0, &_set_callback_cbs_supportsExtension_c2806_0);
  methods += new qt_gsi::GenericMethod ("type", "@hide", true, &_init_cbs_type_c0_0, &_call_cbs_type_c0_0);
  methods += new qt_gsi::GenericMethod ("type", "@brief Virtual method int QGraphicsItem::type()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_type_c0_0, &_call_cbs_type_c0_0, &_set_callback_cbs_type_c0_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_3029_0, &_call_cbs_wheelEvent_3029_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QGraphicsItem::wheelEvent(QGraphicsSceneWheelEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_3029_0, &_call_cbs_wheelEvent_3029_0, &_set_callback_cbs_wheelEvent_3029_0);
  return methods;
}

gsi::Class<QGraphicsItem_Adaptor> decl_QGraphicsItem_Adaptor (qtdecl_QGraphicsItem (), "QtGui", "QGraphicsItem",
  methods_QGraphicsItem_Adaptor (),
  "@qt\n@brief Binding of QGraphicsItem");

}


//  Implementation of the enum wrapper class for QGraphicsItem::CacheMode
namespace qt_gsi
{

static gsi::Enum<QGraphicsItem::CacheMode> decl_QGraphicsItem_CacheMode_Enum ("QtGui", "QGraphicsItem_CacheMode",
    gsi::enum_const ("NoCache", QGraphicsItem::NoCache, "@brief Enum constant QGraphicsItem::NoCache") +
    gsi::enum_const ("ItemCoordinateCache", QGraphicsItem::ItemCoordinateCache, "@brief Enum constant QGraphicsItem::ItemCoordinateCache") +
    gsi::enum_const ("DeviceCoordinateCache", QGraphicsItem::DeviceCoordinateCache, "@brief Enum constant QGraphicsItem::DeviceCoordinateCache"),
  "@qt\n@brief This class represents the QGraphicsItem::CacheMode enum");

static gsi::QFlagsClass<QGraphicsItem::CacheMode > decl_QGraphicsItem_CacheMode_Enums ("QtGui", "QGraphicsItem_QFlags_CacheMode",
  "@qt\n@brief This class represents the QFlags<QGraphicsItem::CacheMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QGraphicsItem> inject_QGraphicsItem_CacheMode_Enum_in_parent (decl_QGraphicsItem_CacheMode_Enum.defs ());
static gsi::ClassExt<QGraphicsItem> decl_QGraphicsItem_CacheMode_Enum_as_child (decl_QGraphicsItem_CacheMode_Enum, "CacheMode");
static gsi::ClassExt<QGraphicsItem> decl_QGraphicsItem_CacheMode_Enums_as_child (decl_QGraphicsItem_CacheMode_Enums, "QFlags_CacheMode");

}


//  Implementation of the enum wrapper class for QGraphicsItem::GraphicsItemChange
namespace qt_gsi
{

static gsi::Enum<QGraphicsItem::GraphicsItemChange> decl_QGraphicsItem_GraphicsItemChange_Enum ("QtGui", "QGraphicsItem_GraphicsItemChange",
    gsi::enum_const ("ItemPositionChange", QGraphicsItem::ItemPositionChange, "@brief Enum constant QGraphicsItem::ItemPositionChange") +
    gsi::enum_const ("ItemMatrixChange", QGraphicsItem::ItemMatrixChange, "@brief Enum constant QGraphicsItem::ItemMatrixChange") +
    gsi::enum_const ("ItemVisibleChange", QGraphicsItem::ItemVisibleChange, "@brief Enum constant QGraphicsItem::ItemVisibleChange") +
    gsi::enum_const ("ItemEnabledChange", QGraphicsItem::ItemEnabledChange, "@brief Enum constant QGraphicsItem::ItemEnabledChange") +
    gsi::enum_const ("ItemSelectedChange", QGraphicsItem::ItemSelectedChange, "@brief Enum constant QGraphicsItem::ItemSelectedChange") +
    gsi::enum_const ("ItemParentChange", QGraphicsItem::ItemParentChange, "@brief Enum constant QGraphicsItem::ItemParentChange") +
    gsi::enum_const ("ItemChildAddedChange", QGraphicsItem::ItemChildAddedChange, "@brief Enum constant QGraphicsItem::ItemChildAddedChange") +
    gsi::enum_const ("ItemChildRemovedChange", QGraphicsItem::ItemChildRemovedChange, "@brief Enum constant QGraphicsItem::ItemChildRemovedChange") +
    gsi::enum_const ("ItemTransformChange", QGraphicsItem::ItemTransformChange, "@brief Enum constant QGraphicsItem::ItemTransformChange") +
    gsi::enum_const ("ItemPositionHasChanged", QGraphicsItem::ItemPositionHasChanged, "@brief Enum constant QGraphicsItem::ItemPositionHasChanged") +
    gsi::enum_const ("ItemTransformHasChanged", QGraphicsItem::ItemTransformHasChanged, "@brief Enum constant QGraphicsItem::ItemTransformHasChanged") +
    gsi::enum_const ("ItemSceneChange", QGraphicsItem::ItemSceneChange, "@brief Enum constant QGraphicsItem::ItemSceneChange") +
    gsi::enum_const ("ItemVisibleHasChanged", QGraphicsItem::ItemVisibleHasChanged, "@brief Enum constant QGraphicsItem::ItemVisibleHasChanged") +
    gsi::enum_const ("ItemEnabledHasChanged", QGraphicsItem::ItemEnabledHasChanged, "@brief Enum constant QGraphicsItem::ItemEnabledHasChanged") +
    gsi::enum_const ("ItemSelectedHasChanged", QGraphicsItem::ItemSelectedHasChanged, "@brief Enum constant QGraphicsItem::ItemSelectedHasChanged") +
    gsi::enum_const ("ItemParentHasChanged", QGraphicsItem::ItemParentHasChanged, "@brief Enum constant QGraphicsItem::ItemParentHasChanged") +
    gsi::enum_const ("ItemSceneHasChanged", QGraphicsItem::ItemSceneHasChanged, "@brief Enum constant QGraphicsItem::ItemSceneHasChanged") +
    gsi::enum_const ("ItemCursorChange", QGraphicsItem::ItemCursorChange, "@brief Enum constant QGraphicsItem::ItemCursorChange") +
    gsi::enum_const ("ItemCursorHasChanged", QGraphicsItem::ItemCursorHasChanged, "@brief Enum constant QGraphicsItem::ItemCursorHasChanged") +
    gsi::enum_const ("ItemToolTipChange", QGraphicsItem::ItemToolTipChange, "@brief Enum constant QGraphicsItem::ItemToolTipChange") +
    gsi::enum_const ("ItemToolTipHasChanged", QGraphicsItem::ItemToolTipHasChanged, "@brief Enum constant QGraphicsItem::ItemToolTipHasChanged") +
    gsi::enum_const ("ItemFlagsChange", QGraphicsItem::ItemFlagsChange, "@brief Enum constant QGraphicsItem::ItemFlagsChange") +
    gsi::enum_const ("ItemFlagsHaveChanged", QGraphicsItem::ItemFlagsHaveChanged, "@brief Enum constant QGraphicsItem::ItemFlagsHaveChanged") +
    gsi::enum_const ("ItemZValueChange", QGraphicsItem::ItemZValueChange, "@brief Enum constant QGraphicsItem::ItemZValueChange") +
    gsi::enum_const ("ItemZValueHasChanged", QGraphicsItem::ItemZValueHasChanged, "@brief Enum constant QGraphicsItem::ItemZValueHasChanged") +
    gsi::enum_const ("ItemOpacityChange", QGraphicsItem::ItemOpacityChange, "@brief Enum constant QGraphicsItem::ItemOpacityChange") +
    gsi::enum_const ("ItemOpacityHasChanged", QGraphicsItem::ItemOpacityHasChanged, "@brief Enum constant QGraphicsItem::ItemOpacityHasChanged") +
    gsi::enum_const ("ItemScenePositionHasChanged", QGraphicsItem::ItemScenePositionHasChanged, "@brief Enum constant QGraphicsItem::ItemScenePositionHasChanged"),
  "@qt\n@brief This class represents the QGraphicsItem::GraphicsItemChange enum");

static gsi::QFlagsClass<QGraphicsItem::GraphicsItemChange > decl_QGraphicsItem_GraphicsItemChange_Enums ("QtGui", "QGraphicsItem_QFlags_GraphicsItemChange",
  "@qt\n@brief This class represents the QFlags<QGraphicsItem::GraphicsItemChange> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QGraphicsItem> inject_QGraphicsItem_GraphicsItemChange_Enum_in_parent (decl_QGraphicsItem_GraphicsItemChange_Enum.defs ());
static gsi::ClassExt<QGraphicsItem> decl_QGraphicsItem_GraphicsItemChange_Enum_as_child (decl_QGraphicsItem_GraphicsItemChange_Enum, "GraphicsItemChange");
static gsi::ClassExt<QGraphicsItem> decl_QGraphicsItem_GraphicsItemChange_Enums_as_child (decl_QGraphicsItem_GraphicsItemChange_Enums, "QFlags_GraphicsItemChange");

}


//  Implementation of the enum wrapper class for QGraphicsItem::GraphicsItemFlag
namespace qt_gsi
{

static gsi::Enum<QGraphicsItem::GraphicsItemFlag> decl_QGraphicsItem_GraphicsItemFlag_Enum ("QtGui", "QGraphicsItem_GraphicsItemFlag",
    gsi::enum_const ("ItemIsMovable", QGraphicsItem::ItemIsMovable, "@brief Enum constant QGraphicsItem::ItemIsMovable") +
    gsi::enum_const ("ItemIsSelectable", QGraphicsItem::ItemIsSelectable, "@brief Enum constant QGraphicsItem::ItemIsSelectable") +
    gsi::enum_const ("ItemIsFocusable", QGraphicsItem::ItemIsFocusable, "@brief Enum constant QGraphicsItem::ItemIsFocusable") +
    gsi::enum_const ("ItemClipsToShape", QGraphicsItem::ItemClipsToShape, "@brief Enum constant QGraphicsItem::ItemClipsToShape") +
    gsi::enum_const ("ItemClipsChildrenToShape", QGraphicsItem::ItemClipsChildrenToShape, "@brief Enum constant QGraphicsItem::ItemClipsChildrenToShape") +
    gsi::enum_const ("ItemIgnoresTransformations", QGraphicsItem::ItemIgnoresTransformations, "@brief Enum constant QGraphicsItem::ItemIgnoresTransformations") +
    gsi::enum_const ("ItemIgnoresParentOpacity", QGraphicsItem::ItemIgnoresParentOpacity, "@brief Enum constant QGraphicsItem::ItemIgnoresParentOpacity") +
    gsi::enum_const ("ItemDoesntPropagateOpacityToChildren", QGraphicsItem::ItemDoesntPropagateOpacityToChildren, "@brief Enum constant QGraphicsItem::ItemDoesntPropagateOpacityToChildren") +
    gsi::enum_const ("ItemStacksBehindParent", QGraphicsItem::ItemStacksBehindParent, "@brief Enum constant QGraphicsItem::ItemStacksBehindParent") +
    gsi::enum_const ("ItemUsesExtendedStyleOption", QGraphicsItem::ItemUsesExtendedStyleOption, "@brief Enum constant QGraphicsItem::ItemUsesExtendedStyleOption") +
    gsi::enum_const ("ItemHasNoContents", QGraphicsItem::ItemHasNoContents, "@brief Enum constant QGraphicsItem::ItemHasNoContents") +
    gsi::enum_const ("ItemSendsGeometryChanges", QGraphicsItem::ItemSendsGeometryChanges, "@brief Enum constant QGraphicsItem::ItemSendsGeometryChanges") +
    gsi::enum_const ("ItemAcceptsInputMethod", QGraphicsItem::ItemAcceptsInputMethod, "@brief Enum constant QGraphicsItem::ItemAcceptsInputMethod") +
    gsi::enum_const ("ItemNegativeZStacksBehindParent", QGraphicsItem::ItemNegativeZStacksBehindParent, "@brief Enum constant QGraphicsItem::ItemNegativeZStacksBehindParent") +
    gsi::enum_const ("ItemIsPanel", QGraphicsItem::ItemIsPanel, "@brief Enum constant QGraphicsItem::ItemIsPanel") +
    gsi::enum_const ("ItemIsFocusScope", QGraphicsItem::ItemIsFocusScope, "@brief Enum constant QGraphicsItem::ItemIsFocusScope") +
    gsi::enum_const ("ItemSendsScenePositionChanges", QGraphicsItem::ItemSendsScenePositionChanges, "@brief Enum constant QGraphicsItem::ItemSendsScenePositionChanges"),
  "@qt\n@brief This class represents the QGraphicsItem::GraphicsItemFlag enum");

static gsi::QFlagsClass<QGraphicsItem::GraphicsItemFlag > decl_QGraphicsItem_GraphicsItemFlag_Enums ("QtGui", "QGraphicsItem_QFlags_GraphicsItemFlag",
  "@qt\n@brief This class represents the QFlags<QGraphicsItem::GraphicsItemFlag> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QGraphicsItem> inject_QGraphicsItem_GraphicsItemFlag_Enum_in_parent (decl_QGraphicsItem_GraphicsItemFlag_Enum.defs ());
static gsi::ClassExt<QGraphicsItem> decl_QGraphicsItem_GraphicsItemFlag_Enum_as_child (decl_QGraphicsItem_GraphicsItemFlag_Enum, "GraphicsItemFlag");
static gsi::ClassExt<QGraphicsItem> decl_QGraphicsItem_GraphicsItemFlag_Enums_as_child (decl_QGraphicsItem_GraphicsItemFlag_Enums, "QFlags_GraphicsItemFlag");

}


//  Implementation of the enum wrapper class for QGraphicsItem::PanelModality
namespace qt_gsi
{

static gsi::Enum<QGraphicsItem::PanelModality> decl_QGraphicsItem_PanelModality_Enum ("QtGui", "QGraphicsItem_PanelModality",
    gsi::enum_const ("NonModal", QGraphicsItem::NonModal, "@brief Enum constant QGraphicsItem::NonModal") +
    gsi::enum_const ("PanelModal", QGraphicsItem::PanelModal, "@brief Enum constant QGraphicsItem::PanelModal") +
    gsi::enum_const ("SceneModal", QGraphicsItem::SceneModal, "@brief Enum constant QGraphicsItem::SceneModal"),
  "@qt\n@brief This class represents the QGraphicsItem::PanelModality enum");

static gsi::QFlagsClass<QGraphicsItem::PanelModality > decl_QGraphicsItem_PanelModality_Enums ("QtGui", "QGraphicsItem_QFlags_PanelModality",
  "@qt\n@brief This class represents the QFlags<QGraphicsItem::PanelModality> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QGraphicsItem> inject_QGraphicsItem_PanelModality_Enum_in_parent (decl_QGraphicsItem_PanelModality_Enum.defs ());
static gsi::ClassExt<QGraphicsItem> decl_QGraphicsItem_PanelModality_Enum_as_child (decl_QGraphicsItem_PanelModality_Enum, "PanelModality");
static gsi::ClassExt<QGraphicsItem> decl_QGraphicsItem_PanelModality_Enums_as_child (decl_QGraphicsItem_PanelModality_Enums, "QFlags_PanelModality");

}

