About [![Build Status](https://travis-ci.org/mooz/js2-mode.svg?branch=master)](https://travis-ci.org/mooz/js2-mode) [![MELPA](https://melpa.org/packages/js2-mode-badge.svg)](https://melpa.org/#/js2-mode)
======

Improved JavaScript editing mode for GNU Emacs ([description here](http://elpa.gnu.org/packages/js2-mode.html)).

For some of the latest changes, see [latest user-visible changes](https://github.com/mooz/js2-mode/wiki/Latest-user-visible-changes).

Installation
======

The stable versions are hosted at [GNU ELPA](http://elpa.gnu.org/)
(<kbd>M-x list-packages</kbd>).

You can also install the latest development version from
[MELPA](https://melpa.org/#/getting-started).

Emacs 22 and 23
===============

This version requires Emacs 24 and `cl-lib` (either built-in or from GNU ELPA above).
For a backward compatible version, check out the branch
[emacs23](https://github.com/mooz/js2-mode/tree/emacs23).

Bugs
====

* See broken syntax highlighting and timer errors? Recently upgraded
Emacs from version 24.2 or earlier? Try
[reinstalling or byte-recompiling](https://github.com/mooz/js2-mode/issues/72)
the package.

* Any indentation problems should be reported with `M-x report-emacs-bug`
(please try reproducing them with `js-mode` first, for clarity).
Starting with Emacs 25, `js2-mode` delegates indentation to
the indentation engine of `js-mode`.

Please report other problems at <http://github.com/mooz/js2-mode/issues>.

Contributing
======

`js2-mode` is subject to the same
[copyright assignment](http://www.gnu.org/prep/maintain/html_node/Copyright-Papers.html)
policy as Emacs itself, `org-mode`, `CEDET` and other packages in
[GNU ELPA](http://elpa.gnu.org/packages/).

Any
[legally significant](http://www.gnu.org/prep/maintain/html_node/Legally-Significant.html#Legally-Significant)
contributions can only be accepted after the author has completed their
paperwork. Please ask for the request form, and we'll send it to you.

See Also
======

Some third-party modes that use the generated syntax tree:

* [js2-refactor](https://github.com/magnars/js2-refactor.el)
* [skewer-mode](https://github.com/skeeto/skewer-mode)
