package org.eclipse.webdav.dom;

/*
 * (c) Copyright IBM Corp. 2000, 2001.
 * All Rights Reserved.
 */

import org.w3c.dom.*;

/**
 * An element editor for the WebDAV owner element. See RFC2518 section
 * 12.10 for the element's definition.
 * <p>
 * <b>Note:</b> This class/interface is part of an interim API that is still under 
 * development and expected to change significantly before reaching stability. 
 * It is being made available at this early stage to solicit feedback from pioneering 
 * adopters on the understanding that any code that uses this API will almost 
 * certainly be broken (repeatedly) as the API evolves.
 * </p>
 *
 * @see ActiveLock
 * @see LockInfo
 */
public class Owner extends ElementEditor {
/**
 * Creates a new editor on the given WebDAV owner element. The element
 * is assumed to be well formed.
 *
 * @param element a owner element
 * @throws        MalformedElementException if there is reason to
 *                believe that the element is not well formed
 */
public Owner(Element root) throws MalformedElementException {

	super(root, "owner");
}
}
