/*******************************************************************************
 * Copyright (c) 2012 Tasktop Technologies and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Tasktop Technologies - initial API and implementation
 *******************************************************************************/

package org.eclipse.mylyn.hudson.tests.integration;

import java.util.Collections;
import java.util.List;

import junit.framework.TestCase;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mylyn.builds.core.IBooleanParameterDefinition;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.IParameterDefinition;
import org.eclipse.mylyn.builds.core.spi.BuildPlanRequest;
import org.eclipse.mylyn.builds.core.spi.BuildServerBehaviour;
import org.eclipse.mylyn.builds.internal.core.BuildFactory;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;
import org.eclipse.mylyn.hudson.core.HudsonCore;
import org.eclipse.mylyn.hudson.tests.support.HudsonFixture;
import org.eclipse.mylyn.hudson.tests.support.HudsonHarness;

/**
 * @author Steffen Pingel
 */
public class HudsonIntegrationTest extends TestCase {

	private HudsonHarness harness;

	@Override
	protected void setUp() throws Exception {
		harness = HudsonFixture.current().createHarness();
	}

	@Override
	protected void tearDown() throws Exception {
		harness.dispose();
	}

	public void testPlanParameters() throws Exception {
		RepositoryLocation location = harness.getFixture().location();
		BuildServerBehaviour behaviour = HudsonCore.createConnector(null).getBehaviour(location);
		BuildPlanRequest request = new BuildPlanRequest(Collections.singletonList(harness.getPlanParameterized()));

		List<IBuildPlan> plans = behaviour.getPlans(request, null);
		assertEquals("Expected one plan, got: " + plans, 1, plans.size());

		IBuildPlan plan = plans.get(0);
		assertEquals(harness.getPlanParameterized(), plan.getName());

		List<IParameterDefinition> parameters = plan.getParameterDefinitions();
		IBooleanParameterDefinition booleanParameter = BuildFactory.eINSTANCE.createBooleanParameterDefinition();
		booleanParameter.setName("Boolean Parameter");
		booleanParameter.setDescription("Boolean Parameter Description.");
		booleanParameter.setDefaultValue(true);
		booleanParameter.setContainingBuildPlan(plan);
		assertEObjectsEquals(booleanParameter, parameters.get(0));
	}

	private void assertEObjectsEquals(Object o1, Object o2) {
		boolean equals = EcoreUtil.equals((EObject) o1, (EObject) o2);
		if (!equals) {
			// fail with meaningful message
			assertEquals(o1.toString(), o2.toString());
		}
	}

}
