/* -*- mode: c; c-basic-offset: 8 -*- */
#ifdef ECL_CMU_FORMAT
# define ECL_NAME_PPRINT(x) ECL_NAME(x)
#else
# define ECL_NAME_PPRINT(x) NULL
#endif
#ifdef ECL_FINAL
# define ECL_NAME(x) x
#else
# define ECL_NAME(x) NULL
#endif
#ifdef ECL_RELATIVE_PACKAGE_NAMES
# define RELATIVE_PACKAGES_P ECL_T
#else
# define RELATIVE_PACKAGES_P ECL_NIL
#endif
#ifdef DPP
#define CLOS_ "CLOS::"
#define EXT_ "EXT::"
#define SYS_ "SI::"
#define MP_ "MP::"
#define KEY_ ":"
#define GRAY_ "GRAY::"
#define FFI_ "FFI::"
typedef struct {
	const char *name, *translation;
} cl_symbol_initializer;
#else
#include "ecl_constants.h"
#define CLOS_
#define EXT_
#define SYS_
#define MP_
#define KEY_
#define GRAY_
#define FFI_
#endif
/*
 * Conditional addition of functions and symbols. The list of symbols can
 * not depend on the features, because otherwise the sources will and we will
 * not be able to cross-compile.
 */
#ifdef ECL_THREADS
# define IF_MP(x) x
#else
# define IF_MP(x) NULL
#endif
#ifdef TCP
# define IF_TCP(x) x
#else
# define IF_TCP(x) NULL
#endif
#ifdef PROFILE
# define IF_PROFILE(x) x
#else
# define IF_PROFILE(x) NULL
#endif
#ifdef ECL_RELATIVE_PACKAGE_NAMES
# define IF_RELPACK(x) x
#else
# define IF_RELPACK(x) NULL
#endif
#ifndef ECL_CLOS_STREAMS
# define GRAY_ SYS_
#endif
#ifdef ECL_SSE2
# define IF_SSE2(x) x
#else
# define IF_SSE2(x) NULL
#endif
#if defined(HAVE_LIBFFI) || defined(ECL_DYNAMIC_FFI)
# define IF_DFFI(x) x
#else
# define IF_DFFI(x) NULL
#endif
#if defined(HAVE_LIBFFI)
# define IF_LIBFFI(x) x
#else
# define IF_LIBFFI(x) NULL
#endif

cl_symbol_initializer
cl_symbols[] = {

{"NIL",NULL},
{"T",NULL},
#ifdef CLOS
{SYS_ "UNBOUND","si_unbound"},
#else
{SYS_ "UNBOUND",NULL},
#endif
{SYS_ "PROTECT-TAG",NULL},
{SYS_ "*RESTART-CLUSTERS*",NULL},
{SYS_ "*HANDLER-CLUSTERS*",NULL},

/* LISP PACKAGE */
{"&ALLOW-OTHER-KEYS",NULL},
{"&AUX",NULL},
{"&BODY",NULL},
{"&ENVIRONMENT",NULL},
{"&KEY",NULL},
{"&OPTIONAL",NULL},
{"&REST",NULL},
{"&WHOLE",NULL},
{"+","cl_P"},
{"++",NULL},
{"+++",NULL},
{"-","cl_M"},
{"*","cl_X"},
{"**",NULL},
{"***",NULL},
{"/","cl_N"},
{"//",NULL},
{"///",NULL},
{"/=","cl_NE"},
{"*BREAK-ON-SIGNALS*",NULL},
{"*COMPILE-FILE-PATHNAME*",NULL},
{"*COMPILE-FILE-TRUENAME*",NULL},
{"*COMPILE-PRINT*",NULL},
{"*COMPILE-VERBOSE*",NULL},
{"*DEBUG-IO*",NULL},
{"*DEBUGGER-HOOK*",NULL},
{"*DEFAULT-PATHNAME-DEFAULTS*",NULL},
{"*ERROR-OUTPUT*",NULL},
{"*FEATURES*",NULL},
{"*GENSYM-COUNTER*",NULL},
{"*LOAD-PATHNAME*",NULL},
{"*LOAD-PRINT*",NULL},
{"*LOAD-TRUENAME*",NULL},
{"*LOAD-VERBOSE*",NULL},
{"*MACROEXPAND-HOOK*",NULL},
{"*MODULES*",NULL},
{EXT_ "*MODULE-PROVIDER-FUNCTIONS*",NULL},
{"*PACKAGE*",NULL},
{"*PRINT-ARRAY*",NULL},
{"*PRINT-BASE*",NULL},
{"*PRINT-CASE*",NULL},
{"*PRINT-CIRCLE*",NULL},
{"*PRINT-ESCAPE*",NULL},
{"*PRINT-GENSYM*",NULL},
{"*PRINT-LENGTH*",NULL},
{"*PRINT-LEVEL*",NULL},
{"*PRINT-LINES*",NULL},
{"*PRINT-MISER-WIDTH*",NULL},
{"*PRINT-PPRINT-DISPATCH*",NULL},
#if defined(ECL_CMU_FORMAT)
{"*PRINT-PRETTY*",NULL},
#else
{"*PRINT-PRETTY*",NULL},
#endif
{"*PRINT-RADIX*",NULL},
{"*PRINT-READABLY*",NULL},
{"*PRINT-RIGHT-MARGIN*",NULL},
{"*QUERY-IO*",NULL},
{"*RANDOM-STATE*",NULL},
{"*READ-BASE*",NULL},
{"*READ-DEFAULT-FLOAT-FORMAT*",NULL},
{"*READ-EVAL*",NULL},
{"*READ-SUPPRESS*",NULL},
{"*READTABLE*",NULL},
{"*STANDARD-INPUT*",NULL},
{"*STANDARD-OUTPUT*",NULL},
{"*TERMINAL-IO*",NULL},
{"*TRACE-OUTPUT*",NULL},
{"1+","cl_1P"},
{"1-","cl_1M"},
{"<","cl_L"},
{"<=","cl_LE"},
{"=","cl_E"},
{">","cl_G"},
{">=","cl_GE"},
{"ABORT","ECL_NAME(cl_abort)"},
{"ABS","cl_abs"},
{"ACONS","cl_acons"},
{"ACOS","ECL_NAME(cl_acos)"},
{"ACOSH","ECL_NAME(cl_acosh)"},
{"ADJOIN","cl_adjoin"},
{"ADJUST-ARRAY","ECL_NAME(cl_adjust_array)"},
{"ADJUSTABLE-ARRAY-P","cl_adjustable_array_p"},
{"ALPHA-CHAR-P","cl_alpha_char_p"},
{"ALPHANUMERICP","cl_alphanumericp"},
{"AND",NULL},
{"APPEND","cl_append"},
{"APPLY","cl_apply"},
{"APROPOS","ECL_NAME(cl_apropos)"},
{"APROPOS-LIST","ECL_NAME(cl_apropos_list)"},
{"AREF","cl_aref"},
{"ARITHMETIC-ERROR",NULL},
{"ARITHMETIC-ERROR-OPERANDS",NULL},
{"ARITHMETIC-ERROR-OPERATION",NULL},
{"ARRAY",NULL},
{"ARRAY-DIMENSION","cl_array_dimension"},
{"ARRAY-DIMENSION-LIMIT",NULL},
{"ARRAY-DIMENSIONS","ECL_NAME(cl_array_dimensions)"},
{"ARRAY-DISPLACEMENT","cl_array_displacement"},
{"ARRAY-ELEMENT-TYPE","cl_array_element_type"},
{"ARRAY-HAS-FILL-POINTER-P","cl_array_has_fill_pointer_p"},
{"ARRAY-IN-BOUNDS-P","ECL_NAME(cl_array_in_bounds_p)"},
{"ARRAY-RANK","cl_array_rank"},
{"ARRAY-RANK-LIMIT",NULL},
{"ARRAY-ROW-MAJOR-INDEX","ECL_NAME(cl_array_row_major_index)"},
{"ARRAY-TOTAL-SIZE","cl_array_total_size"},
{"ARRAY-TOTAL-SIZE-LIMIT",NULL},
{"ARRAYP","cl_arrayp"},
{"ASH","cl_ash"},
{"ASIN","ECL_NAME(cl_asin)"},
{"ASINH","ECL_NAME(cl_asinh)"},
{"ASSERT",NULL},
{"ASSOC","cl_assoc"},
{"ASSOC-IF","ECL_NAME(cl_assoc_if)"},
{"ASSOC-IF-NOT","ECL_NAME(cl_assoc_if_not)"},
{"ATAN","cl_atan"},
{"ATANH","ECL_NAME(cl_atanh)"},
{"ATOM","cl_atom"},
{"BASE-CHAR",NULL},
{"BASE-STRING",NULL},
{"BIGNUM",NULL},
{"BIT","ECL_NAME(cl_bit)"},
{"BIT-AND","ECL_NAME(cl_bit_and)"},
{"BIT-ANDC1","ECL_NAME(cl_bit_andc1)"},
{"BIT-ANDC2","ECL_NAME(cl_bit_andc2)"},
{"BIT-EQV","ECL_NAME(cl_bit_eqv)"},
{"BIT-IOR","ECL_NAME(cl_bit_ior)"},
{"BIT-NAND","ECL_NAME(cl_bit_nand)"},
{"BIT-NOR","ECL_NAME(cl_bit_nor)"},
{"BIT-NOT","ECL_NAME(cl_bit_not)"},
{"BIT-ORC1","ECL_NAME(cl_bit_orc1)"},
{"BIT-ORC2","ECL_NAME(cl_bit_orc2)"},
{"BIT-VECTOR",NULL},
{"BIT-VECTOR-P","cl_bit_vector_p"},
{"BIT-XOR","ECL_NAME(cl_bit_xor)"},
{"BLOCK",NULL},
{"BOOLE","cl_boole"},
{"BOOLE-1",NULL},
{"BOOLE-2",NULL},
{"BOOLE-AND",NULL},
{"BOOLE-ANDC1",NULL},
{"BOOLE-ANDC2",NULL},
{"BOOLE-C1",NULL},
{"BOOLE-C2",NULL},
{"BOOLE-CLR",NULL},
{"BOOLE-EQV",NULL},
{"BOOLE-IOR",NULL},
{"BOOLE-NAND",NULL},
{"BOOLE-NOR",NULL},
{"BOOLE-ORC1",NULL},
{"BOOLE-ORC2",NULL},
{"BOOLE-SET",NULL},
{"BOOLE-XOR",NULL},
{"BOOLEAN",NULL},
{"BOTH-CASE-P","cl_both_case_p"},
{"BOUNDP","cl_boundp"},
{"BREAK",NULL},
{"BROADCAST-STREAM",NULL},
{"BROADCAST-STREAM-STREAMS","cl_broadcast_stream_streams"},
{"BUTLAST","cl_butlast"},
{"BYTE","ECL_NAME(cl_byte)"},
{"BYTE-POSITION","ECL_NAME(cl_byte_position)"},
{"BYTE-SIZE","ECL_NAME(cl_byte_size)"},
{"CAAAAR","cl_caaaar"},
{"CAAADR","cl_caaadr"},
{"CAAAR","cl_caaar"},
{"CAADAR","cl_caadar"},
{"CAADDR","cl_caaddr"},
{"CAADR","cl_caadr"},
{"CAAR","cl_caar"},
{"CADAAR","cl_cadaar"},
{"CADADR","cl_cadadr"},
{"CADAR","cl_cadar"},
{"CADDAR","cl_caddar"},
{"CADDDR","cl_cadddr"},
{"CADDR","cl_caddr"},
{"CADR","cl_cadr"},
{"CALL-ARGUMENTS-LIMIT",NULL},
{"CAR","cl_car"},
{"CASE",NULL},
{"CATCH",NULL},
{"CCASE",NULL},
{"CDAAAR","cl_cdaaar"},
{"CDAADR","cl_cdaadr"},
{"CDAAR","cl_cdaar"},
{"CDADAR","cl_cdadar"},
{"CDADDR","cl_cdaddr"},
{"CDADR","cl_cdadr"},
{"CDAR","cl_cdar"},
{"CDDAAR","cl_cddaar"},
{"CDDADR","cl_cddadr"},
{"CDDAR","cl_cddar"},
{"CDDDAR","cl_cdddar"},
{"CDDDDR","cl_cddddr"},
{"CDDDR","cl_cdddr"},
{"CDDR","cl_cddr"},
{"CDR","cl_cdr"},
{"CEILING","cl_ceiling"},
{"CELL-ERROR",NULL},
{"CELL-ERROR-NAME",NULL},
{"CERROR","cl_cerror"},
{"CHAR","cl_char"},
{"CHAR-CODE","cl_char_code"},
{"CHAR-CODE-LIMIT",NULL},
{"CHAR-DOWNCASE","cl_char_downcase"},
{"CHAR-EQUAL","cl_char_equal"},
{"CHAR-GREATERP","cl_char_greaterp"},
{"CHAR-INT","cl_char_int"},
{"CHAR-LESSP","cl_char_lessp"},
{"CHAR-NAME","cl_char_name"},
{"CHAR-NOT-EQUAL","cl_char_not_equal"},
{"CHAR-NOT-GREATERP","cl_char_not_greaterp"},
{"CHAR-NOT-LESSP","cl_char_not_lessp"},
{"CHAR-UPCASE","cl_char_upcase"},
{"CHAR/=","cl_charNE"},
{"CHAR<","cl_charL"},
{"CHAR<=","cl_charLE"},
{"CHAR=","cl_charE"},
{"CHAR>","cl_charG"},
{"CHAR>=","cl_charGE"},
{"CHARACTER","cl_character"},
{"CHARACTERP","cl_characterp"},
{"CHECK-TYPE",NULL},
{"CIS","ECL_NAME(cl_cis)"},
{"CLEAR-INPUT","cl_clear_input"},
{"CLEAR-OUTPUT","cl_clear_output"},
{"CLOSE","cl_close"},
{"CLRHASH","cl_clrhash"},
{"CODE-CHAR","cl_code_char"},
{"COERCE","ECL_NAME(cl_coerce)"},
{"COMPILATION-SPEED",NULL},
{"COMPILE",NULL},
{"COMPILE-FILE",NULL},
{"COMPILE-FILE-PATHNAME",NULL},
{"COMPILED-FUNCTION",NULL},
{"COMPILED-FUNCTION-P","cl_compiled_function_p"},
{"COMPILER-MACRO",NULL},
{"COMPILER-MACRO-FUNCTION",NULL},
{"COMPLEMENT","ECL_NAME(cl_complement)"},
{"COMPLEX","cl_complex"},
{"COMPLEXP","cl_complexp"},
{"COMPUTE-RESTARTS","ECL_NAME(cl_compute_restarts)"},
{"CONCATENATE","ECL_NAME(cl_concatenate)"},
{"CONCATENATED-STREAM",NULL},
{"CONCATENATED-STREAM-STREAMS","cl_concatenated_stream_streams"},
{"COND",NULL},
{"CONDITION",NULL},
{"CONJUGATE","cl_conjugate"},
{"CONTINUE","ECL_NAME(cl_continue)"},
{"CONS","cl_cons"},
{"CONSP","cl_consp"},
{"CONSTANTLY","ECL_NAME(cl_constantly)"},
{"CONSTANTP","cl_constantp"},
{"CONTROL-ERROR",NULL},
{"COPY-ALIST","cl_copy_alist"},
{"COPY-LIST","cl_copy_list"},
{"COPY-PPRINT-DISPATCH","ECL_NAME_PPRINT(cl_copy_pprint_dispatch)"},
{"COPY-READTABLE","cl_copy_readtable"},
{"COPY-SEQ","cl_copy_seq"},
{"COPY-STRUCTURE","cl_copy_structure"},
{"COPY-SYMBOL","cl_copy_symbol"},
{"COPY-TREE","cl_copy_tree"},
{"COS","cl_cos"},
{"COSH","cl_cosh"},
{"COUNT","ECL_NAME(cl_count)"},
{"COUNT-IF","ECL_NAME(cl_count_if)"},
{"COUNT-IF-NOT","ECL_NAME(cl_count_if_not)"},
{"CTYPECASE",NULL},
{"DEBUG",NULL},
{"DECF",NULL},
{"DECLAIM",NULL},
{"DECLARATION",NULL},
{"DECLARE",NULL},
{"DECODE-FLOAT","cl_decode_float"},
{"DECODE-UNIVERSAL-TIME","ECL_NAME(cl_decode_universal_time)"},
{"DEFCONSTANT",NULL},
{"DEFINE-CONDITION",NULL},
{"DEFINE-COMPILER-MACRO",NULL},
{"DEFINE-MODIFY-MACRO",NULL},
{"DEFINE-SETF-EXPANDER",NULL},
{"DEFINE-SYMBOL-MACRO",NULL},
{"DEFMACRO",NULL},
{"DEFPACKAGE",NULL},
{"DEFPARAMETER",NULL},
{"DEFSETF",NULL},
{"DEFSTRUCT",NULL},
{"DEFTYPE",NULL},
{"DEFUN",NULL},
{"DEFVAR",NULL},
{"DELETE","ECL_NAME(cl_delete)"},
{"DELETE-DUPLICATES","ECL_NAME(cl_delete_duplicates)"},
{"DELETE-FILE","cl_delete_file"},
{"DELETE-IF","ECL_NAME(cl_delete_if)"},
{"DELETE-IF-NOT","ECL_NAME(cl_delete_if_not)"},
{"DELETE-PACKAGE","cl_delete_package"},
{"DENOMINATOR","cl_denominator"},
{"DEPOSIT-FIELD","ECL_NAME(cl_deposit_field)"},
{"DESCRIBE","ECL_NAME(cl_describe)"},
{"DESTRUCTURING-BIND",NULL},
{"DIGIT-CHAR","cl_digit_char"},
{"DIGIT-CHAR-P","cl_digit_char_p"},
{"DIRECTORY","cl_directory"},
{"DIRECTORY-NAMESTRING","cl_directory_namestring"},
{"DISASSEMBLE",NULL},
{"DIVISION-BY-ZERO",NULL},
{"DO",NULL},
{"DO*",NULL},
{"DO-ALL-SYMBOLS",NULL},
{"DO-EXTERNAL-SYMBOLS",NULL},
{"DO-SYMBOLS",NULL},
{"DOCUMENTATION",NULL},
{"DOLIST",NULL},
{"DOTIMES",NULL},
{"DOUBLE-FLOAT",NULL},
{"DOUBLE-FLOAT-EPSILON",NULL},
{"DOUBLE-FLOAT-NEGATIVE-EPSILON",NULL},
{"DPB","ECL_NAME(cl_dpb)"},
{"DRIBBLE","ECL_NAME(cl_dribble)"},
{"DYNAMIC-EXTENT",NULL},
{"ECASE",NULL},
{"ECHO-STREAM",NULL},
{"ECHO-STREAM-INPUT-STREAM","cl_echo_stream_input_stream"},
{"ECHO-STREAM-OUTPUT-STREAM","cl_echo_stream_output_stream"},
{"ED",NULL},
{"EIGHTH","cl_eighth"},
{"ELT","cl_elt"},
{"ENCODE-UNIVERSAL-TIME","ECL_NAME(cl_encode_universal_time)"},
{"END-OF-FILE",NULL},
{"ENDP","cl_endp"},
{"ENOUGH-NAMESTRING","cl_enough_namestring"},
{"ENSURE-DIRECTORIES-EXIST","ECL_NAME(cl_ensure_directories_exist)"},
{"EQ","cl_eq"},
{"EQL","cl_eql"},
{"EQUAL","cl_equal"},
{"EQUALP","cl_equalp"},
{"ERROR","cl_error"},
{"ETYPECASE",NULL},
{"EVAL","cl_eval"},
{"EVAL-WHEN",NULL},
{"EVENP","cl_evenp"},
{"EVERY","ECL_NAME(cl_every)"},
{"EXP","cl_exp"},
{"EXPORT","cl_export"},
{"EXPT","cl_expt"},
{"EXTENDED-CHAR",NULL},
{"FBOUNDP","cl_fboundp"},
{"FCEILING","ECL_NAME(cl_fceiling)"},
{"FDEFINITION","cl_fdefinition"},
{"FFLOOR","ECL_NAME(cl_ffloor)"},
{"FIFTH","cl_fifth"},
{"FILE-AUTHOR","cl_file_author"},
{"FILE-ERROR",NULL},
{"FILE-ERROR-PATHNAME",NULL},
{"FILE-LENGTH","cl_file_length"},
{"FILE-NAMESTRING","cl_file_namestring"},
{"FILE-POSITION","cl_file_position"},
{"FILE-STREAM",NULL},
{"FILE-STRING-LENGTH","cl_file_string_length"},
{"FILE-WRITE-DATE","cl_file_write_date"},
{"FILL","ECL_NAME(cl_fill)"},
{"FILL-POINTER","cl_fill_pointer"},
{"FIND","ECL_NAME(cl_find)"},
{"FIND-ALL-SYMBOLS","ECL_NAME(cl_find_all_symbols)"},
{"FIND-IF","ECL_NAME(cl_find_if)"},
{"FIND-IF-NOT","ECL_NAME(cl_find_if_not)"},
{"FIND-PACKAGE","cl_find_package"},
{"FIND-RESTART","ECL_NAME(cl_find_restart)"},
{"FIND-SYMBOL","cl_find_symbol"},
{"FINISH-OUTPUT","cl_finish_output"},
{"FIRST","cl_car"},
{"FIXNUM",NULL},
{"FLET",NULL},
{"FLOAT","cl_float"},
{"FLOAT-DIGITS","cl_float_digits"},
{"FLOAT-PRECISION","cl_float_precision"},
{"FLOAT-RADIX","cl_float_radix"},
{"FLOAT-SIGN","cl_float_sign"},
{"FLOATING-POINT-INEXACT",NULL},
{"FLOATING-POINT-INVALID-OPERATION",NULL},
{"FLOATING-POINT-OVERFLOW",NULL},
{"FLOATING-POINT-UNDERFLOW",NULL},
{"FLOATP","cl_floatp"},
{"FLOOR","cl_floor"},
{"FMAKUNBOUND","cl_fmakunbound"},
{"FORCE-OUTPUT","cl_force_output"},
{"FORMAT","cl_format"},
{"FORMATTER",NULL},
{"FOURTH","cl_cadddr"},
{"FRESH-LINE","cl_fresh_line"},
{"FROUND","ECL_NAME(cl_fround)"},
{"FTRUNCATE","ECL_NAME(cl_ftruncate)"},
{"FTYPE",NULL},
{"FUNCALL","cl_funcall"},
{"FUNCTION-LAMBDA-EXPRESSION","cl_function_lambda_expression"},
{"FUNCTION",NULL},
{"FUNCTION-KEYWORDS",NULL},
{"FUNCTIONP","cl_functionp"},
{"GCD","cl_gcd"},
{"GENSYM","cl_gensym"},
{"GENTEMP","cl_gentemp"},
{"GET","cl_get"},
{"GET-DECODED-TIME","ECL_NAME(cl_get_decoded_time)"},
{"GET-DISPATCH-MACRO-CHARACTER","cl_get_dispatch_macro_character"},
{"GET-INTERNAL-REAL-TIME","cl_get_internal_real_time"},
{"GET-INTERNAL-RUN-TIME","cl_get_internal_run_time"},
{"GET-MACRO-CHARACTER","cl_get_macro_character"},
{"GET-OUTPUT-STREAM-STRING","cl_get_output_stream_string"},
{"GET-PROPERTIES","cl_get_properties"},
{"GET-SETF-EXPANSION",NULL},
{"GET-UNIVERSAL-TIME","cl_get_universal_time"},
{"GETF","cl_getf"},
{"GETHASH","cl_gethash"},
{"GO",NULL},
{"GRAPHIC-CHAR-P","cl_graphic_char_p"},
{"HANDLER-CASE",NULL},
{"HANDLER-BIND",NULL},
{"HASH-TABLE",NULL},
{"HASH-TABLE-COUNT","cl_hash_table_count"},
{"HASH-TABLE-P","cl_hash_table_p"},
{"HASH-TABLE-REHASH-SIZE","cl_hash_table_rehash_size"},
{"HASH-TABLE-REHASH-THRESHOLD","cl_hash_table_rehash_threshold"},
{"HASH-TABLE-SIZE","cl_hash_table_size"},
{"HASH-TABLE-TEST","cl_hash_table_test"},
{"HOST-NAMESTRING","cl_host_namestring"},
{"IDENTITY","cl_identity"},
{"IGNORABLE",NULL},
{"IGNORE",NULL},
{"IGNORE-ERRORS",NULL},
{"IMAGPART","cl_imagpart"},
{"IMPORT","cl_import"},
{"IN-PACKAGE",NULL},
{"INCF",NULL},
{"INLINE",NULL},
{"INPUT-STREAM-P","cl_input_stream_p"},
{"INSPECT","ECL_NAME(cl_inspect)"},
{"INTEGER",NULL},
{"INTEGER-DECODE-FLOAT","cl_integer_decode_float"},
{"INTEGER-LENGTH","cl_integer_length"},
{"INTEGERP","cl_integerp"},
{"INTERACTIVE-STREAM-P","cl_interactive_stream_p"},
{"INTERN","cl_intern"},
{"INTERNAL-TIME-UNITS-PER-SECOND",NULL},
{"INTERSECTION","ECL_NAME(cl_intersection)"},
{"INVOKE-DEBUGGER",NULL},
{"INVOKE-RESTART","ECL_NAME(cl_invoke_restart)"},
{"INVOKE-RESTART-INTERACTIVELY","ECL_NAME(cl_invoke_restart_interactively)"},
{"ISQRT","ECL_NAME(cl_isqrt)"},
{"KEYWORD",NULL},
{"KEYWORDP","cl_keywordp"},
{"LABELS",NULL},
{"LAMBDA",NULL},
{"LAMBDA-LIST-KEYWORDS",NULL},
{"LAMBDA-PARAMETERS-LIMIT",NULL},
{"LAST","cl_last"},
{"LCM","cl_lcm"},
{"LDB","ECL_NAME(cl_ldb)"},
{"LDB-TEST","ECL_NAME(cl_ldb_test)"},
{"LDIFF","cl_ldiff"},
{"LEAST-NEGATIVE-DOUBLE-FLOAT",NULL},
{"LEAST-NEGATIVE-LONG-FLOAT",NULL},
{"LEAST-NEGATIVE-NORMALIZED-DOUBLE-FLOAT",NULL},
{"LEAST-NEGATIVE-NORMALIZED-LONG-FLOAT",NULL},
{"LEAST-NEGATIVE-NORMALIZED-SHORT-FLOAT",NULL},
{"LEAST-NEGATIVE-NORMALIZED-SINGLE-FLOAT",NULL},
{"LEAST-NEGATIVE-SHORT-FLOAT",NULL},
{"LEAST-NEGATIVE-SINGLE-FLOAT",NULL},
{"LEAST-POSITIVE-DOUBLE-FLOAT",NULL},
{"LEAST-POSITIVE-LONG-FLOAT",NULL},
{"LEAST-POSITIVE-NORMALIZED-DOUBLE-FLOAT",NULL},
{"LEAST-POSITIVE-NORMALIZED-LONG-FLOAT",NULL},
{"LEAST-POSITIVE-NORMALIZED-SHORT-FLOAT",NULL},
{"LEAST-POSITIVE-NORMALIZED-SINGLE-FLOAT",NULL},
{"LEAST-POSITIVE-SHORT-FLOAT",NULL},
{"LEAST-POSITIVE-SINGLE-FLOAT",NULL},
{"LENGTH","cl_length"},
{"LET",NULL},
{"LET*",NULL},
{"LISP-IMPLEMENTATION-TYPE","ECL_NAME(cl_lisp_implementation_type)"},
{"LISP-IMPLEMENTATION-VERSION","ECL_NAME(cl_lisp_implementation_version)"},
{"LIST","cl_list"},
{"LIST*","cl_listX"},
{"LIST-ALL-PACKAGES","cl_list_all_packages"},
{"LIST-LENGTH","cl_list_length"},
{"LISTEN","cl_listen"},
{"LISTP","cl_listp"},
{"LOAD","cl_load"},
{"LOAD-LOGICAL-PATHNAME-TRANSLATIONS","ECL_NAME(cl_load_logical_pathname_translations)"},
{"LOAD-TIME-VALUE",NULL},
{"LOCALLY",NULL},
{"LOG","cl_log"},
{"LOGAND","cl_logand"},
{"LOGANDC1","cl_logandc1"},
{"LOGANDC2","cl_logandc2"},
{"LOGBITP","cl_logbitp"},
{"LOGCOUNT","cl_logcount"},
{"LOGEQV","cl_logeqv"},
{"LOGICAL-PATHNAME","cl_logical_pathname"},
{"LOGICAL-PATHNAME-TRANSLATIONS","ECL_NAME(cl_logical_pathname_translations)"},
{"LOGIOR","cl_logior"},
{"LOGNAND","cl_lognand"},
{"LOGNOR","cl_lognor"},
{"LOGNOT","cl_lognot"},
{"LOGORC1","cl_logorc1"},
{"LOGORC2","cl_logorc2"},
{"LOGTEST","ECL_NAME(cl_logtest)"},
{"LOGXOR","cl_logxor"},
{"LONG-FLOAT",NULL},
{"LONG-FLOAT-EPSILON",NULL},
{"LONG-FLOAT-NEGATIVE-EPSILON",NULL},
{"LONG-SITE-NAME","ECL_NAME(cl_long_site_name)"},
{"LOOP",NULL},
{"LOOP-FINISH",NULL},
{"LOWER-CASE-P","cl_lower_case_p"},
{"MACHINE-INSTANCE","ECL_NAME(cl_machine_instance)"},
{"MACHINE-TYPE","ECL_NAME(cl_machine_type)"},
{"MACHINE-VERSION","ECL_NAME(cl_machine_version)"},
{"MACRO-FUNCTION","cl_macro_function"},
{"MACROEXPAND","cl_macroexpand"},
{"MACROEXPAND-1","cl_macroexpand_1"},
{"MACROLET",NULL},
{"MAKE-ARRAY","ECL_NAME(cl_make_array)"},
{"MAKE-BROADCAST-STREAM","cl_make_broadcast_stream"},
{"MAKE-CONDITION","ECL_NAME(cl_make_condition)"},
{"MAKE-CONCATENATED-STREAM","cl_make_concatenated_stream"},
{"MAKE-DISPATCH-MACRO-CHARACTER","cl_make_dispatch_macro_character"},
{"MAKE-ECHO-STREAM","cl_make_echo_stream"},
{"MAKE-HASH-TABLE","cl_make_hash_table"},
{"MAKE-LIST","cl_make_list"},
{"MAKE-PACKAGE","cl_make_package"},
{"MAKE-PATHNAME","cl_make_pathname"},
{"MAKE-RANDOM-STATE","cl_make_random_state"},
{"MAKE-SEQUENCE","ECL_NAME(cl_make_sequence)"},
{"MAKE-STRING","cl_make_string"},
{"MAKE-STRING-INPUT-STREAM","cl_make_string_input_stream"},
{"MAKE-STRING-OUTPUT-STREAM","cl_make_string_output_stream"},
{"MAKE-SYMBOL","cl_make_symbol"},
{"MAKE-SYNONYM-STREAM","cl_make_synonym_stream"},
{"MAKE-TWO-WAY-STREAM","cl_make_two_way_stream"},
{"MAKUNBOUND","cl_makunbound"},
{"MAP","ECL_NAME(cl_map)"},
{"MAP-INTO","ECL_NAME(cl_map_into)"},
{"MAPC","cl_mapc"},
{"MAPCAN","cl_mapcan"},
{"MAPCAR","cl_mapcar"},
{"MAPCON","cl_mapcon"},
{"MAPHASH","cl_maphash"},
{"MAPL","cl_mapl"},
{"MAPLIST","cl_maplist"},
{"MASK-FIELD","ECL_NAME(cl_mask_field)"},
{"MAX","cl_max"},
{"MEMBER","cl_member"},
{"MEMBER-IF","ECL_NAME(cl_member_if)"},
{"MEMBER-IF-NOT","ECL_NAME(cl_member_if_not)"},
{"MERGE","ECL_NAME(cl_merge)"},
{"MERGE-PATHNAMES","cl_merge_pathnames"},
{"MIN","cl_min"},
{"MINUSP","cl_minusp"},
{"MISMATCH","ECL_NAME(cl_mismatch)"},
{"MOD","cl_mod"},
{"MOST-NEGATIVE-DOUBLE-FLOAT",NULL},
{"MOST-NEGATIVE-FIXNUM",NULL},
{"MOST-NEGATIVE-LONG-FLOAT",NULL},
{"MOST-NEGATIVE-SHORT-FLOAT",NULL},
{"MOST-NEGATIVE-SINGLE-FLOAT",NULL},
{"MOST-POSITIVE-DOUBLE-FLOAT",NULL},
{"MOST-POSITIVE-FIXNUM",NULL},
{"MOST-POSITIVE-LONG-FLOAT",NULL},
{"MOST-POSITIVE-SHORT-FLOAT",NULL},
{"MOST-POSITIVE-SINGLE-FLOAT",NULL},
{"MUFFLE-WARNING","ECL_NAME(cl_muffle_warning)"},
{"MULTIPLE-VALUE-BIND",NULL},
{"MULTIPLE-VALUE-CALL",NULL},
{"MULTIPLE-VALUE-LIST",NULL},
{"MULTIPLE-VALUE-PROG1",NULL},
{"MULTIPLE-VALUE-SETQ",NULL},
{"MULTIPLE-VALUES-LIMIT",NULL},
{"NAME-CHAR","cl_name_char"},
{"NAMESTRING","cl_namestring"},
{"NBUTLAST","cl_nbutlast"},
{"NCONC","cl_nconc"},
{"NINTERSECTION","ECL_NAME(cl_nintersection)"},
{"NINTH","cl_ninth"},
{"NOT","cl_not"},
{"NOTANY","ECL_NAME(cl_notany)"},
{"NOTEVERY","ECL_NAME(cl_notevery)"},
{"NOTINLINE",NULL},
{"NRECONC","cl_nreconc"},
{"NREVERSE","cl_nreverse"},
{"NSET-DIFFERENCE","ECL_NAME(cl_nset_difference)"},
{"NSET-EXCLUSIVE-OR","ECL_NAME(cl_nset_exclusive_or)"},
{"NSTRING-CAPITALIZE","cl_nstring_capitalize"},
{"NSTRING-DOWNCASE","cl_nstring_downcase"},
{"NSTRING-UPCASE","cl_nstring_upcase"},
{"NSUBLIS","cl_nsublis"},
{"NSUBST","cl_nsubst"},
{"NSUBST-IF","ECL_NAME(cl_nsubst_if)"},
{"NSUBST-IF-NOT","ECL_NAME(cl_nsubst_if_not)"},
{"NSUBSTITUTE","ECL_NAME(cl_nsubstitute)"},
{"NSUBSTITUTE-IF","ECL_NAME(cl_nsubstitute_if)"},
{"NSUBSTITUTE-IF-NOT","ECL_NAME(cl_nsubstitute_if_not)"},
{"NTH","cl_nth"},
{"NTH-VALUE",NULL},
{"NTHCDR","cl_nthcdr"},
{"NULL","cl_null"},
{"NUMBER",NULL},
{"NUMBERP","cl_numberp"},
{"NUMERATOR","cl_numerator"},
{"NUNION","ECL_NAME(cl_nunion)"},
{"ODDP","cl_oddp"},
{"OPEN","cl_open"},
{"OPEN-STREAM-P","cl_open_stream_p"},
{"OPTIMIZE",NULL},
{"OR",NULL},
{"OTHERWISE",NULL},
{"OUTPUT-STREAM-P","cl_output_stream_p"},
{"PACKAGE",NULL},
{"PACKAGE-ERROR",NULL},
{"PACKAGE-ERROR-PACKAGE",NULL},
{"PACKAGE-NAME","cl_package_name"},
{"PACKAGE-NICKNAMES","cl_package_nicknames"},
{"PACKAGE-SHADOWING-SYMBOLS","cl_package_shadowing_symbols"},
{"PACKAGE-USE-LIST","cl_package_use_list"},
{"PACKAGE-USED-BY-LIST","cl_package_used_by_list"},
{"PACKAGEP","cl_packagep"},
{"PAIRLIS","cl_pairlis"},
{"PARSE-ERROR",NULL},
{"PARSE-INTEGER","cl_parse_integer"},
{"PARSE-NAMESTRING","cl_parse_namestring"},
{"PATHNAME","cl_pathname"},
{"PATHNAME-DEVICE","cl_pathname_device"},
{"PATHNAME-DIRECTORY","cl_pathname_directory"},
{"PATHNAME-HOST","cl_pathname_host"},
{"PATHNAME-MATCH-P","cl_pathname_match_p"},
{"PATHNAME-NAME","cl_pathname_name"},
{"PATHNAME-TYPE","cl_pathname_type"},
{"PATHNAME-VERSION","cl_pathname_version"},
{"PATHNAMEP","cl_pathnamep"},
{"PEEK-CHAR","cl_peek_char"},
{"PHASE","ECL_NAME(cl_phase)"},
{"PI",NULL},
{"PLUSP","cl_plusp"},
{"POP",NULL},
{"POSITION","ECL_NAME(cl_position)"},
{"POSITION-IF","ECL_NAME(cl_position_if)"},
{"POSITION-IF-NOT","ECL_NAME(cl_position_if_not)"},
{"PPRINT","cl_pprint"},
{"PPRINT-DISPATCH","ECL_NAME_PPRINT(cl_pprint_dispatch)"},
{"PPRINT-EXIT-IF-LIST-EXHAUSTED",NULL},
{"PPRINT-FILL","ECL_NAME_PPRINT(cl_pprint_fill)"},
{"PPRINT-INDENT","ECL_NAME_PPRINT(cl_pprint_indent)"},
{"PPRINT-LINEAR","ECL_NAME_PPRINT(cl_pprint_linear)"},
{"PPRINT-LOGICAL-BLOCK",NULL},
{"PPRINT-NEWLINE","ECL_NAME_PPRINT(cl_pprint_newline)"},
{"PPRINT-POP",NULL},
{"PPRINT-TAB","ECL_NAME_PPRINT(cl_pprint_tab)"},
{"PPRINT-TABULAR","ECL_NAME_PPRINT(cl_pprint_tabular)"},
{"PRIN1","cl_prin1"},
{"PRIN1-TO-STRING","ECL_NAME(cl_prin1_to_string)"},
{"PRINC","cl_princ"},
{"PRINC-TO-STRING","ECL_NAME(cl_princ_to_string)"},
{"PRINT","cl_print"},
{"PRINT-NOT-READABLE",NULL},
{"PRINT-NOT-READABLE-OBJECT",NULL},
{"PROBE-FILE","cl_probe_file"},
{"PROCLAIM",NULL},
{"PROG",NULL},
{"PROG*",NULL},
{"PROG1",NULL},
{"PROG2",NULL},
{"PROGN",NULL},
{"PROGRAM-ERROR",NULL},
{"PROGV",NULL},
{"PROVIDE","ECL_NAME(cl_provide)"},
{"PSETF",NULL},
{"PSETQ",NULL},
{"PUSH",NULL},
{"PUSHNEW",NULL},
{"QUOTE",NULL},
{"RANDOM","cl_random"},
{"RANDOM-STATE",NULL},
{"RANDOM-STATE-P","cl_random_state_p"},
{"RASSOC","cl_rassoc"},
{"RASSOC-IF","ECL_NAME(cl_rassoc_if)"},
{"RASSOC-IF-NOT","ECL_NAME(cl_rassoc_if_not)"},
{"RATIO",NULL},
{"RATIONAL","cl_rational"},
{"RATIONALIZE","cl_rationalize"},
{"RATIONALP","cl_rationalp"},
{"READ","cl_read"},
{"READ-BYTE","cl_read_byte"},
{"READ-CHAR","cl_read_char"},
{"READ-CHAR-NO-HANG","cl_read_char_no_hang"},
{"READ-DELIMITED-LIST","cl_read_delimited_list"},
{"READ-FROM-STRING","ECL_NAME(cl_read_from_string)"},
{"READ-LINE","cl_read_line"},
{"READ-PRESERVING-WHITESPACE","cl_read_preserving_whitespace"},
{"READ-SEQUENCE","cl_read_sequence"},
{"READER-ERROR",NULL},
{"READTABLE",NULL},
{"READTABLE-CASE","cl_readtable_case"},
{"READTABLEP","cl_readtablep"},
{"REAL",NULL},
{"REALP","cl_realp"},
{"REALPART","cl_realpart"},
{"REDUCE","ECL_NAME(cl_reduce)"},
{"REM","cl_rem"},
{"REMF",NULL},
{"REMHASH","cl_remhash"},
{"REMOVE","ECL_NAME(cl_remove)"},
{"REMOVE-DUPLICATES","ECL_NAME(cl_remove_duplicates)"},
{"REMOVE-IF","ECL_NAME(cl_remove_if)"},
{"REMOVE-IF-NOT","ECL_NAME(cl_remove_if_not)"},
{"REMPROP","cl_remprop"},
{"RENAME-FILE","cl_rename_file"},
{"RENAME-PACKAGE","cl_rename_package"},
{"REPLACE","ECL_NAME(cl_replace)"},
{"REQUIRE","ECL_NAME(cl_require)"},
{"REST","cl_cdr"},
{"RESTART",NULL},
{"RESTART-BIND",NULL},
{"RESTART-CASE",NULL},
{"RESTART-NAME",NULL},
{"RETURN",NULL},
{"RETURN-FROM",NULL},
{"REVAPPEND","cl_revappend"},
{"REVERSE","cl_reverse"},
{"ROOM",NULL},
{"ROTATEF",NULL},
{"ROUND","cl_round"},
{"ROW-MAJOR-AREF","cl_row_major_aref"},
{"RPLACA","cl_rplaca"},
{"RPLACD","cl_rplacd"},
{"SAFETY",NULL},
{"SATISFIES",NULL},
{"SBIT","ECL_NAME(cl_sbit)"},
{"SCALE-FLOAT","cl_scale_float"},
{"SCHAR","cl_char"},
{"SEARCH","ECL_NAME(cl_search)"},
{"SECOND","cl_cadr"},
{"SEQUENCE",NULL},
{"SERIOUS-CONDITION",NULL},
{"SET","cl_set"},
{"SET-DIFFERENCE","ECL_NAME(cl_set_difference)"},
{"SET-DISPATCH-MACRO-CHARACTER","cl_set_dispatch_macro_character"},
{"SET-EXCLUSIVE-OR","ECL_NAME(cl_set_exclusive_or)"},
{"SET-MACRO-CHARACTER","cl_set_macro_character"},
{"SET-PPRINT-DISPATCH","ECL_NAME_PPRINT(cl_set_pprint_dispatch)"},
{"SET-SYNTAX-FROM-CHAR","cl_set_syntax_from_char"},
{"SETF",NULL},
{"SETQ",NULL},
{"SEVENTH","cl_seventh"},
{"SHADOW","cl_shadow"},
{"SHADOWING-IMPORT","cl_shadowing_import"},
{"SHIFTF",NULL},
{"SHORT-FLOAT",NULL},
{"SHORT-FLOAT-EPSILON",NULL},
{"SHORT-FLOAT-NEGATIVE-EPSILON",NULL},
{"SHORT-SITE-NAME","ECL_NAME(cl_short_site_name)"},
{"SIGNAL",NULL},
{"SIGNED-BYTE",NULL},
{"SIGNUM","ECL_NAME(cl_signum)"},
{"SIMPLE-ARRAY",NULL},
{"SIMPLE-BASE-STRING",NULL},
{"SIMPLE-BIT-VECTOR",NULL},
{"SIMPLE-BIT-VECTOR-P","cl_simple_bit_vector_p"},
{"SIMPLE-CONDITION",NULL},
{"SIMPLE-CONDITION-FORMAT-CONTROL",NULL},
{"SIMPLE-CONDITION-FORMAT-ARGUMENTS",NULL},
{"SIMPLE-ERROR",NULL},
{"SIMPLE-STRING",NULL},
{"SIMPLE-STRING-P","cl_simple_string_p"},
{"SIMPLE-TYPE-ERROR",NULL},
{"SIMPLE-VECTOR",NULL},
{"SIMPLE-VECTOR-P","cl_simple_vector_p"},
{"SIMPLE-WARNING",NULL},
{"SIN","cl_sin"},
{"SINGLE-FLOAT",NULL},
{"SINGLE-FLOAT-EPSILON",NULL},
{"SINGLE-FLOAT-NEGATIVE-EPSILON",NULL},
{"SINH","cl_sinh"},
{"SIXTH","cl_sixth"},
{"SLEEP","cl_sleep"},
{"SOFTWARE-TYPE","ECL_NAME(cl_software_type)"},
{"SOFTWARE-VERSION","ECL_NAME(cl_software_version)"},
{"SOME","ECL_NAME(cl_some)"},
{"SORT","ECL_NAME(cl_sort)"},
{"SPACE",NULL},
{"SPECIAL",NULL},
{"SPECIAL-OPERATOR-P","cl_special_operator_p"},
{"SPEED",NULL},
{"SQRT","cl_sqrt"},
{"STABLE-SORT","ECL_NAME(cl_stable_sort)"},
{"STANDARD-CHAR",NULL},
{"STANDARD-CHAR-P","cl_standard_char_p"},
{"STEP",NULL},
{"STORAGE-CONDITION",NULL},
{"STORE-VALUE","ECL_NAME(cl_store_value)"},
{"STREAM",NULL},
{"STREAM-ELEMENT-TYPE","cl_stream_element_type"},
{"STREAM-ERROR",NULL},
{"STREAM-ERROR-STREAM",NULL},
{"STREAM-EXTERNAL-FORMAT","cl_stream_external_format"},
{"STREAMP","cl_streamp"},
{"STRING","cl_string"},
{"STRING-DOWNCASE","cl_string_downcase"},
{"STRING-CAPITALIZE","cl_string_capitalize"},
{"STRING-EQUAL","cl_string_equal"},
{"STRING-GREATERP","cl_string_greaterp"},
{"STRING-LEFT-TRIM","cl_string_left_trim"},
{"STRING-LESSP","cl_string_lessp"},
{"STRING-NOT-EQUAL","cl_string_not_equal"},
{"STRING-NOT-GREATERP","cl_string_not_greaterp"},
{"STRING-NOT-LESSP","cl_string_not_lessp"},
{"STRING-RIGHT-TRIM","cl_string_right_trim"},
{"STRING-STREAM",NULL},
{"STRING-TRIM","cl_string_trim"},
{"STRING-UPCASE","cl_string_upcase"},
{"STRING/=","cl_stringNE"},
{"STRING<","cl_stringL"},
{"STRING<=","cl_stringLE"},
{"STRING=","cl_stringE"},
{"STRING>","cl_stringG"},
{"STRING>=","cl_stringGE"},
{"STRINGP","cl_stringp"},
{"STRUCTURE",NULL},
{"STYLE-WARNING",NULL},
{"SUBLIS","cl_sublis"},
{"SUBSEQ","cl_subseq"},
{"SUBSETP","ECL_NAME(cl_subsetp)"},
{"SUBST","cl_subst"},
{"SUBST-IF","ECL_NAME(cl_subst_if)"},
{"SUBST-IF-NOT","ECL_NAME(cl_subst_if_not)"},
{"SUBSTITUTE","ECL_NAME(cl_substitute)"},
{"SUBSTITUTE-IF","ECL_NAME(cl_substitute_if)"},
{"SUBSTITUTE-IF-NOT","ECL_NAME(cl_substitute_if_not)"},
{"SUBTYPEP","ECL_NAME(cl_subtypep)"},
{"SVREF","cl_svref"},
{"SXHASH","cl_sxhash"},
{"SYMBOL",NULL},
{"SYMBOL-FUNCTION","cl_symbol_function"},
{"SYMBOL-MACROLET",NULL},
{"SYMBOL-NAME","cl_symbol_name"},
{"SYMBOL-PACKAGE","cl_symbol_package"},
{"SYMBOL-PLIST","cl_symbol_plist"},
{"SYMBOL-VALUE","cl_symbol_value"},
{"SYMBOLP","cl_symbolp"},
{"SYNONYM-STREAM",NULL},
{"SYNONYM-STREAM-SYMBOL","cl_synonym_stream_symbol"},
{"TAGBODY",NULL},
{"TAILP","cl_tailp"},
{"TAN","cl_tan"},
{"TANH","cl_tanh"},
{"TENTH","cl_tenth"},
{"TERPRI","cl_terpri"},
{"THE",NULL},
{"THIRD","cl_caddr"},
{"THROW",NULL},
{"TIME",NULL},
{"TRACE",NULL},
{"TRANSLATE-LOGICAL-PATHNAME","cl_translate_logical_pathname"},
{"TRANSLATE-PATHNAME","cl_translate_pathname"},
{"TREE-EQUAL","cl_tree_equal"},
{"TRUENAME","cl_truename"},
{"TRUNCATE","cl_truncate"},
{"TWO-WAY-STREAM",NULL},
{"TWO-WAY-STREAM-INPUT-STREAM","cl_two_way_stream_input_stream"},
{"TWO-WAY-STREAM-OUTPUT-STREAM","cl_two_way_stream_output_stream"},
{"TYPE",NULL},
{"TYPE-ERROR",NULL},
{"TYPE-ERROR-DATUM",NULL},
{"TYPE-ERROR-EXPECTED-TYPE",NULL},
{"TYPE-OF","cl_type_of"},
{"TYPECASE",NULL},
{"TYPEP","ECL_NAME(cl_typep)"},
{"UNBOUND-SLOT",NULL},
{"UNBOUND-SLOT-INSTANCE",NULL},
{"UNBOUND-VARIABLE",NULL},
{"UNDEFINED-FUNCTION",NULL},
{"UNEXPORT","cl_unexport"},
{"UNINTERN","cl_unintern"},
{"UNION","ECL_NAME(cl_union)"},
{"UNLESS",NULL},
{"UNREAD-CHAR","cl_unread_char"},
{"UNSIGNED-BYTE",NULL},
{"UNTRACE",NULL},
{"UNUSE-PACKAGE","cl_unuse_package"},
{"UNWIND-PROTECT",NULL},
{"UPGRADED-ARRAY-ELEMENT-TYPE","ECL_NAME(cl_upgraded_array_element_type)"},
{"UPGRADED-COMPLEX-PART-TYPE","ECL_NAME(cl_upgraded_complex_part_type)"},
{"UPPER-CASE-P","cl_upper_case_p"},
{"USE-PACKAGE","cl_use_package"},
{"USE-VALUE","ECL_NAME(cl_use_value)"},
{"USER-HOMEDIR-PATHNAME","cl_user_homedir_pathname"},
{"VALUES","cl_values"},
{"VALUES-LIST","cl_values_list"},
{"VARIABLE",NULL},
{"VECTOR","ECL_NAME(cl_vector)"},
{"VECTOR-POP","ECL_NAME(cl_vector_pop)"},
{"VECTOR-PUSH","cl_vector_push"},
{"VECTOR-PUSH-EXTEND","cl_vector_push_extend"},
{"VECTORP","cl_vectorp"},
{"WARN",NULL},
{"WARNING",NULL},
{"WHEN",NULL},
{"WILD-PATHNAME-P","cl_wild_pathname_p"},
{"WITH-COMPILATION-UNIT",NULL},
{"WITH-CONDITION-RESTARTS",NULL},
{"WITH-HASH-TABLE-ITERATOR",NULL},
{"WITH-INPUT-FROM-STRING",NULL},
{"WITH-OPEN-FILE",NULL},
{"WITH-OPEN-STREAM",NULL},
{"WITH-OUTPUT-TO-STRING",NULL},
{"WITH-PACKAGE-ITERATOR",NULL},
{"WITH-SIMPLE-RESTART",NULL},
{"WITH-STANDARD-IO-SYNTAX",NULL},
{"WRITE","cl_write"},
{"WRITE-BYTE","cl_write_byte"},
{"WRITE-CHAR","cl_write_char"},
{"WRITE-LINE","cl_write_line"},
{"WRITE-SEQUENCE","cl_write_sequence"},
{"WRITE-STRING","cl_write_string"},
{"WRITE-TO-STRING","ECL_NAME(cl_write_to_string)"},
{"Y-OR-N-P","ECL_NAME(cl_y_or_n_p)"},
{"YES-OR-NO-P","ECL_NAME(cl_yes_or_no_p)"},
{"ZEROP","cl_zerop"},

#ifdef CLOS
{"ALLOCATE-INSTANCE",NULL},
{"ADD-METHOD",NULL},
{"BUILT-IN-CLASS",NULL},
{"CALL-METHOD",NULL},
{"CALL-NEXT-METHOD",NULL},
{"CHANGE-CLASS",NULL},
{"CLASS",NULL},
{"CLASS-NAME",NULL},
{"CLASS-OF","cl_class_of"},
{"COMPUTE-APPLICABLE-METHODS",NULL},
{"DEFCLASS",NULL},
{"DEFGENERIC",NULL},
{"DEFINE-METHOD-COMBINATION",NULL},
{"DEFMETHOD",NULL},
{"DESCRIBE-OBJECT",NULL},
{"ENSURE-GENERIC-FUNCTION",NULL},
{"FIND-CLASS","cl_find_class"},
{"FIND-METHOD",NULL},
{"GENERIC-FUNCTION",NULL},
{"IF",NULL},
{"INITIALIZE-INSTANCE",NULL},
{"INVALID-METHOD-ERROR","ECL_NAME(cl_invalid_method_error)"},
{"MAKE-INSTANCE",NULL},
{"MAKE-INSTANCES-OBSOLETE",NULL},
{"MAKE-LOAD-FORM",NULL},
{"MAKE-LOAD-FORM-SAVING-SLOTS",NULL},
{"MAKE-METHOD",NULL},
{"METHOD",NULL},
{"METHOD-COMBINATION-ERROR","ECL_NAME(cl_method_combination_error)"},
{"METHOD-COMBINATION",NULL},
{"METHOD-QUALIFIERS",NULL},
{"NEXT-METHOD-P",NULL},
{"NO-APPLICABLE-METHOD",NULL},
{"NO-NEXT-METHOD",NULL},
{"PRINT-OBJECT",NULL},
{"PRINT-UNREADABLE-OBJECT",NULL},
{"REINITIALIZE-INSTANCE",NULL},
{"REMOVE-METHOD",NULL},
{"SHARED-INITIALIZE",NULL},
{"SLOT-BOUNDP","ECL_NAME(cl_slot_boundp)"},
{"SLOT-EXISTS-P","ECL_NAME(cl_slot_exists_p)"},
{"SLOT-MAKUNBOUND","ECL_NAME(cl_slot_makunbound)"},
{"SLOT-MISSING",NULL},
{"SLOT-UNBOUND",NULL},
{"SLOT-VALUE","cl_slot_value"},
{"STANDARD",NULL},
{"STANDARD-CLASS",NULL},
{"STANDARD-GENERIC-FUNCTION",NULL},
{"STANDARD-METHOD",NULL},
{"STANDARD-OBJECT",NULL},
{"STRUCTURE-CLASS",NULL},
{"STRUCTURE-OBJECT",NULL},
{"UPDATE-INSTANCE-FOR-DIFFERENT-CLASS",NULL},
{"UPDATE-INSTANCE-FOR-REDEFINED-CLASS",NULL},
{"WITH-ACCESSORS",NULL},
{"WITH-SLOTS",NULL},
{KEY_ "ACCESSOR",NULL},
{KEY_ "ARGUMENT-PRECEDENCE-ORDER",NULL},
{KEY_ "ALLOCATION",NULL},
{KEY_ "DECLARE",NULL},
{KEY_ "DEFAULT-INITARGS",NULL},
{KEY_ "DESCRIPTION",NULL},
{KEY_ "DIRECT-DEFAULT-INITARGS",NULL},
{KEY_ "DIRECT-SLOTS",NULL},
{KEY_ "DIRECT-SUPERCLASSES",NULL},
{KEY_ "GENERIC-FUNCTION-CLASS",NULL},
{KEY_ "IDENTITY-WITH-ONE-ARGUMENT",NULL},
{KEY_ "INITARG",NULL},
{KEY_ "INITARGS",NULL},
{KEY_ "INITFORM",NULL},
{KEY_ "INITFUNCTION",NULL},
{KEY_ "LAMBDA-LIST",NULL},
{KEY_ "LOCATION",NULL},
{KEY_ "METACLASS",NULL},
{KEY_ "METHOD",NULL},
{KEY_ "METHOD-CLASS",NULL},
{KEY_ "METHOD-COMBINATION",NULL},
{KEY_ "OPERATOR",NULL},
{KEY_ "ORDER",NULL},
{KEY_ "READER",NULL},
{KEY_ "READERS",NULL},
{KEY_ "REQUIRED",NULL},
{KEY_ "WRITER",NULL},
{KEY_ "WRITERS",NULL},
#endif

/* SYSTEM PACKAGE */
{SYS_ "#!",NULL},
{SYS_ "*BACKQ-LEVEL*",NULL},
{SYS_ "*CBLOCK*",NULL},
{SYS_ "*CIRCLE-COUNTER*",NULL},
{SYS_ "*CIRCLE-STACK*",NULL},
{SYS_ "*CLASS-NAME-HASH-TABLE*",NULL},
{SYS_ "*COMPILER-CONSTANTS*",NULL},
{SYS_ "*GC-MESSAGE*",NULL},
{SYS_ "*GC-VERBOSE*",NULL},
{SYS_ "*IGNORE-EOF-ON-TERMINAL-IO*",NULL},
{SYS_ "*INDENT-FORMATTED-OUTPUT*",NULL},
{SYS_ "*INIT-FUNCTION-PREFIX*",NULL},
{EXT_ "*INTERRUPTS-ENABLED*",NULL},
{SYS_ "*KEEP-DEFINITIONS*",NULL},
{EXT_ "*LOAD-HOOKS*",NULL},
{SYS_ "*LOAD-SEARCH-LIST*",NULL},
{SYS_ "*MAKE-CONSTANT","si_Xmake_constant"},
{SYS_ "*MAKE-SPECIAL","si_Xmake_special"},
{SYS_ "*PRINT-PACKAGE*",NULL},
{SYS_ "*PRINT-STRUCTURE*",NULL},
{SYS_ "*SHARP-EQ-CONTEXT*",NULL},
{SYS_ "*STEP-LEVEL*","OBJNULL"},
{SYS_ "*STEP-ACTION*","OBJNULL"},
{SYS_ ".",NULL},
{SYS_ "UNQUOTE",NULL},
{SYS_ "UNQUOTE-NSPLICE",NULL},
{SYS_ "UNQUOTE-SPLICE",NULL},
{SYS_ "ALLOCATE-RAW-INSTANCE","si_allocate_raw_instance"},
{EXT_ "ARGC","si_argc"},
{EXT_ "ARGV","si_argv"},
{SYS_ "ASET","si_aset"},
{SYS_ "BASE-CHAR-P","si_base_char_p"},
{SYS_ "BASE-STRING-P","si_base_string_p"},
{SYS_ "BC-DISASSEMBLE","si_bc_disassemble"},
{SYS_ "BC-SPLIT","si_bc_split"},
{SYS_ "BC-JOIN","si_bc_join"},
{SYS_ "BDS-TOP","si_bds_top"},
{SYS_ "BDS-VAL","si_bds_val"},
{SYS_ "BDS-VAR","si_bds_var"},
{SYS_ "BIT-ARRAY-OP","si_bit_array_op"},
{SYS_ "C-ARGUMENTS-LIMIT",NULL},
{SYS_ "CHAR-SET","si_char_set"},
{EXT_ "CHDIR","si_chdir"},
{SYS_ "CLEAR-COMPILER-PROPERTIES","cl_identity"},
{SYS_ "COERCE-TO-BASE-STRING","si_coerce_to_base_string"},
{SYS_ "COERCE-TO-EXTENDED-STRING","si_coerce_to_extended_string"},
{SYS_ "COERCE-TO-FILENAME","si_coerce_to_filename"},
{SYS_ "COERCE-TO-FUNCTION","si_coerce_to_function"},
{SYS_ "COERCE-TO-PACKAGE","si_coerce_to_package"},
{SYS_ "COPY-TO-SIMPLE-BASE-STRING","si_copy_to_simple_base_string"},
{SYS_ "COMPILED-FUNCTION-BLOCK","si_compiled_function_block"},
{EXT_ "COMPILED-FUNCTION-NAME","si_compiled_function_name"},
{SYS_ "COPY-STREAM","si_copy_stream"},
{SYS_ "DO-READ-SEQUENCE","si_do_read_sequence"},
{SYS_ "DO-WRITE-SEQUENCE","si_do_write_sequence"},
{SYS_ "ELT-SET","si_elt_set"},
{SYS_ "EVAL-WITH-ENV","si_eval_with_env"},
{SYS_ "EXPAND-DEFMACRO",NULL},
{SYS_ "FILE-COLUMN","si_file_column"},
{EXT_ "FILE-KIND","si_file_kind"},
{SYS_ "FILL-POINTER-SET","si_fill_pointer_set"},
{EXT_ "FILE-STREAM-FD","si_file_stream_fd"},
{EXT_ "FIXNUMP","si_fixnump"},
{SYS_ "FORMAT-ERROR",NULL},
#ifdef ECL_CMU_FORMAT
{SYS_ "FORMATTER-AUX",NULL},
#else
{SYS_ "FORMATTER-AUX","si_formatter_aux"},
#endif
{SYS_ "FRS-BDS","si_frs_bds"},
{SYS_ "FRS-IHS","si_frs_ihs"},
{SYS_ "FRS-TAG","si_frs_tag"},
{SYS_ "FRS-TOP","si_frs_top"},
{SYS_ "FSET","si_fset"},
{SYS_ "FUNCTION-BLOCK-NAME","si_function_block_name"},
{SYS_ "GET-LIBRARY-PATHNAME","si_get_library_pathname"},
{SYS_ "GET-SYSPROP","si_get_sysprop"},
{EXT_ "GETENV","si_getenv"},
{EXT_ "GETCWD","si_getcwd"},
{EXT_ "GETPID","si_getpid"},
{EXT_ "GETUID","si_getuid"},
{SYS_ "HASH-SET","si_hash_set"},
{SYS_ "HASH-TABLE-ITERATOR","si_hash_table_iterator"},
{SYS_ "IHS-BDS","si_ihs_bds"},
{SYS_ "IHS-ENV","si_ihs_env"},
{SYS_ "IHS-FUN","si_ihs_fun"},
{SYS_ "IHS-NEXT","si_ihs_next"},
{SYS_ "IHS-PREV","si_ihs_prev"},
{SYS_ "IHS-TOP","si_ihs_top"},
{SYS_ "INTERPRETER-STACK","si_interpreter_stack"},
{SYS_ "LINK-FROM",NULL},
{SYS_ "LINK-TO",NULL},
{SYS_ "LOAD-SOURCE","si_load_source"},
{SYS_ "LOGICAL-PATHNAME-P","si_logical_pathname_p"},
{SYS_ "MACRO",NULL},
{SYS_ "MAKE-LAMBDA","si_make_lambda"},
{SYS_ "MAKE-PURE-ARRAY","si_make_pure_array"},
{SYS_ "MAKE-STRING-OUTPUT-STREAM-FROM-STRING","si_make_string_output_stream_from_string"},
{SYS_ "MAKE-STRUCTURE","si_make_structure"},
{SYS_ "MAKE-VECTOR","si_make_vector"},
{SYS_ "MANGLE-NAME","si_mangle_name"},
{SYS_ "MEMBER1","si_member1"},
{SYS_ "MEMQ","si_memq"},
{SYS_ "MKDIR","si_mkdir"},
{EXT_ "MKSTEMP","si_mkstemp"},
{SYS_ "RMDIR","si_rmdir"},
{EXT_ "MAKE-PIPE","si_make_pipe"},
{EXT_ "PACKAGE-LOCK","si_package_lock"},
{SYS_ "PACKAGE-HASH-TABLES","si_package_hash_tables"},
{SYS_ "PATHNAME-TRANSLATIONS","si_pathname_translations"},
{SYS_ "POINTER","si_pointer"},
{SYS_ "PRETTY-PRINT-FORMAT",NULL},
{SYS_ "PROCESS-DECLARATIONS","si_process_declarations"},
{SYS_ "PROCESS-LAMBDA","si_process_lambda"},
{SYS_ "PROCESS-LAMBDA-LIST","si_process_lambda_list"},
{SYS_ "PUT-F","si_put_f"},
{SYS_ "PUT-PROPERTIES","si_put_properties"},
{SYS_ "PUT-SYSPROP","si_put_sysprop"},
{SYS_ "PUTPROP","si_putprop"},
{SYS_ "READTABLE-CASE-SET","si_readtable_case_set"},
{SYS_ "REM-F","si_rem_f"},
{SYS_ "REM-SYSPROP","si_rem_sysprop"},
{SYS_ "REPLACE-ARRAY","si_replace_array"},
{SYS_ "ROW-MAJOR-ASET","si_row_major_aset"},
{EXT_ "RUN-PROGRAM","si_run_program"},
{SYS_ "WAIT-FOR-ALL-PROCESSES","si_wait_for_all_processes"},
{EXT_ "SAFE-EVAL","ECL_NAME(si_safe_eval)"},
{SYS_ "SCH-FRS-BASE","si_sch_frs_base"},
{SYS_ "SCHAR-SET","si_char_set"},
{SYS_ "SHARP-A-READER",NULL},
{SYS_ "SHARP-S-READER",NULL},
{SYS_ "SELECT-PACKAGE","si_select_package"},
{SYS_ "SET-SYMBOL-PLIST","si_set_symbol_plist"},
#if defined(HAVE_PUTENV) || defined(HAVE_SETENV)
{EXT_ "SETENV","si_setenv"},
#else
{EXT_ "SETENV",NULL},
#endif
{SYS_ "SETF-METHOD",NULL},
{SYS_ "SETF-NAMEP",NULL},
{SYS_ "SIMPLE-PROGRAM-ERROR","ECL_NAME(si_simple_program_error)"},
{SYS_ "SIGNAL-SIMPLE-ERROR","si_signal_simple_error"},
{SYS_ "SIGNAL-TYPE-ERROR","si_signal_type_error"},
{SYS_ "SPECIALP","si_specialp"},
{SYS_ "STANDARD-READTABLE","si_standard_readtable"},
{SYS_ "STEPPER","OBJNULL"},
{SYS_ "BASE-STRING-CONCATENATE","si_base_string_concatenate"},
{SYS_ "STRING-TO-OBJECT","ECL_NAME(si_string_to_object)"},
{SYS_ "STRUCTURE-NAME","si_structure_name"},
{SYS_ "STRUCTURE-PRINT-FUNCTION",NULL},
{SYS_ "STRUCTURE-REF","si_structure_ref"},
{SYS_ "STRUCTURE-SET","si_structure_set"},
{SYS_ "STRUCTURE-SLOT-DESCRIPTIONS",NULL},
{SYS_ "STRUCTURE-SUBTYPE-P","si_structure_subtype_p"},
{SYS_ "STRUCTUREP","si_structurep"},
{SYS_ "SVSET","si_svset"},
{SYS_ "SYMBOL-MACRO",NULL},
{EXT_ "SYSTEM","ECL_NAME(si_system)"},
{SYS_ "TERMINAL-INTERRUPT",NULL},
{SYS_ "TOP-LEVEL",NULL},
{SYS_ "UNIVERSAL-ERROR-HANDLER",NULL},
{SYS_ "VALID-FUNCTION-NAME-P","si_valid_function_name_p"},
{SYS_ "WRITE-OBJECT","si_write_object"},
{SYS_ "WRITE-UGLY-OBJECT","si_write_ugly_object"},

#ifndef CLOS
{SYS_ "STRUCTURE-INCLUDE",NULL},
#else
{SYS_ "COPY-INSTANCE","si_copy_instance"},
{SYS_ "GENERIC-FUNCTION-P","si_generic_function_p"},
{SYS_ "INSTANCE-REF","si_instance_ref"},
{SYS_ "INSTANCE-SET","si_instance_set"},
{SYS_ "INSTANCE-SIG","si_instance_sig"},
{SYS_ "INSTANCE-SIG-SET","si_instance_sig_set"},
{SYS_ "INSTANCE-CLASS","si_instance_class"},
{SYS_ "INSTANCE-CLASS-SET","si_instance_class_set"},
{SYS_ "INSTANCEP","si_instancep"},
{SYS_ "SL-BOUNDP","si_sl_boundp"},
{SYS_ "SL-MAKUNBOUND","si_sl_makunbound"},
{SYS_ "SUBCLASSP","ECL_NAME(si_subclassp)"},
{SYS_ "OF-CLASS-P","ECL_NAME(si_of_class_p)"},
/*{SYS_ "UNBOUND","si_unbound"}, */
#endif

{EXT_ "*SOURCE-LOCATION*",NULL},
{EXT_ "*REGISTER-WITH-PDE-HOOK*",NULL},
{EXT_ "REGISTER-WITH-PDE",NULL},

/* #ifdef PROFILE */
{SYS_ "PROFILE",IF_PROFILE("si_profile")},
{SYS_ "CLEAR-PROFILE",IF_PROFILE("si_clear_profile")},
{SYS_ "DISPLAY-PROFILE",IF_PROFILE("si_display_profile")},
/* #endif PROFILE */

/* #ifdef TCP */
{SYS_ "*PROFILE-ARRAY*",NULL},
{SYS_ "OPEN-CLIENT-STREAM",IF_TCP("si_open_client_stream")},
{SYS_ "OPEN-SERVER-STREAM",IF_TCP("si_open_server_stream")},
{SYS_ "OPEN-UNIX-SOCKET-STREAM",IF_TCP("si_open_unix_socket_stream")},
{SYS_ "LOOKUP-HOST-ENTRY",IF_TCP("si_lookup_host_entry")},
/* #endif TCP */

{EXT_ "CATCH-SIGNAL","si_catch_signal"},
{EXT_ "GET-SIGNAL-HANDLER","si_get_signal_handler"},
{EXT_ "SET-SIGNAL-HANDLER","si_set_signal_handler"},

/* KEYWORD PACKAGE */
{KEY_ "ADJUSTABLE",NULL},
{KEY_ "ABORT",NULL},
{KEY_ "ABSOLUTE",NULL},
{KEY_ "ALLOW-OTHER-KEYS",NULL},
{KEY_ "APPEND",NULL},
{KEY_ "ARRAY",NULL},
{KEY_ "BACK",NULL},
{KEY_ "BASE",NULL},
{KEY_ "BLOCK",NULL},
{KEY_ "CAPITALIZE",NULL},
{KEY_ "CATCH",NULL},
{KEY_ "CASE",NULL},
{KEY_ "CIRCLE",NULL},
{KEY_ "COMPILE-TOPLEVEL",NULL},
{KEY_ "COMMON",NULL},
{KEY_ "CONC-NAME",NULL},
{KEY_ "CONSTRUCTOR",NULL},
{KEY_ "CONTROL-STRING",NULL},
{KEY_ "COPIER",NULL},
{KEY_ "CREATE",NULL},
{KEY_ "DATUM",NULL},
{KEY_ "DEFAULT",NULL},
{KEY_ "DEFAULTS",NULL},
{KEY_ "DEVICE",NULL},
{KEY_ "DIRECTION",NULL},
{KEY_ "DIRECTORY",NULL},
{KEY_ "DISPLACED-INDEX-OFFSET",NULL},
{KEY_ "DISPLACED-TO",NULL},
{KEY_ "DOCUMENTATION",NULL},
{KEY_ "DOWNCASE",NULL},
{KEY_ "ELEMENT-TYPE",NULL},
{KEY_ "END",NULL},
{KEY_ "END1",NULL},
{KEY_ "END2",NULL},
{KEY_ "EOF",NULL},
{KEY_ "ERROR",NULL},
{KEY_ "ESCAPE",NULL},
{KEY_ "EXECUTE",NULL},
{KEY_ "EXPECTED-TYPE",NULL},
{KEY_ "EXPORT",NULL},
{KEY_ "EXPORT-FROM",NULL},
{KEY_ "EXTERNAL",NULL},
{KEY_ "EXTERNAL-FORMAT",NULL},
{KEY_ "FILE",NULL},
{KEY_ "FILL-POINTER",NULL},
{KEY_ "FORMAT-ARGUMENTS",NULL},
{KEY_ "FORMAT-CONTROL",NULL},
{KEY_ "FUNCTION",NULL},
{KEY_ "GENSYM",NULL},
{KEY_ "HOST",NULL},
{KEY_ "IF-DOES-NOT-EXIST",NULL},
{KEY_ "IF-EXISTS",NULL},
{KEY_ "IF-OUTPUT-EXISTS",NULL},
{KEY_ "IGNORE",NULL},
{KEY_ "IMPORT-FROM",NULL},
{KEY_ "INCLUDE",NULL},
{KEY_ "INHERITED",NULL},
{KEY_ "INITIAL-ELEMENT",NULL},
{KEY_ "INITIAL-CONTENTS",NULL},
{KEY_ "INITIAL-OFFSET",NULL},
{KEY_ "INPUT",NULL},
{KEY_ "INTERACTIVE",NULL},
{KEY_ "INSTANCE",NULL},
{KEY_ "INTERN",NULL},
{KEY_ "INTERNAL",NULL},
{KEY_ "INVERT",NULL},
{KEY_ "IO",NULL},
{KEY_ "JUNK-ALLOWED",NULL},
{KEY_ "KEY",NULL},
{KEY_ "LENGTH",NULL},
{KEY_ "LEVEL",NULL},
{KEY_ "LINES",NULL},
{KEY_ "LINK",NULL},
{KEY_ "LIST-ALL",NULL},
{KEY_ "LOCAL",NULL},
{KEY_ "LOCKABLE",NULL},
{KEY_ "LOAD-TOPLEVEL",NULL},
{KEY_ "MASK",NULL},
{KEY_ "MISER-WIDTH",NULL},
{KEY_ "NAME",NULL},
{KEY_ "NAMED",NULL},
{KEY_ "NEW-VERSION",NULL},
{KEY_ "NEWEST",NULL},
{KEY_ "NICKNAMES",NULL},
{KEY_ "OBJECT",NULL},
{KEY_ "OFFSET",NULL},
{KEY_ "OPERATION",NULL},
{KEY_ "OPERANDS",NULL},
{KEY_ "OUTPUT",NULL},
{KEY_ "OVERWRITE",NULL},
{KEY_ "PACKAGE",NULL},
{KEY_ "PATHNAME",NULL},
{KEY_ "PPRINT-DISPATCH",NULL},
{KEY_ "PREDICATE",NULL},
{KEY_ "PRESERVE",NULL},
{KEY_ "PRETTY",NULL},
{KEY_ "PRINT",NULL},
{KEY_ "PRINT-FUNCTION",NULL},
{KEY_ "PRINT-OBJECT",NULL},
{KEY_ "PROBE",NULL},
{KEY_ "PROCESS",NULL},
{KEY_ "RADIX",NULL},
{KEY_ "READABLY",NULL},
{KEY_ "REHASH-SIZE",NULL},
{KEY_ "REHASH-THRESHOLD",NULL},
{KEY_ "RELATIVE",NULL},
{KEY_ "RENAME",NULL},
{KEY_ "RENAME-AND-DELETE",NULL},
{KEY_ "REPORT",NULL},
{KEY_ "RIGHT-MARGIN",NULL},
{KEY_ "SET-DEFAULT-PATHNAME",NULL},
{KEY_ "SEARCH-LIST",NULL},
{KEY_ "SHADOW",NULL},
{KEY_ "SHADOWING-IMPORT",NULL},
{KEY_ "SIZE",NULL},
{KEY_ "SPECIAL",NULL},
{KEY_ "START",NULL},
{KEY_ "START1",NULL},
{KEY_ "START2",NULL},
{KEY_ "STREAM",NULL},
{KEY_ "SUPERSEDE",NULL},
{KEY_ "TAG",NULL},
{KEY_ "TEST",NULL},
{KEY_ "TEST-NOT",NULL},
{KEY_ "TYPE",NULL},
{KEY_ "UNSPECIFIC",NULL},
{KEY_ "UNMASK",NULL},
{KEY_ "UP",NULL},
{KEY_ "UPCASE",NULL},
{KEY_ "USE",NULL},
{KEY_ "CSTREAM",NULL},
{KEY_ "VERBOSE",NULL},
{KEY_ "VERSION",NULL},
{KEY_ "WILD",NULL},
{KEY_ "WILD-INFERIORS",NULL},
{KEY_ "WAIT",NULL},

{EXT_ "BYTE8",NULL},
{EXT_ "BYTE16",NULL},
{EXT_ "BYTE32",NULL},
{EXT_ "BYTE64",NULL},
{EXT_ "COMPILER-LET",NULL},
{EXT_ "INTEGER8",NULL},
{EXT_ "INTEGER16",NULL},
{EXT_ "INTEGER32",NULL},
{EXT_ "INTEGER64",NULL},
{EXT_ "LAMBDA-BLOCK",NULL},
{EXT_ "QUIT","si_quit"},
#ifdef CLOS
{EXT_ "GET-METHOD",NULL},
{EXT_ "INSTANCE",NULL},
#endif

{SYS_ "ALLOCATE-FOREIGN-DATA","si_allocate_foreign_data"},
{SYS_ "FIND-FOREIGN-SYMBOL","si_find_foreign_symbol"},
{SYS_ "FOREIGN-DATA",NULL},
{SYS_ "FOREIGN-DATA-ADDRESS","si_foreign_data_address"},
{SYS_ "FOREIGN-DATA-EQUAL","si_foreign_data_equal"},
{SYS_ "FOREIGN-DATA-P","si_foreign_data_p"},
{SYS_ "FOREIGN-DATA-POINTER","si_foreign_data_pointer"},
{SYS_ "FOREIGN-DATA-RECAST","si_foreign_data_recast"},
{SYS_ "FOREIGN-DATA-REF","si_foreign_data_ref"},
{SYS_ "FOREIGN-DATA-REF-ELT","si_foreign_data_ref_elt"},
{SYS_ "FOREIGN-DATA-SET","si_foreign_data_set"},
{SYS_ "FOREIGN-DATA-SET-ELT","si_foreign_data_set_elt"},
{SYS_ "FOREIGN-DATA-TAG","si_foreign_data_tag"},
{SYS_ "FOREIGN-ELT-TYPE-P","si_foreign_elt_type_p"},
{SYS_ "FREE-FOREIGN-DATA","si_free_foreign_data"},
{SYS_ "MAKE-FOREIGN-DATA-FROM-ARRAY","si_make_foreign_data_from_array"},
{SYS_ "LOAD-FOREIGN-MODULE","si_load_foreign_module"},
{SYS_ "UNLOAD-FOREIGN-MODULE","si_unload_foreign_module"},
{SYS_ "NULL-POINTER-P","si_null_pointer_p"},
{SYS_ "SIZE-OF-FOREIGN-ELT-TYPE","si_size_of_foreign_elt_type"},
{SYS_ "ALIGNMENT-OF-FOREIGN-ELT-TYPE","si_alignment_of_foreign_elt_type"},
{KEY_ "BYTE",NULL},
{KEY_ "CHAR",NULL},
{KEY_ "CSTRING",NULL},
{KEY_ "DOUBLE",NULL},
{KEY_ "FIXNUM",NULL},
{KEY_ "FLOAT",NULL},
{KEY_ "INT",NULL},
{KEY_ "INT8-T",NULL},
{KEY_ "INT16-T",NULL},
{KEY_ "INT32-T",NULL},
{KEY_ "INT64-T",NULL},
{KEY_ "LONG",NULL},
{KEY_ "LONG-LONG",NULL},
{KEY_ "POINTER-SELF",NULL},
{KEY_ "POINTER-VOID",NULL},
{KEY_ "SHORT",NULL},
{KEY_ "STRUCT",NULL},
{KEY_ "UNION",NULL},
{KEY_ "VOID",NULL},
{KEY_ "UINT8-T",NULL},
{KEY_ "UINT16-T",NULL},
{KEY_ "UINT32-T",NULL},
{KEY_ "UINT64-T",NULL},
{KEY_ "UNSIGNED-BYTE",NULL},
{KEY_ "UNSIGNED-CHAR",NULL},
{KEY_ "UNSIGNED-INT",NULL},
{KEY_ "UNSIGNED-LONG",NULL},
{KEY_ "UNSIGNED-LONG-LONG",NULL},
{KEY_ "UNSIGNED-SHORT",NULL},

#ifdef GBC_BOEHM
{EXT_ "GC","si_gc"},
{SYS_ "GC-DUMP","si_gc_dump"},
{SYS_ "GC-STATS","si_gc_stats"},
#else
{EXT_ "GC","si_gc"},
{SYS_ "ALLOCATE","si_allocate"},
{SYS_ "ALLOCATED-PAGES","si_allocated_pages"},
{SYS_ "MAXIMUM-ALLOCATABLE-PAGES","si_maximum_allocatable_pages"},
{SYS_ "ALLOCATE-CONTIGUOUS-PAGES","si_allocate_contiguous_pages"},
{SYS_ "ALLOCATED-CONTIGUOUS-PAGES","si_allocated_contiguous_pages"},
{SYS_ "MAXIMUM-CONTIGUOUS-PAGES","si_maximum_contiguous_pages"},
{SYS_ "GC-TIME","si_gc_time"},
{SYS_ "GET-HOLE-SIZE","si_get_hole_size"},
{SYS_ "SET-HOLE-SIZE","si_set_hole_size"},
{SYS_ "IGNORE-MAXIMUM-PAGES","si_ignore_maximum_pages"},
{SYS_ "ROOM-REPORT","si_room_report"},
{SYS_ "RESET-GC-COUNT","si_reset_gc_count"},
#endif /* !GBC_BOEHM */

/* #ifdef ECL_THREADS */
{MP_ "PROCESS",NULL},
{MP_ "LOCK",NULL},
{MP_ "CONDITION-VARIABLE",NULL},
{MP_ "*CURRENT-PROCESS*",NULL},
{MP_ "ALL-PROCESSES",IF_MP("mp_all_processes")},
{MP_ "EXIT-PROCESS",IF_MP("mp_exit_process")},
{MP_ "MAKE-PROCESS",IF_MP("mp_make_process")},
{MP_ "PROCESS-ACTIVE-P",IF_MP("mp_process_active_p")},
{MP_ "PROCESS-ENABLE",IF_MP("mp_process_enable")},
{MP_ "PROCESS-YIELD",IF_MP("mp_process_yield")},
{MP_ "PROCESS-KILL",IF_MP("mp_process_kill")},
{MP_ "PROCESS-NAME",IF_MP("mp_process_name")},
{MP_ "PROCESS-PRESET",IF_MP("mp_process_preset")},
{MP_ "PROCESS-RUN-FUNCTION",IF_MP("mp_process_run_function")},
{MP_ "PROCESS-WHOSTATE",IF_MP("mp_process_whostate")},
{MP_ "PROCESS-JOIN",IF_MP("mp_process_join")},
{MP_ "MAKE-LOCK",IF_MP("mp_make_lock")},
{KEY_ "RECURSIVE",NULL},
{MP_ "RECURSIVE-LOCK-P",IF_MP("mp_recursive_lock_p")},
{MP_ "LOCK-NAME",IF_MP("mp_lock_name")},
{MP_ "LOCK-OWNER",IF_MP("mp_lock_owner")},
{MP_ "LOCK-COUNT",IF_MP("mp_lock_count")},
{MP_ "GET-LOCK",IF_MP("mp_get_lock")},
{MP_ "GIVEUP-LOCK",IF_MP("mp_giveup_lock")},
{MP_ "MAKE-CONDITION-VARIABLE",IF_MP("mp_make_condition_variable")},
{MP_ "CONDITION-VARIABLE-WAIT",IF_MP("mp_condition_variable_wait")},
{MP_ "CONDITION-VARIABLE-TIMEDWAIT",IF_MP("mp_condition_variable_timedwait")},
{MP_ "CONDITION-VARIABLE-SIGNAL",IF_MP("mp_condition_variable_signal")},
{MP_ "CONDITION-VARIABLE-BROADCAST",IF_MP("mp_condition_variable_broadcast")},
{KEY_ "INITIAL-BINDINGS",NULL},
{MP_ "INTERRUPT-PROCESS",IF_MP("mp_interrupt_process")},
{MP_ "+LOAD-COMPILE-LOCK+",NULL},
{MP_ "WITH-LOCK",NULL},
{MP_ "BLOCK-SIGNALS",IF_MP("mp_block_signals")},
{MP_ "RESTORE-SIGNALS",IF_MP("mp_restore_signals")},
{MP_ "PROCESS-SUSPEND",IF_MP("mp_process_suspend")},
{MP_ "PROCESS-RESUME",IF_MP("mp_process_resume")},
{MP_ "SUSPEND-LOOP",IF_MP("mp_suspend_loop")},
{MP_ "BREAK-SUSPEND-LOOP",IF_MP("mp_break_suspend_loop")},
{MP_ "MAKE-RWLOCK",IF_MP("mp_make_rwlock")},
{MP_ "RWLOCK",NULL},
{MP_ "RWLOCK-NAME",IF_MP("mp_rwlock_name")},
{MP_ "GET-RWLOCK-READ",IF_MP("mp_get_rwlock_read")},
{MP_ "GET-RWLOCK-WRITE",IF_MP("mp_get_rwlock_write")},
{MP_ "GIVEUP-RWLOCK-READ",IF_MP("mp_giveup_rwlock_read")},
{MP_ "GIVEUP-RWLOCK-WRITE",IF_MP("mp_giveup_rwlock_write")},
{MP_ "GLOBAL-LOCK",NULL},
{MP_ "ERROR-LOCK",NULL},

{MP_ "SEMAPHORE",NULL},
{MP_ "MAKE-SEMAPHORE",IF_MP("mp_make_semaphore")},
{MP_ "SIGNAL-SEMAPHORE",IF_MP("mp_signal_semaphore")},
{MP_ "WAIT-ON-SEMAPHORE",IF_MP("mp_wait_on_semaphore")},
{MP_ "SEMAPHORE-COUNT",IF_MP("mp_semaphore_count")},
{MP_ "SEMAPHORE-NAME",IF_MP("mp_semaphore_name")},
{MP_ "SEMAPHORE-WAIT-COUNT",IF_MP("mp_semaphore_wait_count")},
{KEY_ "COUNT",NULL},

{MP_ "BARRIER",NULL},
{MP_ "MAKE-BARRIER",IF_MP("mp_make_barrier")},
{MP_ "BARRIER-UNBLOCK",IF_MP("mp_barrier_unblock")},
{MP_ "BARRIER-WAIT",IF_MP("mp_barrier_wait")},
{MP_ "BARRIER-COUNT",IF_MP("mp_barrier_count")},
{MP_ "BARRIER-NAME",IF_MP("mp_barrier_name")},
{MP_ "BARRIER-ARRIVERS-COUNT",IF_MP("mp_barrier_arrivers_count")},
{KEY_ "DISABLE",NULL},
{KEY_ "RESET-COUNT",NULL},
{KEY_ "KILL-WAITING",NULL},
{KEY_ "UNBLOCKED",NULL},

{MP_ "MAILBOX",NULL},
{MP_ "MAKE-MAILBOX",IF_MP("mp_make_mailbox")},
{MP_ "MAILBOX-NAME",IF_MP("mp_mailbox_name")},
{MP_ "MAILBOX-COUNT",IF_MP("mp_mailbox_count")},
{MP_ "MAILBOX-EMPTY-P",IF_MP("mp_mailbox_empty_p")},
{MP_ "MAILBOX-READ",IF_MP("mp_mailbox_read")},
{MP_ "MAILBOX-SEND",IF_MP("mp_mailbox_send")},
/* #endif defined(ECL_THREADS) */

{SYS_ "WHILE",NULL},
{SYS_ "UNTIL",NULL},
{SYS_ "QUASIQUOTE",NULL},
{SYS_ "*EXIT-HOOKS*",NULL},

#ifdef CLOS
{CLOS_ ".COMBINED-METHOD-ARGS.",NULL},
{CLOS_ "+BUILTIN-CLASSES+",NULL},
{CLOS_ "*NEXT-METHODS*",NULL},
{CLOS_ "*OPTIMIZE-SLOT-ACCESS*",NULL},
{CLOS_ "+THE-T-CLASS+",NULL},
{CLOS_ "+THE-CLASS+",NULL},
{CLOS_ "+THE-STD-CLASS+",NULL},
{CLOS_ "+THE-STANDARD-CLASS+",NULL},
{CLOS_ "+THE-FUNCALLABLE-STANDARD-CLASS+",NULL},
{CLOS_ "ACCESSOR-METHOD-SLOT-DEFINITION",NULL},
{CLOS_ "ADD-DEPENDENT",NULL},
{CLOS_ "ADD-DIRECT-METHOD",NULL},
{CLOS_ "ADD-DIRECT-SUBCLASS",NULL},
{CLOS_ "CLASS-DEFAULT-INITARGS",NULL},
{CLOS_ "CLASS-DIRECT-DEFAULT-INITARGS",NULL},
{CLOS_ "CLASS-DIRECT-SLOTS",NULL},
{CLOS_ "CLASS-DIRECT-SUBCLASSES",NULL},
{CLOS_ "CLASS-DIRECT-SUPERCLASSES",NULL},
{CLOS_ "CLASS-FINALIZED-P",NULL},
{CLOS_ "CLASS-PRECEDENCE-LIST",NULL},
{CLOS_ "CLASS-PROTOTYPE",NULL},
{CLOS_ "CLASS-SLOTS",NULL},
{CLOS_ "COMPUTE-APPLICABLE-METHODS-USING-CLASSES",NULL},
{CLOS_ "COMPUTE-CLASS-PRECEDENCE-LIST",NULL},
{CLOS_ "COMPUTE-DEFAULT-INITARGS",NULL},
{CLOS_ "COMPUTE-DISCRIMINATING-FUNCTION",NULL},
{CLOS_ "COMPUTE-EFFECTIVE-METHOD",NULL},
{CLOS_ "COMPUTE-EFFECTIVE-SLOT-DEFINITION",NULL},
{CLOS_ "COMPUTE-SLOTS",NULL},
{CLOS_ "DIRECT-SLOT-DEFINITION",NULL},
{CLOS_ "DIRECT-SLOT-DEFINITION-CLASS",NULL},
{CLOS_ "EFFECTIVE-SLOT-DEFINITION",NULL},
{CLOS_ "EFFECTIVE-SLOT-DEFINITION-CLASS",NULL},
{CLOS_ "ENSURE-CLASS",NULL},
{CLOS_ "ENSURE-CLASS-USING-CLASS",NULL},
{CLOS_ "ENSURE-GENERIC-FUNCTION-USING-CLASS",NULL},
{CLOS_ "EQL-SPECIALIZER",NULL},
{CLOS_ "EQL-SPECIALIZER-OBJECT",NULL},
{CLOS_ "EXTRACT-LAMBDA-LIST","ECL_NAME(clos_extract_lambda_list)"},
{CLOS_ "EXTRACT-SPECIALIZER-NAMES","ECL_NAME(clos_extract_specializer_names)"},
{CLOS_ "FINALIZE-INHERITANCE",NULL},
{CLOS_ "FIND-METHOD-COMBINATION",NULL},
{CLOS_ "FORWARD-REFERENCED-CLASS",NULL},
{CLOS_ "FUNCALLABLE-STANDARD-CLASS",NULL},
{CLOS_ "FUNCALLABLE-STANDARD-INSTANCE-ACCESS","ECL_NAME(clos_funcallable_standard_instance_access)"},
{CLOS_ "FUNCALLABLE-STANDARD-OBJECT",NULL},
{CLOS_ "GENERIC-FUNCTION-ARGUMENT-PRECEDENCE-ORDER",NULL},
{CLOS_ "GENERIC-FUNCTION-DECLARATIONS",NULL},
{CLOS_ "GENERIC-FUNCTION-LAMBDA-LIST",NULL},
{CLOS_ "GENERIC-FUNCTION-METHOD-CLASS",NULL},
{CLOS_ "GENERIC-FUNCTION-METHOD-COMBINATION",NULL},
{CLOS_ "GENERIC-FUNCTION-METHODS",NULL},
{CLOS_ "GENERIC-FUNCTION-NAME",NULL},
{CLOS_ "INTERN-EQL-SPECIALIZER",NULL},
{CLOS_ "LOCATION-TABLE",NULL},
{CLOS_ "MAKE-METHOD-LAMBDA",NULL},
{CLOS_ "MAP-DEPENDENTS",NULL},
{CLOS_ "METAOBJECT",NULL},
{CLOS_ "METHOD-FUNCTION",NULL},
{CLOS_ "METHOD-GENERIC-FUNCTION",NULL},
{CLOS_ "METHOD-LAMBDA-LIST",NULL},
{CLOS_ "METHOD-SPECIALIZERS",NULL},
{CLOS_ "NAME",NULL},
{CLOS_ "READER-METHOD-CLASS",NULL},
{CLOS_ "REMOVE-DEPENDENT",NULL},
{CLOS_ "REMOVE-DIRECT-METHOD",NULL},
{CLOS_ "REMOVE-DIRECT-SUBCLASS",NULL},
{CLOS_ "SET-FUNCALLABLE-INSTANCE-FUNCTION","clos_set_funcallable_instance_function"},
{CLOS_ "SLOT-BOUNDP-USING-CLASS",NULL},
{CLOS_ "SLOT-DEFINITION",NULL},
{CLOS_ "SLOT-DEFINITION-ALLOCATION",NULL},
{CLOS_ "SLOT-DEFINITION-INITARGS",NULL},
{CLOS_ "SLOT-DEFINITION-INITFORM",NULL},
{CLOS_ "SLOT-DEFINITION-INITFUNCTION",NULL},
{CLOS_ "SLOT-DEFINITION-LOCATION",NULL},
{CLOS_ "SLOT-DEFINITION-NAME",NULL},
{CLOS_ "SLOT-DEFINITION-READERS",NULL},
{CLOS_ "SLOT-DEFINITION-TYPE",NULL},
{CLOS_ "SLOT-DEFINITION-WRITERS",NULL},
{CLOS_ "SLOT-MAKUNBOUND-USING-CLASS",NULL},
{CLOS_ "SLOT-VALUE-USING-CLASS",NULL},
{CLOS_ "SLOT-VALUE-SET","clos_slot_value_set"},
{CLOS_ "SLOT-TABLE",NULL},
{CLOS_ "SPECIALIZER",NULL},
{CLOS_ "SPECIALIZER-DIRECT-GENERIC-FUNCTIONS",NULL},
{CLOS_ "SPECIALIZER-DIRECT-METHODS",NULL},
{CLOS_ "STANDARD-ACCESSOR-METHOD",NULL},
{CLOS_ "STANDARD-DIRECT-SLOT-DEFINITION",NULL},
{CLOS_ "STANDARD-EFFECTIVE-SLOT-DEFINITION",NULL},
{CLOS_ "STANDARD-INSTANCE-ACCESS","ECL_NAME(clos_standard_instance_access)"},
{CLOS_ "STANDARD-INSTANCE-SET","ECL_NAME(clos_standard_instance_set)"},
{CLOS_ "STANDARD-READER-METHOD",NULL},
{CLOS_ "STANDARD-SLOT-DEFINITION",NULL},
{CLOS_ "STANDARD-WRITER-METHOD",NULL},
{CLOS_ "STANDARD-OPTIMIZED-READER-METHOD",NULL},
{CLOS_ "STANDARD-OPTIMIZED-WRITER-METHOD",NULL},
{CLOS_ "STD-COMPUTE-APPLICABLE-METHODS","ECL_NAME(clos_std_compute_applicable_methods)"},
{CLOS_ "STD-COMPUTE-APPLICABLE-METHODS-USING-CLASSES",NULL},
{CLOS_ "STD-COMPUTE-EFFECTIVE-METHOD","ECL_NAME(clos_std_compute_effective_method)"},
{CLOS_ "COMPUTE-EFFECTIVE-METHOD-FUNCTION","ECL_NAME(clos_compute_effective_method_function)"},
{CLOS_ "UPDATE-DEPENDENT",NULL},
{CLOS_ "UPDATE-INSTANCE",NULL},
{CLOS_ "VALIDATE-SUPERCLASS",NULL},
{CLOS_ "WRITER-METHOD-CLASS",NULL},
{SYS_ "CLEAR-GFUN-HASH","si_clear_gfun_hash"},
{CLOS_ "NEED-TO-MAKE-LOAD-FORM-P","ECL_NAME(clos_need_to_make_load_form_p)"},
{CLOS_ "LOAD-DEFCLASS","ECL_NAME(clos_load_defclass)"},
{CLOS_ "DOCSTRING",NULL},
{CLOS_ "SAFE-INSTANCE-REF","clos_safe_instance_ref"},
#endif

{SYS_ "CL-FIXNUM-BITS",NULL},
{EXT_ "CL-FIXNUM",NULL},
{EXT_ "CL-INDEX",NULL},

{SYS_ "DO-DEFTYPE","ECL_NAME(si_do_deftype)"},
{SYS_ "CREATE-TYPE-NAME",NULL},
{SYS_ "*ALIEN-DECLARATIONS*",NULL},

#ifdef ENABLE_DLOPEN
{SYS_ "LOAD-BINARY","si_load_binary"},
#else
{SYS_ "LOAD-BINARY",NULL},
#endif

{SYS_ "*CODE-WALKER*",NULL},

/* #if defined(HAVE_LIBFFI) || defined(ECL_DYNAMIC_FFI) */
{SYS_ "CALL-CFUN",IF_DFFI("si_call_cfun")},
{KEY_ "CALLBACK",NULL},
{SYS_ "MAKE-DYNAMIC-CALLBACK",IF_DFFI("si_make_dynamic_callback")},
{SYS_ "FREE-FFI-CLOSURE",IF_LIBFFI("si_free_ffi_closure")},
/* #endif defined(HAVE_LIBFFI) || defined(ECL_DYNAMIC_FFI) */
{KEY_ "CDECL",NULL},
{KEY_ "STDCALL",NULL},

{SYS_ "TRAP-FPE","si_trap_fpe"},

{EXT_ "*ACTION-ON-UNDEFINED-VARIABLE*",NULL},

{SYS_ "SET-BUFFERING-MODE","si_set_buffering_mode"},
{KEY_ "NONE",NULL},
{KEY_ "LINE-BUFFERED",NULL},
{KEY_ "FULLY-BUFFERED",NULL},
{KEY_ "LINE",NULL},
{KEY_ "FULL",NULL},

{SYS_ "CMP-ENV-REGISTER-MACROLET",NULL},

{EXT_ "GET-FINALIZER","si_get_finalizer"},
{EXT_ "SET-FINALIZER","si_set_finalizer"},

/* #ifdef ECL_RELATIVE_PACKAGE_NAMES */
{SYS_ "*RELATIVE-PACKAGE-NAMES*",NULL},
{KEY_ "RELATIVE-PACKAGE-NAMES",NULL},
{SYS_ "FIND-RELATIVE-PACKAGE",IF_RELPACK("si_find_relative_package")},
{SYS_ "PACKAGE-PARENT",NULL},
{SYS_ "PACKAGE-CHILDREN",NULL},
/* #endif ECL_RELATIVE_PACKAGE_NAMES */

{SYS_ "WRONG-TYPE-ARGUMENT","si_wrong_type_argument"},

{SYS_ "*CURRENT-FORM*",NULL},

{SYS_ "CODE-BLOCK",NULL},

{SYS_ "FRAME",NULL},
{SYS_ "APPLY-FROM-STACK-FRAME","si_apply_from_stack_frame"},

/* #ifdef ECL_CLOS_STREAMS */
{GRAY_ "CLOSE",NULL},
{GRAY_ "STREAMP",NULL},
{GRAY_ "INPUT-STREAM-P",NULL},
{GRAY_ "OUTPUT-STREAM-P",NULL},
{GRAY_ "OPEN-STREAM-P",NULL},
{GRAY_ "STREAM-ADVANCE-TO-COLUMN",NULL},
{GRAY_ "STREAM-CLEAR-INPUT",NULL},
{GRAY_ "STREAM-CLEAR-OUTPUT",NULL},
{GRAY_ "STREAM-ELEMENT-TYPE",NULL},
{GRAY_ "STREAM-FILE-DESCRIPTOR",NULL},
{GRAY_ "STREAM-FILE-POSITION",NULL},
{GRAY_ "STREAM-FINISH-OUTPUT",NULL},
{GRAY_ "STREAM-FORCE-OUTPUT",NULL},
{GRAY_ "STREAM-FRESH-LINE",NULL},
{GRAY_ "STREAM-INTERACTIVE-P",NULL},
{GRAY_ "STREAM-LINE-COLUMN",NULL},
{GRAY_ "STREAM-LISTEN",NULL},
{GRAY_ "STREAM-PEEK-CHAR",NULL},
{GRAY_ "STREAM-READ-BYTE",NULL},
{GRAY_ "STREAM-READ-CHAR",NULL},
{GRAY_ "STREAM-READ-CHAR-NO-HANG",NULL},
{GRAY_ "STREAM-READ-LINE",NULL},
{GRAY_ "STREAM-READ-SEQUENCE",NULL},
{GRAY_ "STREAM-START-LINE-P",NULL},
{GRAY_ "STREAM-TERPRI",NULL},
{GRAY_ "STREAM-UNREAD-CHAR",NULL},
{GRAY_ "STREAM-WRITE-BYTE",NULL},
{GRAY_ "STREAM-WRITE-CHAR",NULL},
{GRAY_ "STREAM-WRITE-SEQUENCE",NULL},
{GRAY_ "STREAM-WRITE-STRING",NULL},
{GRAY_ "FUNDAMENTAL-STREAM",NULL},
{GRAY_ "FUNDAMENTAL-INPUT-STREAM",NULL},
{GRAY_ "FUNDAMENTAL-OUTPUT-STREAM",NULL},
{GRAY_ "FUNDAMENTAL-CHARACTER-STREAM",NULL},
{GRAY_ "FUNDAMENTAL-BINARY-STREAM",NULL},
{GRAY_ "FUNDAMENTAL-CHARACTER-INPUT-STREAM",NULL},
{GRAY_ "FUNDAMENTAL-CHARACTER-OUTPUT-STREAM",NULL},
{GRAY_ "FUNDAMENTAL-BINARY-INPUT-STREAM",NULL},
{GRAY_ "FUNDAMENTAL-BINARY-OUTPUT-STREAM",NULL},
/* #endif ECL_CLOS_STREAMS */

{SYS_ "LOG1P","si_log1p"},

{EXT_ "BC-FILE","si_compiled_function_file"},
{EXT_ "COMPILED-FUNCTION-FILE","si_compiled_function_file"},

{SYS_ "PROPERTY-LIST",NULL},

{SYS_ "BYTECODES",NULL},

{SYS_ "HASH-EQL","si_hash_eql"},
{SYS_ "HASH-EQUAL","si_hash_equal"},
{SYS_ "HASH-EQUALP","si_hash_equalp"},

{EXT_ "INTERACTIVE-INTERRUPT",NULL},

{EXT_ "STORAGE-EXHAUSTED",NULL},
{EXT_ "STACK-OVERFLOW",NULL},
{EXT_ "STACK-OVERFLOW-SIZE",NULL},
{EXT_ "STACK-OVERFLOW-TYPE",NULL},
{EXT_ "BINDING-STACK",NULL},
{EXT_ "FRAME-STACK",NULL},
{EXT_ "LISP-STACK",NULL},
{EXT_ "C-STACK",NULL},
{EXT_ "HEAP-SIZE",NULL},
{EXT_ "ILLEGAL-INSTRUCTION",NULL},
{EXT_ "SET-LIMIT","si_set_limit"},
{EXT_ "GET-LIMIT","si_get_limit"},
{EXT_ "SEGMENTATION-VIOLATION",NULL},

{EXT_ "EXTENDED-STRING",NULL},

{SYS_ "CHECK-PENDING-INTERRUPTS","si_check_pending_interrupts"},

{KEY_ "LATIN-1",NULL},
{KEY_ "ISO-8859-1",NULL},
{KEY_ "UTF-8",NULL},
{KEY_ "UCS-2",NULL},
{KEY_ "UCS-4",NULL},

{EXT_ "CONSTANTLY-T",NULL},
{EXT_ "CONSTANTLY-NIL",NULL},

{EXT_ "MAYBE-QUOTE",NULL},
{EXT_ "MAYBE-UNQUOTE",NULL},

{KEY_ "CR",NULL},
{KEY_ "LF",NULL},
{KEY_ "CRLF",NULL},
{KEY_ "UCS-2BE",NULL},
{KEY_ "UCS-4BE",NULL},
{KEY_ "UCS-2LE",NULL},
{KEY_ "UCS-4LE",NULL},

{EXT_ "LOAD-ENCODING",NULL},
{EXT_ "MAKE-ENCODING",NULL},
{EXT_ "ALL-ENCODINGS","ECL_NAME(si_load_encoding)"},

{KEY_ "US-ASCII",NULL},
{KEY_ "LITTLE-ENDIAN",NULL},
{KEY_ "BIG-ENDIAN",NULL},

{SYS_ "+UNICODE-DATABASE+",NULL},

{EXT_ "COPY-FILE","si_copy_file"},

{EXT_ "FILL-ARRAY-WITH-ELT","si_fill_array_with_elt"},

{EXT_ "+ECL-VERSION-NUMBER+",NULL},

{EXT_ "*BYTECODES-COMPILER*",NULL},

{EXT_ "SHORT-FLOAT-POSITIVE-INFINITY",NULL},
{EXT_ "SINGLE-FLOAT-POSITIVE-INFINITY",NULL},
{EXT_ "DOUBLE-FLOAT-POSITIVE-INFINITY",NULL},
{EXT_ "LONG-FLOAT-POSITIVE-INFINITY",NULL},
{EXT_ "SHORT-FLOAT-NEGATIVE-INFINITY",NULL},
{EXT_ "SINGLE-FLOAT-NEGATIVE-INFINITY",NULL},
{EXT_ "DOUBLE-FLOAT-NEGATIVE-INFINITY",NULL},
{EXT_ "LONG-FLOAT-NEGATIVE-INFINITY",NULL},
{EXT_ "FLOAT-NAN-P","si_float_nan_p"},
{EXT_ "FLOAT-INFINITY-P","si_float_infinity_p"},

{SYS_ "READ-OBJECT-OR-IGNORE","si_read_object_or_ignore"},

{EXT_ "FLOAT-NAN-STRING",NULL},
{EXT_ "FLOAT-INFINITY-STRING",NULL},

{EXT_ "READTABLE-LOCK","si_readtable_lock"},

{SYS_ "+IO-SYNTAX-PROGV-LIST+",NULL},
{SYS_ "+ECL-SYNTAX-PROGV-LIST+",NULL},
{SYS_ "WITH-ECL-IO-SYNTAX",NULL},

{SYS_ "STREAM-EXTERNAL-FORMAT-SET","si_stream_external_format_set"},

{KEY_ "SYSV",NULL},
{KEY_ "UNIX64",NULL},
{KEY_ "WIN64",NULL},

{EXT_ "WEAK-POINTER",NULL},
{EXT_ "MAKE-WEAK-POINTER","si_make_weak_pointer"},
{EXT_ "WEAK-POINTER-VALUE","si_weak_pointer_value"},

{SYS_ "*ALLOW-WITH-INTERRUPTS*",NULL},

{EXT_ "WITH-UNIQUE-NAMES",NULL},

{SYS_ "HANDLE-SIGNAL","si_handle_signal"},

{EXT_ "WITH-INTERRUPTS",NULL},
{EXT_ "WITHOUT-INTERRUPTS",NULL},
{EXT_ "WITH-LOCAL-INTERRUPTS",NULL},
{EXT_ "ALLOW-WITH-INTERRUPTS",NULL},

{SYS_ "*QUIT-TAG*",NULL},

{EXT_ "ARRAY-RAW-DATA","si_array_raw_data"},

{EXT_ "*PROGRAM-EXIT-CODE*",NULL},
{EXT_ "EXIT","si_exit"},

{EXT_ "ENVIRON","si_environ"},

{KEY_ "ENVIRON",NULL},

{EXT_ "MAKE-EXTERNAL-PROCESS",NULL},
{EXT_ "EXTERNAL-PROCESS",NULL},
{EXT_ "EXTERNAL-PROCESS-PID",NULL},
{EXT_ "EXTERNAL-PROCESS-INPUT",NULL},
{EXT_ "EXTERNAL-PROCESS-OUTPUT",NULL},
{EXT_ "EXTERNAL-PROCESS-STATUS",NULL},

{KEY_ "RUNNING",NULL},
{KEY_ "EXITED",NULL},
{KEY_ "SIGNALED",NULL},
{KEY_ "STOPPED",NULL},

{EXT_ "EXTERNAL-PROCESS-WAIT","si_external_process_wait"},

#if defined(ECL_MS_WINDOWS_HOST) || defined(cygwin)
{SYS_ "CLOSE-WINDOWS-HANDLE","si_close_windows_handle"},
#else
{SYS_ "CLOSE-WINDOWS-HANDLE",NULL},
#endif

{EXT_ "*INVOKE-DEBUGGER-HOOK*",NULL},

{EXT_ "*DOCUMENTATION-POOL*",NULL},
{EXT_ "ANNOTATE",NULL},
{EXT_ "GET-ANNOTATION",NULL},
{EXT_ "REMOVE-ANNOTATION",NULL},
{EXT_ "FUNCTION-LAMBDA-LIST",NULL},
{EXT_ "DEFAULT-ANNOTATION-LOGIC",NULL},
{EXT_ "OPTIONAL-ANNOTATION",NULL},
{EXT_ "LOCATION",NULL},

{EXT_ "LISP-IMPLEMENTATION-VCS-ID","ECL_NAME(si_lisp_implementation_vcs_id)"},

{SYS_ "SIGNAL-SERVICING",NULL},

{EXT_ "*DEFAULT-EXTERNAL-FORMAT*",NULL},
{KEY_ "PASS-THROUGH",NULL},

{EXT_ "WITH-BACKEND",NULL},
{KEY_ "BYTECODES",NULL},
{KEY_ "C/C++",NULL},

{EXT_ "ARRAY-INDEX",NULL},
{EXT_ "ANSI-STREAM",NULL},

{EXT_ "COMPLEX-ARRAY",NULL},

{SYS_ "SEQUENCE-START-END","si_sequence_start_end"},
{SYS_ "SEQUENCE-COUNT",NULL},
{SYS_ "SHRINK-VECTOR",NULL},
{SYS_ "COPY-SUBARRAY","si_copy_subarray"},

{SYS_ "CONS-CAR","cl_car"},
{SYS_ "CONS-CDR","cl_cdr"},

{EXT_ "COMPILER-TYPECASE",NULL},

{SYS_ "ASSERT-FAILURE","ECL_NAME(si_assert_failure)"},
{SYS_ "CCASE-ERROR","ECL_NAME(si_ccase_error)"},
{SYS_ "ECASE-ERROR","ECL_NAME(si_ecase_error)"},
{SYS_ "ETYPECASE-ERROR","ECL_NAME(si_etypecase_error)"},
{SYS_ "CTYPECASE-ERROR","ECL_NAME(si_ctypecase_error)"},
{SYS_ "DO-CHECK-TYPE","ECL_NAME(si_do_check_type)"},

{SYS_ "SERIALIZE","si_serialize"},
{SYS_ "DESERIALIZE","si_deserialize"},

{EXT_ "ARRAY-ELEMENT-TYPE-BYTE-SIZE","si_array_element_type_byte_size"},

/* #ifdef ECL_SSE2 */
{EXT_ "SSE-PACK",NULL},
{EXT_ "SSE-PACK-P",IF_SSE2("si_sse_pack_p")},
{EXT_ "SSE-PACK-AS-ELT-TYPE",IF_SSE2("si_sse_pack_as_elt_type")},
{EXT_ "VECTOR-TO-SSE-PACK",IF_SSE2("si_vector_to_sse_pack")},
{EXT_ "SSE-PACK-TO-VECTOR",IF_SSE2("si_sse_pack_to_vector")},
{EXT_ "INT-SSE-PACK",NULL},
{EXT_ "FLOAT-SSE-PACK",NULL},
{EXT_ "DOUBLE-SSE-PACK",NULL},
{EXT_ "SSE-PACK-ELEMENT-TYPE",IF_SSE2("si_sse_pack_element_type")},
{EXT_ "*SSE-PACK-PRINT-MODE*",NULL},
/* #endif ECL_SSE2 */

{EXT_ "UNIX-SIGNAL-RECEIVED",NULL},
{EXT_ "UNIX-SIGNAL-RECEIVED-CODE",NULL},
{KEY_ "CODE",NULL},

{EXT_ "ASSUME-RIGHT-TYPE",NULL},

{SYS_ "FLOAT-TO-DIGITS","si_float_to_digits"},
{SYS_ "FLOAT-TO-STRING-FREE","si_float_to_string_free"},
{SYS_ "INTEGER-TO-STRING","si_integer_to_string"},

{SYS_ "PRINT-UNREADABLE-OBJECT-FUNCTION","si_print_unreadable_object_function"},

{EXT_ "DUMP-C-BACKTRACE","si_dump_c_backtrace"},

{EXT_ "+PROCESS-STANDARD-INPUT+",NULL},
{EXT_ "+PROCESS-STANDARD-OUTPUT+",NULL},
{EXT_ "+PROCESS-ERROR-OUTPUT+",NULL},

{EXT_ "*HELP-MESSAGE*",NULL},
{EXT_ "*LISP-INIT-FILE-LIST*",NULL},
{EXT_ "+DEFAULT-COMMAND-ARG-RULES+",NULL},
{EXT_ "COMMAND-ARGS",NULL},
{EXT_ "*COMMAND-ARGS*",NULL},
{EXT_ "PROCESS-COMMAND-ARGS",NULL},
{EXT_ "*UNPROCESSED-ECL-COMMAND-ARGS*",NULL},

/* #ifdef ECL_UNICODE */
{KEY_ "OCTETS",NULL},
{EXT_ "CHARACTER-CODING-ERROR",NULL},
{EXT_ "CHARACTER-CODING-ERROR-EXTERNAL-FORMAT",NULL},
{EXT_ "CHARACTER-ENCODING-ERROR",NULL},
{EXT_ "CHARACTER-ENCODING-ERROR-CODE",NULL},
{EXT_ "CHARACTER-DECODING-ERROR",NULL},
{EXT_ "CHARACTER-DECODING-ERROR-OCTETS",NULL},
{EXT_ "STREAM-DECODING-ERROR",NULL},
{EXT_ "STREAM-ENCODING-ERROR",NULL},
{EXT_ "DECODING-ERROR",NULL},
{EXT_ "ENCODING-ERROR",NULL},
/* #endif ECL_UNICODE */

{SYS_ "PROPER-LIST-P","si_proper_list_p"},
{SYS_ "TRACED-OLD-DEFINITION","ECL_NAME(si_traced_old_definition)"},
{SYS_ "*TRACE-LIST*",NULL},

{SYS_ "FUNCTION-BOUNDARY",NULL},

{EXT_ "*INSPECTOR-HOOK*",NULL},

{KEY_ "RESOLVE-SYMLINKS",NULL},

{SYS_ "LOAD-BYTECODES","si_load_bytecodes"},

{KEY_ "SHARED",NULL},
{KEY_ "PRIVATE",NULL},

{EXT_ "MMAP","si_mmap"},
{EXT_ "MUNMAP","si_munmap"},
{EXT_ "MMAP-ARRAY","si_mmap_array"},

{SYS_ "GET-CDATA","si_get_cdata"},
{SYS_ "ADD-CDATA","si_add_cdata"},

/*
 * CDR-5 http://cdr.eurolisp.org/document/5/extra-num-types.html
 */

{EXT_ "NEGATIVE-FIXNUM",NULL},
{EXT_ "NON-NEGATIVE-FIXNUM",NULL},
{EXT_ "NON-POSITIVE-FIXNUM",NULL},
{EXT_ "POSITIVE-FIXNUM",NULL},
{EXT_ "NEGATIVE-FIXNUM-P","ECL_NAME(si_negative_fixnum_p)"},
{EXT_ "POSITIVE-FIXNUM-P","ECL_NAME(si_positive_fixnum_p)"},
{EXT_ "NON-NEGATIVE-FIXNUM-P","ECL_NAME(si_non_negative_fixnum_p)"},
{EXT_ "NON-POSITIVE-FIXNUM-P","ECL_NAME(si_non_positive_fixnum_p)"},

{EXT_ "NEGATIVE-INTEGER",NULL},
{EXT_ "NON-NEGATIVE-INTEGER",NULL},
{EXT_ "NON-POSITIVE-INTEGER",NULL},
{EXT_ "POSITIVE-INTEGER",NULL},
{EXT_ "NEGATIVE-INTEGER-P","ECL_NAME(si_negative_integer_p)"},
{EXT_ "POSITIVE-INTEGER-P","ECL_NAME(si_positive_integer_p)"},
{EXT_ "NON-NEGATIVE-INTEGER-P","ECL_NAME(si_non_negative_integer_p)"},
{EXT_ "NON-POSITIVE-INTEGER-P","ECL_NAME(si_non_positive_integer_p)"},

{EXT_ "NEGATIVE-RATIONAL",NULL},
{EXT_ "NON-NEGATIVE-RATIONAL",NULL},
{EXT_ "NON-POSITIVE-RATIONAL",NULL},
{EXT_ "POSITIVE-RATIONAL",NULL},
{EXT_ "NEGATIVE-RATIONAL-P","ECL_NAME(si_negative_rational_p)"},
{EXT_ "POSITIVE-RATIONAL-P","ECL_NAME(si_positive_rational_p)"},
{EXT_ "NON-NEGATIVE-RATIONAL-P","ECL_NAME(si_non_negative_rational_p)"},
{EXT_ "NON-POSITIVE-RATIONAL-P","ECL_NAME(si_non_positive_rational_p)"},

{EXT_ "NEGATIVE-RATIO",NULL},
{EXT_ "NON-NEGATIVE-RATIO",NULL},
{EXT_ "NON-POSITIVE-RATIO",NULL},
{EXT_ "POSITIVE-RATIO",NULL},
{EXT_ "NEGATIVE-RATIO-P","ECL_NAME(si_negative_ratio_p)"},
{EXT_ "POSITIVE-RATIO-P","ECL_NAME(si_positive_ratio_p)"},
{EXT_ "NON-NEGATIVE-RATIO-P","ECL_NAME(si_non_negative_ratio_p)"},
{EXT_ "NON-POSITIVE-RATIO-P","ECL_NAME(si_non_positive_ratio_p)"},

{EXT_ "NEGATIVE-REAL",NULL},
{EXT_ "NON-NEGATIVE-REAL",NULL},
{EXT_ "NON-POSITIVE-REAL",NULL},
{EXT_ "POSITIVE-REAL",NULL},
{EXT_ "NEGATIVE-REAL-P","ECL_NAME(si_negative_real_p)"},
{EXT_ "POSITIVE-REAL-P","ECL_NAME(si_positive_real_p)"},
{EXT_ "NON-NEGATIVE-REAL-P","ECL_NAME(si_non_negative_real_p)"},
{EXT_ "NON-POSITIVE-REAL-P","ECL_NAME(si_non_positive_real_p)"},

{EXT_ "NEGATIVE-FLOAT",NULL},
{EXT_ "NON-NEGATIVE-FLOAT",NULL},
{EXT_ "NON-POSITIVE-FLOAT",NULL},
{EXT_ "POSITIVE-FLOAT",NULL},
{EXT_ "NEGATIVE-FLOAT-P","ECL_NAME(si_negative_float_p)"},
{EXT_ "POSITIVE-FLOAT-P","ECL_NAME(si_positive_float_p)"},
{EXT_ "NON-NEGATIVE-FLOAT-P","ECL_NAME(si_non_negative_float_p)"},
{EXT_ "NON-POSITIVE-FLOAT-P","ECL_NAME(si_non_positive_float_p)"},

{EXT_ "NEGATIVE-SHORT-FLOAT",NULL},
{EXT_ "NON-NEGATIVE-SHORT-FLOAT",NULL},
{EXT_ "NON-POSITIVE-SHORT-FLOAT",NULL},
{EXT_ "POSITIVE-SHORT-FLOAT",NULL},
{EXT_ "NEGATIVE-SHORT-FLOAT-P","ECL_NAME(si_negative_short_float_p)"},
{EXT_ "POSITIVE-SHORT-FLOAT-P","ECL_NAME(si_positive_short_float_p)"},
{EXT_ "NON-NEGATIVE-SHORT-FLOAT-P","ECL_NAME(si_non_negative_short_float_p)"},
{EXT_ "NON-POSITIVE-SHORT-FLOAT-P","ECL_NAME(si_non_positive_short_float_p)"},

{EXT_ "NEGATIVE-SINGLE-FLOAT",NULL},
{EXT_ "NON-NEGATIVE-SINGLE-FLOAT",NULL},
{EXT_ "NON-POSITIVE-SINGLE-FLOAT",NULL},
{EXT_ "POSITIVE-SINGLE-FLOAT",NULL},
{EXT_ "NEGATIVE-SINGLE-FLOAT-P","ECL_NAME(si_negative_single_float_p)"},
{EXT_ "POSITIVE-SINGLE-FLOAT-P","ECL_NAME(si_positive_single_float_p)"},
{EXT_ "NON-NEGATIVE-SINGLE-FLOAT-P","ECL_NAME(si_non_negative_single_float_p)"},
{EXT_ "NON-POSITIVE-SINGLE-FLOAT-P","ECL_NAME(si_non_positive_single_float_p)"},

{EXT_ "NEGATIVE-DOUBLE-FLOAT",NULL},
{EXT_ "NON-NEGATIVE-DOUBLE-FLOAT",NULL},
{EXT_ "NON-POSITIVE-DOUBLE-FLOAT",NULL},
{EXT_ "POSITIVE-DOUBLE-FLOAT",NULL},
{EXT_ "NEGATIVE-DOUBLE-FLOAT-P","ECL_NAME(si_negative_double_float_p)"},
{EXT_ "POSITIVE-DOUBLE-FLOAT-P","ECL_NAME(si_positive_double_float_p)"},
{EXT_ "NON-NEGATIVE-DOUBLE-FLOAT-P","ECL_NAME(si_non_negative_double_float_p)"},
{EXT_ "NON-POSITIVE-DOUBLE-FLOAT-P","ECL_NAME(si_non_positive_double_float_p)"},

{EXT_ "NEGATIVE-LONG-FLOAT",NULL},
{EXT_ "NON-NEGATIVE-LONG-FLOAT",NULL},
{EXT_ "NON-POSITIVE-LONG-FLOAT",NULL},
{EXT_ "POSITIVE-LONG-FLOAT",NULL},
{EXT_ "NEGATIVE-LONG-FLOAT-P","ECL_NAME(si_negative_long_float_p)"},
{EXT_ "POSITIVE-LONG-FLOAT-P","ECL_NAME(si_positive_long_float_p)"},
{EXT_ "NON-NEGATIVE-LONG-FLOAT-P","ECL_NAME(si_non_negative_long_float_p)"},
{EXT_ "NON-POSITIVE-LONG-FLOAT-P","ECL_NAME(si_non_positive_long_float_p)"},

{EXT_ "ARRAY-INDEX-P","ECL_NAME(si_array_index_p)"},

{EXT_ "SEQUENCE-STREAM",NULL},
{EXT_ "MAKE-SEQUENCE-INPUT-STREAM","si_make_sequence_input_stream"},
{EXT_ "MAKE-SEQUENCE-OUTPUT-STREAM","si_make_sequence_output_stream"},

{EXT_ "CHMOD","si_chmod"},

{SYS_ "MISSING-KEYWORD",NULL},

{EXT_ "HASH-TABLE-CONTENT","si_hash_table_content"},
{EXT_ "HASH-TABLE-FILL","si_hash_table_fill"},

{SYS_ "REPORT-FUNCTION",NULL},

{SYS_ "DO-DEFSETF","ECL_NAME(si_do_defsetf)"},
{SYS_ "DO-DEFINE-SETF-METHOD","ECL_NAME(si_do_define_setf_method)"},

{SYS_ "SETF-DEFINITION","ECL_NAME(si_setf_definition)"},

{EXT_ "ASSUME-NO-ERRORS",NULL},
{EXT_ "ASSUME-TYPES-DONT-CHANGE",NULL},
{EXT_ "CHECK-ARGUMENTS-TYPE",NULL},
{EXT_ "INLINE-ACCESSORS",NULL},
{EXT_ "INLINE-TYPE-CHECKS",NULL},
{EXT_ "EVALUATE-FORMS",NULL},
{EXT_ "TYPE-ASSERTIONS",NULL},
{EXT_ "CHECK-STACK-OVERFLOW",NULL},
{EXT_ "ARRAY-BOUNDS-CHECK",NULL},

{KEY_ "VALUE",NULL},
{KEY_ "KEY-AND-VALUE",NULL},
{KEY_ "WEAKNESS",NULL},
{EXT_ "HASH-TABLE-WEAKNESS","si_hash_table_weakness"},

{EXT_ "TRULY-THE",NULL},
{EXT_ "CHECKED-VALUE",NULL},

{EXT_ "INSTALL-BYTECODES-COMPILER",NULL},
{EXT_ "INSTALL-C-COMPILER",NULL},

{FFI_ "C-CHAR-BIT",NULL},
{FFI_ "C-CHAR-MAX",NULL},
{FFI_ "C-CHAR-MIN",NULL},
{FFI_ "C-INT-MAX",NULL}, /* See main.d */
{FFI_ "C-INT-MIN",NULL}, /* See main.d */
{FFI_ "C-SHORT-MAX",NULL},
{FFI_ "C-SHORT-MIN",NULL},
{FFI_ "C-LONG-MAX",NULL}, /* See main.d */
{FFI_ "C-LONG-MIN",NULL}, /* See main.d */
{FFI_ "C-LONG-LONG-MAX",NULL}, /* See main.d */
{FFI_ "C-UCHAR-MAX",NULL},
{FFI_ "C-UINT-MAX",NULL}, /* See main.d */
{FFI_ "C-USHORT-MAX",NULL},
{FFI_ "C-ULONG-MAX",NULL}, /* See main.d */
{FFI_ "C-ULONG-LONG-MAX",NULL}, /* See main.d */
#ifdef ecl_long_long_t
{FFI_ "C-LONG-LONG-BIT",NULL},
#else
{FFI_ "C-LONG-LONG-BIT",NULL},
#endif

{FFI_ "*USE-DFFI*",NULL},
{FFI_ "+NULL-CSTRING-POINTER+",NULL},
{FFI_ "ALLOCATE-FOREIGN-OBJECT",NULL},
{FFI_ "ALLOCATE-FOREIGN-STRING",NULL},
{FFI_ "C-INLINE",NULL},
{FFI_ "C-PROGN",NULL},
{FFI_ "CALLBACK",NULL},
{FFI_ "CHAR*",NULL},
{FFI_ "CHAR-ARRAY-TO-POINTER",NULL},
{FFI_ "CLINES",NULL},
{FFI_ "CONVERT-FROM-CSTRING",NULL},
{FFI_ "CONVERT-FROM-FOREIGN-STRING",NULL},
{FFI_ "CONVERT-TO-CSTRING",NULL},
{FFI_ "CONVERT-TO-FOREIGN-STRING",NULL},
{FFI_ "DEF-ARRAY",NULL},
{FFI_ "DEF-ARRAY-POINTER",NULL},
{FFI_ "DEF-CONSTANT",NULL},
{FFI_ "DEF-ENUM",NULL},
{FFI_ "DEF-FOREIGN-TYPE",NULL},
{FFI_ "DEF-FOREIGN-VAR",NULL},
{FFI_ "DEF-FUNCTION",NULL},
{FFI_ "DEF-STRUCT",NULL},
{FFI_ "DEF-TYPE",NULL},
{FFI_ "DEF-UNION",NULL},
{FFI_ "DEFCALLBACK",NULL},
{FFI_ "DEFCBODY",NULL},
{FFI_ "DEFENTRY",NULL},
{FFI_ "DEFINLINE",NULL},
{FFI_ "DEFLA",NULL},
{FFI_ "DEREF-ARRAY",NULL},
{FFI_ "DEREF-POINTER",NULL},
{FFI_ "DOUBLE",NULL},
{FFI_ "ENSURE-CHAR-CHARACTER",NULL},
{FFI_ "ENSURE-CHAR-INTEGER",NULL},
{FFI_ "ENSURE-CHAR-STORABLE",NULL},
{FFI_ "FIND-FOREIGN-LIBRARY",NULL},
{FFI_ "FOREIGN-STRING-LENGTH",NULL},
{FFI_ "FREE-CSTRING",NULL},
{FFI_ "FREE-FOREIGN-OBJECT",NULL},
{FFI_ "GET-SLOT-POINTER",NULL},
{FFI_ "GET-SLOT-VALUE",NULL},
{FFI_ "INT",NULL},
{FFI_ "LOAD-FOREIGN-LIBRARY",NULL},
{FFI_ "MAKE-NULL-POINTER",NULL},
{FFI_ "MAKE-POINTER",NULL},
{FFI_ "NULL-CHAR-P",NULL},
{FFI_ "OBJECT",NULL},
{FFI_ "POINTER-ADDRESS",NULL},
{FFI_ "SIZE-OF-FOREIGN-TYPE",NULL},
{FFI_ "VOID",NULL},
{FFI_ "WITH-CAST-POINTER",NULL},
{FFI_ "WITH-CSTRING",NULL},
{FFI_ "WITH-CSTRINGS",NULL},
{FFI_ "WITH-FOREIGN-OBJECT",NULL},
{FFI_ "WITH-FOREIGN-OBJECTS",NULL},
{FFI_ "WITH-FOREIGN-STRING",NULL},
{FFI_ "WITH-FOREIGN-STRINGS",NULL},

{SYS_ "BIND-SIMPLE-RESTARTS","ECL_NAME(si_bind_simple_restarts)"},
{SYS_ "BIND-SIMPLE-HANDLERS","ECL_NAME(si_bind_simple_handlers)"},
{EXT_ "CONSTANT-FORM-VALUE","si_constant_form_value"},
{EXT_ "CONSTANTP-INNER","si_constantp_inner"},
{SYS_ "MAKE-BACKQ-VECTOR","si_make_backq_vector"},

{SYS_ "RATIOP","ECL_NAME(si_ratiop)"},
{SYS_ "SHORT-FLOAT-P","ECL_NAME(si_short_float_p)"},
{SYS_ "SINGLE-FLOAT-P","ECL_NAME(si_single_float_p)"},
{SYS_ "DOUBLE-FLOAT-P","ECL_NAME(si_double_float_p)"},
{SYS_ "LONG-FLOAT-P","ECL_NAME(si_long_float_p)"},

{SYS_ "COPY-HASH-TABLE","si_copy_hash_table"},

/* Tag for end of list */
{NULL,NULL}};
