/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Netscape Portable Runtime (NSPR).
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998-2000
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef prbit_h___
#define prbit_h___

#include <iprt/cdefs.h>

#include "prtypes.h"

PR_BEGIN_EXTERN_C

/*
** Compute the log of the least power of 2 greater than or equal to n
*/
DECL_FORCE_INLINE(PRIntn) PR_CeilingLog2(PRUint32 n)
{
    PRIntn log2 = 0;

    if (n & (n-1))
  log2++;
    if (n >> 16)
  log2 += 16, n >>= 16;
    if (n >> 8)
  log2 += 8, n >>= 8;
    if (n >> 4)
  log2 += 4, n >>= 4;
    if (n >> 2)
  log2 += 2, n >>= 2;
    if (n >> 1)
  log2++;
    return log2;
}

/*
** Compute the log of the greatest power of 2 less than or equal to n.
** This really just finds the highest set bit in the word.
*/
DECL_FORCE_INLINE(PRIntn) PR_FloorLog2(PRUint32 n)
{
    PRIntn log2 = 0;

    if (n >> 16)
  log2 += 16, n >>= 16;
    if (n >> 8)
  log2 += 8, n >>= 8;
    if (n >> 4)
  log2 += 4, n >>= 4;
    if (n >> 2)
  log2 += 2, n >>= 2;
    if (n >> 1)
  log2++;
    return log2;
}

PR_END_EXTERN_C

#endif /* prbit_h___ */
