# Copyright (c) 2001, Stanford University
# All rights reserved.
#
# See the file LICENSE.txt for information on redistributing this software.

from __future__ import print_function
import sys
import apiutil


apiutil.CopyrightC()

print("""

/* DO NOT EDIT - THIS FILE AUTOMATICALLY GENERATED BY spucopy.py SCRIPT */

#include "cr_spu.h"
#include "cr_mem.h"

void crSPUCopyDispatchTable( SPUDispatchTable *dst, SPUDispatchTable *src )
{
""")

keys = apiutil.GetDispatchedFunctions(sys.argv[1]+"/APIspec.txt")
for func_name in keys:
	print('\tdst->%s = src->%s;' % (func_name, func_name))

# if the destination is already a copy of something, we'd better make sure
# that we take it off its source's copy list first.

print("""
	if (dst->copy_of != NULL)
	{
		/*
		 * dst was already a copy, go back to the original, 
		 * and remove dst from the original's copyList.
		 */
		struct _copy_list_node *temp, *prior = NULL;
		for (temp = dst->copy_of->copyList; temp; prior = temp, temp = temp->next)
		{
			if (temp->copy == dst)
			{
				if (prior)
				{
					prior->next = temp->next;
				}
				else
				{
					dst->copy_of->copyList = temp->next;
				}
				crFree( temp );
				break;
			}
		}
	}
	/*
	 * Now that dst->copy_of is unused, set it to point to our
	 * new original.
	 */
	if (src->copy_of)
	{
		dst->copy_of = src->copy_of;
	}
	else
	{
		dst->copy_of = src;
	}
	/*
	 * Create a new copy node, so the src can keep track of the 
	 * new copy (i.e. dst).
	 */
	{
		struct _copy_list_node *copynode;
		copynode = (struct _copy_list_node*)crAlloc( sizeof( *copynode ) );
		copynode->copy = dst;
		copynode->next = src->copyList;
		src->copyList = copynode;
	}
}
""")
