/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;

class BetaIntegerCodec
extends AbstractBitCodec<Integer> {
    private int offset = 0;
    private final int readNofBits;

    public BetaIntegerCodec(int offset, int readNofBits) {
        this.offset = offset;
        this.readNofBits = readNofBits;
    }

    @Override
    public final Integer read(BitInputStream bitInputStream) throws IOException {
        return bitInputStream.readBits(this.readNofBits) - this.offset;
    }

    @Override
    public final long write(BitOutputStream bitOutputStream, Integer value) throws IOException {
        int nofBits = (int)this.numberOfBits(value);
        long newValue = value + this.offset;
        bitOutputStream.write(newValue, nofBits);
        return nofBits;
    }

    @Override
    public final long numberOfBits(Integer value) {
        if ((long)value.intValue() > 1L << this.readNofBits) {
            throw new IllegalArgumentException("Value written is bigger then allowed: value=" + value + ", max nof bits=" + this.readNofBits);
        }
        return this.readNofBits;
    }

    @Override
    public Integer read(BitInputStream bitInputStream, int length) throws IOException {
        throw new RuntimeException("Not implemented.");
    }
}

