/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.applet;

import java.applet.Applet;
import java.applet.AppletStub;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.applet.BasicAppletContext;
import org.fest.swing.applet.BasicAppletStub;
import org.fest.swing.applet.StatusDisplay;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppletViewer
extends JFrame
implements StatusDisplay {
    private static final long serialVersionUID = 1L;
    private static final String APPLET_VIEWER_TITLE = "Applet Viewer: ";
    private static final String APPLET_LOADED_MESSAGE = "Applet loaded";
    private static final Dimension DEFAULT_SIZE = new Dimension(100, 100);
    private final JLabel statusLabel = new JLabel();
    private final Applet applet;
    private transient AppletStub stub;
    private boolean loaded;

    @RunsInEDT
    public static AppletViewer newViewer(Applet applet) {
        AppletViewer viewer = AppletViewer.createInEDT(applet);
        viewer.appletStub(new BasicAppletStub(viewer, new BasicAppletContext(viewer)));
        return viewer;
    }

    @RunsInEDT
    public static AppletViewer newViewer(Applet applet, Map<String, String> parameters) {
        AppletViewer viewer = AppletViewer.createInEDT(applet);
        viewer.appletStub(new BasicAppletStub(viewer, new BasicAppletContext(viewer), parameters));
        return viewer;
    }

    @RunsInEDT
    public static AppletViewer newViewer(Applet applet, AppletStub stub) {
        AppletViewer viewer = AppletViewer.createInEDT(applet);
        viewer.appletStub(stub);
        return viewer;
    }

    @RunsInEDT
    private static AppletViewer createInEDT(final Applet applet) {
        return GuiActionRunner.execute(new GuiQuery<AppletViewer>(){

            @Override
            protected AppletViewer executeInEDT() {
                return new AppletViewer(applet);
            }
        });
    }

    private AppletViewer(Applet applet) {
        if (applet == null) {
            throw new NullPointerException("The applet to load should not be null");
        }
        this.applet = applet;
        this.setUpFrame();
        this.addContent();
    }

    private void setUpFrame() {
        this.setTitle(Strings.concat((Object[])new Object[]{APPLET_VIEWER_TITLE, this.applet.getClass().getName()}));
        this.setSize(DEFAULT_SIZE);
        this.setLayout(new BorderLayout());
    }

    private void addContent() {
        this.add((Component)this.applet, "Center");
        this.statusLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(2, 5, 2, 5)));
        this.statusLabel.setName("status");
        this.add((Component)this.statusLabel, "South");
    }

    private void appletStub(AppletStub newAppletStub) {
        if (newAppletStub == null) {
            throw new NullPointerException("The AppletStub should not be null");
        }
        this.stub = newAppletStub;
        this.applet.setStub(this.stub);
        this.setUpApplet();
    }

    private void setUpApplet() {
        this.loadApplet();
        this.showStatus(APPLET_LOADED_MESSAGE);
    }

    public void reloadApplet() {
        if (this.loaded) {
            this.unloadApplet();
        }
        this.loadApplet();
    }

    private void loadApplet() {
        this.applet.init();
        this.applet.start();
        this.loaded = true;
    }

    public void unloadApplet() {
        this.applet.stop();
        this.applet.destroy();
        this.loaded = false;
    }

    public boolean appletLoaded() {
        return this.loaded;
    }

    @Override
    @RunsInEDT
    public void showStatus(final String status) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setStatus(status);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AppletViewer.this.setStatus(status);
            }
        });
    }

    @RunsInCurrentThread
    private void setStatus(String status) {
        this.statusLabel.setText(status);
    }

    public Applet applet() {
        return this.applet;
    }

    public AppletStub stub() {
        return this.stub;
    }
}

