/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.UserAddPolicyRequest;
import com.amazonaws.services.auth.identity.cli.policy.PolicyBuilder;
import com.amazonaws.services.identitymanagement.model.PutUserPolicyRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMUserAddPolicyDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMUserAddPolicyDriver.class);

    public void invokeRequestImpl(CLIRequest request) {
        if (request instanceof UserAddPolicyRequest) {
            UserAddPolicyRequest req = (UserAddPolicyRequest)request;
            String doc = null;
            try {
                LOG.debug((Object)("Generating policy doc from request " + request));
                doc = PolicyBuilder.buildPolicy(req.getEffect(), req.getActions(), req.getResources());
            }
            catch (Exception e) {
                Utils.exit(1, "Error generating policy document from parameters. " + e.getMessage(), e);
            }
            PutUserPolicyRequest policyRequest = new PutUserPolicyRequest();
            policyRequest.setPolicyDocument(doc);
            policyRequest.setUserName(req.getUserName());
            policyRequest.setPolicyName(req.getPolicyName());
            LOG.debug((Object)("Calling putpolicy with request " + request + " and policy document: "));
            LOG.debug((Object)doc);
            this.getClient().putUserPolicy(policyRequest);
            if (req.isVerbose()) {
                LOG.info((Object)doc);
            }
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

