/* Alteration.c generated by valac 0.40.4, the Vala compiler
 * generated from Alteration.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/**/
/* Alteration represents a description of what has changed in the DataObject (reported via the*/
/* "altered" signal).  Since the descriptions can vary wildly depending on the semantics of each*/
/* DataObject, no assumptions or requirements are placed on Alteration other than it must have*/
/* one or more "subjects", each with a "detail".  Subscribers to the "altered" signal can query*/
/* the Alteration object to determine if the change is important to them.*/
/**/
/* Alteration is an immutable type.  This means it's possible to store const Alterations of oft-used*/
/* values for reuse.*/
/**/
/* Alterations may be compressed, merging their subjects and details into a new aggregated*/
/* Alteration.  Generally this is handled automatically by DataObject and DataCollection, when*/
/* necessary.*/
/**/
/* NOTE: subjects and details should be ASCII labels (as in, plain-old ASCII, no code pages).*/
/* They are treated as case-sensitive strings.*/
/**/
/* Recommended subjects include: image, thumbnail, metadata.*/
/**/


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;
typedef struct _AlterationPrivate AlterationPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecAlteration ParamSpecAlteration;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Alteration {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AlterationPrivate * priv;
};

struct _AlterationClass {
	GTypeClass parent_class;
	void (*finalize) (Alteration *self);
};

struct _AlterationPrivate {
	gchar* subject;
	gchar* detail;
	GeeMultiMap* map;
};

struct _ParamSpecAlteration {
	GParamSpec parent_instance;
};


static gpointer alteration_parent_class = NULL;

gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
void value_set_alteration (GValue* value,
                           gpointer v_object);
void value_take_alteration (GValue* value,
                            gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
#define ALTERATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ALTERATION, AlterationPrivate))
Alteration* alteration_new (const gchar* subject,
                            const gchar* detail);
Alteration* alteration_construct (GType object_type,
                                  const gchar* subject,
                                  const gchar* detail);
static void alteration_add_detail (Alteration* self,
                            const gchar* sub,
                            const gchar* det);
Alteration* alteration_new_from_list (const gchar* list);
Alteration* alteration_construct_from_list (GType object_type,
                                            const gchar* list);
Alteration* alteration_new_from_array (gchar** array,
                                       int array_length1);
Alteration* alteration_construct_from_array (GType object_type,
                                             gchar** array,
                                             int array_length1);
static Alteration* alteration_new_from_map (GeeMultiMap* map);
static Alteration* alteration_construct_from_map (GType object_type,
                                           GeeMultiMap* map);
static GeeMultiMap* alteration_create_map (Alteration* self);
static guint alteration_case_hash (const gchar* a);
static guint _alteration_case_hash_gee_hash_data_func (gconstpointer v,
                                                gpointer self);
static gboolean alteration_case_equal (const gchar* a,
                                const gchar* b);
static gboolean _alteration_case_equal_gee_equal_data_func (gconstpointer a,
                                                     gconstpointer b,
                                                     gpointer self);
static inline gboolean alteration_equal_values (const gchar* str1,
                                  const gchar* str2);
static inline guint alteration_hash_value (const gchar* str);
gboolean alteration_has_subject (Alteration* self,
                                 const gchar* subject);
gboolean alteration_has_detail (Alteration* self,
                                const gchar* subject,
                                const gchar* detail);
GeeCollection* alteration_get_details (Alteration* self,
                                       const gchar* subject);
gchar* alteration_to_string (Alteration* self);
gboolean alteration_contains_any (Alteration* self,
                                  Alteration* other);
gboolean alteration_equals (Alteration* self,
                            Alteration* other);
static void alteration_multimap_add_all (GeeMultiMap* dest,
                                  GeeMultiMap* src);
Alteration* alteration_compress (Alteration* self,
                                 Alteration* other);
static void alteration_finalize (Alteration * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


Alteration*
alteration_construct (GType object_type,
                      const gchar* subject,
                      const gchar* detail)
{
	Alteration* self = NULL;
#line 32 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (subject != NULL, NULL);
#line 32 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (detail != NULL, NULL);
#line 32 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	self = (Alteration*) g_type_create_instance (object_type);
#line 33 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	alteration_add_detail (self, subject, detail);
#line 32 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return self;
#line 168 "Alteration.c"
}


Alteration*
alteration_new (const gchar* subject,
                const gchar* detail)
{
#line 32 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return alteration_construct (TYPE_ALTERATION, subject, detail);
#line 178 "Alteration.c"
}


Alteration*
alteration_construct_from_list (GType object_type,
                                const gchar* list)
{
	Alteration* self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar** pairs = NULL;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint pairs_length1;
	gint _pairs_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
#line 38 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (list != NULL, NULL);
#line 38 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	self = (Alteration*) g_type_create_instance (object_type);
#line 38 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp0_ = strlen (list);
#line 38 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp1_ = _tmp0_;
#line 38 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_vala_return_val_if_fail (_tmp1_ > 0, "list.length > 0", NULL);
#line 39 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp3_ = _tmp2_ = g_strsplit (list, ",", 0);
#line 39 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	pairs = _tmp3_;
#line 39 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	pairs_length1 = _vala_array_length (_tmp2_);
#line 39 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_pairs_size_ = pairs_length1;
#line 40 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp4_ = pairs;
#line 40 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp4__length1 = pairs_length1;
#line 40 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_vala_assert (_tmp4__length1 >= 1, "pairs.length >= 1");
#line 42 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp5_ = pairs;
#line 42 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp5__length1 = pairs_length1;
#line 226 "Alteration.c"
	{
		gchar** pair_collection = NULL;
		gint pair_collection_length1 = 0;
		gint _pair_collection_size_ = 0;
		gint pair_it = 0;
#line 42 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		pair_collection = _tmp5_;
#line 42 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		pair_collection_length1 = _tmp5__length1;
#line 42 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		for (pair_it = 0; pair_it < _tmp5__length1; pair_it = pair_it + 1) {
#line 238 "Alteration.c"
			gchar* _tmp6_;
			gchar* pair = NULL;
#line 42 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp6_ = g_strdup (pair_collection[pair_it]);
#line 42 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			pair = _tmp6_;
#line 245 "Alteration.c"
			{
				gchar** subject_detail = NULL;
				const gchar* _tmp7_;
				gchar** _tmp8_;
				gchar** _tmp9_;
				gint subject_detail_length1;
				gint _subject_detail_size_;
				gchar** _tmp10_;
				gint _tmp10__length1;
				gchar** _tmp11_;
				gint _tmp11__length1;
				const gchar* _tmp12_;
				gchar** _tmp13_;
				gint _tmp13__length1;
				const gchar* _tmp14_;
#line 43 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp7_ = pair;
#line 43 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, ":", 2);
#line 43 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				subject_detail = _tmp9_;
#line 43 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				subject_detail_length1 = _vala_array_length (_tmp8_);
#line 43 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_subject_detail_size_ = subject_detail_length1;
#line 44 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp10_ = subject_detail;
#line 44 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp10__length1 = subject_detail_length1;
#line 44 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_vala_assert (_tmp10__length1 == 2, "subject_detail.length == 2");
#line 46 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp11_ = subject_detail;
#line 46 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp11__length1 = subject_detail_length1;
#line 46 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp12_ = _tmp11_[0];
#line 46 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp13_ = subject_detail;
#line 46 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp13__length1 = subject_detail_length1;
#line 46 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp14_ = _tmp13_[1];
#line 46 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				alteration_add_detail (self, _tmp12_, _tmp14_);
#line 42 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				subject_detail = (_vala_array_free (subject_detail, subject_detail_length1, (GDestroyNotify) g_free), NULL);
#line 42 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_g_free0 (pair);
#line 295 "Alteration.c"
			}
		}
	}
#line 38 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	pairs = (_vala_array_free (pairs, pairs_length1, (GDestroyNotify) g_free), NULL);
#line 38 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return self;
#line 303 "Alteration.c"
}


Alteration*
alteration_new_from_list (const gchar* list)
{
#line 38 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return alteration_construct_from_list (TYPE_ALTERATION, list);
#line 312 "Alteration.c"
}


Alteration*
alteration_construct_from_array (GType object_type,
                                 gchar** array,
                                 int array_length1)
{
	Alteration* self = NULL;
#line 52 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	self = (Alteration*) g_type_create_instance (object_type);
#line 52 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_vala_return_val_if_fail (array_length1 > 0, "array.length > 0", NULL);
#line 326 "Alteration.c"
	{
		gchar** pair_collection = NULL;
		gint pair_collection_length1 = 0;
		gint _pair_collection_size_ = 0;
		gint pair_it = 0;
#line 53 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		pair_collection = array;
#line 53 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		pair_collection_length1 = array_length1;
#line 53 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		for (pair_it = 0; pair_it < array_length1; pair_it = pair_it + 1) {
#line 338 "Alteration.c"
			gchar* _tmp0_;
			gchar* pair = NULL;
#line 53 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp0_ = g_strdup (pair_collection[pair_it]);
#line 53 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			pair = _tmp0_;
#line 345 "Alteration.c"
			{
				gchar** subject_detail = NULL;
				const gchar* _tmp1_;
				gchar** _tmp2_;
				gchar** _tmp3_;
				gint subject_detail_length1;
				gint _subject_detail_size_;
				gchar** _tmp4_;
				gint _tmp4__length1;
				gchar** _tmp5_;
				gint _tmp5__length1;
				const gchar* _tmp6_;
				gchar** _tmp7_;
				gint _tmp7__length1;
				const gchar* _tmp8_;
#line 54 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp1_ = pair;
#line 54 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, ":", 2);
#line 54 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				subject_detail = _tmp3_;
#line 54 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				subject_detail_length1 = _vala_array_length (_tmp2_);
#line 54 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_subject_detail_size_ = subject_detail_length1;
#line 55 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp4_ = subject_detail;
#line 55 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp4__length1 = subject_detail_length1;
#line 55 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_vala_assert (_tmp4__length1 == 2, "subject_detail.length == 2");
#line 57 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp5_ = subject_detail;
#line 57 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp5__length1 = subject_detail_length1;
#line 57 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp6_ = _tmp5_[0];
#line 57 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp7_ = subject_detail;
#line 57 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp7__length1 = subject_detail_length1;
#line 57 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp8_ = _tmp7_[1];
#line 57 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				alteration_add_detail (self, _tmp6_, _tmp8_);
#line 53 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				subject_detail = (_vala_array_free (subject_detail, subject_detail_length1, (GDestroyNotify) g_free), NULL);
#line 53 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_g_free0 (pair);
#line 395 "Alteration.c"
			}
		}
	}
#line 52 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return self;
#line 401 "Alteration.c"
}


Alteration*
alteration_new_from_array (gchar** array,
                           int array_length1)
{
#line 52 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return alteration_construct_from_array (TYPE_ALTERATION, array, array_length1);
#line 411 "Alteration.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 63 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return self ? g_object_ref (self) : NULL;
#line 420 "Alteration.c"
}


static Alteration*
alteration_construct_from_map (GType object_type,
                               GeeMultiMap* map)
{
	Alteration* self = NULL;
	GeeMultiMap* _tmp0_;
#line 62 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (GEE_IS_MULTI_MAP (map), NULL);
#line 62 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	self = (Alteration*) g_type_create_instance (object_type);
#line 63 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp0_ = _g_object_ref0 (map);
#line 63 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_g_object_unref0 (self->priv->map);
#line 63 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	self->priv->map = _tmp0_;
#line 62 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return self;
#line 442 "Alteration.c"
}


static Alteration*
alteration_new_from_map (GeeMultiMap* map)
{
#line 62 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return alteration_construct_from_map (TYPE_ALTERATION, map);
#line 451 "Alteration.c"
}


static gchar*
string_strip (const gchar* self)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
#line 1248 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1249 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1249 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1250 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1250 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1251 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _result_;
#line 1251 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 476 "Alteration.c"
}


static void
alteration_add_detail (Alteration* self,
                       const gchar* sub,
                       const gchar* det)
{
	gchar* subject = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* detail = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	GeeMultiMap* _tmp16_;
	const gchar* _tmp18_;
	GeeMultiMap* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
#line 66 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_if_fail (IS_ALTERATION (self));
#line 66 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_if_fail (sub != NULL);
#line 66 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_if_fail (det != NULL);
#line 68 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp0_ = string_strip (sub);
#line 68 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	subject = _tmp0_;
#line 69 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp1_ = subject;
#line 69 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp2_ = strlen (_tmp1_);
#line 69 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp3_ = _tmp2_;
#line 69 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_vala_assert (_tmp3_ > 0, "subject.length > 0");
#line 71 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp4_ = string_strip (det);
#line 71 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	detail = _tmp4_;
#line 72 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp5_ = detail;
#line 72 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp6_ = strlen (_tmp5_);
#line 72 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp7_ = _tmp6_;
#line 72 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_vala_assert (_tmp7_ > 0, "detail.length > 0");
#line 75 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp9_ = self->priv->subject;
#line 75 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp9_ == NULL) {
#line 536 "Alteration.c"
		GeeMultiMap* _tmp10_;
#line 75 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp10_ = self->priv->map;
#line 75 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp8_ = _tmp10_ == NULL;
#line 542 "Alteration.c"
	} else {
#line 75 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp8_ = FALSE;
#line 546 "Alteration.c"
	}
#line 75 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp8_) {
#line 550 "Alteration.c"
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
#line 76 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp11_ = self->priv->detail;
#line 76 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_vala_assert (_tmp11_ == NULL, "this.detail == null");
#line 78 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp12_ = subject;
#line 78 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp13_ = g_strdup (_tmp12_);
#line 78 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_free0 (self->priv->subject);
#line 78 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		self->priv->subject = _tmp13_;
#line 79 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp14_ = detail;
#line 79 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp15_ = g_strdup (_tmp14_);
#line 79 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_free0 (self->priv->detail);
#line 79 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		self->priv->detail = _tmp15_;
#line 81 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_free0 (detail);
#line 81 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_free0 (subject);
#line 81 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		return;
#line 582 "Alteration.c"
	}
#line 85 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp16_ = self->priv->map;
#line 85 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp16_ == NULL) {
#line 588 "Alteration.c"
		GeeMultiMap* _tmp17_;
#line 86 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp17_ = alteration_create_map (self);
#line 86 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_object_unref0 (self->priv->map);
#line 86 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		self->priv->map = _tmp17_;
#line 596 "Alteration.c"
	}
#line 89 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp18_ = self->priv->subject;
#line 89 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp18_ != NULL) {
#line 602 "Alteration.c"
		const gchar* _tmp19_;
		GeeMultiMap* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
#line 90 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp19_ = self->priv->detail;
#line 90 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_vala_assert (_tmp19_ != NULL, "this.detail != null");
#line 92 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp20_ = self->priv->map;
#line 92 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp21_ = self->priv->subject;
#line 92 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp22_ = self->priv->detail;
#line 92 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		gee_multi_map_set (_tmp20_, _tmp21_, _tmp22_);
#line 93 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_free0 (self->priv->subject);
#line 93 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		self->priv->subject = NULL;
#line 94 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_free0 (self->priv->detail);
#line 94 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		self->priv->detail = NULL;
#line 627 "Alteration.c"
	}
#line 98 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp23_ = self->priv->map;
#line 98 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp24_ = subject;
#line 98 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp25_ = detail;
#line 98 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	gee_multi_map_set (_tmp23_, _tmp24_, _tmp25_);
#line 66 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_g_free0 (detail);
#line 66 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_g_free0 (subject);
#line 641 "Alteration.c"
}


static guint
_alteration_case_hash_gee_hash_data_func (gconstpointer v,
                                          gpointer self)
{
	guint result;
	result = alteration_case_hash ((const gchar*) v);
#line 102 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return result;
#line 653 "Alteration.c"
}


static gboolean
_alteration_case_equal_gee_equal_data_func (gconstpointer a,
                                            gconstpointer b,
                                            gpointer self)
{
	gboolean result;
	result = alteration_case_equal ((const gchar*) a, (const gchar*) b);
#line 102 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return result;
#line 666 "Alteration.c"
}


static GeeMultiMap*
alteration_create_map (Alteration* self)
{
	GeeMultiMap* result = NULL;
	GeeHashMultiMap* _tmp0_;
#line 101 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (IS_ALTERATION (self), NULL);
#line 102 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _alteration_case_hash_gee_hash_data_func, NULL, NULL, _alteration_case_equal_gee_equal_data_func, NULL, NULL, _alteration_case_hash_gee_hash_data_func, NULL, NULL, _alteration_case_equal_gee_equal_data_func, NULL, NULL);
#line 102 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MULTI_MAP, GeeMultiMap);
#line 102 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return result;
#line 683 "Alteration.c"
}


static gboolean
alteration_case_equal (const gchar* a,
                       const gchar* b)
{
	gboolean result = FALSE;
#line 106 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	result = alteration_equal_values (a, b);
#line 106 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return result;
#line 696 "Alteration.c"
}


static guint
alteration_case_hash (const gchar* a)
{
	guint result = 0U;
#line 110 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	result = alteration_hash_value (a);
#line 110 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return result;
#line 708 "Alteration.c"
}


static inline gboolean
alteration_equal_values (const gchar* str1,
                         const gchar* str2)
{
	gboolean result = FALSE;
#line 113 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (str1 != NULL, FALSE);
#line 113 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (str2 != NULL, FALSE);
#line 114 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	result = g_ascii_strcasecmp (str1, str2) == 0;
#line 114 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return result;
#line 725 "Alteration.c"
}


static inline guint
alteration_hash_value (const gchar* str)
{
	guint result = 0U;
	GHashFunc _tmp0_;
#line 117 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (str != NULL, 0U);
#line 118 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp0_ = g_str_hash;
#line 118 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	result = _tmp0_ (str);
#line 118 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return result;
#line 742 "Alteration.c"
}


gboolean
alteration_has_subject (Alteration* self,
                        const gchar* subject)
{
	gboolean result = FALSE;
	const gchar* _tmp0_;
	GeeMultiMap* _tmp2_;
	GeeSet* keys = NULL;
	GeeMultiMap* _tmp3_;
	GeeSet* _tmp4_;
	GeeSet* _tmp5_;
#line 121 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (IS_ALTERATION (self), FALSE);
#line 121 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (subject != NULL, FALSE);
#line 122 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp0_ = self->priv->subject;
#line 122 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp0_ != NULL) {
#line 765 "Alteration.c"
		const gchar* _tmp1_;
#line 123 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp1_ = self->priv->subject;
#line 123 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		result = alteration_equal_values (_tmp1_, subject);
#line 123 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		return result;
#line 773 "Alteration.c"
	}
#line 125 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp2_ = self->priv->map;
#line 125 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_vala_assert (_tmp2_ != NULL, "map != null");
#line 126 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp3_ = self->priv->map;
#line 126 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp4_ = gee_multi_map_get_keys (_tmp3_);
#line 126 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	keys = _tmp4_;
#line 127 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp5_ = keys;
#line 127 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp5_ != NULL) {
#line 789 "Alteration.c"
		{
			GeeIterator* _key_it = NULL;
			GeeSet* _tmp6_;
			GeeIterator* _tmp7_;
#line 128 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp6_ = keys;
#line 128 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp7_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ITERABLE, GeeIterable));
#line 128 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_key_it = _tmp7_;
#line 128 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			while (TRUE) {
#line 802 "Alteration.c"
				GeeIterator* _tmp8_;
				gchar* key = NULL;
				GeeIterator* _tmp9_;
				gpointer _tmp10_;
				const gchar* _tmp11_;
#line 128 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp8_ = _key_it;
#line 128 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				if (!gee_iterator_next (_tmp8_)) {
#line 128 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					break;
#line 814 "Alteration.c"
				}
#line 128 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp9_ = _key_it;
#line 128 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp10_ = gee_iterator_get (_tmp9_);
#line 128 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				key = (gchar*) _tmp10_;
#line 129 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp11_ = key;
#line 129 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				if (alteration_equal_values (_tmp11_, subject)) {
#line 130 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					result = TRUE;
#line 130 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_free0 (key);
#line 130 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (_key_it);
#line 130 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (keys);
#line 130 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					return result;
#line 836 "Alteration.c"
				}
#line 128 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_g_free0 (key);
#line 840 "Alteration.c"
			}
#line 128 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_g_object_unref0 (_key_it);
#line 844 "Alteration.c"
		}
	}
#line 134 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	result = FALSE;
#line 134 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_g_object_unref0 (keys);
#line 134 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return result;
#line 853 "Alteration.c"
}


gboolean
alteration_has_detail (Alteration* self,
                       const gchar* subject,
                       const gchar* detail)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	GeeMultiMap* _tmp6_;
	GeeCollection* values = NULL;
	GeeMultiMap* _tmp7_;
	GeeCollection* _tmp8_;
	GeeCollection* _tmp9_;
#line 137 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (IS_ALTERATION (self), FALSE);
#line 137 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (subject != NULL, FALSE);
#line 137 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (detail != NULL, FALSE);
#line 138 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp1_ = self->priv->subject;
#line 138 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp1_ != NULL) {
#line 880 "Alteration.c"
		const gchar* _tmp2_;
#line 138 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp2_ = self->priv->detail;
#line 138 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp0_ = _tmp2_ != NULL;
#line 886 "Alteration.c"
	} else {
#line 138 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp0_ = FALSE;
#line 890 "Alteration.c"
	}
#line 138 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp0_) {
#line 894 "Alteration.c"
		gboolean _tmp3_ = FALSE;
		const gchar* _tmp4_;
#line 139 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp4_ = self->priv->subject;
#line 139 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		if (alteration_equal_values (_tmp4_, subject)) {
#line 901 "Alteration.c"
			const gchar* _tmp5_;
#line 139 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp5_ = self->priv->detail;
#line 139 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp3_ = alteration_equal_values (_tmp5_, detail);
#line 907 "Alteration.c"
		} else {
#line 139 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp3_ = FALSE;
#line 911 "Alteration.c"
		}
#line 139 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		result = _tmp3_;
#line 139 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		return result;
#line 917 "Alteration.c"
	}
#line 141 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp6_ = self->priv->map;
#line 141 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_vala_assert (_tmp6_ != NULL, "map != null");
#line 142 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp7_ = self->priv->map;
#line 142 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp8_ = gee_multi_map_get (_tmp7_, subject);
#line 142 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	values = _tmp8_;
#line 143 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp9_ = values;
#line 143 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp9_ != NULL) {
#line 933 "Alteration.c"
		{
			GeeIterator* _value_it = NULL;
			GeeCollection* _tmp10_;
			GeeIterator* _tmp11_;
#line 144 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp10_ = values;
#line 144 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp11_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ITERABLE, GeeIterable));
#line 144 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_value_it = _tmp11_;
#line 144 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			while (TRUE) {
#line 946 "Alteration.c"
				GeeIterator* _tmp12_;
				gchar* value = NULL;
				GeeIterator* _tmp13_;
				gpointer _tmp14_;
				const gchar* _tmp15_;
#line 144 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp12_ = _value_it;
#line 144 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				if (!gee_iterator_next (_tmp12_)) {
#line 144 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					break;
#line 958 "Alteration.c"
				}
#line 144 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp13_ = _value_it;
#line 144 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp14_ = gee_iterator_get (_tmp13_);
#line 144 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				value = (gchar*) _tmp14_;
#line 145 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp15_ = value;
#line 145 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				if (alteration_equal_values (_tmp15_, detail)) {
#line 146 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					result = TRUE;
#line 146 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_free0 (value);
#line 146 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (_value_it);
#line 146 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (values);
#line 146 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					return result;
#line 980 "Alteration.c"
				}
#line 144 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_g_free0 (value);
#line 984 "Alteration.c"
			}
#line 144 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_g_object_unref0 (_value_it);
#line 988 "Alteration.c"
		}
	}
#line 150 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	result = FALSE;
#line 150 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_g_object_unref0 (values);
#line 150 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return result;
#line 997 "Alteration.c"
}


GeeCollection*
alteration_get_details (Alteration* self,
                        const gchar* subject)
{
	GeeCollection* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	GeeCollection* _tmp8_ = NULL;
	GeeMultiMap* _tmp9_;
#line 153 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (IS_ALTERATION (self), NULL);
#line 153 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (subject != NULL, NULL);
#line 154 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp2_ = self->priv->subject;
#line 154 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp2_ != NULL) {
#line 1019 "Alteration.c"
		const gchar* _tmp3_;
#line 154 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp3_ = self->priv->detail;
#line 154 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp1_ = _tmp3_ != NULL;
#line 1025 "Alteration.c"
	} else {
#line 154 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp1_ = FALSE;
#line 1029 "Alteration.c"
	}
#line 154 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp1_) {
#line 1033 "Alteration.c"
		const gchar* _tmp4_;
#line 154 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp4_ = self->priv->subject;
#line 154 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp0_ = alteration_equal_values (_tmp4_, subject);
#line 1039 "Alteration.c"
	} else {
#line 154 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp0_ = FALSE;
#line 1043 "Alteration.c"
	}
#line 154 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp0_) {
#line 1047 "Alteration.c"
		GeeArrayList* details = NULL;
		GeeArrayList* _tmp5_;
		GeeArrayList* _tmp6_;
		const gchar* _tmp7_;
#line 155 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp5_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 155 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		details = _tmp5_;
#line 156 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp6_ = details;
#line 156 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp7_ = self->priv->detail;
#line 156 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp7_);
#line 158 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		result = G_TYPE_CHECK_INSTANCE_CAST (details, GEE_TYPE_COLLECTION, GeeCollection);
#line 158 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		return result;
#line 1066 "Alteration.c"
	}
#line 161 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp9_ = self->priv->map;
#line 161 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp9_ != NULL) {
#line 1072 "Alteration.c"
		GeeMultiMap* _tmp10_;
		GeeCollection* _tmp11_;
#line 161 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp10_ = self->priv->map;
#line 161 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp11_ = gee_multi_map_get (_tmp10_, subject);
#line 161 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_object_unref0 (_tmp8_);
#line 161 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp8_ = _tmp11_;
#line 1083 "Alteration.c"
	} else {
#line 161 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_object_unref0 (_tmp8_);
#line 161 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp8_ = NULL;
#line 1089 "Alteration.c"
	}
#line 161 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	result = _tmp8_;
#line 161 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return result;
#line 1095 "Alteration.c"
}


gchar*
alteration_to_string (Alteration* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	GeeMultiMap* _tmp5_;
	gchar* str = NULL;
	gchar* _tmp6_;
#line 164 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (IS_ALTERATION (self), NULL);
#line 165 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp0_ = self->priv->subject;
#line 165 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp0_ != NULL) {
#line 1113 "Alteration.c"
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
#line 166 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp1_ = self->priv->detail;
#line 166 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_vala_assert (_tmp1_ != NULL, "detail != null");
#line 168 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp2_ = self->priv->subject;
#line 168 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp3_ = self->priv->detail;
#line 168 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp4_ = g_strdup_printf ("%s:%s", _tmp2_, _tmp3_);
#line 168 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		result = _tmp4_;
#line 168 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		return result;
#line 1132 "Alteration.c"
	}
#line 171 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp5_ = self->priv->map;
#line 171 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_vala_assert (_tmp5_ != NULL, "map != null");
#line 173 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp6_ = g_strdup ("");
#line 173 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	str = _tmp6_;
#line 1142 "Alteration.c"
	{
		GeeIterator* _key_it = NULL;
		GeeMultiMap* _tmp7_;
		GeeSet* _tmp8_;
		GeeSet* _tmp9_;
		GeeIterator* _tmp10_;
		GeeIterator* _tmp11_;
#line 174 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp7_ = self->priv->map;
#line 174 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp8_ = gee_multi_map_get_keys (_tmp7_);
#line 174 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp9_ = _tmp8_;
#line 174 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp10_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ITERABLE, GeeIterable));
#line 174 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp11_ = _tmp10_;
#line 174 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_object_unref0 (_tmp9_);
#line 174 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_key_it = _tmp11_;
#line 174 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		while (TRUE) {
#line 1166 "Alteration.c"
			GeeIterator* _tmp12_;
			gchar* key = NULL;
			GeeIterator* _tmp13_;
			gpointer _tmp14_;
#line 174 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp12_ = _key_it;
#line 174 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			if (!gee_iterator_next (_tmp12_)) {
#line 174 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				break;
#line 1177 "Alteration.c"
			}
#line 174 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp13_ = _key_it;
#line 174 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp14_ = gee_iterator_get (_tmp13_);
#line 174 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			key = (gchar*) _tmp14_;
#line 1185 "Alteration.c"
			{
				GeeIterator* _value_it = NULL;
				GeeMultiMap* _tmp15_;
				const gchar* _tmp16_;
				GeeCollection* _tmp17_;
				GeeCollection* _tmp18_;
				GeeIterator* _tmp19_;
				GeeIterator* _tmp20_;
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp15_ = self->priv->map;
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp16_ = key;
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp17_ = gee_multi_map_get (_tmp15_, _tmp16_);
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp18_ = _tmp17_;
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp19_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ITERABLE, GeeIterable));
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp20_ = _tmp19_;
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_g_object_unref0 (_tmp18_);
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_value_it = _tmp20_;
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				while (TRUE) {
#line 1212 "Alteration.c"
					GeeIterator* _tmp21_;
					gchar* value = NULL;
					GeeIterator* _tmp22_;
					gpointer _tmp23_;
					const gchar* _tmp24_;
					gint _tmp25_;
					gint _tmp26_;
					const gchar* _tmp29_;
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					gchar* _tmp34_;
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp21_ = _value_it;
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					if (!gee_iterator_next (_tmp21_)) {
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
						break;
#line 1232 "Alteration.c"
					}
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp22_ = _value_it;
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp23_ = gee_iterator_get (_tmp22_);
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					value = (gchar*) _tmp23_;
#line 176 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp24_ = str;
#line 176 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp25_ = strlen (_tmp24_);
#line 176 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp26_ = _tmp25_;
#line 176 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					if (_tmp26_ != 0) {
#line 1248 "Alteration.c"
						const gchar* _tmp27_;
						gchar* _tmp28_;
#line 177 "/home/jens/Source/shotwell/src/core/Alteration.vala"
						_tmp27_ = str;
#line 177 "/home/jens/Source/shotwell/src/core/Alteration.vala"
						_tmp28_ = g_strconcat (_tmp27_, ", ", NULL);
#line 177 "/home/jens/Source/shotwell/src/core/Alteration.vala"
						_g_free0 (str);
#line 177 "/home/jens/Source/shotwell/src/core/Alteration.vala"
						str = _tmp28_;
#line 1259 "Alteration.c"
					}
#line 179 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp29_ = str;
#line 179 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp30_ = key;
#line 179 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp31_ = value;
#line 179 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp32_ = g_strdup_printf ("%s:%s", _tmp30_, _tmp31_);
#line 179 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp33_ = _tmp32_;
#line 179 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp34_ = g_strconcat (_tmp29_, _tmp33_, NULL);
#line 179 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_free0 (str);
#line 179 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					str = _tmp34_;
#line 179 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_free0 (_tmp33_);
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_free0 (value);
#line 1281 "Alteration.c"
				}
#line 175 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_g_object_unref0 (_value_it);
#line 1285 "Alteration.c"
			}
#line 174 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_g_free0 (key);
#line 1289 "Alteration.c"
		}
#line 174 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_object_unref0 (_key_it);
#line 1293 "Alteration.c"
	}
#line 183 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	result = str;
#line 183 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return result;
#line 1299 "Alteration.c"
}


gboolean
alteration_contains_any (Alteration* self,
                         Alteration* other)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	GeeMultiMap* _tmp14_;
	gboolean _tmp42_ = FALSE;
	GeeMultiMap* _tmp43_;
#line 187 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (IS_ALTERATION (self), FALSE);
#line 187 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (IS_ALTERATION (other), FALSE);
#line 189 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (self == other) {
#line 190 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		result = TRUE;
#line 190 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		return result;
#line 1327 "Alteration.c"
	}
#line 193 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp3_ = self->priv->subject;
#line 193 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp3_ != NULL) {
#line 1333 "Alteration.c"
		const gchar* _tmp4_;
#line 193 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp4_ = other->priv->subject;
#line 193 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp2_ = _tmp4_ != NULL;
#line 1339 "Alteration.c"
	} else {
#line 193 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp2_ = FALSE;
#line 1343 "Alteration.c"
	}
#line 193 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp2_) {
#line 1347 "Alteration.c"
		const gchar* _tmp5_;
#line 193 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp5_ = self->priv->detail;
#line 193 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp1_ = _tmp5_ != NULL;
#line 1353 "Alteration.c"
	} else {
#line 193 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp1_ = FALSE;
#line 1357 "Alteration.c"
	}
#line 193 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp1_) {
#line 1361 "Alteration.c"
		const gchar* _tmp6_;
#line 193 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp6_ = other->priv->detail;
#line 193 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp0_ = _tmp6_ != NULL;
#line 1367 "Alteration.c"
	} else {
#line 193 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp0_ = FALSE;
#line 1371 "Alteration.c"
	}
#line 193 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp0_) {
#line 1375 "Alteration.c"
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
#line 194 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp8_ = self->priv->subject;
#line 194 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp9_ = other->priv->subject;
#line 194 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		if (alteration_equal_values (_tmp8_, _tmp9_)) {
#line 1385 "Alteration.c"
			const gchar* _tmp10_;
			const gchar* _tmp11_;
#line 194 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp10_ = self->priv->detail;
#line 194 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp11_ = other->priv->detail;
#line 194 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp7_ = alteration_equal_values (_tmp10_, _tmp11_);
#line 1394 "Alteration.c"
		} else {
#line 194 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp7_ = FALSE;
#line 1398 "Alteration.c"
		}
#line 194 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		result = _tmp7_;
#line 194 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		return result;
#line 1404 "Alteration.c"
	}
#line 197 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp14_ = self->priv->map;
#line 197 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp14_ != NULL) {
#line 1410 "Alteration.c"
		GeeMultiMap* _tmp15_;
#line 197 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp15_ = other->priv->map;
#line 197 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp13_ = _tmp15_ == NULL;
#line 1416 "Alteration.c"
	} else {
#line 197 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp13_ = FALSE;
#line 1420 "Alteration.c"
	}
#line 197 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp13_) {
#line 197 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp12_ = TRUE;
#line 1426 "Alteration.c"
	} else {
		gboolean _tmp16_ = FALSE;
		GeeMultiMap* _tmp17_;
#line 197 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp17_ = self->priv->map;
#line 197 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		if (_tmp17_ == NULL) {
#line 1434 "Alteration.c"
			GeeMultiMap* _tmp18_;
#line 197 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp18_ = other->priv->map;
#line 197 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp16_ = _tmp18_ != NULL;
#line 1440 "Alteration.c"
		} else {
#line 197 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp16_ = FALSE;
#line 1444 "Alteration.c"
		}
#line 197 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp12_ = _tmp16_;
#line 1448 "Alteration.c"
	}
#line 197 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp12_) {
#line 1452 "Alteration.c"
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		gchar* single_subject = NULL;
		gchar* _tmp23_;
		const gchar* _tmp24_ = NULL;
		const gchar* _tmp25_;
		gchar* single_detail = NULL;
		gchar* _tmp28_;
		GeeMultiMap* _tmp29_ = NULL;
		GeeMultiMap* _tmp30_;
		GeeMultiMap* multimap = NULL;
		GeeMultiMap* _tmp33_;
		gboolean _tmp34_ = FALSE;
		GeeMultiMap* _tmp35_;
		const gchar* _tmp36_;
#line 198 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp20_ = self->priv->subject;
#line 198 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		if (_tmp20_ != NULL) {
#line 1472 "Alteration.c"
			const gchar* _tmp21_;
#line 198 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp21_ = self->priv->subject;
#line 198 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp19_ = _tmp21_;
#line 1478 "Alteration.c"
		} else {
			const gchar* _tmp22_;
#line 198 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp22_ = other->priv->subject;
#line 198 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp19_ = _tmp22_;
#line 1485 "Alteration.c"
		}
#line 198 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp23_ = g_strdup (_tmp19_);
#line 198 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		single_subject = _tmp23_;
#line 199 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp25_ = self->priv->detail;
#line 199 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		if (_tmp25_ != NULL) {
#line 1495 "Alteration.c"
			const gchar* _tmp26_;
#line 199 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp26_ = self->priv->detail;
#line 199 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp24_ = _tmp26_;
#line 1501 "Alteration.c"
		} else {
			const gchar* _tmp27_;
#line 199 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp27_ = other->priv->detail;
#line 199 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp24_ = _tmp27_;
#line 1508 "Alteration.c"
		}
#line 199 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp28_ = g_strdup (_tmp24_);
#line 199 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		single_detail = _tmp28_;
#line 200 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp30_ = self->priv->map;
#line 200 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		if (_tmp30_ != NULL) {
#line 1518 "Alteration.c"
			GeeMultiMap* _tmp31_;
#line 200 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp31_ = self->priv->map;
#line 200 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp29_ = _tmp31_;
#line 1524 "Alteration.c"
		} else {
			GeeMultiMap* _tmp32_;
#line 200 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp32_ = other->priv->map;
#line 200 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp29_ = _tmp32_;
#line 1531 "Alteration.c"
		}
#line 200 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp33_ = _g_object_ref0 (_tmp29_);
#line 200 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		multimap = _tmp33_;
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp35_ = multimap;
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp36_ = single_subject;
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		if (gee_multi_map_contains (_tmp35_, _tmp36_)) {
#line 1543 "Alteration.c"
			GeeMultiMap* _tmp37_;
			const gchar* _tmp38_;
			GeeCollection* _tmp39_;
			GeeCollection* _tmp40_;
			const gchar* _tmp41_;
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp37_ = self->priv->map;
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp38_ = single_subject;
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp39_ = gee_multi_map_get (_tmp37_, _tmp38_);
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp40_ = _tmp39_;
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp41_ = single_detail;
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp34_ = gee_collection_contains (_tmp40_, _tmp41_);
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_g_object_unref0 (_tmp40_);
#line 1563 "Alteration.c"
		} else {
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp34_ = FALSE;
#line 1567 "Alteration.c"
		}
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		result = _tmp34_;
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_object_unref0 (multimap);
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_free0 (single_detail);
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_free0 (single_subject);
#line 202 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		return result;
#line 1579 "Alteration.c"
	}
#line 206 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp43_ = self->priv->map;
#line 206 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp43_ != NULL) {
#line 1585 "Alteration.c"
		GeeMultiMap* _tmp44_;
#line 206 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp44_ = other->priv->map;
#line 206 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp42_ = _tmp44_ != NULL;
#line 1591 "Alteration.c"
	} else {
#line 206 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp42_ = FALSE;
#line 1595 "Alteration.c"
	}
#line 206 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp42_) {
#line 1599 "Alteration.c"
		GeeSet* keys = NULL;
		GeeMultiMap* _tmp45_;
		GeeSet* _tmp46_;
		GeeSet* _tmp47_;
		GeeSet* other_keys = NULL;
		GeeMultiMap* _tmp48_;
		GeeSet* _tmp49_;
		GeeSet* _tmp50_;
#line 207 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp45_ = self->priv->map;
#line 207 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp46_ = gee_multi_map_get_keys (_tmp45_);
#line 207 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		keys = _tmp46_;
#line 208 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp47_ = keys;
#line 208 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_vala_assert (_tmp47_ != NULL, "keys != null");
#line 209 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp48_ = other->priv->map;
#line 209 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp49_ = gee_multi_map_get_keys (_tmp48_);
#line 209 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		other_keys = _tmp49_;
#line 210 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp50_ = other_keys;
#line 210 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_vala_assert (_tmp50_ != NULL, "other_keys != null");
#line 1628 "Alteration.c"
		{
			GeeIterator* _subject_it = NULL;
			GeeSet* _tmp51_;
			GeeIterator* _tmp52_;
#line 212 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp51_ = other_keys;
#line 212 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp52_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, GEE_TYPE_ITERABLE, GeeIterable));
#line 212 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_subject_it = _tmp52_;
#line 212 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			while (TRUE) {
#line 1641 "Alteration.c"
				GeeIterator* _tmp53_;
				gchar* subject = NULL;
				GeeIterator* _tmp54_;
				gpointer _tmp55_;
				GeeSet* _tmp56_;
				const gchar* _tmp57_;
				GeeCollection* details = NULL;
				GeeMultiMap* _tmp58_;
				const gchar* _tmp59_;
				GeeCollection* _tmp60_;
				GeeCollection* other_details = NULL;
				GeeMultiMap* _tmp61_;
				const gchar* _tmp62_;
				GeeCollection* _tmp63_;
				gboolean _tmp64_ = FALSE;
				GeeCollection* _tmp65_;
#line 212 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp53_ = _subject_it;
#line 212 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				if (!gee_iterator_next (_tmp53_)) {
#line 212 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					break;
#line 1664 "Alteration.c"
				}
#line 212 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp54_ = _subject_it;
#line 212 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp55_ = gee_iterator_get (_tmp54_);
#line 212 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				subject = (gchar*) _tmp55_;
#line 213 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp56_ = keys;
#line 213 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp57_ = subject;
#line 213 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				if (!gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, GEE_TYPE_COLLECTION, GeeCollection), _tmp57_)) {
#line 214 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_free0 (subject);
#line 214 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					continue;
#line 1682 "Alteration.c"
				}
#line 216 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp58_ = self->priv->map;
#line 216 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp59_ = subject;
#line 216 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp60_ = gee_multi_map_get (_tmp58_, _tmp59_);
#line 216 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				details = _tmp60_;
#line 217 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp61_ = other->priv->map;
#line 217 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp62_ = subject;
#line 217 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp63_ = gee_multi_map_get (_tmp61_, _tmp62_);
#line 217 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				other_details = _tmp63_;
#line 219 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp65_ = details;
#line 219 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				if (_tmp65_ != NULL) {
#line 1704 "Alteration.c"
					GeeCollection* _tmp66_;
#line 219 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp66_ = other_details;
#line 219 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp64_ = _tmp66_ != NULL;
#line 1710 "Alteration.c"
				} else {
#line 219 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp64_ = FALSE;
#line 1714 "Alteration.c"
				}
#line 219 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				if (_tmp64_) {
#line 1718 "Alteration.c"
					{
						GeeIterator* _detail_it = NULL;
						GeeCollection* _tmp67_;
						GeeIterator* _tmp68_;
#line 220 "/home/jens/Source/shotwell/src/core/Alteration.vala"
						_tmp67_ = other_details;
#line 220 "/home/jens/Source/shotwell/src/core/Alteration.vala"
						_tmp68_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, GEE_TYPE_ITERABLE, GeeIterable));
#line 220 "/home/jens/Source/shotwell/src/core/Alteration.vala"
						_detail_it = _tmp68_;
#line 220 "/home/jens/Source/shotwell/src/core/Alteration.vala"
						while (TRUE) {
#line 1731 "Alteration.c"
							GeeIterator* _tmp69_;
							gchar* detail = NULL;
							GeeIterator* _tmp70_;
							gpointer _tmp71_;
							GeeCollection* _tmp72_;
							const gchar* _tmp73_;
#line 220 "/home/jens/Source/shotwell/src/core/Alteration.vala"
							_tmp69_ = _detail_it;
#line 220 "/home/jens/Source/shotwell/src/core/Alteration.vala"
							if (!gee_iterator_next (_tmp69_)) {
#line 220 "/home/jens/Source/shotwell/src/core/Alteration.vala"
								break;
#line 1744 "Alteration.c"
							}
#line 220 "/home/jens/Source/shotwell/src/core/Alteration.vala"
							_tmp70_ = _detail_it;
#line 220 "/home/jens/Source/shotwell/src/core/Alteration.vala"
							_tmp71_ = gee_iterator_get (_tmp70_);
#line 220 "/home/jens/Source/shotwell/src/core/Alteration.vala"
							detail = (gchar*) _tmp71_;
#line 221 "/home/jens/Source/shotwell/src/core/Alteration.vala"
							_tmp72_ = details;
#line 221 "/home/jens/Source/shotwell/src/core/Alteration.vala"
							_tmp73_ = detail;
#line 221 "/home/jens/Source/shotwell/src/core/Alteration.vala"
							if (gee_collection_contains (_tmp72_, _tmp73_)) {
#line 222 "/home/jens/Source/shotwell/src/core/Alteration.vala"
								result = TRUE;
#line 222 "/home/jens/Source/shotwell/src/core/Alteration.vala"
								_g_free0 (detail);
#line 222 "/home/jens/Source/shotwell/src/core/Alteration.vala"
								_g_object_unref0 (_detail_it);
#line 222 "/home/jens/Source/shotwell/src/core/Alteration.vala"
								_g_object_unref0 (other_details);
#line 222 "/home/jens/Source/shotwell/src/core/Alteration.vala"
								_g_object_unref0 (details);
#line 222 "/home/jens/Source/shotwell/src/core/Alteration.vala"
								_g_free0 (subject);
#line 222 "/home/jens/Source/shotwell/src/core/Alteration.vala"
								_g_object_unref0 (_subject_it);
#line 222 "/home/jens/Source/shotwell/src/core/Alteration.vala"
								_g_object_unref0 (other_keys);
#line 222 "/home/jens/Source/shotwell/src/core/Alteration.vala"
								_g_object_unref0 (keys);
#line 222 "/home/jens/Source/shotwell/src/core/Alteration.vala"
								return result;
#line 1778 "Alteration.c"
							}
#line 220 "/home/jens/Source/shotwell/src/core/Alteration.vala"
							_g_free0 (detail);
#line 1782 "Alteration.c"
						}
#line 220 "/home/jens/Source/shotwell/src/core/Alteration.vala"
						_g_object_unref0 (_detail_it);
#line 1786 "Alteration.c"
					}
				}
#line 212 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_g_object_unref0 (other_details);
#line 212 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_g_object_unref0 (details);
#line 212 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_g_free0 (subject);
#line 1795 "Alteration.c"
			}
#line 212 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_g_object_unref0 (_subject_it);
#line 1799 "Alteration.c"
		}
#line 206 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_object_unref0 (other_keys);
#line 206 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_object_unref0 (keys);
#line 1805 "Alteration.c"
	}
#line 228 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	result = FALSE;
#line 228 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return result;
#line 1811 "Alteration.c"
}


gboolean
alteration_equals (Alteration* self,
                   Alteration* other)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp12_ = FALSE;
	GeeMultiMap* _tmp13_;
#line 231 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (IS_ALTERATION (self), FALSE);
#line 231 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (IS_ALTERATION (other), FALSE);
#line 233 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (self == other) {
#line 234 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		result = TRUE;
#line 234 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		return result;
#line 1836 "Alteration.c"
	}
#line 237 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp3_ = self->priv->subject;
#line 237 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp3_ != NULL) {
#line 1842 "Alteration.c"
		const gchar* _tmp4_;
#line 237 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp4_ = other->priv->subject;
#line 237 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp2_ = _tmp4_ != NULL;
#line 1848 "Alteration.c"
	} else {
#line 237 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp2_ = FALSE;
#line 1852 "Alteration.c"
	}
#line 237 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp2_) {
#line 1856 "Alteration.c"
		const gchar* _tmp5_;
#line 237 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp5_ = self->priv->detail;
#line 237 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp1_ = _tmp5_ != NULL;
#line 1862 "Alteration.c"
	} else {
#line 237 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp1_ = FALSE;
#line 1866 "Alteration.c"
	}
#line 237 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp1_) {
#line 1870 "Alteration.c"
		const gchar* _tmp6_;
#line 237 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp6_ = other->priv->detail;
#line 237 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp0_ = _tmp6_ != NULL;
#line 1876 "Alteration.c"
	} else {
#line 237 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp0_ = FALSE;
#line 1880 "Alteration.c"
	}
#line 237 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp0_) {
#line 1884 "Alteration.c"
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
#line 238 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp8_ = self->priv->subject;
#line 238 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp9_ = other->priv->subject;
#line 238 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		if (alteration_equal_values (_tmp8_, _tmp9_)) {
#line 1894 "Alteration.c"
			const gchar* _tmp10_;
			const gchar* _tmp11_;
#line 238 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp10_ = self->priv->detail;
#line 238 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp11_ = other->priv->detail;
#line 238 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp7_ = alteration_equal_values (_tmp10_, _tmp11_);
#line 1903 "Alteration.c"
		} else {
#line 238 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp7_ = FALSE;
#line 1907 "Alteration.c"
		}
#line 238 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		result = _tmp7_;
#line 238 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		return result;
#line 1913 "Alteration.c"
	}
#line 241 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp13_ = self->priv->map;
#line 241 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp13_ != NULL) {
#line 1919 "Alteration.c"
		GeeMultiMap* _tmp14_;
#line 241 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp14_ = other->priv->map;
#line 241 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp12_ = _tmp14_ != NULL;
#line 1925 "Alteration.c"
	} else {
#line 241 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp12_ = FALSE;
#line 1929 "Alteration.c"
	}
#line 241 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp12_) {
#line 1933 "Alteration.c"
		GeeSet* keys = NULL;
		GeeMultiMap* _tmp15_;
		GeeSet* _tmp16_;
		GeeSet* _tmp17_;
		GeeSet* other_keys = NULL;
		GeeMultiMap* _tmp18_;
		GeeSet* _tmp19_;
		GeeSet* _tmp20_;
		GeeSet* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		GeeSet* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		GeeSet* _tmp27_;
		GeeSet* _tmp28_;
		GeeSet* _tmp29_;
		GeeSet* _tmp30_;
#line 243 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp15_ = self->priv->map;
#line 243 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp16_ = gee_multi_map_get_keys (_tmp15_);
#line 243 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		keys = _tmp16_;
#line 244 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp17_ = keys;
#line 244 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_vala_assert (_tmp17_ != NULL, "keys != null");
#line 245 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp18_ = other->priv->map;
#line 245 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp19_ = gee_multi_map_get_keys (_tmp18_);
#line 245 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		other_keys = _tmp19_;
#line 246 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp20_ = other_keys;
#line 246 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_vala_assert (_tmp20_ != NULL, "other_keys != null");
#line 248 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp21_ = keys;
#line 248 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp22_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_COLLECTION, GeeCollection));
#line 248 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp23_ = _tmp22_;
#line 248 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp24_ = other_keys;
#line 248 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp25_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_COLLECTION, GeeCollection));
#line 248 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp26_ = _tmp25_;
#line 248 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		if (_tmp23_ != _tmp26_) {
#line 249 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			result = FALSE;
#line 249 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_g_object_unref0 (other_keys);
#line 249 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_g_object_unref0 (keys);
#line 249 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			return result;
#line 1994 "Alteration.c"
		}
#line 251 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp27_ = keys;
#line 251 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp28_ = other_keys;
#line 251 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		if (!gee_collection_contains_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GEE_TYPE_COLLECTION, GeeCollection))) {
#line 252 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			result = FALSE;
#line 252 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_g_object_unref0 (other_keys);
#line 252 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_g_object_unref0 (keys);
#line 252 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			return result;
#line 2010 "Alteration.c"
		}
#line 254 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp29_ = other_keys;
#line 254 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp30_ = keys;
#line 254 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		if (!gee_collection_contains_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEE_TYPE_COLLECTION, GeeCollection))) {
#line 255 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			result = FALSE;
#line 255 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_g_object_unref0 (other_keys);
#line 255 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_g_object_unref0 (keys);
#line 255 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			return result;
#line 2026 "Alteration.c"
		}
		{
			GeeIterator* _key_it = NULL;
			GeeSet* _tmp31_;
			GeeIterator* _tmp32_;
#line 257 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp31_ = keys;
#line 257 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp32_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GEE_TYPE_ITERABLE, GeeIterable));
#line 257 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_key_it = _tmp32_;
#line 257 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			while (TRUE) {
#line 2040 "Alteration.c"
				GeeIterator* _tmp33_;
				gchar* key = NULL;
				GeeIterator* _tmp34_;
				gpointer _tmp35_;
				GeeCollection* values = NULL;
				GeeMultiMap* _tmp36_;
				const gchar* _tmp37_;
				GeeCollection* _tmp38_;
				GeeCollection* other_values = NULL;
				GeeMultiMap* _tmp39_;
				const gchar* _tmp40_;
				GeeCollection* _tmp41_;
				GeeCollection* _tmp42_;
				gint _tmp43_;
				gint _tmp44_;
				GeeCollection* _tmp45_;
				gint _tmp46_;
				gint _tmp47_;
				GeeCollection* _tmp48_;
				GeeCollection* _tmp49_;
				GeeCollection* _tmp50_;
				GeeCollection* _tmp51_;
#line 257 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp33_ = _key_it;
#line 257 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				if (!gee_iterator_next (_tmp33_)) {
#line 257 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					break;
#line 2069 "Alteration.c"
				}
#line 257 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp34_ = _key_it;
#line 257 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp35_ = gee_iterator_get (_tmp34_);
#line 257 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				key = (gchar*) _tmp35_;
#line 258 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp36_ = self->priv->map;
#line 258 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp37_ = key;
#line 258 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp38_ = gee_multi_map_get (_tmp36_, _tmp37_);
#line 258 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				values = _tmp38_;
#line 259 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp39_ = other->priv->map;
#line 259 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp40_ = key;
#line 259 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp41_ = gee_multi_map_get (_tmp39_, _tmp40_);
#line 259 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				other_values = _tmp41_;
#line 261 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp42_ = values;
#line 261 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp43_ = gee_collection_get_size (_tmp42_);
#line 261 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp44_ = _tmp43_;
#line 261 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp45_ = other_values;
#line 261 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp46_ = gee_collection_get_size (_tmp45_);
#line 261 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp47_ = _tmp46_;
#line 261 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				if (_tmp44_ != _tmp47_) {
#line 262 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					result = FALSE;
#line 262 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (other_values);
#line 262 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (values);
#line 262 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_free0 (key);
#line 262 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (_key_it);
#line 262 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (other_keys);
#line 262 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (keys);
#line 262 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					return result;
#line 2123 "Alteration.c"
				}
#line 264 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp48_ = values;
#line 264 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp49_ = other_values;
#line 264 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				if (!gee_collection_contains_all (_tmp48_, _tmp49_)) {
#line 265 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					result = FALSE;
#line 265 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (other_values);
#line 265 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (values);
#line 265 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_free0 (key);
#line 265 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (_key_it);
#line 265 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (other_keys);
#line 265 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (keys);
#line 265 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					return result;
#line 2147 "Alteration.c"
				}
#line 267 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp50_ = other_values;
#line 267 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp51_ = values;
#line 267 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				if (!gee_collection_contains_all (_tmp50_, _tmp51_)) {
#line 268 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					result = FALSE;
#line 268 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (other_values);
#line 268 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (values);
#line 268 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_free0 (key);
#line 268 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (_key_it);
#line 268 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (other_keys);
#line 268 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_object_unref0 (keys);
#line 268 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					return result;
#line 2171 "Alteration.c"
				}
#line 257 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_g_object_unref0 (other_values);
#line 257 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_g_object_unref0 (values);
#line 257 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_g_free0 (key);
#line 2179 "Alteration.c"
			}
#line 257 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_g_object_unref0 (_key_it);
#line 2183 "Alteration.c"
		}
#line 272 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		result = TRUE;
#line 272 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_object_unref0 (other_keys);
#line 272 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_object_unref0 (keys);
#line 272 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		return result;
#line 2193 "Alteration.c"
	}
#line 276 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	result = FALSE;
#line 276 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return result;
#line 2199 "Alteration.c"
}


static void
alteration_multimap_add_all (GeeMultiMap* dest,
                             GeeMultiMap* src)
{
	GeeSet* keys = NULL;
	GeeSet* _tmp0_;
#line 279 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_if_fail (GEE_IS_MULTI_MAP (dest));
#line 279 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_if_fail (GEE_IS_MULTI_MAP (src));
#line 281 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp0_ = gee_multi_map_get_keys (src);
#line 281 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	keys = _tmp0_;
#line 2217 "Alteration.c"
	{
		GeeIterator* _key_it = NULL;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_;
#line 282 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp1_ = keys;
#line 282 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
#line 282 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_key_it = _tmp2_;
#line 282 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		while (TRUE) {
#line 2230 "Alteration.c"
			GeeIterator* _tmp3_;
			gchar* key = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			GeeCollection* values = NULL;
			const gchar* _tmp6_;
			GeeCollection* _tmp7_;
#line 282 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp3_ = _key_it;
#line 282 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			if (!gee_iterator_next (_tmp3_)) {
#line 282 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				break;
#line 2244 "Alteration.c"
			}
#line 282 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp4_ = _key_it;
#line 282 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 282 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			key = (gchar*) _tmp5_;
#line 283 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp6_ = key;
#line 283 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_tmp7_ = gee_multi_map_get (src, _tmp6_);
#line 283 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			values = _tmp7_;
#line 2258 "Alteration.c"
			{
				GeeIterator* _value_it = NULL;
				GeeCollection* _tmp8_;
				GeeIterator* _tmp9_;
#line 284 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp8_ = values;
#line 284 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_tmp9_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ITERABLE, GeeIterable));
#line 284 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_value_it = _tmp9_;
#line 284 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				while (TRUE) {
#line 2271 "Alteration.c"
					GeeIterator* _tmp10_;
					gchar* value = NULL;
					GeeIterator* _tmp11_;
					gpointer _tmp12_;
					const gchar* _tmp13_;
					const gchar* _tmp14_;
#line 284 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp10_ = _value_it;
#line 284 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					if (!gee_iterator_next (_tmp10_)) {
#line 284 "/home/jens/Source/shotwell/src/core/Alteration.vala"
						break;
#line 2284 "Alteration.c"
					}
#line 284 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp11_ = _value_it;
#line 284 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp12_ = gee_iterator_get (_tmp11_);
#line 284 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					value = (gchar*) _tmp12_;
#line 285 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp13_ = key;
#line 285 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_tmp14_ = value;
#line 285 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					gee_multi_map_set (dest, _tmp13_, _tmp14_);
#line 284 "/home/jens/Source/shotwell/src/core/Alteration.vala"
					_g_free0 (value);
#line 2300 "Alteration.c"
				}
#line 284 "/home/jens/Source/shotwell/src/core/Alteration.vala"
				_g_object_unref0 (_value_it);
#line 2304 "Alteration.c"
			}
#line 282 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_g_object_unref0 (values);
#line 282 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			_g_free0 (key);
#line 2310 "Alteration.c"
		}
#line 282 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_g_object_unref0 (_key_it);
#line 2314 "Alteration.c"
	}
#line 279 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_g_object_unref0 (keys);
#line 2318 "Alteration.c"
}


static gpointer
_alteration_ref0 (gpointer self)
{
#line 293 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return self ? alteration_ref (self) : NULL;
#line 2327 "Alteration.c"
}


Alteration*
alteration_compress (Alteration* self,
                     Alteration* other)
{
	Alteration* result = NULL;
	GeeMultiMap* compressed = NULL;
	GeeMultiMap* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp12_;
	GeeMultiMap* _tmp20_;
	Alteration* _tmp21_;
#line 291 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (IS_ALTERATION (self), NULL);
#line 291 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (IS_ALTERATION (other), NULL);
#line 292 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (alteration_equals (self, other)) {
#line 2350 "Alteration.c"
		Alteration* _tmp0_;
#line 293 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp0_ = _alteration_ref0 (self);
#line 293 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		result = _tmp0_;
#line 293 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		return result;
#line 2358 "Alteration.c"
	}
#line 297 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp1_ = alteration_create_map (self);
#line 297 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	compressed = _tmp1_;
#line 299 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp3_ = self->priv->subject;
#line 299 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp3_ != NULL) {
#line 2368 "Alteration.c"
		const gchar* _tmp4_;
#line 299 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp4_ = self->priv->detail;
#line 299 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp2_ = _tmp4_ != NULL;
#line 2374 "Alteration.c"
	} else {
#line 299 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp2_ = FALSE;
#line 2378 "Alteration.c"
	}
#line 299 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp2_) {
#line 2382 "Alteration.c"
		GeeMultiMap* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
#line 300 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp5_ = compressed;
#line 300 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp6_ = self->priv->subject;
#line 300 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp7_ = self->priv->detail;
#line 300 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		gee_multi_map_set (_tmp5_, _tmp6_, _tmp7_);
#line 2394 "Alteration.c"
	} else {
		GeeMultiMap* _tmp8_;
		GeeMultiMap* _tmp9_;
		GeeMultiMap* _tmp10_;
#line 302 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp8_ = self->priv->map;
#line 302 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_vala_assert (_tmp8_ != NULL, "map != null");
#line 303 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp9_ = compressed;
#line 303 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp10_ = self->priv->map;
#line 303 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		alteration_multimap_add_all (_tmp9_, _tmp10_);
#line 2409 "Alteration.c"
	}
#line 306 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp12_ = other->priv->subject;
#line 306 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp12_ != NULL) {
#line 2415 "Alteration.c"
		const gchar* _tmp13_;
#line 306 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp13_ = other->priv->detail;
#line 306 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp11_ = _tmp13_ != NULL;
#line 2421 "Alteration.c"
	} else {
#line 306 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp11_ = FALSE;
#line 2425 "Alteration.c"
	}
#line 306 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (_tmp11_) {
#line 2429 "Alteration.c"
		GeeMultiMap* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
#line 307 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp14_ = compressed;
#line 307 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp15_ = other->priv->subject;
#line 307 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp16_ = other->priv->detail;
#line 307 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		gee_multi_map_set (_tmp14_, _tmp15_, _tmp16_);
#line 2441 "Alteration.c"
	} else {
		GeeMultiMap* _tmp17_;
		GeeMultiMap* _tmp18_;
		GeeMultiMap* _tmp19_;
#line 309 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp17_ = other->priv->map;
#line 309 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_vala_assert (_tmp17_ != NULL, "other.map != null");
#line 310 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp18_ = compressed;
#line 310 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		_tmp19_ = other->priv->map;
#line 310 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		alteration_multimap_add_all (_tmp18_, _tmp19_);
#line 2456 "Alteration.c"
	}
#line 313 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp20_ = compressed;
#line 313 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_tmp21_ = alteration_new_from_map (_tmp20_);
#line 313 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	result = _tmp21_;
#line 313 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_g_object_unref0 (compressed);
#line 313 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return result;
#line 2468 "Alteration.c"
}


static void
value_alteration_init (GValue* value)
{
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	value->data[0].v_pointer = NULL;
#line 2477 "Alteration.c"
}


static void
value_alteration_free_value (GValue* value)
{
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (value->data[0].v_pointer) {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		alteration_unref (value->data[0].v_pointer);
#line 2488 "Alteration.c"
	}
}


static void
value_alteration_copy_value (const GValue* src_value,
                             GValue* dest_value)
{
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (src_value->data[0].v_pointer) {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		dest_value->data[0].v_pointer = alteration_ref (src_value->data[0].v_pointer);
#line 2501 "Alteration.c"
	} else {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2505 "Alteration.c"
	}
}


static gpointer
value_alteration_peek_pointer (const GValue* value)
{
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return value->data[0].v_pointer;
#line 2515 "Alteration.c"
}


static gchar*
value_alteration_collect_value (GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (collect_values[0].v_pointer) {
#line 2527 "Alteration.c"
		Alteration * object;
		object = collect_values[0].v_pointer;
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		if (object->parent_instance.g_class == NULL) {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2534 "Alteration.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2538 "Alteration.c"
		}
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		value->data[0].v_pointer = alteration_ref (object);
#line 2542 "Alteration.c"
	} else {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		value->data[0].v_pointer = NULL;
#line 2546 "Alteration.c"
	}
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return NULL;
#line 2550 "Alteration.c"
}


static gchar*
value_alteration_lcopy_value (const GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	Alteration ** object_p;
	object_p = collect_values[0].v_pointer;
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (!object_p) {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2566 "Alteration.c"
	}
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (!value->data[0].v_pointer) {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		*object_p = NULL;
#line 2572 "Alteration.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		*object_p = value->data[0].v_pointer;
#line 2576 "Alteration.c"
	} else {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		*object_p = alteration_ref (value->data[0].v_pointer);
#line 2580 "Alteration.c"
	}
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return NULL;
#line 2584 "Alteration.c"
}


GParamSpec*
param_spec_alteration (const gchar* name,
                       const gchar* nick,
                       const gchar* blurb,
                       GType object_type,
                       GParamFlags flags)
{
	ParamSpecAlteration* spec;
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ALTERATION), NULL);
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return G_PARAM_SPEC (spec);
#line 2604 "Alteration.c"
}


gpointer
value_get_alteration (const GValue* value)
{
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ALTERATION), NULL);
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return value->data[0].v_pointer;
#line 2615 "Alteration.c"
}


void
value_set_alteration (GValue* value,
                      gpointer v_object)
{
	Alteration * old;
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ALTERATION));
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	old = value->data[0].v_pointer;
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (v_object) {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ALTERATION));
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		value->data[0].v_pointer = v_object;
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		alteration_ref (value->data[0].v_pointer);
#line 2638 "Alteration.c"
	} else {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		value->data[0].v_pointer = NULL;
#line 2642 "Alteration.c"
	}
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (old) {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		alteration_unref (old);
#line 2648 "Alteration.c"
	}
}


void
value_take_alteration (GValue* value,
                       gpointer v_object)
{
	Alteration * old;
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ALTERATION));
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	old = value->data[0].v_pointer;
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (v_object) {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ALTERATION));
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		value->data[0].v_pointer = v_object;
#line 2670 "Alteration.c"
	} else {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		value->data[0].v_pointer = NULL;
#line 2674 "Alteration.c"
	}
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (old) {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		alteration_unref (old);
#line 2680 "Alteration.c"
	}
}


static void
alteration_class_init (AlterationClass * klass)
{
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	alteration_parent_class = g_type_class_peek_parent (klass);
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	((AlterationClass *) klass)->finalize = alteration_finalize;
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_type_class_add_private (klass, sizeof (AlterationPrivate));
#line 2694 "Alteration.c"
}


static void
alteration_instance_init (Alteration * self)
{
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	self->priv = ALTERATION_GET_PRIVATE (self);
#line 28 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	self->priv->subject = NULL;
#line 29 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	self->priv->detail = NULL;
#line 30 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	self->priv->map = NULL;
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	self->ref_count = 1;
#line 2711 "Alteration.c"
}


static void
alteration_finalize (Alteration * obj)
{
	Alteration * self;
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ALTERATION, Alteration);
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_signal_handlers_destroy (self);
#line 28 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_g_free0 (self->priv->subject);
#line 29 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_g_free0 (self->priv->detail);
#line 30 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	_g_object_unref0 (self->priv->map);
#line 2729 "Alteration.c"
}


GType
alteration_get_type (void)
{
	static volatile gsize alteration_type_id__volatile = 0;
	if (g_once_init_enter (&alteration_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_alteration_init, value_alteration_free_value, value_alteration_copy_value, value_alteration_peek_pointer, "p", value_alteration_collect_value, "p", value_alteration_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AlterationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) alteration_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Alteration), 0, (GInstanceInitFunc) alteration_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType alteration_type_id;
		alteration_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Alteration", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&alteration_type_id__volatile, alteration_type_id);
	}
	return alteration_type_id__volatile;
}


gpointer
alteration_ref (gpointer instance)
{
	Alteration * self;
	self = instance;
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	g_atomic_int_inc (&self->ref_count);
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	return instance;
#line 2758 "Alteration.c"
}


void
alteration_unref (gpointer instance)
{
	Alteration * self;
	self = instance;
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		ALTERATION_GET_CLASS (self)->finalize (self);
#line 27 "/home/jens/Source/shotwell/src/core/Alteration.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2773 "Alteration.c"
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



