/*
 * Decompiled with CFR 0.152.
 */
package org.probatron.officeotron;

import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.probatron.officeotron.WebSubmission;
import org.probatron.officeotron.WebTask;
import org.probatron.officeotron.sessionstorage.Store;

public class ValidatorServlet
extends HttpServlet {
    private static Semaphore sem;
    static Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ServletContext servletContext = this.getServletContext();
        Object object = ValidatorServlet.class;
        synchronized (ValidatorServlet.class) {
            int n;
            if (sem == null) {
                n = Integer.parseInt(servletContext.getInitParameter("maxproc"));
                sem = new Semaphore(n);
                logger.info("maxproc=" + n);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            Store.init(servletContext.getInitParameter("temp-folder"), true);
            if (!this.contentLengthOkay(httpServletRequest)) {
                httpServletResponse.sendError(412, "Request body length exceeds the permitted maximum");
                return;
            }
            object = new WebSubmission(httpServletRequest);
            n = ((WebSubmission)object).fetchFromClient();
            if (n != 200) {
                httpServletResponse.sendError(n, ((WebSubmission)object).getResponseErr());
                return;
            }
            WebTask webTask = new WebTask((WebSubmission)object, httpServletResponse);
            try {
                sem.acquire();
                webTask.run();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            finally {
                sem.release();
            }
            return;
        }
    }

    boolean contentLengthOkay(HttpServletRequest httpServletRequest) throws IOException {
        ServletContext servletContext;
        int n;
        int n2 = httpServletRequest.getContentLength();
        return n2 <= (n = Integer.parseInt((servletContext = this.getServletContext()).getInitParameter("max-upload")));
    }

    static {
        logger = Logger.getLogger(ValidatorServlet.class);
        String string = System.getProperty("property://probatron.org/officeotron-log-level");
        string = string == null ? "ERROR" : string;
        Properties properties = new Properties();
        properties.setProperty("log4j.rootCategory", string + ", A1");
        properties.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        properties.setProperty("log4j.appender.A1.target", "System.err");
        properties.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        properties.setProperty("log4j.appender.A1.layout.ConversionPattern", "[%d{DATE}] %c %p - %m%n");
        PropertyConfigurator.configure(properties);
    }
}

