# wrench

`wrench` is a tool for debugging webrender outside of a browser engine.

## headless

`wrench` has an optional headless mode for use in continuous integration. To run in headless mode, instead of using `cargo run -- args`, use `./headless.py args`.

## `replay` and `show`

Binary recordings can be generated by webrender and replayed with `wrench replay`. Enable binary recording in `RendererOptions`.

```rust
RendererOptions {
    ...
    recorder: Some(Box::new(BinaryRecorder::new("wr-frame.bin"))),
    ...
}
```

If you are working on gecko integration you can enable recording in `webrender_bindings/src/bindings.rs` by setting

```rust
static ENABLE_RECORDING: bool = true;
```

`wrench replay --save yaml` will convert the recording into frames described in yaml. Frames can then be replayed with `wrench show`.

## `reftest`

Wrench also has a reftest system for catching regressions.
* To run all reftests, run `script/headless.py reftest`
* To run specific reftests, run `script/headless.py reftest path/to/test/or/dir`
* To examine test failures, use the [reftest analyzer](https://hg.mozilla.org/mozilla-central/raw-file/tip/layout/tools/reftest/reftest-analyzer.xhtml)
* To add a new reftest, create an example frame and a reference frame in `reftests/` and then add an entry to `reftests/reftest.list`
