/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */
#ifndef _mozilla_dom_ServiceWorkerDescriptor_h
#define _mozilla_dom_ServiceWorkerDescriptor_h

#include "nsString.h"

class nsIPrincipal;

namespace mozilla {

namespace ipc {
class PrincipalInfo;
} // namespace ipc

namespace dom {

class IPCServiceWorkerDescriptor;
enum class ServiceWorkerState : uint8_t;

// This class represents a snapshot of a particular ServiceWorkerInfo object.
// It is threadsafe and can be transferred across processes.  This is useful
// because most of its values are immutable and can be relied upon to be
// accurate. Currently the only variable field is the ServiceWorkerState.
class ServiceWorkerDescriptor final
{
  // This class is largely a wrapper wround an IPDL generated struct.  We
  // need the wrapper class since IPDL generated code includes windows.h
  // which is in turn incompatible with bindings code.
  UniquePtr<IPCServiceWorkerDescriptor> mData;

public:
  ServiceWorkerDescriptor(uint64_t aId,
                          nsIPrincipal* aPrincipal,
                          const nsACString& aScope,
                          ServiceWorkerState aState);

  ServiceWorkerDescriptor(uint64_t aId,
                          const mozilla::ipc::PrincipalInfo& aPrincipalInfo,
                          const nsACString& aScope,
                          ServiceWorkerState aState);

  explicit ServiceWorkerDescriptor(const IPCServiceWorkerDescriptor& aDescriptor);

  ServiceWorkerDescriptor(const ServiceWorkerDescriptor& aRight);

  ServiceWorkerDescriptor&
  operator=(const ServiceWorkerDescriptor& aRight);

  ServiceWorkerDescriptor(ServiceWorkerDescriptor&& aRight);

  ServiceWorkerDescriptor&
  operator=(ServiceWorkerDescriptor&& aRight);

  ~ServiceWorkerDescriptor();

  bool
  operator==(const ServiceWorkerDescriptor& aRight) const;

  uint64_t
  Id() const;

  const mozilla::ipc::PrincipalInfo&
  PrincipalInfo() const;

  const nsCString&
  Scope() const;

  ServiceWorkerState
  State() const;

  void
  SetState(ServiceWorkerState aState);

  // Expose the underlying IPC type so that it can be passed via IPC.
  const IPCServiceWorkerDescriptor&
  ToIPC() const;
};

} // namespace dom
} // namespace mozilla

#endif // _mozilla_dom_ServiceWorkerDescriptor_h
