// Copyright 2020 the V8 project authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

/**
 * @fileoverview Autogenerated exceptions. Created with gen_exceptions.js.
 */
"use strict";

const skipped = [
  /* Tests with parse errors from v8 */
  "v8/test/mjsunit/es6/block-let-contextual-sloppy.js",
  "v8/test/mjsunit/es6/generators-parsing.js",
  "v8/test/mjsunit/es6/object-literals-property-shorthand.js",
  "v8/test/mjsunit/es6/sloppy-restrictive-block-function.js",
  "v8/test/mjsunit/es7/exponentiation-operator.js",
  "v8/test/mjsunit/harmony/bigint/property-names.js",
  "v8/test/mjsunit/harmony/class-static-blocks.js",
  "v8/test/mjsunit/harmony/import-from-compilation-errored.js",
  "v8/test/mjsunit/harmony/import-from-evaluation-errored.js",
  "v8/test/mjsunit/harmony/import-from-fetch-errored.js",
  "v8/test/mjsunit/harmony/import-from-instantiation-errored.js",
  "v8/test/mjsunit/harmony/logical-assignment-function-name.js",
  "v8/test/mjsunit/harmony/logical-assignment.js",
  "v8/test/mjsunit/harmony/numeric-separator.js",
  "v8/test/mjsunit/harmony/optional-chaining-this-private.js",
  "v8/test/mjsunit/harmony/private-brand-checks.js",
  "v8/test/mjsunit/harmony/private-fields-special-object.js",
  "v8/test/mjsunit/harmony/regexp-match-indices.js",
  "v8/test/mjsunit/html-comments.js",
  "v8/test/mjsunit/ignition/dead-code-source-position.js",
  "v8/test/mjsunit/regexp-linear-flag.js",
  "v8/test/mjsunit/regress/regress-436893.js",
  "v8/test/mjsunit/regress/regress-5692.js",
  "v8/test/mjsunit/regress/regress-740694.js",
  "v8/test/mjsunit/regress/regress-744292.js",
  "v8/test/mjsunit/regress/regress-797581.js",
  "v8/test/mjsunit/regress/regress-800651.js",
  "v8/test/mjsunit/regress/regress-crbug-1238467.js",
  "v8/test/mjsunit/regress/regress-crbug-1239907.js",
  "v8/test/mjsunit/regress/regress-crbug-412208.js",
  "v8/test/mjsunit/regress/regress-crbug-934166.js",
  "v8/test/mjsunit/regress/regress-v8-10604.js",
  "v8/test/mjsunit/serialize-embedded-error.js",
  "v8/test/mjsunit/switch.js",
  "v8/test/mjsunit/temporal/calendar-merge-fields.js",
  "v8/test/mjsunit/temporal/calendar-year-month-from-fields.js",
  "v8/test/mjsunit/temporal/plain-date-time-from.js",
  /* Tests with mutation errors from v8 */
  "v8/test/mjsunit/harmony/private-accessors.js",
  "v8/test/mjsunit/harmony/private-methods-empty-inner.js",
  "v8/test/mjsunit/harmony/private-methods.js",
  "v8/test/mjsunit/harmony/static-private-methods.js",
  "v8/test/mjsunit/regress/regress-crbug-1245870.js",
  "v8/test/mjsunit/regress/regress-v8-11360.js",
  /* Very slow tests from v8 */
  "v8/test/mjsunit/regress/wasm/regress-810973b.js", // 12.121s
  /* Tests with parse errors from spidermonkey */
  "spidermonkey/non262/BigInt/property-name-guessed-name.js",
  "spidermonkey/non262/BigInt/property-name.js",
  "spidermonkey/non262/Exceptions/catchguard-002-n.js",
  "spidermonkey/non262/Exceptions/catchguard-003-n.js",
  "spidermonkey/non262/Function/rest-parameter-names.js",
  "spidermonkey/non262/Unicode/regress-352044-02-n.js",
  "spidermonkey/non262/arrow-functions/arrow-not-as-end-of-statement.js",
  "spidermonkey/non262/arrow-functions/arrow-returning-arrow-with-block-body-followed-by-regexp.js",
  "spidermonkey/non262/async-functions/duplicate-__proto__.js",
  "spidermonkey/non262/destructuring/bug1396261.js",
  "spidermonkey/non262/destructuring/duplicate-__proto__.js",
  "spidermonkey/non262/destructuring/yield-in-object-destr-function.js",
  "spidermonkey/non262/destructuring/yield-in-object-destr-script.js",
  "spidermonkey/non262/destructuring/yield-with-escape-in-object-destr-function.js",
  "spidermonkey/non262/destructuring/yield-with-escape-in-object-destr-script.js",
  "spidermonkey/non262/expressions/short-circuit-compound-assignment-anon-fns.js",
  "spidermonkey/non262/expressions/short-circuit-compound-assignment-const.js",
  "spidermonkey/non262/expressions/short-circuit-compound-assignment-deleted-decl-binding.js",
  "spidermonkey/non262/expressions/short-circuit-compound-assignment-property-key-evaluation.js",
  "spidermonkey/non262/expressions/short-circuit-compound-assignment-scope-lookup.js",
  "spidermonkey/non262/expressions/short-circuit-compound-assignment-tdz.js",
  "spidermonkey/non262/expressions/short-circuit-compound-assignment.js",
  "spidermonkey/non262/extensions/inc-dec-functioncall.js",
  "spidermonkey/non262/extensions/regress-406572.js",
  "spidermonkey/non262/fields/await-identifier-module-1.js",
  "spidermonkey/non262/fields/await-identifier-module-2.js",
  "spidermonkey/non262/fields/await-identifier-script.js",
  "spidermonkey/non262/fields/numeric-fields.js",
  "spidermonkey/non262/generators/syntax.js",
  "spidermonkey/non262/generators/yield-non-regexp.js",
  "spidermonkey/non262/jit/regress-451673.js",
  "spidermonkey/non262/lexical-environment/block-scoped-functions-annex-b-if.js",
  "spidermonkey/non262/lexical-environment/block-scoped-functions-annex-b-parameter.js",
  "spidermonkey/non262/module/bug1488117-import-namespace.js",
  "spidermonkey/non262/module/bug1488117.js",
  "spidermonkey/non262/module/bug1689499-a.js",
  "spidermonkey/non262/module/bug1689499-b.js",
  "spidermonkey/non262/module/bug1689499-c.js",
  "spidermonkey/non262/module/bug1689499-x.js",
  "spidermonkey/non262/module/bug1689499.js",
  "spidermonkey/non262/module/bug1693261.js",
  "spidermonkey/non262/module/module-export-name-star.js",
  "spidermonkey/non262/regress/regress-243389-n.js",
  "spidermonkey/non262/regress/regress-319391.js",
  "spidermonkey/non262/regress/regress-350253.js",
  "spidermonkey/non262/regress/regress-351515.js",
  "spidermonkey/non262/regress/regress-452498-168-2.js",
  "spidermonkey/non262/regress/regress-462292.js",
  "spidermonkey/non262/regress/regress-467495-03.js",
  "spidermonkey/non262/regress/regress-467495-04.js",
  "spidermonkey/non262/regress/regress-467495-05.js",
  "spidermonkey/non262/regress/regress-467495-06.js",
  "spidermonkey/non262/regress/regress-609617.js",
  "spidermonkey/non262/regress/regress-98901.js",
  "spidermonkey/non262/statements/for-of-iterator-close.js",
  "spidermonkey/test/expected/export/multi-header.js",
  "spidermonkey/test/expected/export/reftest-error-syntaxerror.js",
  "spidermonkey/test/expected/export/regular.js",
  "spidermonkey/test/expected/import/files/local/smTempBranch/language/export/escaped-foobarbaz.js",
  "spidermonkey/test/fixtures/export/.ignore.js",
  "spidermonkey/test/fixtures/export/multi-header.js",
  "spidermonkey/test/fixtures/export/reftest-error-syntaxerror.js",
  "spidermonkey/test/fixtures/export/regular.js",
  /* Tests with mutation errors from spidermonkey */
  "spidermonkey/non262/PrivateName/home-object-when-preceded-by-computed-key.js",
  /* Very slow tests from spidermonkey */
  "spidermonkey/non262/regress/regress-308085.js", // 17.41s
  /* Tests with parse errors from chakra */
  "chakra/Basics/keyword.js",
  "chakra/Bugs/OS_4341640.js",
  "chakra/Bugs/SuperAccessInGlobalLambda.js",
  "chakra/Closures/bug_OS_2525694.js",
  "chakra/Function/callsideeffects.js",
  "chakra/Function/crosssite_bind_main.js",
  "chakra/Function/deferredBadContinue.js",
  "chakra/LetConst/defer1.js",
  "chakra/LetConst/letlet.js",
  "chakra/LetConst/tdz2.js",
  "chakra/Optimizer/test115.js",
  "chakra/Optimizer/test135.js",
  "chakra/Optimizer/test146.js",
  "chakra/Scanner/InvalidCharacter.js",
  "chakra/Strings/long_concatstr.js",
  "chakra/benchmarks/ARES-6/Babylon/babylon-blob.js",
  "chakra/es6/DeferParseMethods.js",
  "chakra/es6/ES6Iterators-forof.js",
  "chakra/es6/blockscope-functionbinding.js",
  "chakra/es6/bug_OS17895855.js",
  "chakra/es6/bug_issue_3247_dep.js",
  "chakra/es6/bug_issue_5994.js",
  "chakra/es6/forInEdgeCases.js",
  "chakra/es6/generators-syntax.js",
  "chakra/es6/globalCatchNewTargetSyntaxError.js",
  "chakra/es6/globalNewTargetSyntaxError.js",
  "chakra/es6/globalParamCatchNewTargetSyntaxError.js",
  "chakra/es6/lambda-expr.js",
  "chakra/es6/objlit.js",
  "chakra/es6/supersyntax02.js",
  "chakra/es6/supersyntax05.js",
  "chakra/es6/supersyntax06.js",
  "chakra/es6/unicode_6_identifier_Blue511452.js",
  "chakra/es6/unicode_6_identifier_Blue524737.js",
  "chakra/es6module/GetModuleNamespace.js",
  "chakra/es6module/ModuleCircularBar.js",
  "chakra/es6module/ModuleCircularFoo.js",
  "chakra/es6module/ModuleComplexExports.js",
  "chakra/es6module/ModuleComplexReexports.js",
  "chakra/es6module/ModuleDefaultExport1.js",
  "chakra/es6module/ModuleDefaultExport2.js",
  "chakra/es6module/ModuleDefaultExport3.js",
  "chakra/es6module/ModuleDefaultExport4.js",
  "chakra/es6module/ModuleDefaultReexport.js",
  "chakra/es6module/ModuleReexportDefault.js",
  "chakra/es6module/ModuleSimpleExport.js",
  "chakra/es6module/ModuleSimpleReexport.js",
  "chakra/es6module/ValidExportDefaultStatement1.js",
  "chakra/es6module/ValidExportDefaultStatement2.js",
  "chakra/es6module/ValidExportStatements.js",
  "chakra/es6module/ValidExportStatements2.js",
  "chakra/es6module/ValidImportStatements.js",
  "chakra/es6module/ValidReExportStatements.js",
  "chakra/es6module/bug_OS12095746.js",
  "chakra/es6module/bug_OS12095746_mod0.js",
  "chakra/es6module/bug_OS12095746_mod1.js",
  "chakra/es6module/bug_OS12095746_mod2.js",
  "chakra/es6module/bug_OS12095746_moddep.js",
  "chakra/es6module/bug_OS12113549_module1.js",
  "chakra/es6module/bug_OS14562349.js",
  "chakra/es6module/bug_issue_3076.js",
  "chakra/es6module/bug_issue_3257/mod/mod0.js",
  "chakra/es6module/bug_issue_3257/mod1.js",
  "chakra/es6module/bug_issue_3257/mod2/mod2.js",
  "chakra/es6module/bug_issue_3257/script/script0.js",
  "chakra/es6module/bug_issue_5777.js",
  "chakra/es6module/dynamic_import_promises_5796.js",
  "chakra/es6module/exportBinding.js",
  "chakra/es6module/exportmodule.js",
  "chakra/es6module/module-3250-bug-dep.js",
  "chakra/es6module/module-3250-bug-dep2.js",
  "chakra/es6module/module-3250-ext-a.js",
  "chakra/es6module/module-3250-ext-b.js",
  "chakra/es6module/moduleExport1.js",
  "chakra/es6module/moduleImportTheError.js",
  "chakra/es6module/moduleThrowAnError.js",
  "chakra/es6module/module_1_2645.js",
  "chakra/es6module/module_2_2645.js",
  "chakra/es6module/module_4482_dep1.js",
  "chakra/es6module/module_4482_dep2.js",
  "chakra/es6module/module_4482_dep3.js",
  "chakra/es6module/module_4570_dep1.js",
  "chakra/es6module/module_4570_dep2.js",
  "chakra/es6module/moduletest2_mod0.js",
  "chakra/es6module/moduletest2_mod1a.js",
  "chakra/es6module/moduletest2_mod1b.js",
  "chakra/es6module/moduletest2_mod2a.js",
  "chakra/es6module/otherModule.js",
  "chakra/es6module/passmodule.js",
  "chakra/es6module/testDynamicImportfromModule.js",
  "chakra/es6module/top-level-await.js",
  "chakra/es7/json_superset.js",
  "chakra/inlining/bug_gh6303.js",
  "chakra/inlining/profilingbug.js",
  "chakra/stackfunc/602481.js",
  "chakra/strict/bug212755.js",
  "chakra/strict/delete.js",
  "chakra/strict/formal_samename1.js",
  "chakra/strict/formal_samename2.js",
  "chakra/strict/multiunit.js",
  "chakra/strict/nonSimpleParameterList.js",
  "chakra/strict/strictargs-deferred.js",
  "chakra/strict/strictargs2-deferred.js",
  "chakra/strict/strictargs3-deferred.js",
  "chakra/strict/stricteval-deferred.js",
  "chakra/strict/stricteval2-deferred.js",
  "chakra/strict/strictkwd-deferred.js",
  /* Tests with mutation errors from chakra */
  "chakra/es6module/bug_issue_3257.js",
  "chakra/es6module/moduleUrlInError.js",
  "chakra/es6module/moduletest1.js",
  "chakra/es6module/moduletest2.js",
  /* Very slow tests from chakra */
  "chakra/benchmarks/ARES-6/Air/payload-imaging-gaussian-blur-gaussianBlur.js", // 22.525s
  "chakra/benchmarks/ARES-6/Air/payload-gbemu-executeIteration.js", // 19.993s
  /* Tests with parse errors from jstests */
  "WebKit/JSTests/es6/non-strict_function_semantics_function_statements_in_if-statement_clauses.js",
  "WebKit/JSTests/stress/allocation-sinking-changing-structures.js",
  "WebKit/JSTests/stress/arrowfunction-lexical-bind-this-8.js",
  "WebKit/JSTests/stress/big-int-as-property-name.js",
  "WebKit/JSTests/stress/bytecode-for-rmw-with-invalid-right-side.js",
  "WebKit/JSTests/stress/escaped-keyword-identifiers.js",
  "WebKit/JSTests/stress/for-let-comma.js",
  "WebKit/JSTests/stress/global-lexical-environment-access-from-module.js",
  "WebKit/JSTests/stress/import-basic.js",
  "WebKit/JSTests/stress/import-exception.js",
  "WebKit/JSTests/stress/import-from-eval.js",
  "WebKit/JSTests/stress/import-reject-with-exception.js",
  "WebKit/JSTests/stress/import-tests/cocoa.js",
  "WebKit/JSTests/stress/import-tests/multiple.js",
  "WebKit/JSTests/stress/import-tests/multiple2.js",
  "WebKit/JSTests/stress/import-tests/should.js",
  "WebKit/JSTests/stress/import-with-empty-string.js",
  "WebKit/JSTests/stress/logical-assignment-operator-and.js",
  "WebKit/JSTests/stress/logical-assignment-operator-coalesce.js",
  "WebKit/JSTests/stress/logical-assignment-operator-or.js",
  "WebKit/JSTests/stress/module-namespace-access-change.js",
  "WebKit/JSTests/stress/module-namespace-access-non-constant.js",
  "WebKit/JSTests/stress/module-namespace-access-poly.js",
  "WebKit/JSTests/stress/module-namespace-access-set-fails.js",
  "WebKit/JSTests/stress/module-namespace-access-transitive-exports.js",
  "WebKit/JSTests/stress/module-namespace-access.js",
  "WebKit/JSTests/stress/module-namespace-object-caching.js",
  "WebKit/JSTests/stress/optional-chaining-and-private-fields.js",
  "WebKit/JSTests/stress/printableModuleKey-should-never-throw.js",
  "WebKit/JSTests/stress/private-in-error.js",
  "WebKit/JSTests/stress/private-in.js",
  "WebKit/JSTests/stress/re-execute-error-module.js",
  "WebKit/JSTests/stress/regress-170732.js",
  "WebKit/JSTests/stress/regress-191856.js",
  "WebKit/JSTests/stress/resources/error-module.js",
  "WebKit/JSTests/stress/resources/global-lexical-environment-access-from-module-child.js",
  "WebKit/JSTests/stress/resources/module-namespace-access-transitive-exports-2.js",
  "WebKit/JSTests/stress/resources/module-namespace-access-transitive-exports.js",
  "WebKit/JSTests/stress/resources/module-namespace-access.js",
  "WebKit/JSTests/stress/resources/shadow-realm-example-module.js",
  "WebKit/JSTests/stress/resources/to-string-module.js",
  "WebKit/JSTests/stress/resources/value-of-module.js",
  "WebKit/JSTests/stress/shadow-realm-import-value.js",
  "WebKit/JSTests/stress/sloppy-mode-function-hoisting.js",
  "WebKit/JSTests/stress/terminated-execution-error-in-promise.js",
  "WebKit/JSTests/stress/yield-label.js",
  /* Tests with mutation errors from jstests */
  "WebKit/JSTests/stress/BrandedStructure-should-keep-its-members-alive.js",
  "WebKit/JSTests/stress/class-private-method-access.js",
  "WebKit/JSTests/stress/declared-private-field-in-eval.js",
  "WebKit/JSTests/stress/private-access-nested-eval.js",
  "WebKit/JSTests/stress/private-access-nested.js",
  "WebKit/JSTests/stress/private-brand-installed-after-super-call-from-arrow-function.js",
  "WebKit/JSTests/stress/private-brand-installed-after-super-call-from-eval.js",
  "WebKit/JSTests/stress/private-getter-brand-check.js",
  "WebKit/JSTests/stress/private-getter-inner-class.js",
  "WebKit/JSTests/stress/private-members-get-and-set.js",
  "WebKit/JSTests/stress/private-method-brand-check.js",
  "WebKit/JSTests/stress/private-method-change-attribute-from-branded-structure.js",
  "WebKit/JSTests/stress/private-method-change-prototype-from-branded-structure.js",
  "WebKit/JSTests/stress/private-method-check-private-brand-ic.js",
  "WebKit/JSTests/stress/private-method-check-structure-miss.js",
  "WebKit/JSTests/stress/private-method-comparison.js",
  "WebKit/JSTests/stress/private-method-delete-property-from-branded-structure.js",
  "WebKit/JSTests/stress/private-method-extends-brand-check.js",
  "WebKit/JSTests/stress/private-method-get-and-call.js",
  "WebKit/JSTests/stress/private-method-invalid-multiple-brand-installation.js",
  "WebKit/JSTests/stress/private-method-invalidate-compiled-with-constant-symbol.js",
  "WebKit/JSTests/stress/private-method-nested-class.js",
  "WebKit/JSTests/stress/private-method-on-sealed-objects.js",
  "WebKit/JSTests/stress/private-method-on-uncacheable-dictionary.js",
  "WebKit/JSTests/stress/private-method-polymorphic-with-constant-symbol.js",
  "WebKit/JSTests/stress/private-method-set-brand-should-have-write-barrier.js",
  "WebKit/JSTests/stress/private-method-untyped-use.js",
  "WebKit/JSTests/stress/private-method-with-uncacheable-dictionary-transition.js",
  "WebKit/JSTests/stress/private-methods-and-accessors-postfix-node.js",
  "WebKit/JSTests/stress/private-methods-and-accessors-prefix-node.js",
  "WebKit/JSTests/stress/private-methods-inheritance.js",
  "WebKit/JSTests/stress/private-methods-inline-cache.js",
  "WebKit/JSTests/stress/private-methods-megamorphic-ic.js",
  "WebKit/JSTests/stress/private-methods-on-proxy.js",
  "WebKit/JSTests/stress/private-methods-poly-ic-multiple-classes.js",
  "WebKit/JSTests/stress/private-methods-poly-ic-single-class.js",
  "WebKit/JSTests/stress/private-names-available-on-direct-eval.js",
  "WebKit/JSTests/stress/private-names-available-on-eval-during-field-initialization.js",
  "WebKit/JSTests/stress/private-setter-brand-check.js",
  "WebKit/JSTests/stress/private-setter-inner-class.js",
  "WebKit/JSTests/stress/private-static-method-declaration-error.js",
  "WebKit/JSTests/stress/static-private-methods-and-accessor-inner-class.js",
  "WebKit/JSTests/stress/static-private-methods-and-accessor-multiple-evaluation.js",
  "WebKit/JSTests/stress/static-private-methods-and-accessors-postfix-node.js",
  "WebKit/JSTests/stress/static-private-methods-and-accessors-prefix-node.js",
  "WebKit/JSTests/stress/undeclared-private-field-in-eval.js",
  /* Very slow tests from jstests */
  "WebKit/JSTests/stress/string-locale-compare-uca-ducet.js", // 15.698s
  /* Tests with parse errors from crashtests */
  "CrashTests/115674352/util.js",
  "CrashTests/132918471/fast/js/resources/js-test-post.js",
  "CrashTests/135733397/resources/cookies-test-post.js",
  "CrashTests/158344541/support/refTestWait.js",
  "CrashTests/178811021/media-file.js",
  "CrashTests/178811021/video-test.js",
  "CrashTests/31681819/fast/js/resources/js-test-post.js",
  "CrashTests/4506116685037568/00422.js",
  "CrashTests/4523272292270080/02509.js",
  "CrashTests/4531783459405824/01124.js",
  "CrashTests/4563969814560768/1.0.2/conformance/resources/webgl-test-utils.js",
  "CrashTests/4563969814560768/1.0.2/conformance/resources/webgl-test.js",
  "CrashTests/4563969814560768/1.0.2/resources/js-test-pre.js",
  "CrashTests/4570511337324544/01067.js",
  "CrashTests/4592095397150720/619.js",
  "CrashTests/4620742728613888/02272.js",
  "CrashTests/4624768836632576/00383.js",
  "CrashTests/4675875294674944/04443.js",
  "CrashTests/4676310267068416/00041.js",
  "CrashTests/4676310267068416/meta-00041.js",
  "CrashTests/4689880216240128/meta-00116.js",
  "CrashTests/4710304564903936/resources/js-test-post.js",
  "CrashTests/4715062213476352/meta-00915.js",
  "CrashTests/4730791635451904/00498.js",
  "CrashTests/4731918950203392/04316.js",
  "CrashTests/4747813124571136/00737.js",
  "CrashTests/4777280799506432/01745.js",
  "CrashTests/4784915024707584/meta-00090.js",
  "CrashTests/4786126975139840/00686.js",
  "CrashTests/4804606392795136/00345.js",
  "CrashTests/4823335117783040/meta-00192.js",
  "CrashTests/4827148775849984/02704.js",
  "CrashTests/4835573090222080/00096.js",
  "CrashTests/4835573090222080/meta-00096.js",
  "CrashTests/4837730048278528/03052.js",
  "CrashTests/4843490131312640/03475.js",
  "CrashTests/4848225223245824/resources/js-test-post.js",
  "CrashTests/4850895428517888/2670.js",
  "CrashTests/4854644212105216/392.js",
  "CrashTests/4855156194934784/meta-00080.js",
  "CrashTests/4899093893742592/02412.js",
  "CrashTests/4914294111076352/resources/worker-common.js",
  "CrashTests/4920133693472768/09913.js",
  "CrashTests/4924640359088128/resources/methods.js",
  "CrashTests/4966722004058112/01202.js",
  "CrashTests/4996582417891328/00314.js",
  "CrashTests/5010966233481216/05443.js",
  "CrashTests/5016449390477312/02595.js",
  "CrashTests/5019028805124096/01923.js",
  "CrashTests/5024919414112256/02190.js",
  "CrashTests/5026147325968384/01281.js",
  "CrashTests/5034236802498560/00038.js",
  "CrashTests/5034236802498560/meta-00038.js",
  "CrashTests/5036266378756096/resources/js-test.js",
  "CrashTests/5040821977219072/07176.js",
  "CrashTests/5047964758441984/02170.js",
  "CrashTests/5064701201350656/mjsunit_modified.js",
  "CrashTests/5071018176282624/05782.js",
  "CrashTests/5073353348087808/03720.js",
  "CrashTests/5083537469079552/03453.js",
  "CrashTests/5091969183776768/js/angular.js",
  "CrashTests/5104674803023872/meta-00066.js",
  "CrashTests/5110246766673920/117.js",
  "CrashTests/5120973776420864/00299.js",
  "CrashTests/5126730184654848/00846.js",
  "CrashTests/5140656268640256/resources/interpolation-test.js",
  "CrashTests/5151090662178816/01492.js",
  "CrashTests/5153368765628416/00787.js",
  "CrashTests/5157575680327680/06055.js",
  "CrashTests/5159014924288000/01496.js",
  "CrashTests/5164793027624960/01357.js",
  "CrashTests/5165045173846016/Common/MV.js",
  "CrashTests/5168023154720768/meta-00125.js",
  "CrashTests/5171658670473216/02099.js",
  "CrashTests/5190716938387456/05795.js",
  "CrashTests/5192473061359616/meta-00780.js",
  "CrashTests/5197954434596864/01324.js",
  "CrashTests/5200019587334144/meta-00398.js",
  "CrashTests/5222394685292544/resources/stress-js-execution.js",
  "CrashTests/5226258591121408/04850.js",
  "CrashTests/5226692407984128/meta-00030.js",
  "CrashTests/5238861996490752/01351.js",
  "CrashTests/5242104612651008/mjsunit_modified.js",
  "CrashTests/5254331529166848/meta-00409.js",
  "CrashTests/5254663852261376/meta-00497.js",
  "CrashTests/5280655383724032/meta-00355.js",
  "CrashTests/5283736101322752/00921.js",
  "CrashTests/5289653387919360/635.js",
  "CrashTests/5301431549820928/meta-00738.js",
  "CrashTests/5335637787934720/mersenne.js",
  "CrashTests/5337864091729920/00078.js",
  "CrashTests/5346139261108224/meta-00086.js",
  "CrashTests/5354535555825664/01561.js",
  "CrashTests/5402562393276416/meta-00565.js",
  "CrashTests/5418169017303040/156.js",
  "CrashTests/5435516837429248/02591.js",
  "CrashTests/5443796254064640/08661.js",
  "CrashTests/5474124668600320/meta-00992.js",
  "CrashTests/5486126228570112/02840.js",
  "CrashTests/5487631620112384/animations/resources/animation-test-helpers.js",
  "CrashTests/5521703332741120/00376.js",
  "CrashTests/5530153792045056/meta-00910.js",
  "CrashTests/5540548491608064/01146.js",
  "CrashTests/5541203771916288/currentscript.js",
  "CrashTests/5559694775025664/imported/w3c/html-templates/testcommon.js",
  "CrashTests/5559694775025664/resources/testharness.js",
  "CrashTests/5559694775025664/resources/testharnessreport.js",
  "CrashTests/5568247077011456/04042.js",
  "CrashTests/5593713261412352/319.js",
  "CrashTests/5606041047007232/02795.js",
  "CrashTests/5606702255964160/meta-00168.js",
  "CrashTests/5615411944226816/02684.js",
  "CrashTests/5630063870214144/02130.js",
  "CrashTests/5630225822121984/03637.js",
  "CrashTests/5635645835182080/worker-serviceworker-7636bedbbb1f120d.js",
  "CrashTests/5639628713492480/04139.js",
  "CrashTests/5642849944993792/resources/js-test.js",
  "CrashTests/5644307466878976/__MACOSX/._audio.js",
  "CrashTests/5644307466878976/__MACOSX/._processor.js",
  "CrashTests/5649862583648256/meta-00236.js",
  "CrashTests/5650039238033408/00812.js",
  "CrashTests/5651703040835584/resources/testharnessreport.js",
  "CrashTests/5652465613406208/4584.js",
  "CrashTests/5661345388167168/resources/stress-js-execution.js",
  "CrashTests/5668694740172800/meta-00294.js",
  "CrashTests/5672678890405888/resources/js-test.js",
  "CrashTests/5685487336161280/03642.js",
  "CrashTests/5686447370665984/sdk/tests/conformance/ogles/ogles-utils.js",
  "CrashTests/5686447370665984/sdk/tests/conformance/resources/glsl-conformance-test.js",
  "CrashTests/5686447370665984/sdk/tests/conformance/resources/webgl-test-utils.js",
  "CrashTests/5686447370665984/sdk/tests/resources/js-test-pre.js",
  "CrashTests/5688866685321216/09854.js",
  "CrashTests/5689884189392896/02723.js",
  "CrashTests/5694701996867584/conformance/resources/webgl-test.js",
  "CrashTests/5703976838234112/test.js",
  "CrashTests/5707472246472704/1443.js",
  "CrashTests/5712001662517248/report.js",
  "CrashTests/5721502735532032/03042.js",
  "CrashTests/5734750167105536/01271.js",
  "CrashTests/5735023732064256/meta-00070.js",
  "CrashTests/5736353084342272/resources/testharness.js",
  "CrashTests/5737388710821888/resources/js-test.js",
  "CrashTests/5738737345822720/svg/dynamic-updates/resources/SVGTestCase.js",
  "CrashTests/5744365229441024/resources/testharness.js",
  "CrashTests/5745342726537216/meta-00053.js",
  "CrashTests/5747146314285056/support/alertAssert.sub.js",
  "CrashTests/5747146314285056/support/logTest.sub.js",
  "CrashTests/5755508264534016/00224.js",
  "CrashTests/5763511307337728/04651.js",
  "CrashTests/5774432061095936/00972.js",
  "CrashTests/5798263663099904/01459.js",
  "CrashTests/5802116248764416/06966.js",
  "CrashTests/5806021251432448/background.js",
  "CrashTests/58219635/fast/js/resources/js-test-post.js",
  "CrashTests/5826758986170368/resources/js-test-post.js",
  "CrashTests/5841445051170816/resources/js-test-pre.js",
  "CrashTests/5842510916091904/resources/webgl_test_files/resources/js-test-post.js",
  "CrashTests/58693299/selfhtml.js",
  "CrashTests/5910324886634496/02597.js",
  "CrashTests/5925149103357952/webaudio/resources/audit.js",
  "CrashTests/5931087833333760/03890.js",
  "CrashTests/5933875666616320/01048.js",
  "CrashTests/5949184339083264/poc.js",
  "CrashTests/5950573451804672/494.js",
  "CrashTests/5950617700007936/01848.js",
  "CrashTests/5970316012290048/414.js",
  "CrashTests/5996165326962688/meta-00146.js",
  "CrashTests/6010230465626112/resources/webgl_test_files/js/tests/tex-image-and-sub-image-with-image-bitmap-utils.js",
  "CrashTests/6018592823836672/support/refTestWait.js",
  "CrashTests/6026840030314496/00848.js",
  "CrashTests/6037361396809728/02741.js",
  "CrashTests/6049932086083584/03169.js",
  "CrashTests/6051257375784960/03082.js",
  "CrashTests/6071110049988608/00548.js",
  "CrashTests/6073192676327424/resources/js-test-pre.js",
  "CrashTests/6085702952681472/00521.js",
  "CrashTests/6113149884563456/02823.js",
  "CrashTests/6131247808839680/00012.js",
  "CrashTests/6132283327971328/resources/autosizingTest.js",
  "CrashTests/6150179231105024/conformance/resources/webgl-test.js",
  "CrashTests/6158905865666560/meta-00624.js",
  "CrashTests/6179220893204480/02159.js",
  "CrashTests/6183415490019328/02656.js",
  "CrashTests/6198951751188480/1248.js",
  "CrashTests/6204924829630464/meta-00272.js",
  "CrashTests/6216405020835840/03985.js",
  "CrashTests/6218202061209600/mersenne.js",
  "CrashTests/6220111297118208/meta-00050.js",
  "CrashTests/6223202209234944/02648.js",
  "CrashTests/6239384157552640/meta-00271.js",
  "CrashTests/6250055858126848/04619.js",
  "CrashTests/6255231244697600/meta-00216.js",
  "CrashTests/6255916311379968/1372.js",
  "CrashTests/6259138054324224/meta-00172.js",
  "CrashTests/6263485068017664/MediaSessionTestUtils.js",
  "CrashTests/6278159702425600/01463.js",
  "CrashTests/6280577705705472/1146.js",
  "CrashTests/6285336190124032/01621.js",
  "CrashTests/6295241556492288/01763.js",
  "CrashTests/6304143111356416/00782.js",
  "CrashTests/6328755580567552/resources/js-test.js",
  "CrashTests/6328755580567552/svg/dynamic-updates/resources/SVGTestCase.js",
  "CrashTests/6330764245073920/poc1.js",
  "CrashTests/6332832186761216/00681.js",
  "CrashTests/6339944789049344/04142.js",
  "CrashTests/6345007341764608/00699.js",
  "CrashTests/6351789088833536/meta-00122.js",
  "CrashTests/6352599495475200/meta-00093.js",
  "CrashTests/6358320674242560/resources/js-test.js",
  "CrashTests/6359996105359360/934166-poc.js",
  "CrashTests/6362821967740928/00524.js",
  "CrashTests/6374053756272640/824.js",
  "CrashTests/6387037962240000/02996.js",
  "CrashTests/6394941698998272/meta-00167.js",
  "CrashTests/6403694305476608/meta-00079.js",
  "CrashTests/6405187880353792/meta-00826.js",
  "CrashTests/6406267560263680/02111.js",
  "CrashTests/6406622734974976/meta-00188.js",
  "CrashTests/6427802493779968/meta-00335.js",
  "CrashTests/6440904627060736/meta-00149.js",
  "CrashTests/6443097497010176/1.0.2/resources/webgl_test_files/conformance/resources/webgl-test-utils.js",
  "CrashTests/6443097497010176/1.0.2/resources/webgl_test_files/conformance/resources/webgl-test.js",
  "CrashTests/6443097497010176/1.0.2/resources/webgl_test_files/resources/js-test-pre.js",
  "CrashTests/6443097497010176/1.0.2/resources/webkit-webgl-test-harness.js",
  "CrashTests/6449605693931520/meta-00261.js",
  "CrashTests/6452658006392832/meta-00824.js",
  "CrashTests/6463535346614272/meta-00886.js",
  "CrashTests/6509855193169920/03031.js",
  "CrashTests/6530413356122112/meta-00391.js",
  "CrashTests/6541223017054208/01484.js",
  "CrashTests/6550225930944512/mnt/scratch0/clusterfuzz/slave-bot/inputs/fuzzers/inferno_twister_custom_bundle/inferno_twister_custom_bundle_data/moz_tests/dom/workers/test/threadErrors_worker1.js",
  "CrashTests/6551265423982592/00708.js",
  "CrashTests/6552552797503488/bug_41414141.js",
  "CrashTests/6572559555166208/report.js",
  "CrashTests/6576437049950208/conformance/resources/glsl-generator.js",
  "CrashTests/6576437049950208/resources/js-test-pre.js",
  "CrashTests/6586504922267648/00672.js",
  "CrashTests/6597230699216896/meta-00299.js",
  "CrashTests/6613865297084416/builds/chromium-browser-syzyasan_win32-release/revisions/asan-win32-release-276100/resources/inspector/main/Main.js",
  "CrashTests/6617130045341696/02588.js",
  "CrashTests/6622275291840512/resources/js-test.js",
  "CrashTests/6644133880397824/00752.js",
  "CrashTests/6646069054013440/poc.js",
  "CrashTests/6658388688371712/00042.js",
  "CrashTests/6659440421109760/00027.js",
  "CrashTests/6695292278931456/04706.js",
  "CrashTests/6727300586405888/builds/chromium-browser-syzyasan_win32-release/revisions/asan-win32-release-259551/resources/inspector/Main.js",
  "CrashTests/6731147175526400/meta-00107.js",
  "CrashTests/6744125769252864/494.js",
  /* Tests with mutation errors from crashtests */
  "CrashTests/4540193473101824/00967.js",
  "CrashTests/4542853924782080/01450.js",
  "CrashTests/4575654914293760/01532.js",
  "CrashTests/4652594229411840/00000.js",
  "CrashTests/4656490341466112/00126.js",
  "CrashTests/4672370177736704/00528.js",
  "CrashTests/4797755955937280/857.js",
  "CrashTests/4798856567717888/04694.js",
  "CrashTests/4804923870150656/03027.js",
  "CrashTests/4895570342707200/02467.js",
  "CrashTests/4983976359100416/02090.js",
  "CrashTests/5087167542853632/02505.js",
  "CrashTests/5095010520858624/2806.js",
  "CrashTests/5105917793468416/00610.js",
  "CrashTests/5136618234314752/00136.js",
  "CrashTests/5138652353593344/410.js",
  "CrashTests/5200855060774912/00023.js",
  "CrashTests/5357835741888512/568.js",
  "CrashTests/5518580170096640/00960.js",
  "CrashTests/5604116503199744/00316.js",
  "CrashTests/5631123291111424/00708.js",
  "CrashTests/5666447379988480/1339.js",
  "CrashTests/5692170731847680/195.js",
  "CrashTests/5701970444288000/00241.js",
  "CrashTests/5741122957148160/2584.js",
  "CrashTests/5748217537429504/repro.js",
  "CrashTests/5834909260709888/01407.js",
  "CrashTests/5927058168610816/01389.js",
  "CrashTests/6005687605002240/00969.js",
  "CrashTests/6245901978370048/1543.js",
  "CrashTests/6263564054888448/1184.js",
  "CrashTests/6316400054960128/165.js",
  "CrashTests/6396053053243392/00161.js",
  "CrashTests/6491889133158400/01408.js",
  "CrashTests/6551672999968768/259.js",
  "CrashTests/6666268416671744/09877.js",
  /* Very slow tests from crashtests */
  "CrashTests/5680390288441344/scripts/extension.js", // 45.763s
  "CrashTests/5666182802309120/binaryen-1564.js", // 24.367s
  "CrashTests/5680390288441344/scripts/feedback.js", // 22.301s
  "CrashTests/5306741051621376/binaryen-2962.js", // 18.079s
  "CrashTests/6270084030201856/binaryen-634.js", // 14.106s
  "CrashTests/6071297320747008/324.js", // 12.704s
  "CrashTests/6316400054960128/165.js", // 11.802s
  "CrashTests/5691805950083072/binaryen-2729.js", // 11.693s
];
const softSkipped = [
  /* Slow tests from v8 */
  "v8/test/mjsunit/wasm/wasm-module-builder.js", // 7.537s
  "v8/test/mjsunit/object-literal.js", // 3.837s
  /* Slow tests from spidermonkey */
  "spidermonkey/non262/statements/regress-74474-002.js", // 8.047s
  "spidermonkey/non262/statements/regress-74474-003.js", // 6.488s
  "spidermonkey/non262/extensions/dataview.js", // 3.727s
  /* Slow tests from chakra */
  "chakra/TaggedIntegers/loops.js", // 8.255s
  "chakra/benchmarks/ARES-6/Air/payload-typescript-scanIdentifier.js", // 5.26s
  "chakra/benchmarks/ARES-6/Air/payload-airjs-ACLj8C.js", // 3.713s
  "chakra/benchmarks/Octane/crypto.js", // 3.463s
  "chakra/benchmarks/Octane_Closure/crypto.js", // 3.354s
  /* Slow tests from jstests */
  "WebKit/JSTests/stress/v8-crypto-strict.js", // 2.56s
  "WebKit/JSTests/stress/v8-regexp-strict.js", // 2.555s
  /* Slow tests from crashtests */
  "CrashTests/5138652353593344/410.js", // 9.937s
  "CrashTests/6250982932086784/binaryen-538.js", // 9.721s
  "CrashTests/4741082707132416/binaryen-1700.js", // 9.631s
  "CrashTests/5082337238712320/binaryen-3268.js", // 9.475s
  "CrashTests/5187171718529024/844.js", // 9.422s
  "CrashTests/6472801805664256/common/js/frameworks/jquery-1.8.2.min.js", // 8.621s
  "CrashTests/4602127226241024/js/jquery.js", // 8.489s
  "CrashTests/5657174977806336/binaryen-1398.js", // 8.434s
  "CrashTests/4614296351277056/js/jquery-1.8.0.min.js", // 8.29s
  "CrashTests/5657116044951552/scripts/libs/jquery.js", // 8.25s
  "CrashTests/5091969183776768/js/jquery.js", // 8.217s
  "CrashTests/5550653104455680/js/jquery-1.8.0.min.js", // 8.214s
  "CrashTests/6649057641037824/binaryen-3706.js", // 7.484s
  "CrashTests/4612142496743424/binaryen-1882.js", // 7.364s
  "CrashTests/5365583999664128/extensionData/plugins/4_jquery_1_7_1.js", // 7.253s
  "CrashTests/6183950024441856/common/widget-api/widgets/common/jquery-1.7.1.min.js", // 7.168s
  "CrashTests/5049543056424960/inc/jquery-2.1.0.min.js", // 7.118s
  "CrashTests/6183950024441856/common/js/jquery-1.7.1.min.js", // 7.043s
  "CrashTests/6183950024441856/common/components/menu/js/jquery-1.7.1.min.js", // 6.928s
  "CrashTests/4615141375344640/lib/jquery.js", // 6.769s
  "CrashTests/6327982568898560/binaryen-862.js", // 6.678s
  "CrashTests/6240393225306112/48.js", // 5.382s
  "CrashTests/5689977077891072/01770.js", // 4.938s
  "CrashTests/5365583999664128/extensionData/plugins/17_jQuery.js", // 4.922s
  "CrashTests/6636948839202816/121.js", // 4.907s
  "CrashTests/4787946390093824/jquery-ui-1.8.2.custom/js/jquery-1.4.2.min.js", // 4.607s
  "CrashTests/4633495124312064/634.js", // 4.597s
  "CrashTests/5157721919979520/00935.js", // 4.518s
  "CrashTests/5533984447266816/626.js", // 4.445s
  "CrashTests/4528969625894912/encaiiljifbdbjlphpgpiimidegddhic/lib/3rdparty/jquery.js", // 4.33s
  "CrashTests/4528969625894912/lib/3rdparty/jquery.js", // 4.283s
  "CrashTests/5706022850527232/jquery-ui-1.8.2.custom/js/jquery-1.4.2.min.js", // 4.247s
  "CrashTests/5274731158568960/test2.js", // 4.218s
  "CrashTests/6215250211504128/05886.js", // 4.169s
  "CrashTests/6103088053354496/965.js", // 3.924s
  "CrashTests/5293298093391872/65.js", // 3.242s
  "CrashTests/5540518327746560/js/webgl-test-utils.js", // 3.075s
  "CrashTests/6505173049999360/binaryen-1108.js", // 2.989s
  "CrashTests/5020463045804032/js/webgl-test-utils.js", // 2.979s
  "CrashTests/5765813295185920/js/webgl-test-utils.js", // 2.937s
  "CrashTests/6411936120766464/js/webgl-test-utils.js", // 2.928s
  "CrashTests/4756083598753792/js/webgl-test-utils.js", // 2.893s
  "CrashTests/6564750484373504/js/webgl-test-utils.js", // 2.881s
  "CrashTests/5748523325521920/resources/webgl_test_files/js/webgl-test-utils.js", // 2.877s
  "CrashTests/5724904516812800/js/webgl-test-utils.js", // 2.863s
  "CrashTests/5654708333903872/js/webgl-test-utils.js", // 2.852s
  "CrashTests/5658246410207232/js/webgl-test-utils.js", // 2.835s
  "CrashTests/6090022799867904/js/webgl-test-utils.js", // 2.816s
  "CrashTests/5804707603021824/workers/wasm-hashset/worker.js", // 2.81s
  "CrashTests/5767297823473664/js/webgl-test-utils.js", // 2.797s
  "CrashTests/5748791416979456/js/webgl-test-utils.js", // 2.788s
  "CrashTests/4727886732066816/03031.js", // 2.783s
  "CrashTests/5147619843702784/js/webgl-test-utils.js", // 2.757s
  "CrashTests/4561088605323264/js/webgl-test-utils.js", // 2.748s
  "CrashTests/5970862301904896/wasm-hashset/many-test.js", // 2.739s
  "CrashTests/5804707603021824/workers/wasm-hashset/many-test.js", // 2.738s
  "CrashTests/5195343992586240/binaryen-2577.js", // 2.737s
  "CrashTests/6107728614522880/wasm-hashset/many-test.js", // 2.732s
  "CrashTests/4808534067838976/113.js", // 2.702s
  "CrashTests/4521096081309696/workers/wasm-hashset/many-test-2.js", // 2.693s
  "CrashTests/5512230554370048/binaryen-229.js", // 2.688s
  "CrashTests/4764215218012160/workers/wasm-hashset/test.js", // 2.683s
  "CrashTests/6107728614522880/wasm-hashset/worker.js", // 2.664s
  "CrashTests/5934400840466432/resources/testharness.js", // 2.65s
  "CrashTests/6171607952523264/workers/wasm-hashset/many-test-2.js", // 2.65s
  "CrashTests/5649522772541440/js/webgl-test-utils.js", // 2.63s
  "CrashTests/4521096081309696/workers/wasm-hashset/many-worker-2.js", // 2.616s
  "CrashTests/5877660912451584/js/webgl-test-utils.js", // 2.611s
  "CrashTests/5144726426222592/957.js", // 2.609s
  "CrashTests/4750804070957056/js/webgl-test-utils.js", // 2.605s
  "CrashTests/4764215218012160/workers/wasm-hashset/worker.js", // 2.592s
  "CrashTests/5436877461782528/binaryen-4415.js", // 2.579s
  "CrashTests/4544669955129344/binaryen-1549.js", // 2.548s
  "CrashTests/5684927436423168/js/webgl-test-utils.js", // 2.533s
  "CrashTests/5216366704721920/js/webgl-test-utils.js", // 2.52s
  "CrashTests/4780408753094656/js/webgl-test-utils.js", // 2.515s
  "CrashTests/6113858805301248/js/webgl-test-utils.js", // 2.488s
  "CrashTests/4614296351277056/js/esprima.js", // 2.487s
  "CrashTests/6643859697434624/00989.js", // 2.482s
  "CrashTests/5148692865417216/binaryen-587.js", // 2.476s
  "CrashTests/5152046202093568/binaryen-397.js", // 2.457s
  "CrashTests/6396634260570112/builds/chromium-browser-asan_linux-release_4392242b7f59878a2775b4607420a2b37e17ff13/revisions/asan-linux-release-616366/gen/third_party/blink/public/mojom/payments/payment_request.mojom.js", // 2.454s
  "CrashTests/6264668110323712/js/webgl-test-utils.js", // 2.448s
  "CrashTests/5709689405571072/js/webgl-test-utils.js", // 2.443s
  "CrashTests/5720170289692672/js/webgl-test-utils.js", // 2.441s
  "CrashTests/5720530023612416/binaryen-1954.js", // 2.427s
  "CrashTests/5130481752735744/817.js", // 2.419s
  "CrashTests/5692170731847680/195.js", // 2.418s
  "CrashTests/5903614327128064/js/webgl-test-utils.js", // 2.412s
  "CrashTests/5150788929454080/js/webgl-test-utils.js", // 2.401s
  "CrashTests/4763495091142656/js/webgl-test-utils.js", // 2.39s
  "CrashTests/5636770818686976/00408.js", // 2.374s
  "CrashTests/6159546553466880/js/webgl-test-utils.js", // 2.363s
  "CrashTests/4895116383485952/js/webgl-test-utils.js", // 2.35s
  "CrashTests/4986854798262272/js/webgl-test-utils.js", // 2.342s
  "CrashTests/6207235662020608/js/webgl-test-utils.js", // 2.34s
  "CrashTests/5205072808771584/js/webgl-test-utils.js", // 2.336s
  "CrashTests/6103004909666304/js/webgl-test-utils.js", // 2.331s
  "CrashTests/6021155845308416/js/webgl-test-utils.js", // 2.328s
  "CrashTests/4712093587865600/js/webgl-test-utils.js", // 2.314s
  "CrashTests/5550653104455680/js/esprima.js", // 2.313s
  "CrashTests/5803513008095232/js/webgl-test-utils.js", // 2.311s
  "CrashTests/6585627176992768/binaryen-655.js", // 2.309s
  "CrashTests/6231966593318912/js/webgl-test-utils.js", // 2.289s
  "CrashTests/6522661136760832/js/webgl-test-utils.js", // 2.289s
  "CrashTests/4849910154854400/2.0.0/resources/webgl_test_files/js/webgl-test-utils.js", // 2.289s
  "CrashTests/5316130750332928/js/webgl-test-utils.js", // 2.286s
  "CrashTests/4786020456595456/resources/testharness.js", // 2.284s
  "CrashTests/5246233363611648/js/webgl-test-utils.js", // 2.283s
  "CrashTests/4610688298057728/js/webgl-test-utils.js", // 2.271s
  "CrashTests/5732319423168512/js/webgl-test-utils.js", // 2.27s
  "CrashTests/6117827240263680/js/webgl-test-utils.js", // 2.266s
  "CrashTests/6446057308028928/js/webgl-test-utils.js", // 2.265s
  "CrashTests/5474186315956224/js/webgl-test-utils.js", // 2.265s
  "CrashTests/5081168717545472/js/webgl-test-utils.js", // 2.263s
  "CrashTests/5289255386742784/js/webgl-test-utils.js", // 2.258s
  "CrashTests/5153121645625344/binaryen-602.js", // 2.257s
  "CrashTests/6307834848608256/js/webgl-test-utils.js", // 2.234s
  "CrashTests/5069958615400448/js/webgl-test-utils.js", // 2.228s
  "CrashTests/5673981645684736/js/webgl-test-utils.js", // 2.216s
  "CrashTests/6371786506371072/js/webgl-test-utils.js", // 2.208s
  "CrashTests/5766886287081472/js/webgl-test-utils.js", // 2.207s
  "CrashTests/5112085437743104/js/webgl-test-utils.js", // 2.195s
  "CrashTests/5875816496627712/js/webgl-test-utils.js", // 2.187s
  "CrashTests/4902839495032832/2.0.0/resources/webgl_test_files/js/webgl-test-utils.js", // 2.185s
  "CrashTests/5940011987107840/js/webgl-test-utils.js", // 2.181s
  "CrashTests/5934321914609664/js/webgl-test-utils.js", // 2.18s
  "CrashTests/5447031043915776/js/webgl-test-utils.js", // 2.173s
  "CrashTests/5667434598760448/js/webgl-test-utils.js", // 2.172s
  "CrashTests/4722289303355392/js/webgl-test-utils.js", // 2.158s
  "CrashTests/4928460350029824/js/webgl-test-utils.js", // 2.152s
  "CrashTests/6612369747476480/04469.js", // 2.137s
  "CrashTests/5304417640513536/js/webgl-test-utils.js", // 2.134s
  "CrashTests/5154715558084608/572.js", // 2.132s
  "CrashTests/5710180189995008/js/webgl-test-utils.js", // 2.122s
  "CrashTests/5921882795933696/js/webgl-test-utils.js", // 2.119s
  "CrashTests/6578304131006464/js/webgl-test-utils.js", // 2.109s
  "CrashTests/5753604559470592/03311.js", // 2.102s
  "CrashTests/5630410519478272/916.js", // 2.092s
  "CrashTests/4571384448811008/fast/canvas/webgl/resources/webgl-test-utils-full.js", // 2.069s
  "CrashTests/6343749881036800/01604.js", // 2.055s
  "CrashTests/5657181087727616/binaryen-125.js", // 2.031s
  "CrashTests/4979734430351360/builds/chromium-browser-asan_linux-release_4392242b7f59878a2775b4607420a2b37e17ff13/revisions/asan-linux-release-587925/gen/third_party/blink/public/mojom/payments/payment_request.mojom.js", // 2.019s
  "CrashTests/6030846597005312/binaryen-97.js", // 2.015s
  "CrashTests/4661285908905984/builds/chromium-browser-asan_linux-release_4392242b7f59878a2775b4607420a2b37e17ff13/revisions/asan-linux-release-578254/gen/third_party/blink/public/platform/modules/payments/payment_request.mojom.js", // 2.014s
  "CrashTests/4864843149213696/builds/chromium-browser-asan_linux-release_4392242b7f59878a2775b4607420a2b37e17ff13/revisions/asan-linux-release-588015/gen/third_party/blink/public/mojom/payments/payment_request.mojom.js", // 2.014s
];
const sloppy = [
  /* Tests requiring sloppy mode from v8 */
  "v8/test/mjsunit/accessors-on-global-object.js",
  "v8/test/mjsunit/argument-assigned.js",
  "v8/test/mjsunit/argument-named-arguments.js",
  "v8/test/mjsunit/arguments-apply.js",
  "v8/test/mjsunit/arguments-lazy.js",
  "v8/test/mjsunit/arguments-read-and-assignment.js",
  "v8/test/mjsunit/arguments.js",
  "v8/test/mjsunit/array-indexing-receiver.js",
  "v8/test/mjsunit/arrow-with.js",
  "v8/test/mjsunit/asm-directive.js",
  "v8/test/mjsunit/baseline/test-baseline.js",
  "v8/test/mjsunit/compiler/delete.js",
  "v8/test/mjsunit/compiler/global-delete.js",
  "v8/test/mjsunit/compiler/global-var-delete.js",
  "v8/test/mjsunit/compiler/opt-next-call-turbo.js",
  "v8/test/mjsunit/compiler/optimized-for-in.js",
  "v8/test/mjsunit/compiler/optimized-with.js",
  "v8/test/mjsunit/compiler/regress-1037771.js",
  "v8/test/mjsunit/compiler/regress-665680.js",
  "v8/test/mjsunit/compiler/regress-669517.js",
  "v8/test/mjsunit/compiler/rotate.js",
  "v8/test/mjsunit/compiler/try-catch-deopt.js",
  "v8/test/mjsunit/compiler/try-context.js",
  "v8/test/mjsunit/compiler/uint32.js",
  "v8/test/mjsunit/compiler/variables.js",
  "v8/test/mjsunit/context-calls-maintained.js",
  "v8/test/mjsunit/delete-global-properties.js",
  "v8/test/mjsunit/delete-in-with.js",
  "v8/test/mjsunit/delete-vars-from-eval.js",
  "v8/test/mjsunit/delete.js",
  "v8/test/mjsunit/deopt-with-fp-regs.js",
  "v8/test/mjsunit/elements-kind.js",
  "v8/test/mjsunit/es6/array-concat-sloppy-arguments-with-dupes.js",
  "v8/test/mjsunit/es6/arrow-functions-lexical-arguments.js",
  "v8/test/mjsunit/es6/arrow-functions-this.js",
  "v8/test/mjsunit/es6/block-eval-var-over-let.js",
  "v8/test/mjsunit/es6/block-let-contextual-sloppy.js",
  "v8/test/mjsunit/es6/block-sloppy-function.js",
  "v8/test/mjsunit/es6/classes.js",
  "v8/test/mjsunit/es6/default-parameters.js",
  "v8/test/mjsunit/es6/destructuring-assignment.js",
  "v8/test/mjsunit/es6/generator-destructuring.js",
  "v8/test/mjsunit/es6/generators-iteration.js",
  "v8/test/mjsunit/es6/generators-parsing.js",
  "v8/test/mjsunit/es6/global-proto-proxy.js",
  "v8/test/mjsunit/es6/new-target.js",
  "v8/test/mjsunit/es6/object-literals-property-shorthand.js",
  "v8/test/mjsunit/es6/proxies-function.js",
  "v8/test/mjsunit/es6/proxies-with-unscopables.js",
  "v8/test/mjsunit/es6/proxies-with.js",
  "v8/test/mjsunit/es6/regress/regress-crbug-461520.js",
  "v8/test/mjsunit/es6/sloppy-restrictive-block-function.js",
  "v8/test/mjsunit/es6/super.js",
  "v8/test/mjsunit/es6/templates.js",
  "v8/test/mjsunit/es6/unscopables.js",
  "v8/test/mjsunit/es7/array-includes-receiver.js",
  "v8/test/mjsunit/es7/exponentiation-operator.js",
  "v8/test/mjsunit/es8/async-await-basic.js",
  "v8/test/mjsunit/es8/async-destructuring.js",
  "v8/test/mjsunit/eval.js",
  "v8/test/mjsunit/for-in.js",
  "v8/test/mjsunit/function-arguments-duplicate.js",
  "v8/test/mjsunit/getter-in-prototype.js",
  "v8/test/mjsunit/global-arrow-delete-this.js",
  "v8/test/mjsunit/global-infinity.js",
  "v8/test/mjsunit/global-load-from-eval-in-with.js",
  "v8/test/mjsunit/global-load-from-nested-eval.js",
  "v8/test/mjsunit/global-nan.js",
  "v8/test/mjsunit/global-undefined.js",
  "v8/test/mjsunit/global-vars-with.js",
  "v8/test/mjsunit/harmony/array-findlast-unscopables.js",
  "v8/test/mjsunit/harmony/bigint/property-names.js",
  "v8/test/mjsunit/harmony/class-static-blocks.js",
  "v8/test/mjsunit/harmony/global-configurable.js",
  "v8/test/mjsunit/harmony/import-from-compilation-errored.js",
  "v8/test/mjsunit/harmony/import-from-evaluation-errored.js",
  "v8/test/mjsunit/harmony/import-from-fetch-errored.js",
  "v8/test/mjsunit/harmony/import-from-instantiation-errored.js",
  "v8/test/mjsunit/harmony/logical-assignment-function-name.js",
  "v8/test/mjsunit/harmony/logical-assignment.js",
  "v8/test/mjsunit/harmony/numeric-separator.js",
  "v8/test/mjsunit/harmony/optional-chaining-this-private.js",
  "v8/test/mjsunit/harmony/private-brand-checks.js",
  "v8/test/mjsunit/harmony/private-fields-special-object.js",
  "v8/test/mjsunit/harmony/regexp-match-indices.js",
  "v8/test/mjsunit/ignition/dead-code-source-position.js",
  "v8/test/mjsunit/ignition/regress-616064.js",
  "v8/test/mjsunit/no-octal-constants-above-256.js",
  "v8/test/mjsunit/override-read-only-property.js",
  "v8/test/mjsunit/receiver-in-with-calls.js",
  "v8/test/mjsunit/regexp-linear-flag.js",
  "v8/test/mjsunit/regexp-no-linear-flag.js",
  "v8/test/mjsunit/regress/asm/regress-608630.js",
  "v8/test/mjsunit/regress/regress-1030466.js",
  "v8/test/mjsunit/regress/regress-1079.js",
  "v8/test/mjsunit/regress/regress-1125.js",
  "v8/test/mjsunit/regress/regress-1132.js",
  "v8/test/mjsunit/regress/regress-124.js",
  "v8/test/mjsunit/regress/regress-1528.js",
  "v8/test/mjsunit/regress/regress-2071.js",
  "v8/test/mjsunit/regress/regress-2594.js",
  "v8/test/mjsunit/regress/regress-263.js",
  "v8/test/mjsunit/regress/regress-2690.js",
  "v8/test/mjsunit/regress/regress-3138.js",
  "v8/test/mjsunit/regress/regress-318420.js",
  "v8/test/mjsunit/regress/regress-3185905.js",
  "v8/test/mjsunit/regress/regress-353058.js",
  "v8/test/mjsunit/regress/regress-392.js",
  "v8/test/mjsunit/regress/regress-410030.js",
  "v8/test/mjsunit/regress/regress-410912.js",
  "v8/test/mjsunit/regress/regress-4169.js",
  "v8/test/mjsunit/regress/regress-4214.js",
  "v8/test/mjsunit/regress/regress-436893.js",
  "v8/test/mjsunit/regress/regress-4577.js",
  "v8/test/mjsunit/regress/regress-492.js",
  "v8/test/mjsunit/regress/regress-5205.js",
  "v8/test/mjsunit/regress/regress-5405.js",
  "v8/test/mjsunit/regress/regress-5692.js",
  "v8/test/mjsunit/regress/regress-583260.js",
  "v8/test/mjsunit/regress/regress-587004.js",
  "v8/test/mjsunit/regress/regress-592353.js",
  "v8/test/mjsunit/regress/regress-649067.js",
  "v8/test/mjsunit/regress/regress-6677.js",
  "v8/test/mjsunit/regress/regress-670147.js",
  "v8/test/mjsunit/regress/regress-6733.js",
  "v8/test/mjsunit/regress/regress-678525.js",
  "v8/test/mjsunit/regress/regress-70066.js",
  "v8/test/mjsunit/regress/regress-74.js",
  "v8/test/mjsunit/regress/regress-740694.js",
  "v8/test/mjsunit/regress/regress-744292.js",
  "v8/test/mjsunit/regress/regress-784080.js",
  "v8/test/mjsunit/regress/regress-797581.js",
  "v8/test/mjsunit/regress/regress-800651.js",
  "v8/test/mjsunit/regress/regress-801772.js",
  "v8/test/mjsunit/regress/regress-95485.js",
  "v8/test/mjsunit/regress/regress-96523.js",
  "v8/test/mjsunit/regress/regress-969.js",
  "v8/test/mjsunit/regress/regress-abort-context-allocate-params.js",
  "v8/test/mjsunit/regress/regress-abort-preparsing-params.js",
  "v8/test/mjsunit/regress/regress-crbug-1041210.js",
  "v8/test/mjsunit/regress/regress-crbug-1041616.js",
  "v8/test/mjsunit/regress/regress-crbug-1074737.js",
  "v8/test/mjsunit/regress/regress-crbug-1238467.js",
  "v8/test/mjsunit/regress/regress-crbug-1239907.js",
  "v8/test/mjsunit/regress/regress-crbug-1254704.js",
  "v8/test/mjsunit/regress/regress-crbug-135008.js",
  "v8/test/mjsunit/regress/regress-crbug-412208.js",
  "v8/test/mjsunit/regress/regress-crbug-450642.js",
  "v8/test/mjsunit/regress/regress-crbug-455644.js",
  "v8/test/mjsunit/regress/regress-crbug-505907.js",
  "v8/test/mjsunit/regress/regress-crbug-506956.js",
  "v8/test/mjsunit/regress/regress-crbug-552304.js",
  "v8/test/mjsunit/regress/regress-crbug-628573.js",
  "v8/test/mjsunit/regress/regress-crbug-631027.js",
  "v8/test/mjsunit/regress/regress-crbug-648740.js",
  "v8/test/mjsunit/regress/regress-crbug-663750.js",
  "v8/test/mjsunit/regress/regress-crbug-691687.js",
  "v8/test/mjsunit/regress/regress-crbug-851393.js",
  "v8/test/mjsunit/regress/regress-crbug-934166.js",
  "v8/test/mjsunit/regress/regress-sloppy-block-function-hoisting-dynamic.js",
  "v8/test/mjsunit/regress/regress-v8-10604.js",
  "v8/test/mjsunit/regress/regress-v8-9394-2.js",
  "v8/test/mjsunit/regress/regress-v8-9394.js",
  "v8/test/mjsunit/regress/wasm/loop-stack-check.js",
  "v8/test/mjsunit/regress/wasm/regress-648079.js",
  "v8/test/mjsunit/regress/wasm/regress-654377.js",
  "v8/test/mjsunit/regress/wasm/regress-753496.js",
  "v8/test/mjsunit/scope-calls-eval.js",
  "v8/test/mjsunit/serialize-embedded-error.js",
  "v8/test/mjsunit/stackoverflow-underapplication.js",
  "v8/test/mjsunit/strict-mode-implicit-receiver.js",
  "v8/test/mjsunit/strict-mode.js",
  "v8/test/mjsunit/switch.js",
  "v8/test/mjsunit/temporal/calendar-merge-fields.js",
  "v8/test/mjsunit/temporal/calendar-week-of-year.js",
  "v8/test/mjsunit/temporal/calendar-year-month-from-fields.js",
  "v8/test/mjsunit/temporal/duration-from.js",
  "v8/test/mjsunit/temporal/plain-date-time-from.js",
  "v8/test/mjsunit/temporal/plain-date-time-to-json.js",
  "v8/test/mjsunit/throw-and-catch-function.js",
  "v8/test/mjsunit/unused-context-in-with.js",
  "v8/test/mjsunit/value-wrapper.js",
  "v8/test/mjsunit/wasm/import-mutable-global.js",
  "v8/test/mjsunit/with-leave.js",
  "v8/test/mjsunit/with-parameter-access.js",
  "v8/test/mjsunit/with-prototype.js",
  "v8/test/mjsunit/with-readonly.js",
  "v8/test/mjsunit/with-value.js",
  "v8/test/mjsunit/worker-ping-test.js",
  /* Tests requiring sloppy mode from spidermonkey */
  "spidermonkey/non262/Array/unscopables.js",
  "spidermonkey/non262/Array/values.js",
  "spidermonkey/non262/BigInt/property-name-guessed-name.js",
  "spidermonkey/non262/BigInt/property-name.js",
  "spidermonkey/non262/Date/parse-time-zone.js",
  "spidermonkey/non262/Date/time-zones-posix.js",
  "spidermonkey/non262/Date/time-zones.js",
  "spidermonkey/non262/Exceptions/catchguard-002-n.js",
  "spidermonkey/non262/Exceptions/catchguard-003-n.js",
  "spidermonkey/non262/Exceptions/regress-273931.js",
  "spidermonkey/non262/Function/10.2.1.1.6.js",
  "spidermonkey/non262/Function/arguments-parameter-shadowing.js",
  "spidermonkey/non262/Function/arrow-has-duplicated.js",
  "spidermonkey/non262/Function/regress-131964.js",
  "spidermonkey/non262/Function/regress-94506.js",
  "spidermonkey/non262/Function/regress-97921.js",
  "spidermonkey/non262/Function/rest-has-duplicated.js",
  "spidermonkey/non262/Function/rest-parameter-names.js",
  "spidermonkey/non262/GC/regress-383269-02.js",
  "spidermonkey/non262/PrivateName/lexical-presence.js",
  "spidermonkey/non262/RegExp/regress-6359.js",
  "spidermonkey/non262/RegExp/regress-85721.js",
  "spidermonkey/non262/Scope/regress-184107.js",
  "spidermonkey/non262/Scope/regress-185485.js",
  "spidermonkey/non262/Scope/regress-192226.js",
  "spidermonkey/non262/Scope/regress-208496-001.js",
  "spidermonkey/non262/Scope/regress-208496-002.js",
  "spidermonkey/non262/Scope/scope-004.js",
  "spidermonkey/non262/Script/delete-001.js",
  "spidermonkey/non262/Script/new-001.js",
  "spidermonkey/non262/String/regress-392378.js",
  "spidermonkey/non262/Unicode/regress-352044-02-n.js",
  "spidermonkey/non262/arrow-functions/arrow-not-as-end-of-statement.js",
  "spidermonkey/non262/arrow-functions/arrow-returning-arrow-with-block-body-followed-by-regexp.js",
  "spidermonkey/non262/async-functions/async-contains-unicode-escape.js",
  "spidermonkey/non262/async-functions/duplicate-__proto__.js",
  "spidermonkey/non262/class/outerBinding.js",
  "spidermonkey/non262/destructuring/bug1396261.js",
  "spidermonkey/non262/destructuring/duplicate-__proto__.js",
  "spidermonkey/non262/destructuring/yield-in-object-destr-function.js",
  "spidermonkey/non262/destructuring/yield-in-object-destr-script.js",
  "spidermonkey/non262/destructuring/yield-with-escape-in-object-destr-function.js",
  "spidermonkey/non262/destructuring/yield-with-escape-in-object-destr-script.js",
  "spidermonkey/non262/eval/redeclared-arguments-in-param-expression-eval.js",
  "spidermonkey/non262/execution-contexts/regress-448595-01.js",
  "spidermonkey/non262/expressions/delete-constant-folded-and-or.js",
  "spidermonkey/non262/expressions/short-circuit-compound-assignment-anon-fns.js",
  "spidermonkey/non262/expressions/short-circuit-compound-assignment-const.js",
  "spidermonkey/non262/expressions/short-circuit-compound-assignment-deleted-decl-binding.js",
  "spidermonkey/non262/expressions/short-circuit-compound-assignment-property-key-evaluation.js",
  "spidermonkey/non262/expressions/short-circuit-compound-assignment-scope-lookup.js",
  "spidermonkey/non262/expressions/short-circuit-compound-assignment-tdz.js",
  "spidermonkey/non262/expressions/short-circuit-compound-assignment.js",
  "spidermonkey/non262/extensions/clone-leaf-object.js",
  "spidermonkey/non262/extensions/clone-simple.js",
  "spidermonkey/non262/extensions/cross-global-eval-is-indirect.js",
  "spidermonkey/non262/extensions/eval-native-callback-is-indirect.js",
  "spidermonkey/non262/extensions/function-definition-with.js",
  "spidermonkey/non262/extensions/inc-dec-functioncall.js",
  "spidermonkey/non262/extensions/recursion.js",
  "spidermonkey/non262/extensions/regress-104077.js",
  "spidermonkey/non262/extensions/regress-226078.js",
  "spidermonkey/non262/extensions/regress-352604.js",
  "spidermonkey/non262/extensions/regress-365527.js",
  "spidermonkey/non262/extensions/regress-406572.js",
  "spidermonkey/non262/extensions/regress-416834.js",
  "spidermonkey/non262/extensions/regress-476414-01.js",
  "spidermonkey/non262/extensions/regress-476414-02.js",
  "spidermonkey/non262/extensions/uneval/bug496985.js",
  "spidermonkey/non262/extensions/uneval/regress-385393-03.js",
  "spidermonkey/non262/extensions/uneval/regress-452498-101.js",
  "spidermonkey/non262/extensions/uneval/regress-452498-117.js",
  "spidermonkey/non262/extensions/uneval/regress-624199.js",
  "spidermonkey/non262/fields/await-identifier-module-1.js",
  "spidermonkey/non262/fields/await-identifier-module-2.js",
  "spidermonkey/non262/fields/await-identifier-script.js",
  "spidermonkey/non262/fields/numeric-fields.js",
  "spidermonkey/non262/generators/iteration.js",
  "spidermonkey/non262/generators/syntax.js",
  "spidermonkey/non262/generators/yield-non-regexp.js",
  "spidermonkey/non262/global/direct-eval-but-not.js",
  "spidermonkey/non262/global/eval-02.js",
  "spidermonkey/non262/global/eval-inside-with-is-direct.js",
  "spidermonkey/non262/global/eval-native-callback-is-indirect.js",
  "spidermonkey/non262/jit/regress-451673.js",
  "spidermonkey/non262/lexical-conventions/lexical-001.js",
  "spidermonkey/non262/lexical-conventions/regress-177314.js",
  "spidermonkey/non262/lexical-environment/block-scoped-functions-annex-b-arguments.js",
  "spidermonkey/non262/lexical-environment/block-scoped-functions-annex-b-eval.js",
  "spidermonkey/non262/lexical-environment/block-scoped-functions-annex-b-if.js",
  "spidermonkey/non262/lexical-environment/block-scoped-functions-annex-b-parameter.js",
  "spidermonkey/non262/lexical-environment/block-scoped-functions-annex-b-with.js",
  "spidermonkey/non262/lexical-environment/block-scoped-functions-deprecated-redecl.js",
  "spidermonkey/non262/lexical-environment/implicit-this-in-with.js",
  "spidermonkey/non262/lexical-environment/redeclaring-global-properties.js",
  "spidermonkey/non262/lexical-environment/unscopables-basics.js",
  "spidermonkey/non262/lexical-environment/unscopables-closures.js",
  "spidermonkey/non262/lexical-environment/unscopables-const.js",
  "spidermonkey/non262/lexical-environment/unscopables-delete.js",
  "spidermonkey/non262/lexical-environment/unscopables-getters.js",
  "spidermonkey/non262/lexical-environment/unscopables-global.js",
  "spidermonkey/non262/lexical-environment/unscopables-ignored.js",
  "spidermonkey/non262/lexical-environment/unscopables-miss.js",
  "spidermonkey/non262/lexical-environment/unscopables-mutation-frozen.js",
  "spidermonkey/non262/lexical-environment/unscopables-mutation.js",
  "spidermonkey/non262/lexical-environment/unscopables-proto.js",
  "spidermonkey/non262/lexical-environment/unscopables-proxy.js",
  "spidermonkey/non262/lexical-environment/unscopables-strict.js",
  "spidermonkey/non262/lexical-environment/unscopables-tdz.js",
  "spidermonkey/non262/lexical-environment/with-global-ignores-global-let-variables.js",
  "spidermonkey/non262/module/bug1488117-import-namespace.js",
  "spidermonkey/non262/module/bug1488117.js",
  "spidermonkey/non262/module/bug1689499-a.js",
  "spidermonkey/non262/module/bug1689499-b.js",
  "spidermonkey/non262/module/bug1689499-c.js",
  "spidermonkey/non262/module/bug1689499-x.js",
  "spidermonkey/non262/module/bug1689499.js",
  "spidermonkey/non262/module/bug1693261.js",
  "spidermonkey/non262/module/module-export-name-star.js",
  "spidermonkey/non262/reflect-parse/PatternBuilders.js",
  "spidermonkey/non262/reflect-parse/classes.js",
  "spidermonkey/non262/regress/regress-104077.js",
  "spidermonkey/non262/regress/regress-131510-001.js",
  "spidermonkey/non262/regress/regress-146596.js",
  "spidermonkey/non262/regress/regress-170193.js",
  "spidermonkey/non262/regress/regress-230216-1.js",
  "spidermonkey/non262/regress/regress-230216-3.js",
  "spidermonkey/non262/regress/regress-243389-n.js",
  "spidermonkey/non262/regress/regress-252892.js",
  "spidermonkey/non262/regress/regress-290656.js",
  "spidermonkey/non262/regress/regress-319391.js",
  "spidermonkey/non262/regress/regress-336100.js",
  "spidermonkey/non262/regress/regress-343713.js",
  "spidermonkey/non262/regress/regress-344959.js",
  "spidermonkey/non262/regress/regress-349482-02.js",
  "spidermonkey/non262/regress/regress-350253.js",
  "spidermonkey/non262/regress/regress-351515.js",
  "spidermonkey/non262/regress/regress-352604.js",
  "spidermonkey/non262/regress/regress-428366.js",
  "spidermonkey/non262/regress/regress-441477-01.js",
  "spidermonkey/non262/regress/regress-452498-072.js",
  "spidermonkey/non262/regress/regress-452498-102.js",
  "spidermonkey/non262/regress/regress-452498-117.js",
  "spidermonkey/non262/regress/regress-452498-135.js",
  "spidermonkey/non262/regress/regress-452498-168-2.js",
  "spidermonkey/non262/regress/regress-452498-181.js",
  "spidermonkey/non262/regress/regress-452498-192.js",
  "spidermonkey/non262/regress/regress-452742-01.js",
  "spidermonkey/non262/regress/regress-452742-02.js",
  "spidermonkey/non262/regress/regress-462292.js",
  "spidermonkey/non262/regress/regress-467495-03.js",
  "spidermonkey/non262/regress/regress-467495-04.js",
  "spidermonkey/non262/regress/regress-467495-05.js",
  "spidermonkey/non262/regress/regress-467495-06.js",
  "spidermonkey/non262/regress/regress-477234.js",
  "spidermonkey/non262/regress/regress-483749.js",
  "spidermonkey/non262/regress/regress-509354.js",
  "spidermonkey/non262/regress/regress-551763-0.js",
  "spidermonkey/non262/regress/regress-551763-1.js",
  "spidermonkey/non262/regress/regress-551763-2.js",
  "spidermonkey/non262/regress/regress-554955-1.js",
  "spidermonkey/non262/regress/regress-554955-2.js",
  "spidermonkey/non262/regress/regress-554955-3.js",
  "spidermonkey/non262/regress/regress-569306.js",
  "spidermonkey/non262/regress/regress-591897.js",
  "spidermonkey/non262/regress/regress-593256.js",
  "spidermonkey/non262/regress/regress-597945-1.js",
  "spidermonkey/non262/regress/regress-602621.js",
  "spidermonkey/non262/regress/regress-609617.js",
  "spidermonkey/non262/regress/regress-633741.js",
  "spidermonkey/non262/regress/regress-672892.js",
  "spidermonkey/non262/regress/regress-68498-001.js",
  "spidermonkey/non262/regress/regress-68498-002.js",
  "spidermonkey/non262/regress/regress-68498-003.js",
  "spidermonkey/non262/regress/regress-68498-004.js",
  "spidermonkey/non262/regress/regress-98901.js",
  "spidermonkey/non262/statements/for-in-with-assignment-semantics.js",
  "spidermonkey/non262/statements/for-in-with-assignments.js",
  "spidermonkey/non262/statements/for-of-iterator-close.js",
  "spidermonkey/non262/strict/directive-prologue-01.js",
  "spidermonkey/non262/syntax/escaped-strict-reserved-words-and-yield.js",
  "spidermonkey/non262/template-strings/noSubst.js",
  "spidermonkey/test/expected/export/multi-header.js",
  "spidermonkey/test/expected/export/reftest-error-syntaxerror.js",
  "spidermonkey/test/expected/export/regular.js",
  "spidermonkey/test/expected/import/files/local/smTempBranch/language/export/escaped-foobarbaz.js",
  "spidermonkey/test/fixtures/export/.ignore.js",
  "spidermonkey/test/fixtures/export/multi-header.js",
  "spidermonkey/test/fixtures/export/reftest-error-syntaxerror.js",
  "spidermonkey/test/fixtures/export/regular.js",
  /* Tests requiring sloppy mode from chakra */
  "chakra/AsmJs/evalbug.js",
  "chakra/AsmJs/switchBinaryTraverse.js",
  "chakra/Basics/SpecialSymbolCapture.js",
  "chakra/Basics/With-defer-block-scope.js",
  "chakra/Basics/With.js",
  "chakra/Basics/With2.js",
  "chakra/Basics/keyword.js",
  "chakra/Basics/scopedaccessors.js",
  "chakra/Basics/with3.js",
  "chakra/Basics/withBug940841.js",
  "chakra/Basics/withBug940841_2.js",
  "chakra/Basics/witheval.js",
  "chakra/Bugs/OS_4341640.js",
  "chakra/Bugs/SuperAccessInGlobalLambda.js",
  "chakra/Bugs/blue_1096569.js",
  "chakra/Bugs/bug10191241.js",
  "chakra/Bugs/bug56026.js",
  "chakra/Bugs/bug56026_minimal.js",
  "chakra/Bugs/bug56026_minimalWithProperties.js",
  "chakra/Bugs/bug56026_nested.js",
  "chakra/Bugs/bug56026_trycatch.js",
  "chakra/Bugs/bug_OS18260560.js",
  "chakra/Bugs/misc_bugs.js",
  "chakra/Bugs/withSplitScope.js",
  "chakra/Bugs/withnonativeApplyOptimizationBug3433559.js",
  "chakra/Closures/bug_OS_10735999.js",
  "chakra/Closures/bug_OS_13412380.js",
  "chakra/Closures/bug_OS_2525694.js",
  "chakra/Closures/cachedscope_1.js",
  "chakra/Closures/initcachedscope.js",
  "chakra/ControlFlow/DoWhile.js",
  "chakra/DebuggerCommon/ES6_letconst_shadow_eval_with.js",
  "chakra/DebuggerCommon/blockScopeGlobalSlotArrayTest.bug222631.js",
  "chakra/DebuggerCommon/blockScopeSibling.bug263635.js",
  "chakra/DebuggerCommon/blockScopeWithTest.js",
  "chakra/DebuggerCommon/bug_204064.js",
  "chakra/DebuggerCommon/default.js",
  "chakra/DebuggerCommon/frames_inspection_arrayES5.js",
  "chakra/DebuggerCommon/funcSource.js",
  "chakra/DebuggerCommon/globalFuncVars.js",
  "chakra/DebuggerCommon/level_1.js",
  "chakra/DebuggerCommon/protoTest2.js",
  "chakra/DebuggerCommon/shadow_with.js",
  "chakra/DebuggerCommon/step_in_only_debugJIT_attach.js",
  "chakra/DebuggerCommon/with_shadow.js",
  "chakra/EH/optional-catch-binding.js",
  "chakra/EH/try2.js",
  "chakra/EH/try5-ES3.js",
  "chakra/EH/tryfinallyinlineswbug.js",
  "chakra/Function/LabelFuncAsWithStmt.js",
  "chakra/Function/arguments1.js",
  "chakra/Function/arguments2.js",
  "chakra/Function/arguments4.js",
  "chakra/Function/argumentsMisc.js",
  "chakra/Function/bug542360.js",
  "chakra/Function/caller_replaced_proto.js",
  "chakra/Function/callsideeffects.js",
  "chakra/Function/crosssite_bind_main.js",
  "chakra/Function/defernested.js",
  "chakra/Function/deferredBadContinue.js",
  "chakra/Function/deferredParsing.js",
  "chakra/Function/deferredWith.js",
  "chakra/Function/deferredWith2.js",
  "chakra/Function/funcExpr.js",
  "chakra/Function/sameNamePara.js",
  "chakra/Function/someMoreArguments.js",
  "chakra/Function/stackargs.js",
  "chakra/Generated/add.js",
  "chakra/Generated/add0.js",
  "chakra/Generated/add1.js",
  "chakra/Generated/add2.js",
  "chakra/Generated/add3.js",
  "chakra/Generated/and.js",
  "chakra/Generated/and0.js",
  "chakra/Generated/and1.js",
  "chakra/Generated/and2.js",
  "chakra/Generated/and3.js",
  "chakra/Generated/div.js",
  "chakra/Generated/div0.js",
  "chakra/Generated/div1.js",
  "chakra/Generated/div2.js",
  "chakra/Generated/div3.js",
  "chakra/Generated/eq.js",
  "chakra/Generated/eq0.js",
  "chakra/Generated/eq1.js",
  "chakra/Generated/eq2.js",
  "chakra/Generated/eq3.js",
  "chakra/Generated/ge.js",
  "chakra/Generated/ge0.js",
  "chakra/Generated/ge1.js",
  "chakra/Generated/ge2.js",
  "chakra/Generated/ge3.js",
  "chakra/Generated/gt.js",
  "chakra/Generated/gt0.js",
  "chakra/Generated/gt1.js",
  "chakra/Generated/gt2.js",
  "chakra/Generated/gt3.js",
  "chakra/Generated/land.js",
  "chakra/Generated/land0.js",
  "chakra/Generated/land1.js",
  "chakra/Generated/land2.js",
  "chakra/Generated/land3.js",
  "chakra/Generated/le.js",
  "chakra/Generated/le0.js",
  "chakra/Generated/le1.js",
  "chakra/Generated/le2.js",
  "chakra/Generated/le3.js",
  "chakra/Generated/lor.js",
  "chakra/Generated/lor0.js",
  "chakra/Generated/lor1.js",
  "chakra/Generated/lor2.js",
  "chakra/Generated/lor3.js",
  "chakra/Generated/lsh.js",
  "chakra/Generated/lsh0.js",
  "chakra/Generated/lsh1.js",
  "chakra/Generated/lsh2.js",
  "chakra/Generated/lsh3.js",
  "chakra/Generated/lt.js",
  "chakra/Generated/lt0.js",
  "chakra/Generated/lt1.js",
  "chakra/Generated/lt2.js",
  "chakra/Generated/lt3.js",
  "chakra/Generated/mod.js",
  "chakra/Generated/mod0.js",
  "chakra/Generated/mod1.js",
  "chakra/Generated/mod2.js",
  "chakra/Generated/mod3.js",
  "chakra/Generated/mul.js",
  "chakra/Generated/mul0.js",
  "chakra/Generated/mul1.js",
  "chakra/Generated/mul2.js",
  "chakra/Generated/mul3.js",
  "chakra/Generated/ne.js",
  "chakra/Generated/ne0.js",
  "chakra/Generated/ne1.js",
  "chakra/Generated/ne2.js",
  "chakra/Generated/ne3.js",
  "chakra/Generated/or.js",
  "chakra/Generated/or0.js",
  "chakra/Generated/or1.js",
  "chakra/Generated/or2.js",
  "chakra/Generated/or3.js",
  "chakra/Generated/rsh.js",
  "chakra/Generated/rsh0.js",
  "chakra/Generated/rsh1.js",
  "chakra/Generated/rsh2.js",
  "chakra/Generated/rsh3.js",
  "chakra/Generated/rshu.js",
  "chakra/Generated/rshu0.js",
  "chakra/Generated/rshu1.js",
  "chakra/Generated/rshu2.js",
  "chakra/Generated/rshu3.js",
  "chakra/Generated/seq.js",
  "chakra/Generated/seq0.js",
  "chakra/Generated/seq1.js",
  "chakra/Generated/seq2.js",
  "chakra/Generated/seq3.js",
  "chakra/Generated/sne.js",
  "chakra/Generated/sne0.js",
  "chakra/Generated/sne1.js",
  "chakra/Generated/sne2.js",
  "chakra/Generated/sne3.js",
  "chakra/Generated/sub.js",
  "chakra/Generated/sub0.js",
  "chakra/Generated/sub1.js",
  "chakra/Generated/sub2.js",
  "chakra/Generated/sub3.js",
  "chakra/Generated/xor.js",
  "chakra/Generated/xor0.js",
  "chakra/Generated/xor1.js",
  "chakra/Generated/xor2.js",
  "chakra/Generated/xor3.js",
  "chakra/GlobalFunctions/ParseInt1.js",
  "chakra/GlobalFunctions/eval1.js",
  "chakra/GlobalFunctions/parseInt.js",
  "chakra/GlobalFunctions/toString.js",
  "chakra/InlineCaches/test6.js",
  "chakra/LetConst/arguments.js",
  "chakra/LetConst/constreassign1.js",
  "chakra/LetConst/defer1.js",
  "chakra/LetConst/eval1.js",
  "chakra/LetConst/letlet.js",
  "chakra/LetConst/scopegen1.js",
  "chakra/LetConst/tdz1.js",
  "chakra/LetConst/tdz2.js",
  "chakra/LetConst/with.js",
  "chakra/Operators/delete2.js",
  "chakra/Operators/delete3.js",
  "chakra/Optimizer/Miscellaneous_MaxInterpret.js",
  "chakra/Optimizer/bugsimplepathbrfoldgetter.js",
  "chakra/Optimizer/test115.js",
  "chakra/Optimizer/test135.js",
  "chakra/Optimizer/test146.js",
  "chakra/PerfHint/try_with_eval_perfhint.js",
  "chakra/Regex/regex1.js",
  "chakra/Scanner/InvalidCharacter.js",
  "chakra/Strings/concat4.js",
  "chakra/Strings/long_concatstr.js",
  "chakra/UnifiedRegex/bugFixRegression.js",
  "chakra/WasmSpec/testsuite/js-api/constructor/instantiate-bad-imports.any.js",
  "chakra/WasmSpec/testsuite/js-api/instance/constructor-bad-imports.any.js",
  "chakra/benchmarks/ARES-6/Babylon/babylon-blob.js",
  "chakra/es6/DeferParseLambda.js",
  "chakra/es6/DeferParseMethods.js",
  "chakra/es6/ES6Iterators-forof.js",
  "chakra/es6/ES6NewTarget.js",
  "chakra/es6/blockscope-deferred.js",
  "chakra/es6/blockscope-functionbinding.js",
  "chakra/es6/boundConstruction.js",
  "chakra/es6/bug_OS17895855.js",
  "chakra/es6/bug_OS_4498031.js",
  "chakra/es6/bug_issue_3247_dep.js",
  "chakra/es6/bug_issue_5994.js",
  "chakra/es6/default-splitscope-undodeferparse.js",
  "chakra/es6/default-splitscope.js",
  "chakra/es6/default.js",
  "chakra/es6/destructuring_params.js",
  "chakra/es6/destructuring_params_arguments_override.js",
  "chakra/es6/forInEdgeCases.js",
  "chakra/es6/generators-functionality.js",
  "chakra/es6/generators-syntax.js",
  "chakra/es6/globalCatchNewTargetSyntaxError.js",
  "chakra/es6/globalNewTargetSyntaxError.js",
  "chakra/es6/globalParamCatchNewTargetSyntaxError.js",
  "chakra/es6/lambda-expr.js",
  "chakra/es6/lambda1.js",
  "chakra/es6/letconst_global_shadow_deleted.js",
  "chakra/es6/objlit.js",
  "chakra/es6/rest.js",
  "chakra/es6/spreadIterator.js",
  "chakra/es6/supersyntax02.js",
  "chakra/es6/supersyntax05.js",
  "chakra/es6/supersyntax06.js",
  "chakra/es6/unicode_6_identifier_Blue511452.js",
  "chakra/es6/unicode_6_identifier_Blue524737.js",
  "chakra/es6/unscopablesWithEsArrayFindFromLastTest.js",
  "chakra/es6/unscopablesWithScopeTest.js",
  "chakra/es6module/GetModuleNamespace.js",
  "chakra/es6module/ModuleCircularBar.js",
  "chakra/es6module/ModuleCircularFoo.js",
  "chakra/es6module/ModuleComplexExports.js",
  "chakra/es6module/ModuleComplexReexports.js",
  "chakra/es6module/ModuleDefaultExport1.js",
  "chakra/es6module/ModuleDefaultExport2.js",
  "chakra/es6module/ModuleDefaultExport3.js",
  "chakra/es6module/ModuleDefaultExport4.js",
  "chakra/es6module/ModuleDefaultReexport.js",
  "chakra/es6module/ModuleReexportDefault.js",
  "chakra/es6module/ModuleSimpleExport.js",
  "chakra/es6module/ModuleSimpleReexport.js",
  "chakra/es6module/ValidExportDefaultStatement1.js",
  "chakra/es6module/ValidExportDefaultStatement2.js",
  "chakra/es6module/ValidExportStatements.js",
  "chakra/es6module/ValidExportStatements2.js",
  "chakra/es6module/ValidImportStatements.js",
  "chakra/es6module/ValidReExportStatements.js",
  "chakra/es6module/bug_OS12095746.js",
  "chakra/es6module/bug_OS12095746_mod0.js",
  "chakra/es6module/bug_OS12095746_mod1.js",
  "chakra/es6module/bug_OS12095746_mod2.js",
  "chakra/es6module/bug_OS12095746_moddep.js",
  "chakra/es6module/bug_OS12113549_module1.js",
  "chakra/es6module/bug_OS14562349.js",
  "chakra/es6module/bug_issue_3076.js",
  "chakra/es6module/bug_issue_3257/mod/mod0.js",
  "chakra/es6module/bug_issue_3257/mod1.js",
  "chakra/es6module/bug_issue_3257/mod2/mod2.js",
  "chakra/es6module/bug_issue_3257/script/script0.js",
  "chakra/es6module/bug_issue_5777.js",
  "chakra/es6module/dynamic_import_promises_5796.js",
  "chakra/es6module/exportBinding.js",
  "chakra/es6module/exportmodule.js",
  "chakra/es6module/module-3250-bug-dep.js",
  "chakra/es6module/module-3250-bug-dep2.js",
  "chakra/es6module/module-3250-ext-a.js",
  "chakra/es6module/module-3250-ext-b.js",
  "chakra/es6module/moduleExport1.js",
  "chakra/es6module/moduleImportTheError.js",
  "chakra/es6module/moduleThrowAnError.js",
  "chakra/es6module/module_1_2645.js",
  "chakra/es6module/module_2_2645.js",
  "chakra/es6module/module_4482_dep1.js",
  "chakra/es6module/module_4482_dep2.js",
  "chakra/es6module/module_4482_dep3.js",
  "chakra/es6module/module_4570_dep1.js",
  "chakra/es6module/module_4570_dep2.js",
  "chakra/es6module/moduletest2_mod0.js",
  "chakra/es6module/moduletest2_mod1a.js",
  "chakra/es6module/moduletest2_mod1b.js",
  "chakra/es6module/moduletest2_mod2a.js",
  "chakra/es6module/otherModule.js",
  "chakra/es6module/passmodule.js",
  "chakra/es6module/testDynamicImportfromModule.js",
  "chakra/es6module/top-level-await.js",
  "chakra/es7/asyncawait-functionality.js",
  "chakra/es7/json_superset.js",
  "chakra/fieldopts/equiv-mismatch2.js",
  "chakra/fieldopts/markTemp.js",
  "chakra/inlining/bug_gh6303.js",
  "chakra/inlining/profilingbug.js",
  "chakra/loop/loop.js",
  "chakra/stackfunc/602481.js",
  "chakra/stackfunc/arguments_assignment.js",
  "chakra/stackfunc/with_crossscope.js",
  "chakra/stackfunc/with_existing.js",
  "chakra/stackfunc/with_namedfunc.js",
  "chakra/stackfunc/withref_delayobjscope.js",
  "chakra/strict/basics_function_in_SM.js",
  "chakra/strict/bug212755.js",
  "chakra/strict/comma_bug219390.js",
  "chakra/strict/delete.js",
  "chakra/strict/formal_samename1.js",
  "chakra/strict/formal_samename2.js",
  "chakra/strict/multiunit.js",
  "chakra/strict/nonSimpleParameterList.js",
  "chakra/strict/strictargs-deferred.js",
  "chakra/strict/strictargs2-deferred.js",
  "chakra/strict/strictargs3-deferred.js",
  "chakra/strict/stricteval-deferred.js",
  "chakra/strict/stricteval2-deferred.js",
  "chakra/strict/strictkwd-deferred.js",
  "chakra/wasm.simd/int64x2Tests.js",
  /* Tests requiring sloppy mode from jstests */
  "WebKit/JSTests/es6/Proxy_internal_get_calls_HasBinding.js",
  "WebKit/JSTests/es6/non-strict_function_semantics_function_statements_in_if-statement_clauses.js",
  "WebKit/JSTests/es6/non-strict_function_semantics_labeled_function_statements.js",
  "WebKit/JSTests/es6/well-known_symbols_Symbol.unscopables.js",
  "WebKit/JSTests/stress/adhoc-setter-frame-should-not-be-killed.js",
  "WebKit/JSTests/stress/allocation-sinking-changing-structures.js",
  "WebKit/JSTests/stress/allocation-sinking-hints-are-valid-ssa-2.js",
  "WebKit/JSTests/stress/allocation-sinking-hints-are-valid-ssa.js",
  "WebKit/JSTests/stress/array-copywithin.js",
  "WebKit/JSTests/stress/arrow-function-and-use-strict-directive.js",
  "WebKit/JSTests/stress/arrow-functions-as-default-parameter-values.js",
  "WebKit/JSTests/stress/arrowfunction-lexical-bind-arguments-non-strict-1.js",
  "WebKit/JSTests/stress/arrowfunction-lexical-bind-arguments-non-strict-2.js",
  "WebKit/JSTests/stress/arrowfunction-lexical-bind-this-8.js",
  "WebKit/JSTests/stress/big-int-as-property-name.js",
  "WebKit/JSTests/stress/bytecode-for-rmw-with-invalid-right-side.js",
  "WebKit/JSTests/stress/const-and-with-statement.js",
  "WebKit/JSTests/stress/const-not-strict-mode.js",
  "WebKit/JSTests/stress/constant-closure-var-with-dynamic-invalidation.js",
  "WebKit/JSTests/stress/do-eval-virtual-call-correctly.js",
  "WebKit/JSTests/stress/es6-default-parameters.js",
  "WebKit/JSTests/stress/escaped-keyword-identifiers.js",
  "WebKit/JSTests/stress/eval-cached.js",
  "WebKit/JSTests/stress/eval-func-decl-block-with-var-and-remove.js",
  "WebKit/JSTests/stress/eval-func-decl-in-eval-within-with-scope.js",
  "WebKit/JSTests/stress/eval-that-is-not-eval.js",
  "WebKit/JSTests/stress/for-in-tests.js",
  "WebKit/JSTests/stress/for-let-comma.js",
  "WebKit/JSTests/stress/generator-syntax.js",
  "WebKit/JSTests/stress/get-argument-by-val-safe-in-inlined-varargs-call-out-of-bounds.js",
  "WebKit/JSTests/stress/get-by-offset-should-use-correct-child.js",
  "WebKit/JSTests/stress/get-from-scope-dynamic-onto-proxy.js",
  "WebKit/JSTests/stress/get-my-argument-by-val-safe-out-of-bounds.js",
  "WebKit/JSTests/stress/get-my-argument-by-val-safe-wrap-around.js",
  "WebKit/JSTests/stress/getter-setter-should-be-cell.js",
  "WebKit/JSTests/stress/global-environment-does-not-trap-unscopables.js",
  "WebKit/JSTests/stress/global-lexical-environment-access-from-module.js",
  "WebKit/JSTests/stress/global-lexical-variable-with-statement.js",
  "WebKit/JSTests/stress/global-object-proto-getter.js",
  "WebKit/JSTests/stress/hashbang.js",
  "WebKit/JSTests/stress/import-basic.js",
  "WebKit/JSTests/stress/import-exception.js",
  "WebKit/JSTests/stress/import-from-eval.js",
  "WebKit/JSTests/stress/import-reject-with-exception.js",
  "WebKit/JSTests/stress/import-tests/cocoa.js",
  "WebKit/JSTests/stress/import-tests/multiple.js",
  "WebKit/JSTests/stress/import-tests/multiple2.js",
  "WebKit/JSTests/stress/import-tests/should.js",
  "WebKit/JSTests/stress/import-with-empty-string.js",
  "WebKit/JSTests/stress/intl-object.js",
  "WebKit/JSTests/stress/lazy-global-object-property-materialization-should-not-putDirectWithoutTransition.js",
  "WebKit/JSTests/stress/lexical-let-and-with-statement.js",
  "WebKit/JSTests/stress/lexical-let-not-strict-mode.js",
  "WebKit/JSTests/stress/licm-should-handle-if-a-hoist-causes-a-provable-osr-exit.js",
  "WebKit/JSTests/stress/logical-assignment-operator-and.js",
  "WebKit/JSTests/stress/logical-assignment-operator-coalesce.js",
  "WebKit/JSTests/stress/logical-assignment-operator-or.js",
  "WebKit/JSTests/stress/module-namespace-access-change.js",
  "WebKit/JSTests/stress/module-namespace-access-non-constant.js",
  "WebKit/JSTests/stress/module-namespace-access-poly.js",
  "WebKit/JSTests/stress/module-namespace-access-set-fails.js",
  "WebKit/JSTests/stress/module-namespace-access-transitive-exports.js",
  "WebKit/JSTests/stress/module-namespace-access.js",
  "WebKit/JSTests/stress/module-namespace-object-caching.js",
  "WebKit/JSTests/stress/object-allocation-sinking-interpretation-can-interpret-edges-that-can-be-proven-unreachable-in-ai.js",
  "WebKit/JSTests/stress/object-allocation-sinking-phase-needs-to-write-to-each-scope-offset.js",
  "WebKit/JSTests/stress/optional-chaining-and-private-fields.js",
  "WebKit/JSTests/stress/printableModuleKey-should-never-throw.js",
  "WebKit/JSTests/stress/private-in-error.js",
  "WebKit/JSTests/stress/private-in.js",
  "WebKit/JSTests/stress/proxy-call-apply-handler-to-this.js",
  "WebKit/JSTests/stress/proxy-getter-stack-overflow.js",
  "WebKit/JSTests/stress/proxy-stack-overflow-exceptions.js",
  "WebKit/JSTests/stress/proxy-trap-this.js",
  "WebKit/JSTests/stress/proxy-with-statement.js",
  "WebKit/JSTests/stress/put-dynamic-var-strict-and-sloppy.js",
  "WebKit/JSTests/stress/re-execute-error-module.js",
  "WebKit/JSTests/stress/regress-159954.js",
  "WebKit/JSTests/stress/regress-170732.js",
  "WebKit/JSTests/stress/regress-178890.js",
  "WebKit/JSTests/stress/regress-191856.js",
  "WebKit/JSTests/stress/regress-192626.js",
  "WebKit/JSTests/stress/resources/error-module.js",
  "WebKit/JSTests/stress/resources/global-lexical-environment-access-from-module-child.js",
  "WebKit/JSTests/stress/resources/module-namespace-access-transitive-exports-2.js",
  "WebKit/JSTests/stress/resources/module-namespace-access-transitive-exports.js",
  "WebKit/JSTests/stress/resources/module-namespace-access.js",
  "WebKit/JSTests/stress/resources/shadow-realm-example-module.js",
  "WebKit/JSTests/stress/resources/to-string-module.js",
  "WebKit/JSTests/stress/resources/value-of-module.js",
  "WebKit/JSTests/stress/scoped-arguments-table-should-be-tolerant-for-oom.js",
  "WebKit/JSTests/stress/shadow-realm-import-value.js",
  "WebKit/JSTests/stress/sloppy-mode-function-hoisting.js",
  "WebKit/JSTests/stress/sloppy-mode-hoist-arguments-function-non-simple-parameter-list.js",
  "WebKit/JSTests/stress/string-prototype-scopes.js",
  "WebKit/JSTests/stress/tagged-templates-this.js",
  "WebKit/JSTests/stress/terminated-execution-error-in-promise.js",
  "WebKit/JSTests/stress/to-this-before-arrow-function-closes-over-this-that-starts-as-lexical-environment.js",
  "WebKit/JSTests/stress/unscopables.js",
  "WebKit/JSTests/stress/use-arguments-as-object-pointer.js",
  "WebKit/JSTests/stress/values-unscopables.js",
  "WebKit/JSTests/stress/variable-named-eval-under-tdz.js",
  "WebKit/JSTests/stress/with.js",
  "WebKit/JSTests/stress/with_and_arith.js",
  "WebKit/JSTests/stress/yield-label.js",
  /* Tests requiring sloppy mode from crashtests */
  "CrashTests/115674352/util.js",
  "CrashTests/132918471/fast/js/resources/js-test-post.js",
  "CrashTests/135733397/resources/cookies-test-post.js",
  "CrashTests/158344541/support/refTestWait.js",
  "CrashTests/178811021/media-file.js",
  "CrashTests/178811021/video-test.js",
  "CrashTests/31681819/fast/js/resources/js-test-post.js",
  "CrashTests/4506116685037568/00422.js",
  "CrashTests/4506610717425664/00502.js",
  "CrashTests/4523272292270080/02509.js",
  "CrashTests/4527439453618176/00122.js",
  "CrashTests/4528969625894912/encaiiljifbdbjlphpgpiimidegddhic/lib/tweet_manager.js",
  "CrashTests/4528969625894912/lib/tweet_manager.js",
  "CrashTests/4531783459405824/01124.js",
  "CrashTests/4542853924782080/01450.js",
  "CrashTests/4553411667165184/00361.js",
  "CrashTests/4558140288794624/00118.js",
  "CrashTests/4559554636677120/00921.js",
  "CrashTests/4563969814560768/1.0.2/conformance/resources/webgl-test-utils.js",
  "CrashTests/4563969814560768/1.0.2/conformance/resources/webgl-test.js",
  "CrashTests/4563969814560768/1.0.2/resources/js-test-pre.js",
  "CrashTests/4570511337324544/01067.js",
  "CrashTests/4592095397150720/619.js",
  "CrashTests/4599018605772800/00095.js",
  "CrashTests/4609052021096448/02286.js",
  "CrashTests/4620742728613888/02272.js",
  "CrashTests/4624768836632576/00383.js",
  "CrashTests/4625478540066816/02759.js",
  "CrashTests/4632675287826432/01188.js",
  "CrashTests/4636862568726528/02064.js",
  "CrashTests/4637950708285440/02664.js",
  "CrashTests/4646057439133696/01096.js",
  "CrashTests/4665806235369472/02400.js",
  "CrashTests/4666942225383424/00033.js",
  "CrashTests/4675875294674944/04443.js",
  "CrashTests/4676310267068416/00041.js",
  "CrashTests/4676310267068416/meta-00041.js",
  "CrashTests/4678125190643712/01568.js",
  "CrashTests/4689880216240128/meta-00116.js",
  "CrashTests/4692754406047744/00819.js",
  "CrashTests/4704815858057216/02665.js",
  "CrashTests/4709921473167360/00418.js",
  "CrashTests/4710304564903936/resources/js-test-post.js",
  "CrashTests/4714207862587392/03389.js",
  "CrashTests/4714965806153728/00222.js",
  "CrashTests/4715062213476352/meta-00915.js",
  "CrashTests/4730791635451904/00498.js",
  "CrashTests/4731918950203392/04316.js",
  "CrashTests/4736176662773760/01784.js",
  "CrashTests/4747467118084096/02508.js",
  "CrashTests/4747813124571136/00737.js",
  "CrashTests/4762878654545920/00656.js",
  "CrashTests/4763433329491968/01684.js",
  "CrashTests/4769018565623808/00203.js",
  "CrashTests/4769117811507200/01576.js",
  "CrashTests/4776648177352704/02684.js",
  "CrashTests/4777280799506432/01745.js",
  "CrashTests/4778588336291840/03439.js",
  "CrashTests/4784915024707584/meta-00090.js",
  "CrashTests/4786126975139840/00686.js",
  "CrashTests/4804556499451904/07362.js",
  "CrashTests/4804606392795136/00345.js",
  "CrashTests/4808505226690560/00570.js",
  "CrashTests/4816373903785984/01394.js",
  "CrashTests/4817362373836800/01654.js",
  "CrashTests/4823335117783040/meta-00192.js",
  "CrashTests/4827148775849984/02704.js",
  "CrashTests/4828749863583744/00863.js",
  "CrashTests/4830304484196352/01110.js",
  "CrashTests/4835573090222080/00096.js",
  "CrashTests/4835573090222080/meta-00096.js",
  "CrashTests/4837730048278528/03052.js",
  "CrashTests/4843490131312640/03475.js",
  "CrashTests/4848225223245824/resources/js-test-post.js",
  "CrashTests/4850895428517888/2670.js",
  "CrashTests/4854644212105216/392.js",
  "CrashTests/4855156194934784/meta-00080.js",
  "CrashTests/4863599620390912/01845.js",
  "CrashTests/4865459476234240/02997.js",
  "CrashTests/4867582249664512/01063.js",
  "CrashTests/4876270013382656/test.js",
  "CrashTests/4877247254626304/00194.js",
  "CrashTests/4888824389304320/00897.js",
  "CrashTests/4895370524491776/00981.js",
  "CrashTests/4897972860223488/00795.js",
  "CrashTests/4899093893742592/02412.js",
  "CrashTests/4904085663776768/01119.js",
  "CrashTests/4907797561212928/01094.js",
  "CrashTests/4907899447410688/lib/prototype.js",
  "CrashTests/4908800751173632/02190.js",
  "CrashTests/4914294111076352/resources/worker-common.js",
  "CrashTests/4917356818071552/00992.js",
  "CrashTests/4920133693472768/09913.js",
  "CrashTests/4924640359088128/resources/methods.js",
  "CrashTests/4930344755658752/00813.js",
  "CrashTests/4932372025311232/01177.js",
  "CrashTests/4940906897866752/01190.js",
  "CrashTests/4966722004058112/01202.js",
  "CrashTests/4972148754743296/01007.js",
  "CrashTests/4976392256618496/01500.js",
  "CrashTests/4982480049274880/00401.js",
  "CrashTests/4991878320095232/01486.js",
  "CrashTests/4996582417891328/00314.js",
  "CrashTests/5000906812162048/02217.js",
  "CrashTests/5006028967247872/01936.js",
  "CrashTests/5010596302946304/03143.js",
  "CrashTests/5010966233481216/05443.js",
  "CrashTests/5015563071913984/00891.js",
  "CrashTests/5016449390477312/02595.js",
  "CrashTests/5017709745274880/00480.js",
  "CrashTests/5019028805124096/01923.js",
  "CrashTests/5020202404937728/04355.js",
  "CrashTests/5024919414112256/02190.js",
  "CrashTests/5026147325968384/01281.js",
  "CrashTests/5026251190829056/01496.js",
  "CrashTests/5034236802498560/00038.js",
  "CrashTests/5034236802498560/meta-00038.js",
  "CrashTests/5036266378756096/resources/js-test.js",
  "CrashTests/5040821977219072/07176.js",
  "CrashTests/5047964758441984/02170.js",
  "CrashTests/5048503350853632/00378.js",
  "CrashTests/5055795031965696/00903.js",
  "CrashTests/5064701201350656/mjsunit_modified.js",
  "CrashTests/5068740508516352/00968.js",
  "CrashTests/5068815053619200/02921.js",
  "CrashTests/5070483825885184/01709.js",
  "CrashTests/5071018176282624/05782.js",
  "CrashTests/5072932293050368/01965.js",
  "CrashTests/5073353348087808/03720.js",
  "CrashTests/5076362928848896/00103.js",
  "CrashTests/5080979047317504/04300.js",
  "CrashTests/5083229709664256/00286.js",
  "CrashTests/5083537469079552/03453.js",
  "CrashTests/5086848684654592/00140.js",
  "CrashTests/5087262806704128/00566.js",
  "CrashTests/5089350304661504/04000.js",
  "CrashTests/5090843606515712/4564.js",
  "CrashTests/5091969183776768/js/angular.js",
  "CrashTests/5092426574987264/02412.js",
  "CrashTests/5092539386822656/00729.js",
  "CrashTests/5096882252677120/05262.js",
  "CrashTests/5097225136504832/00340.js",
  "CrashTests/5104674803023872/meta-00066.js",
  "CrashTests/5107484490989568/00655.js",
  "CrashTests/5110246766673920/117.js",
  "CrashTests/5113028242702336/03897.js",
  "CrashTests/5114377424601088/00224.js",
  "CrashTests/5120973776420864/00299.js",
  "CrashTests/5126302418337792/00216.js",
  "CrashTests/5126730184654848/00846.js",
  "CrashTests/5127274311843840/769.js",
  "CrashTests/5128141337133056/898.js",
  "CrashTests/5129004072042496/02689.js",
  "CrashTests/5130481752735744/817.js",
  "CrashTests/5140656268640256/resources/interpolation-test.js",
  "CrashTests/5150697335816192/04726.js",
  "CrashTests/5151090662178816/01492.js",
  "CrashTests/5152408142086144/01220.js",
  "CrashTests/5153368765628416/00787.js",
  "CrashTests/5157575680327680/06055.js",
  "CrashTests/5159014924288000/01496.js",
  "CrashTests/5164793027624960/01357.js",
  "CrashTests/5165045173846016/Common/MV.js",
  "CrashTests/5165672034205696/05364.js",
  "CrashTests/5168023154720768/meta-00125.js",
  "CrashTests/5171157051899904/00383.js",
  "CrashTests/5171658670473216/02099.js",
  "CrashTests/5174188858146816/00365.js",
  "CrashTests/5190716938387456/05795.js",
  "CrashTests/5192473061359616/meta-00780.js",
  "CrashTests/5197954434596864/01324.js",
  "CrashTests/5200019587334144/meta-00398.js",
  "CrashTests/5214085959909376/00916.js",
  "CrashTests/5219122255757312/00999.js",
  "CrashTests/5222394685292544/resources/stress-js-execution.js",
  "CrashTests/5225766790889472/03395.js",
  "CrashTests/5226258591121408/04850.js",
  "CrashTests/5226692407984128/meta-00030.js",
  "CrashTests/5226950361612288/01783.js",
  "CrashTests/5228917292597248/01383.js",
  "CrashTests/5231597301334016/00307.js",
  "CrashTests/5238861996490752/01351.js",
  "CrashTests/5242104612651008/mjsunit_modified.js",
  "CrashTests/5254331529166848/meta-00409.js",
  "CrashTests/5254663852261376/meta-00497.js",
  "CrashTests/5257477901778944/06912.js",
  "CrashTests/5265513080946688/00263.js",
  "CrashTests/5271669179678720/01206.js",
  "CrashTests/5280655383724032/meta-00355.js",
  "CrashTests/5283736101322752/00921.js",
  "CrashTests/5289653387919360/635.js",
  "CrashTests/5292566928162816/05416.js",
  "CrashTests/5301431549820928/meta-00738.js",
  "CrashTests/5313740812320768/00284.js",
  "CrashTests/5326135539793920/01618.js",
  "CrashTests/5327466171465728/benchmarks/propertyTreeSplitting.js",
  "CrashTests/5335637787934720/mersenne.js",
  "CrashTests/5337864091729920/00078.js",
  "CrashTests/5346139261108224/meta-00086.js",
  "CrashTests/5351139388424192/00966.js",
  "CrashTests/5351969500168192/02350.js",
  "CrashTests/5352173552795648/00798.js",
  "CrashTests/5352347554545664/00293.js",
  "CrashTests/5354535555825664/01561.js",
  "CrashTests/5361893420302336/03633.js",
  "CrashTests/5363987624493056/00401.js",
  "CrashTests/5367250713575424/00858.js",
  "CrashTests/5384147026837504/00846.js",
  "CrashTests/5385945858179072/01283.js",
  "CrashTests/5385947877998592/00345.js",
  "CrashTests/5390684309946368/00499.js",
  "CrashTests/5397761290403840/00742.js",
  "CrashTests/5397969593958400/02399.js",
  "CrashTests/5400975855321088/04550.js",
  "CrashTests/5402562393276416/meta-00565.js",
  "CrashTests/5417888764657664/01529.js",
  "CrashTests/5418169017303040/156.js",
  "CrashTests/5420098825748480/01174.js",
  "CrashTests/5435516837429248/02591.js",
  "CrashTests/5439052443025408/01562.js",
  "CrashTests/5443705157976064/04908.js",
  "CrashTests/5443796254064640/08661.js",
  "CrashTests/5474124668600320/meta-00992.js",
  "CrashTests/5480706662727680/02537.js",
  "CrashTests/5486126228570112/02840.js",
  "CrashTests/5487631620112384/animations/resources/animation-test-helpers.js",
  "CrashTests/5494987147444224/01679.js",
  "CrashTests/5513876092223488/00005.js",
  "CrashTests/5521703332741120/00376.js",
  "CrashTests/5528671464456192/01324.js",
  "CrashTests/5530121586081792/03646.js",
  "CrashTests/5530153792045056/meta-00910.js",
  "CrashTests/5536392074493952/01051.js",
  "CrashTests/5540548491608064/01146.js",
  "CrashTests/5541203771916288/currentscript.js",
  "CrashTests/5544125599580160/00526.js",
  "CrashTests/5559694775025664/imported/w3c/html-templates/testcommon.js",
  "CrashTests/5559694775025664/resources/testharness.js",
  "CrashTests/5559694775025664/resources/testharnessreport.js",
  "CrashTests/5568247077011456/04042.js",
  "CrashTests/5577681470488576/00437.js",
  "CrashTests/5593713261412352/319.js",
  "CrashTests/5603057343660032/01771.js",
  "CrashTests/5605754113884160/01777.js",
  "CrashTests/5606041047007232/02795.js",
  "CrashTests/5606702255964160/meta-00168.js",
  "CrashTests/5612290518810624/dist/jquery.js",
  "CrashTests/5615411944226816/02684.js",
  "CrashTests/5620205313589248/01035.js",
  "CrashTests/5625391309127680/02293.js",
  "CrashTests/5630063870214144/02130.js",
  "CrashTests/5630225822121984/03637.js",
  "CrashTests/5630410519478272/916.js",
  "CrashTests/5635092719599616/00041.js",
  "CrashTests/5635645835182080/worker-serviceworker-7636bedbbb1f120d.js",
  "CrashTests/5639584467910656/00441.js",
  "CrashTests/5639628713492480/04139.js",
  "CrashTests/5642849944993792/resources/js-test.js",
  "CrashTests/5642994023202816/950.js",
  "CrashTests/5644307466878976/__MACOSX/._audio.js",
  "CrashTests/5644307466878976/__MACOSX/._processor.js",
  "CrashTests/5645896422522880/00670.js",
  "CrashTests/5648004624678912/01755.js",
  "CrashTests/5649862583648256/meta-00236.js",
  "CrashTests/5650039238033408/00812.js",
  "CrashTests/5651439780495360/250.js",
  "CrashTests/5651703040835584/resources/testharnessreport.js",
  "CrashTests/5652465613406208/4584.js",
  "CrashTests/5657116044951552/scripts/options.js",
  "CrashTests/5657183745998848/01385.js",
  "CrashTests/5657306247462912/00434.js",
  "CrashTests/5661345388167168/resources/stress-js-execution.js",
  "CrashTests/5662199714480128/00467.js",
  "CrashTests/5662596912513024/265.js",
  "CrashTests/5664971082694656/02223.js",
  "CrashTests/5665078627663872/262.js",
  "CrashTests/5668694740172800/meta-00294.js",
  "CrashTests/5672678890405888/resources/js-test.js",
  "CrashTests/5672678890405888/webaudio/resources/distance-model-testing.js",
  "CrashTests/5675659103830016/04982.js",
  "CrashTests/5676981169487872/01110.js",
  "CrashTests/5677821452091392/02168.js",
  "CrashTests/5679632916676608/04152.js",
  "CrashTests/5684463616917504/01498.js",
  "CrashTests/5685487336161280/03642.js",
  "CrashTests/5686447370665984/sdk/tests/conformance/ogles/ogles-utils.js",
  "CrashTests/5686447370665984/sdk/tests/conformance/resources/glsl-conformance-test.js",
  "CrashTests/5686447370665984/sdk/tests/conformance/resources/webgl-test-utils.js",
  "CrashTests/5686447370665984/sdk/tests/resources/js-test-pre.js",
  "CrashTests/5688866685321216/09854.js",
  "CrashTests/5689884189392896/02723.js",
  "CrashTests/5690371071803392/01662.js",
  "CrashTests/5690744270487552/oob_write.js",
  "CrashTests/5694376231632896/1033966.js",
  "CrashTests/5694701996867584/conformance/resources/webgl-test.js",
  "CrashTests/5696049601314816/7.js",
  "CrashTests/5697903049441280/03188.js",
  "CrashTests/5703976838234112/test.js",
  "CrashTests/5706349639434240/804.js",
  "CrashTests/5707472246472704/1443.js",
  "CrashTests/5712001662517248/report.js",
  "CrashTests/5713776938582016/00793.js",
  "CrashTests/5721502735532032/03042.js",
  "CrashTests/5729254488211456/151.js",
  "CrashTests/5733293570392064/00764.js",
  "CrashTests/5734750167105536/01271.js",
  "CrashTests/5735023732064256/meta-00070.js",
  "CrashTests/5736353084342272/resources/testharness.js",
  "CrashTests/5737388710821888/resources/js-test.js",
  "CrashTests/5738737345822720/svg/dynamic-updates/resources/SVGTestCase.js",
  "CrashTests/5744365229441024/resources/testharness.js",
  "CrashTests/5745342726537216/meta-00053.js",
  "CrashTests/5747146314285056/support/alertAssert.sub.js",
  "CrashTests/5747146314285056/support/logTest.sub.js",
  "CrashTests/5750922200875008/747.js",
  "CrashTests/5753604559470592/03311.js",
  "CrashTests/5754855756136448/00202.js",
  "CrashTests/5755508264534016/00224.js",
  "CrashTests/5763511307337728/04651.js",
  "CrashTests/5763879718617088/lib/prototype.js",
  "CrashTests/5764427184865280/00843.js",
  "CrashTests/5765576144060416/815.js",
  "CrashTests/5767941953945600/02556.js",
  "CrashTests/5774432061095936/00972.js",
  "CrashTests/5780358435962880/02297.js",
  "CrashTests/5781432505466880/02329.js",
  "CrashTests/5784274577129472/146.js",
  "CrashTests/5784274665996288/02175.js",
  "CrashTests/5794086030147584/04345.js",
  "CrashTests/5798263663099904/01459.js",
  "CrashTests/5802116248764416/06966.js",
  "CrashTests/5806021251432448/background.js",
  "CrashTests/58219635/fast/js/resources/js-test-post.js",
  "CrashTests/5826758986170368/resources/js-test-post.js",
  "CrashTests/5830309687853056/00112.js",
  "CrashTests/5830406377832448/01330.js",
  "CrashTests/5832728473239552/02422.js",
  "CrashTests/5841445051170816/resources/js-test-pre.js",
  "CrashTests/5842510916091904/resources/webgl_test_files/resources/js-test-post.js",
  "CrashTests/58693299/selfhtml.js",
  "CrashTests/5878747354365952/02158.js",
  "CrashTests/5910324886634496/02597.js",
  "CrashTests/5913894233833472/05410.js",
  "CrashTests/5914309578784768/repro.js",
  "CrashTests/5919491238920192/00154.js",
  "CrashTests/5925149103357952/webaudio/resources/audit.js",
  "CrashTests/5931087833333760/03890.js",
  "CrashTests/5931608799707136/04633.js",
  "CrashTests/5933875666616320/01048.js",
  "CrashTests/5936525417644032/00317.js",
  "CrashTests/5941859303555072/01996.js",
  "CrashTests/5949184339083264/poc.js",
  "CrashTests/5950573451804672/494.js",
  "CrashTests/5950617700007936/01848.js",
  "CrashTests/5957695718031360/01051.js",
  "CrashTests/5969639398440960/00249.js",
  "CrashTests/5970316012290048/414.js",
  "CrashTests/5978056946876416/00920.js",
  "CrashTests/5989158878183424/02865.js",
  "CrashTests/5990019710320640/00076.js",
  "CrashTests/5996165326962688/meta-00146.js",
  "CrashTests/6002230377840640/01046.js",
  "CrashTests/6007370099195904/HTML5/Bugbash/Demo.js",
  "CrashTests/6010230465626112/resources/webgl_test_files/js/tests/tex-image-and-sub-image-with-image-bitmap-utils.js",
  "CrashTests/6018592823836672/support/refTestWait.js",
  "CrashTests/6022256973840384/04395.js",
  "CrashTests/6022630427590656/03625.js",
  "CrashTests/6023488715620352/04168.js",
  "CrashTests/6026840030314496/00848.js",
  "CrashTests/6034116338909184/513.js",
  "CrashTests/6037361396809728/02741.js",
  "CrashTests/6043736092966912/00712.js",
  "CrashTests/6049932086083584/03169.js",
  "CrashTests/6051257375784960/03082.js",
  "CrashTests/6054819434070016/02737.js",
  "CrashTests/6059329424457728/01928.js",
  "CrashTests/6068082133696512/01044.js",
  "CrashTests/6071110049988608/00548.js",
  "CrashTests/6073192676327424/resources/js-test-pre.js",
  "CrashTests/6081148422979584/00926.js",
  "CrashTests/6081568072531968/02867.js",
  "CrashTests/6085702952681472/00521.js",
  "CrashTests/6096783899361280/01310.js",
  "CrashTests/6099421385981952/04526.js",
  "CrashTests/6103999282413568/fast/dom/script-tests/event-handlers.js",
  "CrashTests/6107917668319232/00571.js",
  "CrashTests/6113149884563456/02823.js",
  "CrashTests/6124318079582208/00744.js",
  "CrashTests/6131247808839680/00012.js",
  "CrashTests/6132283327971328/resources/autosizingTest.js",
  "CrashTests/6134706385977344/00149.js",
  "CrashTests/6136495474737152/00377.js",
  "CrashTests/6150179231105024/conformance/resources/webgl-test.js",
  "CrashTests/6156744933769216/02993.js",
  "CrashTests/6158905865666560/meta-00624.js",
  "CrashTests/6162601424453632/00565.js",
  "CrashTests/6166378025320448/dist/jquery.js",
  "CrashTests/6169525843394560/00344.js",
  "CrashTests/6171947516297216/00845.js",
  "CrashTests/6179220893204480/02159.js",
  "CrashTests/6179752663842816/01196.js",
  "CrashTests/6183005912825856/00515.js",
  "CrashTests/6183415490019328/02656.js",
  "CrashTests/6198951751188480/1248.js",
  "CrashTests/6199083597824000/00227.js",
  "CrashTests/6202558821957632/02015.js",
  "CrashTests/6204924829630464/meta-00272.js",
  "CrashTests/6211017381249024/01253.js",
  "CrashTests/6213317429559296/02944.js",
  "CrashTests/6216405020835840/03985.js",
  "CrashTests/6218202061209600/mersenne.js",
  "CrashTests/6220111297118208/meta-00050.js",
  "CrashTests/6223202209234944/02648.js",
  "CrashTests/6234705257168896/01780.js",
  "CrashTests/6239384157552640/meta-00271.js",
  "CrashTests/6248723961348096/01050.js",
  "CrashTests/6249957991645184/00503.js",
  "CrashTests/6250003584909312/1114.js",
  "CrashTests/6250055858126848/04619.js",
  "CrashTests/6255231244697600/meta-00216.js",
  "CrashTests/6255916311379968/1372.js",
  "CrashTests/6259138054324224/meta-00172.js",
  "CrashTests/6263485068017664/MediaSessionTestUtils.js",
  "CrashTests/6269363175555072/00815.js",
  "CrashTests/6273728140017664/03583.js",
  "CrashTests/6277052166832128/00830.js",
  "CrashTests/6278159702425600/01463.js",
  "CrashTests/6280577705705472/1146.js",
  "CrashTests/6285336190124032/01621.js",
  "CrashTests/6290863075688448/192.js",
  "CrashTests/6292792642371584/00047.js",
  "CrashTests/6294597573541888/00725.js",
  "CrashTests/6294835115065344/00805.js",
  "CrashTests/6295241556492288/01763.js",
  "CrashTests/6300171514675200/00115.js",
  "CrashTests/6304143111356416/00782.js",
  "CrashTests/6313127026688000/02126.js",
  "CrashTests/6316400054960128/165.js",
  "CrashTests/6319065615040512/04012.js",
  "CrashTests/6328755580567552/resources/js-test.js",
  "CrashTests/6328755580567552/svg/dynamic-updates/resources/SVGTestCase.js",
  "CrashTests/6330764245073920/poc1.js",
  "CrashTests/6332832186761216/00681.js",
  "CrashTests/6332904701427712/00888.js",
  "CrashTests/6332930432958464/02637.js",
  "CrashTests/6333032621998080/04777.js",
  "CrashTests/6339944789049344/04142.js",
  "CrashTests/6345007341764608/00699.js",
  "CrashTests/6346448656400384/dist/jquery.js",
  "CrashTests/6351789088833536/meta-00122.js",
  "CrashTests/6352599495475200/meta-00093.js",
  "CrashTests/6353579392630784/04156.js",
  "CrashTests/6358320674242560/resources/js-test.js",
  "CrashTests/6359996105359360/934166-poc.js",
  "CrashTests/6362821967740928/00524.js",
  "CrashTests/6364115106004992/03982.js",
  "CrashTests/6374053756272640/824.js",
  "CrashTests/6384055239835648/00899.js",
  "CrashTests/6387037962240000/02996.js",
  "CrashTests/6391863691706368/01129.js",
  "CrashTests/6394941698998272/meta-00167.js",
  "CrashTests/6403694305476608/meta-00079.js",
  "CrashTests/6405187880353792/meta-00826.js",
  "CrashTests/6406267560263680/02111.js",
  "CrashTests/6406622734974976/meta-00188.js",
  "CrashTests/6408374819487744/02912.js",
  "CrashTests/6413480679964672/01826.js",
  "CrashTests/6417030613041152/02923.js",
  "CrashTests/6417972328660992/09282.js",
  "CrashTests/6419282024726528/00370.js",
  "CrashTests/6423571127599104/04989.js",
  "CrashTests/6427802493779968/meta-00335.js",
  "CrashTests/6440904627060736/meta-00149.js",
  "CrashTests/6441460252803072/04234.js",
  "CrashTests/6443097497010176/1.0.2/resources/webgl_test_files/conformance/resources/webgl-test-utils.js",
  "CrashTests/6443097497010176/1.0.2/resources/webgl_test_files/conformance/resources/webgl-test.js",
  "CrashTests/6443097497010176/1.0.2/resources/webgl_test_files/resources/js-test-pre.js",
  "CrashTests/6443097497010176/1.0.2/resources/webkit-webgl-test-harness.js",
  "CrashTests/6449605693931520/meta-00261.js",
  "CrashTests/6452658006392832/meta-00824.js",
  "CrashTests/6454378660626432/00345.js",
  "CrashTests/6463535346614272/meta-00886.js",
  "CrashTests/6486287733489664/01857.js",
  "CrashTests/6491889133158400/01408.js",
  "CrashTests/6499287285366784/01193.js",
  "CrashTests/6506410742120448/04615.js",
  "CrashTests/6507668386873344/02815.js",
  "CrashTests/6509855193169920/03031.js",
  "CrashTests/6530413356122112/meta-00391.js",
  "CrashTests/6534217117990912/01172.js",
  "CrashTests/6541223017054208/01484.js",
  "CrashTests/6550225930944512/mnt/scratch0/clusterfuzz/slave-bot/inputs/fuzzers/inferno_twister_custom_bundle/inferno_twister_custom_bundle_data/moz_tests/dom/workers/test/threadErrors_worker1.js",
  "CrashTests/6551265423982592/00708.js",
  "CrashTests/6552552797503488/bug_41414141.js",
  "CrashTests/6566622022860800/05257.js",
  "CrashTests/6566953431597056/02044.js",
  "CrashTests/6572559555166208/report.js",
  "CrashTests/6574969751601152/01903.js",
  "CrashTests/6576437049950208/conformance/resources/glsl-generator.js",
  "CrashTests/6576437049950208/resources/js-test-pre.js",
  "CrashTests/6576519795965952/04466.js",
  "CrashTests/6586504922267648/00672.js",
  "CrashTests/6588129316438016/04328.js",
  "CrashTests/6590585390235648/00180.js",
  "CrashTests/6597230699216896/meta-00299.js",
  "CrashTests/6598446651015168/02933.js",
  "CrashTests/6603081141977088/00482.js",
  "CrashTests/6603770342408192/00211.js",
  "CrashTests/6613865297084416/builds/chromium-browser-syzyasan_win32-release/revisions/asan-win32-release-276100/resources/inspector/main/Main.js",
  "CrashTests/6616252740009984/01288.js",
  "CrashTests/6617130045341696/02588.js",
  "CrashTests/6622275291840512/resources/js-test.js",
  "CrashTests/6637202159960064/01577.js",
  "CrashTests/6637774979465216/01973.js",
  "CrashTests/6644133880397824/00752.js",
  "CrashTests/6645639153188864/00207.js",
  "CrashTests/6646069054013440/poc.js",
  "CrashTests/6652514189508608/poc.js",
  "CrashTests/6658388688371712/00042.js",
  "CrashTests/6659440421109760/00027.js",
  "CrashTests/6669656538742784/00851.js",
  "CrashTests/6669776086630400/01043.js",
  "CrashTests/6681695539429376/01791.js",
  "CrashTests/6694038640001024/01601.js",
  "CrashTests/6695292278931456/04706.js",
  "CrashTests/6701111818059776/00487.js",
  "CrashTests/6710149884674048/00808.js",
  "CrashTests/6710629039079424/01300.js",
  "CrashTests/6720085192343552/00257.js",
  "CrashTests/6727300586405888/builds/chromium-browser-syzyasan_win32-release/revisions/asan-win32-release-259551/resources/inspector/Main.js",
  "CrashTests/6731147175526400/meta-00107.js",
  "CrashTests/6744125769252864/494.js",
];
module.exports = {
  generatedSkipped: new Set(skipped),
  generatedSoftSkipped: new Set(softSkipped),
  generatedSloppy: new Set(sloppy),
};
