/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

"use strict";

const {
  accessibility: {
    SIMULATION_TYPE: {
      DEUTERANOMALY,
      PROTANOMALY,
      TRITANOMALY,
      DEUTERANOPIA,
      PROTANOPIA,
      TRITANOPIA,
      CONTRAST_LOSS,
    },
  },
} = require("devtools/shared/constants");

/**
 * Constants used in accessibility actors.
 */

// Color blindness matrix values taken from https://github.com/eeejay/NoCoffee/blob/master/popup.js#L5-L10
// Contrast loss matrix values are for 50% contrast (see https://docs.rainmeter.net/tips/colormatrix-guide/,
// and https://stackoverflow.com/questions/23865511/contrast-with-color-matrix). The matrices are flattened
// 4x5 matrices, needed for docShell setColorMatrix method. i.e. A 4x5 matrix of the form:
//   1  2  3  4  5
//   6  7  8  9  10
//   11 12 13 14 15
//   16 17 18 19 20
// will be need to be set in docShell as:
//   [1, 6, 11, 16, 2, 7, 12, 17, 3, 8, 13, 18, 4, 9, 14, 19, 5, 10, 15, 20]
const COLOR_TRANSFORMATION_MATRICES = {
  NONE: [1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0],
  [PROTANOMALY]: [
    0.817,
    0.333,
    0,
    0,
    0.183,
    0.667,
    0.125,
    0,
    0,
    0,
    0.875,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
  ],
  [DEUTERANOMALY]: [
    0.8,
    0.258,
    0,
    0,
    0.2,
    0.742,
    0.142,
    0,
    0,
    0,
    0.858,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
  ],
  [TRITANOMALY]: [
    0.967,
    0,
    0,
    0,
    0.033,
    0.733,
    0.183,
    0,
    0,
    0.267,
    0.817,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
  ],
  [PROTANOPIA]: [
    0.567,
    0.558,
    0,
    0,
    0.433,
    0.442,
    0.242,
    0,
    0,
    0,
    0.758,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
  ],
  [DEUTERANOPIA]: [
    0.625,
    0.7,
    0,
    0,
    0.375,
    0.3,
    0.3,
    0,
    0,
    0,
    0.7,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
  ],
  [TRITANOPIA]: [
    0.95,
    0,
    0,
    0,
    0.05,
    0.433,
    0.475,
    0,
    0,
    0.567,
    0.525,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
  ],
  [CONTRAST_LOSS]: [
    0.5,
    0,
    0,
    0,
    0,
    0.5,
    0,
    0,
    0,
    0,
    0.5,
    0,
    0,
    0,
    0,
    0.5,
    0.25,
    0.25,
    0.25,
    0,
  ],
};

exports.simulation = {
  COLOR_TRANSFORMATION_MATRICES,
};
