// This file can be generated from
//   SPIRV-Headers/include/spirv/unified1/spirv.core.grammar.json

#include "spirv/unified1/spirv.hpp"

static constexpr bool OpcodeHasType(uint32_t opcode)
{
    switch (opcode)
    {
        case spv::OpUndef:
        case spv::OpExtInst:
        case spv::OpConstantTrue:
        case spv::OpConstantFalse:
        case spv::OpConstant:
        case spv::OpConstantComposite:
        case spv::OpConstantNull:
        case spv::OpSpecConstantTrue:
        case spv::OpSpecConstantFalse:
        case spv::OpSpecConstant:
        case spv::OpSpecConstantComposite:
        case spv::OpSpecConstantOp:
        case spv::OpFunction:
        case spv::OpFunctionParameter:
        case spv::OpFunctionCall:
        case spv::OpVariable:
        case spv::OpImageTexelPointer:
        case spv::OpLoad:
        case spv::OpAccessChain:
        case spv::OpInBoundsAccessChain:
        case spv::OpPtrAccessChain:
        case spv::OpArrayLength:
        case spv::OpInBoundsPtrAccessChain:
        case spv::OpVectorExtractDynamic:
        case spv::OpVectorInsertDynamic:
        case spv::OpVectorShuffle:
        case spv::OpCompositeConstruct:
        case spv::OpCompositeExtract:
        case spv::OpCompositeInsert:
        case spv::OpCopyObject:
        case spv::OpTranspose:
        case spv::OpSampledImage:
        case spv::OpImageSampleImplicitLod:
        case spv::OpImageSampleExplicitLod:
        case spv::OpImageSampleDrefImplicitLod:
        case spv::OpImageSampleDrefExplicitLod:
        case spv::OpImageSampleProjImplicitLod:
        case spv::OpImageSampleProjExplicitLod:
        case spv::OpImageSampleProjDrefImplicitLod:
        case spv::OpImageSampleProjDrefExplicitLod:
        case spv::OpImageFetch:
        case spv::OpImageGather:
        case spv::OpImageDrefGather:
        case spv::OpImageRead:
        case spv::OpImage:
        case spv::OpImageQuerySizeLod:
        case spv::OpImageQuerySize:
        case spv::OpImageQueryLod:
        case spv::OpImageQueryLevels:
        case spv::OpImageQuerySamples:
        case spv::OpConvertFToU:
        case spv::OpConvertFToS:
        case spv::OpConvertSToF:
        case spv::OpConvertUToF:
        case spv::OpUConvert:
        case spv::OpSConvert:
        case spv::OpFConvert:
        case spv::OpQuantizeToF16:
        case spv::OpConvertPtrToU:
        case spv::OpConvertUToPtr:
        case spv::OpBitcast:
        case spv::OpSNegate:
        case spv::OpFNegate:
        case spv::OpIAdd:
        case spv::OpFAdd:
        case spv::OpISub:
        case spv::OpFSub:
        case spv::OpIMul:
        case spv::OpFMul:
        case spv::OpUDiv:
        case spv::OpSDiv:
        case spv::OpFDiv:
        case spv::OpUMod:
        case spv::OpSRem:
        case spv::OpSMod:
        case spv::OpFRem:
        case spv::OpFMod:
        case spv::OpVectorTimesScalar:
        case spv::OpMatrixTimesScalar:
        case spv::OpVectorTimesMatrix:
        case spv::OpMatrixTimesVector:
        case spv::OpMatrixTimesMatrix:
        case spv::OpOuterProduct:
        case spv::OpDot:
        case spv::OpIAddCarry:
        case spv::OpISubBorrow:
        case spv::OpUMulExtended:
        case spv::OpSMulExtended:
        case spv::OpAny:
        case spv::OpAll:
        case spv::OpIsNan:
        case spv::OpIsInf:
        case spv::OpLogicalEqual:
        case spv::OpLogicalNotEqual:
        case spv::OpLogicalOr:
        case spv::OpLogicalAnd:
        case spv::OpLogicalNot:
        case spv::OpSelect:
        case spv::OpIEqual:
        case spv::OpINotEqual:
        case spv::OpUGreaterThan:
        case spv::OpSGreaterThan:
        case spv::OpUGreaterThanEqual:
        case spv::OpSGreaterThanEqual:
        case spv::OpULessThan:
        case spv::OpSLessThan:
        case spv::OpULessThanEqual:
        case spv::OpSLessThanEqual:
        case spv::OpFOrdEqual:
        case spv::OpFUnordEqual:
        case spv::OpFOrdNotEqual:
        case spv::OpFUnordNotEqual:
        case spv::OpFOrdLessThan:
        case spv::OpFUnordLessThan:
        case spv::OpFOrdGreaterThan:
        case spv::OpFUnordGreaterThan:
        case spv::OpFOrdLessThanEqual:
        case spv::OpFUnordLessThanEqual:
        case spv::OpFOrdGreaterThanEqual:
        case spv::OpFUnordGreaterThanEqual:
        case spv::OpShiftRightLogical:
        case spv::OpShiftRightArithmetic:
        case spv::OpShiftLeftLogical:
        case spv::OpBitwiseOr:
        case spv::OpBitwiseXor:
        case spv::OpBitwiseAnd:
        case spv::OpNot:
        case spv::OpBitFieldInsert:
        case spv::OpBitFieldSExtract:
        case spv::OpBitFieldUExtract:
        case spv::OpBitReverse:
        case spv::OpBitCount:
        case spv::OpDPdx:
        case spv::OpDPdy:
        case spv::OpFwidth:
        case spv::OpDPdxFine:
        case spv::OpDPdyFine:
        case spv::OpFwidthFine:
        case spv::OpDPdxCoarse:
        case spv::OpDPdyCoarse:
        case spv::OpFwidthCoarse:
        case spv::OpAtomicLoad:
        case spv::OpAtomicExchange:
        case spv::OpAtomicCompareExchange:
        case spv::OpAtomicIIncrement:
        case spv::OpAtomicIDecrement:
        case spv::OpAtomicIAdd:
        case spv::OpAtomicISub:
        case spv::OpAtomicSMin:
        case spv::OpAtomicUMin:
        case spv::OpAtomicSMax:
        case spv::OpAtomicUMax:
        case spv::OpAtomicAnd:
        case spv::OpAtomicOr:
        case spv::OpAtomicXor:
        case spv::OpPhi:
        case spv::OpGroupAll:
        case spv::OpGroupAny:
        case spv::OpGroupBroadcast:
        case spv::OpGroupIAdd:
        case spv::OpGroupFAdd:
        case spv::OpGroupFMin:
        case spv::OpGroupUMin:
        case spv::OpGroupSMin:
        case spv::OpGroupFMax:
        case spv::OpGroupUMax:
        case spv::OpGroupSMax:
        case spv::OpImageSparseSampleImplicitLod:
        case spv::OpImageSparseSampleExplicitLod:
        case spv::OpImageSparseSampleDrefImplicitLod:
        case spv::OpImageSparseSampleDrefExplicitLod:
        case spv::OpImageSparseSampleProjImplicitLod:
        case spv::OpImageSparseSampleProjExplicitLod:
        case spv::OpImageSparseSampleProjDrefImplicitLod:
        case spv::OpImageSparseSampleProjDrefExplicitLod:
        case spv::OpImageSparseFetch:
        case spv::OpImageSparseGather:
        case spv::OpImageSparseDrefGather:
        case spv::OpImageSparseTexelsResident:
        case spv::OpImageSparseRead:
        case spv::OpSizeOf:
        case spv::OpGroupNonUniformElect:
        case spv::OpGroupNonUniformAll:
        case spv::OpGroupNonUniformAny:
        case spv::OpGroupNonUniformAllEqual:
        case spv::OpGroupNonUniformBroadcast:
        case spv::OpGroupNonUniformBroadcastFirst:
        case spv::OpGroupNonUniformBallot:
        case spv::OpGroupNonUniformInverseBallot:
        case spv::OpGroupNonUniformBallotBitExtract:
        case spv::OpGroupNonUniformBallotBitCount:
        case spv::OpGroupNonUniformBallotFindLSB:
        case spv::OpGroupNonUniformBallotFindMSB:
        case spv::OpGroupNonUniformShuffle:
        case spv::OpGroupNonUniformShuffleXor:
        case spv::OpGroupNonUniformShuffleUp:
        case spv::OpGroupNonUniformShuffleDown:
        case spv::OpGroupNonUniformIAdd:
        case spv::OpGroupNonUniformFAdd:
        case spv::OpGroupNonUniformIMul:
        case spv::OpGroupNonUniformFMul:
        case spv::OpGroupNonUniformSMin:
        case spv::OpGroupNonUniformUMin:
        case spv::OpGroupNonUniformFMin:
        case spv::OpGroupNonUniformSMax:
        case spv::OpGroupNonUniformUMax:
        case spv::OpGroupNonUniformFMax:
        case spv::OpGroupNonUniformBitwiseAnd:
        case spv::OpGroupNonUniformBitwiseOr:
        case spv::OpGroupNonUniformBitwiseXor:
        case spv::OpGroupNonUniformLogicalAnd:
        case spv::OpGroupNonUniformLogicalOr:
        case spv::OpGroupNonUniformLogicalXor:
        case spv::OpGroupNonUniformQuadBroadcast:
        case spv::OpGroupNonUniformQuadSwap:
        case spv::OpCopyLogical:
        case spv::OpPtrEqual:
        case spv::OpPtrNotEqual:
        case spv::OpPtrDiff:
        case spv::OpColorAttachmentReadEXT:
        case spv::OpDepthAttachmentReadEXT:
        case spv::OpStencilAttachmentReadEXT:
        case spv::OpSubgroupBallotKHR:
        case spv::OpSubgroupFirstInvocationKHR:
        case spv::OpSubgroupAllKHR:
        case spv::OpSubgroupAnyKHR:
        case spv::OpSubgroupAllEqualKHR:
        case spv::OpGroupNonUniformRotateKHR:
        case spv::OpSubgroupReadInvocationKHR:
        case spv::OpConvertUToAccelerationStructureKHR:
        case spv::OpSDot:
        case spv::OpUDot:
        case spv::OpSUDot:
        case spv::OpSDotAccSat:
        case spv::OpUDotAccSat:
        case spv::OpSUDotAccSat:
        case spv::OpCooperativeMatrixLoadKHR:
        case spv::OpCooperativeMatrixMulAddKHR:
        case spv::OpCooperativeMatrixLengthKHR:
        case spv::OpRayQueryProceedKHR:
        case spv::OpRayQueryGetIntersectionTypeKHR:
        case spv::OpImageSampleWeightedQCOM:
        case spv::OpImageBoxFilterQCOM:
        case spv::OpImageBlockMatchSSDQCOM:
        case spv::OpImageBlockMatchSADQCOM:
        case spv::OpImageBlockMatchWindowSSDQCOM:
        case spv::OpImageBlockMatchWindowSADQCOM:
        case spv::OpImageBlockMatchGatherSSDQCOM:
        case spv::OpImageBlockMatchGatherSADQCOM:
        case spv::OpGroupIAddNonUniformAMD:
        case spv::OpGroupFAddNonUniformAMD:
        case spv::OpGroupFMinNonUniformAMD:
        case spv::OpGroupUMinNonUniformAMD:
        case spv::OpGroupSMinNonUniformAMD:
        case spv::OpGroupFMaxNonUniformAMD:
        case spv::OpGroupUMaxNonUniformAMD:
        case spv::OpGroupSMaxNonUniformAMD:
        case spv::OpFragmentMaskFetchAMD:
        case spv::OpFragmentFetchAMD:
        case spv::OpReadClockKHR:
        case spv::OpFinishWritingNodePayloadAMDX:
        case spv::OpGroupNonUniformQuadAllKHR:
        case spv::OpGroupNonUniformQuadAnyKHR:
        case spv::OpHitObjectGetWorldToObjectNV:
        case spv::OpHitObjectGetObjectToWorldNV:
        case spv::OpHitObjectGetObjectRayDirectionNV:
        case spv::OpHitObjectGetObjectRayOriginNV:
        case spv::OpHitObjectGetShaderRecordBufferHandleNV:
        case spv::OpHitObjectGetShaderBindingTableRecordIndexNV:
        case spv::OpHitObjectGetCurrentTimeNV:
        case spv::OpHitObjectGetHitKindNV:
        case spv::OpHitObjectGetPrimitiveIndexNV:
        case spv::OpHitObjectGetGeometryIndexNV:
        case spv::OpHitObjectGetInstanceIdNV:
        case spv::OpHitObjectGetInstanceCustomIndexNV:
        case spv::OpHitObjectGetWorldRayDirectionNV:
        case spv::OpHitObjectGetWorldRayOriginNV:
        case spv::OpHitObjectGetRayTMaxNV:
        case spv::OpHitObjectGetRayTMinNV:
        case spv::OpHitObjectIsEmptyNV:
        case spv::OpHitObjectIsHitNV:
        case spv::OpHitObjectIsMissNV:
        case spv::OpImageSampleFootprintNV:
        case spv::OpGroupNonUniformPartitionNV:
        case spv::OpFetchMicroTriangleVertexPositionNV:
        case spv::OpFetchMicroTriangleVertexBarycentricNV:
        case spv::OpReportIntersectionNV:
        case spv::OpRayQueryGetIntersectionTriangleVertexPositionsKHR:
        case spv::OpCooperativeMatrixLoadNV:
        case spv::OpCooperativeMatrixMulAddNV:
        case spv::OpCooperativeMatrixLengthNV:
        case spv::OpIsHelperInvocationEXT:
        case spv::OpConvertUToImageNV:
        case spv::OpConvertUToSamplerNV:
        case spv::OpConvertImageToUNV:
        case spv::OpConvertSamplerToUNV:
        case spv::OpConvertUToSampledImageNV:
        case spv::OpConvertSampledImageToUNV:
        case spv::OpRawAccessChainNV:
        case spv::OpUCountLeadingZerosINTEL:
        case spv::OpUCountTrailingZerosINTEL:
        case spv::OpAbsISubINTEL:
        case spv::OpAbsUSubINTEL:
        case spv::OpIAddSatINTEL:
        case spv::OpUAddSatINTEL:
        case spv::OpIAverageINTEL:
        case spv::OpUAverageINTEL:
        case spv::OpIAverageRoundedINTEL:
        case spv::OpUAverageRoundedINTEL:
        case spv::OpISubSatINTEL:
        case spv::OpUSubSatINTEL:
        case spv::OpIMul32x16INTEL:
        case spv::OpUMul32x16INTEL:
        case spv::OpConstantFunctionPointerINTEL:
        case spv::OpFunctionPointerCallINTEL:
        case spv::OpAtomicFMinEXT:
        case spv::OpAtomicFMaxEXT:
        case spv::OpExpectKHR:
        case spv::OpRayQueryGetRayTMinKHR:
        case spv::OpRayQueryGetRayFlagsKHR:
        case spv::OpRayQueryGetIntersectionTKHR:
        case spv::OpRayQueryGetIntersectionInstanceCustomIndexKHR:
        case spv::OpRayQueryGetIntersectionInstanceIdKHR:
        case spv::OpRayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR:
        case spv::OpRayQueryGetIntersectionGeometryIndexKHR:
        case spv::OpRayQueryGetIntersectionPrimitiveIndexKHR:
        case spv::OpRayQueryGetIntersectionBarycentricsKHR:
        case spv::OpRayQueryGetIntersectionFrontFaceKHR:
        case spv::OpRayQueryGetIntersectionCandidateAABBOpaqueKHR:
        case spv::OpRayQueryGetIntersectionObjectRayDirectionKHR:
        case spv::OpRayQueryGetIntersectionObjectRayOriginKHR:
        case spv::OpRayQueryGetWorldRayDirectionKHR:
        case spv::OpRayQueryGetWorldRayOriginKHR:
        case spv::OpRayQueryGetIntersectionObjectToWorldKHR:
        case spv::OpRayQueryGetIntersectionWorldToObjectKHR:
        case spv::OpAtomicFAddEXT:
        case spv::OpGroupIMulKHR:
        case spv::OpGroupFMulKHR:
        case spv::OpGroupBitwiseAndKHR:
        case spv::OpGroupBitwiseOrKHR:
        case spv::OpGroupBitwiseXorKHR:
        case spv::OpGroupLogicalAndKHR:
        case spv::OpGroupLogicalOrKHR:
        case spv::OpGroupLogicalXorKHR:
            return true;
        default:
            return false;
    }
}

static constexpr bool OpcodeHasResult(uint32_t opcode)
{
    switch (opcode)
    {
        case spv::OpUndef:
        case spv::OpString:
        case spv::OpExtInstImport:
        case spv::OpExtInst:
        case spv::OpTypeVoid:
        case spv::OpTypeBool:
        case spv::OpTypeInt:
        case spv::OpTypeFloat:
        case spv::OpTypeVector:
        case spv::OpTypeMatrix:
        case spv::OpTypeImage:
        case spv::OpTypeSampler:
        case spv::OpTypeSampledImage:
        case spv::OpTypeArray:
        case spv::OpTypeRuntimeArray:
        case spv::OpTypeStruct:
        case spv::OpTypePointer:
        case spv::OpTypeFunction:
        case spv::OpConstantTrue:
        case spv::OpConstantFalse:
        case spv::OpConstant:
        case spv::OpConstantComposite:
        case spv::OpConstantNull:
        case spv::OpSpecConstantTrue:
        case spv::OpSpecConstantFalse:
        case spv::OpSpecConstant:
        case spv::OpSpecConstantComposite:
        case spv::OpSpecConstantOp:
        case spv::OpFunction:
        case spv::OpFunctionParameter:
        case spv::OpFunctionCall:
        case spv::OpVariable:
        case spv::OpImageTexelPointer:
        case spv::OpLoad:
        case spv::OpAccessChain:
        case spv::OpInBoundsAccessChain:
        case spv::OpPtrAccessChain:
        case spv::OpArrayLength:
        case spv::OpInBoundsPtrAccessChain:
        case spv::OpDecorationGroup:
        case spv::OpVectorExtractDynamic:
        case spv::OpVectorInsertDynamic:
        case spv::OpVectorShuffle:
        case spv::OpCompositeConstruct:
        case spv::OpCompositeExtract:
        case spv::OpCompositeInsert:
        case spv::OpCopyObject:
        case spv::OpTranspose:
        case spv::OpSampledImage:
        case spv::OpImageSampleImplicitLod:
        case spv::OpImageSampleExplicitLod:
        case spv::OpImageSampleDrefImplicitLod:
        case spv::OpImageSampleDrefExplicitLod:
        case spv::OpImageSampleProjImplicitLod:
        case spv::OpImageSampleProjExplicitLod:
        case spv::OpImageSampleProjDrefImplicitLod:
        case spv::OpImageSampleProjDrefExplicitLod:
        case spv::OpImageFetch:
        case spv::OpImageGather:
        case spv::OpImageDrefGather:
        case spv::OpImageRead:
        case spv::OpImage:
        case spv::OpImageQuerySizeLod:
        case spv::OpImageQuerySize:
        case spv::OpImageQueryLod:
        case spv::OpImageQueryLevels:
        case spv::OpImageQuerySamples:
        case spv::OpConvertFToU:
        case spv::OpConvertFToS:
        case spv::OpConvertSToF:
        case spv::OpConvertUToF:
        case spv::OpUConvert:
        case spv::OpSConvert:
        case spv::OpFConvert:
        case spv::OpQuantizeToF16:
        case spv::OpConvertPtrToU:
        case spv::OpConvertUToPtr:
        case spv::OpBitcast:
        case spv::OpSNegate:
        case spv::OpFNegate:
        case spv::OpIAdd:
        case spv::OpFAdd:
        case spv::OpISub:
        case spv::OpFSub:
        case spv::OpIMul:
        case spv::OpFMul:
        case spv::OpUDiv:
        case spv::OpSDiv:
        case spv::OpFDiv:
        case spv::OpUMod:
        case spv::OpSRem:
        case spv::OpSMod:
        case spv::OpFRem:
        case spv::OpFMod:
        case spv::OpVectorTimesScalar:
        case spv::OpMatrixTimesScalar:
        case spv::OpVectorTimesMatrix:
        case spv::OpMatrixTimesVector:
        case spv::OpMatrixTimesMatrix:
        case spv::OpOuterProduct:
        case spv::OpDot:
        case spv::OpIAddCarry:
        case spv::OpISubBorrow:
        case spv::OpUMulExtended:
        case spv::OpSMulExtended:
        case spv::OpAny:
        case spv::OpAll:
        case spv::OpIsNan:
        case spv::OpIsInf:
        case spv::OpLogicalEqual:
        case spv::OpLogicalNotEqual:
        case spv::OpLogicalOr:
        case spv::OpLogicalAnd:
        case spv::OpLogicalNot:
        case spv::OpSelect:
        case spv::OpIEqual:
        case spv::OpINotEqual:
        case spv::OpUGreaterThan:
        case spv::OpSGreaterThan:
        case spv::OpUGreaterThanEqual:
        case spv::OpSGreaterThanEqual:
        case spv::OpULessThan:
        case spv::OpSLessThan:
        case spv::OpULessThanEqual:
        case spv::OpSLessThanEqual:
        case spv::OpFOrdEqual:
        case spv::OpFUnordEqual:
        case spv::OpFOrdNotEqual:
        case spv::OpFUnordNotEqual:
        case spv::OpFOrdLessThan:
        case spv::OpFUnordLessThan:
        case spv::OpFOrdGreaterThan:
        case spv::OpFUnordGreaterThan:
        case spv::OpFOrdLessThanEqual:
        case spv::OpFUnordLessThanEqual:
        case spv::OpFOrdGreaterThanEqual:
        case spv::OpFUnordGreaterThanEqual:
        case spv::OpShiftRightLogical:
        case spv::OpShiftRightArithmetic:
        case spv::OpShiftLeftLogical:
        case spv::OpBitwiseOr:
        case spv::OpBitwiseXor:
        case spv::OpBitwiseAnd:
        case spv::OpNot:
        case spv::OpBitFieldInsert:
        case spv::OpBitFieldSExtract:
        case spv::OpBitFieldUExtract:
        case spv::OpBitReverse:
        case spv::OpBitCount:
        case spv::OpDPdx:
        case spv::OpDPdy:
        case spv::OpFwidth:
        case spv::OpDPdxFine:
        case spv::OpDPdyFine:
        case spv::OpFwidthFine:
        case spv::OpDPdxCoarse:
        case spv::OpDPdyCoarse:
        case spv::OpFwidthCoarse:
        case spv::OpAtomicLoad:
        case spv::OpAtomicExchange:
        case spv::OpAtomicCompareExchange:
        case spv::OpAtomicIIncrement:
        case spv::OpAtomicIDecrement:
        case spv::OpAtomicIAdd:
        case spv::OpAtomicISub:
        case spv::OpAtomicSMin:
        case spv::OpAtomicUMin:
        case spv::OpAtomicSMax:
        case spv::OpAtomicUMax:
        case spv::OpAtomicAnd:
        case spv::OpAtomicOr:
        case spv::OpAtomicXor:
        case spv::OpPhi:
        case spv::OpLabel:
        case spv::OpGroupAll:
        case spv::OpGroupAny:
        case spv::OpGroupBroadcast:
        case spv::OpGroupIAdd:
        case spv::OpGroupFAdd:
        case spv::OpGroupFMin:
        case spv::OpGroupUMin:
        case spv::OpGroupSMin:
        case spv::OpGroupFMax:
        case spv::OpGroupUMax:
        case spv::OpGroupSMax:
        case spv::OpImageSparseSampleImplicitLod:
        case spv::OpImageSparseSampleExplicitLod:
        case spv::OpImageSparseSampleDrefImplicitLod:
        case spv::OpImageSparseSampleDrefExplicitLod:
        case spv::OpImageSparseSampleProjImplicitLod:
        case spv::OpImageSparseSampleProjExplicitLod:
        case spv::OpImageSparseSampleProjDrefImplicitLod:
        case spv::OpImageSparseSampleProjDrefExplicitLod:
        case spv::OpImageSparseFetch:
        case spv::OpImageSparseGather:
        case spv::OpImageSparseDrefGather:
        case spv::OpImageSparseTexelsResident:
        case spv::OpImageSparseRead:
        case spv::OpSizeOf:
        case spv::OpGroupNonUniformElect:
        case spv::OpGroupNonUniformAll:
        case spv::OpGroupNonUniformAny:
        case spv::OpGroupNonUniformAllEqual:
        case spv::OpGroupNonUniformBroadcast:
        case spv::OpGroupNonUniformBroadcastFirst:
        case spv::OpGroupNonUniformBallot:
        case spv::OpGroupNonUniformInverseBallot:
        case spv::OpGroupNonUniformBallotBitExtract:
        case spv::OpGroupNonUniformBallotBitCount:
        case spv::OpGroupNonUniformBallotFindLSB:
        case spv::OpGroupNonUniformBallotFindMSB:
        case spv::OpGroupNonUniformShuffle:
        case spv::OpGroupNonUniformShuffleXor:
        case spv::OpGroupNonUniformShuffleUp:
        case spv::OpGroupNonUniformShuffleDown:
        case spv::OpGroupNonUniformIAdd:
        case spv::OpGroupNonUniformFAdd:
        case spv::OpGroupNonUniformIMul:
        case spv::OpGroupNonUniformFMul:
        case spv::OpGroupNonUniformSMin:
        case spv::OpGroupNonUniformUMin:
        case spv::OpGroupNonUniformFMin:
        case spv::OpGroupNonUniformSMax:
        case spv::OpGroupNonUniformUMax:
        case spv::OpGroupNonUniformFMax:
        case spv::OpGroupNonUniformBitwiseAnd:
        case spv::OpGroupNonUniformBitwiseOr:
        case spv::OpGroupNonUniformBitwiseXor:
        case spv::OpGroupNonUniformLogicalAnd:
        case spv::OpGroupNonUniformLogicalOr:
        case spv::OpGroupNonUniformLogicalXor:
        case spv::OpGroupNonUniformQuadBroadcast:
        case spv::OpGroupNonUniformQuadSwap:
        case spv::OpCopyLogical:
        case spv::OpPtrEqual:
        case spv::OpPtrNotEqual:
        case spv::OpPtrDiff:
        case spv::OpColorAttachmentReadEXT:
        case spv::OpDepthAttachmentReadEXT:
        case spv::OpStencilAttachmentReadEXT:
        case spv::OpSubgroupBallotKHR:
        case spv::OpSubgroupFirstInvocationKHR:
        case spv::OpSubgroupAllKHR:
        case spv::OpSubgroupAnyKHR:
        case spv::OpSubgroupAllEqualKHR:
        case spv::OpGroupNonUniformRotateKHR:
        case spv::OpSubgroupReadInvocationKHR:
        case spv::OpConvertUToAccelerationStructureKHR:
        case spv::OpSDot:
        case spv::OpUDot:
        case spv::OpSUDot:
        case spv::OpSDotAccSat:
        case spv::OpUDotAccSat:
        case spv::OpSUDotAccSat:
        case spv::OpTypeCooperativeMatrixKHR:
        case spv::OpCooperativeMatrixLoadKHR:
        case spv::OpCooperativeMatrixMulAddKHR:
        case spv::OpCooperativeMatrixLengthKHR:
        case spv::OpTypeRayQueryKHR:
        case spv::OpRayQueryProceedKHR:
        case spv::OpRayQueryGetIntersectionTypeKHR:
        case spv::OpImageSampleWeightedQCOM:
        case spv::OpImageBoxFilterQCOM:
        case spv::OpImageBlockMatchSSDQCOM:
        case spv::OpImageBlockMatchSADQCOM:
        case spv::OpImageBlockMatchWindowSSDQCOM:
        case spv::OpImageBlockMatchWindowSADQCOM:
        case spv::OpImageBlockMatchGatherSSDQCOM:
        case spv::OpImageBlockMatchGatherSADQCOM:
        case spv::OpGroupIAddNonUniformAMD:
        case spv::OpGroupFAddNonUniformAMD:
        case spv::OpGroupFMinNonUniformAMD:
        case spv::OpGroupUMinNonUniformAMD:
        case spv::OpGroupSMinNonUniformAMD:
        case spv::OpGroupFMaxNonUniformAMD:
        case spv::OpGroupUMaxNonUniformAMD:
        case spv::OpGroupSMaxNonUniformAMD:
        case spv::OpFragmentMaskFetchAMD:
        case spv::OpFragmentFetchAMD:
        case spv::OpReadClockKHR:
        case spv::OpFinishWritingNodePayloadAMDX:
        case spv::OpGroupNonUniformQuadAllKHR:
        case spv::OpGroupNonUniformQuadAnyKHR:
        case spv::OpHitObjectGetWorldToObjectNV:
        case spv::OpHitObjectGetObjectToWorldNV:
        case spv::OpHitObjectGetObjectRayDirectionNV:
        case spv::OpHitObjectGetObjectRayOriginNV:
        case spv::OpHitObjectGetShaderRecordBufferHandleNV:
        case spv::OpHitObjectGetShaderBindingTableRecordIndexNV:
        case spv::OpHitObjectGetCurrentTimeNV:
        case spv::OpHitObjectGetHitKindNV:
        case spv::OpHitObjectGetPrimitiveIndexNV:
        case spv::OpHitObjectGetGeometryIndexNV:
        case spv::OpHitObjectGetInstanceIdNV:
        case spv::OpHitObjectGetInstanceCustomIndexNV:
        case spv::OpHitObjectGetWorldRayDirectionNV:
        case spv::OpHitObjectGetWorldRayOriginNV:
        case spv::OpHitObjectGetRayTMaxNV:
        case spv::OpHitObjectGetRayTMinNV:
        case spv::OpHitObjectIsEmptyNV:
        case spv::OpHitObjectIsHitNV:
        case spv::OpHitObjectIsMissNV:
        case spv::OpTypeHitObjectNV:
        case spv::OpImageSampleFootprintNV:
        case spv::OpGroupNonUniformPartitionNV:
        case spv::OpFetchMicroTriangleVertexPositionNV:
        case spv::OpFetchMicroTriangleVertexBarycentricNV:
        case spv::OpReportIntersectionNV:
        case spv::OpRayQueryGetIntersectionTriangleVertexPositionsKHR:
        case spv::OpTypeAccelerationStructureKHR:
        case spv::OpTypeCooperativeMatrixNV:
        case spv::OpCooperativeMatrixLoadNV:
        case spv::OpCooperativeMatrixMulAddNV:
        case spv::OpCooperativeMatrixLengthNV:
        case spv::OpIsHelperInvocationEXT:
        case spv::OpConvertUToImageNV:
        case spv::OpConvertUToSamplerNV:
        case spv::OpConvertImageToUNV:
        case spv::OpConvertSamplerToUNV:
        case spv::OpConvertUToSampledImageNV:
        case spv::OpConvertSampledImageToUNV:
        case spv::OpRawAccessChainNV:
        case spv::OpUCountLeadingZerosINTEL:
        case spv::OpUCountTrailingZerosINTEL:
        case spv::OpAbsISubINTEL:
        case spv::OpAbsUSubINTEL:
        case spv::OpIAddSatINTEL:
        case spv::OpUAddSatINTEL:
        case spv::OpIAverageINTEL:
        case spv::OpUAverageINTEL:
        case spv::OpIAverageRoundedINTEL:
        case spv::OpUAverageRoundedINTEL:
        case spv::OpISubSatINTEL:
        case spv::OpUSubSatINTEL:
        case spv::OpIMul32x16INTEL:
        case spv::OpUMul32x16INTEL:
        case spv::OpConstantFunctionPointerINTEL:
        case spv::OpFunctionPointerCallINTEL:
        case spv::OpAtomicFMinEXT:
        case spv::OpAtomicFMaxEXT:
        case spv::OpExpectKHR:
        case spv::OpRayQueryGetRayTMinKHR:
        case spv::OpRayQueryGetRayFlagsKHR:
        case spv::OpRayQueryGetIntersectionTKHR:
        case spv::OpRayQueryGetIntersectionInstanceCustomIndexKHR:
        case spv::OpRayQueryGetIntersectionInstanceIdKHR:
        case spv::OpRayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR:
        case spv::OpRayQueryGetIntersectionGeometryIndexKHR:
        case spv::OpRayQueryGetIntersectionPrimitiveIndexKHR:
        case spv::OpRayQueryGetIntersectionBarycentricsKHR:
        case spv::OpRayQueryGetIntersectionFrontFaceKHR:
        case spv::OpRayQueryGetIntersectionCandidateAABBOpaqueKHR:
        case spv::OpRayQueryGetIntersectionObjectRayDirectionKHR:
        case spv::OpRayQueryGetIntersectionObjectRayOriginKHR:
        case spv::OpRayQueryGetWorldRayDirectionKHR:
        case spv::OpRayQueryGetWorldRayOriginKHR:
        case spv::OpRayQueryGetIntersectionObjectToWorldKHR:
        case spv::OpRayQueryGetIntersectionWorldToObjectKHR:
        case spv::OpAtomicFAddEXT:
        case spv::OpGroupIMulKHR:
        case spv::OpGroupFMulKHR:
        case spv::OpGroupBitwiseAndKHR:
        case spv::OpGroupBitwiseOrKHR:
        case spv::OpGroupBitwiseXorKHR:
        case spv::OpGroupLogicalAndKHR:
        case spv::OpGroupLogicalOrKHR:
        case spv::OpGroupLogicalXorKHR:
            return true;
        default:
            return false;
    }
}

const char* string_SpvOpcode(uint32_t opcode)
{
    switch (opcode)
    {
        case spv::OpNop:
            return "OpNop";
        case spv::OpUndef:
            return "OpUndef";
        case spv::OpSourceContinued:
            return "OpSourceContinued";
        case spv::OpSource:
            return "OpSource";
        case spv::OpSourceExtension:
            return "OpSourceExtension";
        case spv::OpName:
            return "OpName";
        case spv::OpMemberName:
            return "OpMemberName";
        case spv::OpString:
            return "OpString";
        case spv::OpLine:
            return "OpLine";
        case spv::OpExtension:
            return "OpExtension";
        case spv::OpExtInstImport:
            return "OpExtInstImport";
        case spv::OpExtInst:
            return "OpExtInst";
        case spv::OpMemoryModel:
            return "OpMemoryModel";
        case spv::OpEntryPoint:
            return "OpEntryPoint";
        case spv::OpExecutionMode:
            return "OpExecutionMode";
        case spv::OpCapability:
            return "OpCapability";
        case spv::OpTypeVoid:
            return "OpTypeVoid";
        case spv::OpTypeBool:
            return "OpTypeBool";
        case spv::OpTypeInt:
            return "OpTypeInt";
        case spv::OpTypeFloat:
            return "OpTypeFloat";
        case spv::OpTypeVector:
            return "OpTypeVector";
        case spv::OpTypeMatrix:
            return "OpTypeMatrix";
        case spv::OpTypeImage:
            return "OpTypeImage";
        case spv::OpTypeSampler:
            return "OpTypeSampler";
        case spv::OpTypeSampledImage:
            return "OpTypeSampledImage";
        case spv::OpTypeArray:
            return "OpTypeArray";
        case spv::OpTypeRuntimeArray:
            return "OpTypeRuntimeArray";
        case spv::OpTypeStruct:
            return "OpTypeStruct";
        case spv::OpTypePointer:
            return "OpTypePointer";
        case spv::OpTypeFunction:
            return "OpTypeFunction";
        case spv::OpTypeForwardPointer:
            return "OpTypeForwardPointer";
        case spv::OpConstantTrue:
            return "OpConstantTrue";
        case spv::OpConstantFalse:
            return "OpConstantFalse";
        case spv::OpConstant:
            return "OpConstant";
        case spv::OpConstantComposite:
            return "OpConstantComposite";
        case spv::OpConstantNull:
            return "OpConstantNull";
        case spv::OpSpecConstantTrue:
            return "OpSpecConstantTrue";
        case spv::OpSpecConstantFalse:
            return "OpSpecConstantFalse";
        case spv::OpSpecConstant:
            return "OpSpecConstant";
        case spv::OpSpecConstantComposite:
            return "OpSpecConstantComposite";
        case spv::OpSpecConstantOp:
            return "OpSpecConstantOp";
        case spv::OpFunction:
            return "OpFunction";
        case spv::OpFunctionParameter:
            return "OpFunctionParameter";
        case spv::OpFunctionEnd:
            return "OpFunctionEnd";
        case spv::OpFunctionCall:
            return "OpFunctionCall";
        case spv::OpVariable:
            return "OpVariable";
        case spv::OpImageTexelPointer:
            return "OpImageTexelPointer";
        case spv::OpLoad:
            return "OpLoad";
        case spv::OpStore:
            return "OpStore";
        case spv::OpCopyMemory:
            return "OpCopyMemory";
        case spv::OpCopyMemorySized:
            return "OpCopyMemorySized";
        case spv::OpAccessChain:
            return "OpAccessChain";
        case spv::OpInBoundsAccessChain:
            return "OpInBoundsAccessChain";
        case spv::OpPtrAccessChain:
            return "OpPtrAccessChain";
        case spv::OpArrayLength:
            return "OpArrayLength";
        case spv::OpInBoundsPtrAccessChain:
            return "OpInBoundsPtrAccessChain";
        case spv::OpDecorate:
            return "OpDecorate";
        case spv::OpMemberDecorate:
            return "OpMemberDecorate";
        case spv::OpDecorationGroup:
            return "OpDecorationGroup";
        case spv::OpGroupDecorate:
            return "OpGroupDecorate";
        case spv::OpGroupMemberDecorate:
            return "OpGroupMemberDecorate";
        case spv::OpVectorExtractDynamic:
            return "OpVectorExtractDynamic";
        case spv::OpVectorInsertDynamic:
            return "OpVectorInsertDynamic";
        case spv::OpVectorShuffle:
            return "OpVectorShuffle";
        case spv::OpCompositeConstruct:
            return "OpCompositeConstruct";
        case spv::OpCompositeExtract:
            return "OpCompositeExtract";
        case spv::OpCompositeInsert:
            return "OpCompositeInsert";
        case spv::OpCopyObject:
            return "OpCopyObject";
        case spv::OpTranspose:
            return "OpTranspose";
        case spv::OpSampledImage:
            return "OpSampledImage";
        case spv::OpImageSampleImplicitLod:
            return "OpImageSampleImplicitLod";
        case spv::OpImageSampleExplicitLod:
            return "OpImageSampleExplicitLod";
        case spv::OpImageSampleDrefImplicitLod:
            return "OpImageSampleDrefImplicitLod";
        case spv::OpImageSampleDrefExplicitLod:
            return "OpImageSampleDrefExplicitLod";
        case spv::OpImageSampleProjImplicitLod:
            return "OpImageSampleProjImplicitLod";
        case spv::OpImageSampleProjExplicitLod:
            return "OpImageSampleProjExplicitLod";
        case spv::OpImageSampleProjDrefImplicitLod:
            return "OpImageSampleProjDrefImplicitLod";
        case spv::OpImageSampleProjDrefExplicitLod:
            return "OpImageSampleProjDrefExplicitLod";
        case spv::OpImageFetch:
            return "OpImageFetch";
        case spv::OpImageGather:
            return "OpImageGather";
        case spv::OpImageDrefGather:
            return "OpImageDrefGather";
        case spv::OpImageRead:
            return "OpImageRead";
        case spv::OpImageWrite:
            return "OpImageWrite";
        case spv::OpImage:
            return "OpImage";
        case spv::OpImageQuerySizeLod:
            return "OpImageQuerySizeLod";
        case spv::OpImageQuerySize:
            return "OpImageQuerySize";
        case spv::OpImageQueryLod:
            return "OpImageQueryLod";
        case spv::OpImageQueryLevels:
            return "OpImageQueryLevels";
        case spv::OpImageQuerySamples:
            return "OpImageQuerySamples";
        case spv::OpConvertFToU:
            return "OpConvertFToU";
        case spv::OpConvertFToS:
            return "OpConvertFToS";
        case spv::OpConvertSToF:
            return "OpConvertSToF";
        case spv::OpConvertUToF:
            return "OpConvertUToF";
        case spv::OpUConvert:
            return "OpUConvert";
        case spv::OpSConvert:
            return "OpSConvert";
        case spv::OpFConvert:
            return "OpFConvert";
        case spv::OpQuantizeToF16:
            return "OpQuantizeToF16";
        case spv::OpConvertPtrToU:
            return "OpConvertPtrToU";
        case spv::OpConvertUToPtr:
            return "OpConvertUToPtr";
        case spv::OpBitcast:
            return "OpBitcast";
        case spv::OpSNegate:
            return "OpSNegate";
        case spv::OpFNegate:
            return "OpFNegate";
        case spv::OpIAdd:
            return "OpIAdd";
        case spv::OpFAdd:
            return "OpFAdd";
        case spv::OpISub:
            return "OpISub";
        case spv::OpFSub:
            return "OpFSub";
        case spv::OpIMul:
            return "OpIMul";
        case spv::OpFMul:
            return "OpFMul";
        case spv::OpUDiv:
            return "OpUDiv";
        case spv::OpSDiv:
            return "OpSDiv";
        case spv::OpFDiv:
            return "OpFDiv";
        case spv::OpUMod:
            return "OpUMod";
        case spv::OpSRem:
            return "OpSRem";
        case spv::OpSMod:
            return "OpSMod";
        case spv::OpFRem:
            return "OpFRem";
        case spv::OpFMod:
            return "OpFMod";
        case spv::OpVectorTimesScalar:
            return "OpVectorTimesScalar";
        case spv::OpMatrixTimesScalar:
            return "OpMatrixTimesScalar";
        case spv::OpVectorTimesMatrix:
            return "OpVectorTimesMatrix";
        case spv::OpMatrixTimesVector:
            return "OpMatrixTimesVector";
        case spv::OpMatrixTimesMatrix:
            return "OpMatrixTimesMatrix";
        case spv::OpOuterProduct:
            return "OpOuterProduct";
        case spv::OpDot:
            return "OpDot";
        case spv::OpIAddCarry:
            return "OpIAddCarry";
        case spv::OpISubBorrow:
            return "OpISubBorrow";
        case spv::OpUMulExtended:
            return "OpUMulExtended";
        case spv::OpSMulExtended:
            return "OpSMulExtended";
        case spv::OpAny:
            return "OpAny";
        case spv::OpAll:
            return "OpAll";
        case spv::OpIsNan:
            return "OpIsNan";
        case spv::OpIsInf:
            return "OpIsInf";
        case spv::OpLogicalEqual:
            return "OpLogicalEqual";
        case spv::OpLogicalNotEqual:
            return "OpLogicalNotEqual";
        case spv::OpLogicalOr:
            return "OpLogicalOr";
        case spv::OpLogicalAnd:
            return "OpLogicalAnd";
        case spv::OpLogicalNot:
            return "OpLogicalNot";
        case spv::OpSelect:
            return "OpSelect";
        case spv::OpIEqual:
            return "OpIEqual";
        case spv::OpINotEqual:
            return "OpINotEqual";
        case spv::OpUGreaterThan:
            return "OpUGreaterThan";
        case spv::OpSGreaterThan:
            return "OpSGreaterThan";
        case spv::OpUGreaterThanEqual:
            return "OpUGreaterThanEqual";
        case spv::OpSGreaterThanEqual:
            return "OpSGreaterThanEqual";
        case spv::OpULessThan:
            return "OpULessThan";
        case spv::OpSLessThan:
            return "OpSLessThan";
        case spv::OpULessThanEqual:
            return "OpULessThanEqual";
        case spv::OpSLessThanEqual:
            return "OpSLessThanEqual";
        case spv::OpFOrdEqual:
            return "OpFOrdEqual";
        case spv::OpFUnordEqual:
            return "OpFUnordEqual";
        case spv::OpFOrdNotEqual:
            return "OpFOrdNotEqual";
        case spv::OpFUnordNotEqual:
            return "OpFUnordNotEqual";
        case spv::OpFOrdLessThan:
            return "OpFOrdLessThan";
        case spv::OpFUnordLessThan:
            return "OpFUnordLessThan";
        case spv::OpFOrdGreaterThan:
            return "OpFOrdGreaterThan";
        case spv::OpFUnordGreaterThan:
            return "OpFUnordGreaterThan";
        case spv::OpFOrdLessThanEqual:
            return "OpFOrdLessThanEqual";
        case spv::OpFUnordLessThanEqual:
            return "OpFUnordLessThanEqual";
        case spv::OpFOrdGreaterThanEqual:
            return "OpFOrdGreaterThanEqual";
        case spv::OpFUnordGreaterThanEqual:
            return "OpFUnordGreaterThanEqual";
        case spv::OpShiftRightLogical:
            return "OpShiftRightLogical";
        case spv::OpShiftRightArithmetic:
            return "OpShiftRightArithmetic";
        case spv::OpShiftLeftLogical:
            return "OpShiftLeftLogical";
        case spv::OpBitwiseOr:
            return "OpBitwiseOr";
        case spv::OpBitwiseXor:
            return "OpBitwiseXor";
        case spv::OpBitwiseAnd:
            return "OpBitwiseAnd";
        case spv::OpNot:
            return "OpNot";
        case spv::OpBitFieldInsert:
            return "OpBitFieldInsert";
        case spv::OpBitFieldSExtract:
            return "OpBitFieldSExtract";
        case spv::OpBitFieldUExtract:
            return "OpBitFieldUExtract";
        case spv::OpBitReverse:
            return "OpBitReverse";
        case spv::OpBitCount:
            return "OpBitCount";
        case spv::OpDPdx:
            return "OpDPdx";
        case spv::OpDPdy:
            return "OpDPdy";
        case spv::OpFwidth:
            return "OpFwidth";
        case spv::OpDPdxFine:
            return "OpDPdxFine";
        case spv::OpDPdyFine:
            return "OpDPdyFine";
        case spv::OpFwidthFine:
            return "OpFwidthFine";
        case spv::OpDPdxCoarse:
            return "OpDPdxCoarse";
        case spv::OpDPdyCoarse:
            return "OpDPdyCoarse";
        case spv::OpFwidthCoarse:
            return "OpFwidthCoarse";
        case spv::OpEmitVertex:
            return "OpEmitVertex";
        case spv::OpEndPrimitive:
            return "OpEndPrimitive";
        case spv::OpEmitStreamVertex:
            return "OpEmitStreamVertex";
        case spv::OpEndStreamPrimitive:
            return "OpEndStreamPrimitive";
        case spv::OpControlBarrier:
            return "OpControlBarrier";
        case spv::OpMemoryBarrier:
            return "OpMemoryBarrier";
        case spv::OpAtomicLoad:
            return "OpAtomicLoad";
        case spv::OpAtomicStore:
            return "OpAtomicStore";
        case spv::OpAtomicExchange:
            return "OpAtomicExchange";
        case spv::OpAtomicCompareExchange:
            return "OpAtomicCompareExchange";
        case spv::OpAtomicIIncrement:
            return "OpAtomicIIncrement";
        case spv::OpAtomicIDecrement:
            return "OpAtomicIDecrement";
        case spv::OpAtomicIAdd:
            return "OpAtomicIAdd";
        case spv::OpAtomicISub:
            return "OpAtomicISub";
        case spv::OpAtomicSMin:
            return "OpAtomicSMin";
        case spv::OpAtomicUMin:
            return "OpAtomicUMin";
        case spv::OpAtomicSMax:
            return "OpAtomicSMax";
        case spv::OpAtomicUMax:
            return "OpAtomicUMax";
        case spv::OpAtomicAnd:
            return "OpAtomicAnd";
        case spv::OpAtomicOr:
            return "OpAtomicOr";
        case spv::OpAtomicXor:
            return "OpAtomicXor";
        case spv::OpPhi:
            return "OpPhi";
        case spv::OpLoopMerge:
            return "OpLoopMerge";
        case spv::OpSelectionMerge:
            return "OpSelectionMerge";
        case spv::OpLabel:
            return "OpLabel";
        case spv::OpBranch:
            return "OpBranch";
        case spv::OpBranchConditional:
            return "OpBranchConditional";
        case spv::OpSwitch:
            return "OpSwitch";
        case spv::OpKill:
            return "OpKill";
        case spv::OpReturn:
            return "OpReturn";
        case spv::OpReturnValue:
            return "OpReturnValue";
        case spv::OpUnreachable:
            return "OpUnreachable";
        case spv::OpGroupAll:
            return "OpGroupAll";
        case spv::OpGroupAny:
            return "OpGroupAny";
        case spv::OpGroupBroadcast:
            return "OpGroupBroadcast";
        case spv::OpGroupIAdd:
            return "OpGroupIAdd";
        case spv::OpGroupFAdd:
            return "OpGroupFAdd";
        case spv::OpGroupFMin:
            return "OpGroupFMin";
        case spv::OpGroupUMin:
            return "OpGroupUMin";
        case spv::OpGroupSMin:
            return "OpGroupSMin";
        case spv::OpGroupFMax:
            return "OpGroupFMax";
        case spv::OpGroupUMax:
            return "OpGroupUMax";
        case spv::OpGroupSMax:
            return "OpGroupSMax";
        case spv::OpImageSparseSampleImplicitLod:
            return "OpImageSparseSampleImplicitLod";
        case spv::OpImageSparseSampleExplicitLod:
            return "OpImageSparseSampleExplicitLod";
        case spv::OpImageSparseSampleDrefImplicitLod:
            return "OpImageSparseSampleDrefImplicitLod";
        case spv::OpImageSparseSampleDrefExplicitLod:
            return "OpImageSparseSampleDrefExplicitLod";
        case spv::OpImageSparseSampleProjImplicitLod:
            return "OpImageSparseSampleProjImplicitLod";
        case spv::OpImageSparseSampleProjExplicitLod:
            return "OpImageSparseSampleProjExplicitLod";
        case spv::OpImageSparseSampleProjDrefImplicitLod:
            return "OpImageSparseSampleProjDrefImplicitLod";
        case spv::OpImageSparseSampleProjDrefExplicitLod:
            return "OpImageSparseSampleProjDrefExplicitLod";
        case spv::OpImageSparseFetch:
            return "OpImageSparseFetch";
        case spv::OpImageSparseGather:
            return "OpImageSparseGather";
        case spv::OpImageSparseDrefGather:
            return "OpImageSparseDrefGather";
        case spv::OpImageSparseTexelsResident:
            return "OpImageSparseTexelsResident";
        case spv::OpNoLine:
            return "OpNoLine";
        case spv::OpImageSparseRead:
            return "OpImageSparseRead";
        case spv::OpSizeOf:
            return "OpSizeOf";
        case spv::OpModuleProcessed:
            return "OpModuleProcessed";
        case spv::OpExecutionModeId:
            return "OpExecutionModeId";
        case spv::OpDecorateId:
            return "OpDecorateId";
        case spv::OpGroupNonUniformElect:
            return "OpGroupNonUniformElect";
        case spv::OpGroupNonUniformAll:
            return "OpGroupNonUniformAll";
        case spv::OpGroupNonUniformAny:
            return "OpGroupNonUniformAny";
        case spv::OpGroupNonUniformAllEqual:
            return "OpGroupNonUniformAllEqual";
        case spv::OpGroupNonUniformBroadcast:
            return "OpGroupNonUniformBroadcast";
        case spv::OpGroupNonUniformBroadcastFirst:
            return "OpGroupNonUniformBroadcastFirst";
        case spv::OpGroupNonUniformBallot:
            return "OpGroupNonUniformBallot";
        case spv::OpGroupNonUniformInverseBallot:
            return "OpGroupNonUniformInverseBallot";
        case spv::OpGroupNonUniformBallotBitExtract:
            return "OpGroupNonUniformBallotBitExtract";
        case spv::OpGroupNonUniformBallotBitCount:
            return "OpGroupNonUniformBallotBitCount";
        case spv::OpGroupNonUniformBallotFindLSB:
            return "OpGroupNonUniformBallotFindLSB";
        case spv::OpGroupNonUniformBallotFindMSB:
            return "OpGroupNonUniformBallotFindMSB";
        case spv::OpGroupNonUniformShuffle:
            return "OpGroupNonUniformShuffle";
        case spv::OpGroupNonUniformShuffleXor:
            return "OpGroupNonUniformShuffleXor";
        case spv::OpGroupNonUniformShuffleUp:
            return "OpGroupNonUniformShuffleUp";
        case spv::OpGroupNonUniformShuffleDown:
            return "OpGroupNonUniformShuffleDown";
        case spv::OpGroupNonUniformIAdd:
            return "OpGroupNonUniformIAdd";
        case spv::OpGroupNonUniformFAdd:
            return "OpGroupNonUniformFAdd";
        case spv::OpGroupNonUniformIMul:
            return "OpGroupNonUniformIMul";
        case spv::OpGroupNonUniformFMul:
            return "OpGroupNonUniformFMul";
        case spv::OpGroupNonUniformSMin:
            return "OpGroupNonUniformSMin";
        case spv::OpGroupNonUniformUMin:
            return "OpGroupNonUniformUMin";
        case spv::OpGroupNonUniformFMin:
            return "OpGroupNonUniformFMin";
        case spv::OpGroupNonUniformSMax:
            return "OpGroupNonUniformSMax";
        case spv::OpGroupNonUniformUMax:
            return "OpGroupNonUniformUMax";
        case spv::OpGroupNonUniformFMax:
            return "OpGroupNonUniformFMax";
        case spv::OpGroupNonUniformBitwiseAnd:
            return "OpGroupNonUniformBitwiseAnd";
        case spv::OpGroupNonUniformBitwiseOr:
            return "OpGroupNonUniformBitwiseOr";
        case spv::OpGroupNonUniformBitwiseXor:
            return "OpGroupNonUniformBitwiseXor";
        case spv::OpGroupNonUniformLogicalAnd:
            return "OpGroupNonUniformLogicalAnd";
        case spv::OpGroupNonUniformLogicalOr:
            return "OpGroupNonUniformLogicalOr";
        case spv::OpGroupNonUniformLogicalXor:
            return "OpGroupNonUniformLogicalXor";
        case spv::OpGroupNonUniformQuadBroadcast:
            return "OpGroupNonUniformQuadBroadcast";
        case spv::OpGroupNonUniformQuadSwap:
            return "OpGroupNonUniformQuadSwap";
        case spv::OpCopyLogical:
            return "OpCopyLogical";
        case spv::OpPtrEqual:
            return "OpPtrEqual";
        case spv::OpPtrNotEqual:
            return "OpPtrNotEqual";
        case spv::OpPtrDiff:
            return "OpPtrDiff";
        case spv::OpColorAttachmentReadEXT:
            return "OpColorAttachmentReadEXT";
        case spv::OpDepthAttachmentReadEXT:
            return "OpDepthAttachmentReadEXT";
        case spv::OpStencilAttachmentReadEXT:
            return "OpStencilAttachmentReadEXT";
        case spv::OpTerminateInvocation:
            return "OpTerminateInvocation";
        case spv::OpSubgroupBallotKHR:
            return "OpSubgroupBallotKHR";
        case spv::OpSubgroupFirstInvocationKHR:
            return "OpSubgroupFirstInvocationKHR";
        case spv::OpSubgroupAllKHR:
            return "OpSubgroupAllKHR";
        case spv::OpSubgroupAnyKHR:
            return "OpSubgroupAnyKHR";
        case spv::OpSubgroupAllEqualKHR:
            return "OpSubgroupAllEqualKHR";
        case spv::OpGroupNonUniformRotateKHR:
            return "OpGroupNonUniformRotateKHR";
        case spv::OpSubgroupReadInvocationKHR:
            return "OpSubgroupReadInvocationKHR";
        case spv::OpTraceRayKHR:
            return "OpTraceRayKHR";
        case spv::OpExecuteCallableKHR:
            return "OpExecuteCallableKHR";
        case spv::OpConvertUToAccelerationStructureKHR:
            return "OpConvertUToAccelerationStructureKHR";
        case spv::OpIgnoreIntersectionKHR:
            return "OpIgnoreIntersectionKHR";
        case spv::OpTerminateRayKHR:
            return "OpTerminateRayKHR";
        case spv::OpSDot:
            return "OpSDot";
        case spv::OpUDot:
            return "OpUDot";
        case spv::OpSUDot:
            return "OpSUDot";
        case spv::OpSDotAccSat:
            return "OpSDotAccSat";
        case spv::OpUDotAccSat:
            return "OpUDotAccSat";
        case spv::OpSUDotAccSat:
            return "OpSUDotAccSat";
        case spv::OpTypeCooperativeMatrixKHR:
            return "OpTypeCooperativeMatrixKHR";
        case spv::OpCooperativeMatrixLoadKHR:
            return "OpCooperativeMatrixLoadKHR";
        case spv::OpCooperativeMatrixStoreKHR:
            return "OpCooperativeMatrixStoreKHR";
        case spv::OpCooperativeMatrixMulAddKHR:
            return "OpCooperativeMatrixMulAddKHR";
        case spv::OpCooperativeMatrixLengthKHR:
            return "OpCooperativeMatrixLengthKHR";
        case spv::OpTypeRayQueryKHR:
            return "OpTypeRayQueryKHR";
        case spv::OpRayQueryInitializeKHR:
            return "OpRayQueryInitializeKHR";
        case spv::OpRayQueryTerminateKHR:
            return "OpRayQueryTerminateKHR";
        case spv::OpRayQueryGenerateIntersectionKHR:
            return "OpRayQueryGenerateIntersectionKHR";
        case spv::OpRayQueryConfirmIntersectionKHR:
            return "OpRayQueryConfirmIntersectionKHR";
        case spv::OpRayQueryProceedKHR:
            return "OpRayQueryProceedKHR";
        case spv::OpRayQueryGetIntersectionTypeKHR:
            return "OpRayQueryGetIntersectionTypeKHR";
        case spv::OpImageSampleWeightedQCOM:
            return "OpImageSampleWeightedQCOM";
        case spv::OpImageBoxFilterQCOM:
            return "OpImageBoxFilterQCOM";
        case spv::OpImageBlockMatchSSDQCOM:
            return "OpImageBlockMatchSSDQCOM";
        case spv::OpImageBlockMatchSADQCOM:
            return "OpImageBlockMatchSADQCOM";
        case spv::OpImageBlockMatchWindowSSDQCOM:
            return "OpImageBlockMatchWindowSSDQCOM";
        case spv::OpImageBlockMatchWindowSADQCOM:
            return "OpImageBlockMatchWindowSADQCOM";
        case spv::OpImageBlockMatchGatherSSDQCOM:
            return "OpImageBlockMatchGatherSSDQCOM";
        case spv::OpImageBlockMatchGatherSADQCOM:
            return "OpImageBlockMatchGatherSADQCOM";
        case spv::OpGroupIAddNonUniformAMD:
            return "OpGroupIAddNonUniformAMD";
        case spv::OpGroupFAddNonUniformAMD:
            return "OpGroupFAddNonUniformAMD";
        case spv::OpGroupFMinNonUniformAMD:
            return "OpGroupFMinNonUniformAMD";
        case spv::OpGroupUMinNonUniformAMD:
            return "OpGroupUMinNonUniformAMD";
        case spv::OpGroupSMinNonUniformAMD:
            return "OpGroupSMinNonUniformAMD";
        case spv::OpGroupFMaxNonUniformAMD:
            return "OpGroupFMaxNonUniformAMD";
        case spv::OpGroupUMaxNonUniformAMD:
            return "OpGroupUMaxNonUniformAMD";
        case spv::OpGroupSMaxNonUniformAMD:
            return "OpGroupSMaxNonUniformAMD";
        case spv::OpFragmentMaskFetchAMD:
            return "OpFragmentMaskFetchAMD";
        case spv::OpFragmentFetchAMD:
            return "OpFragmentFetchAMD";
        case spv::OpReadClockKHR:
            return "OpReadClockKHR";
        case spv::OpFinalizeNodePayloadsAMDX:
            return "OpFinalizeNodePayloadsAMDX";
        case spv::OpFinishWritingNodePayloadAMDX:
            return "OpFinishWritingNodePayloadAMDX";
        case spv::OpInitializeNodePayloadsAMDX:
            return "OpInitializeNodePayloadsAMDX";
        case spv::OpGroupNonUniformQuadAllKHR:
            return "OpGroupNonUniformQuadAllKHR";
        case spv::OpGroupNonUniformQuadAnyKHR:
            return "OpGroupNonUniformQuadAnyKHR";
        case spv::OpHitObjectRecordHitMotionNV:
            return "OpHitObjectRecordHitMotionNV";
        case spv::OpHitObjectRecordHitWithIndexMotionNV:
            return "OpHitObjectRecordHitWithIndexMotionNV";
        case spv::OpHitObjectRecordMissMotionNV:
            return "OpHitObjectRecordMissMotionNV";
        case spv::OpHitObjectGetWorldToObjectNV:
            return "OpHitObjectGetWorldToObjectNV";
        case spv::OpHitObjectGetObjectToWorldNV:
            return "OpHitObjectGetObjectToWorldNV";
        case spv::OpHitObjectGetObjectRayDirectionNV:
            return "OpHitObjectGetObjectRayDirectionNV";
        case spv::OpHitObjectGetObjectRayOriginNV:
            return "OpHitObjectGetObjectRayOriginNV";
        case spv::OpHitObjectTraceRayMotionNV:
            return "OpHitObjectTraceRayMotionNV";
        case spv::OpHitObjectGetShaderRecordBufferHandleNV:
            return "OpHitObjectGetShaderRecordBufferHandleNV";
        case spv::OpHitObjectGetShaderBindingTableRecordIndexNV:
            return "OpHitObjectGetShaderBindingTableRecordIndexNV";
        case spv::OpHitObjectRecordEmptyNV:
            return "OpHitObjectRecordEmptyNV";
        case spv::OpHitObjectTraceRayNV:
            return "OpHitObjectTraceRayNV";
        case spv::OpHitObjectRecordHitNV:
            return "OpHitObjectRecordHitNV";
        case spv::OpHitObjectRecordHitWithIndexNV:
            return "OpHitObjectRecordHitWithIndexNV";
        case spv::OpHitObjectRecordMissNV:
            return "OpHitObjectRecordMissNV";
        case spv::OpHitObjectExecuteShaderNV:
            return "OpHitObjectExecuteShaderNV";
        case spv::OpHitObjectGetCurrentTimeNV:
            return "OpHitObjectGetCurrentTimeNV";
        case spv::OpHitObjectGetAttributesNV:
            return "OpHitObjectGetAttributesNV";
        case spv::OpHitObjectGetHitKindNV:
            return "OpHitObjectGetHitKindNV";
        case spv::OpHitObjectGetPrimitiveIndexNV:
            return "OpHitObjectGetPrimitiveIndexNV";
        case spv::OpHitObjectGetGeometryIndexNV:
            return "OpHitObjectGetGeometryIndexNV";
        case spv::OpHitObjectGetInstanceIdNV:
            return "OpHitObjectGetInstanceIdNV";
        case spv::OpHitObjectGetInstanceCustomIndexNV:
            return "OpHitObjectGetInstanceCustomIndexNV";
        case spv::OpHitObjectGetWorldRayDirectionNV:
            return "OpHitObjectGetWorldRayDirectionNV";
        case spv::OpHitObjectGetWorldRayOriginNV:
            return "OpHitObjectGetWorldRayOriginNV";
        case spv::OpHitObjectGetRayTMaxNV:
            return "OpHitObjectGetRayTMaxNV";
        case spv::OpHitObjectGetRayTMinNV:
            return "OpHitObjectGetRayTMinNV";
        case spv::OpHitObjectIsEmptyNV:
            return "OpHitObjectIsEmptyNV";
        case spv::OpHitObjectIsHitNV:
            return "OpHitObjectIsHitNV";
        case spv::OpHitObjectIsMissNV:
            return "OpHitObjectIsMissNV";
        case spv::OpReorderThreadWithHitObjectNV:
            return "OpReorderThreadWithHitObjectNV";
        case spv::OpReorderThreadWithHintNV:
            return "OpReorderThreadWithHintNV";
        case spv::OpTypeHitObjectNV:
            return "OpTypeHitObjectNV";
        case spv::OpImageSampleFootprintNV:
            return "OpImageSampleFootprintNV";
        case spv::OpEmitMeshTasksEXT:
            return "OpEmitMeshTasksEXT";
        case spv::OpSetMeshOutputsEXT:
            return "OpSetMeshOutputsEXT";
        case spv::OpGroupNonUniformPartitionNV:
            return "OpGroupNonUniformPartitionNV";
        case spv::OpWritePackedPrimitiveIndices4x8NV:
            return "OpWritePackedPrimitiveIndices4x8NV";
        case spv::OpFetchMicroTriangleVertexPositionNV:
            return "OpFetchMicroTriangleVertexPositionNV";
        case spv::OpFetchMicroTriangleVertexBarycentricNV:
            return "OpFetchMicroTriangleVertexBarycentricNV";
        case spv::OpReportIntersectionNV:
            return "OpReportIntersectionNV";
        case spv::OpIgnoreIntersectionNV:
            return "OpIgnoreIntersectionNV";
        case spv::OpTerminateRayNV:
            return "OpTerminateRayNV";
        case spv::OpTraceNV:
            return "OpTraceNV";
        case spv::OpTraceMotionNV:
            return "OpTraceMotionNV";
        case spv::OpTraceRayMotionNV:
            return "OpTraceRayMotionNV";
        case spv::OpRayQueryGetIntersectionTriangleVertexPositionsKHR:
            return "OpRayQueryGetIntersectionTriangleVertexPositionsKHR";
        case spv::OpTypeAccelerationStructureKHR:
            return "OpTypeAccelerationStructureKHR";
        case spv::OpExecuteCallableNV:
            return "OpExecuteCallableNV";
        case spv::OpTypeCooperativeMatrixNV:
            return "OpTypeCooperativeMatrixNV";
        case spv::OpCooperativeMatrixLoadNV:
            return "OpCooperativeMatrixLoadNV";
        case spv::OpCooperativeMatrixStoreNV:
            return "OpCooperativeMatrixStoreNV";
        case spv::OpCooperativeMatrixMulAddNV:
            return "OpCooperativeMatrixMulAddNV";
        case spv::OpCooperativeMatrixLengthNV:
            return "OpCooperativeMatrixLengthNV";
        case spv::OpBeginInvocationInterlockEXT:
            return "OpBeginInvocationInterlockEXT";
        case spv::OpEndInvocationInterlockEXT:
            return "OpEndInvocationInterlockEXT";
        case spv::OpDemoteToHelperInvocation:
            return "OpDemoteToHelperInvocation";
        case spv::OpIsHelperInvocationEXT:
            return "OpIsHelperInvocationEXT";
        case spv::OpConvertUToImageNV:
            return "OpConvertUToImageNV";
        case spv::OpConvertUToSamplerNV:
            return "OpConvertUToSamplerNV";
        case spv::OpConvertImageToUNV:
            return "OpConvertImageToUNV";
        case spv::OpConvertSamplerToUNV:
            return "OpConvertSamplerToUNV";
        case spv::OpConvertUToSampledImageNV:
            return "OpConvertUToSampledImageNV";
        case spv::OpConvertSampledImageToUNV:
            return "OpConvertSampledImageToUNV";
        case spv::OpSamplerImageAddressingModeNV:
            return "OpSamplerImageAddressingModeNV";
        case spv::OpRawAccessChainNV:
            return "OpRawAccessChainNV";
        case spv::OpUCountLeadingZerosINTEL:
            return "OpUCountLeadingZerosINTEL";
        case spv::OpUCountTrailingZerosINTEL:
            return "OpUCountTrailingZerosINTEL";
        case spv::OpAbsISubINTEL:
            return "OpAbsISubINTEL";
        case spv::OpAbsUSubINTEL:
            return "OpAbsUSubINTEL";
        case spv::OpIAddSatINTEL:
            return "OpIAddSatINTEL";
        case spv::OpUAddSatINTEL:
            return "OpUAddSatINTEL";
        case spv::OpIAverageINTEL:
            return "OpIAverageINTEL";
        case spv::OpUAverageINTEL:
            return "OpUAverageINTEL";
        case spv::OpIAverageRoundedINTEL:
            return "OpIAverageRoundedINTEL";
        case spv::OpUAverageRoundedINTEL:
            return "OpUAverageRoundedINTEL";
        case spv::OpISubSatINTEL:
            return "OpISubSatINTEL";
        case spv::OpUSubSatINTEL:
            return "OpUSubSatINTEL";
        case spv::OpIMul32x16INTEL:
            return "OpIMul32x16INTEL";
        case spv::OpUMul32x16INTEL:
            return "OpUMul32x16INTEL";
        case spv::OpConstantFunctionPointerINTEL:
            return "OpConstantFunctionPointerINTEL";
        case spv::OpFunctionPointerCallINTEL:
            return "OpFunctionPointerCallINTEL";
        case spv::OpAtomicFMinEXT:
            return "OpAtomicFMinEXT";
        case spv::OpAtomicFMaxEXT:
            return "OpAtomicFMaxEXT";
        case spv::OpAssumeTrueKHR:
            return "OpAssumeTrueKHR";
        case spv::OpExpectKHR:
            return "OpExpectKHR";
        case spv::OpDecorateString:
            return "OpDecorateString";
        case spv::OpMemberDecorateString:
            return "OpMemberDecorateString";
        case spv::OpRayQueryGetRayTMinKHR:
            return "OpRayQueryGetRayTMinKHR";
        case spv::OpRayQueryGetRayFlagsKHR:
            return "OpRayQueryGetRayFlagsKHR";
        case spv::OpRayQueryGetIntersectionTKHR:
            return "OpRayQueryGetIntersectionTKHR";
        case spv::OpRayQueryGetIntersectionInstanceCustomIndexKHR:
            return "OpRayQueryGetIntersectionInstanceCustomIndexKHR";
        case spv::OpRayQueryGetIntersectionInstanceIdKHR:
            return "OpRayQueryGetIntersectionInstanceIdKHR";
        case spv::OpRayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR:
            return "OpRayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR";
        case spv::OpRayQueryGetIntersectionGeometryIndexKHR:
            return "OpRayQueryGetIntersectionGeometryIndexKHR";
        case spv::OpRayQueryGetIntersectionPrimitiveIndexKHR:
            return "OpRayQueryGetIntersectionPrimitiveIndexKHR";
        case spv::OpRayQueryGetIntersectionBarycentricsKHR:
            return "OpRayQueryGetIntersectionBarycentricsKHR";
        case spv::OpRayQueryGetIntersectionFrontFaceKHR:
            return "OpRayQueryGetIntersectionFrontFaceKHR";
        case spv::OpRayQueryGetIntersectionCandidateAABBOpaqueKHR:
            return "OpRayQueryGetIntersectionCandidateAABBOpaqueKHR";
        case spv::OpRayQueryGetIntersectionObjectRayDirectionKHR:
            return "OpRayQueryGetIntersectionObjectRayDirectionKHR";
        case spv::OpRayQueryGetIntersectionObjectRayOriginKHR:
            return "OpRayQueryGetIntersectionObjectRayOriginKHR";
        case spv::OpRayQueryGetWorldRayDirectionKHR:
            return "OpRayQueryGetWorldRayDirectionKHR";
        case spv::OpRayQueryGetWorldRayOriginKHR:
            return "OpRayQueryGetWorldRayOriginKHR";
        case spv::OpRayQueryGetIntersectionObjectToWorldKHR:
            return "OpRayQueryGetIntersectionObjectToWorldKHR";
        case spv::OpRayQueryGetIntersectionWorldToObjectKHR:
            return "OpRayQueryGetIntersectionWorldToObjectKHR";
        case spv::OpAtomicFAddEXT:
            return "OpAtomicFAddEXT";
        case spv::OpGroupIMulKHR:
            return "OpGroupIMulKHR";
        case spv::OpGroupFMulKHR:
            return "OpGroupFMulKHR";
        case spv::OpGroupBitwiseAndKHR:
            return "OpGroupBitwiseAndKHR";
        case spv::OpGroupBitwiseOrKHR:
            return "OpGroupBitwiseOrKHR";
        case spv::OpGroupBitwiseXorKHR:
            return "OpGroupBitwiseXorKHR";
        case spv::OpGroupLogicalAndKHR:
            return "OpGroupLogicalAndKHR";
        case spv::OpGroupLogicalOrKHR:
            return "OpGroupLogicalOrKHR";
        case spv::OpGroupLogicalXorKHR:
            return "OpGroupLogicalXorKHR";

        default:
            return "Unknown Opcode";
    }
}
