/*
 * Copyright (c) 2020-2021 Valve Corporation
 * Copyright (c) 2020-2021 LunarG, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Authors:
 * - Richard S. Wright Jr. <richard@lunarg.com>
 * - Christophe Riccio <christophe@lunarg.com>
 */

#pragma once

#include "ui_dialog_vulkan_info.h"

#include <memory>

class VulkanInfoDialog : public QDialog {
    Q_OBJECT

   public:
    explicit VulkanInfoDialog(QWidget *parent = nullptr);

   private:
    VulkanInfoDialog(const VulkanInfoDialog &) = delete;
    VulkanInfoDialog &operator=(const VulkanInfoDialog &) = delete;

    void BuildExtensions(QJsonValue &json_value, QTreeWidgetItem *root);
    void BuildLayers(QJsonValue &json_value, QTreeWidgetItem *root);
    void BuildSurfaces(QJsonValue &json_value, QTreeWidgetItem *root);
    void BuildGroups(QJsonValue &json_value, QTreeWidgetItem *root);
    void BuildDevices(QJsonValue &json_value, QTreeWidgetItem *root);
    void TraverseGenericProperties(QJsonValue &parent_json, QTreeWidgetItem *parent_tree_item);

    void Run();

    std::unique_ptr<Ui::dialog_vulkan_info> ui;
};
