#!/usr/bin/python
# $Id: personalize.py,v 1.3.2.1 2002/01/28 17:17:05 rp Exp $
#
# PDFlib/PDI client: personalization demo
#

from sys import *
from time import *
from pdflib_py import *

p = PDF_new()

if PDF_open_file(p, "personalize.pdf") == -1:
    print "Couldn't open PDF file 'personalize.pdf'\n"
    exit(2)

PDF_set_info(p, "Author", "Thomas Merz")
PDF_set_info(p, "Creator", "personalize.py")
PDF_set_info(p, "Title", "PDFlib personalization demo (Python)")

infile = "../../doc/PDFlib-purchase-order.pdf"
col1 = 70
col2 = 335

form = PDF_open_pdi(p, infile, "", 0)
if form == -1:
    print "Couldn't open input file '" + infile + "'.\n"
    exit(2)

page = PDF_open_pdi_page(p, form, 1, "")
if page == -1:
    print "Couldn't open page 1 in '" + infile + "'.\n"
    exit(2)

font = PDF_findfont(p, "Helvetica-Bold", "host", 0)

# get the dimensions of the imported form
width = PDF_get_pdi_value(p, "width", form, page, 0)
height = PDF_get_pdi_value(p, "height", form, page, 0)

PDF_begin_page(p, width, height)
PDF_place_pdi_page(p, page, 0, 0, 1, 1)
PDF_close_pdi_page(p, page)

PDF_setfont(p, font, 18)
PDF_set_value(p, "leading", 24)
PDF_set_text_pos(p, col1, 486)

PDF_show(p, "Doublecheck, Inc.")
PDF_continue_text(p, "Petra Porst")
PDF_continue_text(p, "500, Market St.")
PDF_continue_text(p, "94110 San Francisco, CA")
PDF_continue_text(p, "")
PDF_continue_text(p, "USA")
PDF_continue_text(p, "+1/950/123-4567")
PDF_continue_text(p, "+1/950/123-4568")
PDF_continue_text(p, "")
PDF_continue_text(p, "petra@doublecheck.com")

(tm_year, tm_mon, tm_day,
tm_hour, tm_min, tm_sec, 
tm_weekday, tm_julian, tm_ds) = localtime(time())

months = [ "January", "February", "March", "April", "May", "June",
	    "July", "August", "September", "October", "November", "December" ]

PDF_set_text_pos(p, col2, 104)
PDF_continue_text(p, "%s %d, %d" % (months[tm_mon], tm_day, tm_year))

PDF_end_page(p)
PDF_close(p)
PDF_close_pdi(p, form)
PDF_delete(p)
