#!/bin/sh
# $Id: image.tcl,v 1.10 2001/03/15 13:42:54 rjs Exp $
#
# PDFlib client: image example in Tcl
#

# Hide the exec to Tcl but not to the shell by appending a backslash\
exec tclsh "$0" ${1+"$@"}

# The lappend line is unnecessary if PDFlib has been installed
# in the Tcl package directory
set auto_path [linsert $auto_path 0 .libs .]

package require pdflib 4.0

set p [PDF_new]

if {[PDF_open_file $p "image.pdf"] == -1} {
    puts stderr "Couldn't open PDF file!"
    exit
}

PDF_set_info $p "Creator" "image.tcl"
PDF_set_info $p "Author" "Thomas Merz"
PDF_set_info $p "Title" "image sample (Tcl)"

set image [PDF_open_image_file $p "jpeg" "../../test/nesrin.jpg" "" 0]

if {$image == -1} {
    puts stderr "Couldn't open image file!"
    exit
}

# See the PDFlib manual for more advanced image size calculations
set width [PDF_get_value $p "imagewidth" image]
set height [PDF_get_value $p "imageheight" image]

# We generate a page with the image's dimensions
PDF_begin_page $p $width $height
PDF_place_image $p $image 0 0 1
PDF_close_image $p $image
PDF_end_page $p

PDF_close $p

PDF_delete $p
