#include <stdlib.h>	/* atoi, strtol */
#include <string.h>	/* strcmp, strcasecmp */
#include <stdio.h>	/* printf */

#include "dostypes.h"	/* Byte Word Dword */
#include "fatio.h"	/* {read,write}fat(drive, slot, {*,} value) */
#include "diskio.h"	/* r/w file+sector */
#include "drives.h"	/* DPB, getdrive(DPB * dpb), setdrive(0...) */
#include "dir16.h"	/* dirent structure, Date/Time macros */
#include "cluster.h"	/* nextcluster, clustertosector/CTS */
#include "dirfind.h"	/* dirfind, dirfind1 */

/* {read,write}sector(drive,which,*buffer), openfile{r,w}(*name) */
/* closefile(handle), {read,write}file(handle,*buffer) */

/* ***************************************************** */

#ifndef strcasecmp /* seems to be avail for Unix only... */
#include <ctype.h>
int strcasecmp(const char * s1, const char * s2)
{	/* case insensitive string compare */
  int x;
  while (s1[0] && s2[0]) {
    x = (toupper(s1[0]) - toupper(s2[0]));
    if (x != 0) { return (x<0 ? -1 : 1); }
    s1++;
    s2++;
  }
  if (s1[0] != s2[0]) {
    x = (toupper(s1[0]) - toupper(s2[0]));
    return (x<0 ? -1 : 1);
  } else {
    return 0;
  }
}
#endif


void help(void)
{
  printf("Undelete (and mirror, kind of) GPL 2 software\n");
  printf("Eric Auer <eric@coli.uni-sb.de>\n");
  printf("Always operates on the current drive, saves items\n");
  printf("to files on other drives or undeletes files in place\n\n");
  
  printf("Usage: undelete how what where [size]\n");
  printf("how:           syssave, follow, dirsave or undelete\n");
  printf("what/syssave:  fat1, fat2, root or boot\n");
  printf("what/follow:   first cluster number\n");
  printf("what/dirsave:  \\abs\\directory\\name or cluster number\n");
  printf("what/undelete: *nothing yet* (would modify the FAT/dir)\n");
  printf("where:         file, but *not* on current drive\n");
  printf("size:          sectors for dirsave, clusters for follow\n");
  printf("               use 0 for autodetect (existing files).\n");
}

/* ***************************************************** */


int main(int argc, char ** argv) /* argv[0] is self... */
{
  int arg4 = -1;
  Byte buffer[512];
  Dword sector;
  Word cluster;
  Word nextclust;
  Dword howmany;
  int handle,i,j,state;
  struct DPB dpb;
  int drive;
  
  drive = getdrive(&dpb);
  /* always operates on current drive */
  
  if (dpb.bytepersec != 512) {
    printf("Must have 512 bytes per sector\n");
    return -1;
  }

  /* arg0: self                                        */
  /* arg1: SYSSAVE FOLLOW DIRSAVE (UNDELETE)           */
  /* arg2: FAT1 FAT2 ROOT BOOT for SYSSAVE, starting   */
  /*       cluster for FOLLOW, directory for DIRSAVE,  */
  /*       (some filespec for UNDELETE, never dir!?)   */
  /* arg3: filename, where to save the specified thing */
  /* arg4: size for follow in clusters, may guess...   */
  /*       (follow a deleted file -> guess your way)   */
  /*       No arg4 for SYSSAVE. Size in sectors for    */
  /*       DIRSAVE. Arg4 is always optional.           */
  /* undelete (modify fat) not yet implemented!        */
  
  if (argc>5) { printf("Too many args\n"); help(); return -1; };
  if (argc<4) { printf("Too few args\n");  help(); return -1; };
  if (argc==5) {
    arg4 = atoi(argv[4]);
    /* strtol(argv[4],NULL,10); base 10, end irrelevant */
    if (arg4 < 0) { printf("Negative?\n"); help(); return -1; };
  };

/* ***************************************************** */

  if (!strcasecmp(argv[1],"UNDELETE")) {
    printf("Undelete in place not yet implemented\n");
    return -1;
  }

/* ***************************************************** */

  if (!strcasecmp(argv[1],"SYSSAVE")) {
    if (arg4 != -1) { help(); return -1; } /* no arg4 for syssave */
    howmany = 0;
    if (!strcasecmp(argv[2],"BOOT")) {
      howmany = dpb.numressec;
      sector = 0; /* first sectors */
    };   
    if (!strcasecmp(argv[2],"FAT1")) {
      howmany = dpb.secperfat;
      sector = dpb.numressec; /* skip over reserved */
    }
    if (!strcasecmp(argv[2],"FAT2")) {
      howmany = dpb.secperfat;
      sector = dpb.numressec + howmany;
    }
    if (!strcasecmp(argv[2],"ROOT")) {
      howmany = dpb.rootdirents >> 4; /* 512/32 */
      sector = dpb.numressec + (dpb.secperfat * dpb.fats);
    }
    if (howmany == 0) { help(); return -1; }; /* illegal sysssave */
    
    handle = openfilew(argv[3]);
    if (handle < 0) { printf("write/open error\n"); return -1; };
    printf("Saving from sector %ld on...\n", sector);

    for (i=0;i<howmany;i++) {
      state = readsector(drive,sector,buffer);
      if (state<0) { printf("read error\n"); return -1; }
      state = writefile(handle,buffer);
      if (state<0) { printf("write error\n"); return -1; }
      sector++;
      printf(".");
    }

    printf("\nDone\n");
    (void)closefile(handle);
    return 0;
  }

/* ***************************************************** */

  if (!strcasecmp(argv[1],"FOLLOW")) {
    if (arg4 < 0) { arg4 = 1; } /* default size 1 cluster */
    cluster = atoi(argv[2]);
    
    handle = openfilew(argv[3]);
    if (handle < 0) { printf("write/open error\n"); return -1; };
    printf("Following FAT chain until EOF or count reached...\n");
        
    if (arg4 == 0) {
      printf("Reading an existing FAT chain\n");
      state = readfat(drive,cluster,&nextclust, &dpb);
      if (state < 0) { return -1; }
      if (nextclust == 0) {
        printf("There is no FAT chain on this spot!\n");
        return -1;
      }
    } else {
      printf("Reading from empty areas according to FAT\n");
      state = readfat(drive,cluster,&nextclust,&dpb);
      if (state<0) { return -1; }
      if (nextclust > 0) {
        printf("This area is not empty, skipping...\n");
        while (nextclust > 0) {
          cluster++;
          state = readfat(drive,cluster,&nextclust,&dpb);
          if (state<0) { return -1; }
        }
        printf("Starting with cluster %u\n",cluster);
      }
    }
    
    for (i=0 ; (arg4==0) || (i<arg4) ; i++) { /* 0 is auto */

      sector = CTS(cluster, &dpb);

      if (!sector) { return -1; }
      
      for (j=0 ; j <= dpb.maxsecinclust ; j++) {
        state = readsector(drive,sector,buffer);
        if (state<0) { printf("read error\n"); return -1; }
        state = writefile(handle,buffer);
        if (state<0) { printf("write error\n"); return -1; }
        sector++;
       }

      cluster = nextcluster(cluster, &dpb); /* MAGIC */

      if (cluster == 0) {
        printf("\nDone (FAT chain EOF encountered)\n");
        (void)closefile(handle);
        return 0;
      }
    }

   printf("\nDone\n");
   (void)closefile(handle);
   return 0;
  }

/* ***************************************************** */

  if (!strcasecmp(argv[1],"DIRSAVE")) {
    if (arg4 < 0) { arg4 = 1; } /* default size 1 sector */

    if ((argv[2][0] <= '9') && (argv[2][0] >= '0')) {	/* cluster */
      cluster = atoi(argv[2]);
      sector = CTS(cluster,&dpb);

      if (arg4 == 0) {
        printf("Reading an existing FAT chain\n");
        state = readfat(drive,cluster,&nextclust,&dpb);
        if (state < 0) { return -1; }
        if (nextclust == 0) {
          printf("There is no FAT chain on this spot!\n");
          return -1;
        }
      } else {
        printf("Reading from empty areas according to FAT\n");
        state = readfat(drive,cluster,&nextclust,&dpb);
        if (state<0) { return -1; }
        if (nextclust > 0) {
          printf("This area is not empty, skipping...\n");
          while (nextclust > 0) {
            cluster++;
            state = readfat(drive,cluster,&nextclust,&dpb);
            if (state<0) { return -1; }
          }
          sector = CTS(cluster,&dpb);
        }
      }

    } else {					/* path */
      if ((!strcasecmp(argv[2],"\\")) ||
          (!strcasecmp(argv[2],"/"))) {
        printf("Dirsave: selected root directory\n");
        cluster = 0;
      } else {
      
        if (dirfind(argv[2],&cluster,&dpb)<0) { /* main MAGIC */

          printf("Dirsave: directory not found\n");
          return -1;
        }
      }

      if (cluster == 0) {
        sector = dpb.numressec + (dpb.fats * dpb.secperfat);
      } else {
        sector = CTS(cluster,&dpb);
      }
    }
        
    printf("DIRSAVE starting with sector %ld, cluster %u\n", 
      sector, cluster);
    j = 0; /* sector in cluster */
    
    handle = openfilew(argv[3]);
    if (handle < 0) { printf("write/open error\n"); return -1; };
    printf("Saving DIR until EOF or count reached...\n");

    for (i=0; (arg4==0) || (i<arg4) ; i++) { /* 0 is auto */
      state = readsector(drive,sector,buffer);
      if (state<0) { printf("read error\n"); return -1; }
      state = writefile(handle,buffer);
      if (state<0) { printf("write error\n"); return -1; }
    
      printdirents(buffer,&dpb); /* also print dirents for user */
      
      if (arg4==0) { /* if auto, detect end */
        if ((buffer[512-32] == 0) && (buffer[512-64] == 0)) {
          printf("\nSeems to be EOF\n");
          (void)closefile(handle);
          return 0;
        }
      }
    
      if (sector < CTS(2,&dpb)) { /* root directory is linear */
        sector++;
      } else {
        sector++; /* clusters are linear */
        j++;
        if (j == dpb.maxsecinclust) { /* follow FAT chain */

          cluster = nextcluster(cluster,&dpb);

          if (cluster == 0) {
            printf("\nDone (EOF encountered)\n");
            (void)closefile(handle);
            return 0;
          }

          sector = CTS(cluster,&dpb); /* back on track */

        }
      }
      
    }
    
    printf("\nDone\n");
    (void)closefile(handle);
    return 0;
  }

  return -1;
}



