/*  Label

    Copyright (c) Max Brante 1994.
    Copyright (c) Joe Cosentino and Brian Reifsnyder 2000.
    All Rights Reserved.

*/

// I N C L U D E S //////////////////////////////////////////////////////////

#include <conio.h>
#include <dos.h>
#include <dir.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

// F U N C T I O N S ////////////////////////////////////////////////////////

void error(int errnum)
{
    char *buffer;

    switch (errnum&0xFF)
	{
	case 0x00:
            sprintf(buffer,"Write protect error\n");
	    break;
	case 0x01:
            sprintf(buffer,"Unknown unit\n");
	    break;
	case 0x02:
            sprintf(buffer,"Drive not ready\n");
	    break;
	case 0x03:
            sprintf(buffer,"Unknown command\n");
	    break;
	case 0x04:
            sprintf(buffer,"Data error (bad CRC)\n");
	    break;
	case 0x05:
            sprintf(buffer,"Cannot label a network drive\n");
	    break;
	case 0x06:
            sprintf(buffer,"Seek error\n");
	    break;
	case 0x07:
            sprintf(buffer,"Unknown media type\n");
	    break;
	case 0x08:
            sprintf(buffer,"Sector not found\n");
	    break;
	case 0x0A:
            sprintf(buffer,"Write fault\n");
	    break;
	case 0x0B:
            sprintf(buffer,"Read fault\n");
	    break;
        case 0x0C:
            sprintf(buffer,"General failure\n");
            break;

        } // end switch.

    exit(1);

} // end error.

/////////////////////////////////////////////////////////////////////////////

int label(int drive, char label[15])
{
    char oldlabel[12], far *mdbptr;
    unsigned char buf[512], ch, *dirent, buffer[512], sector_buffer[512];
    unsigned nument, serhi, serlo;
    int haslabel=0,savedlabel=0, result, nresult, index=0;
    long dirstart,i,lsect;
    time_t timer;
    struct tm tblock;
    union REGS regs;

    serlo=serlo,serhi=serhi;
    do
        {
        label[index]=0;
        index++;
        } // end do.
    while (index<15);

    // time() returns time of day in seconds, elapsed since 00:00:00 GMT,
    // January 1, 1970.
    timer = time(NULL);

    // localtime() converts date and time to a structure.
    memcpy(&tblock,localtime(&timer),sizeof(struct tm));

    // Get drive info.
    regs.h.ah=0x1c;
    regs.h.dl=drive+1;
    intdos(&regs,&regs);                // Generate a DOS interrupt.
    if (regs.h.al==0xFF)                // If drive not valid.
	error(2);

    // Check for write-protection and stop if it is.
    nresult = biosdisk(1, drive, 0, 0, 1, 1, sector_buffer);
    if (nresult == 3)
        {
        sprintf(buffer,"Disk is write-protected\n");
        return 1;
        } // end if.

    // Read boot record of logical disk.
    if (absread(drive,1,0,buf)==-1)
	error(errno);

    nument=*(unsigned *)&buf[0x11];     // Get number of root dir. entries.

    // Get the start block number of the root directory.
    dirstart=buf[0x10]*(*(unsigned *)&(buf[0x16]))+1;

    // Get volume serial number.
    serlo=*(unsigned *)&buf[0x27];
    serhi=*(unsigned *)&buf[0x29];

    // Loop through the entries in the root directory.
    for (i=0;i<nument*32;i+=32)
        {
        // If we crossed a block boundary, read next one.
        if ((i%512)==0)
	    {
            if (absread(drive,1,dirstart+i/512,buf)==-1)
                error(errno);

            drive=drive;
	    } // end if.

        // Point dirent at current entry in the root directory.
        dirent=&buf[i%512];

        // If first byte in directory entry is 0 no more entries.
        if (*dirent==0)
            break;

	// If volume label attribute is set, the label isn't deleted,
	// and the size is 0 we have found the volume label.
	if ((dirent[0x0B]&8)==8 && *dirent!=0xE5 && (dirent[0x0B])!=0x0F)
	    {
            // Get volume the label and the number of the block in which the
            // entry containing the label is.
            memcpy(oldlabel,dirent,11);
            oldlabel[11]=0;
            lsect=dirstart+i/512;
            haslabel=1;
            break;
            } // end if.

        } // end for.

    if (strpbrk(label, "*?/\|.,;:+=[]()&^<>"))
        {
        fprintf(stderr, "Invalid characters in volume label\n");
        return 1;
        } // end if.

    if (label[strlen(label)-1]=='\n')
        label[strlen(label)-1]=0;

    if ((strlen(label)!=0) && (strlen(label)<11))
	memset(&label[strlen(label)],32,11-strlen(label));

    strupr(label);
    if (strlen(label)==0)               // If we didn't get a new label.
	{
	if (haslabel)
	    {
            *dirent=0xE5;           // Delete the old label.
            if (abswrite(drive,1,lsect,buf)==-1)
                error(errno);

            if (absread(drive,1,0,buf)==-1)
                error(errno);

            // Change the label field in the boot block.
            memcpy(&buf[43],"NO NAME    ",11);
            if (abswrite(drive,1,0,buf)==-1)
                error(errno);

            } // end if.

	} // end if.
    else
	{
	if (haslabel)           // If the volume had a old label, change it.
	    {
	    memcpy(dirent,label,11);
	    savedlabel=1;
	    } // end if.
	// The volume had no label so find a unused directory entry
	// and save the label.
	else
	    {
	    // Loop through the entries in the root directory.
	    for (i=0;i<nument*32;i+=32)
		{
		// If we crossed a block boundary, read next one.
		if ((i%512)==0)
		    {
		    if (absread(drive,1,dirstart+i/512,buf)==-1)
			error(errno);

		    drive=drive;
		    } // end if.

		// Point dirent at current entry in the root directory.
		dirent=&buf[i%512];

		// If the directory entry deleted or isn't used
		// and if the entry is not an LFN, save label there.
                if ((*dirent==0xE5 || *dirent==0) && dirent[0x0B]!=0x0F)
		    {
		    memset(dirent,0,32);
		    memcpy(dirent,label,11);
		    dirent[0x0B]=0x28;
		    lsect=dirstart+i/512;
		    savedlabel=1;
		    break;
		    } // end if.

		} // end for.

	    } // end else.

	if (savedlabel)
	    {
	    // Save the time and date of the change in the directory entry.
	    *(unsigned*)&dirent[0x16]=(tblock.tm_hour&31)<<11 | (tblock.tm_min&63)<<5 | (tblock.tm_sec&31);
	    *(unsigned*)&dirent[0x18]=((80-tblock.tm_year)&127)<<9 | ((1+tblock.tm_mon)&15)<<5 | (tblock.tm_mday&31);

	    // Write the directory entry to the volume.
	    if (abswrite(drive,1,lsect,buf)==-1)
		error(errno);

	    // Update the label field in the boot record.
	    if (absread(drive,1,0,buf)==-1)
		error(errno);

	    memcpy(&buf[43],label,11);
	    if (abswrite(drive,1,0,buf)==-1)
		error(errno);

	    } // end if.

	} // end else.

    return 0;

} // end label.
