/*  Copy

    Copyright (c) Marty M. Peritsky 1996.
    All Rights Reserved.

    See COPY.TXT for more details.

*/

// I N C L U D E S //////////////////////////////////////////////////////////

#include <conio.h>
#include <ctype.h>
#include <direct.h>
#include <dos.h>
#include <stdio.h>
#include <string.h>
#include "copy.h"
#include "copyhlp.h"
#include "copysubs.h"
#include "dirfns.h"
#include "strfns.h"

// D E F I N E S ////////////////////////////////////////////////////////////

#define TRUE 1
#define FALSE 0
#define DEVICENAME FILENAME

// M A C R O S //////////////////////////////////////////////////////////////

#define STRCAT2(x, y) strcat3(x, y, "")

#define CWD_IS_ROOT     (!cwd_parent_exists)
#define DWD_IS_ROOT     (!dwd_parent_exists)
#define CWD_IS_NOT_ROOT cwd_parent_exists
#define DWD_IS_NOT_ROOT dwd_parent_exists

#define FNSPLITX(x) fnsplit(x, tf.drive, tf.dir, tf.file, tf.ext)
#define FNMERGEX(x) fnmerge(x, tf.drive, tf.dir, tf.file, tf.ext)
#define FNSPLIT     FNSPLITX(fn_path)
#define FNMERGE     FNMERGEX(fn_path)

// P R O T O T Y P E S //////////////////////////////////////////////////////

static char *nextspec(char *p);
static void do_one_file(int pass);

// G L O B A L S ////////////////////////////////////////////////////////////

struct fn_parts {
    char drive[MAXDRIVE];
    char dir[MAXDIR];
    char file[MAXFILE];
    char ext[MAXEXT];
} tf;

char *myname, fn_path[MAXPATH], cwd[MAXPATH], cwd_parent[MAXPATH], *dwd, *spec[2];
char *src_fullpath, *src_drive_dir, *src_file_ext, *dest_fullpath, *dest_drive_dir, *dest_file_ext;

int src_fullpath_flags, dest_fullpath_flags, skip_this_dest, n_copied=0;
int cwd_parent_exists=FALSE, dwd_parent_exists=FALSE, spec_count=0, old_vf=-1;
int a_switch[3], b_switch[3], c_switch=FALSE,k_switch=FALSE,r_switch=FALSE, s_switch=FALSE, v_switch=FALSE, w_switch=FALSE,z_switch=FALSE;

struct ffblk filedata;

// F U N C T I O N S ////////////////////////////////////////////////////////

int main(int argc, char *argv[])
{
    char c, *cp, *p, *q, *r, *s, *t;
    int i, pass, doing_firstspec=FALSE;

    FNSPLITX(argv[0]);
    myname=strdup1(tf.file);

    if (argc == 1)
        {
        copyhlp();
        return 1;
        } // end if.

    for (i=1;i<argc;i++)
        {
        if ((strcmpi(argv[i],"/?") == 0) || (strcmpi(argv[i],"/h") == 0) || (strcmpi(argv[i],"/help") == 0))
            {
            copyhlp();
            return 1;
            } // end if.

        } // end for.

    // Parse switches and arguments.
    for (i=0;i<3;i++)
        {
        a_switch[i]=FALSE;
        b_switch[i]=FALSE;
        } // end for.

    for (i=1;i<argc;i++)
        {
        cp=argv[i];
        if (*cp == '/')
            {
            doing_firstspec=FALSE;
            if (strlen(cp) == 2)
                {
                c=toupper(*(cp+1));
                switch (c)
                    {
                    case 'A':
                        a_switch[spec_count]=TRUE;
                        break;
                    case 'B':
                        b_switch[spec_count]=TRUE;
                        break;
                    case 'C':
                        c_switch=TRUE;
                        break;
                    case 'K':
                        k_switch=TRUE;
                        break;
                    case 'R':
                        r_switch=TRUE;
                        break;
                    case 'S':
                         s_switch=TRUE;
                         break;
                    case 'V':
                        v_switch=TRUE;
                        break;
                    case 'W':
                        w_switch=TRUE;
                        break;
                    case 'Z':
                        z_switch=TRUE;
                        break;

                    default:
                        printf("Option %s is not valid.\n", cp);
                        main_exit(1);

                    } // end switch.

                } // end if.
            else
                {
                printf("Option %s is not valid.\n", cp);
                main_exit(1);
                } // end else.

            } // end if.
        else
            {
            switch (spec_count)
                {
                case 0:
                    spec[spec_count++]=strdup1(cp);
                    doing_firstspec=TRUE;
                    break;
                case 1:
                    if (doing_firstspec && (ends_with_plus(spec[0]) || starts_with_plus(cp)))
                        {
                        t=spec[0];
                        spec[0]=STRCAT2(t, cp);
                        free(t);
                        } // end if.
                    else
                        {
                        spec[spec_count++]=cp;
                        } // end else.

                    break;
                default:
                    printf("Too many file specifications.\n");
                    main_exit(1);
                    break;

                } // end switch.

            } // end else.

        } // end for.

    // Check for conflicting switches.
    if ((a_switch[0] && b_switch[0]) || (a_switch[1] && b_switch[1]))
        {
        printf("Switches /A and /B conflict.\n");
        main_exit(1);
        } // end if.

    if (a_switch[2] || b_switch[2])
        {
        printf("Switches /A and /B must come before file specifications.\n");
        main_exit(1);
        } // end if.

    // Check for missing source spec.
    if (spec_count == 0)
        {
        printf("No source files specified.\n");
        main_exit(1);
        } // end if.

    // Get current directory and parent.
    getcwd(cwd, MAXPATH); 
    strcpy(cwd_parent, cwd);
    i=strlen(cwd_parent);
    if (i > 3)
        {
        cwd_parent_exists=TRUE;
        while (cwd_parent[i] != '\\')
            cwd_parent[i--]='\0';

        } // end if.

    // Initialize the drive and working-directory.
    dwd=strdup1(cwd);
    dwd_parent_exists=cwd_parent_exists;

    // If no destination specified, make it cwd.
    if (spec_count == 1)
        spec[spec_count++]=cwd;

    // Determine full path of destination spec.
    dest_fullpath=fullpath(spec[1]);
    dest_fullpath_flags=fnsplit2(dest_fullpath, &dest_drive_dir, &dest_file_ext);

    // Set verification.
    if (v_switch)
        {
        old_vf=getverify();
        setverify(1);
        } // end if.

    // Loop over source specs, two passes.
    for (pass=0;pass<2;pass++)
        {
        p=strdup1(spec[0]);
        r=p;
        do
            {
            q=nextspec(p);
            s=fullpath(p);
            src_fullpath=s;
            src_fullpath_flags=fnsplit2(src_fullpath, &src_drive_dir, &src_file_ext);
            i=FA_NORMAL;
            if (s_switch)
                i=FA_SYSTEM | FA_HIDDEN;

            if (findfirst(s, &filedata, i) == 0)
                {
                do_one_file(pass);
                while (findnext(&filedata) == 0)
                    {
                    do_one_file(pass);
                    } // end while.

                } // end if.

            free(s);
            free(src_drive_dir);
            free(src_file_ext);
            } // end do.
        while ((p=q) != NULL);

        free(r);
        } // end for.

    main_exit(0);

} // end main.

/////////////////////////////////////////////////////////////////////////////

static char *nextspec(char *p)
{
    char *q;

    q=p;
    while ((*q != '\0') && (*q != '+'))
        q++;

    if (*q == '+')
        {
        *q='\0';
        return ++q;
        } // end if.
    else
        {
        return NULL;
        } // end else.

} // end nextspec.

/////////////////////////////////////////////////////////////////////////////

void main_exit(int code)
{
    if (old_vf > -1)
        setverify(old_vf);

    printf("%d file(s) copied.\n", n_copied);
    if (code != 0)
        printf("Uns");
    else
        printf("S");

    printf("uccessful termination.\n");
    exit(code);

} // end main_exit.

/////////////////////////////////////////////////////////////////////////////

static void do_one_file(int pass)
{
    char *src_arg, *dest_arg, *temp;
    int g, appnd, ab_in, ab_out, exist_warning, dest_file_exists, dest_file_newer;
    int src_is_dev, dest_is_dev;
    struct ffblk fd;

    src_arg=STRCAT2(src_drive_dir, filedata.ff_name);
    if ((dest_fullpath_flags & WILDCARDS) != 0)
        {
        temp=newname(filedata.ff_name, dest_file_ext);
        dest_arg=STRCAT2(dest_drive_dir, temp);
        free(temp);
        } // end if.
    else
        {
        dest_arg=strdup1(dest_fullpath);
        } // end else.

    str_toupper(src_arg);
    str_toupper(dest_arg);
    src_is_dev=(src_fullpath_flags == DEVICENAME);
    if (src_is_dev && ((dest_fullpath_flags & WILDCARDS) != 0))
        {
        printf("Destination wildcards not permitted when source is %s\n", src_file_ext);
        main_exit(1);
        } // end if.

    if (pass == 0)
        {
        if (strcmpi(src_arg, dest_arg) == 0)
            {
            printf("Cannot copy %s onto itself.\n", src_arg);
            main_exit(1);
            } // end if.

        } // end if.
    else
        {
        if (strcmpi(src_arg, dest_arg) != 0)
            {
            dest_is_dev=(dest_fullpath_flags == DEVICENAME);
            dest_file_exists=(((!dest_is_dev) && ( k_switch || r_switch || w_switch)) ? (findfirst(dest_arg, &fd, FA_SYSTEM | FA_HIDDEN) == 0) : FALSE);
            dest_file_newer=(((!dest_file_exists) || src_is_dev) ? FALSE : ((((unsigned) fd.ff_fdate) > ((unsigned) filedata.ff_fdate)) ? TRUE : ((fd.ff_fdate == filedata.ff_fdate) && (((unsigned) fd.ff_ftime) >= ((unsigned) filedata.ff_ftime)))));

            // The (unsigned) cast operators in the above statement are
            // needed because of a bug in the Power C header files; the
            // ff_fdate and ff_ftime variables should have been declared
            // as unsigned rather than as int originally.
            if (r_switch && (!dest_is_dev) && (!dest_file_exists))
                {
                printf("Skipping source %s;\n", src_arg);
                printf("   destination %s doesn't exist.\n", dest_arg);
                } // end if.
            else
                {
                if (k_switch && dest_file_newer)
                    {
                    printf("Skipping source %s;\n", src_arg);
                    printf("   file isn't newer than %s\n", dest_arg);
                    } // end if.
                else
                    {
                    if ((!dest_is_dev) && ((dest_fullpath_flags & WILDCARDS) == 0) && (n_copied > 0))
                        {
                        printf("Appending %s to %s\n", src_arg, dest_arg);
                        appnd=TRUE;
                        } // end if.
                    else
                        {
                        printf("Copying %s to %s\n", src_arg, dest_arg);
                        appnd=FALSE;
                        } // end else.

                    ab_in=(dest_is_dev || a_switch[0]);
                    ab_out=a_switch[1];
                    exist_warning=FALSE;
                    if (w_switch && dest_file_exists)
                        {
                        exist_warning=TRUE;
                        printf("Destination file already exists.\n");
                        } // end if.

                    g='Y';
                    if (c_switch || exist_warning)
                        {
                        do
                            {
                            printf("Do the copy operation? [Y]es (default), [N]o, [S]top?");
                            g=toupper(getche());
                            printf("\n");
                            } // end do.
                        while (strchr("YNS\r", g) == NULL);

                        } // end if.

                    switch (g)
                        {
                        case '\r':
                        case 'Y':
                            printf("Working...\n");
                            copy1(src_arg, ab_in, dest_arg, ab_out, appnd, z_switch, ((!src_is_dev) && (!dest_is_dev) && (!appnd)));
                            n_copied++;
                            break;
                        case 'N':
                            break;
                        case 'S':
                            printf("Program halted at user's request.\n");
                            main_exit(0);
                            break;

                        } // end switch.

                    } // end else.

                } // end else.

            } // end if.

        } // end else.

    free(src_arg); free(dest_arg);

} // end do_one_file.
