/* $Id: hello.c,v 1.6.2.2 2002/01/22 19:49:33 tm Exp $
 * PDFlib client: hello example in C
 *
 */

#include <stdio.h>
#include <stdlib.h>

#include "pdflib.h"

int
main(void)
{
    PDF *p;
    int font;

    p = PDF_new();

    /* open new PDF file */
    if (PDF_open_file(p, "hello.pdf") == -1) {
	fprintf(stderr, "Error: cannot open PDF file hello.pdf.\n");
	exit(2);
    }

    PDF_set_info(p, "Creator", "hello.c");
    PDF_set_info(p, "Author", "Thomas Merz");
    PDF_set_info(p, "Title", "Hello, world (C)!");

    PDF_begin_page(p, a4_width, a4_height);	/* start a new page	*/

    /* Change "host" encoding to "winansi" or whatever you need! */
    font = PDF_findfont(p, "Helvetica-Bold", "host", 0);

    PDF_setfont(p, font, 24);
    PDF_set_text_pos(p, 50, 700);
    PDF_show(p, "Hello, world!");
    PDF_continue_text(p, "(says C)");
    PDF_end_page(p);				/* close page		*/

    PDF_close(p);				/* close PDF document	*/

    PDF_delete(p);				/* delete the PDF object */

    return 0;
}
