/* $Id: personalizeServlet.java,v 1.1.2.3 2002/01/28 17:33:42 rp Exp $
 *
 * PDFlib/PDI client: personalization demo
 */

import java.io.*;
import java.text.*;		// DateFormat
import java.util.*;		// Date
import javax.servlet.*;
import com.pdflib.pdflib;

public class personalizeServlet extends GenericServlet
{
    public void service (ServletRequest request, ServletResponse response) throws
	OutOfMemoryError, IOException, IllegalArgumentException,
	IndexOutOfBoundsException, ClassCastException, ArithmeticException,
	RuntimeException, InternalError, UnknownError
    {
	int form, page, font;
	float width, height;
	pdflib p;
	Date now = new Date();
	DateFormat fulldate = DateFormat.getDateInstance(DateFormat.LONG); 
	String infile = "PDFlib-purchase-order.pdf";
	final int col1 = 70, col2 = 335;

	p = new pdflib();
	byte[] buf;
	ServletOutputStream out;

	p.open_file("");

	p.set_info("Creator", "personalizeServlet.java");
	p.set_info("Author", "Rainer Ploeckl");
	p.set_info("Title", "PDFlib personalization demo (Java)");

	form = p.open_pdi(infile, "", 0);
	if (form == -1) {
	    System.err.println("Couldn't open input file '" + infile + "'.\n");
	    System.exit(1);
	}

	page = p.open_pdi_page(form, 1, "");
	if (page == -1) {
	    System.err.println("Couldn't open page 1 in '" + infile + "'.\n");
	    System.exit(1);
	}

	font = p.findfont("Helvetica-Bold", "host", 0);

	// get the dimensions of the imported form
	width = p.get_pdi_value("width", form, page, 0);
	height = p.get_pdi_value("height", form, page, 0);

	p.begin_page(width, height);
	p.place_pdi_page(page, 0, 0, 1, 1);
	p.close_pdi_page(page);

	p.setfont(font, 18);
	p.set_value("leading", 24);
	p.set_text_pos(col1, 486);

	p.show("Doublecheck, Inc.");
	p.continue_text("Petra Porst");
	p.continue_text("500, Market St.");
	p.continue_text("94110 San Francisco, CA");
	p.continue_text("");
	p.continue_text("USA");
	p.continue_text("+1/950/123-4567");
	p.continue_text("+1/950/123-4568");
	p.continue_text("");
	p.set_text_pos(col1, 278);
	p.show("petra@doublecheck.com");

	p.set_text_pos(col2, 104);
	p.continue_text(fulldate.format(now));

	p.end_page();

	p.close();
	p.close_pdi(form);

	buf = p.get_buffer();

	response.setContentType("application/pdf");
	response.setContentLength(buf.length);

	out = response.getOutputStream();
	out.write(buf);
	out.close();

    }
}
