. $MYPWD/../locations.include
TREE=$1
if [ ! -d $1 ]; then
    echo "First parameter must be the directory to place at the root of the CD"
    exit 1
fi

DEST=$2
if [ -z "$2" ]; then
    echo "Second parameter must be the name of the final iso image."
    exit 1
fi

echo "Creating $2 from $1..."
cd $TREE
BOOTIMG="isolinux/isolinux.bin"
echo "Boot image is" $BOOTIMG
BOOTCAT="isolinux/boot.cat"
BOOTOPTS="-no-emul-boot -boot-load-size 4 -boot-info-table"

# Create the image (This is for disk 1)

mkisofs \
	-A "$VERSION DISC1" \
	-V "$VERSION" \
	-R -l -v -J \
	-x ./lost+found \
        -c $BOOTCAT $BOOTOPTS \
 	-b $BOOTIMG \
	-o $DEST \
	. 
