MYPWD=`pwd`
up1=`dirname $MYPWD`
up2=`dirname $up1`
site=`basename $up2`
if [ "$site" = "example" ] ; then
	continue
else
   echo "You must be in the /sites/example/build/scripts directory to run this script"
   exit
fi
if [ ! -d /usr/lib/anaconda ] ; then
   echo "You need to have the anaconda rpm installed. "
   echo "You can use \"yum\" to install it for you. "
   echo "yum install anaconda"
   exit
fi
if [ ! -d /usr/lib/anaconda-runtime ] ; then
   echo "You need to have the anaconda-runtime rpm installed. "
   echo "You can use \"yum\" to install it for you. "
   echo "yum install anaconda-runtime"
   exit
fi
up3=`dirname $up2`
up4=`dirname $up3`
arch=`basename $up4`
up5=`dirname $up4`
echo "Would you like to make a new site based on the example site? y or n?"
read answer
if [ "$answer" = "y" ] ; then
   echo "Enter site name please"
   read site
   export site
   echo "Making new site based on example site in $up3/$site"
   mkdir -p $up3/$site
   echo "Copying over new site to $up3/$site"
   rsync -va --exclude=\*.iso $up3/example/  $up3/$site
   cd $up3/$site/build/scripts
   echo "Changing $up3/$site files for new site"
   sh ./transform.sh
   echo " ----------------------------------------------------"
else
   echo "Would you like to make a new site based on a full release tree? y or n?"
   read answer
   if [ "$answer" = "y" ] ; then
        echo "Enter site name please"
        read site
        export site
        echo "Making new site $site"
	echo "-------------------------------------------------------------"
        echo "Enter full pathname of Scientific Linux 3.0.1 release with the arch"
        echo "as the last directory"
        read tree 
	DEFAULT=SL
	if [ ! -d $tree/$DEFAULT/RPMS ] ; then
  		echo "The Scientific Linux directory $tree does not exist."
  		exit
	fi
        export tree 
	echo "-------------------------------------------------------------"
        echo "Making new site in $tree/sites/$site/"
	echo "Running ./make.site.from.release.sh now"
	echo "-------------------------------------------------------------"
	sh ./make.site.from.release.sh
        cd $tree/sites/$site/build/scripts
	sh ./transform.sh
	echo "-------------------------------------------------------------"
   else
	echo "The only choices in this script are to create a site from"
        echo "    the existing example site or"
	echo "    from a full release tree"
	exit 
   fi
fi
