untrusted comment: verify with openbsd-70-base.pub
RWR3KL+gSr4QZxE0M+VW6yJr8tMwrk7RjurX/Ism7+KiHBbvd41hmtdPPQt5Pxp6OxivIlmJw0nCmM3K/NiDjNhaUhQ/DF6tRgI=

OpenBSD 7.0 errata 003, October 31, 2021:

The kernel could leak memory when closing unix sockets.

Apply by doing:
    signify -Vep /etc/signify/openbsd-70-base.pub -x 003_uipc.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/kern/uipc_usrreq.c
===================================================================
RCS file: /cvs/src/sys/kern/uipc_usrreq.c,v
retrieving revision 1.148
diff -u -p -r1.148 uipc_usrreq.c
--- sys/kern/uipc_usrreq.c	25 May 2021 22:45:09 -0000	1.148
+++ sys/kern/uipc_usrreq.c	25 Oct 2021 18:51:41 -0000
@@ -300,7 +300,13 @@ uipc_usrreq(struct socket *so, int req, 
 		break;
 
 	case PRU_ABORT:
-		unp_drop(unp, ECONNABORTED);
+		unp_detach(unp);
+		/*
+		 * As long as `unp_lock' is taken before entering
+		 * uipc_usrreq() releasing it here would lead to a
+		 * double unlock.
+		 */
+		sofree(so, SL_NOUNLOCK);
 		break;
 
 	case PRU_SENSE: {
