/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httpsessions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.zaproxy.zap.extension.httpsessions.ExtensionHttpSessions;
import org.zaproxy.zap.extension.httpsessions.HttpSession;
import org.zaproxy.zap.extension.httpsessions.HttpSessionsPanel;
import org.zaproxy.zap.extension.httpsessions.HttpSessionsSite;

public class PopupMenuSetActiveSession
extends ExtensionPopupMenuItem {
    private static final long serialVersionUID = 1L;
    private ExtensionHttpSessions extension;

    public PopupMenuSetActiveSession() {
        super(Constant.messages.getString("httpsessions.popup.session.active.set"));
        this.initialize();
    }

    public void setExtension(ExtensionHttpSessions extension) {
        this.extension = extension;
    }

    private void initialize() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HttpSessionsPanel panel = PopupMenuSetActiveSession.this.extension.getHttpSessionsPanel();
                HttpSessionsSite site = panel.getCurrentHttpSessionSite();
                if (site == null) {
                    return;
                }
                HttpSession item = panel.getSelectedSession();
                site.setActiveSession(item);
            }
        });
    }

    @Override
    public boolean isEnableForComponent(Component invoker) {
        HttpSession item;
        if (invoker.getName() != null && invoker.getName().equals("httpsessions") && (item = this.extension.getHttpSessionsPanel().getSelectedSession()) != null) {
            return !item.isActive();
        }
        return false;
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

