/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.NetworkInterfaceAttributeDescription;
import com.amazon.aes.webservices.client.NetworkInterfaceAttributeType;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class DescribeNetworkInterfaceAttribute
extends BaseCmd {
    private static final String[] DESCRIPTION_DESC = new String[]{"Get the description of the network interface."};
    private static final String[] SOURCE_DEST_CHECK_DESC = new String[]{"Gets whether to enable the source/dest check on traffic through this network interface.", "Valid options are 'true' and 'false'."};
    private static final String[] GROUP_SET_DESC = new String[]{"Get the security groups for the network interface."};
    private static final String[] ATTACHMENT_DESC = new String[]{"Get the attachment (if any) of the network interface."};
    private String networkInterfaceId;
    private NetworkInterfaceAttributeType type;

    public DescribeNetworkInterfaceAttribute(String[] args) {
        super("ec2dnicatt", "ec2-describe-network-interface-attribute");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        result.addOption(DescribeNetworkInterfaceAttribute.createOption("d", "description", DESCRIPTION_DESC));
        result.addOption(DescribeNetworkInterfaceAttribute.createOption(null, "source-dest-check", SOURCE_DEST_CHECK_DESC));
        result.addOption(DescribeNetworkInterfaceAttribute.createOption(null, "group-set", GROUP_SET_DESC));
        result.addOption(DescribeNetworkInterfaceAttribute.createOption("a", "attachment", ATTACHMENT_DESC));
        return result;
    }

    @Override
    protected String getOptionString() {
        return "NETWORKINTERFACE";
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("description");
        this.printOption("source-dest-check");
        this.printOption("group-set");
        this.printOption("attachment");
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Describes a network interface attribute. Only one attribute can be specified");
        System.out.println("     per call.");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        RequestResultPair rsp = jec2.describeNetworkInterfaceAttribute(this.networkInterfaceId, this.type);
        out.printRequestId(System.out, (RequestResult)rsp);
        out.output(System.out, (NetworkInterfaceAttributeDescription)rsp.getResponse());
        return true;
    }

    protected void validateParameters() {
        this.assertNonOptionSet("NETWORKINTERFACE");
        this.networkInterfaceId = this.getNonOptions()[0];
        this.assertOnlyOneOptionSet(new String[]{"description", "source-dest-check", "group-set", "attachment"});
        this.warnIfTooManyNonOptions();
        if (this.isOptionSet("description")) {
            this.type = NetworkInterfaceAttributeType.description;
        } else if (this.isOptionSet("source-dest-check")) {
            this.type = NetworkInterfaceAttributeType.sourceDestCheck;
        } else if (this.isOptionSet("group-set")) {
            this.type = NetworkInterfaceAttributeType.group;
        } else if (this.isOptionSet("attachment")) {
            this.type = NetworkInterfaceAttributeType.attachment;
        }
    }

    public static void main(String[] args) {
        new DescribeNetworkInterfaceAttribute(args).invoke();
    }
}

