/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.notificators;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.model.Event;
import org.traccar.model.ObjectOperation;
import org.traccar.model.Position;
import org.traccar.model.User;
import org.traccar.notification.NotificationFormatter;
import org.traccar.notification.NotificationMessage;
import org.traccar.notificators.Notificator;
import org.traccar.session.cache.CacheManager;
import org.traccar.storage.Storage;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@Singleton
public class NotificatorTraccar
extends Notificator {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotificatorTraccar.class);
    private final Client client;
    private final Storage storage;
    private final CacheManager cacheManager;
    private final String url;
    private final String key;

    @Inject
    public NotificatorTraccar(Config config, NotificationFormatter notificationFormatter, Client client, Storage storage, CacheManager cacheManager) {
        super(notificationFormatter);
        this.client = client;
        this.storage = storage;
        this.cacheManager = cacheManager;
        this.url = "https://www.traccar.org/push/";
        this.key = config.getString(Keys.NOTIFICATOR_TRACCAR_KEY);
    }

    @Override
    public void send(User user, NotificationMessage shortMessage, Event event, Position position) {
        if (user.hasAttribute("notificationTokens")) {
            NotificationObject item = new NotificationObject();
            item.title = shortMessage.subject();
            item.body = shortMessage.digest();
            item.sound = "default";
            String[] tokenArray = user.getString("notificationTokens").split("[, ]");
            ArrayList<String> registrationTokens = new ArrayList<String>(Arrays.asList(tokenArray));
            Message message = new Message();
            message.tokens = user.getString("notificationTokens").split("[, ]");
            message.notification = item;
            Invocation.Builder request = this.client.target(this.url).request().header("Authorization", (Object)("key=" + this.key));
            try (Response result = request.post(Entity.json((Object)message));){
                JsonObject json = (JsonObject)result.readEntity(JsonObject.class);
                LinkedList<String> failedTokens = new LinkedList<String>();
                JsonArray responses = json.getJsonArray("responses");
                for (int i = 0; i < responses.size(); ++i) {
                    JsonObject response = responses.getJsonObject(i);
                    if (response.getBoolean("success")) continue;
                    JsonObject error = response.getJsonObject("error");
                    String errorCode = error.getString("code");
                    if (errorCode.equals("messaging/invalid-argument") || errorCode.equals("messaging/registration-token-not-registered")) {
                        failedTokens.add((String)registrationTokens.get(i));
                    }
                    LOGGER.warn("Push user {} error - {}", (Object)user.getId(), (Object)error.getString("message"));
                }
                if (!failedTokens.isEmpty()) {
                    registrationTokens.removeAll(failedTokens);
                    if (registrationTokens.isEmpty()) {
                        user.removeAttribute("notificationTokens");
                    } else {
                        user.set("notificationTokens", String.join((CharSequence)",", registrationTokens));
                    }
                    this.storage.updateObject(user, new Request((Columns)new Columns.Include("attributes"), new Condition.Equals("id", user.getId())));
                    this.cacheManager.invalidateObject(true, User.class, user.getId(), ObjectOperation.UPDATE);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Push error", (Throwable)e);
            }
        }
    }

    public static class NotificationObject {
        @JsonProperty(value="title")
        private String title;
        @JsonProperty(value="body")
        private String body;
        @JsonProperty(value="sound")
        private String sound;
    }

    public static class Message {
        @JsonProperty(value="registration_ids")
        private String[] tokens;
        @JsonProperty(value="notification")
        private NotificationObject notification;
    }
}

