/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.dispatch;

import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.model.Factory;
import org.eclipse.jdt.internal.compiler.apt.util.ManyToMany;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;

public class AnnotationDiscoveryVisitor
extends ASTVisitor {
    final BaseProcessingEnvImpl _env;
    final Factory _factory;
    final ManyToMany<TypeElement, Element> _annoToElement;

    public AnnotationDiscoveryVisitor(BaseProcessingEnvImpl env) {
        this._env = env;
        this._factory = env.getFactory();
        this._annoToElement = new ManyToMany();
    }

    @Override
    public boolean visit(Argument argument, BlockScope scope) {
        Annotation[] annotations = argument.annotations;
        if (annotations != null) {
            TypeDeclaration typeDeclaration = scope.referenceType();
            typeDeclaration.binding.resolveTypesFor(((AbstractMethodDeclaration)scope.referenceContext()).binding);
            this.resolveAnnotations(scope, annotations, argument.binding);
        }
        return false;
    }

    @Override
    public boolean visit(ConstructorDeclaration constructorDeclaration, ClassScope scope) {
        Argument[] arguments;
        Annotation[] annotations = constructorDeclaration.annotations;
        if (annotations != null) {
            this.resolveAnnotations(constructorDeclaration.scope, annotations, constructorDeclaration.binding);
        }
        if ((arguments = constructorDeclaration.arguments) != null) {
            int argumentLength = arguments.length;
            int i = 0;
            while (i < argumentLength) {
                arguments[i].traverse((ASTVisitor)this, constructorDeclaration.scope);
                ++i;
            }
        }
        return false;
    }

    @Override
    public boolean visit(FieldDeclaration fieldDeclaration, MethodScope scope) {
        Annotation[] annotations = fieldDeclaration.annotations;
        if (annotations != null) {
            this.resolveAnnotations(scope, annotations, fieldDeclaration.binding);
        }
        return false;
    }

    @Override
    public boolean visit(MethodDeclaration methodDeclaration, ClassScope scope) {
        Argument[] arguments;
        Annotation[] annotations = methodDeclaration.annotations;
        if (annotations != null) {
            this.resolveAnnotations(methodDeclaration.scope, annotations, methodDeclaration.binding);
        }
        if ((arguments = methodDeclaration.arguments) != null) {
            int argumentLength = arguments.length;
            int i = 0;
            while (i < argumentLength) {
                arguments[i].traverse((ASTVisitor)this, methodDeclaration.scope);
                ++i;
            }
        }
        return false;
    }

    @Override
    public boolean visit(TypeDeclaration memberTypeDeclaration, ClassScope scope) {
        Annotation[] annotations = memberTypeDeclaration.annotations;
        if (annotations != null) {
            this.resolveAnnotations(memberTypeDeclaration.staticInitializerScope, annotations, memberTypeDeclaration.binding);
        }
        return true;
    }

    @Override
    public boolean visit(TypeDeclaration typeDeclaration, CompilationUnitScope scope) {
        Annotation[] annotations = typeDeclaration.annotations;
        if (annotations != null) {
            this.resolveAnnotations(typeDeclaration.staticInitializerScope, annotations, typeDeclaration.binding);
        }
        return true;
    }

    private void resolveAnnotations(BlockScope scope, Annotation[] annotations, Binding currentBinding) {
        ASTNode.resolveAnnotations(scope, annotations, currentBinding);
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            AnnotationBinding binding = annotation.getCompilerAnnotation();
            if (binding != null) {
                TypeElement anno = (TypeElement)this._factory.newElement(binding.getAnnotationType());
                Element element = this._factory.newElement(currentBinding);
                this._annoToElement.put(anno, element);
            }
            ++n2;
        }
    }
}

