//
// RWLock_WINCE.h
//
// $Id: //poco/1.4/Foundation/include/Poco/RWLock_WINCE.h#1 $
//
// Library: Foundation
// Package: Threading
// Module:  RWLock
//
// Definition of the RWLockImpl class for WINCE.
//
// Copyright (c) 2009-2010, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef Foundation_RWLock_WINCE_INCLUDED
#define Foundation_RWLock_WINCE_INCLUDED


#include "Poco/Foundation.h"
#include "Poco/Exception.h"
#include "Poco/UnWindows.h"


namespace Poco {


class Foundation_API RWLockImpl
	/// This implementation is based on the one from Stone Steps Inc,
	/// licensed under the BSD license.
	/// http://forums.stonesteps.ca/thread.asp?t=105
	///
	/// Note that with this implementation, writers always take
	/// precedence over readers.
{
protected:
	RWLockImpl();
	~RWLockImpl();
	void readLockImpl();
	bool tryReadLockImpl(DWORD timeout = 1);
	void writeLockImpl();
	bool tryWriteLockImpl(DWORD timeout = 1);
	void unlockImpl();
	
private:
	DWORD _readerCount;
	DWORD _readerWaiting;
	DWORD _writerCount;
	DWORD _writerWaiting;
	HANDLE _readerGreen;
	HANDLE _writerGreen;
	CRITICAL_SECTION _cs;
	bool _writeLock;
};


} // namespace Poco


#endif // Foundation_RWLock_WINCE_INCLUDED
