/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * abs(ivec3(-5, -2, -1)) => ivec3(5, 2, 1)
 * abs(ivec3(0, 1, 2)) => ivec3(0, 1, 2)
 * abs(ivec3(5, -5, -2)) => ivec3(5, 5, 2)
 */
#version 130

void main()
{
  float[all(equal(abs(ivec3(-5, -2, -1)), ivec3(5, 2, 1))) ? 1 : -1] array0;
  float[all(equal(abs(ivec3(0, 1, 2)), ivec3(0, 1, 2))) ? 1 : -1] array1;
  float[all(equal(abs(ivec3(5, -5, -2)), ivec3(5, 5, 2))) ? 1 : -1] array2;
  gl_Position = vec4(array0.length() + array1.length() + array2.length());
}
