/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) << uvec3(22u, 23u, 4u)) => u64vec3(16612971250515443712ul, 713031680ul, 1504ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) << uvec3(19u, 1u, 13u)) => u64vec3(11299993443169206272ul, 170ul, 770048ul)
 * (u64vec3(167ul, 66ul, 187ul) << uvec3(22u, 23u, 4u)) => u64vec3(700448768ul, 553648128ul, 2992ul)
 * (u64vec3(167ul, 66ul, 187ul) << uvec3(19u, 1u, 13u)) => u64vec3(87556096ul, 132ul, 1531904ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) << uvec3(22u, 23u, 4u)), u64vec3(16612971250515443712ul, 713031680ul, 1504ul))) ? 1 : -1] array0;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) << uvec3(19u, 1u, 13u)), u64vec3(11299993443169206272ul, 170ul, 770048ul))) ? 1 : -1] array1;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) << uvec3(22u, 23u, 4u)), u64vec3(700448768ul, 553648128ul, 2992ul))) ? 1 : -1] array2;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) << uvec3(19u, 1u, 13u)), u64vec3(87556096ul, 132ul, 1531904ul))) ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
