/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * dot(dvec2(-0.1lf, -1.2lf), dvec2(-0.1lf, -1.2lf)) => 1.45lf
 * dot(dvec2(-0.1lf, -1.2lf), dvec2(-0.42lf, 0.48lf)) => -0.5339999999999999lf
 * dot(dvec2(-0.42lf, 0.48lf), dvec2(-0.1lf, -1.2lf)) => -0.5339999999999999lf
 * dot(dvec2(-0.42lf, 0.48lf), dvec2(-0.42lf, 0.48lf)) => 0.40679999999999994lf
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(dot(dvec2(-0.1lf, -1.2lf), dvec2(-0.1lf, -1.2lf)), 1.45lf) <= 1.45e-05lf ? 1 : -1] array0;
  double[distance(dot(dvec2(-0.1lf, -1.2lf), dvec2(-0.42lf, 0.48lf)), -0.5339999999999999lf) <= 5.34e-06lf ? 1 : -1] array1;
  double[distance(dot(dvec2(-0.42lf, 0.48lf), dvec2(-0.1lf, -1.2lf)), -0.5339999999999999lf) <= 5.34e-06lf ? 1 : -1] array2;
  double[distance(dot(dvec2(-0.42lf, 0.48lf), dvec2(-0.42lf, 0.48lf)), 0.40679999999999994lf) <= 4.068e-06lf ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
