/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.message;

import gov.nist.javax.sip.message.Content;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.sip.header.ContentDispositionHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.Header;

public class ContentImpl
implements Content {
    private Object content;
    private ContentTypeHeader contentTypeHeader;
    private ContentDispositionHeader contentDispositionHeader;
    private List<Header> extensionHeaders = new ArrayList<Header>();

    public ContentImpl(String content) {
        this.content = content;
    }

    @Override
    public void setContent(Object content) {
        this.content = content;
    }

    @Override
    public ContentTypeHeader getContentTypeHeader() {
        return this.contentTypeHeader;
    }

    @Override
    public Object getContent() {
        return this.content;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.contentTypeHeader != null) {
            result.append(this.contentTypeHeader.toString());
        }
        if (this.contentDispositionHeader != null) {
            result.append(this.contentDispositionHeader.toString());
        }
        for (Header header : this.extensionHeaders) {
            result.append(header);
        }
        result.append("\r\n");
        result.append(this.content.toString());
        return result.toString();
    }

    public void setContentDispositionHeader(ContentDispositionHeader contentDispositionHeader) {
        this.contentDispositionHeader = contentDispositionHeader;
    }

    @Override
    public ContentDispositionHeader getContentDispositionHeader() {
        return this.contentDispositionHeader;
    }

    public void setContentTypeHeader(ContentTypeHeader contentTypeHeader) {
        this.contentTypeHeader = contentTypeHeader;
    }

    public void addExtensionHeader(Header header) {
        this.extensionHeaders.add(header);
    }

    @Override
    public Iterator<Header> getExtensionHeaders() {
        return this.extensionHeaders.iterator();
    }
}

