/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.registry;

import java.io.FilePermission;
import java.io.IOException;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationID;
import java.rmi.registry.Registry;
import java.rmi.server.ObjID;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UID;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.security.cert.Certificate;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import sun.misc.ObjectInputFilter;
import sun.misc.URLClassPath;
import sun.rmi.runtime.Log;
import sun.rmi.server.LoaderHandler;
import sun.rmi.server.UnicastRef;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.server.UnicastServerRef2;
import sun.rmi.transport.LiveRef;

public class RegistryImpl
extends RemoteServer
implements Registry {
    private static final long serialVersionUID = 4666870661827494597L;
    private Hashtable<String, Remote> bindings = new Hashtable(101);
    private static Hashtable<InetAddress, InetAddress> allowedAccessCache = new Hashtable(3);
    private static RegistryImpl registry;
    private static ObjID id;
    private static ResourceBundle resources;
    private static final String REGISTRY_FILTER_PROPNAME = "sun.rmi.registry.registryFilter";
    private static final int REGISTRY_MAX_DEPTH = 20;
    private static final int REGISTRY_MAX_ARRAY_SIZE = 1000000;
    private static final ObjectInputFilter registryFilter;

    private static ObjectInputFilter initRegistryFilter() {
        ObjectInputFilter objectInputFilter = null;
        String string = System.getProperty(REGISTRY_FILTER_PROPNAME);
        if (string == null) {
            string = Security.getProperty(REGISTRY_FILTER_PROPNAME);
        }
        if (string != null) {
            objectInputFilter = ObjectInputFilter.Config.createFilter2(string);
            Log log = Log.getLog("sun.rmi.registry", "registry", -1);
            if (log.isLoggable(Log.BRIEF)) {
                log.log(Log.BRIEF, "registryFilter = " + objectInputFilter);
            }
        }
        return objectInputFilter;
    }

    public RegistryImpl(int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
        this(n, rMIClientSocketFactory, rMIServerSocketFactory, RegistryImpl::registryFilter);
    }

    public RegistryImpl(final int n, final RMIClientSocketFactory rMIClientSocketFactory, final RMIServerSocketFactory rMIServerSocketFactory, final ObjectInputFilter objectInputFilter) throws RemoteException {
        if (n == 1099 && System.getSecurityManager() != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws RemoteException {
                        LiveRef liveRef = new LiveRef(id, n, rMIClientSocketFactory, rMIServerSocketFactory);
                        RegistryImpl.this.setup(new UnicastServerRef2(liveRef, objectInputFilter));
                        return null;
                    }
                }, null, new SocketPermission("localhost:" + n, "listen,accept"));
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (RemoteException)privilegedActionException.getException();
            }
        } else {
            LiveRef liveRef = new LiveRef(id, n, rMIClientSocketFactory, rMIServerSocketFactory);
            this.setup(new UnicastServerRef2(liveRef, objectInputFilter));
        }
    }

    public RegistryImpl(final int n) throws RemoteException {
        if (n == 1099 && System.getSecurityManager() != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws RemoteException {
                        LiveRef liveRef = new LiveRef(id, n);
                        RegistryImpl.this.setup(new UnicastServerRef(liveRef, filterInfo -> RegistryImpl.registryFilter(filterInfo)));
                        return null;
                    }
                }, null, new SocketPermission("localhost:" + n, "listen,accept"));
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (RemoteException)privilegedActionException.getException();
            }
        } else {
            LiveRef liveRef = new LiveRef(id, n);
            this.setup(new UnicastServerRef(liveRef, RegistryImpl::registryFilter));
        }
    }

    private void setup(UnicastServerRef unicastServerRef) throws RemoteException {
        this.ref = unicastServerRef;
        unicastServerRef.exportObject(this, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Remote lookup(String string) throws RemoteException, NotBoundException {
        Hashtable<String, Remote> hashtable = this.bindings;
        synchronized (hashtable) {
            Remote remote = this.bindings.get(string);
            if (remote == null) {
                throw new NotBoundException(string);
            }
            return remote;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(String string, Remote remote) throws RemoteException, AlreadyBoundException, AccessException {
        Hashtable<String, Remote> hashtable = this.bindings;
        synchronized (hashtable) {
            Remote remote2 = this.bindings.get(string);
            if (remote2 != null) {
                throw new AlreadyBoundException(string);
            }
            this.bindings.put(string, remote);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(String string) throws RemoteException, NotBoundException, AccessException {
        Hashtable<String, Remote> hashtable = this.bindings;
        synchronized (hashtable) {
            Remote remote = this.bindings.get(string);
            if (remote == null) {
                throw new NotBoundException(string);
            }
            this.bindings.remove(string);
        }
    }

    @Override
    public void rebind(String string, Remote remote) throws RemoteException, AccessException {
        this.bindings.put(string, remote);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] list() throws RemoteException {
        String[] stringArray;
        Hashtable<String, Remote> hashtable = this.bindings;
        synchronized (hashtable) {
            int n = this.bindings.size();
            stringArray = new String[n];
            Enumeration<String> enumeration = this.bindings.keys();
            while (--n >= 0) {
                stringArray[n] = enumeration.nextElement();
            }
        }
        return stringArray;
    }

    public static void checkAccess(String string) throws AccessException {
        block8: {
            try {
                InetAddress inetAddress;
                final String string2 = RegistryImpl.getClientHost();
                try {
                    inetAddress = AccessController.doPrivileged(new PrivilegedExceptionAction<InetAddress>(){

                        @Override
                        public InetAddress run() throws UnknownHostException {
                            return InetAddress.getByName(string2);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (UnknownHostException)privilegedActionException.getException();
                }
                if (allowedAccessCache.get(inetAddress) != null) break block8;
                if (inetAddress.isAnyLocalAddress()) {
                    throw new AccessException(string + " disallowed; origin unknown");
                }
                try {
                    final InetAddress inetAddress2 = inetAddress;
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws IOException {
                            new ServerSocket(0, 10, inetAddress2).close();
                            allowedAccessCache.put(inetAddress2, inetAddress2);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw new AccessException(string + " disallowed; origin " + inetAddress + " is non-local host");
                }
            }
            catch (ServerNotActiveException serverNotActiveException) {
            }
            catch (UnknownHostException unknownHostException) {
                throw new AccessException(string + " disallowed; origin is unknown host");
            }
        }
    }

    public static ObjID getID() {
        return id;
    }

    private static String getTextResource(String string) {
        if (resources == null) {
            try {
                resources = ResourceBundle.getBundle("sun.rmi.registry.resources.rmiregistry");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (resources == null) {
                return "[missing resource file: " + string + "]";
            }
        }
        String string2 = null;
        try {
            string2 = resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (string2 == null) {
            return "[missing resource: " + string + "]";
        }
        return string2;
    }

    private static ObjectInputFilter.Status registryFilter(ObjectInputFilter.FilterInfo filterInfo) {
        Object object;
        if (registryFilter != null && (object = registryFilter.checkInput(filterInfo)) != ObjectInputFilter.Status.UNDECIDED) {
            return object;
        }
        if (filterInfo.depth() > 20L) {
            return ObjectInputFilter.Status.REJECTED;
        }
        object = filterInfo.serialClass();
        if (object != null) {
            if (((Class)object).isArray()) {
                return filterInfo.arrayLength() >= 0L && filterInfo.arrayLength() > 1000000L ? ObjectInputFilter.Status.REJECTED : ObjectInputFilter.Status.UNDECIDED;
            }
            if (String.class == object || Number.class.isAssignableFrom((Class<?>)object) || Remote.class.isAssignableFrom((Class<?>)object) || Proxy.class.isAssignableFrom((Class<?>)object) || UnicastRef.class.isAssignableFrom((Class<?>)object) || RMIClientSocketFactory.class.isAssignableFrom((Class<?>)object) || RMIServerSocketFactory.class.isAssignableFrom((Class<?>)object) || ActivationID.class.isAssignableFrom((Class<?>)object) || UID.class.isAssignableFrom((Class<?>)object)) {
                return ObjectInputFilter.Status.ALLOWED;
            }
            return ObjectInputFilter.Status.REJECTED;
        }
        return ObjectInputFilter.Status.UNDECIDED;
    }

    public static void main(String[] stringArray) {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        try {
            String string = System.getProperty("env.class.path");
            if (string == null) {
                string = ".";
            }
            URL[] uRLArray = URLClassPath.pathToURLs(string);
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
            LoaderHandler.registerCodebaseLoader(uRLClassLoader);
            Thread.currentThread().setContextClassLoader(uRLClassLoader);
            final int n = stringArray.length >= 1 ? Integer.parseInt(stringArray[0]) : 1099;
            try {
                registry = AccessController.doPrivileged(new PrivilegedExceptionAction<RegistryImpl>(){

                    @Override
                    public RegistryImpl run() throws RemoteException {
                        return new RegistryImpl(n);
                    }
                }, RegistryImpl.getAccessControlContext(n));
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (RemoteException)privilegedActionException.getException();
            }
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(Long.MAX_VALUE);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println(MessageFormat.format(RegistryImpl.getTextResource("rmiregistry.port.badnumber"), stringArray[0]));
            System.err.println(MessageFormat.format(RegistryImpl.getTextResource("rmiregistry.usage"), "rmiregistry"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(1);
    }

    private static AccessControlContext getAccessControlContext(int n) {
        PermissionCollection permissionCollection = AccessController.doPrivileged(new PrivilegedAction<PermissionCollection>(){

            @Override
            public PermissionCollection run() {
                CodeSource codeSource = new CodeSource(null, (Certificate[])null);
                Policy policy = Policy.getPolicy();
                if (policy != null) {
                    return policy.getPermissions(codeSource);
                }
                return new Permissions();
            }
        });
        permissionCollection.add(new SocketPermission("*", "connect,accept"));
        permissionCollection.add(new SocketPermission("localhost:" + n, "listen,accept"));
        permissionCollection.add(new RuntimePermission("accessClassInPackage.sun.jvmstat.*"));
        permissionCollection.add(new RuntimePermission("accessClassInPackage.sun.jvm.hotspot.*"));
        permissionCollection.add(new FilePermission("<<ALL FILES>>", "read"));
        ProtectionDomain protectionDomain = new ProtectionDomain(new CodeSource(null, (Certificate[])null), permissionCollection);
        return new AccessControlContext(new ProtectionDomain[]{protectionDomain});
    }

    static {
        id = new ObjID(0);
        resources = null;
        registryFilter = AccessController.doPrivileged(RegistryImpl::initRegistryFilter);
    }
}

