/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.preferencespanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jd.gui.spi.PreferencesPanel;

public class MavenOrgSourceLoaderPreferencesProvider
extends JPanel
implements PreferencesPanel,
DocumentListener,
ActionListener {
    public static final String ACTIVATED = "MavenOrgSourceLoaderPreferencesProvider.activated";
    public static final String FILTERS = "MavenOrgSourceLoaderPreferencesProvider.filters";
    public static final String DEFAULT_FILTERS_VALUE = "+org +com.google +com.springsource +com.sun -com +java +javax +sun +sunw +spring +springframework +springmodules +tomcat +maven +edu";
    protected static final Pattern CONTROL_PATTERN = Pattern.compile("([+-][a-zA-Z_0-9$_.]+(\\s+[+-][a-zA-Z_0-9$_.]+)*)?\\s*");
    protected JCheckBox enableCheckBox;
    protected JTextArea filtersTextArea;
    protected JButton resetButton;
    protected Color errorBackgroundColor = Color.RED;
    protected Color defaultBackgroundColor;
    protected PreferencesPanel.PreferencesPanelChangeListener listener;

    public MavenOrgSourceLoaderPreferencesProvider() {
        super(new BorderLayout());
        this.enableCheckBox = new JCheckBox("Search source code on maven.org for:");
        this.enableCheckBox.addActionListener(this);
        this.filtersTextArea = new JTextArea();
        this.filtersTextArea.setFont(this.getFont());
        this.filtersTextArea.setLineWrap(true);
        this.filtersTextArea.getDocument().addDocumentListener(this);
        this.defaultBackgroundColor = this.filtersTextArea.getBackground();
        JComponent spacer = new JComponent(){};
        JScrollPane scrollPane = new JScrollPane(this.filtersTextArea);
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("windows")) {
            spacer.setPreferredSize(new Dimension(22, -1));
            scrollPane.setPreferredSize(new Dimension(-1, 50));
        } else if (osName.contains("mac os")) {
            spacer.setPreferredSize(new Dimension(28, -1));
            scrollPane.setPreferredSize(new Dimension(-1, 56));
        } else {
            spacer.setPreferredSize(new Dimension(22, -1));
            scrollPane.setPreferredSize(new Dimension(-1, 56));
        }
        this.resetButton = new JButton("Reset");
        this.resetButton.addActionListener(this);
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)this.resetButton, "East");
        this.add((Component)this.enableCheckBox, "North");
        this.add((Component)spacer, "West");
        this.add((Component)scrollPane, "Center");
        this.add((Component)southPanel, "South");
    }

    @Override
    public String getPreferencesGroupTitle() {
        return "Source loader";
    }

    @Override
    public String getPreferencesPanelTitle() {
        return "maven.org";
    }

    @Override
    public JComponent getPanel() {
        return this;
    }

    @Override
    public void init(Color errorBackgroundColor) {
        this.errorBackgroundColor = errorBackgroundColor;
    }

    @Override
    public boolean isActivated() {
        return true;
    }

    @Override
    public void loadPreferences(Map<String, String> preferences) {
        boolean enabled = !"false".equals(preferences.get(ACTIVATED));
        this.enableCheckBox.setSelected(enabled);
        this.filtersTextArea.setEnabled(enabled);
        this.resetButton.setEnabled(enabled);
        String filters = preferences.get(FILTERS);
        this.filtersTextArea.setText(filters == null || filters.isEmpty() ? DEFAULT_FILTERS_VALUE : filters);
    }

    @Override
    public void savePreferences(Map<String, String> preferences) {
        preferences.put(ACTIVATED, Boolean.toString(this.enableCheckBox.isSelected()));
        preferences.put(FILTERS, this.filtersTextArea.getText().trim());
    }

    @Override
    public boolean arePreferencesValid() {
        return CONTROL_PATTERN.matcher(this.filtersTextArea.getText()).matches();
    }

    @Override
    public void addPreferencesChangeListener(PreferencesPanel.PreferencesPanelChangeListener listener) {
        this.listener = listener;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.onTextChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.onTextChange();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.onTextChange();
    }

    protected void onTextChange() {
        this.filtersTextArea.setBackground(this.arePreferencesValid() ? this.defaultBackgroundColor : this.errorBackgroundColor);
        if (this.listener != null) {
            this.listener.preferencesPanelChanged(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.enableCheckBox) {
            boolean enabled = this.enableCheckBox.isSelected();
            this.filtersTextArea.setEnabled(enabled);
            this.resetButton.setEnabled(enabled);
        } else {
            this.filtersTextArea.setText(DEFAULT_FILTERS_VALUE);
            this.filtersTextArea.requestFocus();
        }
    }
}

