/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal.modulemap;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.gradle.api.UncheckedIOException;
import org.gradle.util.internal.CollectionUtils;

public class GenerateModuleMapFile {
    public static void generateFile(File moduleMapFile, String moduleName, List<String> publicHeaderDirs) {
        String firstLine = "module " + moduleName + " {";
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(firstLine);
        List validHeaderDirs = CollectionUtils.filter(publicHeaderDirs, path -> new File((String)path).exists());
        lines.addAll(CollectionUtils.collect((Iterable)validHeaderDirs, path -> "\tumbrella \"" + path + "\""));
        lines.add("\texport *");
        lines.add("}");
        try {
            Files.createParentDirs((File)moduleMapFile);
            FileUtils.writeLines((File)moduleMapFile, lines);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not generate a module map for " + moduleName, (Throwable)e);
        }
    }
}

